use Test;

use lib './lib';
use lib '.';

use Lingua::NumericWordForms::Roles::Ukrainian::WordedNumberSpec;
use Lingua::NumericWordForms::Actions::Ukrainian::WordedNumberSpec;

grammar ParseObj
        does Lingua::NumericWordForms::Roles::Ukrainian::WordedNumberSpec {
    rule TOP { <numeric-word-form>  }
};

sub parse-func(Str:D $spec) {
    ParseObj.parse(
            $spec.lc,
            rule => 'numeric-word-form',
            actions => Lingua::NumericWordForms::Actions::Ukrainian::WordedNumberSpec.new).made,
}

plan 42;

#-----------------------------------------------------------
# Worded number specifications parsing
#-----------------------------------------------------------
# The tests below are generated with the following Mathematica code:
#SeedRandom[39902];
#testLanguage = "Ukrainian";
#k = 6;
#lsTestNumbers =
#  Union[Join @@
#    Map[RandomInteger[#, k] &, {{0, 19}, {20, 100}, {101,
#       1000}, {1001, 10000}, {10001, 10^6}, {10^6, 10^9}, {10^9,
#       10^12}}]];
#Length[lsTestNumbers]
#
#lsSentences =
#  Map[IntegerName[#, {"Ukrainian", "Words"}] &, lsTestNumbers];
#Shallow[lsSentences]
#
#StringRiffle[
# MapThread[
#  "## " <> #3 <> "\n" <> "is parse-func('" <> #1 <> "'), " <> #2 <>
#    ",\n'" <> #1 <> "';" &, {lsSentences, ToString /@ lsTestNumbers,
#   ToString /@ Range[Length[lsTestNumbers]]}], "\n\n"]

## 1
is parse-func('нуль'), 0,
        'нуль';

## 2
is parse-func('три'), 3,
        'три';

## 3
is parse-func('чотири'), 4,
        'чотири';

## 4
is parse-func('девʼять'), 9,
        'девʼять';

## 5
is parse-func('вісімнадцять'), 18,
        'вісімнадцять';

## 6
is parse-func('девʼятнадцять'), 19,
        'девʼятнадцять';

## 7
is parse-func('двадцять один'), 21,
        'двадцять один';

## 8
is parse-func('двадцять девʼять'), 29,
        'двадцять девʼять';

## 9
is parse-func('пʼятдесят шість'), 56,
        'пʼятдесят шість';

## 10
is parse-func('сімдесят шість'), 76,
        'сімдесят шість';

## 11
is parse-func('вісімдесят пʼять'), 85,
        'вісімдесят пʼять';

## 12
is parse-func('девʼяносто сім'), 97,
        'девʼяносто сім';

## 13
is parse-func('сто шістдесят три'), 163,
        'сто шістдесят три';

## 14
is parse-func('сто шістдесят вісім'), 168,
        'сто шістдесят вісім';

## 15
is parse-func('двісті чотири'), 204,
        'двісті чотири';

## 16
is parse-func('двісті шістдесят'), 260,
        'двісті шістдесят';

## 17
is parse-func('чотириста двадцять сім'), 427,
        'чотириста двадцять сім';

## 18
is parse-func('вісімсот чотири'), 804,
        'вісімсот чотири';

## 19
is parse-func('дві тисячі сімдесят два'), 2072,
        'дві тисячі сімдесят два';

## 20
is parse-func('дві тисячі двісті двадцять вісім'), 2228,
        'дві тисячі двісті двадцять вісім';

## 21
is parse-func('пʼять тисяч пʼятсот двадцять вісім'), 5528,
        'пʼять тисяч пʼятсот двадцять вісім';

## 22
is parse-func('пʼять тисяч вісімсот пʼятдесят'), 5850,
        'пʼять тисяч вісімсот пʼятдесят';

## 23
is parse-func('шість тисяч пʼятсот вісім'), 6508,
        'шість тисяч пʼятсот вісім';

## 24
is parse-func('сім тисяч чотириста дванадцять'), 7412,
        'сім тисяч чотириста дванадцять';

## 25
is parse-func('двісті сорок пʼять тисяч триста двадцять чотири'), 245324,
        'двісті сорок пʼять тисяч триста двадцять чотири';

## 26
is parse-func('шістсот пʼятнадцять тисяч двісті девʼяносто вісім'), 615298,
        'шістсот пʼятнадцять тисяч двісті девʼяносто вісім';

## 27
is parse-func('сімсот тридцять одна тисяча сто шість'), 731106,
        'сімсот тридцять одна тисяча сто шість';

## 28
is parse-func('вісімсот двадцять три тисячі вісімсот двадцять чотири'), 823824,
        'вісімсот двадцять три тисячі вісімсот двадцять чотири';

## 29
is parse-func('вісімсот девʼяносто одна тисяча вісімсот сімдесят один'), 891871,
        'вісімсот девʼяносто одна тисяча вісімсот сімдесят один';

## 30
is parse-func('девʼятсот сорок одна тисяча пʼятсот шість'), 941506,
        'девʼятсот сорок одна тисяча пʼятсот шість';

## 31
is parse-func('пʼятдесят пʼять мільйонів триста девʼяносто тисяч пʼятсот двадцять сім'), 55390527,
        'пʼятдесят пʼять мільйонів триста девʼяносто тисяч пʼятсот двадцять сім';

## 32
is parse-func('сімдесят шість мільйонів сімсот двадцять чотири тисячі чотириста тридцять шість'), 76724436,
        'сімдесят шість мільйонів сімсот двадцять чотири тисячі чотириста тридцять шість';

## 33
is parse-func('двісті сорок сім мільйонів пʼятсот сім тисяч вісімнадцять'), 247507018,
        'двісті сорок сім мільйонів пʼятсот сім тисяч вісімнадцять';

## 34
is parse-func('пʼятсот шістнадцять мільйонів сімсот пʼятдесят три тисячі триста сімдесят вісім'), 516753378,
        'пʼятсот шістнадцять мільйонів сімсот пʼятдесят три тисячі триста сімдесят вісім';

## 35
is parse-func('вісімсот сорок два мільйони сімсот чотири тисячі сімсот вісімдесят три'), 842704783,
        'вісімсот сорок два мільйони сімсот чотири тисячі сімсот вісімдесят три';

## 36
is parse-func('девʼятсот вісімдесят вісім мільйонів девʼятсот шістдесят одна тисяча триста двадцять чотири'), 988961324,
        'девʼятсот вісімдесят вісім мільйонів девʼятсот шістдесят одна тисяча триста двадцять чотири';

## 37
is
        parse-func('пʼятсот вісімдесят сім мільярдів сімсот двадцять сім мільйонів двісті тридцять тисяч сто девʼяносто девʼять'),
        587727230199,
        'пʼятсот вісімдесят сім мільярдів сімсот двадцять сім мільйонів двісті тридцять тисяч сто девʼяносто девʼять';

## 38
is
        parse-func('шістсот двадцять сім мільярдів пʼятсот вісімдесят мільйонів девʼятсот тридцять пʼять тисяч сімдесят два'),
        627580935072,
        'шістсот двадцять сім мільярдів пʼятсот вісімдесят мільйонів девʼятсот тридцять пʼять тисяч сімдесят два';

## 39
is parse-func('сімсот вісімдесят чотири мільярди шістсот тридцять мільйонів сімсот тридцять вісім тисяч сто двадцять'),
        784630738120,
        'сімсот вісімдесят чотири мільярди шістсот тридцять мільйонів сімсот тридцять вісім тисяч сто двадцять';

## 40
is
        parse-func('вісімсот чотири мільярди триста девʼяносто сім мільйонів чотириста шістнадцять тисяч сімсот тридцять шість'),
        804397416736,
        'вісімсот чотири мільярди триста девʼяносто сім мільйонів чотириста шістнадцять тисяч сімсот тридцять шість';

## 41
is
        parse-func('вісімсот шістдесят сім мільярдів пʼятсот шістдесят один мільйон триста вісімдесят тисяч чотириста чотирнадцять'),
        867561380414,
        'вісімсот шістдесят сім мільярдів пʼятсот шістдесят один мільйон триста вісімдесят тисяч чотириста чотирнадцять';

## 42
is
        parse-func('девʼятсот вісімдесят мільярдів сімсот тридцять шість мільйонів сто тридцять вісім тисяч вісімсот тридцять девʼять'),
        980736138839,
        'девʼятсот вісімдесят мільярдів сімсот тридцять шість мільйонів сто тридцять вісім тисяч вісімсот тридцять девʼять';

done-testing;