use 5.014002;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'DNS::LDNS',
    VERSION_FROM      => 'lib/DNS/LDNS.pm', # finds $VERSION
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/DNS/LDNS.pm', # retrieve abstract from module
       AUTHOR         => 'Erik Pihl Ostlyngen <erik.ostlyngen@uninett.no>') : ()),
    LIBS              => ['-lldns'],
    DEFINE            => '',
    INC               => '-I.',
	# Un-comment this if you add C files to link with later:
    # OBJECT            => '$(O_FILES)', # link all the C files too
);
if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = (qw(LDNS_AA LDNS_AD LDNS_CD LDNS_DEFAULT_EXP_TIME
                 LDNS_DEFAULT_TTL LDNS_DNSSEC_KEYPROTO LDNS_IP4ADDRLEN
		 LDNS_IP6ADDRLEN LDNS_KEY_REVOKE_KEY LDNS_KEY_SEP_KEY
		 LDNS_KEY_ZONE_KEY LDNS_MAX_DOMAINLEN LDNS_MAX_KEYLEN
                 LDNS_MAX_LABELLEN LDNS_MAX_PACKETLEN LDNS_MAX_POINTERS 
                 LDNS_MAX_RDFLEN LDNS_NSEC3_MAX_ITERATIONS
		 LDNS_NSEC3_VARS_OPTOUT_MASK LDNS_PORT LDNS_QR LDNS_RA LDNS_RD
		 LDNS_RDATA_FIELD_DESCRIPTORS_COMMON LDNS_RDF_SIZE_16BYTES
		 LDNS_RDF_SIZE_6BYTES LDNS_RDF_SIZE_BYTE
		 LDNS_RDF_SIZE_DOUBLEWORD LDNS_RDF_SIZE_WORD LDNS_RESOLV_ANCHOR
		 LDNS_RESOLV_DEFDOMAIN LDNS_RESOLV_INET LDNS_RESOLV_INET6
		 LDNS_RESOLV_INETANY LDNS_RESOLV_KEYWORD LDNS_RESOLV_KEYWORDS
		 LDNS_RESOLV_NAMESERVER LDNS_RESOLV_OPTIONS LDNS_RESOLV_RTT_INF
		 LDNS_RESOLV_RTT_MIN LDNS_RESOLV_SEARCH LDNS_RESOLV_SORTLIST
		 LDNS_RR_OVERHEAD LDNS_SIGNATURE_LEAVE_ADD_NEW
                 LDNS_SIGNATURE_LEAVE_NO_ADD LDNS_SIGNATURE_REMOVE_ADD_NEW
                 LDNS_SIGNATURE_REMOVE_NO_ADD LDNS_TC),
              {name=>"LDNS_CERT_ACPKIX", macro=>"1"},
              {name=>"LDNS_CERT_IACPKIX", macro=>"1"},
              {name=>"LDNS_CERT_IPGP", macro=>"1"},
              {name=>"LDNS_CERT_IPKIX", macro=>"1"},
              {name=>"LDNS_CERT_ISPKI", macro=>"1"},
              {name=>"LDNS_CERT_OID", macro=>"1"},
              {name=>"LDNS_CERT_PGP", macro=>"1"},
              {name=>"LDNS_CERT_PKIX", macro=>"1"},
              {name=>"LDNS_CERT_SPKI", macro=>"1"},
              {name=>"LDNS_CERT_URI", macro=>"1"},
              {name=>"LDNS_DH", macro=>"1"},
              {name=>"LDNS_DSA", macro=>"1"},
              {name=>"LDNS_DSA_NSEC3", macro=>"1"},
              {name=>"LDNS_ECC", macro=>"1"},
              {name=>"LDNS_ECC_GOST", macro=>"1"},
              {name=>"LDNS_HASH_GOST", macro=>"1"},
              {name=>"LDNS_PACKET_ANSWER", macro=>"1"},
              {name=>"LDNS_PACKET_IQUERY", macro=>"1"},
              {name=>"LDNS_PACKET_NODATA", macro=>"1"},
              {name=>"LDNS_PACKET_NOTIFY", macro=>"1"},
              {name=>"LDNS_PACKET_NXDOMAIN", macro=>"1"},
              {name=>"LDNS_PACKET_QUERY", macro=>"1"},
              {name=>"LDNS_PACKET_QUESTION", macro=>"1"},
              {name=>"LDNS_PACKET_REFERRAL", macro=>"1"},
              {name=>"LDNS_PACKET_STATUS", macro=>"1"},
              {name=>"LDNS_PACKET_UNKNOWN", macro=>"1"},
              {name=>"LDNS_PACKET_UPDATE", macro=>"1"},
              {name=>"LDNS_PRIVATEDNS", macro=>"1"},
              {name=>"LDNS_PRIVATEOID", macro=>"1"},
              {name=>"LDNS_RCODE_FORMERR", macro=>"1"},
              {name=>"LDNS_RCODE_NOERROR", macro=>"1"},
              {name=>"LDNS_RCODE_NOTAUTH", macro=>"1"},
              {name=>"LDNS_RCODE_NOTIMPL", macro=>"1"},
              {name=>"LDNS_RCODE_NOTZONE", macro=>"1"},
              {name=>"LDNS_RCODE_NXDOMAIN", macro=>"1"},
              {name=>"LDNS_RCODE_NXRRSET", macro=>"1"},
              {name=>"LDNS_RCODE_REFUSED", macro=>"1"},
              {name=>"LDNS_RCODE_SERVFAIL", macro=>"1"},
              {name=>"LDNS_RCODE_YXDOMAIN", macro=>"1"},
              {name=>"LDNS_RCODE_YXRRSET", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_A", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_AAAA", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_ALG", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_APL", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_ATMA", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_B32_EXT", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_B64", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_CERT_ALG", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_CLASS", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_DNAME", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_HEX", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_INT16", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_INT16_DATA", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_INT32", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_INT8", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_IPSECKEY", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_LOC", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_NONE", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_NSAP", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_NSEC", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_NSEC3_NEXT_OWNER", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_NSEC3_SALT", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_PERIOD", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_SERVICE", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_STR", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_TIME", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_HIP", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_TSIGTIME", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_TYPE", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_UNKNOWN", macro=>"1"},
              {name=>"LDNS_RDF_TYPE_WKS", macro=>"1"},
              {name=>"LDNS_RR_CLASS_ANY", macro=>"1"},
              {name=>"LDNS_RR_CLASS_CH", macro=>"1"},
              {name=>"LDNS_RR_CLASS_COUNT", macro=>"1"},
              {name=>"LDNS_RR_CLASS_FIRST", macro=>"1"},
              {name=>"LDNS_RR_CLASS_HS", macro=>"1"},
              {name=>"LDNS_RR_CLASS_IN", macro=>"1"},
              {name=>"LDNS_RR_CLASS_LAST", macro=>"1"},
              {name=>"LDNS_RR_CLASS_NONE", macro=>"1"},
              {name=>"LDNS_RR_COMPRESS", macro=>"1"},
              {name=>"LDNS_RR_NO_COMPRESS", macro=>"1"},
              {name=>"LDNS_RR_TYPE_A", macro=>"1"},
              {name=>"LDNS_RR_TYPE_A6", macro=>"1"},
              {name=>"LDNS_RR_TYPE_AAAA", macro=>"1"},
              {name=>"LDNS_RR_TYPE_AFSDB", macro=>"1"},
              {name=>"LDNS_RR_TYPE_ANY", macro=>"1"},
              {name=>"LDNS_RR_TYPE_APL", macro=>"1"},
              {name=>"LDNS_RR_TYPE_ATMA", macro=>"1"},
              {name=>"LDNS_RR_TYPE_AXFR", macro=>"1"},
              {name=>"LDNS_RR_TYPE_CERT", macro=>"1"},
              {name=>"LDNS_RR_TYPE_CNAME", macro=>"1"},
              {name=>"LDNS_RR_TYPE_COUNT", macro=>"1"},
              {name=>"LDNS_RR_TYPE_DHCID", macro=>"1"},
              {name=>"LDNS_RR_TYPE_DLV", macro=>"1"},
              {name=>"LDNS_RR_TYPE_DNAME", macro=>"1"},
              {name=>"LDNS_RR_TYPE_DNSKEY", macro=>"1"},
              {name=>"LDNS_RR_TYPE_DS", macro=>"1"},
              {name=>"LDNS_RR_TYPE_EID", macro=>"1"},
              {name=>"LDNS_RR_TYPE_FIRST", macro=>"1"},
              {name=>"LDNS_RR_TYPE_GID", macro=>"1"},
              {name=>"LDNS_RR_TYPE_GPOS", macro=>"1"},
              {name=>"LDNS_RR_TYPE_HINFO", macro=>"1"},
              {name=>"LDNS_RR_TYPE_IPSECKEY", macro=>"1"},
              {name=>"LDNS_RR_TYPE_ISDN", macro=>"1"},
              {name=>"LDNS_RR_TYPE_IXFR", macro=>"1"},
              {name=>"LDNS_RR_TYPE_KEY", macro=>"1"},
              {name=>"LDNS_RR_TYPE_KX", macro=>"1"},
              {name=>"LDNS_RR_TYPE_LAST", macro=>"1"},
              {name=>"LDNS_RR_TYPE_LOC", macro=>"1"},
              {name=>"LDNS_RR_TYPE_MAILA", macro=>"1"},
              {name=>"LDNS_RR_TYPE_MAILB", macro=>"1"},
              {name=>"LDNS_RR_TYPE_MB", macro=>"1"},
              {name=>"LDNS_RR_TYPE_MD", macro=>"1"},
              {name=>"LDNS_RR_TYPE_MF", macro=>"1"},
              {name=>"LDNS_RR_TYPE_MG", macro=>"1"},
              {name=>"LDNS_RR_TYPE_MINFO", macro=>"1"},
              {name=>"LDNS_RR_TYPE_MR", macro=>"1"},
              {name=>"LDNS_RR_TYPE_MX", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NAPTR", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NIMLOC", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NS", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NSAP", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NSAP_PTR", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NSEC", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NSEC3", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NSEC3PARAM", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NSEC3PARAMS", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NULL", macro=>"1"},
              {name=>"LDNS_RR_TYPE_NXT", macro=>"1"},
              {name=>"LDNS_RR_TYPE_OPT", macro=>"1"},
              {name=>"LDNS_RR_TYPE_PTR", macro=>"1"},
              {name=>"LDNS_RR_TYPE_PX", macro=>"1"},
              {name=>"LDNS_RR_TYPE_RP", macro=>"1"},
              {name=>"LDNS_RR_TYPE_RRSIG", macro=>"1"},
              {name=>"LDNS_RR_TYPE_RT", macro=>"1"},
              {name=>"LDNS_RR_TYPE_SIG", macro=>"1"},
              {name=>"LDNS_RR_TYPE_SINK", macro=>"1"},
              {name=>"LDNS_RR_TYPE_SOA", macro=>"1"},
              {name=>"LDNS_RR_TYPE_SPF", macro=>"1"},
              {name=>"LDNS_RR_TYPE_SRV", macro=>"1"},
              {name=>"LDNS_RR_TYPE_SSHFP", macro=>"1"},
              {name=>"LDNS_RR_TYPE_TALINK", macro=>"1"},
              {name=>"LDNS_RR_TYPE_TSIG", macro=>"1"},
              {name=>"LDNS_RR_TYPE_TXT", macro=>"1"},
              {name=>"LDNS_RR_TYPE_UID", macro=>"1"},
              {name=>"LDNS_RR_TYPE_UINFO", macro=>"1"},
              {name=>"LDNS_RR_TYPE_UNSPEC", macro=>"1"},
              {name=>"LDNS_RR_TYPE_WKS", macro=>"1"},
              {name=>"LDNS_RR_TYPE_X25", macro=>"1"},
              {name=>"LDNS_RSAMD5", macro=>"1"},
              {name=>"LDNS_RSASHA1", macro=>"1"},
              {name=>"LDNS_RSASHA1_NSEC3", macro=>"1"},
              {name=>"LDNS_RSASHA256", macro=>"1"},
              {name=>"LDNS_RSASHA512", macro=>"1"},
              {name=>"LDNS_SECTION_ADDITIONAL", macro=>"1"},
              {name=>"LDNS_SECTION_ANSWER", macro=>"1"},
              {name=>"LDNS_SECTION_ANY", macro=>"1"},
              {name=>"LDNS_SECTION_ANY_NOQUESTION", macro=>"1"},
              {name=>"LDNS_SECTION_AUTHORITY", macro=>"1"},
              {name=>"LDNS_SECTION_QUESTION", macro=>"1"},
              {name=>"LDNS_SHA1", macro=>"1"},
              {name=>"LDNS_SHA256", macro=>"1"},
              {name=>"LDNS_SIGN_DSA", macro=>"1"},
              {name=>"LDNS_SIGN_DSA_NSEC3", macro=>"1"},
              {name=>"LDNS_SIGN_ECC_GOST", macro=>"1"},
              {name=>"LDNS_SIGN_HMACSHA1", macro=>"1"},
              {name=>"LDNS_SIGN_HMACSHA256", macro=>"1"},
              {name=>"LDNS_SIGN_RSAMD5", macro=>"1"},
              {name=>"LDNS_SIGN_RSASHA1", macro=>"1"},
              {name=>"LDNS_SIGN_RSASHA1_NSEC3", macro=>"1"},
              {name=>"LDNS_SIGN_RSASHA256", macro=>"1"},
              {name=>"LDNS_SIGN_RSASHA512", macro=>"1"},
              {name=>"LDNS_STATUS_ADDRESS_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_CERT_BAD_ALGORITHM", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_ALGO_NOT_IMPL", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_BOGUS", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_EXPIRATION_BEFORE_INCEPTION", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_NO_DNSKEY", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_NO_DS", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_NO_MATCHING_KEYTAG_DNSKEY", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_NO_RRSIG", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_NO_TRUSTED_DNSKEY", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_NO_TRUSTED_DS", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_SIG_EXPIRED", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_SIG_NOT_INCEPTED", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_TSIG_BOGUS", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_TSIG_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_TYPE_COVERED_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_UNKNOWN_ALGO", macro=>"1"},
              {name=>"LDNS_STATUS_CRYPTO_VALIDATED", macro=>"1"},
              {name=>"LDNS_STATUS_DDD_OVERFLOW", macro=>"1"},
              {name=>"LDNS_STATUS_DNSSEC_EXISTENCE_DENIED", macro=>"1"},
              {name=>"LDNS_STATUS_DNSSEC_NSEC3_ORIGINAL_NOT_FOUND", macro=>"1"},
              {name=>"LDNS_STATUS_DNSSEC_NSEC_RR_NOT_COVERED", macro=>"1"},
              {name=>"LDNS_STATUS_DNSSEC_NSEC_WILDCARD_NOT_COVERED", macro=>"1"},
              {name=>"LDNS_STATUS_DOMAINNAME_OVERFLOW", macro=>"1"},
              {name=>"LDNS_STATUS_DOMAINNAME_UNDERFLOW", macro=>"1"},
              {name=>"LDNS_STATUS_EMPTY_LABEL", macro=>"1"},
              {name=>"LDNS_STATUS_ENGINE_KEY_NOT_LOADED", macro=>"1"},
              {name=>"LDNS_STATUS_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_FILE_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_INTERNAL_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_INVALID_B32_EXT", macro=>"1"},
              {name=>"LDNS_STATUS_INVALID_B64", macro=>"1"},
              {name=>"LDNS_STATUS_INVALID_HEX", macro=>"1"},
              {name=>"LDNS_STATUS_INVALID_INT", macro=>"1"},
              {name=>"LDNS_STATUS_INVALID_IP4", macro=>"1"},
              {name=>"LDNS_STATUS_INVALID_IP6", macro=>"1"},
              {name=>"LDNS_STATUS_INVALID_POINTER", macro=>"1"},
              {name=>"LDNS_STATUS_INVALID_STR", macro=>"1"},
              {name=>"LDNS_STATUS_INVALID_TIME", macro=>"1"},
              {name=>"LDNS_STATUS_LABEL_OVERFLOW", macro=>"1"},
              {name=>"LDNS_STATUS_MEM_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_MISSING_RDATA_FIELDS_KEY", macro=>"1"},
              {name=>"LDNS_STATUS_MISSING_RDATA_FIELDS_RRSIG", macro=>"1"},
              {name=>"LDNS_STATUS_NETWORK_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_NOT_IMPL", macro=>"1"},
              {name=>"LDNS_STATUS_NO_DATA", macro=>"1"},
              {name=>"LDNS_STATUS_NSEC3_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_NULL", macro=>"1"},
              {name=>"LDNS_STATUS_OK", macro=>"1"},
              {name=>"LDNS_STATUS_PACKET_OVERFLOW", macro=>"1"},
              {name=>"LDNS_STATUS_RES_NO_NS", macro=>"1"},
              {name=>"LDNS_STATUS_RES_QUERY", macro=>"1"},
              {name=>"LDNS_STATUS_SOCKET_ERROR", macro=>"1"},
              {name=>"LDNS_STATUS_SSL_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_ALG_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_BAD_ESCAPE", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_CLASS_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_DNAME_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_EMPTY", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_INCLUDE", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_INCLUDE_ERR_NOTIMPL", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_INTEGER_OVERFLOW", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_ITERATIONS_OVERFLOW", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_KEYWORD_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_MISSING_VALUE_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_ORIGIN", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_RDATA_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_TTL", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_TTL_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_TYPE_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_SYNTAX_VERSION_ERR", macro=>"1"},
              {name=>"LDNS_STATUS_UNKNOWN_INET", macro=>"1"},
              {name=>"LDNS_STATUS_WIRE_INCOMPLETE_ADDITIONAL", macro=>"1"},
              {name=>"LDNS_STATUS_WIRE_INCOMPLETE_ANSWER", macro=>"1"},
              {name=>"LDNS_STATUS_WIRE_INCOMPLETE_AUTHORITY", macro=>"1"},
              {name=>"LDNS_STATUS_WIRE_INCOMPLETE_HEADER", macro=>"1"},
              {name=>"LDNS_STATUS_WIRE_INCOMPLETE_QUESTION", macro=>"1"});
  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'LDNS',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}
