package App::Manoc::DB::ResultSet::IPAddressInfo;
#ABSTRACT: ResultSet class for Ip

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::ResultSet';

use App::Manoc::DB::Search::Result::IPAddr;


sub manoc_search {
    my ( $self, $query, $result ) = @_;

    my $query_type = $query->query_type;
    my $pattern    = $query->sql_pattern;

    my $filter;

    if ( $query_type eq 'ipaddr' ) {
        $filter = { ipaddr => { '-like' => $pattern } };
    }
    elsif ( $query_type eq 'notes' ) {
        $filter = { notes => { '-like' => $pattern } };
    }
    elsif ( $query_type eq 'inventory' ) {
        $filter = { description => { '-like' => $pattern } };
    }
    else {
        return;
    }

    my $rs = $self->search( $filter, { order_by => 'ipaddr' } );

    while ( my $e = $rs->next ) {
        my $item = App::Manoc::DB::Search::Result::IPAddr->new(
            {
                match   => $e->ipaddr->address,
                address => $e->ipaddr,
            }
        );
        $result->add_item($item);
    }
}

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet::IPAddressInfo - ResultSet class for Ip

=head1 VERSION

version 2.99.4

=head1 METHODS

=head2 manoc_search( $query, $result)

Support for Manoc search feature

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
