/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.openqa.selenium.logging.CompositeLocalLogs;
import org.openqa.selenium.logging.HandlerBasedLocalLogs;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LoggingHandler;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.logging.StoringLocalLogs;

public abstract class LocalLogs
implements Logs {
    private static final LocalLogs NULL_LOGGER = new LocalLogs(){

        @Override
        public LogEntries get(String logType) {
            return new LogEntries(ImmutableList.of());
        }

        @Override
        public Set<String> getAvailableLogTypes() {
            return ImmutableSet.of();
        }

        @Override
        public void addEntry(String logType, LogEntry entry) {
        }
    };

    public static LocalLogs getNullLogger() {
        return NULL_LOGGER;
    }

    public static LocalLogs getStoringLoggerInstance(Set<String> logTypesToIgnore) {
        return new StoringLocalLogs(logTypesToIgnore);
    }

    public static LocalLogs getHandlerBasedLoggerInstance(LoggingHandler loggingHandler, Set<String> logTypesToInclude) {
        return new HandlerBasedLocalLogs(loggingHandler, logTypesToInclude);
    }

    public static LocalLogs getCombinedLogsHolder(LocalLogs predefinedTypeLogger, LocalLogs allTypesLogger) {
        return new CompositeLocalLogs(predefinedTypeLogger, allTypesLogger);
    }

    protected LocalLogs() {
    }

    @Override
    public abstract LogEntries get(String var1);

    public abstract void addEntry(String var1, LogEntry var2);
}

