use feature qw(say);
use lib './lib';
use Cron::Toolkit;

my $c = Cron::Toolkit->new(
    expression => "0 30 14 ? * 6-2 *",
    time_zone  => 'America/Chicago',
);
$c->time_zone('America/Chicago');

say $c->describe;
# 2:30 PM every day from Saturday to Tuesday of every month
# next occurence in epoch seconds
say $c->next;
# previous occurence in epoch seconds
say $c->previous;
# Question: when does February 29th next land on a Monday? 
say Cron::Toolkit->new(expression => "0 0 0 29 2 1 *")->next;
# Mon Feb 29 00:00:00 2044
# See exactly what was parsed
$c->dump_tree;
# ┌─ second: 0
# ├─ minute: 30
# ├─ hour:   14
# ├─ dom:    ?
# ├─ month:  *
# ├─ dow:    6-2 
# └─ year:   *
