package Microsoft::AdCenter::V7::ReportingService::KeywordPerformanceReportColumn;
# Copyright (C) 2012 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V7::ReportingService::KeywordPerformanceReportColumn - Represents "KeywordPerformanceReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountId
    AccountName
    AccountNumber
    AdDistribution
    AdGroupId
    AdGroupName
    AdId
    AdType
    AverageCpc
    AverageCpm
    AveragePosition
    BidMatchType
    CampaignId
    CampaignName
    Cashback
    Clicks
    ConversionRate
    Conversions
    CostPerConversion
    Ctr
    CurrencyCode
    CurrentMaxCpc
    DestinationUrl
    DeviceType
    HistoricKeywordRelevance
    HistoricLandingPageRelevance
    HistoricLandingPageUserExperience
    HistoricQualityScore
    Impressions
    Keyword
    KeywordId
    KeywordMatchTypeId
    KeywordRelevance
    LandingPageRelevance
    LandingPageUserExperience
    Language
    LanguageAndRegion
    MatchType
    PricingModel
    QualityScore
    Spend
    TimePeriod

=cut

sub AccountId {
    return 'AccountId';
}

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdDistribution {
    return 'AdDistribution';
}

sub AdGroupId {
    return 'AdGroupId';
}

sub AdGroupName {
    return 'AdGroupName';
}

sub AdId {
    return 'AdId';
}

sub AdType {
    return 'AdType';
}

sub AverageCpc {
    return 'AverageCpc';
}

sub AverageCpm {
    return 'AverageCpm';
}

sub AveragePosition {
    return 'AveragePosition';
}

sub BidMatchType {
    return 'BidMatchType';
}

sub CampaignId {
    return 'CampaignId';
}

sub CampaignName {
    return 'CampaignName';
}

sub Cashback {
    return 'Cashback';
}

sub Clicks {
    return 'Clicks';
}

sub ConversionRate {
    return 'ConversionRate';
}

sub Conversions {
    return 'Conversions';
}

sub CostPerConversion {
    return 'CostPerConversion';
}

sub Ctr {
    return 'Ctr';
}

sub CurrencyCode {
    return 'CurrencyCode';
}

sub CurrentMaxCpc {
    return 'CurrentMaxCpc';
}

sub DestinationUrl {
    return 'DestinationUrl';
}

sub DeviceType {
    return 'DeviceType';
}

sub HistoricKeywordRelevance {
    return 'HistoricKeywordRelevance';
}

sub HistoricLandingPageRelevance {
    return 'HistoricLandingPageRelevance';
}

sub HistoricLandingPageUserExperience {
    return 'HistoricLandingPageUserExperience';
}

sub HistoricQualityScore {
    return 'HistoricQualityScore';
}

sub Impressions {
    return 'Impressions';
}

sub Keyword {
    return 'Keyword';
}

sub KeywordId {
    return 'KeywordId';
}

sub KeywordMatchTypeId {
    return 'KeywordMatchTypeId';
}

sub KeywordRelevance {
    return 'KeywordRelevance';
}

sub LandingPageRelevance {
    return 'LandingPageRelevance';
}

sub LandingPageUserExperience {
    return 'LandingPageUserExperience';
}

sub Language {
    return 'Language';
}

sub LanguageAndRegion {
    return 'LanguageAndRegion';
}

sub MatchType {
    return 'MatchType';
}

sub PricingModel {
    return 'PricingModel';
}

sub QualityScore {
    return 'QualityScore';
}

sub Spend {
    return 'Spend';
}

sub TimePeriod {
    return 'TimePeriod';
}

1;
