package Dancer2::Plugin::FormValidator::Role::Validator;

use Moo::Role;
use Types::Standard qw(ConsumerOf);
use namespace::clean;

has extension => (
    is        => 'ro',
    isa       => ConsumerOf['Dancer2::Plugin::FormValidator::Role::Extension'],
    predicate => 1,
);

requires 'validate';
requires 'message';

sub stop_on_fail {
    return 0;
}

sub _field_defined_and_non_empty {
    if (
        exists $_[1]
        and defined $_[1]
        and $_[1] ne ''
    ){
        return 1;
    }

    return 0;
}

1;
