package Shipment::FedEx::WSDL::RateTypes::CurrencyExchangeRate;
$Shipment::FedEx::WSDL::RateTypes::CurrencyExchangeRate::VERSION = '2.03';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/rate/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %FromCurrency_of : ATTR(:get<FromCurrency>);
    my %IntoCurrency_of : ATTR(:get<IntoCurrency>);
    my %Rate_of : ATTR(:get<Rate>);

    __PACKAGE__->_factory(
        [   qw(        FromCurrency
              IntoCurrency
              Rate

              )
        ],
        {   'FromCurrency' => \%FromCurrency_of,
            'IntoCurrency' => \%IntoCurrency_of,
            'Rate'         => \%Rate_of,
        },
        {   'FromCurrency' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'IntoCurrency' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Rate'         => 'SOAP::WSDL::XSD::Typelib::Builtin::decimal',
        },
        {

            'FromCurrency' => 'FromCurrency',
            'IntoCurrency' => 'IntoCurrency',
            'Rate'         => 'Rate',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::RateTypes::CurrencyExchangeRate

=head1 VERSION

version 2.03

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CurrencyExchangeRate from the namespace http://fedex.com/ws/rate/v9.

Specifies the currency exchange performed on financial amounts for this rate.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * FromCurrency (min/maxOccurs: 0/1)

=item * IntoCurrency (min/maxOccurs: 0/1)

=item * Rate (min/maxOccurs: 0/1)

=back

=head1 NAME

Shipment::FedEx::WSDL::RateTypes::CurrencyExchangeRate

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::RateTypes::CurrencyExchangeRate
   FromCurrency =>  $some_value, # string
   IntoCurrency =>  $some_value, # string
   Rate =>  $some_value, # decimal
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
