package Shipment::UPS::WSDL::ShipTypes::EmailDetailsType;
$Shipment::UPS::WSDL::ShipTypes::EmailDetailsType::VERSION = '3.07';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.ups.com/XMLSchema/XOLTWS/Ship/v1.0' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %EMailAddress_of :ATTR(:get<EMailAddress>);
my %UndeliverableEMailAddress_of :ATTR(:get<UndeliverableEMailAddress>);
my %FromEMailAddress_of :ATTR(:get<FromEMailAddress>);
my %FromName_of :ATTR(:get<FromName>);
my %Memo_of :ATTR(:get<Memo>);
my %Subject_of :ATTR(:get<Subject>);
my %SubjectCode_of :ATTR(:get<SubjectCode>);

__PACKAGE__->_factory(
    [ qw(        EMailAddress
        UndeliverableEMailAddress
        FromEMailAddress
        FromName
        Memo
        Subject
        SubjectCode

    ) ],
    {
        'EMailAddress' => \%EMailAddress_of,
        'UndeliverableEMailAddress' => \%UndeliverableEMailAddress_of,
        'FromEMailAddress' => \%FromEMailAddress_of,
        'FromName' => \%FromName_of,
        'Memo' => \%Memo_of,
        'Subject' => \%Subject_of,
        'SubjectCode' => \%SubjectCode_of,
    },
    {
        'EMailAddress' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'UndeliverableEMailAddress' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'FromEMailAddress' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'FromName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Memo' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Subject' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'SubjectCode' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'EMailAddress' => 'EMailAddress',
        'UndeliverableEMailAddress' => 'UndeliverableEMailAddress',
        'FromEMailAddress' => 'FromEMailAddress',
        'FromName' => 'FromName',
        'Memo' => 'Memo',
        'Subject' => 'Subject',
        'SubjectCode' => 'SubjectCode',
    }
);

} # end BLOCK







1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::ShipTypes::EmailDetailsType

=head1 VERSION

version 3.07

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
EmailDetailsType from the namespace http://www.ups.com/XMLSchema/XOLTWS/Ship/v1.0.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * EMailAddress (min/maxOccurs: 1/unbounded)

=item * UndeliverableEMailAddress (min/maxOccurs: 0/1)

=item * FromEMailAddress (min/maxOccurs: 0/1)

=item * FromName (min/maxOccurs: 0/1)

=item * Memo (min/maxOccurs: 0/1)

=item * Subject (min/maxOccurs: 0/1)

=item * SubjectCode (min/maxOccurs: 0/1)

=back

=head1 NAME

Shipment::UPS::WSDL::ShipTypes::EmailDetailsType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::ShipTypes::EmailDetailsType
   EMailAddress =>  $some_value, # string
   UndeliverableEMailAddress =>  $some_value, # string
   FromEMailAddress =>  $some_value, # string
   FromName =>  $some_value, # string
   Memo =>  $some_value, # string
   Subject =>  $some_value, # string
   SubjectCode =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
