use strict;
use warnings;

use Amazon::API::Botocore qw(paginator);
use Amazon::API::Route53;
use Amazon::Credentials;
use Data::Dumper;
use English qw(-no_match_vars);
use Term::ANSIColor;
use Text::ASCIITable;

use constant {
  PRIVATE => [ colored( 'private', 'red' ),   'private' ],
  PUBLIC  => [ colored( 'public',  'green' ), 'public' ],
};

########################################################################
sub zone_type {
########################################################################
  my ( $zone_record, $pager ) = @_;

  $pager = $pager ? 1 : 0;

  my $private_zone = $zone_record->{Config}->{PrivateZone};

  return $private_zone ? PRIVATE->[$pager] : PUBLIC->[$pager];
}

########################################################################
sub init_pager {
########################################################################
  my ($use_pager) = @_;

  return 0
    if !$use_pager;

  my $token = eval {
    require IO::Pager;

    IO::Pager::open( *STDOUT, '|-:utf8', 'Unbuffered' );
  };

  return $token;
}

########################################################################
# MAIN SCRIPT STARTS HERE
########################################################################

my $credentials = Amazon::Credentials->new( no_passkey_warning => 1 );

my $rt53 = Amazon::API::Route53->new( credentials => $credentials );

my $use_pager = init_pager( defined $ENV{PAGER} );

my $t = Text::ASCIITable->new(
  { allowANSI   => !$use_pager,
    headingText => 'Hosted Zones'
  }
);

$t->setCols( 'Name', 'Record Count', 'Zone Id', 'Comment', 'Type' );

my $result = paginator(
  service    => $rt53,
  api        => 'ListHostedZones',
  parameters => {},
);

for ( sort { $a->{Name} cmp $b->{Name} } @{$result} ) {

  $t->addRow(
    @{$_}{qw(Name ResourceRecordSetCount Id)},
    $_->{Config}->{Comment},
    zone_type( $_, $use_pager ),
  );
}

print {*STDOUT} $t;

1;
