#!/usr/bin/perl -w -I ../../../lib

use 5.018;

use strict;

use Carp;

{ package Audio::Signal::Tone::Pluck;

  use Moose;
  
  extends 'Audio::Signal::Tone';

  has 'sustain' => (
    is => 'rw',
    isa => 'Num',
    trigger => sub {
      my ($self,$val,$old) = @_;
      if($val < 0 || $val > 8092) {
        warn "Regrettably, sustain parameter for pluck synth ${$self->position} is out of generous range.";
      }
    },
  );

  has 'tone1' => (
    is => 'rw',
    isa => 'Num',
    trigger => sub {
      my ($self,$val,$old) = @_;
      if($val < 0 || $val > 8092) {
        warn "Regrettably, sustain parameter for pluck synth ${$self->position} is out of generous range.";
      }
    },
  );

  has 'tone2' => (
    is => 'rw',
    isa => 'Num',
    trigger => sub {
      my ($self,$val,$old) = @_;
      if($val < 0 || $val > 8092) {
        warn "Regrettably, sustain parameter for pluck synth ${$self->position} is out of generous range.";
      }
    },
  );
  
  sub gencmd {
    my $self = shift;
    my $ret = sprintf("%s %s %s %s %s",$self->fm,$self->note,$self->sustain,$self->tone1,$self->tone2);
    return($ret);
  }
}

1;
