package Google::Ads::AdWords::v201206::ConversionOptimizerBiddingTransition;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201206' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201206::BiddingTransition);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %targetBiddingStrategy_of :ATTR(:get<targetBiddingStrategy>);
my %BiddingTransition__Type_of :ATTR(:get<BiddingTransition__Type>);
my %useSavedBids_of :ATTR(:get<useSavedBids>);

__PACKAGE__->_factory(
    [ qw(        targetBiddingStrategy
        BiddingTransition__Type
        useSavedBids

    ) ],
    {
        'targetBiddingStrategy' => \%targetBiddingStrategy_of,
        'BiddingTransition__Type' => \%BiddingTransition__Type_of,
        'useSavedBids' => \%useSavedBids_of,
    },
    {
        'targetBiddingStrategy' => 'Google::Ads::AdWords::v201206::BiddingStrategy',
        'BiddingTransition__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'useSavedBids' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'targetBiddingStrategy' => 'targetBiddingStrategy',
        'BiddingTransition__Type' => 'BiddingTransition.Type',
        'useSavedBids' => 'useSavedBids',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201206::ConversionOptimizerBiddingTransition

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ConversionOptimizerBiddingTransition from the namespace https://adwords.google.com/api/adwords/cm/v201206.

Used to switch a campaign's bidding strategy to conversion optimizer. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * useSavedBids




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201206::ConversionOptimizerBiddingTransition
   useSavedBids =>  $some_value, # boolean
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

