package Google::Ads::AdWords::v201209::InAppLinkExtension;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201209' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201209::AdExtension);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %id_of :ATTR(:get<id>);
my %AdExtension__Type_of :ATTR(:get<AdExtension__Type>);
my %inAppLinkText_of :ATTR(:get<inAppLinkText>);
my %inAppLinkUrl_of :ATTR(:get<inAppLinkUrl>);
my %appStore_of :ATTR(:get<appStore>);
my %appId_of :ATTR(:get<appId>);

__PACKAGE__->_factory(
    [ qw(        id
        AdExtension__Type
        inAppLinkText
        inAppLinkUrl
        appStore
        appId

    ) ],
    {
        'id' => \%id_of,
        'AdExtension__Type' => \%AdExtension__Type_of,
        'inAppLinkText' => \%inAppLinkText_of,
        'inAppLinkUrl' => \%inAppLinkUrl_of,
        'appStore' => \%appStore_of,
        'appId' => \%appId_of,
    },
    {
        'id' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'AdExtension__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inAppLinkText' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'inAppLinkUrl' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'appStore' => 'Google::Ads::AdWords::v201209::InAppLinkExtension::AppStore',
        'appId' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'id' => 'id',
        'AdExtension__Type' => 'AdExtension.Type',
        'inAppLinkText' => 'inAppLinkText',
        'inAppLinkUrl' => 'inAppLinkUrl',
        'appStore' => 'appStore',
        'appId' => 'appId',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201209::InAppLinkExtension

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
InAppLinkExtension from the namespace https://adwords.google.com/api/adwords/cm/v201209.

<p>This extension is useful for advertisers who wish to provide users with a link that points to the advertiser's mobile application in addition to their website. <p>It is also known as Mobile App Extension. <p>The API allows one InAppLinkExtension per {@code AppStore} per campaign. Only the extension for a given {@code AppStore} will render on the device relevant to that {@code AppStore} (e.g. iPhones for {@code AppStore.ITUNES} and Android phones for {@code AppStore.GOOGLE_PLAY}). <span class="constraint Beta">This is a beta feature.</span> 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * inAppLinkText


=item * inAppLinkUrl


=item * appStore


=item * appId




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201209::InAppLinkExtension
   inAppLinkText =>  $some_value, # string
   inAppLinkUrl =>  $some_value, # string
   appStore => $some_value, # InAppLinkExtension.AppStore
   appId =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

