package App::Manoc::DB::ResultSet::DeviceIface;
#ABSTRACT: ResultSet class for IfNotes
use strict;
use warnings;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use parent 'App::Manoc::DB::ResultSet';

use App::Manoc::DB::Search::Result::Iface;


sub search_unused {
    my ($self) = @_;

    my $conditions = { 'mat_entry.macaddr' => undef };

    my $rs = $self->search(
        $conditions,
        {
            alias => 'me',
            join  => 'mat_entry',
        }
    );
    return wantarray ? $rs->all : $rs;
}


sub search_uncabled {
    my ($self) = @_;

    my $conditions = { 'cabling.interface2_id' => undef };

    my $rs = $self->search(
        $conditions,
        {
            alias => 'me',
            join  => 'cabling',
        }
    );
    return wantarray ? $rs->all : $rs;
}


sub search_mat_last_activity {
    my ( $self, $device ) = @_;

    my $conditions = {};
    $device and $conditions->{'me.device_id'} = $device;

    my $rs = $self->search(
        $conditions,
        {
            alias    => 'me',
            group_by => [qw(me.device_id me.name)],
            select   => [ 'me.name', { max => 'mat_entry.lastseen' }, ],
            as       => [qw(interface lastseen)],
            join     => 'mat_entry',
        }
    );
    return wantarray ? $rs->all : $rs;
}


sub manoc_search {
    my ( $self, $query, $result ) = @_;

    my $type    = $query->query_type;
    my $pattern = $query->sql_pattern;

    return unless $type eq 'notes';

    my $filter;
    $type eq 'notes' and $filter = { notes => { '-like' => $pattern } };

    my $rs = $self->search(
        $filter,
        {
            order_by => '',
            prefetch => 'device',
        },
    );
    while ( my $e = $rs->next ) {
        my $item = App::Manoc::DB::Search::Result::Iface->new(
            {
                device    => $e->device,
                interface => $e->interface,
                text      => $e->description,
            }
        );
        $result->add_item($item);
    }
}

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet::DeviceIface - ResultSet class for IfNotes

=head1 VERSION

version 2.99.3

=head1 METHODS

=head2 search_unused

Return a resultset containing all interfaces which were never seen in
mac address table.

=head2 search_uncabled

Return a resultset containing all interfaces which are not in
the cabling matrix

=head2 search_mat_last_activity (  $device )

Return a resultset containing all interfaces of <$device> with their corresponding
maximum value of lastseen in Mat.

=head2 manoc_search(  $query, $result)

Support for Manoc search feature

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
