package App::Manoc::View::TT;

use strict;
use warnings;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use base 'Catalyst::View::TT';

use App::Manoc;

__PACKAGE__->config(
    TEMPLATE_EXTENSION => '.tt',
    INCLUDE_PATH       => [
        App::Manoc->path_to( 'root', 'src' ),
        App::Manoc->path_to( 'root', 'src', 'include' ),
        App::Manoc->path_to( 'root', 'src', 'pages' ),
    ],
    PRE_PROCESS => 'init.tt',
    WRAPPER     => 'wrapper.tt',
    PLUGIN_BASE => 'App::Manoc::View::TT::Plugin',
    render_die  => 1,
);


1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::View::TT

=head1 VERSION

version 2.99.3

=head1 DESCRIPTION

This is the Template Toolkit view for Manoc.

=head1 NAME

App::Manoc::View::TT - TT View for Manoc

=head1 SEE ALSO

L<App::Manoc>

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
