package App::Manoc::DB::Result::Session;

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->table('sessions');
__PACKAGE__->add_columns(
    'id' => {
        data_type   => 'varchar',
        is_nullable => 0,
        size        => 72,
    },
    'session_data' => { data_type => 'text', },
    'expires'      => {
        data_type => 'int',
        size      => 10,
    }
);

__PACKAGE__->set_primary_key(qw(id));


1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::Session

=head1 VERSION

version 2.99.4

=head1 DESCRIPTION

Needed for L<CGI::Session> L<CGI::Session::Driver::dbixc>

=head1 NAME

App::Manoc::DB::Result::Session - A model object representing a WEB UI session

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
