package App::Manoc::DB::Result::WinHostname;

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->load_components(
    qw/
        +App::Manoc::DB::Helper::Row::TupleArchive
        +App::Manoc::DB::InflateColumn::IPv4
        /
);

__PACKAGE__->table('win_hostname');

__PACKAGE__->add_columns(
    'name' => {
        data_type   => 'char',
        size        => 255,
        is_nullable => 0,
    },
    'ipaddr' => {
        data_type    => 'char',
        is_nullable  => 0,
        size         => 15,
        ipv4_address => 1
    },
);

__PACKAGE__->set_tuple_archive_columns(qw(name ipaddr));

__PACKAGE__->set_primary_key(qw(name ipaddr firstseen));

__PACKAGE__->resultset_class('App::Manoc::DB::ResultSet::WinHostname');


sub sqlt_deploy_hook {
    my ( $self, $sqlt_schema ) = @_;

    $sqlt_schema->add_index(
        name   => 'idx_winhostname_ipaddr',
        fields => ['ipaddr']
    );
}
1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::WinHostname

=head1 VERSION

version 2.99.4

=for Pod::Coverage sqlt_deploy_hook

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
