package SNMP::Insight::MIB::Bridge;

#ABSTRACT: Support for data in Bridge-MIB

use Moose::Role;

our $VERSION = '0.002';    #TRIAL VERSION:

use SNMP::Insight::Moose::MIB;

use namespace::autoclean;
with 'SNMP::Insight::MIB';

mib_oid "1.3.6.1.2.1.17";
mib_name "BRIDGE-MIB";

# .1 dot1dBase

has_scalar "dot1dBaseBridgeAddress" => (
    oid    => "1.1",
    munger => 'munge_macaddress',
);

has_scalar "dot1dBaseNumPorts" => ( oid => "1.2" );

has_table "dot1dBasePortTable" => (
    oid     => "1.4",
    index   => "dot1dBasePort",
    columns => {
        "dot1dBasePort"        => 1,
        "dot1dBasePortIfIndex" => 2
    }
);

has_scalar "dot1dStpProtocolSpecification" => ( oid => "2.1" );

# .4 dot1dTp

has_table "dot1dTpFdbEntry" => (
    oid     => "4.3",
    index   => "dot1dTpFdbAddress",
    columns => {
        "dot1dTpFdbAddress" => [ 1, 'munge_macaddress' ],
        "dot1dTpFdbPort"    => 2,
        "dot1dTpFdbStatus"  => 3,
    }
);

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

SNMP::Insight::MIB::Bridge - Support for data in Bridge-MIB

=head1 VERSION

version 0.002

=head1 AUTHOR

Gabriele Mambrini <g.mambrini@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
