######################################################################
#
# 5121_cp932x_by_utf8jp_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xF3\xB0\x84\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x40"],
        ["\x81\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x80"],

        ["\xF3\xB0\x84\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x41"],
        ["\x81\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x81"],

        ["\xF3\xB0\x84\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x42"],
        ["\x81\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x82"],

        ["\xF3\xB0\x84\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x43"],
        ["\x81\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x83"],

        ["\xF3\xB0\x84\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x44"],
        ["\x81\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x84"],

        ["\xF3\xB0\x84\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x45"],
        ["\x81\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x85"],

        ["\xF3\xB0\x84\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x46"],
        ["\x81\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x86"],

        ["\xF3\xB0\x84\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x47"],
        ["\x81\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x87"],

        ["\xF3\xB0\x84\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x48"],
        ["\x81\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x88"],

        ["\xF3\xB0\x84\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x49"],
        ["\x81\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x89"],

        ["\xF3\xB0\x84\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4A"],
        ["\x81\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8A"],

        ["\xF3\xB0\x84\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4B"],
        ["\x81\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8B"],

        ["\xF3\xB0\x84\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4C"],
        ["\x81\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8C"],

        ["\xF3\xB0\x84\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4D"],
        ["\x81\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8D"],

        ["\xF3\xB0\x84\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4E"],
        ["\x81\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8E"],

        ["\xF3\xB0\x84\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x4F"],
        ["\x81\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8F"],

        ["\xF3\xB0\x84\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x50"],
        ["\x81\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x90"],

        ["\xF3\xB0\x84\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x51"],
        ["\x81\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x91"],

        ["\xF3\xB0\x84\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x52"],
        ["\x81\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x92"],

        ["\xF3\xB0\x84\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x53"],
        ["\x81\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x93"],

        ["\xF3\xB0\x84\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x54"],
        ["\x81\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x94"],

        ["\xF3\xB0\x84\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x55"],
        ["\x81\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x95"],

        ["\xF3\xB0\x84\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x56"],
        ["\x81\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x96"],

        ["\xF3\xB0\x84\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x57"],
        ["\x81\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x97"],

        ["\xF3\xB0\x84\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x58"],
        ["\x81\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x98"],

        ["\xF3\xB0\x84\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x59"],
        ["\x81\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x99"],

        ["\xF3\xB0\x84\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5A"],
        ["\x81\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9A"],

        ["\xF3\xB0\x84\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5B"],
        ["\x81\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9B"],

        ["\xF3\xB0\x84\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5C"],
        ["\x81\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9C"],

        ["\xF3\xB0\x84\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5D"],
        ["\x81\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9D"],

        ["\xF3\xB0\x84\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5E"],
        ["\x81\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9E"],

        ["\xF3\xB0\x84\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x5F"],
        ["\x81\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9F"],

        ["\xF3\xB0\x84\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x60"],
        ["\x81\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA0"],

        ["\xF3\xB0\x84\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x61"],
        ["\x81\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA1"],

        ["\xF3\xB0\x84\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x62"],
        ["\x81\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA2"],

        ["\xF3\xB0\x84\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x63"],
        ["\x81\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA3"],

        ["\xF3\xB0\x84\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x64"],
        ["\x81\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA4"],

        ["\xF3\xB0\x84\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x65"],
        ["\x81\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA5"],

        ["\xF3\xB0\x84\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x66"],
        ["\x81\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA6"],

        ["\xF3\xB0\x84\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x67"],
        ["\x81\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA7"],

        ["\xF3\xB0\x84\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x68"],
        ["\x81\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA8"],

        ["\xF3\xB0\x84\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x69"],
        ["\x81\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA9"],

        ["\xF3\xB0\x84\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6A"],
        ["\x81\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAA"],

        ["\xF3\xB0\x84\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6B"],
        ["\x81\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAB"],

        ["\xF3\xB0\x84\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6C"],
        ["\x81\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAC"],

        ["\xF3\xB0\x84\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6D"],
        ["\x81\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAD"],

        ["\xF3\xB0\x84\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6E"],
        ["\x81\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAE"],

        ["\xF3\xB0\x84\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x6F"],
        ["\x81\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAF"],

        ["\xF3\xB0\x84\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x70"],
        ["\x81\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB0"],

        ["\xF3\xB0\x84\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x71"],
        ["\x81\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB1"],

        ["\xF3\xB0\x84\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x72"],
        ["\x81\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB2"],

        ["\xF3\xB0\x84\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x73"],
        ["\x81\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB3"],

        ["\xF3\xB0\x84\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x74"],
        ["\x81\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB4"],

        ["\xF3\xB0\x84\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x75"],
        ["\x81\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB5"],

        ["\xF3\xB0\x84\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x76"],
        ["\x81\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB6"],

        ["\xF3\xB0\x84\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x77"],
        ["\x81\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB7"],

        ["\xF3\xB0\x84\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x78"],
        ["\x81\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB8"],

        ["\xF3\xB0\x84\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x79"],
        ["\x81\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB9"],

        ["\xF3\xB0\x84\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x7A"],
        ["\x81\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBA"],

        ["\xF3\xB0\x84\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x7B"],
        ["\x81\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBB"],

        ["\xF3\xB0\x84\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x7C"],
        ["\x81\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBC"],

        ["\xF3\xB0\x84\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x7D"],
        ["\x81\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBD"],

        ["\xF3\xB0\x84\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x7E"],
        ["\x81\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBE"],

        ["\xF3\xB0\x84\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x80"],
        ["\x81\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBF"],

        ["\xF3\xB0\x85\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x81"],
        ["\x81\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x80"],

        ["\xF3\xB0\x85\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x82"],
        ["\x81\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x81"],

        ["\xF3\xB0\x85\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x83"],
        ["\x81\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x82"],

        ["\xF3\xB0\x85\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x84"],
        ["\x81\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x83"],

        ["\xF3\xB0\x85\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x85"],
        ["\x81\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x84"],

        ["\xF3\xB0\x85\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x86"],
        ["\x81\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x85"],

        ["\xF3\xB0\x85\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x87"],
        ["\x81\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x86"],

        ["\xF3\xB0\x85\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x88"],
        ["\x81\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x87"],

        ["\xF3\xB0\x85\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x89"],
        ["\x81\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x88"],

        ["\xF3\xB0\x85\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8A"],
        ["\x81\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x89"],

        ["\xF3\xB0\x85\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8B"],
        ["\x81\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8A"],

        ["\xF3\xB0\x85\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8C"],
        ["\x81\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8B"],

        ["\xF3\xB0\x85\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8D"],
        ["\x81\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8C"],

        ["\xF3\xB0\x85\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8E"],
        ["\x81\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8D"],

        ["\xF3\xB0\x85\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x8F"],
        ["\x81\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8E"],

        ["\xF3\xB0\x85\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x90"],
        ["\x81\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8F"],

        ["\xF3\xB0\x85\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x91"],
        ["\x81\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x90"],

        ["\xF3\xB0\x85\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x92"],
        ["\x81\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x91"],

        ["\xF3\xB0\x85\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x93"],
        ["\x81\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x92"],

        ["\xF3\xB0\x85\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x94"],
        ["\x81\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x93"],

        ["\xF3\xB0\x85\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x95"],
        ["\x81\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x94"],

        ["\xF3\xB0\x85\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x96"],
        ["\x81\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x95"],

        ["\xF3\xB0\x85\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x97"],
        ["\x81\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x96"],

        ["\xF3\xB0\x85\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x98"],
        ["\x81\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x97"],

        ["\xF3\xB0\x85\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x99"],
        ["\x81\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x98"],

        ["\xF3\xB0\x85\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9A"],
        ["\x81\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x99"],

        ["\xF3\xB0\x85\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9B"],
        ["\x81\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9A"],

        ["\xF3\xB0\x85\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9C"],
        ["\x81\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9B"],

        ["\xF3\xB0\x85\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9D"],
        ["\x81\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9C"],

        ["\xF3\xB0\x85\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9E"],
        ["\x81\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9D"],

        ["\xF3\xB0\x85\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\x9F"],
        ["\x81\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9E"],

        ["\xF3\xB0\x85\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA0"],
        ["\x81\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9F"],

        ["\xF3\xB0\x85\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA1"],
        ["\x81\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA0"],

        ["\xF3\xB0\x85\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA2"],
        ["\x81\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA1"],

        ["\xF3\xB0\x85\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA3"],
        ["\x81\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA2"],

        ["\xF3\xB0\x85\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA4"],
        ["\x81\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA3"],

        ["\xF3\xB0\x85\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA5"],
        ["\x81\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA4"],

        ["\xF3\xB0\x85\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA6"],
        ["\x81\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA5"],

        ["\xF3\xB0\x85\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA7"],
        ["\x81\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA6"],

        ["\xF3\xB0\x85\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA8"],
        ["\x81\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA7"],

        ["\xF3\xB0\x85\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xA9"],
        ["\x81\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA8"],

        ["\xF3\xB0\x85\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xAA"],
        ["\x81\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA9"],

        ["\xF3\xB0\x85\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xAB"],
        ["\x81\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAA"],

        ["\xF3\xB0\x85\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x81\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAB"],

        ["\xF3\xB0\x85\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB8"],
        ["\x81\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB7"],

        ["\xF3\xB0\x85\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xB9"],
        ["\x81\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB8"],

        ["\xF3\xB0\x85\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBA"],
        ["\x81\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB9"],

        ["\xF3\xB0\x85\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBB"],
        ["\x81\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBA"],

        ["\xF3\xB0\x85\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBC"],
        ["\x81\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBB"],

        ["\xF3\xB0\x85\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBD"],
        ["\x81\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBC"],

        ["\xF3\xB0\x85\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBE"],
        ["\x81\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBD"],

        ["\xF3\xB0\x85\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xBF"],
        ["\x81\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBE"],

        ["\xF3\xB0\x86\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC8"],
        ["\x81\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x87"],

        ["\xF3\xB0\x86\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xC9"],
        ["\x81\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x88"],

        ["\xF3\xB0\x86\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCA"],
        ["\x81\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x89"],

        ["\xF3\xB0\x86\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCB"],
        ["\x81\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8A"],

        ["\xF3\xB0\x86\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCC"],
        ["\x81\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8B"],

        ["\xF3\xB0\x86\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCD"],
        ["\x81\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8C"],

        ["\xF3\xB0\x86\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xCE"],
        ["\x81\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8D"],

        ["\xF3\xB0\x86\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDA"],
        ["\x81\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x99"],

        ["\xF3\xB0\x86\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDB"],
        ["\x81\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9A"],

        ["\xF3\xB0\x86\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDC"],
        ["\x81\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9B"],

        ["\xF3\xB0\x86\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDD"],
        ["\x81\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9C"],

        ["\xF3\xB0\x86\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDE"],
        ["\x81\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9D"],

        ["\xF3\xB0\x86\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xDF"],
        ["\x81\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9E"],

        ["\xF3\xB0\x86\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE0"],
        ["\x81\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9F"],

        ["\xF3\xB0\x86\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE1"],
        ["\x81\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA0"],

        ["\xF3\xB0\x86\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE2"],
        ["\x81\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA1"],

        ["\xF3\xB0\x86\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE3"],
        ["\x81\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA2"],

        ["\xF3\xB0\x86\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE4"],
        ["\x81\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA3"],

        ["\xF3\xB0\x86\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE5"],
        ["\x81\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA4"],

        ["\xF3\xB0\x86\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE6"],
        ["\x81\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA5"],

        ["\xF3\xB0\x86\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE7"],
        ["\x81\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA6"],

        ["\xF3\xB0\x86\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xE8"],
        ["\x81\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA7"],

        ["\xF3\xB0\x86\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF0"],
        ["\x81\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xAF"],

        ["\xF3\xB0\x86\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF1"],
        ["\x81\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB0"],

        ["\xF3\xB0\x86\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF2"],
        ["\x81\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB1"],

        ["\xF3\xB0\x86\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF3"],
        ["\x81\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB2"],

        ["\xF3\xB0\x86\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF4"],
        ["\x81\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB3"],

        ["\xF3\xB0\x86\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF5"],
        ["\x81\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB4"],

        ["\xF3\xB0\x86\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF6"],
        ["\x81\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB5"],

        ["\xF3\xB0\x86\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xF7"],
        ["\x81\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB6"],

        ["\xF3\xB0\x86\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81\xFC"],
        ["\x81\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xBB"],

        ["\xF3\xB0\x87\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x4F"],
        ["\x82\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8B"],

        ["\xF3\xB0\x87\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x50"],
        ["\x82\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8C"],

        ["\xF3\xB0\x87\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x51"],
        ["\x82\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8D"],

        ["\xF3\xB0\x87\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x52"],
        ["\x82\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8E"],

        ["\xF3\xB0\x87\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x53"],
        ["\x82\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8F"],

        ["\xF3\xB0\x87\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x54"],
        ["\x82\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x90"],

        ["\xF3\xB0\x87\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x55"],
        ["\x82\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x91"],

        ["\xF3\xB0\x87\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x56"],
        ["\x82\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x92"],

        ["\xF3\xB0\x87\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x57"],
        ["\x82\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x93"],

        ["\xF3\xB0\x87\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x58"],
        ["\x82\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x94"],

        ["\xF3\xB0\x87\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x60"],
        ["\x82\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9C"],

        ["\xF3\xB0\x87\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x61"],
        ["\x82\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9D"],

        ["\xF3\xB0\x87\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x62"],
        ["\x82\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9E"],

        ["\xF3\xB0\x87\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x63"],
        ["\x82\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9F"],

        ["\xF3\xB0\x87\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x64"],
        ["\x82\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA0"],

        ["\xF3\xB0\x87\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x65"],
        ["\x82\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA1"],

        ["\xF3\xB0\x87\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x66"],
        ["\x82\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA2"],

        ["\xF3\xB0\x87\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x67"],
        ["\x82\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA3"],

        ["\xF3\xB0\x87\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x68"],
        ["\x82\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA4"],

        ["\xF3\xB0\x87\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x69"],
        ["\x82\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA5"],

        ["\xF3\xB0\x87\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6A"],
        ["\x82\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA6"],

        ["\xF3\xB0\x87\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6B"],
        ["\x82\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA7"],

        ["\xF3\xB0\x87\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6C"],
        ["\x82\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA8"],

        ["\xF3\xB0\x87\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6D"],
        ["\x82\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA9"],

        ["\xF3\xB0\x87\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6E"],
        ["\x82\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAA"],

        ["\xF3\xB0\x87\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x6F"],
        ["\x82\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAB"],

        ["\xF3\xB0\x87\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x70"],
        ["\x82\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAC"],

        ["\xF3\xB0\x87\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x71"],
        ["\x82\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAD"],

        ["\xF3\xB0\x87\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x72"],
        ["\x82\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAE"],

        ["\xF3\xB0\x87\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x73"],
        ["\x82\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAF"],

        ["\xF3\xB0\x87\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x74"],
        ["\x82\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB0"],

        ["\xF3\xB0\x87\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x75"],
        ["\x82\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB1"],

        ["\xF3\xB0\x87\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x76"],
        ["\x82\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB2"],

        ["\xF3\xB0\x87\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x77"],
        ["\x82\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB3"],

        ["\xF3\xB0\x87\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x78"],
        ["\x82\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB4"],

        ["\xF3\xB0\x87\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x79"],
        ["\x82\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB5"],

        ["\xF3\xB0\x87\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x81"],
        ["\x82\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBC"],

        ["\xF3\xB0\x87\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x82"],
        ["\x82\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBD"],

        ["\xF3\xB0\x87\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x83"],
        ["\x82\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBE"],

        ["\xF3\xB0\x87\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x84"],
        ["\x82\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBF"],

        ["\xF3\xB0\x88\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x85"],
        ["\x82\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x80"],

        ["\xF3\xB0\x88\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x86"],
        ["\x82\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x81"],

        ["\xF3\xB0\x88\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x87"],
        ["\x82\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x82"],

        ["\xF3\xB0\x88\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x88"],
        ["\x82\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x83"],

        ["\xF3\xB0\x88\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x89"],
        ["\x82\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x84"],

        ["\xF3\xB0\x88\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8A"],
        ["\x82\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x85"],

        ["\xF3\xB0\x88\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8B"],
        ["\x82\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x86"],

        ["\xF3\xB0\x88\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8C"],
        ["\x82\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x87"],

        ["\xF3\xB0\x88\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8D"],
        ["\x82\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x88"],

        ["\xF3\xB0\x88\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8E"],
        ["\x82\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x89"],

        ["\xF3\xB0\x88\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8F"],
        ["\x82\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8A"],

        ["\xF3\xB0\x88\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x90"],
        ["\x82\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8B"],

        ["\xF3\xB0\x88\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x91"],
        ["\x82\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8C"],

        ["\xF3\xB0\x88\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x92"],
        ["\x82\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8D"],

        ["\xF3\xB0\x88\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x93"],
        ["\x82\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8E"],

        ["\xF3\xB0\x88\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x94"],
        ["\x82\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8F"],

        ["\xF3\xB0\x88\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x95"],
        ["\x82\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x90"],

        ["\xF3\xB0\x88\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x96"],
        ["\x82\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x91"],

        ["\xF3\xB0\x88\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x97"],
        ["\x82\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x92"],

        ["\xF3\xB0\x88\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x98"],
        ["\x82\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x93"],

        ["\xF3\xB0\x88\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x99"],
        ["\x82\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x94"],

        ["\xF3\xB0\x88\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x9A"],
        ["\x82\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x95"],

        ["\xF3\xB0\x88\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x9F"],
        ["\x82\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9A"],

        ["\xF3\xB0\x88\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA0"],
        ["\x82\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9B"],

        ["\xF3\xB0\x88\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA1"],
        ["\x82\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9C"],

        ["\xF3\xB0\x88\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA2"],
        ["\x82\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9D"],

        ["\xF3\xB0\x88\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA3"],
        ["\x82\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9E"],

        ["\xF3\xB0\x88\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA4"],
        ["\x82\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9F"],

        ["\xF3\xB0\x88\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA5"],
        ["\x82\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA0"],

        ["\xF3\xB0\x88\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA6"],
        ["\x82\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA1"],

        ["\xF3\xB0\x88\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA7"],
        ["\x82\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA2"],

        ["\xF3\xB0\x88\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA8"],
        ["\x82\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA3"],

        ["\xF3\xB0\x88\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA9"],
        ["\x82\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA4"],

        ["\xF3\xB0\x88\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAA"],
        ["\x82\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA5"],

        ["\xF3\xB0\x88\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAB"],
        ["\x82\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA6"],

        ["\xF3\xB0\x88\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAC"],
        ["\x82\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA7"],

        ["\xF3\xB0\x88\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAD"],
        ["\x82\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA8"],

        ["\xF3\xB0\x88\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAE"],
        ["\x82\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA9"],

        ["\xF3\xB0\x88\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAF"],
        ["\x82\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAA"],

        ["\xF3\xB0\x88\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB0"],
        ["\x82\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAB"],

        ["\xF3\xB0\x88\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB1"],
        ["\x82\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAC"],

        ["\xF3\xB0\x88\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB2"],
        ["\x82\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAD"],

        ["\xF3\xB0\x88\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB3"],
        ["\x82\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAE"],

        ["\xF3\xB0\x88\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB4"],
        ["\x82\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAF"],

        ["\xF3\xB0\x88\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB5"],
        ["\x82\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB0"],

        ["\xF3\xB0\x88\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB6"],
        ["\x82\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB1"],

        ["\xF3\xB0\x88\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB7"],
        ["\x82\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB2"],

        ["\xF3\xB0\x88\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB8"],
        ["\x82\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB3"],

        ["\xF3\xB0\x88\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB9"],
        ["\x82\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB4"],

        ["\xF3\xB0\x88\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBA"],
        ["\x82\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB5"],

        ["\xF3\xB0\x88\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBB"],
        ["\x82\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB6"],

        ["\xF3\xB0\x88\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBC"],
        ["\x82\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB7"],

        ["\xF3\xB0\x88\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBD"],
        ["\x82\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB8"],

        ["\xF3\xB0\x88\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBE"],
        ["\x82\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB9"],

        ["\xF3\xB0\x88\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBF"],
        ["\x82\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBA"],

        ["\xF3\xB0\x88\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC0"],
        ["\x82\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBB"],

        ["\xF3\xB0\x88\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC1"],
        ["\x82\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBC"],

        ["\xF3\xB0\x88\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC2"],
        ["\x82\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBD"],

        ["\xF3\xB0\x88\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC3"],
        ["\x82\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBE"],

        ["\xF3\xB0\x88\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC4"],
        ["\x82\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBF"],

        ["\xF3\xB0\x89\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC5"],
        ["\x82\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x80"],

        ["\xF3\xB0\x89\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC6"],
        ["\x82\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x81"],

        ["\xF3\xB0\x89\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC7"],
        ["\x82\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x82"],

        ["\xF3\xB0\x89\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC8"],
        ["\x82\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x83"],

        ["\xF3\xB0\x89\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xC9"],
        ["\x82\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x84"],

        ["\xF3\xB0\x89\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCA"],
        ["\x82\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x85"],

        ["\xF3\xB0\x89\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCB"],
        ["\x82\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x86"],

        ["\xF3\xB0\x89\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCC"],
        ["\x82\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x87"],

        ["\xF3\xB0\x89\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCD"],
        ["\x82\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x88"],

        ["\xF3\xB0\x89\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCE"],
        ["\x82\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x89"],

        ["\xF3\xB0\x89\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCF"],
        ["\x82\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8A"],

        ["\xF3\xB0\x89\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD0"],
        ["\x82\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8B"],

        ["\xF3\xB0\x89\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD1"],
        ["\x82\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8C"],

        ["\xF3\xB0\x89\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD2"],
        ["\x82\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8D"],

        ["\xF3\xB0\x89\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD3"],
        ["\x82\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8E"],

        ["\xF3\xB0\x89\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD4"],
        ["\x82\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8F"],

        ["\xF3\xB0\x89\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD5"],
        ["\x82\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x90"],

        ["\xF3\xB0\x89\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD6"],
        ["\x82\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x91"],

        ["\xF3\xB0\x89\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD7"],
        ["\x82\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x92"],

        ["\xF3\xB0\x89\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD8"],
        ["\x82\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x93"],

        ["\xF3\xB0\x89\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xD9"],
        ["\x82\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x94"],

        ["\xF3\xB0\x89\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDA"],
        ["\x82\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x95"],

        ["\xF3\xB0\x89\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDB"],
        ["\x82\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x96"],

        ["\xF3\xB0\x89\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDC"],
        ["\x82\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x97"],

        ["\xF3\xB0\x89\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDD"],
        ["\x82\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x98"],

        ["\xF3\xB0\x89\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDE"],
        ["\x82\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x99"],

        ["\xF3\xB0\x89\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDF"],
        ["\x82\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9A"],

        ["\xF3\xB0\x89\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE0"],
        ["\x82\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9B"],

        ["\xF3\xB0\x89\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE1"],
        ["\x82\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9C"],

        ["\xF3\xB0\x89\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE2"],
        ["\x82\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9D"],

        ["\xF3\xB0\x89\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE3"],
        ["\x82\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9E"],

        ["\xF3\xB0\x89\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE4"],
        ["\x82\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9F"],

        ["\xF3\xB0\x89\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE5"],
        ["\x82\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA0"],

        ["\xF3\xB0\x89\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE6"],
        ["\x82\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA1"],

        ["\xF3\xB0\x89\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE7"],
        ["\x82\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA2"],

        ["\xF3\xB0\x89\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE8"],
        ["\x82\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA3"],

        ["\xF3\xB0\x89\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xE9"],
        ["\x82\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA4"],

        ["\xF3\xB0\x89\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEA"],
        ["\x82\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA5"],

        ["\xF3\xB0\x89\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEB"],
        ["\x82\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA6"],

        ["\xF3\xB0\x89\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEC"],
        ["\x82\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA7"],

        ["\xF3\xB0\x89\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xED"],
        ["\x82\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA8"],

        ["\xF3\xB0\x89\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEE"],
        ["\x82\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA9"],

        ["\xF3\xB0\x89\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEF"],
        ["\x82\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAA"],

        ["\xF3\xB0\x89\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF0"],
        ["\x82\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAB"],

        ["\xF3\xB0\x89\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xF1"],
        ["\x82\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAC"],

        ["\xF3\xB0\x89\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x40"],
        ["\x83\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB8"],

        ["\xF3\xB0\x89\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x41"],
        ["\x83\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB9"],

        ["\xF3\xB0\x89\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x42"],
        ["\x83\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBA"],

        ["\xF3\xB0\x89\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x43"],
        ["\x83\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBB"],

        ["\xF3\xB0\x89\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x44"],
        ["\x83\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBC"],

        ["\xF3\xB0\x89\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x45"],
        ["\x83\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBD"],

        ["\xF3\xB0\x89\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x46"],
        ["\x83\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBE"],

        ["\xF3\xB0\x89\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x47"],
        ["\x83\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBF"],

        ["\xF3\xB0\x8A\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x48"],
        ["\x83\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x80"],

        ["\xF3\xB0\x8A\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x49"],
        ["\x83\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x81"],

        ["\xF3\xB0\x8A\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4A"],
        ["\x83\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x82"],

        ["\xF3\xB0\x8A\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4B"],
        ["\x83\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x83"],

        ["\xF3\xB0\x8A\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4C"],
        ["\x83\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x84"],

        ["\xF3\xB0\x8A\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4D"],
        ["\x83\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x85"],

        ["\xF3\xB0\x8A\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4E"],
        ["\x83\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x86"],

        ["\xF3\xB0\x8A\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x4F"],
        ["\x83\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x87"],

        ["\xF3\xB0\x8A\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x50"],
        ["\x83\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x88"],

        ["\xF3\xB0\x8A\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x51"],
        ["\x83\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x89"],

        ["\xF3\xB0\x8A\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x52"],
        ["\x83\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8A"],

        ["\xF3\xB0\x8A\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x53"],
        ["\x83\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8B"],

        ["\xF3\xB0\x8A\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x54"],
        ["\x83\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8C"],

        ["\xF3\xB0\x8A\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x55"],
        ["\x83\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8D"],

        ["\xF3\xB0\x8A\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x56"],
        ["\x83\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8E"],

        ["\xF3\xB0\x8A\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x57"],
        ["\x83\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8F"],

        ["\xF3\xB0\x8A\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x58"],
        ["\x83\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x90"],

        ["\xF3\xB0\x8A\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x59"],
        ["\x83\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x91"],

        ["\xF3\xB0\x8A\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5A"],
        ["\x83\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x92"],

        ["\xF3\xB0\x8A\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5B"],
        ["\x83\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x93"],

        ["\xF3\xB0\x8A\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5C"],
        ["\x83\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x94"],

        ["\xF3\xB0\x8A\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5D"],
        ["\x83\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x95"],

        ["\xF3\xB0\x8A\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5E"],
        ["\x83\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x96"],

        ["\xF3\xB0\x8A\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x5F"],
        ["\x83\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x97"],

        ["\xF3\xB0\x8A\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x60"],
        ["\x83\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x98"],

        ["\xF3\xB0\x8A\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x61"],
        ["\x83\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x99"],

        ["\xF3\xB0\x8A\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x62"],
        ["\x83\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9A"],

        ["\xF3\xB0\x8A\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x63"],
        ["\x83\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9B"],

        ["\xF3\xB0\x8A\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x64"],
        ["\x83\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9C"],

        ["\xF3\xB0\x8A\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x65"],
        ["\x83\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9D"],

        ["\xF3\xB0\x8A\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x66"],
        ["\x83\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9E"],

        ["\xF3\xB0\x8A\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x67"],
        ["\x83\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9F"],

        ["\xF3\xB0\x8A\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x68"],
        ["\x83\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA0"],

        ["\xF3\xB0\x8A\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x69"],
        ["\x83\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA1"],

        ["\xF3\xB0\x8A\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6A"],
        ["\x83\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA2"],

        ["\xF3\xB0\x8A\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6B"],
        ["\x83\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA3"],

        ["\xF3\xB0\x8A\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6C"],
        ["\x83\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA4"],

        ["\xF3\xB0\x8A\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6D"],
        ["\x83\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA5"],

        ["\xF3\xB0\x8A\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6E"],
        ["\x83\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA6"],

        ["\xF3\xB0\x8A\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x6F"],
        ["\x83\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA7"],

        ["\xF3\xB0\x8A\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x70"],
        ["\x83\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA8"],

        ["\xF3\xB0\x8A\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x71"],
        ["\x83\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA9"],

        ["\xF3\xB0\x8A\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x72"],
        ["\x83\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAA"],

        ["\xF3\xB0\x8A\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x73"],
        ["\x83\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAB"],

        ["\xF3\xB0\x8A\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x74"],
        ["\x83\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAC"],

        ["\xF3\xB0\x8A\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x75"],
        ["\x83\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAD"],

        ["\xF3\xB0\x8A\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x76"],
        ["\x83\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAE"],

        ["\xF3\xB0\x8A\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x77"],
        ["\x83\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAF"],

        ["\xF3\xB0\x8A\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x78"],
        ["\x83\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB0"],

        ["\xF3\xB0\x8A\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x79"],
        ["\x83\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB1"],

        ["\xF3\xB0\x8A\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x7A"],
        ["\x83\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB2"],

        ["\xF3\xB0\x8A\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x7B"],
        ["\x83\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB3"],

        ["\xF3\xB0\x8A\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x7C"],
        ["\x83\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB4"],

        ["\xF3\xB0\x8A\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x7D"],
        ["\x83\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB5"],

        ["\xF3\xB0\x8A\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x7E"],
        ["\x83\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB6"],

        ["\xF3\xB0\x8A\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x80"],
        ["\x83\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB7"],

        ["\xF3\xB0\x8A\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x81"],
        ["\x83\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB8"],

        ["\xF3\xB0\x8A\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x82"],
        ["\x83\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB9"],

        ["\xF3\xB0\x8A\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x83"],
        ["\x83\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBA"],

        ["\xF3\xB0\x8A\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x84"],
        ["\x83\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBB"],

        ["\xF3\xB0\x8A\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x85"],
        ["\x83\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBC"],

        ["\xF3\xB0\x8A\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x86"],
        ["\x83\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBD"],

        ["\xF3\xB0\x8A\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x87"],
        ["\x83\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBE"],

        ["\xF3\xB0\x8A\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x88"],
        ["\x83\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBF"],

        ["\xF3\xB0\x8B\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x89"],
        ["\x83\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x80"],

        ["\xF3\xB0\x8B\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8A"],
        ["\x83\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x81"],

        ["\xF3\xB0\x8B\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8B"],
        ["\x83\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x82"],

        ["\xF3\xB0\x8B\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8C"],
        ["\x83\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x83"],

        ["\xF3\xB0\x8B\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8D"],
        ["\x83\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x84"],

        ["\xF3\xB0\x8B\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8E"],
        ["\x83\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x85"],

        ["\xF3\xB0\x8B\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8F"],
        ["\x83\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x86"],

        ["\xF3\xB0\x8B\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x90"],
        ["\x83\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x87"],

        ["\xF3\xB0\x8B\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x91"],
        ["\x83\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x88"],

        ["\xF3\xB0\x8B\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x92"],
        ["\x83\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x89"],

        ["\xF3\xB0\x8B\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x93"],
        ["\x83\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8A"],

        ["\xF3\xB0\x8B\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x94"],
        ["\x83\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8B"],

        ["\xF3\xB0\x8B\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x95"],
        ["\x83\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8C"],

        ["\xF3\xB0\x8B\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x96"],
        ["\x83\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8D"],

        ["\xF3\xB0\x8B\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x9F"],
        ["\x83\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x96"],

        ["\xF3\xB0\x8B\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA0"],
        ["\x83\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x97"],

        ["\xF3\xB0\x8B\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA1"],
        ["\x83\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x98"],

        ["\xF3\xB0\x8B\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA2"],
        ["\x83\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x99"],

        ["\xF3\xB0\x8B\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA3"],
        ["\x83\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9A"],

        ["\xF3\xB0\x8B\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA4"],
        ["\x83\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9B"],

        ["\xF3\xB0\x8B\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA5"],
        ["\x83\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9C"],

        ["\xF3\xB0\x8B\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA6"],
        ["\x83\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9D"],

        ["\xF3\xB0\x8B\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA7"],
        ["\x83\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9E"],

        ["\xF3\xB0\x8B\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA8"],
        ["\x83\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9F"],

        ["\xF3\xB0\x8B\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA9"],
        ["\x83\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA0"],

        ["\xF3\xB0\x8B\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAA"],
        ["\x83\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA1"],

        ["\xF3\xB0\x8B\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAB"],
        ["\x83\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA2"],

        ["\xF3\xB0\x8B\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAC"],
        ["\x83\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA3"],

        ["\xF3\xB0\x8B\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAD"],
        ["\x83\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA4"],

        ["\xF3\xB0\x8B\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAE"],
        ["\x83\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA5"],

        ["\xF3\xB0\x8B\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAF"],
        ["\x83\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA6"],

        ["\xF3\xB0\x8B\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB0"],
        ["\x83\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA7"],

        ["\xF3\xB0\x8B\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB1"],
        ["\x83\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA8"],

        ["\xF3\xB0\x8B\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB2"],
        ["\x83\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA9"],

        ["\xF3\xB0\x8B\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB3"],
        ["\x83\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAA"],

        ["\xF3\xB0\x8B\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB4"],
        ["\x83\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAB"],

        ["\xF3\xB0\x8B\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB5"],
        ["\x83\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAC"],

        ["\xF3\xB0\x8B\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB6"],
        ["\x83\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAD"],

        ["\xF3\xB0\x8B\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xBF"],
        ["\x83\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB6"],

        ["\xF3\xB0\x8B\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC0"],
        ["\x83\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB7"],

        ["\xF3\xB0\x8B\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC1"],
        ["\x83\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB8"],

        ["\xF3\xB0\x8B\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC2"],
        ["\x83\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB9"],

        ["\xF3\xB0\x8B\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC3"],
        ["\x83\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBA"],

        ["\xF3\xB0\x8B\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC4"],
        ["\x83\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBB"],

        ["\xF3\xB0\x8B\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC5"],
        ["\x83\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBC"],

        ["\xF3\xB0\x8B\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC6"],
        ["\x83\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBD"],

        ["\xF3\xB0\x8B\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC7"],
        ["\x83\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBE"],

        ["\xF3\xB0\x8B\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC8"],
        ["\x83\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBF"],

        ["\xF3\xB0\x8C\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xC9"],
        ["\x83\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x80"],

        ["\xF3\xB0\x8C\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCA"],
        ["\x83\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x81"],

        ["\xF3\xB0\x8C\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCB"],
        ["\x83\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x82"],

        ["\xF3\xB0\x8C\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCC"],
        ["\x83\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x83"],

        ["\xF3\xB0\x8C\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCD"],
        ["\x83\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x84"],

        ["\xF3\xB0\x8C\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCE"],
        ["\x83\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x85"],

        ["\xF3\xB0\x8C\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCF"],
        ["\x83\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x86"],

        ["\xF3\xB0\x8C\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD0"],
        ["\x83\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x87"],

        ["\xF3\xB0\x8C\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD1"],
        ["\x83\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x88"],

        ["\xF3\xB0\x8C\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD2"],
        ["\x83\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x89"],

        ["\xF3\xB0\x8C\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD3"],
        ["\x83\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8A"],

        ["\xF3\xB0\x8C\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD4"],
        ["\x83\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8B"],

        ["\xF3\xB0\x8C\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD5"],
        ["\x83\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8C"],

        ["\xF3\xB0\x8C\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xD6"],
        ["\x83\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8D"],

        ["\xF3\xB0\x8C\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x40"],
        ["\x84\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB4"],

        ["\xF3\xB0\x8C\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x41"],
        ["\x84\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB5"],

        ["\xF3\xB0\x8C\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x42"],
        ["\x84\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB6"],

        ["\xF3\xB0\x8C\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x43"],
        ["\x84\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB7"],

        ["\xF3\xB0\x8C\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x44"],
        ["\x84\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB8"],

        ["\xF3\xB0\x8C\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x45"],
        ["\x84\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB9"],

        ["\xF3\xB0\x8C\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x46"],
        ["\x84\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBA"],

        ["\xF3\xB0\x8C\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x47"],
        ["\x84\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBB"],

        ["\xF3\xB0\x8C\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x48"],
        ["\x84\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBC"],

        ["\xF3\xB0\x8C\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x49"],
        ["\x84\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBD"],

        ["\xF3\xB0\x8C\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4A"],
        ["\x84\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBE"],

        ["\xF3\xB0\x8C\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4B"],
        ["\x84\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBF"],

        ["\xF3\xB0\x8D\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4C"],
        ["\x84\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x80"],

        ["\xF3\xB0\x8D\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4D"],
        ["\x84\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x81"],

        ["\xF3\xB0\x8D\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4E"],
        ["\x84\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x82"],

        ["\xF3\xB0\x8D\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x4F"],
        ["\x84\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x83"],

        ["\xF3\xB0\x8D\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x50"],
        ["\x84\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x84"],

        ["\xF3\xB0\x8D\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x51"],
        ["\x84\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x85"],

        ["\xF3\xB0\x8D\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x52"],
        ["\x84\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x86"],

        ["\xF3\xB0\x8D\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x53"],
        ["\x84\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x87"],

        ["\xF3\xB0\x8D\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x54"],
        ["\x84\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x88"],

        ["\xF3\xB0\x8D\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x55"],
        ["\x84\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x89"],

        ["\xF3\xB0\x8D\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x56"],
        ["\x84\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8A"],

        ["\xF3\xB0\x8D\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x57"],
        ["\x84\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8B"],

        ["\xF3\xB0\x8D\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x58"],
        ["\x84\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8C"],

        ["\xF3\xB0\x8D\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x59"],
        ["\x84\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8D"],

        ["\xF3\xB0\x8D\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5A"],
        ["\x84\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8E"],

        ["\xF3\xB0\x8D\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5B"],
        ["\x84\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8F"],

        ["\xF3\xB0\x8D\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5C"],
        ["\x84\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x90"],

        ["\xF3\xB0\x8D\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5D"],
        ["\x84\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x91"],

        ["\xF3\xB0\x8D\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5E"],
        ["\x84\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x92"],

        ["\xF3\xB0\x8D\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x5F"],
        ["\x84\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x93"],

        ["\xF3\xB0\x8D\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x60"],
        ["\x84\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x94"],

        ["\xF3\xB0\x8D\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x70"],
        ["\x84\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA4"],

        ["\xF3\xB0\x8D\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x71"],
        ["\x84\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA5"],

        ["\xF3\xB0\x8D\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x72"],
        ["\x84\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA6"],

        ["\xF3\xB0\x8D\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x73"],
        ["\x84\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA7"],

        ["\xF3\xB0\x8D\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x74"],
        ["\x84\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA8"],

        ["\xF3\xB0\x8D\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x75"],
        ["\x84\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA9"],

        ["\xF3\xB0\x8D\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x76"],
        ["\x84\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAA"],

        ["\xF3\xB0\x8D\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x77"],
        ["\x84\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAB"],

        ["\xF3\xB0\x8D\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x78"],
        ["\x84\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAC"],

        ["\xF3\xB0\x8D\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x79"],
        ["\x84\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAD"],

        ["\xF3\xB0\x8D\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x7A"],
        ["\x84\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAE"],

        ["\xF3\xB0\x8D\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x7B"],
        ["\x84\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAF"],

        ["\xF3\xB0\x8D\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x7C"],
        ["\x84\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB0"],

        ["\xF3\xB0\x8D\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x7D"],
        ["\x84\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB1"],

        ["\xF3\xB0\x8D\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x7E"],
        ["\x84\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB2"],

        ["\xF3\xB0\x8D\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x80"],
        ["\x84\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB3"],

        ["\xF3\xB0\x8D\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x81"],
        ["\x84\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB4"],

        ["\xF3\xB0\x8D\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x82"],
        ["\x84\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB5"],

        ["\xF3\xB0\x8D\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x83"],
        ["\x84\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB6"],

        ["\xF3\xB0\x8D\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x84"],
        ["\x84\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB7"],

        ["\xF3\xB0\x8D\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x85"],
        ["\x84\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB8"],

        ["\xF3\xB0\x8D\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x86"],
        ["\x84\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB9"],

        ["\xF3\xB0\x8D\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x87"],
        ["\x84\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBA"],

        ["\xF3\xB0\x8D\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x88"],
        ["\x84\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBB"],

        ["\xF3\xB0\x8D\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x89"],
        ["\x84\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBC"],

        ["\xF3\xB0\x8D\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8A"],
        ["\x84\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBD"],

        ["\xF3\xB0\x8D\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8B"],
        ["\x84\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBE"],

        ["\xF3\xB0\x8D\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8C"],
        ["\x84\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBF"],

        ["\xF3\xB0\x8E\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8D"],
        ["\x84\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x80"],

        ["\xF3\xB0\x8E\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8E"],
        ["\x84\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x81"],

        ["\xF3\xB0\x8E\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8F"],
        ["\x84\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x82"],

        ["\xF3\xB0\x8E\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x90"],
        ["\x84\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x83"],

        ["\xF3\xB0\x8E\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x91"],
        ["\x84\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x84"],

        ["\xF3\xB0\x8E\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x9F"],
        ["\x84\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x92"],

        ["\xF3\xB0\x8E\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA0"],
        ["\x84\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x93"],

        ["\xF3\xB0\x8E\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA1"],
        ["\x84\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x94"],

        ["\xF3\xB0\x8E\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA2"],
        ["\x84\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x95"],

        ["\xF3\xB0\x8E\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA3"],
        ["\x84\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x96"],

        ["\xF3\xB0\x8E\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA4"],
        ["\x84\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x97"],

        ["\xF3\xB0\x8E\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA5"],
        ["\x84\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x98"],

        ["\xF3\xB0\x8E\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA6"],
        ["\x84\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x99"],

        ["\xF3\xB0\x8E\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA7"],
        ["\x84\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9A"],

        ["\xF3\xB0\x8E\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA8"],
        ["\x84\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9B"],

        ["\xF3\xB0\x8E\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA9"],
        ["\x84\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9C"],

        ["\xF3\xB0\x8E\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAA"],
        ["\x84\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9D"],

        ["\xF3\xB0\x8E\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAB"],
        ["\x84\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9E"],

        ["\xF3\xB0\x8E\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAC"],
        ["\x84\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9F"],

        ["\xF3\xB0\x8E\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAD"],
        ["\x84\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA0"],

        ["\xF3\xB0\x8E\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAE"],
        ["\x84\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA1"],

        ["\xF3\xB0\x8E\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAF"],
        ["\x84\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA2"],

        ["\xF3\xB0\x8E\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB0"],
        ["\x84\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA3"],

        ["\xF3\xB0\x8E\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB1"],
        ["\x84\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA4"],

        ["\xF3\xB0\x8E\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB2"],
        ["\x84\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA5"],

        ["\xF3\xB0\x8E\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB3"],
        ["\x84\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA6"],

        ["\xF3\xB0\x8E\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB4"],
        ["\x84\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA7"],

        ["\xF3\xB0\x8E\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB5"],
        ["\x84\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA8"],

        ["\xF3\xB0\x8E\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB6"],
        ["\x84\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA9"],

        ["\xF3\xB0\x8E\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB7"],
        ["\x84\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAA"],

        ["\xF3\xB0\x8E\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB8"],
        ["\x84\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAB"],

        ["\xF3\xB0\x8E\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB9"],
        ["\x84\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAC"],

        ["\xF3\xB0\x8E\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBA"],
        ["\x84\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAD"],

        ["\xF3\xB0\x8E\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBB"],
        ["\x84\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAE"],

        ["\xF3\xB0\x8E\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBC"],
        ["\x84\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAF"],

        ["\xF3\xB0\x8E\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBD"],
        ["\x84\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB0"],

        ["\xF3\xB0\x8E\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xBE"],
        ["\x84\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB1"],

        ["\xF3\xB0\x95\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x40"],
        ["\x87\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA8"],

        ["\xF3\xB0\x95\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x41"],
        ["\x87\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA9"],

        ["\xF3\xB0\x95\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x42"],
        ["\x87\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAA"],

        ["\xF3\xB0\x95\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x43"],
        ["\x87\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAB"],

        ["\xF3\xB0\x95\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x44"],
        ["\x87\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAC"],

        ["\xF3\xB0\x95\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x45"],
        ["\x87\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAD"],

        ["\xF3\xB0\x95\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x46"],
        ["\x87\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAE"],

        ["\xF3\xB0\x95\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x47"],
        ["\x87\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAF"],

        ["\xF3\xB0\x95\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x48"],
        ["\x87\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB0"],

        ["\xF3\xB0\x95\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x49"],
        ["\x87\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB1"],

        ["\xF3\xB0\x95\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4A"],
        ["\x87\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB2"],

        ["\xF3\xB0\x95\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4B"],
        ["\x87\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB3"],

        ["\xF3\xB0\x95\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4C"],
        ["\x87\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB4"],

        ["\xF3\xB0\x95\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4D"],
        ["\x87\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB5"],

        ["\xF3\xB0\x95\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4E"],
        ["\x87\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB6"],

        ["\xF3\xB0\x95\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x4F"],
        ["\x87\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB7"],

        ["\xF3\xB0\x95\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x50"],
        ["\x87\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB8"],

        ["\xF3\xB0\x95\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x51"],
        ["\x87\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB9"],

        ["\xF3\xB0\x95\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x52"],
        ["\x87\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBA"],

        ["\xF3\xB0\x95\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x53"],
        ["\x87\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBB"],

        ["\xF3\xB0\x95\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x54"],
        ["\x87\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBC"],

        ["\xF3\xB0\x95\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x55"],
        ["\x87\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBD"],

        ["\xF3\xB0\x95\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x56"],
        ["\x87\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBE"],

        ["\xF3\xB0\x95\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x57"],
        ["\x87\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBF"],

        ["\xF3\xB0\x96\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x58"],
        ["\x87\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x80"],

        ["\xF3\xB0\x96\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x59"],
        ["\x87\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x81"],

        ["\xF3\xB0\x96\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5A"],
        ["\x87\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x82"],

        ["\xF3\xB0\x96\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5B"],
        ["\x87\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x83"],

        ["\xF3\xB0\x96\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5C"],
        ["\x87\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x84"],

        ["\xF3\xB0\x96\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5D"],
        ["\x87\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x85"],

        ["\xF3\xB0\x96\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x5F"],
        ["\x87\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x87"],

        ["\xF3\xB0\x96\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x60"],
        ["\x87\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x88"],

        ["\xF3\xB0\x96\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x61"],
        ["\x87\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x89"],

        ["\xF3\xB0\x96\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x62"],
        ["\x87\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8A"],

        ["\xF3\xB0\x96\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x63"],
        ["\x87\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8B"],

        ["\xF3\xB0\x96\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x64"],
        ["\x87\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8C"],

        ["\xF3\xB0\x96\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x65"],
        ["\x87\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8D"],

        ["\xF3\xB0\x96\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x66"],
        ["\x87\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8E"],

        ["\xF3\xB0\x96\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x67"],
        ["\x87\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8F"],

        ["\xF3\xB0\x96\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x68"],
        ["\x87\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x90"],

        ["\xF3\xB0\x96\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x69"],
        ["\x87\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x91"],

        ["\xF3\xB0\x96\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6A"],
        ["\x87\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x92"],

        ["\xF3\xB0\x96\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6B"],
        ["\x87\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x93"],

        ["\xF3\xB0\x96\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6C"],
        ["\x87\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x94"],

        ["\xF3\xB0\x96\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6D"],
        ["\x87\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x95"],

        ["\xF3\xB0\x96\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6E"],
        ["\x87\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x96"],

        ["\xF3\xB0\x96\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x6F"],
        ["\x87\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x97"],

        ["\xF3\xB0\x96\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x70"],
        ["\x87\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x98"],

        ["\xF3\xB0\x96\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x71"],
        ["\x87\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x99"],

        ["\xF3\xB0\x96\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x72"],
        ["\x87\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9A"],

        ["\xF3\xB0\x96\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x73"],
        ["\x87\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9B"],

        ["\xF3\xB0\x96\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x74"],
        ["\x87\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9C"],

        ["\xF3\xB0\x96\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x75"],
        ["\x87\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9D"],

        ["\xF3\xB0\x96\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x7E"],
        ["\x87\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA6"],

        ["\xF3\xB0\x96\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x80"],
        ["\x87\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA7"],

        ["\xF3\xB0\x96\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x81"],
        ["\x87\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA8"],

        ["\xF3\xB0\x96\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x82"],
        ["\x87\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA9"],

        ["\xF3\xB0\x96\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x83"],
        ["\x87\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAA"],

        ["\xF3\xB0\x96\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x84"],
        ["\x87\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAB"],

        ["\xF3\xB0\x96\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x85"],
        ["\x87\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAC"],

        ["\xF3\xB0\x96\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x86"],
        ["\x87\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAD"],

        ["\xF3\xB0\x96\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x87"],
        ["\x87\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAE"],

        ["\xF3\xB0\x96\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x88"],
        ["\x87\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAF"],

        ["\xF3\xB0\x96\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x89"],
        ["\x87\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB0"],

        ["\xF3\xB0\x96\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8A"],
        ["\x87\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB1"],

        ["\xF3\xB0\x96\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8B"],
        ["\x87\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB2"],

        ["\xF3\xB0\x96\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8C"],
        ["\x87\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB3"],

        ["\xF3\xB0\x96\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8D"],
        ["\x87\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB4"],

        ["\xF3\xB0\x96\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8E"],
        ["\x87\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB5"],

        ["\xF3\xB0\x96\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8F"],
        ["\x87\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB6"],

        ["\xF3\xB0\x96\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x93"],
        ["\x87\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBA"],

        ["\xF3\xB0\x96\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x94"],
        ["\x87\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBB"],

        ["\xF3\xB0\x96\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x98"],
        ["\x87\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBF"],

        ["\xF3\xB0\x97\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x99"],
        ["\x87\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x97\x80"],

        ["\xF3\xB0\x9A\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x9F"],
        ["\x88\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x82"],

        ["\xF3\xB0\x9A\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA0"],
        ["\x88\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x83"],

        ["\xF3\xB0\x9A\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA1"],
        ["\x88\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x84"],

        ["\xF3\xB0\x9A\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA2"],
        ["\x88\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x85"],

        ["\xF3\xB0\x9A\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA3"],
        ["\x88\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x86"],

        ["\xF3\xB0\x9A\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA4"],
        ["\x88\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x87"],

        ["\xF3\xB0\x9A\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA5"],
        ["\x88\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x88"],

        ["\xF3\xB0\x9A\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA6"],
        ["\x88\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x89"],

        ["\xF3\xB0\x9A\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA7"],
        ["\x88\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8A"],

        ["\xF3\xB0\x9A\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA8"],
        ["\x88\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8B"],

        ["\xF3\xB0\x9A\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA9"],
        ["\x88\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8C"],

        ["\xF3\xB0\x9A\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAA"],
        ["\x88\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8D"],

        ["\xF3\xB0\x9A\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAB"],
        ["\x88\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8E"],

        ["\xF3\xB0\x9A\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAC"],
        ["\x88\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8F"],

        ["\xF3\xB0\x9A\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAD"],
        ["\x88\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x90"],

        ["\xF3\xB0\x9A\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAE"],
        ["\x88\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x91"],

        ["\xF3\xB0\x9A\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xAF"],
        ["\x88\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x92"],

        ["\xF3\xB0\x9A\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB0"],
        ["\x88\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x93"],

        ["\xF3\xB0\x9A\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB1"],
        ["\x88\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x94"],

        ["\xF3\xB0\x9A\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB2"],
        ["\x88\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x95"],

        ["\xF3\xB0\x9A\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB3"],
        ["\x88\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x96"],

        ["\xF3\xB0\x9A\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB4"],
        ["\x88\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x97"],

        ["\xF3\xB0\x9A\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB5"],
        ["\x88\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x98"],

        ["\xF3\xB0\x9A\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB6"],
        ["\x88\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x99"],

        ["\xF3\xB0\x9A\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB7"],
        ["\x88\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9A"],

        ["\xF3\xB0\x9A\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB8"],
        ["\x88\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9B"],

        ["\xF3\xB0\x9A\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB9"],
        ["\x88\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9C"],

        ["\xF3\xB0\x9A\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBA"],
        ["\x88\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9D"],

        ["\xF3\xB0\x9A\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBB"],
        ["\x88\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9E"],

        ["\xF3\xB0\x9A\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBC"],
        ["\x88\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9F"],

        ["\xF3\xB0\x9A\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBD"],
        ["\x88\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA0"],

        ["\xF3\xB0\x9A\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBE"],
        ["\x88\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA1"],

        ["\xF3\xB0\x9A\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xBF"],
        ["\x88\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA2"],

        ["\xF3\xB0\x9A\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC0"],
        ["\x88\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA3"],

        ["\xF3\xB0\x9A\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC1"],
        ["\x88\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA4"],

        ["\xF3\xB0\x9A\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC2"],
        ["\x88\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA5"],

        ["\xF3\xB0\x9A\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC3"],
        ["\x88\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA6"],

        ["\xF3\xB0\x9A\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC4"],
        ["\x88\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA7"],

        ["\xF3\xB0\x9A\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC5"],
        ["\x88\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA8"],

        ["\xF3\xB0\x9A\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC6"],
        ["\x88\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA9"],

        ["\xF3\xB0\x9A\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC7"],
        ["\x88\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAA"],

        ["\xF3\xB0\x9A\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC8"],
        ["\x88\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAB"],

        ["\xF3\xB0\x9A\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xC9"],
        ["\x88\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAC"],

        ["\xF3\xB0\x9A\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCA"],
        ["\x88\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAD"],

        ["\xF3\xB0\x9A\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCB"],
        ["\x88\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAE"],

        ["\xF3\xB0\x9A\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCC"],
        ["\x88\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAF"],

        ["\xF3\xB0\x9A\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCD"],
        ["\x88\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB0"],

        ["\xF3\xB0\x9A\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCE"],
        ["\x88\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB1"],

        ["\xF3\xB0\x9A\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCF"],
        ["\x88\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB2"],

        ["\xF3\xB0\x9A\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD0"],
        ["\x88\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB3"],

        ["\xF3\xB0\x9A\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD1"],
        ["\x88\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB4"],

        ["\xF3\xB0\x9A\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD2"],
        ["\x88\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB5"],

        ["\xF3\xB0\x9A\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD3"],
        ["\x88\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB6"],

        ["\xF3\xB0\x9A\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD4"],
        ["\x88\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB7"],

        ["\xF3\xB0\x9A\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD5"],
        ["\x88\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB8"],

        ["\xF3\xB0\x9A\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD6"],
        ["\x88\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB9"],

        ["\xF3\xB0\x9A\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD7"],
        ["\x88\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBA"],

        ["\xF3\xB0\x9A\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD8"],
        ["\x88\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBB"],

        ["\xF3\xB0\x9A\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xD9"],
        ["\x88\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBC"],

        ["\xF3\xB0\x9A\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDA"],
        ["\x88\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBD"],

        ["\xF3\xB0\x9A\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDB"],
        ["\x88\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBE"],

        ["\xF3\xB0\x9A\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDC"],
        ["\x88\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBF"],

        ["\xF3\xB0\x9B\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDD"],
        ["\x88\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x80"],

        ["\xF3\xB0\x9B\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDE"],
        ["\x88\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x81"],

        ["\xF3\xB0\x9B\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDF"],
        ["\x88\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x82"],

        ["\xF3\xB0\x9B\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE0"],
        ["\x88\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x83"],

        ["\xF3\xB0\x9B\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE1"],
        ["\x88\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x84"],

        ["\xF3\xB0\x9B\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE2"],
        ["\x88\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x85"],

        ["\xF3\xB0\x9B\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE3"],
        ["\x88\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x86"],

        ["\xF3\xB0\x9B\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE4"],
        ["\x88\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x87"],

        ["\xF3\xB0\x9B\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE5"],
        ["\x88\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x88"],

        ["\xF3\xB0\x9B\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE6"],
        ["\x88\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x89"],

        ["\xF3\xB0\x9B\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE7"],
        ["\x88\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8A"],

        ["\xF3\xB0\x9B\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE8"],
        ["\x88\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8B"],

        ["\xF3\xB0\x9B\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xE9"],
        ["\x88\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8C"],

        ["\xF3\xB0\x9B\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEA"],
        ["\x88\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8D"],

        ["\xF3\xB0\x9B\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEB"],
        ["\x88\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8E"],

        ["\xF3\xB0\x9B\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEC"],
        ["\x88\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8F"],

        ["\xF3\xB0\x9B\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xED"],
        ["\x88\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x90"],

        ["\xF3\xB0\x9B\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEE"],
        ["\x88\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x91"],

        ["\xF3\xB0\x9B\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEF"],
        ["\x88\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x92"],

        ["\xF3\xB0\x9B\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF0"],
        ["\x88\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x93"],

        ["\xF3\xB0\x9B\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF1"],
        ["\x88\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x94"],

        ["\xF3\xB0\x9B\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF2"],
        ["\x88\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x95"],

        ["\xF3\xB0\x9B\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF3"],
        ["\x88\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x96"],

        ["\xF3\xB0\x9B\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF4"],
        ["\x88\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x97"],

        ["\xF3\xB0\x9B\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF5"],
        ["\x88\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x98"],

        ["\xF3\xB0\x9B\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF6"],
        ["\x88\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x99"],

        ["\xF3\xB0\x9B\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF7"],
        ["\x88\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9A"],

        ["\xF3\xB0\x9B\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF8"],
        ["\x88\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9B"],

        ["\xF3\xB0\x9B\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xF9"],
        ["\x88\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9C"],

        ["\xF3\xB0\x9B\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xFA"],
        ["\x88\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9D"],

        ["\xF3\xB0\x9B\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xFB"],
        ["\x88\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9E"],

        ["\xF3\xB0\x9B\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xFC"],
        ["\x88\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9F"],

        ["\xF3\xB0\x9B\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x40"],
        ["\x89\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA0"],

        ["\xF3\xB0\x9B\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x41"],
        ["\x89\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA1"],

        ["\xF3\xB0\x9B\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x42"],
        ["\x89\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA2"],

        ["\xF3\xB0\x9B\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x43"],
        ["\x89\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA3"],

        ["\xF3\xB0\x9B\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x44"],
        ["\x89\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA4"],

        ["\xF3\xB0\x9B\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x45"],
        ["\x89\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA5"],

        ["\xF3\xB0\x9B\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x46"],
        ["\x89\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA6"],

        ["\xF3\xB0\x9B\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x47"],
        ["\x89\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA7"],

        ["\xF3\xB0\x9B\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x48"],
        ["\x89\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA8"],

        ["\xF3\xB0\x9B\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x49"],
        ["\x89\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA9"],

        ["\xF3\xB0\x9B\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4A"],
        ["\x89\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAA"],

        ["\xF3\xB0\x9B\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4B"],
        ["\x89\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAB"],

        ["\xF3\xB0\x9B\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4C"],
        ["\x89\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAC"],

        ["\xF3\xB0\x9B\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4D"],
        ["\x89\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAD"],

        ["\xF3\xB0\x9B\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4E"],
        ["\x89\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAE"],

        ["\xF3\xB0\x9B\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x4F"],
        ["\x89\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAF"],

        ["\xF3\xB0\x9B\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x50"],
        ["\x89\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB0"],

        ["\xF3\xB0\x9B\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x51"],
        ["\x89\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB1"],

        ["\xF3\xB0\x9B\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x52"],
        ["\x89\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB2"],

        ["\xF3\xB0\x9B\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x53"],
        ["\x89\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB3"],

        ["\xF3\xB0\x9B\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x54"],
        ["\x89\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB4"],

        ["\xF3\xB0\x9B\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x55"],
        ["\x89\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB5"],

        ["\xF3\xB0\x9B\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x56"],
        ["\x89\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB6"],

        ["\xF3\xB0\x9B\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x57"],
        ["\x89\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB7"],

        ["\xF3\xB0\x9B\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x58"],
        ["\x89\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB8"],

        ["\xF3\xB0\x9B\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x59"],
        ["\x89\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB9"],

        ["\xF3\xB0\x9B\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5A"],
        ["\x89\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBA"],

        ["\xF3\xB0\x9B\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5B"],
        ["\x89\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBB"],

        ["\xF3\xB0\x9B\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5C"],
        ["\x89\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBC"],

        ["\xF3\xB0\x9B\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5D"],
        ["\x89\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBD"],

        ["\xF3\xB0\x9B\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5E"],
        ["\x89\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBE"],

        ["\xF3\xB0\x9B\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x5F"],
        ["\x89\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBF"],

        ["\xF3\xB0\x9C\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x60"],
        ["\x89\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x80"],

        ["\xF3\xB0\x9C\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x61"],
        ["\x89\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x81"],

        ["\xF3\xB0\x9C\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x62"],
        ["\x89\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x82"],

        ["\xF3\xB0\x9C\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x63"],
        ["\x89\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x83"],

        ["\xF3\xB0\x9C\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x64"],
        ["\x89\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x84"],

        ["\xF3\xB0\x9C\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x65"],
        ["\x89\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x85"],

        ["\xF3\xB0\x9C\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x66"],
        ["\x89\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x86"],

        ["\xF3\xB0\x9C\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x67"],
        ["\x89\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x87"],

        ["\xF3\xB0\x9C\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x68"],
        ["\x89\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x88"],

        ["\xF3\xB0\x9C\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x69"],
        ["\x89\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x89"],

        ["\xF3\xB0\x9C\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6A"],
        ["\x89\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8A"],

        ["\xF3\xB0\x9C\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6B"],
        ["\x89\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8B"],

        ["\xF3\xB0\x9C\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6C"],
        ["\x89\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8C"],

        ["\xF3\xB0\x9C\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6D"],
        ["\x89\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8D"],

        ["\xF3\xB0\x9C\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6E"],
        ["\x89\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8E"],

        ["\xF3\xB0\x9C\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x6F"],
        ["\x89\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8F"],

        ["\xF3\xB0\x9C\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x70"],
        ["\x89\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x90"],

        ["\xF3\xB0\x9C\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x71"],
        ["\x89\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x91"],

        ["\xF3\xB0\x9C\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x72"],
        ["\x89\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x92"],

        ["\xF3\xB0\x9C\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x73"],
        ["\x89\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x93"],

        ["\xF3\xB0\x9C\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x74"],
        ["\x89\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x94"],

        ["\xF3\xB0\x9C\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x75"],
        ["\x89\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x95"],

        ["\xF3\xB0\x9C\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x76"],
        ["\x89\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x96"],

        ["\xF3\xB0\x9C\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x77"],
        ["\x89\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x97"],

        ["\xF3\xB0\x9C\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x78"],
        ["\x89\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x98"],

        ["\xF3\xB0\x9C\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x79"],
        ["\x89\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x99"],

        ["\xF3\xB0\x9C\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x7A"],
        ["\x89\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9A"],

        ["\xF3\xB0\x9C\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x7B"],
        ["\x89\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9B"],

        ["\xF3\xB0\x9C\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x7C"],
        ["\x89\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9C"],

        ["\xF3\xB0\x9C\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x7D"],
        ["\x89\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9D"],

        ["\xF3\xB0\x9C\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x7E"],
        ["\x89\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9E"],

        ["\xF3\xB0\x9C\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x80"],
        ["\x89\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9F"],

        ["\xF3\xB0\x9C\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x81"],
        ["\x89\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA0"],

        ["\xF3\xB0\x9C\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x82"],
        ["\x89\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA1"],

        ["\xF3\xB0\x9C\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x83"],
        ["\x89\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA2"],

        ["\xF3\xB0\x9C\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x84"],
        ["\x89\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA3"],

        ["\xF3\xB0\x9C\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x85"],
        ["\x89\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA4"],

        ["\xF3\xB0\x9C\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x86"],
        ["\x89\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA5"],

        ["\xF3\xB0\x9C\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x87"],
        ["\x89\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA6"],

        ["\xF3\xB0\x9C\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x88"],
        ["\x89\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA7"],

        ["\xF3\xB0\x9C\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x89"],
        ["\x89\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA8"],

        ["\xF3\xB0\x9C\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8A"],
        ["\x89\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA9"],

        ["\xF3\xB0\x9C\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8B"],
        ["\x89\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAA"],

        ["\xF3\xB0\x9C\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8C"],
        ["\x89\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAB"],

        ["\xF3\xB0\x9C\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8D"],
        ["\x89\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAC"],

        ["\xF3\xB0\x9C\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8E"],
        ["\x89\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAD"],

        ["\xF3\xB0\x9C\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8F"],
        ["\x89\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAE"],

        ["\xF3\xB0\x9C\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x90"],
        ["\x89\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAF"],

        ["\xF3\xB0\x9C\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x91"],
        ["\x89\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB0"],

        ["\xF3\xB0\x9C\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x92"],
        ["\x89\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB1"],

        ["\xF3\xB0\x9C\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x93"],
        ["\x89\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB2"],

        ["\xF3\xB0\x9C\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x94"],
        ["\x89\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB3"],

        ["\xF3\xB0\x9C\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x95"],
        ["\x89\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB4"],

        ["\xF3\xB0\x9C\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x96"],
        ["\x89\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB5"],

        ["\xF3\xB0\x9C\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x97"],
        ["\x89\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB6"],

        ["\xF3\xB0\x9C\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x98"],
        ["\x89\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB7"],

        ["\xF3\xB0\x9C\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x99"],
        ["\x89\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB8"],

        ["\xF3\xB0\x9C\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9A"],
        ["\x89\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB9"],

        ["\xF3\xB0\x9C\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9B"],
        ["\x89\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBA"],

        ["\xF3\xB0\x9C\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9C"],
        ["\x89\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBB"],

        ["\xF3\xB0\x9C\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9D"],
        ["\x89\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBC"],

        ["\xF3\xB0\x9C\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9E"],
        ["\x89\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBD"],

        ["\xF3\xB0\x9C\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x9F"],
        ["\x89\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBE"],

        ["\xF3\xB0\x9C\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA0"],
        ["\x89\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBF"],

        ["\xF3\xB0\x9D\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA1"],
        ["\x89\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x80"],

        ["\xF3\xB0\x9D\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA2"],
        ["\x89\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x81"],

        ["\xF3\xB0\x9D\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA3"],
        ["\x89\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x82"],

        ["\xF3\xB0\x9D\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA4"],
        ["\x89\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x83"],

        ["\xF3\xB0\x9D\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA5"],
        ["\x89\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x84"],

        ["\xF3\xB0\x9D\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA6"],
        ["\x89\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x85"],

        ["\xF3\xB0\x9D\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA7"],
        ["\x89\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x86"],

        ["\xF3\xB0\x9D\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA8"],
        ["\x89\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x87"],

        ["\xF3\xB0\x9D\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA9"],
        ["\x89\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x88"],

        ["\xF3\xB0\x9D\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAA"],
        ["\x89\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x89"],

        ["\xF3\xB0\x9D\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAB"],
        ["\x89\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8A"],

        ["\xF3\xB0\x9D\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAC"],
        ["\x89\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8B"],

        ["\xF3\xB0\x9D\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAD"],
        ["\x89\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8C"],

        ["\xF3\xB0\x9D\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAE"],
        ["\x89\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8D"],

        ["\xF3\xB0\x9D\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAF"],
        ["\x89\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8E"],

        ["\xF3\xB0\x9D\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB0"],
        ["\x89\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8F"],

        ["\xF3\xB0\x9D\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB1"],
        ["\x89\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x90"],

        ["\xF3\xB0\x9D\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB2"],
        ["\x89\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x91"],

        ["\xF3\xB0\x9D\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB3"],
        ["\x89\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x92"],

        ["\xF3\xB0\x9D\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB4"],
        ["\x89\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x93"],

        ["\xF3\xB0\x9D\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB5"],
        ["\x89\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x94"],

        ["\xF3\xB0\x9D\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB6"],
        ["\x89\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x95"],

        ["\xF3\xB0\x9D\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB7"],
        ["\x89\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x96"],

        ["\xF3\xB0\x9D\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB8"],
        ["\x89\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x97"],

        ["\xF3\xB0\x9D\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB9"],
        ["\x89\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x98"],

        ["\xF3\xB0\x9D\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBA"],
        ["\x89\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x99"],

        ["\xF3\xB0\x9D\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBB"],
        ["\x89\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9A"],

        ["\xF3\xB0\x9D\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBC"],
        ["\x89\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9B"],

        ["\xF3\xB0\x9D\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBD"],
        ["\x89\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9C"],

        ["\xF3\xB0\x9D\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBE"],
        ["\x89\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9D"],

        ["\xF3\xB0\x9D\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBF"],
        ["\x89\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9E"],

        ["\xF3\xB0\x9D\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC0"],
        ["\x89\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9F"],

        ["\xF3\xB0\x9D\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC1"],
        ["\x89\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA0"],

        ["\xF3\xB0\x9D\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC2"],
        ["\x89\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA1"],

        ["\xF3\xB0\x9D\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC3"],
        ["\x89\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA2"],

        ["\xF3\xB0\x9D\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC4"],
        ["\x89\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA3"],

        ["\xF3\xB0\x9D\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC5"],
        ["\x89\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA4"],

        ["\xF3\xB0\x9D\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC6"],
        ["\x89\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA5"],

        ["\xF3\xB0\x9D\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC7"],
        ["\x89\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA6"],

        ["\xF3\xB0\x9D\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC8"],
        ["\x89\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA7"],

        ["\xF3\xB0\x9D\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xC9"],
        ["\x89\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA8"],

        ["\xF3\xB0\x9D\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCA"],
        ["\x89\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA9"],

        ["\xF3\xB0\x9D\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCB"],
        ["\x89\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAA"],

        ["\xF3\xB0\x9D\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCC"],
        ["\x89\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAB"],

        ["\xF3\xB0\x9D\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCD"],
        ["\x89\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAC"],

        ["\xF3\xB0\x9D\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCE"],
        ["\x89\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAD"],

        ["\xF3\xB0\x9D\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCF"],
        ["\x89\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAE"],

        ["\xF3\xB0\x9D\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD0"],
        ["\x89\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAF"],

        ["\xF3\xB0\x9D\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD1"],
        ["\x89\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB0"],

        ["\xF3\xB0\x9D\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD2"],
        ["\x89\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB1"],

        ["\xF3\xB0\x9D\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD3"],
        ["\x89\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB2"],

        ["\xF3\xB0\x9D\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD4"],
        ["\x89\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB3"],

        ["\xF3\xB0\x9D\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD5"],
        ["\x89\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB4"],

        ["\xF3\xB0\x9D\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD6"],
        ["\x89\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB5"],

        ["\xF3\xB0\x9D\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD7"],
        ["\x89\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB6"],

        ["\xF3\xB0\x9D\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD8"],
        ["\x89\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB7"],

        ["\xF3\xB0\x9D\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xD9"],
        ["\x89\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB8"],

        ["\xF3\xB0\x9D\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDA"],
        ["\x89\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB9"],

        ["\xF3\xB0\x9D\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDB"],
        ["\x89\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBA"],

        ["\xF3\xB0\x9D\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDC"],
        ["\x89\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBB"],

        ["\xF3\xB0\x9D\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDD"],
        ["\x89\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBC"],

        ["\xF3\xB0\x9D\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDE"],
        ["\x89\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBD"],

        ["\xF3\xB0\x9D\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDF"],
        ["\x89\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBE"],

        ["\xF3\xB0\x9D\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE0"],
        ["\x89\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBF"],

        ["\xF3\xB0\x9E\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE1"],
        ["\x89\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x80"],

        ["\xF3\xB0\x9E\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE2"],
        ["\x89\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x81"],

        ["\xF3\xB0\x9E\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE3"],
        ["\x89\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x82"],

        ["\xF3\xB0\x9E\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE4"],
        ["\x89\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x83"],

        ["\xF3\xB0\x9E\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE5"],
        ["\x89\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x84"],

        ["\xF3\xB0\x9E\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE6"],
        ["\x89\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x85"],

        ["\xF3\xB0\x9E\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE7"],
        ["\x89\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x86"],

        ["\xF3\xB0\x9E\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE8"],
        ["\x89\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x87"],

        ["\xF3\xB0\x9E\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xE9"],
        ["\x89\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x88"],

        ["\xF3\xB0\x9E\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEA"],
        ["\x89\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x89"],

        ["\xF3\xB0\x9E\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEB"],
        ["\x89\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8A"],

        ["\xF3\xB0\x9E\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEC"],
        ["\x89\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8B"],

        ["\xF3\xB0\x9E\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xED"],
        ["\x89\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8C"],

        ["\xF3\xB0\x9E\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEE"],
        ["\x89\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8D"],

        ["\xF3\xB0\x9E\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEF"],
        ["\x89\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8E"],

        ["\xF3\xB0\x9E\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF0"],
        ["\x89\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8F"],

        ["\xF3\xB0\x9E\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF1"],
        ["\x89\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x90"],

        ["\xF3\xB0\x9E\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF2"],
        ["\x89\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x91"],

        ["\xF3\xB0\x9E\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF3"],
        ["\x89\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x92"],

        ["\xF3\xB0\x9E\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF4"],
        ["\x89\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x93"],

        ["\xF3\xB0\x9E\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF5"],
        ["\x89\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x94"],

        ["\xF3\xB0\x9E\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF6"],
        ["\x89\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x95"],

        ["\xF3\xB0\x9E\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF7"],
        ["\x89\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x96"],

        ["\xF3\xB0\x9E\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF8"],
        ["\x89\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x97"],

        ["\xF3\xB0\x9E\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xF9"],
        ["\x89\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x98"],

        ["\xF3\xB0\x9E\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xFA"],
        ["\x89\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x99"],

        ["\xF3\xB0\x9E\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xFB"],
        ["\x89\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9A"],

        ["\xF3\xB0\x9E\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xFC"],
        ["\x89\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9B"],

        ["\xF3\xB0\x9E\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x40"],
        ["\x8A\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9C"],

        ["\xF3\xB0\x9E\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x41"],
        ["\x8A\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9D"],

        ["\xF3\xB0\x9E\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x42"],
        ["\x8A\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9E"],

        ["\xF3\xB0\x9E\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x43"],
        ["\x8A\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9F"],

        ["\xF3\xB0\x9E\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x44"],
        ["\x8A\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA0"],

        ["\xF3\xB0\x9E\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x45"],
        ["\x8A\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA1"],

        ["\xF3\xB0\x9E\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x46"],
        ["\x8A\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA2"],

        ["\xF3\xB0\x9E\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x47"],
        ["\x8A\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA3"],

        ["\xF3\xB0\x9E\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x48"],
        ["\x8A\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA4"],

        ["\xF3\xB0\x9E\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x49"],
        ["\x8A\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA5"],

        ["\xF3\xB0\x9E\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4A"],
        ["\x8A\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA6"],

        ["\xF3\xB0\x9E\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4B"],
        ["\x8A\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA7"],

        ["\xF3\xB0\x9E\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4C"],
        ["\x8A\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA8"],

        ["\xF3\xB0\x9E\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4D"],
        ["\x8A\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA9"],

        ["\xF3\xB0\x9E\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4E"],
        ["\x8A\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAA"],

        ["\xF3\xB0\x9E\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x4F"],
        ["\x8A\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAB"],

        ["\xF3\xB0\x9E\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x50"],
        ["\x8A\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAC"],

        ["\xF3\xB0\x9E\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x51"],
        ["\x8A\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAD"],

        ["\xF3\xB0\x9E\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x52"],
        ["\x8A\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAE"],

        ["\xF3\xB0\x9E\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x53"],
        ["\x8A\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAF"],

        ["\xF3\xB0\x9E\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x54"],
        ["\x8A\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB0"],

        ["\xF3\xB0\x9E\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x55"],
        ["\x8A\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB1"],

        ["\xF3\xB0\x9E\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x56"],
        ["\x8A\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB2"],

        ["\xF3\xB0\x9E\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x57"],
        ["\x8A\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB3"],

        ["\xF3\xB0\x9E\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x58"],
        ["\x8A\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB4"],

        ["\xF3\xB0\x9E\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x59"],
        ["\x8A\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB5"],

        ["\xF3\xB0\x9E\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5A"],
        ["\x8A\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB6"],

        ["\xF3\xB0\x9E\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5B"],
        ["\x8A\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB7"],

        ["\xF3\xB0\x9E\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5C"],
        ["\x8A\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB8"],

        ["\xF3\xB0\x9E\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5D"],
        ["\x8A\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB9"],

        ["\xF3\xB0\x9E\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5E"],
        ["\x8A\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBA"],

        ["\xF3\xB0\x9E\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x5F"],
        ["\x8A\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBB"],

        ["\xF3\xB0\x9E\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x60"],
        ["\x8A\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBC"],

        ["\xF3\xB0\x9E\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x61"],
        ["\x8A\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBD"],

        ["\xF3\xB0\x9E\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x62"],
        ["\x8A\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBE"],

        ["\xF3\xB0\x9E\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x63"],
        ["\x8A\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBF"],

        ["\xF3\xB0\x9F\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x64"],
        ["\x8A\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x80"],

        ["\xF3\xB0\x9F\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x65"],
        ["\x8A\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x81"],

        ["\xF3\xB0\x9F\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x66"],
        ["\x8A\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x82"],

        ["\xF3\xB0\x9F\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x67"],
        ["\x8A\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x83"],

        ["\xF3\xB0\x9F\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x68"],
        ["\x8A\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x84"],

        ["\xF3\xB0\x9F\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x69"],
        ["\x8A\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x85"],

        ["\xF3\xB0\x9F\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6A"],
        ["\x8A\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x86"],

        ["\xF3\xB0\x9F\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6B"],
        ["\x8A\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x87"],

        ["\xF3\xB0\x9F\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6C"],
        ["\x8A\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x88"],

        ["\xF3\xB0\x9F\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6D"],
        ["\x8A\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x89"],

        ["\xF3\xB0\x9F\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6E"],
        ["\x8A\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8A"],

        ["\xF3\xB0\x9F\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x6F"],
        ["\x8A\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8B"],

        ["\xF3\xB0\x9F\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x70"],
        ["\x8A\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8C"],

        ["\xF3\xB0\x9F\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x71"],
        ["\x8A\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8D"],

        ["\xF3\xB0\x9F\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x72"],
        ["\x8A\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8E"],

        ["\xF3\xB0\x9F\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x73"],
        ["\x8A\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8F"],

        ["\xF3\xB0\x9F\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x74"],
        ["\x8A\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x90"],

        ["\xF3\xB0\x9F\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x75"],
        ["\x8A\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x91"],

        ["\xF3\xB0\x9F\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x76"],
        ["\x8A\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x92"],

        ["\xF3\xB0\x9F\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x77"],
        ["\x8A\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x93"],

        ["\xF3\xB0\x9F\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x78"],
        ["\x8A\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x94"],

        ["\xF3\xB0\x9F\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x79"],
        ["\x8A\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x95"],

        ["\xF3\xB0\x9F\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x7A"],
        ["\x8A\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x96"],

        ["\xF3\xB0\x9F\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x7B"],
        ["\x8A\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x97"],

        ["\xF3\xB0\x9F\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x7C"],
        ["\x8A\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x98"],

        ["\xF3\xB0\x9F\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x7D"],
        ["\x8A\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x99"],

        ["\xF3\xB0\x9F\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x7E"],
        ["\x8A\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9A"],

        ["\xF3\xB0\x9F\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x80"],
        ["\x8A\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9B"],

        ["\xF3\xB0\x9F\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x81"],
        ["\x8A\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9C"],

        ["\xF3\xB0\x9F\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x82"],
        ["\x8A\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9D"],

        ["\xF3\xB0\x9F\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x83"],
        ["\x8A\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9E"],

        ["\xF3\xB0\x9F\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x84"],
        ["\x8A\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9F"],

        ["\xF3\xB0\x9F\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x85"],
        ["\x8A\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA0"],

        ["\xF3\xB0\x9F\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x86"],
        ["\x8A\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA1"],

        ["\xF3\xB0\x9F\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x87"],
        ["\x8A\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA2"],

        ["\xF3\xB0\x9F\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x88"],
        ["\x8A\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA3"],

        ["\xF3\xB0\x9F\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x89"],
        ["\x8A\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA4"],

        ["\xF3\xB0\x9F\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8A"],
        ["\x8A\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA5"],

        ["\xF3\xB0\x9F\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8B"],
        ["\x8A\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA6"],

        ["\xF3\xB0\x9F\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8C"],
        ["\x8A\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA7"],

        ["\xF3\xB0\x9F\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8D"],
        ["\x8A\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA8"],

        ["\xF3\xB0\x9F\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8E"],
        ["\x8A\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA9"],

        ["\xF3\xB0\x9F\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8F"],
        ["\x8A\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAA"],

        ["\xF3\xB0\x9F\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x90"],
        ["\x8A\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAB"],

        ["\xF3\xB0\x9F\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x91"],
        ["\x8A\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAC"],

        ["\xF3\xB0\x9F\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x92"],
        ["\x8A\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAD"],

        ["\xF3\xB0\x9F\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x93"],
        ["\x8A\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAE"],

        ["\xF3\xB0\x9F\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x94"],
        ["\x8A\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAF"],

        ["\xF3\xB0\x9F\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x95"],
        ["\x8A\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB0"],

        ["\xF3\xB0\x9F\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x96"],
        ["\x8A\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB1"],

        ["\xF3\xB0\x9F\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x97"],
        ["\x8A\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB2"],

        ["\xF3\xB0\x9F\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x98"],
        ["\x8A\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB3"],

        ["\xF3\xB0\x9F\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x99"],
        ["\x8A\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB4"],

        ["\xF3\xB0\x9F\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9A"],
        ["\x8A\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB5"],

        ["\xF3\xB0\x9F\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9B"],
        ["\x8A\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB6"],

        ["\xF3\xB0\x9F\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9C"],
        ["\x8A\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB7"],

        ["\xF3\xB0\x9F\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9D"],
        ["\x8A\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB8"],

        ["\xF3\xB0\x9F\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9E"],
        ["\x8A\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB9"],

        ["\xF3\xB0\x9F\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x9F"],
        ["\x8A\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBA"],

        ["\xF3\xB0\x9F\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA0"],
        ["\x8A\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBB"],

        ["\xF3\xB0\x9F\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA1"],
        ["\x8A\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBC"],

        ["\xF3\xB0\x9F\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA2"],
        ["\x8A\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBD"],

        ["\xF3\xB0\x9F\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA3"],
        ["\x8A\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBE"],

        ["\xF3\xB0\x9F\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA4"],
        ["\x8A\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBF"],

        ["\xF3\xB0\xA0\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA5"],
        ["\x8A\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x80"],

        ["\xF3\xB0\xA0\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA6"],
        ["\x8A\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x81"],

        ["\xF3\xB0\xA0\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA7"],
        ["\x8A\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x82"],

        ["\xF3\xB0\xA0\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA8"],
        ["\x8A\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x83"],

        ["\xF3\xB0\xA0\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA9"],
        ["\x8A\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x84"],

        ["\xF3\xB0\xA0\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAA"],
        ["\x8A\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x85"],

        ["\xF3\xB0\xA0\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAB"],
        ["\x8A\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x86"],

        ["\xF3\xB0\xA0\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAC"],
        ["\x8A\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x87"],

        ["\xF3\xB0\xA0\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAD"],
        ["\x8A\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x88"],

        ["\xF3\xB0\xA0\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAE"],
        ["\x8A\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x89"],

        ["\xF3\xB0\xA0\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAF"],
        ["\x8A\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8A"],

        ["\xF3\xB0\xA0\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB0"],
        ["\x8A\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8B"],

        ["\xF3\xB0\xA0\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB1"],
        ["\x8A\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8C"],

        ["\xF3\xB0\xA0\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB2"],
        ["\x8A\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8D"],

        ["\xF3\xB0\xA0\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB3"],
        ["\x8A\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8E"],

        ["\xF3\xB0\xA0\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB4"],
        ["\x8A\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8F"],

        ["\xF3\xB0\xA0\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB5"],
        ["\x8A\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x90"],

        ["\xF3\xB0\xA0\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB6"],
        ["\x8A\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x91"],

        ["\xF3\xB0\xA0\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB7"],
        ["\x8A\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x92"],

        ["\xF3\xB0\xA0\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB8"],
        ["\x8A\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x93"],

        ["\xF3\xB0\xA0\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xB9"],
        ["\x8A\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x94"],

        ["\xF3\xB0\xA0\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBA"],
        ["\x8A\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x95"],

        ["\xF3\xB0\xA0\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBB"],
        ["\x8A\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x96"],

        ["\xF3\xB0\xA0\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBC"],
        ["\x8A\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x97"],

        ["\xF3\xB0\xA0\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBD"],
        ["\x8A\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x98"],

        ["\xF3\xB0\xA0\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBE"],
        ["\x8A\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x99"],

        ["\xF3\xB0\xA0\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBF"],
        ["\x8A\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9A"],

        ["\xF3\xB0\xA0\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC0"],
        ["\x8A\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9B"],

        ["\xF3\xB0\xA0\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC1"],
        ["\x8A\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9C"],

        ["\xF3\xB0\xA0\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC2"],
        ["\x8A\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9D"],

        ["\xF3\xB0\xA0\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC3"],
        ["\x8A\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9E"],

        ["\xF3\xB0\xA0\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC4"],
        ["\x8A\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9F"],

        ["\xF3\xB0\xA0\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC5"],
        ["\x8A\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA0"],

        ["\xF3\xB0\xA0\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC6"],
        ["\x8A\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA1"],

        ["\xF3\xB0\xA0\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC7"],
        ["\x8A\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA2"],

        ["\xF3\xB0\xA0\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC8"],
        ["\x8A\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA3"],

        ["\xF3\xB0\xA0\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xC9"],
        ["\x8A\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA4"],

        ["\xF3\xB0\xA0\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCA"],
        ["\x8A\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA5"],

        ["\xF3\xB0\xA0\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCB"],
        ["\x8A\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA6"],

        ["\xF3\xB0\xA0\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCC"],
        ["\x8A\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA7"],

        ["\xF3\xB0\xA0\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCD"],
        ["\x8A\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA8"],

        ["\xF3\xB0\xA0\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCE"],
        ["\x8A\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA9"],

        ["\xF3\xB0\xA0\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCF"],
        ["\x8A\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAA"],

        ["\xF3\xB0\xA0\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD0"],
        ["\x8A\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAB"],

        ["\xF3\xB0\xA0\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD1"],
        ["\x8A\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAC"],

        ["\xF3\xB0\xA0\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD2"],
        ["\x8A\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAD"],

        ["\xF3\xB0\xA0\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD3"],
        ["\x8A\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAE"],

        ["\xF3\xB0\xA0\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD4"],
        ["\x8A\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAF"],

        ["\xF3\xB0\xA0\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD5"],
        ["\x8A\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB0"],

        ["\xF3\xB0\xA0\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD6"],
        ["\x8A\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB1"],

        ["\xF3\xB0\xA0\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD7"],
        ["\x8A\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB2"],

        ["\xF3\xB0\xA0\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD8"],
        ["\x8A\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB3"],

        ["\xF3\xB0\xA0\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xD9"],
        ["\x8A\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB4"],

        ["\xF3\xB0\xA0\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDA"],
        ["\x8A\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB5"],

        ["\xF3\xB0\xA0\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDB"],
        ["\x8A\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB6"],

        ["\xF3\xB0\xA0\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDC"],
        ["\x8A\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB7"],

        ["\xF3\xB0\xA0\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDD"],
        ["\x8A\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB8"],

        ["\xF3\xB0\xA0\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDE"],
        ["\x8A\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB9"],

        ["\xF3\xB0\xA0\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDF"],
        ["\x8A\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBA"],

        ["\xF3\xB0\xA0\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE0"],
        ["\x8A\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBB"],

        ["\xF3\xB0\xA0\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE1"],
        ["\x8A\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBC"],

        ["\xF3\xB0\xA0\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE2"],
        ["\x8A\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBD"],

        ["\xF3\xB0\xA0\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE3"],
        ["\x8A\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBE"],

        ["\xF3\xB0\xA0\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE4"],
        ["\x8A\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBF"],

        ["\xF3\xB0\xA1\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE5"],
        ["\x8A\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x80"],

        ["\xF3\xB0\xA1\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE6"],
        ["\x8A\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x81"],

        ["\xF3\xB0\xA1\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE7"],
        ["\x8A\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x82"],

        ["\xF3\xB0\xA1\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE8"],
        ["\x8A\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x83"],

        ["\xF3\xB0\xA1\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xE9"],
        ["\x8A\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x84"],

        ["\xF3\xB0\xA1\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEA"],
        ["\x8A\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x85"],

        ["\xF3\xB0\xA1\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEB"],
        ["\x8A\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x86"],

        ["\xF3\xB0\xA1\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEC"],
        ["\x8A\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x87"],

        ["\xF3\xB0\xA1\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xED"],
        ["\x8A\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x88"],

        ["\xF3\xB0\xA1\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEE"],
        ["\x8A\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x89"],

        ["\xF3\xB0\xA1\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEF"],
        ["\x8A\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8A"],

        ["\xF3\xB0\xA1\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF0"],
        ["\x8A\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8B"],

        ["\xF3\xB0\xA1\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF1"],
        ["\x8A\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8C"],

        ["\xF3\xB0\xA1\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF2"],
        ["\x8A\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8D"],

        ["\xF3\xB0\xA1\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF3"],
        ["\x8A\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8E"],

        ["\xF3\xB0\xA1\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF4"],
        ["\x8A\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8F"],

        ["\xF3\xB0\xA1\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF5"],
        ["\x8A\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x90"],

        ["\xF3\xB0\xA1\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF6"],
        ["\x8A\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x91"],

        ["\xF3\xB0\xA1\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF7"],
        ["\x8A\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x92"],

        ["\xF3\xB0\xA1\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF8"],
        ["\x8A\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x93"],

        ["\xF3\xB0\xA1\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xF9"],
        ["\x8A\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x94"],

        ["\xF3\xB0\xA1\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xFA"],
        ["\x8A\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x95"],

        ["\xF3\xB0\xA1\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xFB"],
        ["\x8A\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x96"],

        ["\xF3\xB0\xA1\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xFC"],
        ["\x8A\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x97"],

        ["\xF3\xB0\xA1\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x40"],
        ["\x8B\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x98"],

        ["\xF3\xB0\xA1\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x41"],
        ["\x8B\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x99"],

        ["\xF3\xB0\xA1\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x42"],
        ["\x8B\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9A"],

        ["\xF3\xB0\xA1\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x43"],
        ["\x8B\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9B"],

        ["\xF3\xB0\xA1\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x44"],
        ["\x8B\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9C"],

        ["\xF3\xB0\xA1\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x45"],
        ["\x8B\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9D"],

        ["\xF3\xB0\xA1\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x46"],
        ["\x8B\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9E"],

        ["\xF3\xB0\xA1\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x47"],
        ["\x8B\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9F"],

        ["\xF3\xB0\xA1\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x48"],
        ["\x8B\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA0"],

        ["\xF3\xB0\xA1\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x49"],
        ["\x8B\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA1"],

        ["\xF3\xB0\xA1\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4A"],
        ["\x8B\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA2"],

        ["\xF3\xB0\xA1\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4B"],
        ["\x8B\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA3"],

        ["\xF3\xB0\xA1\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4C"],
        ["\x8B\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA4"],

        ["\xF3\xB0\xA1\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4D"],
        ["\x8B\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA5"],

        ["\xF3\xB0\xA1\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4E"],
        ["\x8B\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA6"],

        ["\xF3\xB0\xA1\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x4F"],
        ["\x8B\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA7"],

        ["\xF3\xB0\xA1\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x50"],
        ["\x8B\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA8"],

        ["\xF3\xB0\xA1\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x51"],
        ["\x8B\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA9"],

        ["\xF3\xB0\xA1\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x52"],
        ["\x8B\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAA"],

        ["\xF3\xB0\xA1\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x53"],
        ["\x8B\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAB"],

        ["\xF3\xB0\xA1\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x54"],
        ["\x8B\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAC"],

        ["\xF3\xB0\xA1\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x55"],
        ["\x8B\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAD"],

        ["\xF3\xB0\xA1\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x56"],
        ["\x8B\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAE"],

        ["\xF3\xB0\xA1\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x57"],
        ["\x8B\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAF"],

        ["\xF3\xB0\xA1\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x58"],
        ["\x8B\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB0"],

        ["\xF3\xB0\xA1\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x59"],
        ["\x8B\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB1"],

        ["\xF3\xB0\xA1\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5A"],
        ["\x8B\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB2"],

        ["\xF3\xB0\xA1\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5B"],
        ["\x8B\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB3"],

        ["\xF3\xB0\xA1\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5C"],
        ["\x8B\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB4"],

        ["\xF3\xB0\xA1\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5D"],
        ["\x8B\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB5"],

        ["\xF3\xB0\xA1\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5E"],
        ["\x8B\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB6"],

        ["\xF3\xB0\xA1\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x5F"],
        ["\x8B\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB7"],

        ["\xF3\xB0\xA1\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x60"],
        ["\x8B\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB8"],

        ["\xF3\xB0\xA1\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x61"],
        ["\x8B\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB9"],

        ["\xF3\xB0\xA1\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x62"],
        ["\x8B\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBA"],

        ["\xF3\xB0\xA1\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x63"],
        ["\x8B\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBB"],

        ["\xF3\xB0\xA1\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x64"],
        ["\x8B\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBC"],

        ["\xF3\xB0\xA1\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x65"],
        ["\x8B\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBD"],

        ["\xF3\xB0\xA1\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x66"],
        ["\x8B\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBE"],

        ["\xF3\xB0\xA1\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x67"],
        ["\x8B\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBF"],

        ["\xF3\xB0\xA2\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x68"],
        ["\x8B\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x80"],

        ["\xF3\xB0\xA2\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x69"],
        ["\x8B\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x81"],

        ["\xF3\xB0\xA2\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6A"],
        ["\x8B\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x82"],

        ["\xF3\xB0\xA2\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6B"],
        ["\x8B\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x83"],

        ["\xF3\xB0\xA2\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6C"],
        ["\x8B\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x84"],

        ["\xF3\xB0\xA2\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6D"],
        ["\x8B\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x85"],

        ["\xF3\xB0\xA2\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6E"],
        ["\x8B\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x86"],

        ["\xF3\xB0\xA2\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x6F"],
        ["\x8B\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x87"],

        ["\xF3\xB0\xA2\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x70"],
        ["\x8B\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x88"],

        ["\xF3\xB0\xA2\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x71"],
        ["\x8B\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x89"],

        ["\xF3\xB0\xA2\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x72"],
        ["\x8B\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8A"],

        ["\xF3\xB0\xA2\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x73"],
        ["\x8B\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8B"],

        ["\xF3\xB0\xA2\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x74"],
        ["\x8B\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8C"],

        ["\xF3\xB0\xA2\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x75"],
        ["\x8B\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8D"],

        ["\xF3\xB0\xA2\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x76"],
        ["\x8B\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8E"],

        ["\xF3\xB0\xA2\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x77"],
        ["\x8B\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8F"],

        ["\xF3\xB0\xA2\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x78"],
        ["\x8B\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x90"],

        ["\xF3\xB0\xA2\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x79"],
        ["\x8B\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x91"],

        ["\xF3\xB0\xA2\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x7A"],
        ["\x8B\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x92"],

        ["\xF3\xB0\xA2\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x7B"],
        ["\x8B\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x93"],

        ["\xF3\xB0\xA2\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x7C"],
        ["\x8B\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x94"],

        ["\xF3\xB0\xA2\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x7D"],
        ["\x8B\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x95"],

        ["\xF3\xB0\xA2\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x7E"],
        ["\x8B\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x96"],

        ["\xF3\xB0\xA2\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x80"],
        ["\x8B\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x97"],

        ["\xF3\xB0\xA2\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x81"],
        ["\x8B\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x98"],

        ["\xF3\xB0\xA2\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x82"],
        ["\x8B\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x99"],

        ["\xF3\xB0\xA2\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x83"],
        ["\x8B\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9A"],

        ["\xF3\xB0\xA2\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x84"],
        ["\x8B\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9B"],

        ["\xF3\xB0\xA2\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x85"],
        ["\x8B\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9C"],

        ["\xF3\xB0\xA2\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x86"],
        ["\x8B\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9D"],

        ["\xF3\xB0\xA2\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x87"],
        ["\x8B\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9E"],

        ["\xF3\xB0\xA2\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x88"],
        ["\x8B\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9F"],

        ["\xF3\xB0\xA2\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x89"],
        ["\x8B\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA0"],

        ["\xF3\xB0\xA2\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8A"],
        ["\x8B\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA1"],

        ["\xF3\xB0\xA2\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8B"],
        ["\x8B\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA2"],

        ["\xF3\xB0\xA2\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8C"],
        ["\x8B\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA3"],

        ["\xF3\xB0\xA2\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8D"],
        ["\x8B\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA4"],

        ["\xF3\xB0\xA2\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8E"],
        ["\x8B\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA5"],

        ["\xF3\xB0\xA2\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x8F"],
        ["\x8B\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA6"],

        ["\xF3\xB0\xA2\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x90"],
        ["\x8B\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA7"],

        ["\xF3\xB0\xA2\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x91"],
        ["\x8B\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA8"],

        ["\xF3\xB0\xA2\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x92"],
        ["\x8B\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA9"],

        ["\xF3\xB0\xA2\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x93"],
        ["\x8B\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAA"],

        ["\xF3\xB0\xA2\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x94"],
        ["\x8B\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAB"],

        ["\xF3\xB0\xA2\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x95"],
        ["\x8B\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAC"],

        ["\xF3\xB0\xA2\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x96"],
        ["\x8B\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAD"],

        ["\xF3\xB0\xA2\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x97"],
        ["\x8B\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAE"],

        ["\xF3\xB0\xA2\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x98"],
        ["\x8B\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAF"],

        ["\xF3\xB0\xA2\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x99"],
        ["\x8B\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB0"],

        ["\xF3\xB0\xA2\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9A"],
        ["\x8B\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB1"],

        ["\xF3\xB0\xA2\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9B"],
        ["\x8B\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB2"],

        ["\xF3\xB0\xA2\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9C"],
        ["\x8B\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB3"],

        ["\xF3\xB0\xA2\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9D"],
        ["\x8B\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB4"],

        ["\xF3\xB0\xA2\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9E"],
        ["\x8B\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB5"],

        ["\xF3\xB0\xA2\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\x9F"],
        ["\x8B\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB6"],

        ["\xF3\xB0\xA2\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA0"],
        ["\x8B\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB7"],

        ["\xF3\xB0\xA2\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA1"],
        ["\x8B\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB8"],

        ["\xF3\xB0\xA2\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA2"],
        ["\x8B\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB9"],

        ["\xF3\xB0\xA2\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA3"],
        ["\x8B\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBA"],

        ["\xF3\xB0\xA2\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA4"],
        ["\x8B\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBB"],

        ["\xF3\xB0\xA2\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA5"],
        ["\x8B\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBC"],

        ["\xF3\xB0\xA2\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA6"],
        ["\x8B\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBD"],

        ["\xF3\xB0\xA2\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA7"],
        ["\x8B\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBE"],

        ["\xF3\xB0\xA2\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA8"],
        ["\x8B\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBF"],

        ["\xF3\xB0\xA3\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xA9"],
        ["\x8B\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x80"],

        ["\xF3\xB0\xA3\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAA"],
        ["\x8B\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x81"],

        ["\xF3\xB0\xA3\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAB"],
        ["\x8B\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x82"],

        ["\xF3\xB0\xA3\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAC"],
        ["\x8B\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x83"],

        ["\xF3\xB0\xA3\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAD"],
        ["\x8B\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x84"],

        ["\xF3\xB0\xA3\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAE"],
        ["\x8B\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x85"],

        ["\xF3\xB0\xA3\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xAF"],
        ["\x8B\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x86"],

        ["\xF3\xB0\xA3\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB0"],
        ["\x8B\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x87"],

        ["\xF3\xB0\xA3\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB1"],
        ["\x8B\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x88"],

        ["\xF3\xB0\xA3\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB2"],
        ["\x8B\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x89"],

        ["\xF3\xB0\xA3\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB3"],
        ["\x8B\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8A"],

        ["\xF3\xB0\xA3\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB4"],
        ["\x8B\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8B"],

        ["\xF3\xB0\xA3\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB5"],
        ["\x8B\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8C"],

        ["\xF3\xB0\xA3\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB6"],
        ["\x8B\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8D"],

        ["\xF3\xB0\xA3\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB7"],
        ["\x8B\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8E"],

        ["\xF3\xB0\xA3\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB8"],
        ["\x8B\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8F"],

        ["\xF3\xB0\xA3\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xB9"],
        ["\x8B\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x90"],

        ["\xF3\xB0\xA3\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBA"],
        ["\x8B\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x91"],

        ["\xF3\xB0\xA3\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBB"],
        ["\x8B\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x92"],

        ["\xF3\xB0\xA3\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBC"],
        ["\x8B\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x93"],

        ["\xF3\xB0\xA3\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBD"],
        ["\x8B\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x94"],

        ["\xF3\xB0\xA3\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBE"],
        ["\x8B\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x95"],

        ["\xF3\xB0\xA3\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xBF"],
        ["\x8B\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x96"],

        ["\xF3\xB0\xA3\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC0"],
        ["\x8B\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x97"],

        ["\xF3\xB0\xA3\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC1"],
        ["\x8B\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x98"],

        ["\xF3\xB0\xA3\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC2"],
        ["\x8B\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x99"],

        ["\xF3\xB0\xA3\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC3"],
        ["\x8B\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9A"],

        ["\xF3\xB0\xA3\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC4"],
        ["\x8B\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9B"],

        ["\xF3\xB0\xA3\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC5"],
        ["\x8B\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9C"],

        ["\xF3\xB0\xA3\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC6"],
        ["\x8B\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9D"],

        ["\xF3\xB0\xA3\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC7"],
        ["\x8B\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9E"],

        ["\xF3\xB0\xA3\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC8"],
        ["\x8B\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9F"],

        ["\xF3\xB0\xA3\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xC9"],
        ["\x8B\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA0"],

        ["\xF3\xB0\xA3\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCA"],
        ["\x8B\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA1"],

        ["\xF3\xB0\xA3\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCB"],
        ["\x8B\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA2"],

        ["\xF3\xB0\xA3\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCC"],
        ["\x8B\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA3"],

        ["\xF3\xB0\xA3\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCD"],
        ["\x8B\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA4"],

        ["\xF3\xB0\xA3\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCE"],
        ["\x8B\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA5"],

        ["\xF3\xB0\xA3\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xCF"],
        ["\x8B\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA6"],

        ["\xF3\xB0\xA3\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD0"],
        ["\x8B\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA7"],

        ["\xF3\xB0\xA3\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD1"],
        ["\x8B\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA8"],

        ["\xF3\xB0\xA3\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD2"],
        ["\x8B\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA9"],

        ["\xF3\xB0\xA3\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD3"],
        ["\x8B\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAA"],

        ["\xF3\xB0\xA3\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD4"],
        ["\x8B\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAB"],

        ["\xF3\xB0\xA3\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD5"],
        ["\x8B\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAC"],

        ["\xF3\xB0\xA3\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD6"],
        ["\x8B\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAD"],

        ["\xF3\xB0\xA3\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD7"],
        ["\x8B\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAE"],

        ["\xF3\xB0\xA3\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD8"],
        ["\x8B\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAF"],

        ["\xF3\xB0\xA3\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xD9"],
        ["\x8B\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB0"],

        ["\xF3\xB0\xA3\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDA"],
        ["\x8B\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB1"],

        ["\xF3\xB0\xA3\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDB"],
        ["\x8B\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB2"],

        ["\xF3\xB0\xA3\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDC"],
        ["\x8B\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB3"],

        ["\xF3\xB0\xA3\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDD"],
        ["\x8B\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB4"],

        ["\xF3\xB0\xA3\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDE"],
        ["\x8B\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB5"],

        ["\xF3\xB0\xA3\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xDF"],
        ["\x8B\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB6"],

        ["\xF3\xB0\xA3\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE0"],
        ["\x8B\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB7"],

        ["\xF3\xB0\xA3\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE1"],
        ["\x8B\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB8"],

        ["\xF3\xB0\xA3\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE2"],
        ["\x8B\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB9"],

        ["\xF3\xB0\xA3\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE3"],
        ["\x8B\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBA"],

        ["\xF3\xB0\xA3\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE4"],
        ["\x8B\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBB"],

        ["\xF3\xB0\xA3\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE5"],
        ["\x8B\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBC"],

        ["\xF3\xB0\xA3\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE6"],
        ["\x8B\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBD"],

        ["\xF3\xB0\xA3\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE7"],
        ["\x8B\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBE"],

        ["\xF3\xB0\xA3\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE8"],
        ["\x8B\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBF"],

        ["\xF3\xB0\xA4\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xE9"],
        ["\x8B\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x80"],

        ["\xF3\xB0\xA4\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xEA"],
        ["\x8B\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x81"],

        ["\xF3\xB0\xA4\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xEB"],
        ["\x8B\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x82"],

        ["\xF3\xB0\xA4\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xEC"],
        ["\x8B\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x83"],

        ["\xF3\xB0\xA4\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xED"],
        ["\x8B\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x84"],

        ["\xF3\xB0\xA4\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xEE"],
        ["\x8B\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x85"],

        ["\xF3\xB0\xA4\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xEF"],
        ["\x8B\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x86"],

        ["\xF3\xB0\xA4\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF0"],
        ["\x8B\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x87"],

        ["\xF3\xB0\xA4\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF1"],
        ["\x8B\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x88"],

        ["\xF3\xB0\xA4\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF2"],
        ["\x8B\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x89"],

        ["\xF3\xB0\xA4\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF3"],
        ["\x8B\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8A"],

        ["\xF3\xB0\xA4\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF4"],
        ["\x8B\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8B"],

        ["\xF3\xB0\xA4\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF5"],
        ["\x8B\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8C"],

        ["\xF3\xB0\xA4\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF6"],
        ["\x8B\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8D"],

        ["\xF3\xB0\xA4\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF7"],
        ["\x8B\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8E"],

        ["\xF3\xB0\xA4\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF8"],
        ["\x8B\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8F"],

        ["\xF3\xB0\xA4\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xF9"],
        ["\x8B\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x90"],

        ["\xF3\xB0\xA4\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xFA"],
        ["\x8B\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x91"],

        ["\xF3\xB0\xA4\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xFB"],
        ["\x8B\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x92"],

        ["\xF3\xB0\xA4\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B\xFC"],
        ["\x8B\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x93"],

        ["\xF3\xB0\xA4\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x40"],
        ["\x8C\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x94"],

        ["\xF3\xB0\xA4\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x41"],
        ["\x8C\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x95"],

        ["\xF3\xB0\xA4\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x42"],
        ["\x8C\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x96"],

        ["\xF3\xB0\xA4\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x43"],
        ["\x8C\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x97"],

        ["\xF3\xB0\xA4\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x44"],
        ["\x8C\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x98"],

        ["\xF3\xB0\xA4\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x45"],
        ["\x8C\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x99"],

        ["\xF3\xB0\xA4\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x46"],
        ["\x8C\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9A"],

        ["\xF3\xB0\xA4\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x47"],
        ["\x8C\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9B"],

        ["\xF3\xB0\xA4\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x48"],
        ["\x8C\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9C"],

        ["\xF3\xB0\xA4\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x49"],
        ["\x8C\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9D"],

        ["\xF3\xB0\xA4\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4A"],
        ["\x8C\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9E"],

        ["\xF3\xB0\xA4\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4B"],
        ["\x8C\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9F"],

        ["\xF3\xB0\xA4\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4C"],
        ["\x8C\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA0"],

        ["\xF3\xB0\xA4\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4D"],
        ["\x8C\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA1"],

        ["\xF3\xB0\xA4\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4E"],
        ["\x8C\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA2"],

        ["\xF3\xB0\xA4\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x4F"],
        ["\x8C\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA3"],

        ["\xF3\xB0\xA4\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x50"],
        ["\x8C\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA4"],

        ["\xF3\xB0\xA4\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x51"],
        ["\x8C\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA5"],

        ["\xF3\xB0\xA4\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x52"],
        ["\x8C\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA6"],

        ["\xF3\xB0\xA4\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x53"],
        ["\x8C\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA7"],

        ["\xF3\xB0\xA4\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x54"],
        ["\x8C\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA8"],

        ["\xF3\xB0\xA4\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x55"],
        ["\x8C\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA9"],

        ["\xF3\xB0\xA4\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x56"],
        ["\x8C\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAA"],

        ["\xF3\xB0\xA4\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x57"],
        ["\x8C\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAB"],

        ["\xF3\xB0\xA4\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x58"],
        ["\x8C\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAC"],

        ["\xF3\xB0\xA4\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x59"],
        ["\x8C\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAD"],

        ["\xF3\xB0\xA4\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5A"],
        ["\x8C\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAE"],

        ["\xF3\xB0\xA4\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5B"],
        ["\x8C\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAF"],

        ["\xF3\xB0\xA4\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5C"],
        ["\x8C\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB0"],

        ["\xF3\xB0\xA4\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5D"],
        ["\x8C\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB1"],

        ["\xF3\xB0\xA4\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5E"],
        ["\x8C\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB2"],

        ["\xF3\xB0\xA4\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x5F"],
        ["\x8C\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB3"],

        ["\xF3\xB0\xA4\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x60"],
        ["\x8C\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB4"],

        ["\xF3\xB0\xA4\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x61"],
        ["\x8C\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB5"],

        ["\xF3\xB0\xA4\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x62"],
        ["\x8C\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB6"],

        ["\xF3\xB0\xA4\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x63"],
        ["\x8C\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB7"],

        ["\xF3\xB0\xA4\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x64"],
        ["\x8C\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB8"],

        ["\xF3\xB0\xA4\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x65"],
        ["\x8C\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB9"],

        ["\xF3\xB0\xA4\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x66"],
        ["\x8C\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBA"],

        ["\xF3\xB0\xA4\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x67"],
        ["\x8C\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBB"],

        ["\xF3\xB0\xA4\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x68"],
        ["\x8C\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBC"],

        ["\xF3\xB0\xA4\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x69"],
        ["\x8C\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBD"],

        ["\xF3\xB0\xA4\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6A"],
        ["\x8C\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBE"],

        ["\xF3\xB0\xA4\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6B"],
        ["\x8C\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBF"],

        ["\xF3\xB0\xA5\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6C"],
        ["\x8C\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x80"],

        ["\xF3\xB0\xA5\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6D"],
        ["\x8C\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x81"],

        ["\xF3\xB0\xA5\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6E"],
        ["\x8C\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x82"],

        ["\xF3\xB0\xA5\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x6F"],
        ["\x8C\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x83"],

        ["\xF3\xB0\xA5\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x70"],
        ["\x8C\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x84"],

        ["\xF3\xB0\xA5\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x71"],
        ["\x8C\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x85"],

        ["\xF3\xB0\xA5\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x72"],
        ["\x8C\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x86"],

        ["\xF3\xB0\xA5\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x73"],
        ["\x8C\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x87"],

        ["\xF3\xB0\xA5\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x74"],
        ["\x8C\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x88"],

        ["\xF3\xB0\xA5\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x75"],
        ["\x8C\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x89"],

        ["\xF3\xB0\xA5\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x76"],
        ["\x8C\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8A"],

        ["\xF3\xB0\xA5\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x77"],
        ["\x8C\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8B"],

        ["\xF3\xB0\xA5\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x78"],
        ["\x8C\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8C"],

        ["\xF3\xB0\xA5\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x79"],
        ["\x8C\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8D"],

        ["\xF3\xB0\xA5\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x7A"],
        ["\x8C\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8E"],

        ["\xF3\xB0\xA5\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x7B"],
        ["\x8C\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8F"],

        ["\xF3\xB0\xA5\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x7C"],
        ["\x8C\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x90"],

        ["\xF3\xB0\xA5\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x7D"],
        ["\x8C\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x91"],

        ["\xF3\xB0\xA5\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x7E"],
        ["\x8C\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x92"],

        ["\xF3\xB0\xA5\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x80"],
        ["\x8C\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x93"],

        ["\xF3\xB0\xA5\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x81"],
        ["\x8C\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x94"],

        ["\xF3\xB0\xA5\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x82"],
        ["\x8C\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x95"],

        ["\xF3\xB0\xA5\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x83"],
        ["\x8C\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x96"],

        ["\xF3\xB0\xA5\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x84"],
        ["\x8C\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x97"],

        ["\xF3\xB0\xA5\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x85"],
        ["\x8C\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x98"],

        ["\xF3\xB0\xA5\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x86"],
        ["\x8C\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x99"],

        ["\xF3\xB0\xA5\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x87"],
        ["\x8C\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9A"],

        ["\xF3\xB0\xA5\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x88"],
        ["\x8C\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9B"],

        ["\xF3\xB0\xA5\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x89"],
        ["\x8C\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9C"],

        ["\xF3\xB0\xA5\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8A"],
        ["\x8C\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9D"],

        ["\xF3\xB0\xA5\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8B"],
        ["\x8C\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9E"],

        ["\xF3\xB0\xA5\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8C"],
        ["\x8C\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9F"],

        ["\xF3\xB0\xA5\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8D"],
        ["\x8C\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA0"],

        ["\xF3\xB0\xA5\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8E"],
        ["\x8C\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA1"],

        ["\xF3\xB0\xA5\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8F"],
        ["\x8C\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA2"],

        ["\xF3\xB0\xA5\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x90"],
        ["\x8C\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA3"],

        ["\xF3\xB0\xA5\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x91"],
        ["\x8C\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA4"],

        ["\xF3\xB0\xA5\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x92"],
        ["\x8C\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA5"],

        ["\xF3\xB0\xA5\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x93"],
        ["\x8C\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA6"],

        ["\xF3\xB0\xA5\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x94"],
        ["\x8C\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA7"],

        ["\xF3\xB0\xA5\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x95"],
        ["\x8C\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA8"],

        ["\xF3\xB0\xA5\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x96"],
        ["\x8C\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA9"],

        ["\xF3\xB0\xA5\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x97"],
        ["\x8C\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAA"],

        ["\xF3\xB0\xA5\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x98"],
        ["\x8C\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAB"],

        ["\xF3\xB0\xA5\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x99"],
        ["\x8C\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAC"],

        ["\xF3\xB0\xA5\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9A"],
        ["\x8C\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAD"],

        ["\xF3\xB0\xA5\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9B"],
        ["\x8C\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAE"],

        ["\xF3\xB0\xA5\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9C"],
        ["\x8C\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAF"],

        ["\xF3\xB0\xA5\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9D"],
        ["\x8C\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB0"],

        ["\xF3\xB0\xA5\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9E"],
        ["\x8C\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB1"],

        ["\xF3\xB0\xA5\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9F"],
        ["\x8C\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB2"],

        ["\xF3\xB0\xA5\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA0"],
        ["\x8C\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB3"],

        ["\xF3\xB0\xA5\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA1"],
        ["\x8C\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB4"],

        ["\xF3\xB0\xA5\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA2"],
        ["\x8C\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB5"],

        ["\xF3\xB0\xA5\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA3"],
        ["\x8C\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB6"],

        ["\xF3\xB0\xA5\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA4"],
        ["\x8C\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB7"],

        ["\xF3\xB0\xA5\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA5"],
        ["\x8C\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB8"],

        ["\xF3\xB0\xA5\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA6"],
        ["\x8C\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB9"],

        ["\xF3\xB0\xA5\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA7"],
        ["\x8C\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBA"],

        ["\xF3\xB0\xA5\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA8"],
        ["\x8C\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBB"],

        ["\xF3\xB0\xA5\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA9"],
        ["\x8C\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBC"],

        ["\xF3\xB0\xA5\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAA"],
        ["\x8C\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBD"],

        ["\xF3\xB0\xA5\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAB"],
        ["\x8C\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBE"],

        ["\xF3\xB0\xA5\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAC"],
        ["\x8C\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBF"],

        ["\xF3\xB0\xA6\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAD"],
        ["\x8C\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x80"],

        ["\xF3\xB0\xA6\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAE"],
        ["\x8C\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x81"],

        ["\xF3\xB0\xA6\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAF"],
        ["\x8C\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x82"],

        ["\xF3\xB0\xA6\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB0"],
        ["\x8C\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x83"],

        ["\xF3\xB0\xA6\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB1"],
        ["\x8C\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x84"],

        ["\xF3\xB0\xA6\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB2"],
        ["\x8C\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x85"],

        ["\xF3\xB0\xA6\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB3"],
        ["\x8C\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x86"],

        ["\xF3\xB0\xA6\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB4"],
        ["\x8C\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x87"],

        ["\xF3\xB0\xA6\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB5"],
        ["\x8C\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x88"],

        ["\xF3\xB0\xA6\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB6"],
        ["\x8C\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x89"],

        ["\xF3\xB0\xA6\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB7"],
        ["\x8C\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8A"],

        ["\xF3\xB0\xA6\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB8"],
        ["\x8C\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8B"],

        ["\xF3\xB0\xA6\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB9"],
        ["\x8C\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8C"],

        ["\xF3\xB0\xA6\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBA"],
        ["\x8C\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8D"],

        ["\xF3\xB0\xA6\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBB"],
        ["\x8C\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8E"],

        ["\xF3\xB0\xA6\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBC"],
        ["\x8C\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8F"],

        ["\xF3\xB0\xA6\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBD"],
        ["\x8C\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x90"],

        ["\xF3\xB0\xA6\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBE"],
        ["\x8C\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x91"],

        ["\xF3\xB0\xA6\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBF"],
        ["\x8C\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x92"],

        ["\xF3\xB0\xA6\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC0"],
        ["\x8C\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x93"],

        ["\xF3\xB0\xA6\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC1"],
        ["\x8C\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x94"],

        ["\xF3\xB0\xA6\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC2"],
        ["\x8C\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x95"],

        ["\xF3\xB0\xA6\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC3"],
        ["\x8C\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x96"],

        ["\xF3\xB0\xA6\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC4"],
        ["\x8C\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x97"],

        ["\xF3\xB0\xA6\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC5"],
        ["\x8C\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x98"],

        ["\xF3\xB0\xA6\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC6"],
        ["\x8C\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x99"],

        ["\xF3\xB0\xA6\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC7"],
        ["\x8C\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9A"],

        ["\xF3\xB0\xA6\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC8"],
        ["\x8C\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9B"],

        ["\xF3\xB0\xA6\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xC9"],
        ["\x8C\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9C"],

        ["\xF3\xB0\xA6\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCA"],
        ["\x8C\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9D"],

        ["\xF3\xB0\xA6\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCB"],
        ["\x8C\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9E"],

        ["\xF3\xB0\xA6\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCC"],
        ["\x8C\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9F"],

        ["\xF3\xB0\xA6\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCD"],
        ["\x8C\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA0"],

        ["\xF3\xB0\xA6\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCE"],
        ["\x8C\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA1"],

        ["\xF3\xB0\xA6\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCF"],
        ["\x8C\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA2"],

        ["\xF3\xB0\xA6\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD0"],
        ["\x8C\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA3"],

        ["\xF3\xB0\xA6\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD1"],
        ["\x8C\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA4"],

        ["\xF3\xB0\xA6\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD2"],
        ["\x8C\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA5"],

        ["\xF3\xB0\xA6\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD3"],
        ["\x8C\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA6"],

        ["\xF3\xB0\xA6\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD4"],
        ["\x8C\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA7"],

        ["\xF3\xB0\xA6\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD5"],
        ["\x8C\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA8"],

        ["\xF3\xB0\xA6\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD6"],
        ["\x8C\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA9"],

        ["\xF3\xB0\xA6\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD7"],
        ["\x8C\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAA"],

        ["\xF3\xB0\xA6\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD8"],
        ["\x8C\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAB"],

        ["\xF3\xB0\xA6\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xD9"],
        ["\x8C\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAC"],

        ["\xF3\xB0\xA6\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDA"],
        ["\x8C\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAD"],

        ["\xF3\xB0\xA6\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDB"],
        ["\x8C\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAE"],

        ["\xF3\xB0\xA6\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDC"],
        ["\x8C\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAF"],

        ["\xF3\xB0\xA6\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDD"],
        ["\x8C\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB0"],

        ["\xF3\xB0\xA6\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDE"],
        ["\x8C\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB1"],

        ["\xF3\xB0\xA6\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDF"],
        ["\x8C\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB2"],

        ["\xF3\xB0\xA6\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE0"],
        ["\x8C\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB3"],

        ["\xF3\xB0\xA6\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE1"],
        ["\x8C\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB4"],

        ["\xF3\xB0\xA6\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE2"],
        ["\x8C\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB5"],

        ["\xF3\xB0\xA6\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE3"],
        ["\x8C\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB6"],

        ["\xF3\xB0\xA6\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE4"],
        ["\x8C\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB7"],

        ["\xF3\xB0\xA6\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE5"],
        ["\x8C\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB8"],

        ["\xF3\xB0\xA6\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE6"],
        ["\x8C\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB9"],

        ["\xF3\xB0\xA6\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE7"],
        ["\x8C\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBA"],

        ["\xF3\xB0\xA6\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE8"],
        ["\x8C\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBB"],

        ["\xF3\xB0\xA6\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xE9"],
        ["\x8C\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBC"],

        ["\xF3\xB0\xA6\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEA"],
        ["\x8C\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBD"],

        ["\xF3\xB0\xA6\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEB"],
        ["\x8C\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBE"],

        ["\xF3\xB0\xA6\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEC"],
        ["\x8C\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBF"],

        ["\xF3\xB0\xA7\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xED"],
        ["\x8C\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x80"],

        ["\xF3\xB0\xA7\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEE"],
        ["\x8C\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x81"],

        ["\xF3\xB0\xA7\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEF"],
        ["\x8C\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x82"],

        ["\xF3\xB0\xA7\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF0"],
        ["\x8C\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x83"],

        ["\xF3\xB0\xA7\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF1"],
        ["\x8C\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x84"],

        ["\xF3\xB0\xA7\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF2"],
        ["\x8C\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x85"],

        ["\xF3\xB0\xA7\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF3"],
        ["\x8C\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x86"],

        ["\xF3\xB0\xA7\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF4"],
        ["\x8C\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x87"],

        ["\xF3\xB0\xA7\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF5"],
        ["\x8C\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x88"],

        ["\xF3\xB0\xA7\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF6"],
        ["\x8C\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x89"],

        ["\xF3\xB0\xA7\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF7"],
        ["\x8C\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8A"],

        ["\xF3\xB0\xA7\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF8"],
        ["\x8C\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8B"],

        ["\xF3\xB0\xA7\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xF9"],
        ["\x8C\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8C"],

        ["\xF3\xB0\xA7\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xFA"],
        ["\x8C\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8D"],

        ["\xF3\xB0\xA7\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xFB"],
        ["\x8C\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8E"],

        ["\xF3\xB0\xA7\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xFC"],
        ["\x8C\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8F"],

        ["\xF3\xB0\xA7\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x40"],
        ["\x8D\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x90"],

        ["\xF3\xB0\xA7\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x41"],
        ["\x8D\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x91"],

        ["\xF3\xB0\xA7\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x42"],
        ["\x8D\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x92"],

        ["\xF3\xB0\xA7\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x43"],
        ["\x8D\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x93"],

        ["\xF3\xB0\xA7\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x44"],
        ["\x8D\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x94"],

        ["\xF3\xB0\xA7\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x45"],
        ["\x8D\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x95"],

        ["\xF3\xB0\xA7\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x46"],
        ["\x8D\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x96"],

        ["\xF3\xB0\xA7\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x47"],
        ["\x8D\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x97"],

        ["\xF3\xB0\xA7\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x48"],
        ["\x8D\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x98"],

        ["\xF3\xB0\xA7\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x49"],
        ["\x8D\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x99"],

        ["\xF3\xB0\xA7\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4A"],
        ["\x8D\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9A"],

        ["\xF3\xB0\xA7\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4B"],
        ["\x8D\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9B"],

        ["\xF3\xB0\xA7\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4C"],
        ["\x8D\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9C"],

        ["\xF3\xB0\xA7\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4D"],
        ["\x8D\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9D"],

        ["\xF3\xB0\xA7\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4E"],
        ["\x8D\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9E"],

        ["\xF3\xB0\xA7\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x4F"],
        ["\x8D\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9F"],

        ["\xF3\xB0\xA7\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x50"],
        ["\x8D\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA0"],

        ["\xF3\xB0\xA7\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x51"],
        ["\x8D\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA1"],

        ["\xF3\xB0\xA7\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x52"],
        ["\x8D\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA2"],

        ["\xF3\xB0\xA7\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x53"],
        ["\x8D\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA3"],

        ["\xF3\xB0\xA7\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x54"],
        ["\x8D\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA4"],

        ["\xF3\xB0\xA7\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x55"],
        ["\x8D\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA5"],

        ["\xF3\xB0\xA7\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x56"],
        ["\x8D\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA6"],

        ["\xF3\xB0\xA7\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x57"],
        ["\x8D\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA7"],

        ["\xF3\xB0\xA7\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x58"],
        ["\x8D\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA8"],

        ["\xF3\xB0\xA7\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x59"],
        ["\x8D\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA9"],

        ["\xF3\xB0\xA7\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5A"],
        ["\x8D\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAA"],

        ["\xF3\xB0\xA7\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5B"],
        ["\x8D\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAB"],

        ["\xF3\xB0\xA7\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5C"],
        ["\x8D\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAC"],

        ["\xF3\xB0\xA7\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5D"],
        ["\x8D\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAD"],

        ["\xF3\xB0\xA7\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5E"],
        ["\x8D\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAE"],

        ["\xF3\xB0\xA7\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x5F"],
        ["\x8D\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAF"],

        ["\xF3\xB0\xA7\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x60"],
        ["\x8D\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB0"],

        ["\xF3\xB0\xA7\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x61"],
        ["\x8D\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB1"],

        ["\xF3\xB0\xA7\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x62"],
        ["\x8D\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB2"],

        ["\xF3\xB0\xA7\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x63"],
        ["\x8D\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB3"],

        ["\xF3\xB0\xA7\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x64"],
        ["\x8D\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB4"],

        ["\xF3\xB0\xA7\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x65"],
        ["\x8D\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB5"],

        ["\xF3\xB0\xA7\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x66"],
        ["\x8D\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB6"],

        ["\xF3\xB0\xA7\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x67"],
        ["\x8D\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB7"],

        ["\xF3\xB0\xA7\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x68"],
        ["\x8D\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB8"],

        ["\xF3\xB0\xA7\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x69"],
        ["\x8D\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB9"],

        ["\xF3\xB0\xA7\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6A"],
        ["\x8D\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBA"],

        ["\xF3\xB0\xA7\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6B"],
        ["\x8D\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBB"],

        ["\xF3\xB0\xA7\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6C"],
        ["\x8D\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBC"],

        ["\xF3\xB0\xA7\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6D"],
        ["\x8D\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBD"],

        ["\xF3\xB0\xA7\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6E"],
        ["\x8D\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBE"],

        ["\xF3\xB0\xA7\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x6F"],
        ["\x8D\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBF"],

        ["\xF3\xB0\xA8\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x70"],
        ["\x8D\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x80"],

        ["\xF3\xB0\xA8\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x71"],
        ["\x8D\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x81"],

        ["\xF3\xB0\xA8\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x72"],
        ["\x8D\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x82"],

        ["\xF3\xB0\xA8\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x73"],
        ["\x8D\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x83"],

        ["\xF3\xB0\xA8\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x74"],
        ["\x8D\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x84"],

        ["\xF3\xB0\xA8\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x75"],
        ["\x8D\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x85"],

        ["\xF3\xB0\xA8\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x76"],
        ["\x8D\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x86"],

        ["\xF3\xB0\xA8\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x77"],
        ["\x8D\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x87"],

        ["\xF3\xB0\xA8\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x78"],
        ["\x8D\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x88"],

        ["\xF3\xB0\xA8\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x79"],
        ["\x8D\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x89"],

        ["\xF3\xB0\xA8\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x7A"],
        ["\x8D\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8A"],

        ["\xF3\xB0\xA8\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x7B"],
        ["\x8D\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8B"],

        ["\xF3\xB0\xA8\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x7C"],
        ["\x8D\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8C"],

        ["\xF3\xB0\xA8\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x7D"],
        ["\x8D\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8D"],

        ["\xF3\xB0\xA8\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x7E"],
        ["\x8D\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8E"],

        ["\xF3\xB0\xA8\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x80"],
        ["\x8D\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8F"],

        ["\xF3\xB0\xA8\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x81"],
        ["\x8D\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x90"],

        ["\xF3\xB0\xA8\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x82"],
        ["\x8D\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x91"],

        ["\xF3\xB0\xA8\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x83"],
        ["\x8D\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x92"],

        ["\xF3\xB0\xA8\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x84"],
        ["\x8D\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x93"],

        ["\xF3\xB0\xA8\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x85"],
        ["\x8D\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x94"],

        ["\xF3\xB0\xA8\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x86"],
        ["\x8D\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x95"],

        ["\xF3\xB0\xA8\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x87"],
        ["\x8D\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x96"],

        ["\xF3\xB0\xA8\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x88"],
        ["\x8D\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x97"],

        ["\xF3\xB0\xA8\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x89"],
        ["\x8D\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x98"],

        ["\xF3\xB0\xA8\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8A"],
        ["\x8D\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x99"],

        ["\xF3\xB0\xA8\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8B"],
        ["\x8D\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9A"],

        ["\xF3\xB0\xA8\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8C"],
        ["\x8D\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9B"],

        ["\xF3\xB0\xA8\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8D"],
        ["\x8D\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9C"],

        ["\xF3\xB0\xA8\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8E"],
        ["\x8D\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9D"],

        ["\xF3\xB0\xA8\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8F"],
        ["\x8D\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9E"],

        ["\xF3\xB0\xA8\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x90"],
        ["\x8D\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9F"],

        ["\xF3\xB0\xA8\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x91"],
        ["\x8D\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA0"],

        ["\xF3\xB0\xA8\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x92"],
        ["\x8D\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA1"],

        ["\xF3\xB0\xA8\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x93"],
        ["\x8D\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA2"],

        ["\xF3\xB0\xA8\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x94"],
        ["\x8D\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA3"],

        ["\xF3\xB0\xA8\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x95"],
        ["\x8D\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA4"],

        ["\xF3\xB0\xA8\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x96"],
        ["\x8D\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA5"],

        ["\xF3\xB0\xA8\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x97"],
        ["\x8D\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA6"],

        ["\xF3\xB0\xA8\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x98"],
        ["\x8D\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA7"],

        ["\xF3\xB0\xA8\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x99"],
        ["\x8D\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA8"],

        ["\xF3\xB0\xA8\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9A"],
        ["\x8D\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA9"],

        ["\xF3\xB0\xA8\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9B"],
        ["\x8D\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAA"],

        ["\xF3\xB0\xA8\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9C"],
        ["\x8D\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAB"],

        ["\xF3\xB0\xA8\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9D"],
        ["\x8D\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAC"],

        ["\xF3\xB0\xA8\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9E"],
        ["\x8D\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAD"],

        ["\xF3\xB0\xA8\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9F"],
        ["\x8D\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAE"],

        ["\xF3\xB0\xA8\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA0"],
        ["\x8D\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAF"],

        ["\xF3\xB0\xA8\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA1"],
        ["\x8D\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB0"],

        ["\xF3\xB0\xA8\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA2"],
        ["\x8D\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB1"],

        ["\xF3\xB0\xA8\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA3"],
        ["\x8D\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB2"],

        ["\xF3\xB0\xA8\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA4"],
        ["\x8D\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB3"],

        ["\xF3\xB0\xA8\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA5"],
        ["\x8D\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB4"],

        ["\xF3\xB0\xA8\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA6"],
        ["\x8D\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB5"],

        ["\xF3\xB0\xA8\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA7"],
        ["\x8D\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB6"],

        ["\xF3\xB0\xA8\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA8"],
        ["\x8D\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB7"],

        ["\xF3\xB0\xA8\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA9"],
        ["\x8D\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB8"],

        ["\xF3\xB0\xA8\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAA"],
        ["\x8D\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB9"],

        ["\xF3\xB0\xA8\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAB"],
        ["\x8D\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBA"],

        ["\xF3\xB0\xA8\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAC"],
        ["\x8D\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBB"],

        ["\xF3\xB0\xA8\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAD"],
        ["\x8D\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBC"],

        ["\xF3\xB0\xA8\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAE"],
        ["\x8D\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBD"],

        ["\xF3\xB0\xA8\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAF"],
        ["\x8D\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBE"],

        ["\xF3\xB0\xA8\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB0"],
        ["\x8D\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBF"],

        ["\xF3\xB0\xA9\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB1"],
        ["\x8D\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x80"],

        ["\xF3\xB0\xA9\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB2"],
        ["\x8D\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x81"],

        ["\xF3\xB0\xA9\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB3"],
        ["\x8D\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x82"],

        ["\xF3\xB0\xA9\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB4"],
        ["\x8D\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x83"],

        ["\xF3\xB0\xA9\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB5"],
        ["\x8D\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x84"],

        ["\xF3\xB0\xA9\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB6"],
        ["\x8D\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x85"],

        ["\xF3\xB0\xA9\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB7"],
        ["\x8D\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x86"],

        ["\xF3\xB0\xA9\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB8"],
        ["\x8D\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x87"],

        ["\xF3\xB0\xA9\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB9"],
        ["\x8D\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x88"],

        ["\xF3\xB0\xA9\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBA"],
        ["\x8D\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x89"],

        ["\xF3\xB0\xA9\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBB"],
        ["\x8D\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8A"],

        ["\xF3\xB0\xA9\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBC"],
        ["\x8D\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8B"],

        ["\xF3\xB0\xA9\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBD"],
        ["\x8D\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8C"],

        ["\xF3\xB0\xA9\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBE"],
        ["\x8D\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8D"],

        ["\xF3\xB0\xA9\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBF"],
        ["\x8D\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8E"],

        ["\xF3\xB0\xA9\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC0"],
        ["\x8D\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8F"],

        ["\xF3\xB0\xA9\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC1"],
        ["\x8D\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x90"],

        ["\xF3\xB0\xA9\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC2"],
        ["\x8D\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x91"],

        ["\xF3\xB0\xA9\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC3"],
        ["\x8D\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x92"],

        ["\xF3\xB0\xA9\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC4"],
        ["\x8D\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x93"],

        ["\xF3\xB0\xA9\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC5"],
        ["\x8D\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x94"],

        ["\xF3\xB0\xA9\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC6"],
        ["\x8D\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x95"],

        ["\xF3\xB0\xA9\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC7"],
        ["\x8D\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x96"],

        ["\xF3\xB0\xA9\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC8"],
        ["\x8D\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x97"],

        ["\xF3\xB0\xA9\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xC9"],
        ["\x8D\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x98"],

        ["\xF3\xB0\xA9\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCA"],
        ["\x8D\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x99"],

        ["\xF3\xB0\xA9\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCB"],
        ["\x8D\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9A"],

        ["\xF3\xB0\xA9\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCC"],
        ["\x8D\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9B"],

        ["\xF3\xB0\xA9\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCD"],
        ["\x8D\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9C"],

        ["\xF3\xB0\xA9\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCE"],
        ["\x8D\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9D"],

        ["\xF3\xB0\xA9\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCF"],
        ["\x8D\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9E"],

        ["\xF3\xB0\xA9\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD0"],
        ["\x8D\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9F"],

        ["\xF3\xB0\xA9\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD1"],
        ["\x8D\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA0"],

        ["\xF3\xB0\xA9\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD2"],
        ["\x8D\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA1"],

        ["\xF3\xB0\xA9\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD3"],
        ["\x8D\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA2"],

        ["\xF3\xB0\xA9\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD4"],
        ["\x8D\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA3"],

        ["\xF3\xB0\xA9\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD5"],
        ["\x8D\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA4"],

        ["\xF3\xB0\xA9\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD6"],
        ["\x8D\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA5"],

        ["\xF3\xB0\xA9\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD7"],
        ["\x8D\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA6"],

        ["\xF3\xB0\xA9\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD8"],
        ["\x8D\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA7"],

        ["\xF3\xB0\xA9\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xD9"],
        ["\x8D\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA8"],

        ["\xF3\xB0\xA9\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDA"],
        ["\x8D\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA9"],

        ["\xF3\xB0\xA9\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDB"],
        ["\x8D\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAA"],

        ["\xF3\xB0\xA9\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDC"],
        ["\x8D\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAB"],

        ["\xF3\xB0\xA9\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDD"],
        ["\x8D\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAC"],

        ["\xF3\xB0\xA9\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDE"],
        ["\x8D\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAD"],

        ["\xF3\xB0\xA9\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDF"],
        ["\x8D\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAE"],

        ["\xF3\xB0\xA9\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE0"],
        ["\x8D\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAF"],

        ["\xF3\xB0\xA9\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE1"],
        ["\x8D\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB0"],

        ["\xF3\xB0\xA9\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE2"],
        ["\x8D\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB1"],

        ["\xF3\xB0\xA9\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE3"],
        ["\x8D\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB2"],

        ["\xF3\xB0\xA9\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE4"],
        ["\x8D\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB3"],

        ["\xF3\xB0\xA9\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE5"],
        ["\x8D\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB4"],

        ["\xF3\xB0\xA9\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE6"],
        ["\x8D\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB5"],

        ["\xF3\xB0\xA9\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE7"],
        ["\x8D\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB6"],

        ["\xF3\xB0\xA9\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE8"],
        ["\x8D\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB7"],

        ["\xF3\xB0\xA9\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xE9"],
        ["\x8D\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB8"],

        ["\xF3\xB0\xA9\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEA"],
        ["\x8D\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB9"],

        ["\xF3\xB0\xA9\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEB"],
        ["\x8D\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBA"],

        ["\xF3\xB0\xA9\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEC"],
        ["\x8D\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBB"],

        ["\xF3\xB0\xA9\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xED"],
        ["\x8D\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBC"],

        ["\xF3\xB0\xA9\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEE"],
        ["\x8D\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBD"],

        ["\xF3\xB0\xA9\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEF"],
        ["\x8D\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBE"],

        ["\xF3\xB0\xA9\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF0"],
        ["\x8D\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBF"],

        ["\xF3\xB0\xAA\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF1"],
        ["\x8D\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x80"],

        ["\xF3\xB0\xAA\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF2"],
        ["\x8D\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x81"],

        ["\xF3\xB0\xAA\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF3"],
        ["\x8D\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x82"],

        ["\xF3\xB0\xAA\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF4"],
        ["\x8D\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x83"],

        ["\xF3\xB0\xAA\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF5"],
        ["\x8D\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x84"],

        ["\xF3\xB0\xAA\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF6"],
        ["\x8D\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x85"],

        ["\xF3\xB0\xAA\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF7"],
        ["\x8D\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x86"],

        ["\xF3\xB0\xAA\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF8"],
        ["\x8D\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x87"],

        ["\xF3\xB0\xAA\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xF9"],
        ["\x8D\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x88"],

        ["\xF3\xB0\xAA\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xFA"],
        ["\x8D\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x89"],

        ["\xF3\xB0\xAA\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xFB"],
        ["\x8D\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8A"],

        ["\xF3\xB0\xAA\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xFC"],
        ["\x8D\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8B"],

        ["\xF3\xB0\xAA\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x40"],
        ["\x8E\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8C"],

        ["\xF3\xB0\xAA\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x41"],
        ["\x8E\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8D"],

        ["\xF3\xB0\xAA\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x42"],
        ["\x8E\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8E"],

        ["\xF3\xB0\xAA\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x43"],
        ["\x8E\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8F"],

        ["\xF3\xB0\xAA\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x44"],
        ["\x8E\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x90"],

        ["\xF3\xB0\xAA\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x45"],
        ["\x8E\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x91"],

        ["\xF3\xB0\xAA\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x46"],
        ["\x8E\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x92"],

        ["\xF3\xB0\xAA\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x47"],
        ["\x8E\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x93"],

        ["\xF3\xB0\xAA\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x48"],
        ["\x8E\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x94"],

        ["\xF3\xB0\xAA\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x49"],
        ["\x8E\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x95"],

        ["\xF3\xB0\xAA\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4A"],
        ["\x8E\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x96"],

        ["\xF3\xB0\xAA\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4B"],
        ["\x8E\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x97"],

        ["\xF3\xB0\xAA\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4C"],
        ["\x8E\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x98"],

        ["\xF3\xB0\xAA\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4D"],
        ["\x8E\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x99"],

        ["\xF3\xB0\xAA\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4E"],
        ["\x8E\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9A"],

        ["\xF3\xB0\xAA\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x4F"],
        ["\x8E\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9B"],

        ["\xF3\xB0\xAA\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x50"],
        ["\x8E\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9C"],

        ["\xF3\xB0\xAA\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x51"],
        ["\x8E\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9D"],

        ["\xF3\xB0\xAA\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x52"],
        ["\x8E\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9E"],

        ["\xF3\xB0\xAA\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x53"],
        ["\x8E\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9F"],

        ["\xF3\xB0\xAA\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x54"],
        ["\x8E\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA0"],

        ["\xF3\xB0\xAA\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x55"],
        ["\x8E\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA1"],

        ["\xF3\xB0\xAA\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x56"],
        ["\x8E\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA2"],

        ["\xF3\xB0\xAA\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x57"],
        ["\x8E\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA3"],

        ["\xF3\xB0\xAA\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x58"],
        ["\x8E\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA4"],

        ["\xF3\xB0\xAA\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x59"],
        ["\x8E\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA5"],

        ["\xF3\xB0\xAA\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5A"],
        ["\x8E\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA6"],

        ["\xF3\xB0\xAA\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5B"],
        ["\x8E\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA7"],

        ["\xF3\xB0\xAA\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5C"],
        ["\x8E\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA8"],

        ["\xF3\xB0\xAA\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5D"],
        ["\x8E\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA9"],

        ["\xF3\xB0\xAA\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5E"],
        ["\x8E\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAA"],

        ["\xF3\xB0\xAA\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x5F"],
        ["\x8E\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAB"],

        ["\xF3\xB0\xAA\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x60"],
        ["\x8E\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAC"],

        ["\xF3\xB0\xAA\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x61"],
        ["\x8E\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAD"],

        ["\xF3\xB0\xAA\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x62"],
        ["\x8E\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAE"],

        ["\xF3\xB0\xAA\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x63"],
        ["\x8E\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAF"],

        ["\xF3\xB0\xAA\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x64"],
        ["\x8E\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB0"],

        ["\xF3\xB0\xAA\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x65"],
        ["\x8E\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB1"],

        ["\xF3\xB0\xAA\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x66"],
        ["\x8E\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB2"],

        ["\xF3\xB0\xAA\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x67"],
        ["\x8E\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB3"],

        ["\xF3\xB0\xAA\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x68"],
        ["\x8E\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB4"],

        ["\xF3\xB0\xAA\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x69"],
        ["\x8E\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB5"],

        ["\xF3\xB0\xAA\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6A"],
        ["\x8E\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB6"],

        ["\xF3\xB0\xAA\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6B"],
        ["\x8E\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB7"],

        ["\xF3\xB0\xAA\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6C"],
        ["\x8E\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB8"],

        ["\xF3\xB0\xAA\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6D"],
        ["\x8E\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB9"],

        ["\xF3\xB0\xAA\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6E"],
        ["\x8E\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBA"],

        ["\xF3\xB0\xAA\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x6F"],
        ["\x8E\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBB"],

        ["\xF3\xB0\xAA\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x70"],
        ["\x8E\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBC"],

        ["\xF3\xB0\xAA\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x71"],
        ["\x8E\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBD"],

        ["\xF3\xB0\xAA\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x72"],
        ["\x8E\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBE"],

        ["\xF3\xB0\xAA\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x73"],
        ["\x8E\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBF"],

        ["\xF3\xB0\xAB\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x74"],
        ["\x8E\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x80"],

        ["\xF3\xB0\xAB\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x75"],
        ["\x8E\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x81"],

        ["\xF3\xB0\xAB\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x76"],
        ["\x8E\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x82"],

        ["\xF3\xB0\xAB\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x77"],
        ["\x8E\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x83"],

        ["\xF3\xB0\xAB\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x78"],
        ["\x8E\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x84"],

        ["\xF3\xB0\xAB\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x79"],
        ["\x8E\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x85"],

        ["\xF3\xB0\xAB\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x7A"],
        ["\x8E\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x86"],

        ["\xF3\xB0\xAB\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x7B"],
        ["\x8E\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x87"],

        ["\xF3\xB0\xAB\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x7C"],
        ["\x8E\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x88"],

        ["\xF3\xB0\xAB\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x7D"],
        ["\x8E\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x89"],

        ["\xF3\xB0\xAB\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x7E"],
        ["\x8E\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8A"],

        ["\xF3\xB0\xAB\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x80"],
        ["\x8E\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8B"],

        ["\xF3\xB0\xAB\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x81"],
        ["\x8E\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8C"],

        ["\xF3\xB0\xAB\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x82"],
        ["\x8E\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8D"],

        ["\xF3\xB0\xAB\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x83"],
        ["\x8E\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8E"],

        ["\xF3\xB0\xAB\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x84"],
        ["\x8E\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8F"],

        ["\xF3\xB0\xAB\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x85"],
        ["\x8E\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x90"],

        ["\xF3\xB0\xAB\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],
        ["\x8E\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x91"],

        ["\xF3\xB0\xAB\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x87"],
        ["\x8E\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x92"],

        ["\xF3\xB0\xAB\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x88"],
        ["\x8E\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x93"],

        ["\xF3\xB0\xAB\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x89"],
        ["\x8E\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x94"],

        ["\xF3\xB0\xAB\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8A"],
        ["\x8E\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x95"],

        ["\xF3\xB0\xAB\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8B"],
        ["\x8E\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x96"],

        ["\xF3\xB0\xAB\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8C"],
        ["\x8E\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x97"],

        ["\xF3\xB0\xAB\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8D"],
        ["\x8E\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x98"],

        ["\xF3\xB0\xAB\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8E"],
        ["\x8E\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x99"],

        ["\xF3\xB0\xAB\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8F"],
        ["\x8E\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9A"],

        ["\xF3\xB0\xAB\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x90"],
        ["\x8E\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9B"],

        ["\xF3\xB0\xAB\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x91"],
        ["\x8E\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9C"],

        ["\xF3\xB0\xAB\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x92"],
        ["\x8E\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9D"],

        ["\xF3\xB0\xAB\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x93"],
        ["\x8E\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9E"],

        ["\xF3\xB0\xAB\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x94"],
        ["\x8E\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9F"],

        ["\xF3\xB0\xAB\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x95"],
        ["\x8E\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA0"],

        ["\xF3\xB0\xAB\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x96"],
        ["\x8E\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA1"],

        ["\xF3\xB0\xAB\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x97"],
        ["\x8E\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA2"],

        ["\xF3\xB0\xAB\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x98"],
        ["\x8E\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA3"],

        ["\xF3\xB0\xAB\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x99"],
        ["\x8E\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA4"],

        ["\xF3\xB0\xAB\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9A"],
        ["\x8E\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA5"],

        ["\xF3\xB0\xAB\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9B"],
        ["\x8E\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA6"],

        ["\xF3\xB0\xAB\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9C"],
        ["\x8E\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA7"],

        ["\xF3\xB0\xAB\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9D"],
        ["\x8E\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA8"],

        ["\xF3\xB0\xAB\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9E"],
        ["\x8E\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA9"],

        ["\xF3\xB0\xAB\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9F"],
        ["\x8E\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAA"],

        ["\xF3\xB0\xAB\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA0"],
        ["\x8E\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAB"],

        ["\xF3\xB0\xAB\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA1"],
        ["\x8E\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAC"],

        ["\xF3\xB0\xAB\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA2"],
        ["\x8E\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAD"],

        ["\xF3\xB0\xAB\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA3"],
        ["\x8E\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAE"],

        ["\xF3\xB0\xAB\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA4"],
        ["\x8E\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAF"],

        ["\xF3\xB0\xAB\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA5"],
        ["\x8E\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB0"],

        ["\xF3\xB0\xAB\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA6"],
        ["\x8E\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB1"],

        ["\xF3\xB0\xAB\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA7"],
        ["\x8E\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB2"],

        ["\xF3\xB0\xAB\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA8"],
        ["\x8E\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB3"],

        ["\xF3\xB0\xAB\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA9"],
        ["\x8E\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB4"],

        ["\xF3\xB0\xAB\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAA"],
        ["\x8E\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB5"],

        ["\xF3\xB0\xAB\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAB"],
        ["\x8E\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB6"],

        ["\xF3\xB0\xAB\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAC"],
        ["\x8E\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB7"],

        ["\xF3\xB0\xAB\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAD"],
        ["\x8E\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB8"],

        ["\xF3\xB0\xAB\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAE"],
        ["\x8E\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB9"],

        ["\xF3\xB0\xAB\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAF"],
        ["\x8E\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBA"],

        ["\xF3\xB0\xAB\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB0"],
        ["\x8E\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBB"],

        ["\xF3\xB0\xAB\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB1"],
        ["\x8E\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBC"],

        ["\xF3\xB0\xAB\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB2"],
        ["\x8E\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBD"],

        ["\xF3\xB0\xAB\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB3"],
        ["\x8E\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBE"],

        ["\xF3\xB0\xAB\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB4"],
        ["\x8E\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBF"],

        ["\xF3\xB0\xAC\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB5"],
        ["\x8E\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x80"],

        ["\xF3\xB0\xAC\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB6"],
        ["\x8E\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x81"],

        ["\xF3\xB0\xAC\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB7"],
        ["\x8E\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x82"],

        ["\xF3\xB0\xAC\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB8"],
        ["\x8E\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x83"],

        ["\xF3\xB0\xAC\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB9"],
        ["\x8E\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x84"],

        ["\xF3\xB0\xAC\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBA"],
        ["\x8E\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x85"],

        ["\xF3\xB0\xAC\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBB"],
        ["\x8E\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x86"],

        ["\xF3\xB0\xAC\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBC"],
        ["\x8E\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x87"],

        ["\xF3\xB0\xAC\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBD"],
        ["\x8E\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x88"],

        ["\xF3\xB0\xAC\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBE"],
        ["\x8E\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x89"],

        ["\xF3\xB0\xAC\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBF"],
        ["\x8E\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8A"],

        ["\xF3\xB0\xAC\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC0"],
        ["\x8E\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8B"],

        ["\xF3\xB0\xAC\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC1"],
        ["\x8E\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8C"],

        ["\xF3\xB0\xAC\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC2"],
        ["\x8E\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8D"],

        ["\xF3\xB0\xAC\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC3"],
        ["\x8E\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8E"],

        ["\xF3\xB0\xAC\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC4"],
        ["\x8E\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8F"],

        ["\xF3\xB0\xAC\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC5"],
        ["\x8E\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x90"],

        ["\xF3\xB0\xAC\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC6"],
        ["\x8E\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x91"],

        ["\xF3\xB0\xAC\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC7"],
        ["\x8E\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x92"],

        ["\xF3\xB0\xAC\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC8"],
        ["\x8E\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x93"],

        ["\xF3\xB0\xAC\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xC9"],
        ["\x8E\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x94"],

        ["\xF3\xB0\xAC\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCA"],
        ["\x8E\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x95"],

        ["\xF3\xB0\xAC\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCB"],
        ["\x8E\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x96"],

        ["\xF3\xB0\xAC\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCC"],
        ["\x8E\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x97"],

        ["\xF3\xB0\xAC\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCD"],
        ["\x8E\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x98"],

        ["\xF3\xB0\xAC\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCE"],
        ["\x8E\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x99"],

        ["\xF3\xB0\xAC\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCF"],
        ["\x8E\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9A"],

        ["\xF3\xB0\xAC\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD0"],
        ["\x8E\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9B"],

        ["\xF3\xB0\xAC\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD1"],
        ["\x8E\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9C"],

        ["\xF3\xB0\xAC\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD2"],
        ["\x8E\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9D"],

        ["\xF3\xB0\xAC\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD3"],
        ["\x8E\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9E"],

        ["\xF3\xB0\xAC\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD4"],
        ["\x8E\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9F"],

        ["\xF3\xB0\xAC\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD5"],
        ["\x8E\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA0"],

        ["\xF3\xB0\xAC\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD6"],
        ["\x8E\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA1"],

        ["\xF3\xB0\xAC\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD7"],
        ["\x8E\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA2"],

        ["\xF3\xB0\xAC\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD8"],
        ["\x8E\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA3"],

        ["\xF3\xB0\xAC\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xD9"],
        ["\x8E\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA4"],

        ["\xF3\xB0\xAC\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDA"],
        ["\x8E\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA5"],

        ["\xF3\xB0\xAC\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDB"],
        ["\x8E\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA6"],

        ["\xF3\xB0\xAC\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDC"],
        ["\x8E\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA7"],

        ["\xF3\xB0\xAC\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDD"],
        ["\x8E\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA8"],

        ["\xF3\xB0\xAC\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDE"],
        ["\x8E\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA9"],

        ["\xF3\xB0\xAC\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDF"],
        ["\x8E\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAA"],

        ["\xF3\xB0\xAC\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE0"],
        ["\x8E\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAB"],

        ["\xF3\xB0\xAC\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE1"],
        ["\x8E\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAC"],

        ["\xF3\xB0\xAC\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE2"],
        ["\x8E\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAD"],

        ["\xF3\xB0\xAC\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE3"],
        ["\x8E\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAE"],

        ["\xF3\xB0\xAC\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE4"],
        ["\x8E\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAF"],

        ["\xF3\xB0\xAC\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE5"],
        ["\x8E\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB0"],

        ["\xF3\xB0\xAC\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE6"],
        ["\x8E\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB1"],

        ["\xF3\xB0\xAC\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE7"],
        ["\x8E\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB2"],

        ["\xF3\xB0\xAC\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE8"],
        ["\x8E\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB3"],

        ["\xF3\xB0\xAC\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xE9"],
        ["\x8E\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB4"],

        ["\xF3\xB0\xAC\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xEA"],
        ["\x8E\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB5"],

        ["\xF3\xB0\xAC\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xEB"],
        ["\x8E\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB6"],

        ["\xF3\xB0\xAC\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xEC"],
        ["\x8E\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB7"],

        ["\xF3\xB0\xAC\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xED"],
        ["\x8E\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB8"],

        ["\xF3\xB0\xAC\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xEE"],
        ["\x8E\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB9"],

        ["\xF3\xB0\xAC\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xEF"],
        ["\x8E\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBA"],

        ["\xF3\xB0\xAC\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF0"],
        ["\x8E\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBB"],

        ["\xF3\xB0\xAC\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF1"],
        ["\x8E\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBC"],

        ["\xF3\xB0\xAC\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF2"],
        ["\x8E\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBD"],

        ["\xF3\xB0\xAC\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF3"],
        ["\x8E\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBE"],

        ["\xF3\xB0\xAC\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF4"],
        ["\x8E\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBF"],

        ["\xF3\xB0\xAD\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF5"],
        ["\x8E\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x80"],

        ["\xF3\xB0\xAD\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF6"],
        ["\x8E\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x81"],

        ["\xF3\xB0\xAD\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF7"],
        ["\x8E\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x82"],

        ["\xF3\xB0\xAD\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF8"],
        ["\x8E\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x83"],

        ["\xF3\xB0\xAD\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xF9"],
        ["\x8E\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x84"],

        ["\xF3\xB0\xAD\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xFA"],
        ["\x8E\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x85"],

        ["\xF3\xB0\xAD\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xFB"],
        ["\x8E\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x86"],

        ["\xF3\xB0\xAD\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xFC"],
        ["\x8E\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x87"],

        ["\xF3\xB0\xAD\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x40"],
        ["\x8F\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x88"],

        ["\xF3\xB0\xAD\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x41"],
        ["\x8F\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x89"],

        ["\xF3\xB0\xAD\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x42"],
        ["\x8F\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8A"],

        ["\xF3\xB0\xAD\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x43"],
        ["\x8F\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8B"],

        ["\xF3\xB0\xAD\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x44"],
        ["\x8F\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8C"],

        ["\xF3\xB0\xAD\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x45"],
        ["\x8F\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8D"],

        ["\xF3\xB0\xAD\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x46"],
        ["\x8F\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8E"],

        ["\xF3\xB0\xAD\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x47"],
        ["\x8F\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8F"],

        ["\xF3\xB0\xAD\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x48"],
        ["\x8F\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x90"],

        ["\xF3\xB0\xAD\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x49"],
        ["\x8F\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x91"],

        ["\xF3\xB0\xAD\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4A"],
        ["\x8F\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x92"],

        ["\xF3\xB0\xAD\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4B"],
        ["\x8F\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x93"],

        ["\xF3\xB0\xAD\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4C"],
        ["\x8F\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x94"],

        ["\xF3\xB0\xAD\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4D"],
        ["\x8F\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x95"],

        ["\xF3\xB0\xAD\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4E"],
        ["\x8F\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x96"],

        ["\xF3\xB0\xAD\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x4F"],
        ["\x8F\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x97"],

        ["\xF3\xB0\xAD\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x50"],
        ["\x8F\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x98"],

        ["\xF3\xB0\xAD\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x51"],
        ["\x8F\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x99"],

        ["\xF3\xB0\xAD\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x52"],
        ["\x8F\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9A"],

        ["\xF3\xB0\xAD\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x53"],
        ["\x8F\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9B"],

        ["\xF3\xB0\xAD\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x54"],
        ["\x8F\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9C"],

        ["\xF3\xB0\xAD\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x55"],
        ["\x8F\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9D"],

        ["\xF3\xB0\xAD\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x56"],
        ["\x8F\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9E"],

        ["\xF3\xB0\xAD\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x57"],
        ["\x8F\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9F"],

        ["\xF3\xB0\xAD\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x58"],
        ["\x8F\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA0"],

        ["\xF3\xB0\xAD\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x59"],
        ["\x8F\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA1"],

        ["\xF3\xB0\xAD\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5A"],
        ["\x8F\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA2"],

        ["\xF3\xB0\xAD\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5B"],
        ["\x8F\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA3"],

        ["\xF3\xB0\xAD\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5C"],
        ["\x8F\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA4"],

        ["\xF3\xB0\xAD\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5D"],
        ["\x8F\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA5"],

        ["\xF3\xB0\xAD\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5E"],
        ["\x8F\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA6"],

        ["\xF3\xB0\xAD\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x5F"],
        ["\x8F\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA7"],

        ["\xF3\xB0\xAD\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x60"],
        ["\x8F\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA8"],

        ["\xF3\xB0\xAD\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x61"],
        ["\x8F\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA9"],

        ["\xF3\xB0\xAD\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x62"],
        ["\x8F\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAA"],

        ["\xF3\xB0\xAD\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x63"],
        ["\x8F\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAB"],

        ["\xF3\xB0\xAD\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x64"],
        ["\x8F\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAC"],

        ["\xF3\xB0\xAD\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x65"],
        ["\x8F\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAD"],

        ["\xF3\xB0\xAD\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x66"],
        ["\x8F\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAE"],

        ["\xF3\xB0\xAD\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x67"],
        ["\x8F\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAF"],

        ["\xF3\xB0\xAD\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x68"],
        ["\x8F\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB0"],

        ["\xF3\xB0\xAD\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x69"],
        ["\x8F\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB1"],

        ["\xF3\xB0\xAD\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6A"],
        ["\x8F\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB2"],

        ["\xF3\xB0\xAD\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6B"],
        ["\x8F\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB3"],

        ["\xF3\xB0\xAD\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6C"],
        ["\x8F\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB4"],

        ["\xF3\xB0\xAD\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6D"],
        ["\x8F\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB5"],

        ["\xF3\xB0\xAD\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6E"],
        ["\x8F\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB6"],

        ["\xF3\xB0\xAD\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x6F"],
        ["\x8F\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB7"],

        ["\xF3\xB0\xAD\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x70"],
        ["\x8F\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB8"],

        ["\xF3\xB0\xAD\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x71"],
        ["\x8F\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB9"],

        ["\xF3\xB0\xAD\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x72"],
        ["\x8F\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBA"],

        ["\xF3\xB0\xAD\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x73"],
        ["\x8F\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBB"],

        ["\xF3\xB0\xAD\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x74"],
        ["\x8F\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBC"],

        ["\xF3\xB0\xAD\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x75"],
        ["\x8F\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBD"],

        ["\xF3\xB0\xAD\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x76"],
        ["\x8F\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBE"],

        ["\xF3\xB0\xAD\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x77"],
        ["\x8F\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBF"],

        ["\xF3\xB0\xAE\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x78"],
        ["\x8F\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x80"],

        ["\xF3\xB0\xAE\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x79"],
        ["\x8F\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x81"],

        ["\xF3\xB0\xAE\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x7A"],
        ["\x8F\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x82"],

        ["\xF3\xB0\xAE\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x7B"],
        ["\x8F\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x83"],

        ["\xF3\xB0\xAE\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x7C"],
        ["\x8F\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x84"],

        ["\xF3\xB0\xAE\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x7D"],
        ["\x8F\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x85"],

        ["\xF3\xB0\xAE\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x7E"],
        ["\x8F\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x86"],

        ["\xF3\xB0\xAE\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x80"],
        ["\x8F\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x87"],

        ["\xF3\xB0\xAE\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x81"],
        ["\x8F\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x88"],

        ["\xF3\xB0\xAE\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x82"],
        ["\x8F\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x89"],

        ["\xF3\xB0\xAE\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x83"],
        ["\x8F\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8A"],

        ["\xF3\xB0\xAE\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x84"],
        ["\x8F\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8B"],

        ["\xF3\xB0\xAE\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x85"],
        ["\x8F\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8C"],

        ["\xF3\xB0\xAE\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x86"],
        ["\x8F\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8D"],

        ["\xF3\xB0\xAE\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x87"],
        ["\x8F\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8E"],

        ["\xF3\xB0\xAE\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x88"],
        ["\x8F\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8F"],

        ["\xF3\xB0\xAE\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x89"],
        ["\x8F\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x90"],

        ["\xF3\xB0\xAE\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8A"],
        ["\x8F\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x91"],

        ["\xF3\xB0\xAE\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8B"],
        ["\x8F\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x92"],

        ["\xF3\xB0\xAE\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8C"],
        ["\x8F\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x93"],

        ["\xF3\xB0\xAE\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8D"],
        ["\x8F\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x94"],

        ["\xF3\xB0\xAE\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8E"],
        ["\x8F\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x95"],

        ["\xF3\xB0\xAE\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8F"],
        ["\x8F\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x96"],

        ["\xF3\xB0\xAE\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x90"],
        ["\x8F\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x97"],

        ["\xF3\xB0\xAE\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x91"],
        ["\x8F\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x98"],

        ["\xF3\xB0\xAE\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x92"],
        ["\x8F\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x99"],

        ["\xF3\xB0\xAE\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x93"],
        ["\x8F\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9A"],

        ["\xF3\xB0\xAE\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x94"],
        ["\x8F\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9B"],

        ["\xF3\xB0\xAE\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x95"],
        ["\x8F\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9C"],

        ["\xF3\xB0\xAE\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x96"],
        ["\x8F\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9D"],

        ["\xF3\xB0\xAE\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x97"],
        ["\x8F\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9E"],

        ["\xF3\xB0\xAE\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x98"],
        ["\x8F\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9F"],

        ["\xF3\xB0\xAE\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x99"],
        ["\x8F\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA0"],

        ["\xF3\xB0\xAE\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9A"],
        ["\x8F\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA1"],

        ["\xF3\xB0\xAE\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9B"],
        ["\x8F\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA2"],

        ["\xF3\xB0\xAE\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9C"],
        ["\x8F\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA3"],

        ["\xF3\xB0\xAE\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9D"],
        ["\x8F\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA4"],

        ["\xF3\xB0\xAE\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9E"],
        ["\x8F\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA5"],

        ["\xF3\xB0\xAE\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9F"],
        ["\x8F\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA6"],

        ["\xF3\xB0\xAE\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA0"],
        ["\x8F\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA7"],

        ["\xF3\xB0\xAE\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA1"],
        ["\x8F\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA8"],

        ["\xF3\xB0\xAE\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA2"],
        ["\x8F\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA9"],

        ["\xF3\xB0\xAE\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA3"],
        ["\x8F\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAA"],

        ["\xF3\xB0\xAE\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA4"],
        ["\x8F\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAB"],

        ["\xF3\xB0\xAE\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA5"],
        ["\x8F\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAC"],

        ["\xF3\xB0\xAE\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA6"],
        ["\x8F\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAD"],

        ["\xF3\xB0\xAE\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA7"],
        ["\x8F\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAE"],

        ["\xF3\xB0\xAE\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA8"],
        ["\x8F\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAF"],

        ["\xF3\xB0\xAE\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA9"],
        ["\x8F\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB0"],

        ["\xF3\xB0\xAE\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAA"],
        ["\x8F\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB1"],

        ["\xF3\xB0\xAE\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAB"],
        ["\x8F\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB2"],

        ["\xF3\xB0\xAE\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAC"],
        ["\x8F\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB3"],

        ["\xF3\xB0\xAE\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAD"],
        ["\x8F\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB4"],

        ["\xF3\xB0\xAE\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAE"],
        ["\x8F\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB5"],

        ["\xF3\xB0\xAE\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAF"],
        ["\x8F\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB6"],

        ["\xF3\xB0\xAE\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB0"],
        ["\x8F\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB7"],

        ["\xF3\xB0\xAE\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB1"],
        ["\x8F\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB8"],

        ["\xF3\xB0\xAE\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB2"],
        ["\x8F\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB9"],

        ["\xF3\xB0\xAE\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB3"],
        ["\x8F\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBA"],

        ["\xF3\xB0\xAE\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB4"],
        ["\x8F\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBB"],

        ["\xF3\xB0\xAE\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB5"],
        ["\x8F\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBC"],

        ["\xF3\xB0\xAE\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB6"],
        ["\x8F\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBD"],

        ["\xF3\xB0\xAE\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB7"],
        ["\x8F\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBE"],

        ["\xF3\xB0\xAE\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB8"],
        ["\x8F\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBF"],

        ["\xF3\xB0\xAF\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB9"],
        ["\x8F\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x80"],

        ["\xF3\xB0\xAF\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBA"],
        ["\x8F\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x81"],

        ["\xF3\xB0\xAF\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBB"],
        ["\x8F\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x82"],

        ["\xF3\xB0\xAF\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBC"],
        ["\x8F\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x83"],

        ["\xF3\xB0\xAF\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBD"],
        ["\x8F\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x84"],

        ["\xF3\xB0\xAF\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBE"],
        ["\x8F\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x85"],

        ["\xF3\xB0\xAF\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBF"],
        ["\x8F\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x86"],

        ["\xF3\xB0\xAF\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC0"],
        ["\x8F\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x87"],

        ["\xF3\xB0\xAF\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC1"],
        ["\x8F\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x88"],

        ["\xF3\xB0\xAF\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC2"],
        ["\x8F\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x89"],

        ["\xF3\xB0\xAF\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC3"],
        ["\x8F\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8A"],

        ["\xF3\xB0\xAF\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC4"],
        ["\x8F\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8B"],

        ["\xF3\xB0\xAF\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC5"],
        ["\x8F\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8C"],

        ["\xF3\xB0\xAF\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC6"],
        ["\x8F\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8D"],

        ["\xF3\xB0\xAF\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC7"],
        ["\x8F\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8E"],

        ["\xF3\xB0\xAF\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC8"],
        ["\x8F\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8F"],

        ["\xF3\xB0\xAF\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xC9"],
        ["\x8F\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x90"],

        ["\xF3\xB0\xAF\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCA"],
        ["\x8F\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x91"],

        ["\xF3\xB0\xAF\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCB"],
        ["\x8F\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x92"],

        ["\xF3\xB0\xAF\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCC"],
        ["\x8F\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x93"],

        ["\xF3\xB0\xAF\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCD"],
        ["\x8F\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x94"],

        ["\xF3\xB0\xAF\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCE"],
        ["\x8F\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x95"],

        ["\xF3\xB0\xAF\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCF"],
        ["\x8F\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x96"],

        ["\xF3\xB0\xAF\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD0"],
        ["\x8F\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x97"],

        ["\xF3\xB0\xAF\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD1"],
        ["\x8F\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x98"],

        ["\xF3\xB0\xAF\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD2"],
        ["\x8F\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x99"],

        ["\xF3\xB0\xAF\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD3"],
        ["\x8F\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9A"],

        ["\xF3\xB0\xAF\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD4"],
        ["\x8F\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9B"],

        ["\xF3\xB0\xAF\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD5"],
        ["\x8F\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9C"],

        ["\xF3\xB0\xAF\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD6"],
        ["\x8F\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9D"],

        ["\xF3\xB0\xAF\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD7"],
        ["\x8F\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9E"],

        ["\xF3\xB0\xAF\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD8"],
        ["\x8F\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9F"],

        ["\xF3\xB0\xAF\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xD9"],
        ["\x8F\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA0"],

        ["\xF3\xB0\xAF\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDA"],
        ["\x8F\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA1"],

        ["\xF3\xB0\xAF\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDB"],
        ["\x8F\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA2"],

        ["\xF3\xB0\xAF\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDC"],
        ["\x8F\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA3"],

        ["\xF3\xB0\xAF\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDD"],
        ["\x8F\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA4"],

        ["\xF3\xB0\xAF\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDE"],
        ["\x8F\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA5"],

        ["\xF3\xB0\xAF\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDF"],
        ["\x8F\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA6"],

        ["\xF3\xB0\xAF\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE0"],
        ["\x8F\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA7"],

        ["\xF3\xB0\xAF\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE1"],
        ["\x8F\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA8"],

        ["\xF3\xB0\xAF\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE2"],
        ["\x8F\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA9"],

        ["\xF3\xB0\xAF\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE3"],
        ["\x8F\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAA"],

        ["\xF3\xB0\xAF\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE4"],
        ["\x8F\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAB"],

        ["\xF3\xB0\xAF\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE5"],
        ["\x8F\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAC"],

        ["\xF3\xB0\xAF\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE6"],
        ["\x8F\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAD"],

        ["\xF3\xB0\xAF\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE7"],
        ["\x8F\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAE"],

        ["\xF3\xB0\xAF\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE8"],
        ["\x8F\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAF"],

        ["\xF3\xB0\xAF\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xE9"],
        ["\x8F\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB0"],

        ["\xF3\xB0\xAF\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEA"],
        ["\x8F\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB1"],

        ["\xF3\xB0\xAF\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEB"],
        ["\x8F\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB2"],

        ["\xF3\xB0\xAF\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEC"],
        ["\x8F\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB3"],

        ["\xF3\xB0\xAF\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xED"],
        ["\x8F\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB4"],

        ["\xF3\xB0\xAF\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEE"],
        ["\x8F\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB5"],

        ["\xF3\xB0\xAF\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEF"],
        ["\x8F\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB6"],

        ["\xF3\xB0\xAF\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF0"],
        ["\x8F\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB7"],

        ["\xF3\xB0\xAF\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF1"],
        ["\x8F\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB8"],

        ["\xF3\xB0\xAF\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF2"],
        ["\x8F\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB9"],

        ["\xF3\xB0\xAF\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF3"],
        ["\x8F\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBA"],

        ["\xF3\xB0\xAF\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF4"],
        ["\x8F\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBB"],

        ["\xF3\xB0\xAF\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF5"],
        ["\x8F\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBC"],

        ["\xF3\xB0\xAF\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF6"],
        ["\x8F\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBD"],

        ["\xF3\xB0\xAF\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF7"],
        ["\x8F\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBE"],

        ["\xF3\xB0\xAF\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF8"],
        ["\x8F\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBF"],

        ["\xF3\xB0\xB0\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xF9"],
        ["\x8F\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x80"],

        ["\xF3\xB0\xB0\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xFA"],
        ["\x8F\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x81"],

        ["\xF3\xB0\xB0\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xFB"],
        ["\x8F\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x82"],

        ["\xF3\xB0\xB0\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xFC"],
        ["\x8F\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x83"],

        ["\xF3\xB0\xB0\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x40"],
        ["\x90\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x84"],

        ["\xF3\xB0\xB0\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x41"],
        ["\x90\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x85"],

        ["\xF3\xB0\xB0\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x42"],
        ["\x90\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x86"],

        ["\xF3\xB0\xB0\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x43"],
        ["\x90\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x87"],

        ["\xF3\xB0\xB0\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x44"],
        ["\x90\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x88"],

        ["\xF3\xB0\xB0\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x45"],
        ["\x90\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x89"],

        ["\xF3\xB0\xB0\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x46"],
        ["\x90\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8A"],

        ["\xF3\xB0\xB0\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x47"],
        ["\x90\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8B"],

        ["\xF3\xB0\xB0\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x48"],
        ["\x90\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8C"],

        ["\xF3\xB0\xB0\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x49"],
        ["\x90\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8D"],

        ["\xF3\xB0\xB0\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4A"],
        ["\x90\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8E"],

        ["\xF3\xB0\xB0\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4B"],
        ["\x90\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8F"],

        ["\xF3\xB0\xB0\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4C"],
        ["\x90\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x90"],

        ["\xF3\xB0\xB0\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4D"],
        ["\x90\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x91"],

        ["\xF3\xB0\xB0\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4E"],
        ["\x90\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x92"],

        ["\xF3\xB0\xB0\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x4F"],
        ["\x90\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x93"],

        ["\xF3\xB0\xB0\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x50"],
        ["\x90\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x94"],

        ["\xF3\xB0\xB0\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x51"],
        ["\x90\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x95"],

        ["\xF3\xB0\xB0\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x52"],
        ["\x90\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x96"],

        ["\xF3\xB0\xB0\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x53"],
        ["\x90\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x97"],

        ["\xF3\xB0\xB0\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x54"],
        ["\x90\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x98"],

        ["\xF3\xB0\xB0\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x55"],
        ["\x90\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x99"],

        ["\xF3\xB0\xB0\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x56"],
        ["\x90\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9A"],

        ["\xF3\xB0\xB0\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x57"],
        ["\x90\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9B"],

        ["\xF3\xB0\xB0\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x58"],
        ["\x90\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9C"],

        ["\xF3\xB0\xB0\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x59"],
        ["\x90\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9D"],

        ["\xF3\xB0\xB0\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5A"],
        ["\x90\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9E"],

        ["\xF3\xB0\xB0\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5B"],
        ["\x90\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9F"],

        ["\xF3\xB0\xB0\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5C"],
        ["\x90\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA0"],

        ["\xF3\xB0\xB0\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5D"],
        ["\x90\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA1"],

        ["\xF3\xB0\xB0\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5E"],
        ["\x90\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA2"],

        ["\xF3\xB0\xB0\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x5F"],
        ["\x90\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA3"],

        ["\xF3\xB0\xB0\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x60"],
        ["\x90\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA4"],

        ["\xF3\xB0\xB0\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x61"],
        ["\x90\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA5"],

        ["\xF3\xB0\xB0\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x62"],
        ["\x90\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA6"],

        ["\xF3\xB0\xB0\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x63"],
        ["\x90\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA7"],

        ["\xF3\xB0\xB0\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x64"],
        ["\x90\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA8"],

        ["\xF3\xB0\xB0\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x65"],
        ["\x90\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA9"],

        ["\xF3\xB0\xB0\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x66"],
        ["\x90\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAA"],

        ["\xF3\xB0\xB0\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x67"],
        ["\x90\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAB"],

        ["\xF3\xB0\xB0\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x68"],
        ["\x90\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAC"],

        ["\xF3\xB0\xB0\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x69"],
        ["\x90\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAD"],

        ["\xF3\xB0\xB0\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6A"],
        ["\x90\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAE"],

        ["\xF3\xB0\xB0\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6B"],
        ["\x90\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAF"],

        ["\xF3\xB0\xB0\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6C"],
        ["\x90\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB0"],

        ["\xF3\xB0\xB0\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6D"],
        ["\x90\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB1"],

        ["\xF3\xB0\xB0\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6E"],
        ["\x90\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB2"],

        ["\xF3\xB0\xB0\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x6F"],
        ["\x90\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB3"],

        ["\xF3\xB0\xB0\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x70"],
        ["\x90\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB4"],

        ["\xF3\xB0\xB0\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x71"],
        ["\x90\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB5"],

        ["\xF3\xB0\xB0\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x72"],
        ["\x90\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB6"],

        ["\xF3\xB0\xB0\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x73"],
        ["\x90\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB7"],

        ["\xF3\xB0\xB0\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x74"],
        ["\x90\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB8"],

        ["\xF3\xB0\xB0\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x75"],
        ["\x90\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB9"],

        ["\xF3\xB0\xB0\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x76"],
        ["\x90\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBA"],

        ["\xF3\xB0\xB0\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x77"],
        ["\x90\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBB"],

        ["\xF3\xB0\xB0\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x78"],
        ["\x90\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBC"],

        ["\xF3\xB0\xB0\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x79"],
        ["\x90\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBD"],

        ["\xF3\xB0\xB0\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x7A"],
        ["\x90\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBE"],

        ["\xF3\xB0\xB0\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x7B"],
        ["\x90\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBF"],

        ["\xF3\xB0\xB1\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x7C"],
        ["\x90\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x80"],

        ["\xF3\xB0\xB1\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x7D"],
        ["\x90\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x81"],

        ["\xF3\xB0\xB1\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x7E"],
        ["\x90\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x82"],

        ["\xF3\xB0\xB1\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x80"],
        ["\x90\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x83"],

        ["\xF3\xB0\xB1\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x81"],
        ["\x90\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x84"],

        ["\xF3\xB0\xB1\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x82"],
        ["\x90\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x85"],

        ["\xF3\xB0\xB1\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x83"],
        ["\x90\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x86"],

        ["\xF3\xB0\xB1\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x84"],
        ["\x90\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x87"],

        ["\xF3\xB0\xB1\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x85"],
        ["\x90\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x88"],

        ["\xF3\xB0\xB1\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x86"],
        ["\x90\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x89"],

        ["\xF3\xB0\xB1\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x87"],
        ["\x90\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8A"],

        ["\xF3\xB0\xB1\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x88"],
        ["\x90\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8B"],

        ["\xF3\xB0\xB1\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x89"],
        ["\x90\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8C"],

        ["\xF3\xB0\xB1\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8A"],
        ["\x90\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8D"],

        ["\xF3\xB0\xB1\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8B"],
        ["\x90\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8E"],

        ["\xF3\xB0\xB1\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8C"],
        ["\x90\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8F"],

        ["\xF3\xB0\xB1\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8D"],
        ["\x90\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x90"],

        ["\xF3\xB0\xB1\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8E"],
        ["\x90\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x91"],

        ["\xF3\xB0\xB1\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8F"],
        ["\x90\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x92"],

        ["\xF3\xB0\xB1\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x90"],
        ["\x90\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x93"],

        ["\xF3\xB0\xB1\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x91"],
        ["\x90\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x94"],

        ["\xF3\xB0\xB1\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x92"],
        ["\x90\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x95"],

        ["\xF3\xB0\xB1\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x93"],
        ["\x90\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x96"],

        ["\xF3\xB0\xB1\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x94"],
        ["\x90\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x97"],

        ["\xF3\xB0\xB1\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x95"],
        ["\x90\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x98"],

        ["\xF3\xB0\xB1\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x96"],
        ["\x90\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x99"],

        ["\xF3\xB0\xB1\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x97"],
        ["\x90\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9A"],

        ["\xF3\xB0\xB1\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x98"],
        ["\x90\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9B"],

        ["\xF3\xB0\xB1\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x99"],
        ["\x90\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9C"],

        ["\xF3\xB0\xB1\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9A"],
        ["\x90\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9D"],

        ["\xF3\xB0\xB1\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9B"],
        ["\x90\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9E"],

        ["\xF3\xB0\xB1\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9C"],
        ["\x90\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9F"],

        ["\xF3\xB0\xB1\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9D"],
        ["\x90\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA0"],

        ["\xF3\xB0\xB1\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9E"],
        ["\x90\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA1"],

        ["\xF3\xB0\xB1\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9F"],
        ["\x90\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA2"],

        ["\xF3\xB0\xB1\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA0"],
        ["\x90\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA3"],

        ["\xF3\xB0\xB1\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA1"],
        ["\x90\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA4"],

        ["\xF3\xB0\xB1\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA2"],
        ["\x90\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA5"],

        ["\xF3\xB0\xB1\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],
        ["\x90\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA6"],

        ["\xF3\xB0\xB1\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA4"],
        ["\x90\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA7"],

        ["\xF3\xB0\xB1\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA5"],
        ["\x90\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA8"],

        ["\xF3\xB0\xB1\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA6"],
        ["\x90\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA9"],

        ["\xF3\xB0\xB1\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA7"],
        ["\x90\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAA"],

        ["\xF3\xB0\xB1\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA8"],
        ["\x90\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAB"],

        ["\xF3\xB0\xB1\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA9"],
        ["\x90\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAC"],

        ["\xF3\xB0\xB1\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAA"],
        ["\x90\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAD"],

        ["\xF3\xB0\xB1\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAB"],
        ["\x90\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAE"],

        ["\xF3\xB0\xB1\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAC"],
        ["\x90\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAF"],

        ["\xF3\xB0\xB1\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAD"],
        ["\x90\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB0"],

        ["\xF3\xB0\xB1\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAE"],
        ["\x90\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB1"],

        ["\xF3\xB0\xB1\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAF"],
        ["\x90\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB2"],

        ["\xF3\xB0\xB1\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB0"],
        ["\x90\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB3"],

        ["\xF3\xB0\xB1\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB1"],
        ["\x90\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB4"],

        ["\xF3\xB0\xB1\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB2"],
        ["\x90\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB5"],

        ["\xF3\xB0\xB1\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB3"],
        ["\x90\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB6"],

        ["\xF3\xB0\xB1\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB4"],
        ["\x90\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB7"],

        ["\xF3\xB0\xB1\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB5"],
        ["\x90\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB8"],

        ["\xF3\xB0\xB1\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB6"],
        ["\x90\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB9"],

        ["\xF3\xB0\xB1\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB7"],
        ["\x90\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBA"],

        ["\xF3\xB0\xB1\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB8"],
        ["\x90\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBB"],

        ["\xF3\xB0\xB1\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB9"],
        ["\x90\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBC"],

        ["\xF3\xB0\xB1\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBA"],
        ["\x90\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBD"],

        ["\xF3\xB0\xB1\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBB"],
        ["\x90\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBE"],

        ["\xF3\xB0\xB1\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBC"],
        ["\x90\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBF"],

        ["\xF3\xB0\xB2\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBD"],
        ["\x90\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x80"],

        ["\xF3\xB0\xB2\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBE"],
        ["\x90\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x81"],

        ["\xF3\xB0\xB2\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBF"],
        ["\x90\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x82"],

        ["\xF3\xB0\xB2\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC0"],
        ["\x90\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x83"],

        ["\xF3\xB0\xB2\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC1"],
        ["\x90\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x84"],

        ["\xF3\xB0\xB2\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC2"],
        ["\x90\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x85"],

        ["\xF3\xB0\xB2\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC3"],
        ["\x90\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x86"],

        ["\xF3\xB0\xB2\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC4"],
        ["\x90\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x87"],

        ["\xF3\xB0\xB2\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC5"],
        ["\x90\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x88"],

        ["\xF3\xB0\xB2\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC6"],
        ["\x90\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x89"],

        ["\xF3\xB0\xB2\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC7"],
        ["\x90\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8A"],

        ["\xF3\xB0\xB2\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC8"],
        ["\x90\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8B"],

        ["\xF3\xB0\xB2\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xC9"],
        ["\x90\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8C"],

        ["\xF3\xB0\xB2\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCA"],
        ["\x90\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8D"],

        ["\xF3\xB0\xB2\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCB"],
        ["\x90\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8E"],

        ["\xF3\xB0\xB2\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCC"],
        ["\x90\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8F"],

        ["\xF3\xB0\xB2\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCD"],
        ["\x90\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x90"],

        ["\xF3\xB0\xB2\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCE"],
        ["\x90\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x91"],

        ["\xF3\xB0\xB2\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCF"],
        ["\x90\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x92"],

        ["\xF3\xB0\xB2\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD0"],
        ["\x90\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x93"],

        ["\xF3\xB0\xB2\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD1"],
        ["\x90\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x94"],

        ["\xF3\xB0\xB2\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD2"],
        ["\x90\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x95"],

        ["\xF3\xB0\xB2\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD3"],
        ["\x90\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x96"],

        ["\xF3\xB0\xB2\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD4"],
        ["\x90\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x97"],

        ["\xF3\xB0\xB2\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD5"],
        ["\x90\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x98"],

        ["\xF3\xB0\xB2\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD6"],
        ["\x90\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x99"],

        ["\xF3\xB0\xB2\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD7"],
        ["\x90\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9A"],

        ["\xF3\xB0\xB2\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD8"],
        ["\x90\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9B"],

        ["\xF3\xB0\xB2\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xD9"],
        ["\x90\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9C"],

        ["\xF3\xB0\xB2\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDA"],
        ["\x90\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9D"],

        ["\xF3\xB0\xB2\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDB"],
        ["\x90\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9E"],

        ["\xF3\xB0\xB2\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDC"],
        ["\x90\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9F"],

        ["\xF3\xB0\xB2\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDD"],
        ["\x90\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA0"],

        ["\xF3\xB0\xB2\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDE"],
        ["\x90\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA1"],

        ["\xF3\xB0\xB2\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDF"],
        ["\x90\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA2"],

        ["\xF3\xB0\xB2\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE0"],
        ["\x90\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA3"],

        ["\xF3\xB0\xB2\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE1"],
        ["\x90\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA4"],

        ["\xF3\xB0\xB2\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE2"],
        ["\x90\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA5"],

        ["\xF3\xB0\xB2\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE3"],
        ["\x90\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA6"],

        ["\xF3\xB0\xB2\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE4"],
        ["\x90\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA7"],

        ["\xF3\xB0\xB2\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE5"],
        ["\x90\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA8"],

        ["\xF3\xB0\xB2\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE6"],
        ["\x90\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA9"],

        ["\xF3\xB0\xB2\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE7"],
        ["\x90\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAA"],

        ["\xF3\xB0\xB2\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE8"],
        ["\x90\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAB"],

        ["\xF3\xB0\xB2\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xE9"],
        ["\x90\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAC"],

        ["\xF3\xB0\xB2\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEA"],
        ["\x90\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAD"],

        ["\xF3\xB0\xB2\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEB"],
        ["\x90\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAE"],

        ["\xF3\xB0\xB2\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEC"],
        ["\x90\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAF"],

        ["\xF3\xB0\xB2\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xED"],
        ["\x90\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB0"],

        ["\xF3\xB0\xB2\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEE"],
        ["\x90\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB1"],

        ["\xF3\xB0\xB2\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEF"],
        ["\x90\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB2"],

        ["\xF3\xB0\xB2\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF0"],
        ["\x90\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB3"],

        ["\xF3\xB0\xB2\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF1"],
        ["\x90\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB4"],

        ["\xF3\xB0\xB2\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF2"],
        ["\x90\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB5"],

        ["\xF3\xB0\xB2\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF3"],
        ["\x90\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB6"],

        ["\xF3\xB0\xB2\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF4"],
        ["\x90\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB7"],

        ["\xF3\xB0\xB2\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF5"],
        ["\x90\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB8"],

        ["\xF3\xB0\xB2\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF6"],
        ["\x90\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB9"],

        ["\xF3\xB0\xB2\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF7"],
        ["\x90\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBA"],

        ["\xF3\xB0\xB2\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF8"],
        ["\x90\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBB"],

        ["\xF3\xB0\xB2\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xF9"],
        ["\x90\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBC"],

        ["\xF3\xB0\xB2\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xFA"],
        ["\x90\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBD"],

        ["\xF3\xB0\xB2\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xFB"],
        ["\x90\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBE"],

        ["\xF3\xB0\xB2\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xFC"],
        ["\x90\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBF"],

        ["\xF3\xB0\xB3\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x40"],
        ["\x91\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x80"],

        ["\xF3\xB0\xB3\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x41"],
        ["\x91\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x81"],

        ["\xF3\xB0\xB3\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x42"],
        ["\x91\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x82"],

        ["\xF3\xB0\xB3\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x43"],
        ["\x91\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x83"],

        ["\xF3\xB0\xB3\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x44"],
        ["\x91\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x84"],

        ["\xF3\xB0\xB3\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x45"],
        ["\x91\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x85"],

        ["\xF3\xB0\xB3\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x46"],
        ["\x91\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x86"],

        ["\xF3\xB0\xB3\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x47"],
        ["\x91\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x87"],

        ["\xF3\xB0\xB3\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x48"],
        ["\x91\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x88"],

        ["\xF3\xB0\xB3\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x49"],
        ["\x91\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x89"],

        ["\xF3\xB0\xB3\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4A"],
        ["\x91\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8A"],

        ["\xF3\xB0\xB3\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4B"],
        ["\x91\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8B"],

        ["\xF3\xB0\xB3\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4C"],
        ["\x91\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8C"],

        ["\xF3\xB0\xB3\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4D"],
        ["\x91\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8D"],

        ["\xF3\xB0\xB3\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4E"],
        ["\x91\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8E"],

        ["\xF3\xB0\xB3\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x4F"],
        ["\x91\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8F"],

        ["\xF3\xB0\xB3\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x50"],
        ["\x91\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x90"],

        ["\xF3\xB0\xB3\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x51"],
        ["\x91\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x91"],

        ["\xF3\xB0\xB3\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x52"],
        ["\x91\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x92"],

        ["\xF3\xB0\xB3\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x53"],
        ["\x91\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x93"],

        ["\xF3\xB0\xB3\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x54"],
        ["\x91\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x94"],

        ["\xF3\xB0\xB3\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x55"],
        ["\x91\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x95"],

        ["\xF3\xB0\xB3\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x56"],
        ["\x91\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x96"],

        ["\xF3\xB0\xB3\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x57"],
        ["\x91\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x97"],

        ["\xF3\xB0\xB3\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x58"],
        ["\x91\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x98"],

        ["\xF3\xB0\xB3\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x59"],
        ["\x91\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x99"],

        ["\xF3\xB0\xB3\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5A"],
        ["\x91\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9A"],

        ["\xF3\xB0\xB3\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5B"],
        ["\x91\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9B"],

        ["\xF3\xB0\xB3\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5C"],
        ["\x91\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9C"],

        ["\xF3\xB0\xB3\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5D"],
        ["\x91\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9D"],

        ["\xF3\xB0\xB3\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5E"],
        ["\x91\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9E"],

        ["\xF3\xB0\xB3\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x5F"],
        ["\x91\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9F"],

        ["\xF3\xB0\xB3\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x60"],
        ["\x91\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA0"],

        ["\xF3\xB0\xB3\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x61"],
        ["\x91\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA1"],

        ["\xF3\xB0\xB3\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x62"],
        ["\x91\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA2"],

        ["\xF3\xB0\xB3\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x63"],
        ["\x91\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA3"],

        ["\xF3\xB0\xB3\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x64"],
        ["\x91\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA4"],

        ["\xF3\xB0\xB3\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x65"],
        ["\x91\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA5"],

        ["\xF3\xB0\xB3\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x66"],
        ["\x91\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA6"],

        ["\xF3\xB0\xB3\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x67"],
        ["\x91\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA7"],

        ["\xF3\xB0\xB3\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x68"],
        ["\x91\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA8"],

        ["\xF3\xB0\xB3\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x69"],
        ["\x91\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA9"],

        ["\xF3\xB0\xB3\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6A"],
        ["\x91\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAA"],

        ["\xF3\xB0\xB3\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6B"],
        ["\x91\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAB"],

        ["\xF3\xB0\xB3\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6C"],
        ["\x91\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAC"],

        ["\xF3\xB0\xB3\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6D"],
        ["\x91\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAD"],

        ["\xF3\xB0\xB3\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6E"],
        ["\x91\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAE"],

        ["\xF3\xB0\xB3\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x6F"],
        ["\x91\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAF"],

        ["\xF3\xB0\xB3\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x70"],
        ["\x91\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB0"],

        ["\xF3\xB0\xB3\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x71"],
        ["\x91\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB1"],

        ["\xF3\xB0\xB3\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x72"],
        ["\x91\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB2"],

        ["\xF3\xB0\xB3\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x73"],
        ["\x91\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB3"],

        ["\xF3\xB0\xB3\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x74"],
        ["\x91\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB4"],

        ["\xF3\xB0\xB3\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x75"],
        ["\x91\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB5"],

        ["\xF3\xB0\xB3\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x76"],
        ["\x91\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB6"],

        ["\xF3\xB0\xB3\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x77"],
        ["\x91\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB7"],

        ["\xF3\xB0\xB3\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x78"],
        ["\x91\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB8"],

        ["\xF3\xB0\xB3\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x79"],
        ["\x91\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB9"],

        ["\xF3\xB0\xB3\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x7A"],
        ["\x91\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBA"],

        ["\xF3\xB0\xB3\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x7B"],
        ["\x91\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBB"],

        ["\xF3\xB0\xB3\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x7C"],
        ["\x91\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBC"],

        ["\xF3\xB0\xB3\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x7D"],
        ["\x91\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBD"],

        ["\xF3\xB0\xB3\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x7E"],
        ["\x91\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBE"],

        ["\xF3\xB0\xB3\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x80"],
        ["\x91\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBF"],

        ["\xF3\xB0\xB4\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x81"],
        ["\x91\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x80"],

        ["\xF3\xB0\xB4\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x82"],
        ["\x91\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x81"],

        ["\xF3\xB0\xB4\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x83"],
        ["\x91\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x82"],

        ["\xF3\xB0\xB4\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x84"],
        ["\x91\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x83"],

        ["\xF3\xB0\xB4\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x85"],
        ["\x91\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x84"],

        ["\xF3\xB0\xB4\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x86"],
        ["\x91\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x85"],

        ["\xF3\xB0\xB4\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x87"],
        ["\x91\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x86"],

        ["\xF3\xB0\xB4\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x88"],
        ["\x91\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x87"],

        ["\xF3\xB0\xB4\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x89"],
        ["\x91\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x88"],

        ["\xF3\xB0\xB4\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8A"],
        ["\x91\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x89"],

        ["\xF3\xB0\xB4\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8B"],
        ["\x91\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8A"],

        ["\xF3\xB0\xB4\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8C"],
        ["\x91\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8B"],

        ["\xF3\xB0\xB4\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8D"],
        ["\x91\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8C"],

        ["\xF3\xB0\xB4\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8E"],
        ["\x91\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8D"],

        ["\xF3\xB0\xB4\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8F"],
        ["\x91\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8E"],

        ["\xF3\xB0\xB4\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x90"],
        ["\x91\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8F"],

        ["\xF3\xB0\xB4\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x91"],
        ["\x91\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x90"],

        ["\xF3\xB0\xB4\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x92"],
        ["\x91\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x91"],

        ["\xF3\xB0\xB4\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x93"],
        ["\x91\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x92"],

        ["\xF3\xB0\xB4\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x94"],
        ["\x91\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x93"],

        ["\xF3\xB0\xB4\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x95"],
        ["\x91\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x94"],

        ["\xF3\xB0\xB4\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x96"],
        ["\x91\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x95"],

        ["\xF3\xB0\xB4\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x97"],
        ["\x91\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x96"],

        ["\xF3\xB0\xB4\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x98"],
        ["\x91\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x97"],

        ["\xF3\xB0\xB4\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x99"],
        ["\x91\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x98"],

        ["\xF3\xB0\xB4\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9A"],
        ["\x91\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x99"],

        ["\xF3\xB0\xB4\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9B"],
        ["\x91\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9A"],

        ["\xF3\xB0\xB4\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9C"],
        ["\x91\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9B"],

        ["\xF3\xB0\xB4\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9D"],
        ["\x91\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9C"],

        ["\xF3\xB0\xB4\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9E"],
        ["\x91\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9D"],

        ["\xF3\xB0\xB4\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9F"],
        ["\x91\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9E"],

        ["\xF3\xB0\xB4\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA0"],
        ["\x91\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9F"],

        ["\xF3\xB0\xB4\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA1"],
        ["\x91\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA0"],

        ["\xF3\xB0\xB4\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA2"],
        ["\x91\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA1"],

        ["\xF3\xB0\xB4\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA3"],
        ["\x91\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA2"],

        ["\xF3\xB0\xB4\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA4"],
        ["\x91\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA3"],

        ["\xF3\xB0\xB4\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA5"],
        ["\x91\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA4"],

        ["\xF3\xB0\xB4\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA6"],
        ["\x91\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA5"],

        ["\xF3\xB0\xB4\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA7"],
        ["\x91\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA6"],

        ["\xF3\xB0\xB4\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA8"],
        ["\x91\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA7"],

        ["\xF3\xB0\xB4\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA9"],
        ["\x91\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA8"],

        ["\xF3\xB0\xB4\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAA"],
        ["\x91\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA9"],

        ["\xF3\xB0\xB4\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAB"],
        ["\x91\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAA"],

        ["\xF3\xB0\xB4\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAC"],
        ["\x91\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAB"],

        ["\xF3\xB0\xB4\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAD"],
        ["\x91\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAC"],

        ["\xF3\xB0\xB4\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAE"],
        ["\x91\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAD"],

        ["\xF3\xB0\xB4\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAF"],
        ["\x91\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAE"],

        ["\xF3\xB0\xB4\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB0"],
        ["\x91\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAF"],

        ["\xF3\xB0\xB4\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB1"],
        ["\x91\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB0"],

        ["\xF3\xB0\xB4\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB2"],
        ["\x91\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB1"],

        ["\xF3\xB0\xB4\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB3"],
        ["\x91\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB2"],

        ["\xF3\xB0\xB4\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB4"],
        ["\x91\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB3"],

        ["\xF3\xB0\xB4\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB5"],
        ["\x91\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB4"],

        ["\xF3\xB0\xB4\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB6"],
        ["\x91\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB5"],

        ["\xF3\xB0\xB4\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB7"],
        ["\x91\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB6"],

        ["\xF3\xB0\xB4\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB8"],
        ["\x91\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB7"],

        ["\xF3\xB0\xB4\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB9"],
        ["\x91\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB8"],

        ["\xF3\xB0\xB4\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBA"],
        ["\x91\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB9"],

        ["\xF3\xB0\xB4\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBB"],
        ["\x91\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBA"],

        ["\xF3\xB0\xB4\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBC"],
        ["\x91\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBB"],

        ["\xF3\xB0\xB4\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBD"],
        ["\x91\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBC"],

        ["\xF3\xB0\xB4\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBE"],
        ["\x91\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBD"],

        ["\xF3\xB0\xB4\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBF"],
        ["\x91\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBE"],

        ["\xF3\xB0\xB4\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC0"],
        ["\x91\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBF"],

        ["\xF3\xB0\xB5\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC1"],
        ["\x91\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x80"],

        ["\xF3\xB0\xB5\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC2"],
        ["\x91\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x81"],

        ["\xF3\xB0\xB5\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC3"],
        ["\x91\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x82"],

        ["\xF3\xB0\xB5\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC4"],
        ["\x91\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x83"],

        ["\xF3\xB0\xB5\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC5"],
        ["\x91\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x84"],

        ["\xF3\xB0\xB5\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC6"],
        ["\x91\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x85"],

        ["\xF3\xB0\xB5\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC7"],
        ["\x91\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x86"],

        ["\xF3\xB0\xB5\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC8"],
        ["\x91\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x87"],

        ["\xF3\xB0\xB5\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xC9"],
        ["\x91\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x88"],

        ["\xF3\xB0\xB5\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCA"],
        ["\x91\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x89"],

        ["\xF3\xB0\xB5\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCB"],
        ["\x91\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8A"],

        ["\xF3\xB0\xB5\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCC"],
        ["\x91\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8B"],

        ["\xF3\xB0\xB5\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCD"],
        ["\x91\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8C"],

        ["\xF3\xB0\xB5\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCE"],
        ["\x91\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8D"],

        ["\xF3\xB0\xB5\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCF"],
        ["\x91\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8E"],

        ["\xF3\xB0\xB5\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD0"],
        ["\x91\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8F"],

        ["\xF3\xB0\xB5\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD1"],
        ["\x91\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x90"],

        ["\xF3\xB0\xB5\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD2"],
        ["\x91\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x91"],

        ["\xF3\xB0\xB5\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD3"],
        ["\x91\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x92"],

        ["\xF3\xB0\xB5\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD4"],
        ["\x91\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x93"],

        ["\xF3\xB0\xB5\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD5"],
        ["\x91\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x94"],

        ["\xF3\xB0\xB5\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD6"],
        ["\x91\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x95"],

        ["\xF3\xB0\xB5\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD7"],
        ["\x91\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x96"],

        ["\xF3\xB0\xB5\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD8"],
        ["\x91\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x97"],

        ["\xF3\xB0\xB5\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xD9"],
        ["\x91\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x98"],

        ["\xF3\xB0\xB5\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDA"],
        ["\x91\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x99"],

        ["\xF3\xB0\xB5\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDB"],
        ["\x91\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9A"],

        ["\xF3\xB0\xB5\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDC"],
        ["\x91\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9B"],

        ["\xF3\xB0\xB5\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDD"],
        ["\x91\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9C"],

        ["\xF3\xB0\xB5\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDE"],
        ["\x91\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9D"],

        ["\xF3\xB0\xB5\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDF"],
        ["\x91\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9E"],

        ["\xF3\xB0\xB5\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE0"],
        ["\x91\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9F"],

        ["\xF3\xB0\xB5\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE1"],
        ["\x91\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA0"],

        ["\xF3\xB0\xB5\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE2"],
        ["\x91\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA1"],

        ["\xF3\xB0\xB5\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE3"],
        ["\x91\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA2"],

        ["\xF3\xB0\xB5\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE4"],
        ["\x91\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA3"],

        ["\xF3\xB0\xB5\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE5"],
        ["\x91\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA4"],

        ["\xF3\xB0\xB5\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE6"],
        ["\x91\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA5"],

        ["\xF3\xB0\xB5\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE7"],
        ["\x91\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA6"],

        ["\xF3\xB0\xB5\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE8"],
        ["\x91\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA7"],

        ["\xF3\xB0\xB5\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xE9"],
        ["\x91\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA8"],

        ["\xF3\xB0\xB5\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEA"],
        ["\x91\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA9"],

        ["\xF3\xB0\xB5\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEB"],
        ["\x91\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAA"],

        ["\xF3\xB0\xB5\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEC"],
        ["\x91\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAB"],

        ["\xF3\xB0\xB5\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xED"],
        ["\x91\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAC"],

        ["\xF3\xB0\xB5\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEE"],
        ["\x91\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAD"],

        ["\xF3\xB0\xB5\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEF"],
        ["\x91\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAE"],

        ["\xF3\xB0\xB5\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF0"],
        ["\x91\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAF"],

        ["\xF3\xB0\xB5\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF1"],
        ["\x91\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB0"],

        ["\xF3\xB0\xB5\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF2"],
        ["\x91\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB1"],

        ["\xF3\xB0\xB5\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF3"],
        ["\x91\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB2"],

        ["\xF3\xB0\xB5\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF4"],
        ["\x91\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB3"],

        ["\xF3\xB0\xB5\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF5"],
        ["\x91\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB4"],

        ["\xF3\xB0\xB5\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF6"],
        ["\x91\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB5"],

        ["\xF3\xB0\xB5\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF7"],
        ["\x91\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB6"],

        ["\xF3\xB0\xB5\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF8"],
        ["\x91\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB7"],

        ["\xF3\xB0\xB5\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xF9"],
        ["\x91\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB8"],

        ["\xF3\xB0\xB5\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xFA"],
        ["\x91\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB9"],

        ["\xF3\xB0\xB5\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xFB"],
        ["\x91\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBA"],

        ["\xF3\xB0\xB5\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xFC"],
        ["\x91\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBB"],

        ["\xF3\xB0\xB5\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x40"],
        ["\x92\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBC"],

        ["\xF3\xB0\xB5\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x41"],
        ["\x92\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBD"],

        ["\xF3\xB0\xB5\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x42"],
        ["\x92\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBE"],

        ["\xF3\xB0\xB5\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x43"],
        ["\x92\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBF"],

        ["\xF3\xB0\xB6\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x44"],
        ["\x92\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x80"],

        ["\xF3\xB0\xB6\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x45"],
        ["\x92\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x81"],

        ["\xF3\xB0\xB6\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x46"],
        ["\x92\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x82"],

        ["\xF3\xB0\xB6\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x47"],
        ["\x92\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x83"],

        ["\xF3\xB0\xB6\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x48"],
        ["\x92\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x84"],

        ["\xF3\xB0\xB6\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x49"],
        ["\x92\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x85"],

        ["\xF3\xB0\xB6\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4A"],
        ["\x92\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x86"],

        ["\xF3\xB0\xB6\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4B"],
        ["\x92\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x87"],

        ["\xF3\xB0\xB6\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4C"],
        ["\x92\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x88"],

        ["\xF3\xB0\xB6\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4D"],
        ["\x92\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x89"],

        ["\xF3\xB0\xB6\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4E"],
        ["\x92\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8A"],

        ["\xF3\xB0\xB6\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x4F"],
        ["\x92\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8B"],

        ["\xF3\xB0\xB6\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x50"],
        ["\x92\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8C"],

        ["\xF3\xB0\xB6\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x51"],
        ["\x92\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8D"],

        ["\xF3\xB0\xB6\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x52"],
        ["\x92\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8E"],

        ["\xF3\xB0\xB6\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x53"],
        ["\x92\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8F"],

        ["\xF3\xB0\xB6\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x54"],
        ["\x92\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x90"],

        ["\xF3\xB0\xB6\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x55"],
        ["\x92\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x91"],

        ["\xF3\xB0\xB6\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x56"],
        ["\x92\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x92"],

        ["\xF3\xB0\xB6\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x57"],
        ["\x92\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x93"],

        ["\xF3\xB0\xB6\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x58"],
        ["\x92\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x94"],

        ["\xF3\xB0\xB6\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x59"],
        ["\x92\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x95"],

        ["\xF3\xB0\xB6\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5A"],
        ["\x92\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x96"],

        ["\xF3\xB0\xB6\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5B"],
        ["\x92\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x97"],

        ["\xF3\xB0\xB6\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5C"],
        ["\x92\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x98"],

        ["\xF3\xB0\xB6\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5D"],
        ["\x92\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x99"],

        ["\xF3\xB0\xB6\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5E"],
        ["\x92\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9A"],

        ["\xF3\xB0\xB6\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x5F"],
        ["\x92\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9B"],

        ["\xF3\xB0\xB6\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x60"],
        ["\x92\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9C"],

        ["\xF3\xB0\xB6\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x61"],
        ["\x92\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9D"],

        ["\xF3\xB0\xB6\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x62"],
        ["\x92\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9E"],

        ["\xF3\xB0\xB6\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x63"],
        ["\x92\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9F"],

        ["\xF3\xB0\xB6\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x64"],
        ["\x92\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA0"],

        ["\xF3\xB0\xB6\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x65"],
        ["\x92\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA1"],

        ["\xF3\xB0\xB6\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x66"],
        ["\x92\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA2"],

        ["\xF3\xB0\xB6\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x67"],
        ["\x92\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA3"],

        ["\xF3\xB0\xB6\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x68"],
        ["\x92\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA4"],

        ["\xF3\xB0\xB6\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x69"],
        ["\x92\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA5"],

        ["\xF3\xB0\xB6\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6A"],
        ["\x92\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA6"],

        ["\xF3\xB0\xB6\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6B"],
        ["\x92\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA7"],

        ["\xF3\xB0\xB6\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6C"],
        ["\x92\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA8"],

        ["\xF3\xB0\xB6\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6D"],
        ["\x92\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA9"],

        ["\xF3\xB0\xB6\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6E"],
        ["\x92\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAA"],

        ["\xF3\xB0\xB6\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x6F"],
        ["\x92\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAB"],

        ["\xF3\xB0\xB6\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x70"],
        ["\x92\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAC"],

        ["\xF3\xB0\xB6\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x71"],
        ["\x92\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAD"],

        ["\xF3\xB0\xB6\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x72"],
        ["\x92\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAE"],

        ["\xF3\xB0\xB6\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x73"],
        ["\x92\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAF"],

        ["\xF3\xB0\xB6\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x74"],
        ["\x92\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB0"],

        ["\xF3\xB0\xB6\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x75"],
        ["\x92\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB1"],

        ["\xF3\xB0\xB6\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x76"],
        ["\x92\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB2"],

        ["\xF3\xB0\xB6\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x77"],
        ["\x92\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB3"],

        ["\xF3\xB0\xB6\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x78"],
        ["\x92\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB4"],

        ["\xF3\xB0\xB6\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x79"],
        ["\x92\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB5"],

        ["\xF3\xB0\xB6\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x7A"],
        ["\x92\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB6"],

        ["\xF3\xB0\xB6\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x7B"],
        ["\x92\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB7"],

        ["\xF3\xB0\xB6\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x7C"],
        ["\x92\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB8"],

        ["\xF3\xB0\xB6\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x7D"],
        ["\x92\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB9"],

        ["\xF3\xB0\xB6\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x7E"],
        ["\x92\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBA"],

        ["\xF3\xB0\xB6\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x80"],
        ["\x92\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBB"],

        ["\xF3\xB0\xB6\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x81"],
        ["\x92\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBC"],

        ["\xF3\xB0\xB6\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x82"],
        ["\x92\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBD"],

        ["\xF3\xB0\xB6\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x83"],
        ["\x92\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBE"],

        ["\xF3\xB0\xB6\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x84"],
        ["\x92\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBF"],

        ["\xF3\xB0\xB7\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x85"],
        ["\x92\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x80"],

        ["\xF3\xB0\xB7\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x86"],
        ["\x92\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x81"],

        ["\xF3\xB0\xB7\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x87"],
        ["\x92\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x82"],

        ["\xF3\xB0\xB7\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x88"],
        ["\x92\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x83"],

        ["\xF3\xB0\xB7\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x89"],
        ["\x92\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x84"],

        ["\xF3\xB0\xB7\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8A"],
        ["\x92\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x85"],

        ["\xF3\xB0\xB7\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8B"],
        ["\x92\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x86"],

        ["\xF3\xB0\xB7\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8C"],
        ["\x92\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x87"],

        ["\xF3\xB0\xB7\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8D"],
        ["\x92\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x88"],

        ["\xF3\xB0\xB7\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8E"],
        ["\x92\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x89"],

        ["\xF3\xB0\xB7\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8F"],
        ["\x92\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8A"],

        ["\xF3\xB0\xB7\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x90"],
        ["\x92\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8B"],

        ["\xF3\xB0\xB7\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x91"],
        ["\x92\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8C"],

        ["\xF3\xB0\xB7\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x92"],
        ["\x92\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8D"],

        ["\xF3\xB0\xB7\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x93"],
        ["\x92\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8E"],

        ["\xF3\xB0\xB7\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x94"],
        ["\x92\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8F"],

        ["\xF3\xB0\xB7\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x95"],
        ["\x92\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x90"],

        ["\xF3\xB0\xB7\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x96"],
        ["\x92\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x91"],

        ["\xF3\xB0\xB7\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x97"],
        ["\x92\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x92"],

        ["\xF3\xB0\xB7\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x98"],
        ["\x92\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x93"],

        ["\xF3\xB0\xB7\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x99"],
        ["\x92\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x94"],

        ["\xF3\xB0\xB7\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9A"],
        ["\x92\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x95"],

        ["\xF3\xB0\xB7\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9B"],
        ["\x92\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x96"],

        ["\xF3\xB0\xB7\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9C"],
        ["\x92\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x97"],

        ["\xF3\xB0\xB7\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9D"],
        ["\x92\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x98"],

        ["\xF3\xB0\xB7\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9E"],
        ["\x92\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x99"],

        ["\xF3\xB0\xB7\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9F"],
        ["\x92\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9A"],

        ["\xF3\xB0\xB7\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA0"],
        ["\x92\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9B"],

        ["\xF3\xB0\xB7\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA1"],
        ["\x92\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9C"],

        ["\xF3\xB0\xB7\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA2"],
        ["\x92\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9D"],

        ["\xF3\xB0\xB7\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA3"],
        ["\x92\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9E"],

        ["\xF3\xB0\xB7\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA4"],
        ["\x92\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9F"],

        ["\xF3\xB0\xB7\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA5"],
        ["\x92\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA0"],

        ["\xF3\xB0\xB7\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA6"],
        ["\x92\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA1"],

        ["\xF3\xB0\xB7\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA7"],
        ["\x92\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA2"],

        ["\xF3\xB0\xB7\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA8"],
        ["\x92\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA3"],

        ["\xF3\xB0\xB7\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA9"],
        ["\x92\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA4"],

        ["\xF3\xB0\xB7\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAA"],
        ["\x92\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA5"],

        ["\xF3\xB0\xB7\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAB"],
        ["\x92\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA6"],

        ["\xF3\xB0\xB7\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAC"],
        ["\x92\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA7"],

        ["\xF3\xB0\xB7\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAD"],
        ["\x92\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA8"],

        ["\xF3\xB0\xB7\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAE"],
        ["\x92\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA9"],

        ["\xF3\xB0\xB7\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAF"],
        ["\x92\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAA"],

        ["\xF3\xB0\xB7\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB0"],
        ["\x92\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAB"],

        ["\xF3\xB0\xB7\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB1"],
        ["\x92\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAC"],

        ["\xF3\xB0\xB7\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB2"],
        ["\x92\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAD"],

        ["\xF3\xB0\xB7\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB3"],
        ["\x92\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAE"],

        ["\xF3\xB0\xB7\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB4"],
        ["\x92\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAF"],

        ["\xF3\xB0\xB7\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB5"],
        ["\x92\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB0"],

        ["\xF3\xB0\xB7\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB6"],
        ["\x92\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB1"],

        ["\xF3\xB0\xB7\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB7"],
        ["\x92\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB2"],

        ["\xF3\xB0\xB7\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB8"],
        ["\x92\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB3"],

        ["\xF3\xB0\xB7\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB9"],
        ["\x92\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB4"],

        ["\xF3\xB0\xB7\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBA"],
        ["\x92\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB5"],

        ["\xF3\xB0\xB7\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBB"],
        ["\x92\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB6"],

        ["\xF3\xB0\xB7\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBC"],
        ["\x92\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB7"],

        ["\xF3\xB0\xB7\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBD"],
        ["\x92\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB8"],

        ["\xF3\xB0\xB7\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBE"],
        ["\x92\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB9"],

        ["\xF3\xB0\xB7\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBF"],
        ["\x92\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBA"],

        ["\xF3\xB0\xB7\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC0"],
        ["\x92\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBB"],

        ["\xF3\xB0\xB7\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC1"],
        ["\x92\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBC"],

        ["\xF3\xB0\xB7\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC2"],
        ["\x92\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBD"],

        ["\xF3\xB0\xB7\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC3"],
        ["\x92\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBE"],

        ["\xF3\xB0\xB7\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC4"],
        ["\x92\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBF"],

        ["\xF3\xB0\xB8\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC5"],
        ["\x92\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x80"],

        ["\xF3\xB0\xB8\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC6"],
        ["\x92\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x81"],

        ["\xF3\xB0\xB8\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC7"],
        ["\x92\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x82"],

        ["\xF3\xB0\xB8\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC8"],
        ["\x92\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x83"],

        ["\xF3\xB0\xB8\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xC9"],
        ["\x92\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x84"],

        ["\xF3\xB0\xB8\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCA"],
        ["\x92\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x85"],

        ["\xF3\xB0\xB8\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCB"],
        ["\x92\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x86"],

        ["\xF3\xB0\xB8\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCC"],
        ["\x92\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x87"],

        ["\xF3\xB0\xB8\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCD"],
        ["\x92\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x88"],

        ["\xF3\xB0\xB8\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCE"],
        ["\x92\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x89"],

        ["\xF3\xB0\xB8\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCF"],
        ["\x92\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8A"],

        ["\xF3\xB0\xB8\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD0"],
        ["\x92\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8B"],

        ["\xF3\xB0\xB8\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD1"],
        ["\x92\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8C"],

        ["\xF3\xB0\xB8\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD2"],
        ["\x92\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8D"],

        ["\xF3\xB0\xB8\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD3"],
        ["\x92\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8E"],

        ["\xF3\xB0\xB8\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD4"],
        ["\x92\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8F"],

        ["\xF3\xB0\xB8\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD5"],
        ["\x92\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x90"],

        ["\xF3\xB0\xB8\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD6"],
        ["\x92\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x91"],

        ["\xF3\xB0\xB8\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD7"],
        ["\x92\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x92"],

        ["\xF3\xB0\xB8\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD8"],
        ["\x92\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x93"],

        ["\xF3\xB0\xB8\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xD9"],
        ["\x92\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x94"],

        ["\xF3\xB0\xB8\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDA"],
        ["\x92\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x95"],

        ["\xF3\xB0\xB8\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDB"],
        ["\x92\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x96"],

        ["\xF3\xB0\xB8\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDC"],
        ["\x92\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x97"],

        ["\xF3\xB0\xB8\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDD"],
        ["\x92\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x98"],

        ["\xF3\xB0\xB8\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDE"],
        ["\x92\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x99"],

        ["\xF3\xB0\xB8\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDF"],
        ["\x92\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9A"],

        ["\xF3\xB0\xB8\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE0"],
        ["\x92\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9B"],

        ["\xF3\xB0\xB8\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE1"],
        ["\x92\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9C"],

        ["\xF3\xB0\xB8\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE2"],
        ["\x92\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9D"],

        ["\xF3\xB0\xB8\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE3"],
        ["\x92\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9E"],

        ["\xF3\xB0\xB8\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE4"],
        ["\x92\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9F"],

        ["\xF3\xB0\xB8\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE5"],
        ["\x92\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA0"],

        ["\xF3\xB0\xB8\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE6"],
        ["\x92\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA1"],

        ["\xF3\xB0\xB8\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE7"],
        ["\x92\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA2"],

        ["\xF3\xB0\xB8\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE8"],
        ["\x92\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA3"],

        ["\xF3\xB0\xB8\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xE9"],
        ["\x92\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA4"],

        ["\xF3\xB0\xB8\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEA"],
        ["\x92\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA5"],

        ["\xF3\xB0\xB8\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEB"],
        ["\x92\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA6"],

        ["\xF3\xB0\xB8\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEC"],
        ["\x92\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA7"],

        ["\xF3\xB0\xB8\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xED"],
        ["\x92\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA8"],

        ["\xF3\xB0\xB8\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEE"],
        ["\x92\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA9"],

        ["\xF3\xB0\xB8\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEF"],
        ["\x92\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAA"],

        ["\xF3\xB0\xB8\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF0"],
        ["\x92\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAB"],

        ["\xF3\xB0\xB8\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF1"],
        ["\x92\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAC"],

        ["\xF3\xB0\xB8\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF2"],
        ["\x92\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAD"],

        ["\xF3\xB0\xB8\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF3"],
        ["\x92\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAE"],

        ["\xF3\xB0\xB8\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF4"],
        ["\x92\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAF"],

        ["\xF3\xB0\xB8\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF5"],
        ["\x92\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB0"],

        ["\xF3\xB0\xB8\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF6"],
        ["\x92\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB1"],

        ["\xF3\xB0\xB8\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF7"],
        ["\x92\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB2"],

        ["\xF3\xB0\xB8\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF8"],
        ["\x92\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB3"],

        ["\xF3\xB0\xB8\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xF9"],
        ["\x92\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB4"],

        ["\xF3\xB0\xB8\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xFA"],
        ["\x92\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB5"],

        ["\xF3\xB0\xB8\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xFB"],
        ["\x92\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB6"],

        ["\xF3\xB0\xB8\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xFC"],
        ["\x92\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB7"],

        ["\xF3\xB0\xB8\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x40"],
        ["\x93\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB8"],

        ["\xF3\xB0\xB8\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x41"],
        ["\x93\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB9"],

        ["\xF3\xB0\xB8\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x42"],
        ["\x93\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBA"],

        ["\xF3\xB0\xB8\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x43"],
        ["\x93\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBB"],

        ["\xF3\xB0\xB8\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x44"],
        ["\x93\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBC"],

        ["\xF3\xB0\xB8\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x45"],
        ["\x93\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBD"],

        ["\xF3\xB0\xB8\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x46"],
        ["\x93\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBE"],

        ["\xF3\xB0\xB8\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x47"],
        ["\x93\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBF"],

        ["\xF3\xB0\xB9\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x48"],
        ["\x93\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x80"],

        ["\xF3\xB0\xB9\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x49"],
        ["\x93\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x81"],

        ["\xF3\xB0\xB9\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4A"],
        ["\x93\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x82"],

        ["\xF3\xB0\xB9\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4B"],
        ["\x93\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x83"],

        ["\xF3\xB0\xB9\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4C"],
        ["\x93\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x84"],

        ["\xF3\xB0\xB9\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4D"],
        ["\x93\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x85"],

        ["\xF3\xB0\xB9\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4E"],
        ["\x93\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x86"],

        ["\xF3\xB0\xB9\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x4F"],
        ["\x93\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x87"],

        ["\xF3\xB0\xB9\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x50"],
        ["\x93\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x88"],

        ["\xF3\xB0\xB9\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x51"],
        ["\x93\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x89"],

        ["\xF3\xB0\xB9\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x52"],
        ["\x93\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8A"],

        ["\xF3\xB0\xB9\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x53"],
        ["\x93\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8B"],

        ["\xF3\xB0\xB9\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x54"],
        ["\x93\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8C"],

        ["\xF3\xB0\xB9\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x55"],
        ["\x93\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8D"],

        ["\xF3\xB0\xB9\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x56"],
        ["\x93\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8E"],

        ["\xF3\xB0\xB9\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x57"],
        ["\x93\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8F"],

        ["\xF3\xB0\xB9\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x58"],
        ["\x93\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x90"],

        ["\xF3\xB0\xB9\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x59"],
        ["\x93\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x91"],

        ["\xF3\xB0\xB9\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5A"],
        ["\x93\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x92"],

        ["\xF3\xB0\xB9\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5B"],
        ["\x93\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x93"],

        ["\xF3\xB0\xB9\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5C"],
        ["\x93\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x94"],

        ["\xF3\xB0\xB9\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5D"],
        ["\x93\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x95"],

        ["\xF3\xB0\xB9\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5E"],
        ["\x93\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x96"],

        ["\xF3\xB0\xB9\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x5F"],
        ["\x93\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x97"],

        ["\xF3\xB0\xB9\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x60"],
        ["\x93\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x98"],

        ["\xF3\xB0\xB9\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x61"],
        ["\x93\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x99"],

        ["\xF3\xB0\xB9\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x62"],
        ["\x93\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9A"],

        ["\xF3\xB0\xB9\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x63"],
        ["\x93\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9B"],

        ["\xF3\xB0\xB9\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x64"],
        ["\x93\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9C"],

        ["\xF3\xB0\xB9\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x65"],
        ["\x93\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9D"],

        ["\xF3\xB0\xB9\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x66"],
        ["\x93\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9E"],

        ["\xF3\xB0\xB9\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x67"],
        ["\x93\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9F"],

        ["\xF3\xB0\xB9\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x68"],
        ["\x93\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA0"],

        ["\xF3\xB0\xB9\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x69"],
        ["\x93\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA1"],

        ["\xF3\xB0\xB9\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6A"],
        ["\x93\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA2"],

        ["\xF3\xB0\xB9\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6B"],
        ["\x93\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA3"],

        ["\xF3\xB0\xB9\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6C"],
        ["\x93\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA4"],

        ["\xF3\xB0\xB9\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6D"],
        ["\x93\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA5"],

        ["\xF3\xB0\xB9\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6E"],
        ["\x93\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA6"],

        ["\xF3\xB0\xB9\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x6F"],
        ["\x93\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA7"],

        ["\xF3\xB0\xB9\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x70"],
        ["\x93\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA8"],

        ["\xF3\xB0\xB9\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x71"],
        ["\x93\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA9"],

        ["\xF3\xB0\xB9\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x72"],
        ["\x93\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAA"],

        ["\xF3\xB0\xB9\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x73"],
        ["\x93\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAB"],

        ["\xF3\xB0\xB9\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x74"],
        ["\x93\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAC"],

        ["\xF3\xB0\xB9\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x75"],
        ["\x93\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAD"],

        ["\xF3\xB0\xB9\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x76"],
        ["\x93\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAE"],

        ["\xF3\xB0\xB9\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x77"],
        ["\x93\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAF"],

        ["\xF3\xB0\xB9\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x78"],
        ["\x93\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB0"],

        ["\xF3\xB0\xB9\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x79"],
        ["\x93\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB1"],

        ["\xF3\xB0\xB9\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x7A"],
        ["\x93\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB2"],

        ["\xF3\xB0\xB9\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x7B"],
        ["\x93\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB3"],

        ["\xF3\xB0\xB9\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x7C"],
        ["\x93\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB4"],

        ["\xF3\xB0\xB9\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x7D"],
        ["\x93\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB5"],

        ["\xF3\xB0\xB9\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x7E"],
        ["\x93\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB6"],

        ["\xF3\xB0\xB9\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x80"],
        ["\x93\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB7"],

        ["\xF3\xB0\xB9\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x81"],
        ["\x93\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB8"],

        ["\xF3\xB0\xB9\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x82"],
        ["\x93\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB9"],

        ["\xF3\xB0\xB9\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x83"],
        ["\x93\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBA"],

        ["\xF3\xB0\xB9\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x84"],
        ["\x93\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBB"],

        ["\xF3\xB0\xB9\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x85"],
        ["\x93\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBC"],

        ["\xF3\xB0\xB9\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x86"],
        ["\x93\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBD"],

        ["\xF3\xB0\xB9\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x87"],
        ["\x93\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBE"],

        ["\xF3\xB0\xB9\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x88"],
        ["\x93\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBF"],

        ["\xF3\xB0\xBA\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x89"],
        ["\x93\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x80"],

        ["\xF3\xB0\xBA\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8A"],
        ["\x93\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x81"],

        ["\xF3\xB0\xBA\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8B"],
        ["\x93\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x82"],

        ["\xF3\xB0\xBA\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8C"],
        ["\x93\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x83"],

        ["\xF3\xB0\xBA\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8D"],
        ["\x93\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x84"],

        ["\xF3\xB0\xBA\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8E"],
        ["\x93\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x85"],

        ["\xF3\xB0\xBA\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8F"],
        ["\x93\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x86"],

        ["\xF3\xB0\xBA\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x90"],
        ["\x93\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x87"],

        ["\xF3\xB0\xBA\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x91"],
        ["\x93\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x88"],

        ["\xF3\xB0\xBA\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x92"],
        ["\x93\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x89"],

        ["\xF3\xB0\xBA\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x93"],
        ["\x93\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8A"],

        ["\xF3\xB0\xBA\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x94"],
        ["\x93\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8B"],

        ["\xF3\xB0\xBA\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x95"],
        ["\x93\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8C"],

        ["\xF3\xB0\xBA\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x96"],
        ["\x93\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8D"],

        ["\xF3\xB0\xBA\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x97"],
        ["\x93\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8E"],

        ["\xF3\xB0\xBA\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x98"],
        ["\x93\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8F"],

        ["\xF3\xB0\xBA\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x99"],
        ["\x93\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x90"],

        ["\xF3\xB0\xBA\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9A"],
        ["\x93\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x91"],

        ["\xF3\xB0\xBA\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9B"],
        ["\x93\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x92"],

        ["\xF3\xB0\xBA\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9C"],
        ["\x93\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x93"],

        ["\xF3\xB0\xBA\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9D"],
        ["\x93\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x94"],

        ["\xF3\xB0\xBA\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9E"],
        ["\x93\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x95"],

        ["\xF3\xB0\xBA\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9F"],
        ["\x93\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x96"],

        ["\xF3\xB0\xBA\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA0"],
        ["\x93\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x97"],

        ["\xF3\xB0\xBA\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA1"],
        ["\x93\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x98"],

        ["\xF3\xB0\xBA\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA2"],
        ["\x93\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x99"],

        ["\xF3\xB0\xBA\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA3"],
        ["\x93\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9A"],

        ["\xF3\xB0\xBA\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA4"],
        ["\x93\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9B"],

        ["\xF3\xB0\xBA\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA5"],
        ["\x93\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9C"],

        ["\xF3\xB0\xBA\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA6"],
        ["\x93\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9D"],

        ["\xF3\xB0\xBA\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA7"],
        ["\x93\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9E"],

        ["\xF3\xB0\xBA\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA8"],
        ["\x93\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9F"],

        ["\xF3\xB0\xBA\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA9"],
        ["\x93\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA0"],

        ["\xF3\xB0\xBA\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAA"],
        ["\x93\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA1"],

        ["\xF3\xB0\xBA\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAB"],
        ["\x93\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA2"],

        ["\xF3\xB0\xBA\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAC"],
        ["\x93\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA3"],

        ["\xF3\xB0\xBA\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAD"],
        ["\x93\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA4"],

        ["\xF3\xB0\xBA\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAE"],
        ["\x93\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA5"],

        ["\xF3\xB0\xBA\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xAF"],
        ["\x93\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA6"],

        ["\xF3\xB0\xBA\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB0"],
        ["\x93\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA7"],

        ["\xF3\xB0\xBA\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB1"],
        ["\x93\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA8"],

        ["\xF3\xB0\xBA\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB2"],
        ["\x93\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA9"],

        ["\xF3\xB0\xBA\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB3"],
        ["\x93\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAA"],

        ["\xF3\xB0\xBA\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB4"],
        ["\x93\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAB"],

        ["\xF3\xB0\xBA\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB5"],
        ["\x93\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAC"],

        ["\xF3\xB0\xBA\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB6"],
        ["\x93\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAD"],

        ["\xF3\xB0\xBA\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB7"],
        ["\x93\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAE"],

        ["\xF3\xB0\xBA\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB8"],
        ["\x93\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAF"],

        ["\xF3\xB0\xBA\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB9"],
        ["\x93\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB0"],

        ["\xF3\xB0\xBA\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBA"],
        ["\x93\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB1"],

        ["\xF3\xB0\xBA\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBB"],
        ["\x93\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB2"],

        ["\xF3\xB0\xBA\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBC"],
        ["\x93\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB3"],

        ["\xF3\xB0\xBA\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBD"],
        ["\x93\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB4"],

        ["\xF3\xB0\xBA\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBE"],
        ["\x93\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB5"],

        ["\xF3\xB0\xBA\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBF"],
        ["\x93\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB6"],

        ["\xF3\xB0\xBA\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC0"],
        ["\x93\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB7"],

        ["\xF3\xB0\xBA\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC1"],
        ["\x93\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB8"],

        ["\xF3\xB0\xBA\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC2"],
        ["\x93\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB9"],

        ["\xF3\xB0\xBA\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC3"],
        ["\x93\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBA"],

        ["\xF3\xB0\xBA\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC4"],
        ["\x93\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBB"],

        ["\xF3\xB0\xBA\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC5"],
        ["\x93\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBC"],

        ["\xF3\xB0\xBA\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC6"],
        ["\x93\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBD"],

        ["\xF3\xB0\xBA\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC7"],
        ["\x93\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBE"],

        ["\xF3\xB0\xBA\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC8"],
        ["\x93\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBF"],

        ["\xF3\xB0\xBB\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xC9"],
        ["\x93\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x80"],

        ["\xF3\xB0\xBB\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCA"],
        ["\x93\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x81"],

        ["\xF3\xB0\xBB\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCB"],
        ["\x93\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x82"],

        ["\xF3\xB0\xBB\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCC"],
        ["\x93\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x83"],

        ["\xF3\xB0\xBB\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCD"],
        ["\x93\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x84"],

        ["\xF3\xB0\xBB\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCE"],
        ["\x93\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x85"],

        ["\xF3\xB0\xBB\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCF"],
        ["\x93\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x86"],

        ["\xF3\xB0\xBB\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD0"],
        ["\x93\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x87"],

        ["\xF3\xB0\xBB\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD1"],
        ["\x93\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x88"],

        ["\xF3\xB0\xBB\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD2"],
        ["\x93\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x89"],

        ["\xF3\xB0\xBB\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD3"],
        ["\x93\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8A"],

        ["\xF3\xB0\xBB\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD4"],
        ["\x93\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8B"],

        ["\xF3\xB0\xBB\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD5"],
        ["\x93\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8C"],

        ["\xF3\xB0\xBB\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD6"],
        ["\x93\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8D"],

        ["\xF3\xB0\xBB\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD7"],
        ["\x93\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8E"],

        ["\xF3\xB0\xBB\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD8"],
        ["\x93\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8F"],

        ["\xF3\xB0\xBB\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xD9"],
        ["\x93\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x90"],

        ["\xF3\xB0\xBB\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDA"],
        ["\x93\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x91"],

        ["\xF3\xB0\xBB\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDB"],
        ["\x93\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x92"],

        ["\xF3\xB0\xBB\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDC"],
        ["\x93\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x93"],

        ["\xF3\xB0\xBB\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDD"],
        ["\x93\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x94"],

        ["\xF3\xB0\xBB\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDE"],
        ["\x93\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x95"],

        ["\xF3\xB0\xBB\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDF"],
        ["\x93\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x96"],

        ["\xF3\xB0\xBB\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE0"],
        ["\x93\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x97"],

        ["\xF3\xB0\xBB\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE1"],
        ["\x93\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x98"],

        ["\xF3\xB0\xBB\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE2"],
        ["\x93\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x99"],

        ["\xF3\xB0\xBB\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE3"],
        ["\x93\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9A"],

        ["\xF3\xB0\xBB\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE4"],
        ["\x93\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9B"],

        ["\xF3\xB0\xBB\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE5"],
        ["\x93\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9C"],

        ["\xF3\xB0\xBB\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE6"],
        ["\x93\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9D"],

        ["\xF3\xB0\xBB\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE7"],
        ["\x93\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9E"],

        ["\xF3\xB0\xBB\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE8"],
        ["\x93\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9F"],

        ["\xF3\xB0\xBB\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xE9"],
        ["\x93\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA0"],

        ["\xF3\xB0\xBB\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEA"],
        ["\x93\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA1"],

        ["\xF3\xB0\xBB\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEB"],
        ["\x93\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA2"],

        ["\xF3\xB0\xBB\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEC"],
        ["\x93\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA3"],

        ["\xF3\xB0\xBB\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xED"],
        ["\x93\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA4"],

        ["\xF3\xB0\xBB\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEE"],
        ["\x93\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA5"],

        ["\xF3\xB0\xBB\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEF"],
        ["\x93\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA6"],

        ["\xF3\xB0\xBB\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF0"],
        ["\x93\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA7"],

        ["\xF3\xB0\xBB\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF1"],
        ["\x93\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA8"],

        ["\xF3\xB0\xBB\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF2"],
        ["\x93\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA9"],

        ["\xF3\xB0\xBB\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF3"],
        ["\x93\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAA"],

        ["\xF3\xB0\xBB\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF4"],
        ["\x93\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAB"],

        ["\xF3\xB0\xBB\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF5"],
        ["\x93\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAC"],

        ["\xF3\xB0\xBB\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF6"],
        ["\x93\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAD"],

        ["\xF3\xB0\xBB\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF7"],
        ["\x93\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAE"],

        ["\xF3\xB0\xBB\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF8"],
        ["\x93\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAF"],

        ["\xF3\xB0\xBB\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xF9"],
        ["\x93\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB0"],

        ["\xF3\xB0\xBB\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFA"],
        ["\x93\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB1"],

        ["\xF3\xB0\xBB\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFB"],
        ["\x93\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB2"],

        ["\xF3\xB0\xBB\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFC"],
        ["\x93\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB3"],

        ["\xF3\xB0\xBB\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x40"],
        ["\x94\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB4"],

        ["\xF3\xB0\xBB\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x41"],
        ["\x94\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB5"],

        ["\xF3\xB0\xBB\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x42"],
        ["\x94\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB6"],

        ["\xF3\xB0\xBB\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x43"],
        ["\x94\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB7"],

        ["\xF3\xB0\xBB\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x44"],
        ["\x94\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB8"],

        ["\xF3\xB0\xBB\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x45"],
        ["\x94\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB9"],

        ["\xF3\xB0\xBB\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x46"],
        ["\x94\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBA"],

        ["\xF3\xB0\xBB\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x47"],
        ["\x94\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBB"],

        ["\xF3\xB0\xBB\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x48"],
        ["\x94\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBC"],

        ["\xF3\xB0\xBB\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x49"],
        ["\x94\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBD"],

        ["\xF3\xB0\xBB\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4A"],
        ["\x94\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBE"],

        ["\xF3\xB0\xBB\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4B"],
        ["\x94\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBF"],

        ["\xF3\xB0\xBC\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4C"],
        ["\x94\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x80"],

        ["\xF3\xB0\xBC\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4D"],
        ["\x94\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x81"],

        ["\xF3\xB0\xBC\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4E"],
        ["\x94\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x82"],

        ["\xF3\xB0\xBC\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x4F"],
        ["\x94\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x83"],

        ["\xF3\xB0\xBC\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x50"],
        ["\x94\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x84"],

        ["\xF3\xB0\xBC\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x51"],
        ["\x94\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x85"],

        ["\xF3\xB0\xBC\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x52"],
        ["\x94\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x86"],

        ["\xF3\xB0\xBC\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x53"],
        ["\x94\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x87"],

        ["\xF3\xB0\xBC\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x54"],
        ["\x94\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x88"],

        ["\xF3\xB0\xBC\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x55"],
        ["\x94\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x89"],

        ["\xF3\xB0\xBC\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x56"],
        ["\x94\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8A"],

        ["\xF3\xB0\xBC\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x57"],
        ["\x94\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8B"],

        ["\xF3\xB0\xBC\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x58"],
        ["\x94\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8C"],

        ["\xF3\xB0\xBC\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x59"],
        ["\x94\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8D"],

        ["\xF3\xB0\xBC\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5A"],
        ["\x94\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8E"],

        ["\xF3\xB0\xBC\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5B"],
        ["\x94\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8F"],

        ["\xF3\xB0\xBC\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5C"],
        ["\x94\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x90"],

        ["\xF3\xB0\xBC\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5D"],
        ["\x94\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x91"],

        ["\xF3\xB0\xBC\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5E"],
        ["\x94\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x92"],

        ["\xF3\xB0\xBC\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x5F"],
        ["\x94\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x93"],

        ["\xF3\xB0\xBC\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x60"],
        ["\x94\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x94"],

        ["\xF3\xB0\xBC\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x61"],
        ["\x94\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x95"],

        ["\xF3\xB0\xBC\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x62"],
        ["\x94\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x96"],

        ["\xF3\xB0\xBC\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x63"],
        ["\x94\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x97"],

        ["\xF3\xB0\xBC\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x64"],
        ["\x94\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x98"],

        ["\xF3\xB0\xBC\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x65"],
        ["\x94\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x99"],

        ["\xF3\xB0\xBC\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x66"],
        ["\x94\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9A"],

        ["\xF3\xB0\xBC\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x67"],
        ["\x94\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9B"],

        ["\xF3\xB0\xBC\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x68"],
        ["\x94\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9C"],

        ["\xF3\xB0\xBC\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x69"],
        ["\x94\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9D"],

        ["\xF3\xB0\xBC\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6A"],
        ["\x94\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9E"],

        ["\xF3\xB0\xBC\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6B"],
        ["\x94\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9F"],

        ["\xF3\xB0\xBC\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6C"],
        ["\x94\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA0"],

        ["\xF3\xB0\xBC\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6D"],
        ["\x94\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA1"],

        ["\xF3\xB0\xBC\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6E"],
        ["\x94\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA2"],

        ["\xF3\xB0\xBC\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x6F"],
        ["\x94\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA3"],

        ["\xF3\xB0\xBC\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x70"],
        ["\x94\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA4"],

        ["\xF3\xB0\xBC\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x71"],
        ["\x94\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA5"],

        ["\xF3\xB0\xBC\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x72"],
        ["\x94\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA6"],

        ["\xF3\xB0\xBC\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x73"],
        ["\x94\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA7"],

        ["\xF3\xB0\xBC\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x74"],
        ["\x94\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA8"],

        ["\xF3\xB0\xBC\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x75"],
        ["\x94\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA9"],

        ["\xF3\xB0\xBC\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x76"],
        ["\x94\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAA"],

        ["\xF3\xB0\xBC\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x77"],
        ["\x94\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAB"],

        ["\xF3\xB0\xBC\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x78"],
        ["\x94\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAC"],

        ["\xF3\xB0\xBC\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x79"],
        ["\x94\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAD"],

        ["\xF3\xB0\xBC\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x7A"],
        ["\x94\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAE"],

        ["\xF3\xB0\xBC\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x7B"],
        ["\x94\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAF"],

        ["\xF3\xB0\xBC\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x7C"],
        ["\x94\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB0"],

        ["\xF3\xB0\xBC\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x7D"],
        ["\x94\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB1"],

        ["\xF3\xB0\xBC\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x7E"],
        ["\x94\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB2"],

        ["\xF3\xB0\xBC\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x80"],
        ["\x94\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB3"],

        ["\xF3\xB0\xBC\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x81"],
        ["\x94\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB4"],

        ["\xF3\xB0\xBC\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x82"],
        ["\x94\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB5"],

        ["\xF3\xB0\xBC\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x83"],
        ["\x94\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB6"],

        ["\xF3\xB0\xBC\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x84"],
        ["\x94\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB7"],

        ["\xF3\xB0\xBC\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x85"],
        ["\x94\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB8"],

        ["\xF3\xB0\xBC\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x86"],
        ["\x94\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB9"],

        ["\xF3\xB0\xBC\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x87"],
        ["\x94\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBA"],

        ["\xF3\xB0\xBC\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x88"],
        ["\x94\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBB"],

        ["\xF3\xB0\xBC\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x89"],
        ["\x94\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBC"],

        ["\xF3\xB0\xBC\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8A"],
        ["\x94\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBD"],

        ["\xF3\xB0\xBC\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8B"],
        ["\x94\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBE"],

        ["\xF3\xB0\xBC\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8C"],
        ["\x94\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBF"],

        ["\xF3\xB0\xBD\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8D"],
        ["\x94\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x80"],

        ["\xF3\xB0\xBD\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8E"],
        ["\x94\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x81"],

        ["\xF3\xB0\xBD\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8F"],
        ["\x94\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x82"],

        ["\xF3\xB0\xBD\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x90"],
        ["\x94\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x83"],

        ["\xF3\xB0\xBD\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x91"],
        ["\x94\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x84"],

        ["\xF3\xB0\xBD\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x92"],
        ["\x94\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x85"],

        ["\xF3\xB0\xBD\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x93"],
        ["\x94\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x86"],

        ["\xF3\xB0\xBD\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x94"],
        ["\x94\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x87"],

        ["\xF3\xB0\xBD\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x95"],
        ["\x94\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x88"],

        ["\xF3\xB0\xBD\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x96"],
        ["\x94\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x89"],

        ["\xF3\xB0\xBD\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x97"],
        ["\x94\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8A"],

        ["\xF3\xB0\xBD\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x98"],
        ["\x94\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8B"],

        ["\xF3\xB0\xBD\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x99"],
        ["\x94\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8C"],

        ["\xF3\xB0\xBD\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9A"],
        ["\x94\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8D"],

        ["\xF3\xB0\xBD\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9B"],
        ["\x94\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8E"],

        ["\xF3\xB0\xBD\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9C"],
        ["\x94\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8F"],

        ["\xF3\xB0\xBD\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9D"],
        ["\x94\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x90"],

        ["\xF3\xB0\xBD\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9E"],
        ["\x94\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x91"],

        ["\xF3\xB0\xBD\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9F"],
        ["\x94\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x92"],

        ["\xF3\xB0\xBD\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA0"],
        ["\x94\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x93"],

        ["\xF3\xB0\xBD\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA1"],
        ["\x94\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x94"],

        ["\xF3\xB0\xBD\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA2"],
        ["\x94\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x95"],

        ["\xF3\xB0\xBD\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA3"],
        ["\x94\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x96"],

        ["\xF3\xB0\xBD\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA4"],
        ["\x94\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x97"],

        ["\xF3\xB0\xBD\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA5"],
        ["\x94\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x98"],

        ["\xF3\xB0\xBD\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA6"],
        ["\x94\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x99"],

        ["\xF3\xB0\xBD\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA7"],
        ["\x94\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9A"],

        ["\xF3\xB0\xBD\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA8"],
        ["\x94\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9B"],

        ["\xF3\xB0\xBD\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA9"],
        ["\x94\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9C"],

        ["\xF3\xB0\xBD\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAA"],
        ["\x94\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9D"],

        ["\xF3\xB0\xBD\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAB"],
        ["\x94\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9E"],

        ["\xF3\xB0\xBD\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAC"],
        ["\x94\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9F"],

        ["\xF3\xB0\xBD\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAD"],
        ["\x94\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA0"],

        ["\xF3\xB0\xBD\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAE"],
        ["\x94\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA1"],

        ["\xF3\xB0\xBD\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAF"],
        ["\x94\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA2"],

        ["\xF3\xB0\xBD\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB0"],
        ["\x94\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA3"],

        ["\xF3\xB0\xBD\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB1"],
        ["\x94\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA4"],

        ["\xF3\xB0\xBD\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB2"],
        ["\x94\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA5"],

        ["\xF3\xB0\xBD\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB3"],
        ["\x94\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA6"],

        ["\xF3\xB0\xBD\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB4"],
        ["\x94\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA7"],

        ["\xF3\xB0\xBD\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB5"],
        ["\x94\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA8"],

        ["\xF3\xB0\xBD\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB6"],
        ["\x94\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA9"],

        ["\xF3\xB0\xBD\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB7"],
        ["\x94\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAA"],

        ["\xF3\xB0\xBD\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB8"],
        ["\x94\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAB"],

        ["\xF3\xB0\xBD\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB9"],
        ["\x94\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAC"],

        ["\xF3\xB0\xBD\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBA"],
        ["\x94\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAD"],

        ["\xF3\xB0\xBD\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBB"],
        ["\x94\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAE"],

        ["\xF3\xB0\xBD\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBC"],
        ["\x94\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAF"],

        ["\xF3\xB0\xBD\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBD"],
        ["\x94\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB0"],

        ["\xF3\xB0\xBD\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBE"],
        ["\x94\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB1"],

        ["\xF3\xB0\xBD\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xBF"],
        ["\x94\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB2"],

        ["\xF3\xB0\xBD\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC0"],
        ["\x94\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB3"],

        ["\xF3\xB0\xBD\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC1"],
        ["\x94\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB4"],

        ["\xF3\xB0\xBD\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC2"],
        ["\x94\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB5"],

        ["\xF3\xB0\xBD\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC3"],
        ["\x94\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB6"],

        ["\xF3\xB0\xBD\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC4"],
        ["\x94\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB7"],

        ["\xF3\xB0\xBD\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC5"],
        ["\x94\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB8"],

        ["\xF3\xB0\xBD\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC6"],
        ["\x94\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB9"],

        ["\xF3\xB0\xBD\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC7"],
        ["\x94\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBA"],

        ["\xF3\xB0\xBD\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC8"],
        ["\x94\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBB"],

        ["\xF3\xB0\xBD\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xC9"],
        ["\x94\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBC"],

        ["\xF3\xB0\xBD\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCA"],
        ["\x94\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBD"],

        ["\xF3\xB0\xBD\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCB"],
        ["\x94\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBE"],

        ["\xF3\xB0\xBD\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCC"],
        ["\x94\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBF"],

        ["\xF3\xB0\xBE\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCD"],
        ["\x94\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x80"],

        ["\xF3\xB0\xBE\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCE"],
        ["\x94\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x81"],

        ["\xF3\xB0\xBE\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCF"],
        ["\x94\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x82"],

        ["\xF3\xB0\xBE\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD0"],
        ["\x94\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x83"],

        ["\xF3\xB0\xBE\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD1"],
        ["\x94\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x84"],

        ["\xF3\xB0\xBE\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD2"],
        ["\x94\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x85"],

        ["\xF3\xB0\xBE\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD3"],
        ["\x94\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x86"],

        ["\xF3\xB0\xBE\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD4"],
        ["\x94\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x87"],

        ["\xF3\xB0\xBE\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD5"],
        ["\x94\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x88"],

        ["\xF3\xB0\xBE\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD6"],
        ["\x94\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x89"],

        ["\xF3\xB0\xBE\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD7"],
        ["\x94\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8A"],

        ["\xF3\xB0\xBE\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD8"],
        ["\x94\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8B"],

        ["\xF3\xB0\xBE\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xD9"],
        ["\x94\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8C"],

        ["\xF3\xB0\xBE\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDA"],
        ["\x94\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8D"],

        ["\xF3\xB0\xBE\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDB"],
        ["\x94\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8E"],

        ["\xF3\xB0\xBE\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDC"],
        ["\x94\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8F"],

        ["\xF3\xB0\xBE\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDD"],
        ["\x94\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x90"],

        ["\xF3\xB0\xBE\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDE"],
        ["\x94\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x91"],

        ["\xF3\xB0\xBE\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDF"],
        ["\x94\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x92"],

        ["\xF3\xB0\xBE\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE0"],
        ["\x94\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x93"],

        ["\xF3\xB0\xBE\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE1"],
        ["\x94\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x94"],

        ["\xF3\xB0\xBE\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE2"],
        ["\x94\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x95"],

        ["\xF3\xB0\xBE\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE3"],
        ["\x94\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x96"],

        ["\xF3\xB0\xBE\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE4"],
        ["\x94\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x97"],

        ["\xF3\xB0\xBE\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE5"],
        ["\x94\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x98"],

        ["\xF3\xB0\xBE\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE6"],
        ["\x94\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x99"],

        ["\xF3\xB0\xBE\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE7"],
        ["\x94\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9A"],

        ["\xF3\xB0\xBE\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE8"],
        ["\x94\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9B"],

        ["\xF3\xB0\xBE\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xE9"],
        ["\x94\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9C"],

        ["\xF3\xB0\xBE\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEA"],
        ["\x94\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9D"],

        ["\xF3\xB0\xBE\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEB"],
        ["\x94\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9E"],

        ["\xF3\xB0\xBE\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEC"],
        ["\x94\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9F"],

        ["\xF3\xB0\xBE\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xED"],
        ["\x94\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA0"],

        ["\xF3\xB0\xBE\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEE"],
        ["\x94\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA1"],

        ["\xF3\xB0\xBE\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEF"],
        ["\x94\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA2"],

        ["\xF3\xB0\xBE\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF0"],
        ["\x94\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA3"],

        ["\xF3\xB0\xBE\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF1"],
        ["\x94\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA4"],

        ["\xF3\xB0\xBE\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF2"],
        ["\x94\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA5"],

        ["\xF3\xB0\xBE\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF3"],
        ["\x94\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA6"],

        ["\xF3\xB0\xBE\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF4"],
        ["\x94\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA7"],

        ["\xF3\xB0\xBE\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF5"],
        ["\x94\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA8"],

        ["\xF3\xB0\xBE\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF6"],
        ["\x94\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA9"],

        ["\xF3\xB0\xBE\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF7"],
        ["\x94\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAA"],

        ["\xF3\xB0\xBE\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF8"],
        ["\x94\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAB"],

        ["\xF3\xB0\xBE\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xF9"],
        ["\x94\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAC"],

        ["\xF3\xB0\xBE\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xFA"],
        ["\x94\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAD"],

        ["\xF3\xB0\xBE\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xFB"],
        ["\x94\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAE"],

        ["\xF3\xB0\xBE\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xFC"],
        ["\x94\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAF"],

        ["\xF3\xB0\xBE\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x40"],
        ["\x95\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB0"],

        ["\xF3\xB0\xBE\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x41"],
        ["\x95\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB1"],

        ["\xF3\xB0\xBE\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x42"],
        ["\x95\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB2"],

        ["\xF3\xB0\xBE\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x43"],
        ["\x95\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB3"],

        ["\xF3\xB0\xBE\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x44"],
        ["\x95\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB4"],

        ["\xF3\xB0\xBE\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x45"],
        ["\x95\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB5"],

        ["\xF3\xB0\xBE\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x46"],
        ["\x95\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB6"],

        ["\xF3\xB0\xBE\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x47"],
        ["\x95\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB7"],

        ["\xF3\xB0\xBE\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x48"],
        ["\x95\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB8"],

        ["\xF3\xB0\xBE\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x49"],
        ["\x95\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB9"],

        ["\xF3\xB0\xBE\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4A"],
        ["\x95\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBA"],

        ["\xF3\xB0\xBE\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4B"],
        ["\x95\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBB"],

        ["\xF3\xB0\xBE\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4C"],
        ["\x95\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBC"],

        ["\xF3\xB0\xBE\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4D"],
        ["\x95\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBD"],

        ["\xF3\xB0\xBE\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4E"],
        ["\x95\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBE"],

        ["\xF3\xB0\xBE\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x4F"],
        ["\x95\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBF"],

        ["\xF3\xB0\xBF\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x50"],
        ["\x95\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x80"],

        ["\xF3\xB0\xBF\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x51"],
        ["\x95\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x81"],

        ["\xF3\xB0\xBF\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x52"],
        ["\x95\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x82"],

        ["\xF3\xB0\xBF\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x53"],
        ["\x95\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x83"],

        ["\xF3\xB0\xBF\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x54"],
        ["\x95\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x84"],

        ["\xF3\xB0\xBF\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x55"],
        ["\x95\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x85"],

        ["\xF3\xB0\xBF\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x56"],
        ["\x95\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x86"],

        ["\xF3\xB0\xBF\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x57"],
        ["\x95\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x87"],

        ["\xF3\xB0\xBF\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x58"],
        ["\x95\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x88"],

        ["\xF3\xB0\xBF\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x59"],
        ["\x95\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x89"],

        ["\xF3\xB0\xBF\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5A"],
        ["\x95\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8A"],

        ["\xF3\xB0\xBF\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5B"],
        ["\x95\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8B"],

        ["\xF3\xB0\xBF\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5C"],
        ["\x95\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8C"],

        ["\xF3\xB0\xBF\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5D"],
        ["\x95\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8D"],

        ["\xF3\xB0\xBF\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5E"],
        ["\x95\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8E"],

        ["\xF3\xB0\xBF\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x5F"],
        ["\x95\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8F"],

        ["\xF3\xB0\xBF\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x60"],
        ["\x95\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x90"],

        ["\xF3\xB0\xBF\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x61"],
        ["\x95\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x91"],

        ["\xF3\xB0\xBF\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x62"],
        ["\x95\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x92"],

        ["\xF3\xB0\xBF\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x63"],
        ["\x95\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x93"],

        ["\xF3\xB0\xBF\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x64"],
        ["\x95\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x94"],

        ["\xF3\xB0\xBF\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x65"],
        ["\x95\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x95"],

        ["\xF3\xB0\xBF\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x66"],
        ["\x95\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x96"],

        ["\xF3\xB0\xBF\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x67"],
        ["\x95\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x97"],

        ["\xF3\xB0\xBF\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x68"],
        ["\x95\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x98"],

        ["\xF3\xB0\xBF\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x69"],
        ["\x95\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x99"],

        ["\xF3\xB0\xBF\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6A"],
        ["\x95\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9A"],

        ["\xF3\xB0\xBF\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6B"],
        ["\x95\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9B"],

        ["\xF3\xB0\xBF\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6C"],
        ["\x95\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9C"],

        ["\xF3\xB0\xBF\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6D"],
        ["\x95\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9D"],

        ["\xF3\xB0\xBF\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6E"],
        ["\x95\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9E"],

        ["\xF3\xB0\xBF\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x6F"],
        ["\x95\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9F"],

        ["\xF3\xB0\xBF\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x70"],
        ["\x95\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA0"],

        ["\xF3\xB0\xBF\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x71"],
        ["\x95\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA1"],

        ["\xF3\xB0\xBF\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x72"],
        ["\x95\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA2"],

        ["\xF3\xB0\xBF\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x73"],
        ["\x95\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA3"],

        ["\xF3\xB0\xBF\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x74"],
        ["\x95\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA4"],

        ["\xF3\xB0\xBF\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x75"],
        ["\x95\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA5"],

        ["\xF3\xB0\xBF\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x76"],
        ["\x95\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA6"],

        ["\xF3\xB0\xBF\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x77"],
        ["\x95\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA7"],

        ["\xF3\xB0\xBF\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x78"],
        ["\x95\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA8"],

        ["\xF3\xB0\xBF\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x79"],
        ["\x95\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA9"],

        ["\xF3\xB0\xBF\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x7A"],
        ["\x95\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAA"],

        ["\xF3\xB0\xBF\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x7B"],
        ["\x95\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAB"],

        ["\xF3\xB0\xBF\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x7C"],
        ["\x95\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAC"],

        ["\xF3\xB0\xBF\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x7D"],
        ["\x95\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAD"],

        ["\xF3\xB0\xBF\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x7E"],
        ["\x95\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAE"],

        ["\xF3\xB0\xBF\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x80"],
        ["\x95\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAF"],

        ["\xF3\xB0\xBF\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x81"],
        ["\x95\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB0"],

        ["\xF3\xB0\xBF\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x82"],
        ["\x95\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB1"],

        ["\xF3\xB0\xBF\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x83"],
        ["\x95\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB2"],

        ["\xF3\xB0\xBF\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x84"],
        ["\x95\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB3"],

        ["\xF3\xB0\xBF\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x85"],
        ["\x95\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB4"],

        ["\xF3\xB0\xBF\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x86"],
        ["\x95\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB5"],

        ["\xF3\xB0\xBF\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x87"],
        ["\x95\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB6"],

        ["\xF3\xB0\xBF\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x88"],
        ["\x95\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB7"],

        ["\xF3\xB0\xBF\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x89"],
        ["\x95\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB8"],

        ["\xF3\xB0\xBF\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8A"],
        ["\x95\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB9"],

        ["\xF3\xB0\xBF\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8B"],
        ["\x95\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBA"],

        ["\xF3\xB0\xBF\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8C"],
        ["\x95\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBB"],

        ["\xF3\xB0\xBF\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8D"],
        ["\x95\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBC"],

        ["\xF3\xB0\xBF\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8E"],
        ["\x95\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBD"],

        ["\xF3\xB0\xBF\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8F"],
        ["\x95\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBE"],

        ["\xF3\xB0\xBF\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x90"],
        ["\x95\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBF"],

        ["\xF3\xB1\x80\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x91"],
        ["\x95\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x80"],

        ["\xF3\xB1\x80\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x92"],
        ["\x95\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x81"],

        ["\xF3\xB1\x80\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x93"],
        ["\x95\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x82"],

        ["\xF3\xB1\x80\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x94"],
        ["\x95\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x83"],

        ["\xF3\xB1\x80\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x95"],
        ["\x95\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x84"],

        ["\xF3\xB1\x80\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x96"],
        ["\x95\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x85"],

        ["\xF3\xB1\x80\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x97"],
        ["\x95\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x86"],

        ["\xF3\xB1\x80\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x98"],
        ["\x95\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x87"],

        ["\xF3\xB1\x80\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x99"],
        ["\x95\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x88"],

        ["\xF3\xB1\x80\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9A"],
        ["\x95\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x89"],

        ["\xF3\xB1\x80\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9B"],
        ["\x95\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8A"],

        ["\xF3\xB1\x80\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9C"],
        ["\x95\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8B"],

        ["\xF3\xB1\x80\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9D"],
        ["\x95\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8C"],

        ["\xF3\xB1\x80\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9E"],
        ["\x95\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8D"],

        ["\xF3\xB1\x80\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9F"],
        ["\x95\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8E"],

        ["\xF3\xB1\x80\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA0"],
        ["\x95\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8F"],

        ["\xF3\xB1\x80\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA1"],
        ["\x95\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x90"],

        ["\xF3\xB1\x80\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA2"],
        ["\x95\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x91"],

        ["\xF3\xB1\x80\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA3"],
        ["\x95\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x92"],

        ["\xF3\xB1\x80\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA4"],
        ["\x95\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x93"],

        ["\xF3\xB1\x80\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA5"],
        ["\x95\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x94"],

        ["\xF3\xB1\x80\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA6"],
        ["\x95\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x95"],

        ["\xF3\xB1\x80\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA7"],
        ["\x95\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x96"],

        ["\xF3\xB1\x80\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA8"],
        ["\x95\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x97"],

        ["\xF3\xB1\x80\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA9"],
        ["\x95\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x98"],

        ["\xF3\xB1\x80\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAA"],
        ["\x95\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x99"],

        ["\xF3\xB1\x80\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAB"],
        ["\x95\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9A"],

        ["\xF3\xB1\x80\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAC"],
        ["\x95\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9B"],

        ["\xF3\xB1\x80\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAD"],
        ["\x95\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9C"],

        ["\xF3\xB1\x80\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAE"],
        ["\x95\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9D"],

        ["\xF3\xB1\x80\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAF"],
        ["\x95\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9E"],

        ["\xF3\xB1\x80\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB0"],
        ["\x95\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9F"],

        ["\xF3\xB1\x80\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB1"],
        ["\x95\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA0"],

        ["\xF3\xB1\x80\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB2"],
        ["\x95\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA1"],

        ["\xF3\xB1\x80\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB3"],
        ["\x95\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA2"],

        ["\xF3\xB1\x80\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB4"],
        ["\x95\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA3"],

        ["\xF3\xB1\x80\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB5"],
        ["\x95\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA4"],

        ["\xF3\xB1\x80\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB6"],
        ["\x95\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA5"],

        ["\xF3\xB1\x80\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB7"],
        ["\x95\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA6"],

        ["\xF3\xB1\x80\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB8"],
        ["\x95\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA7"],

        ["\xF3\xB1\x80\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB9"],
        ["\x95\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA8"],

        ["\xF3\xB1\x80\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBA"],
        ["\x95\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA9"],

        ["\xF3\xB1\x80\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBB"],
        ["\x95\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAA"],

        ["\xF3\xB1\x80\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBC"],
        ["\x95\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAB"],

        ["\xF3\xB1\x80\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBD"],
        ["\x95\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAC"],

        ["\xF3\xB1\x80\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBE"],
        ["\x95\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAD"],

        ["\xF3\xB1\x80\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBF"],
        ["\x95\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAE"],

        ["\xF3\xB1\x80\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC0"],
        ["\x95\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAF"],

        ["\xF3\xB1\x80\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC1"],
        ["\x95\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB0"],

        ["\xF3\xB1\x80\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC2"],
        ["\x95\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB1"],

        ["\xF3\xB1\x80\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC3"],
        ["\x95\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB2"],

        ["\xF3\xB1\x80\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC4"],
        ["\x95\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB3"],

        ["\xF3\xB1\x80\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC5"],
        ["\x95\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB4"],

        ["\xF3\xB1\x80\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC6"],
        ["\x95\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB5"],

        ["\xF3\xB1\x80\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC7"],
        ["\x95\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB6"],

        ["\xF3\xB1\x80\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC8"],
        ["\x95\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB7"],

        ["\xF3\xB1\x80\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xC9"],
        ["\x95\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB8"],

        ["\xF3\xB1\x80\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],
        ["\x95\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB9"],

        ["\xF3\xB1\x80\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCB"],
        ["\x95\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBA"],

        ["\xF3\xB1\x80\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCC"],
        ["\x95\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBB"],

        ["\xF3\xB1\x80\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCD"],
        ["\x95\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBC"],

        ["\xF3\xB1\x80\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCE"],
        ["\x95\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBD"],

        ["\xF3\xB1\x80\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCF"],
        ["\x95\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBE"],

        ["\xF3\xB1\x80\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD0"],
        ["\x95\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBF"],

        ["\xF3\xB1\x81\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD1"],
        ["\x95\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x80"],

        ["\xF3\xB1\x81\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD2"],
        ["\x95\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x81"],

        ["\xF3\xB1\x81\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD3"],
        ["\x95\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x82"],

        ["\xF3\xB1\x81\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD4"],
        ["\x95\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x83"],

        ["\xF3\xB1\x81\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD5"],
        ["\x95\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x84"],

        ["\xF3\xB1\x81\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD6"],
        ["\x95\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x85"],

        ["\xF3\xB1\x81\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD7"],
        ["\x95\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x86"],

        ["\xF3\xB1\x81\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD8"],
        ["\x95\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x87"],

        ["\xF3\xB1\x81\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xD9"],
        ["\x95\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x88"],

        ["\xF3\xB1\x81\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDA"],
        ["\x95\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x89"],

        ["\xF3\xB1\x81\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDB"],
        ["\x95\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8A"],

        ["\xF3\xB1\x81\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDC"],
        ["\x95\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8B"],

        ["\xF3\xB1\x81\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDD"],
        ["\x95\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8C"],

        ["\xF3\xB1\x81\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDE"],
        ["\x95\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8D"],

        ["\xF3\xB1\x81\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDF"],
        ["\x95\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8E"],

        ["\xF3\xB1\x81\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE0"],
        ["\x95\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8F"],

        ["\xF3\xB1\x81\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE1"],
        ["\x95\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x90"],

        ["\xF3\xB1\x81\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE2"],
        ["\x95\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x91"],

        ["\xF3\xB1\x81\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE3"],
        ["\x95\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x92"],

        ["\xF3\xB1\x81\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE4"],
        ["\x95\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x93"],

        ["\xF3\xB1\x81\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE5"],
        ["\x95\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x94"],

        ["\xF3\xB1\x81\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE6"],
        ["\x95\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x95"],

        ["\xF3\xB1\x81\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE7"],
        ["\x95\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x96"],

        ["\xF3\xB1\x81\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE8"],
        ["\x95\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x97"],

        ["\xF3\xB1\x81\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xE9"],
        ["\x95\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x98"],

        ["\xF3\xB1\x81\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEA"],
        ["\x95\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x99"],

        ["\xF3\xB1\x81\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEB"],
        ["\x95\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9A"],

        ["\xF3\xB1\x81\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEC"],
        ["\x95\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9B"],

        ["\xF3\xB1\x81\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xED"],
        ["\x95\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9C"],

        ["\xF3\xB1\x81\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEE"],
        ["\x95\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9D"],

        ["\xF3\xB1\x81\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEF"],
        ["\x95\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9E"],

        ["\xF3\xB1\x81\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF0"],
        ["\x95\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9F"],

        ["\xF3\xB1\x81\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF1"],
        ["\x95\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA0"],

        ["\xF3\xB1\x81\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF2"],
        ["\x95\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA1"],

        ["\xF3\xB1\x81\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF3"],
        ["\x95\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA2"],

        ["\xF3\xB1\x81\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF4"],
        ["\x95\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA3"],

        ["\xF3\xB1\x81\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF5"],
        ["\x95\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA4"],

        ["\xF3\xB1\x81\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF6"],
        ["\x95\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA5"],

        ["\xF3\xB1\x81\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF7"],
        ["\x95\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA6"],

        ["\xF3\xB1\x81\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF8"],
        ["\x95\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA7"],

        ["\xF3\xB1\x81\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xF9"],
        ["\x95\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA8"],

        ["\xF3\xB1\x81\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xFA"],
        ["\x95\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA9"],

        ["\xF3\xB1\x81\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xFB"],
        ["\x95\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAA"],

        ["\xF3\xB1\x81\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xFC"],
        ["\x95\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAB"],

        ["\xF3\xB1\x81\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x40"],
        ["\x96\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAC"],

        ["\xF3\xB1\x81\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x41"],
        ["\x96\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAD"],

        ["\xF3\xB1\x81\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x42"],
        ["\x96\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAE"],

        ["\xF3\xB1\x81\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x43"],
        ["\x96\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAF"],

        ["\xF3\xB1\x81\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x44"],
        ["\x96\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB0"],

        ["\xF3\xB1\x81\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x45"],
        ["\x96\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB1"],

        ["\xF3\xB1\x81\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x46"],
        ["\x96\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB2"],

        ["\xF3\xB1\x81\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x47"],
        ["\x96\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB3"],

        ["\xF3\xB1\x81\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x48"],
        ["\x96\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB4"],

        ["\xF3\xB1\x81\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x49"],
        ["\x96\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB5"],

        ["\xF3\xB1\x81\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4A"],
        ["\x96\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB6"],

        ["\xF3\xB1\x81\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4B"],
        ["\x96\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB7"],

        ["\xF3\xB1\x81\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4C"],
        ["\x96\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB8"],

        ["\xF3\xB1\x81\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4D"],
        ["\x96\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB9"],

        ["\xF3\xB1\x81\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4E"],
        ["\x96\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBA"],

        ["\xF3\xB1\x81\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x4F"],
        ["\x96\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBB"],

        ["\xF3\xB1\x81\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x50"],
        ["\x96\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBC"],

        ["\xF3\xB1\x81\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x51"],
        ["\x96\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBD"],

        ["\xF3\xB1\x81\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x52"],
        ["\x96\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBE"],

        ["\xF3\xB1\x81\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x53"],
        ["\x96\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBF"],

        ["\xF3\xB1\x82\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x54"],
        ["\x96\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x80"],

        ["\xF3\xB1\x82\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x55"],
        ["\x96\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x81"],

        ["\xF3\xB1\x82\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x56"],
        ["\x96\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x82"],

        ["\xF3\xB1\x82\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x57"],
        ["\x96\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x83"],

        ["\xF3\xB1\x82\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x58"],
        ["\x96\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x84"],

        ["\xF3\xB1\x82\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x59"],
        ["\x96\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x85"],

        ["\xF3\xB1\x82\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5A"],
        ["\x96\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x86"],

        ["\xF3\xB1\x82\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5B"],
        ["\x96\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x87"],

        ["\xF3\xB1\x82\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5C"],
        ["\x96\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x88"],

        ["\xF3\xB1\x82\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5D"],
        ["\x96\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x89"],

        ["\xF3\xB1\x82\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5E"],
        ["\x96\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8A"],

        ["\xF3\xB1\x82\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x5F"],
        ["\x96\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8B"],

        ["\xF3\xB1\x82\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x60"],
        ["\x96\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8C"],

        ["\xF3\xB1\x82\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x61"],
        ["\x96\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8D"],

        ["\xF3\xB1\x82\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x62"],
        ["\x96\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8E"],

        ["\xF3\xB1\x82\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x63"],
        ["\x96\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8F"],

        ["\xF3\xB1\x82\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x64"],
        ["\x96\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x90"],

        ["\xF3\xB1\x82\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x65"],
        ["\x96\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x91"],

        ["\xF3\xB1\x82\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x66"],
        ["\x96\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x92"],

        ["\xF3\xB1\x82\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x67"],
        ["\x96\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x93"],

        ["\xF3\xB1\x82\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x68"],
        ["\x96\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x94"],

        ["\xF3\xB1\x82\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x69"],
        ["\x96\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x95"],

        ["\xF3\xB1\x82\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6A"],
        ["\x96\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x96"],

        ["\xF3\xB1\x82\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6B"],
        ["\x96\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x97"],

        ["\xF3\xB1\x82\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6C"],
        ["\x96\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x98"],

        ["\xF3\xB1\x82\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6D"],
        ["\x96\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x99"],

        ["\xF3\xB1\x82\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6E"],
        ["\x96\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9A"],

        ["\xF3\xB1\x82\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x6F"],
        ["\x96\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9B"],

        ["\xF3\xB1\x82\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x70"],
        ["\x96\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9C"],

        ["\xF3\xB1\x82\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x71"],
        ["\x96\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9D"],

        ["\xF3\xB1\x82\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x72"],
        ["\x96\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9E"],

        ["\xF3\xB1\x82\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x73"],
        ["\x96\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9F"],

        ["\xF3\xB1\x82\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x74"],
        ["\x96\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA0"],

        ["\xF3\xB1\x82\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x75"],
        ["\x96\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA1"],

        ["\xF3\xB1\x82\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x76"],
        ["\x96\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA2"],

        ["\xF3\xB1\x82\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x77"],
        ["\x96\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA3"],

        ["\xF3\xB1\x82\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x78"],
        ["\x96\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA4"],

        ["\xF3\xB1\x82\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x79"],
        ["\x96\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA5"],

        ["\xF3\xB1\x82\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x7A"],
        ["\x96\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA6"],

        ["\xF3\xB1\x82\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x7B"],
        ["\x96\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA7"],

        ["\xF3\xB1\x82\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x7C"],
        ["\x96\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA8"],

        ["\xF3\xB1\x82\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x7D"],
        ["\x96\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA9"],

        ["\xF3\xB1\x82\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x7E"],
        ["\x96\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAA"],

        ["\xF3\xB1\x82\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x80"],
        ["\x96\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAB"],

        ["\xF3\xB1\x82\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x81"],
        ["\x96\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAC"],

        ["\xF3\xB1\x82\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x82"],
        ["\x96\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAD"],

        ["\xF3\xB1\x82\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x83"],
        ["\x96\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAE"],

        ["\xF3\xB1\x82\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x84"],
        ["\x96\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAF"],

        ["\xF3\xB1\x82\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x85"],
        ["\x96\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB0"],

        ["\xF3\xB1\x82\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x86"],
        ["\x96\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB1"],

        ["\xF3\xB1\x82\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x87"],
        ["\x96\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB2"],

        ["\xF3\xB1\x82\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x88"],
        ["\x96\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB3"],

        ["\xF3\xB1\x82\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x89"],
        ["\x96\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB4"],

        ["\xF3\xB1\x82\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8A"],
        ["\x96\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB5"],

        ["\xF3\xB1\x82\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8B"],
        ["\x96\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB6"],

        ["\xF3\xB1\x82\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8C"],
        ["\x96\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB7"],

        ["\xF3\xB1\x82\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8D"],
        ["\x96\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB8"],

        ["\xF3\xB1\x82\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8E"],
        ["\x96\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB9"],

        ["\xF3\xB1\x82\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8F"],
        ["\x96\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBA"],

        ["\xF3\xB1\x82\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x90"],
        ["\x96\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBB"],

        ["\xF3\xB1\x82\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x91"],
        ["\x96\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBC"],

        ["\xF3\xB1\x82\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x92"],
        ["\x96\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBD"],

        ["\xF3\xB1\x82\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x93"],
        ["\x96\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBE"],

        ["\xF3\xB1\x82\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x94"],
        ["\x96\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBF"],

        ["\xF3\xB1\x83\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x95"],
        ["\x96\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x80"],

        ["\xF3\xB1\x83\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x96"],
        ["\x96\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x81"],

        ["\xF3\xB1\x83\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x97"],
        ["\x96\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x82"],

        ["\xF3\xB1\x83\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x98"],
        ["\x96\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x83"],

        ["\xF3\xB1\x83\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x99"],
        ["\x96\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x84"],

        ["\xF3\xB1\x83\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9A"],
        ["\x96\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x85"],

        ["\xF3\xB1\x83\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9B"],
        ["\x96\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x86"],

        ["\xF3\xB1\x83\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9C"],
        ["\x96\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x87"],

        ["\xF3\xB1\x83\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9D"],
        ["\x96\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x88"],

        ["\xF3\xB1\x83\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9E"],
        ["\x96\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x89"],

        ["\xF3\xB1\x83\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9F"],
        ["\x96\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8A"],

        ["\xF3\xB1\x83\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA0"],
        ["\x96\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8B"],

        ["\xF3\xB1\x83\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA1"],
        ["\x96\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8C"],

        ["\xF3\xB1\x83\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA2"],
        ["\x96\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8D"],

        ["\xF3\xB1\x83\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA3"],
        ["\x96\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8E"],

        ["\xF3\xB1\x83\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA4"],
        ["\x96\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8F"],

        ["\xF3\xB1\x83\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA5"],
        ["\x96\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x90"],

        ["\xF3\xB1\x83\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA6"],
        ["\x96\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x91"],

        ["\xF3\xB1\x83\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA7"],
        ["\x96\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x92"],

        ["\xF3\xB1\x83\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA8"],
        ["\x96\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x93"],

        ["\xF3\xB1\x83\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA9"],
        ["\x96\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x94"],

        ["\xF3\xB1\x83\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAA"],
        ["\x96\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x95"],

        ["\xF3\xB1\x83\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAB"],
        ["\x96\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x96"],

        ["\xF3\xB1\x83\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAC"],
        ["\x96\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x97"],

        ["\xF3\xB1\x83\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAD"],
        ["\x96\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x98"],

        ["\xF3\xB1\x83\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAE"],
        ["\x96\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x99"],

        ["\xF3\xB1\x83\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAF"],
        ["\x96\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9A"],

        ["\xF3\xB1\x83\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB0"],
        ["\x96\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9B"],

        ["\xF3\xB1\x83\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB1"],
        ["\x96\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9C"],

        ["\xF3\xB1\x83\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB2"],
        ["\x96\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9D"],

        ["\xF3\xB1\x83\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB3"],
        ["\x96\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9E"],

        ["\xF3\xB1\x83\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB4"],
        ["\x96\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9F"],

        ["\xF3\xB1\x83\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB5"],
        ["\x96\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA0"],

        ["\xF3\xB1\x83\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB6"],
        ["\x96\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA1"],

        ["\xF3\xB1\x83\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB7"],
        ["\x96\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA2"],

        ["\xF3\xB1\x83\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB8"],
        ["\x96\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA3"],

        ["\xF3\xB1\x83\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB9"],
        ["\x96\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA4"],

        ["\xF3\xB1\x83\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBA"],
        ["\x96\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA5"],

        ["\xF3\xB1\x83\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBB"],
        ["\x96\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA6"],

        ["\xF3\xB1\x83\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBC"],
        ["\x96\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA7"],

        ["\xF3\xB1\x83\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBD"],
        ["\x96\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA8"],

        ["\xF3\xB1\x83\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBE"],
        ["\x96\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA9"],

        ["\xF3\xB1\x83\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBF"],
        ["\x96\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAA"],

        ["\xF3\xB1\x83\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC0"],
        ["\x96\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAB"],

        ["\xF3\xB1\x83\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC1"],
        ["\x96\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAC"],

        ["\xF3\xB1\x83\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC2"],
        ["\x96\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAD"],

        ["\xF3\xB1\x83\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC3"],
        ["\x96\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAE"],

        ["\xF3\xB1\x83\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC4"],
        ["\x96\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAF"],

        ["\xF3\xB1\x83\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC5"],
        ["\x96\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB0"],

        ["\xF3\xB1\x83\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC6"],
        ["\x96\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB1"],

        ["\xF3\xB1\x83\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC7"],
        ["\x96\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB2"],

        ["\xF3\xB1\x83\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC8"],
        ["\x96\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB3"],

        ["\xF3\xB1\x83\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xC9"],
        ["\x96\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB4"],

        ["\xF3\xB1\x83\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCA"],
        ["\x96\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB5"],

        ["\xF3\xB1\x83\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCB"],
        ["\x96\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB6"],

        ["\xF3\xB1\x83\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCC"],
        ["\x96\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB7"],

        ["\xF3\xB1\x83\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCD"],
        ["\x96\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB8"],

        ["\xF3\xB1\x83\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCE"],
        ["\x96\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB9"],

        ["\xF3\xB1\x83\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCF"],
        ["\x96\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBA"],

        ["\xF3\xB1\x83\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD0"],
        ["\x96\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBB"],

        ["\xF3\xB1\x83\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD1"],
        ["\x96\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBC"],

        ["\xF3\xB1\x83\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD2"],
        ["\x96\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBD"],

        ["\xF3\xB1\x83\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD3"],
        ["\x96\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBE"],

        ["\xF3\xB1\x83\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD4"],
        ["\x96\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBF"],

        ["\xF3\xB1\x84\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD5"],
        ["\x96\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x80"],

        ["\xF3\xB1\x84\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD6"],
        ["\x96\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x81"],

        ["\xF3\xB1\x84\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD7"],
        ["\x96\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x82"],

        ["\xF3\xB1\x84\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD8"],
        ["\x96\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x83"],

        ["\xF3\xB1\x84\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xD9"],
        ["\x96\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x84"],

        ["\xF3\xB1\x84\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDA"],
        ["\x96\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x85"],

        ["\xF3\xB1\x84\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDB"],
        ["\x96\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x86"],

        ["\xF3\xB1\x84\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDC"],
        ["\x96\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x87"],

        ["\xF3\xB1\x84\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDD"],
        ["\x96\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x88"],

        ["\xF3\xB1\x84\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDE"],
        ["\x96\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x89"],

        ["\xF3\xB1\x84\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDF"],
        ["\x96\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8A"],

        ["\xF3\xB1\x84\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE0"],
        ["\x96\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8B"],

        ["\xF3\xB1\x84\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE1"],
        ["\x96\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8C"],

        ["\xF3\xB1\x84\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE2"],
        ["\x96\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8D"],

        ["\xF3\xB1\x84\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE3"],
        ["\x96\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8E"],

        ["\xF3\xB1\x84\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE4"],
        ["\x96\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8F"],

        ["\xF3\xB1\x84\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE5"],
        ["\x96\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x90"],

        ["\xF3\xB1\x84\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE6"],
        ["\x96\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x91"],

        ["\xF3\xB1\x84\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE7"],
        ["\x96\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x92"],

        ["\xF3\xB1\x84\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE8"],
        ["\x96\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x93"],

        ["\xF3\xB1\x84\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xE9"],
        ["\x96\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x94"],

        ["\xF3\xB1\x84\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEA"],
        ["\x96\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x95"],

        ["\xF3\xB1\x84\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEB"],
        ["\x96\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x96"],

        ["\xF3\xB1\x84\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEC"],
        ["\x96\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x97"],

        ["\xF3\xB1\x84\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xED"],
        ["\x96\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x98"],

        ["\xF3\xB1\x84\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEE"],
        ["\x96\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x99"],

        ["\xF3\xB1\x84\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEF"],
        ["\x96\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9A"],

        ["\xF3\xB1\x84\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF0"],
        ["\x96\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9B"],

        ["\xF3\xB1\x84\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF1"],
        ["\x96\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9C"],

        ["\xF3\xB1\x84\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF2"],
        ["\x96\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9D"],

        ["\xF3\xB1\x84\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF3"],
        ["\x96\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9E"],

        ["\xF3\xB1\x84\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF4"],
        ["\x96\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9F"],

        ["\xF3\xB1\x84\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF5"],
        ["\x96\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA0"],

        ["\xF3\xB1\x84\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF6"],
        ["\x96\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA1"],

        ["\xF3\xB1\x84\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF7"],
        ["\x96\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA2"],

        ["\xF3\xB1\x84\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF8"],
        ["\x96\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA3"],

        ["\xF3\xB1\x84\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xF9"],
        ["\x96\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA4"],

        ["\xF3\xB1\x84\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xFA"],
        ["\x96\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA5"],

        ["\xF3\xB1\x84\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xFB"],
        ["\x96\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA6"],

        ["\xF3\xB1\x84\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xFC"],
        ["\x96\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA7"],

        ["\xF3\xB1\x84\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x40"],
        ["\x97\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA8"],

        ["\xF3\xB1\x84\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x41"],
        ["\x97\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA9"],

        ["\xF3\xB1\x84\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x42"],
        ["\x97\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAA"],

        ["\xF3\xB1\x84\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x43"],
        ["\x97\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAB"],

        ["\xF3\xB1\x84\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x44"],
        ["\x97\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAC"],

        ["\xF3\xB1\x84\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x45"],
        ["\x97\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAD"],

        ["\xF3\xB1\x84\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x46"],
        ["\x97\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAE"],

        ["\xF3\xB1\x84\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x47"],
        ["\x97\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAF"],

        ["\xF3\xB1\x84\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x48"],
        ["\x97\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB0"],

        ["\xF3\xB1\x84\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x49"],
        ["\x97\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB1"],

        ["\xF3\xB1\x84\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4A"],
        ["\x97\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB2"],

        ["\xF3\xB1\x84\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4B"],
        ["\x97\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB3"],

        ["\xF3\xB1\x84\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4C"],
        ["\x97\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB4"],

        ["\xF3\xB1\x84\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4D"],
        ["\x97\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB5"],

        ["\xF3\xB1\x84\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4E"],
        ["\x97\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB6"],

        ["\xF3\xB1\x84\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x4F"],
        ["\x97\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB7"],

        ["\xF3\xB1\x84\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x50"],
        ["\x97\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB8"],

        ["\xF3\xB1\x84\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x51"],
        ["\x97\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB9"],

        ["\xF3\xB1\x84\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x52"],
        ["\x97\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBA"],

        ["\xF3\xB1\x84\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x53"],
        ["\x97\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBB"],

        ["\xF3\xB1\x84\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x54"],
        ["\x97\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBC"],

        ["\xF3\xB1\x84\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x55"],
        ["\x97\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBD"],

        ["\xF3\xB1\x84\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x56"],
        ["\x97\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBE"],

        ["\xF3\xB1\x84\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x57"],
        ["\x97\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBF"],

        ["\xF3\xB1\x85\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x58"],
        ["\x97\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x80"],

        ["\xF3\xB1\x85\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x59"],
        ["\x97\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x81"],

        ["\xF3\xB1\x85\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5A"],
        ["\x97\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x82"],

        ["\xF3\xB1\x85\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5B"],
        ["\x97\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x83"],

        ["\xF3\xB1\x85\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5C"],
        ["\x97\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x84"],

        ["\xF3\xB1\x85\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5D"],
        ["\x97\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x85"],

        ["\xF3\xB1\x85\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5E"],
        ["\x97\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x86"],

        ["\xF3\xB1\x85\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x5F"],
        ["\x97\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x87"],

        ["\xF3\xB1\x85\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x60"],
        ["\x97\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x88"],

        ["\xF3\xB1\x85\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x61"],
        ["\x97\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x89"],

        ["\xF3\xB1\x85\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x62"],
        ["\x97\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8A"],

        ["\xF3\xB1\x85\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x63"],
        ["\x97\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8B"],

        ["\xF3\xB1\x85\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x64"],
        ["\x97\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8C"],

        ["\xF3\xB1\x85\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x65"],
        ["\x97\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8D"],

        ["\xF3\xB1\x85\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x66"],
        ["\x97\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8E"],

        ["\xF3\xB1\x85\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x67"],
        ["\x97\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8F"],

        ["\xF3\xB1\x85\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x68"],
        ["\x97\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x90"],

        ["\xF3\xB1\x85\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x69"],
        ["\x97\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x91"],

        ["\xF3\xB1\x85\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6A"],
        ["\x97\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x92"],

        ["\xF3\xB1\x85\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6B"],
        ["\x97\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x93"],

        ["\xF3\xB1\x85\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6C"],
        ["\x97\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x94"],

        ["\xF3\xB1\x85\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6D"],
        ["\x97\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x95"],

        ["\xF3\xB1\x85\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6E"],
        ["\x97\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x96"],

        ["\xF3\xB1\x85\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x6F"],
        ["\x97\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x97"],

        ["\xF3\xB1\x85\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x70"],
        ["\x97\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x98"],

        ["\xF3\xB1\x85\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x71"],
        ["\x97\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x99"],

        ["\xF3\xB1\x85\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x72"],
        ["\x97\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9A"],

        ["\xF3\xB1\x85\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x73"],
        ["\x97\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9B"],

        ["\xF3\xB1\x85\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x74"],
        ["\x97\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9C"],

        ["\xF3\xB1\x85\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x75"],
        ["\x97\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9D"],

        ["\xF3\xB1\x85\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x76"],
        ["\x97\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9E"],

        ["\xF3\xB1\x85\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x77"],
        ["\x97\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9F"],

        ["\xF3\xB1\x85\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x78"],
        ["\x97\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA0"],

        ["\xF3\xB1\x85\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x79"],
        ["\x97\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA1"],

        ["\xF3\xB1\x85\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x7A"],
        ["\x97\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA2"],

        ["\xF3\xB1\x85\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x7B"],
        ["\x97\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA3"],

        ["\xF3\xB1\x85\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x7C"],
        ["\x97\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA4"],

        ["\xF3\xB1\x85\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x7D"],
        ["\x97\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA5"],

        ["\xF3\xB1\x85\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x7E"],
        ["\x97\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA6"],

        ["\xF3\xB1\x85\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x80"],
        ["\x97\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA7"],

        ["\xF3\xB1\x85\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x81"],
        ["\x97\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA8"],

        ["\xF3\xB1\x85\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x82"],
        ["\x97\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA9"],

        ["\xF3\xB1\x85\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x83"],
        ["\x97\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAA"],

        ["\xF3\xB1\x85\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x84"],
        ["\x97\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAB"],

        ["\xF3\xB1\x85\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x85"],
        ["\x97\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAC"],

        ["\xF3\xB1\x85\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x86"],
        ["\x97\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAD"],

        ["\xF3\xB1\x85\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x87"],
        ["\x97\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAE"],

        ["\xF3\xB1\x85\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x88"],
        ["\x97\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAF"],

        ["\xF3\xB1\x85\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x89"],
        ["\x97\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB0"],

        ["\xF3\xB1\x85\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8A"],
        ["\x97\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB1"],

        ["\xF3\xB1\x85\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8B"],
        ["\x97\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB2"],

        ["\xF3\xB1\x85\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8C"],
        ["\x97\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB3"],

        ["\xF3\xB1\x85\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8D"],
        ["\x97\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB4"],

        ["\xF3\xB1\x85\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8E"],
        ["\x97\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB5"],

        ["\xF3\xB1\x85\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8F"],
        ["\x97\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB6"],

        ["\xF3\xB1\x85\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x90"],
        ["\x97\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB7"],

        ["\xF3\xB1\x85\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x91"],
        ["\x97\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB8"],

        ["\xF3\xB1\x85\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x92"],
        ["\x97\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB9"],

        ["\xF3\xB1\x85\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x93"],
        ["\x97\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBA"],

        ["\xF3\xB1\x85\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x94"],
        ["\x97\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBB"],

        ["\xF3\xB1\x85\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x95"],
        ["\x97\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBC"],

        ["\xF3\xB1\x85\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x96"],
        ["\x97\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBD"],

        ["\xF3\xB1\x85\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x97"],
        ["\x97\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBE"],

        ["\xF3\xB1\x85\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x98"],
        ["\x97\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBF"],

        ["\xF3\xB1\x86\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x99"],
        ["\x97\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x80"],

        ["\xF3\xB1\x86\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9A"],
        ["\x97\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x81"],

        ["\xF3\xB1\x86\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9B"],
        ["\x97\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x82"],

        ["\xF3\xB1\x86\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9C"],
        ["\x97\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x83"],

        ["\xF3\xB1\x86\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9D"],
        ["\x97\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x84"],

        ["\xF3\xB1\x86\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9E"],
        ["\x97\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x85"],

        ["\xF3\xB1\x86\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9F"],
        ["\x97\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x86"],

        ["\xF3\xB1\x86\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA0"],
        ["\x97\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x87"],

        ["\xF3\xB1\x86\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA1"],
        ["\x97\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x88"],

        ["\xF3\xB1\x86\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA2"],
        ["\x97\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x89"],

        ["\xF3\xB1\x86\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA3"],
        ["\x97\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8A"],

        ["\xF3\xB1\x86\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA4"],
        ["\x97\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8B"],

        ["\xF3\xB1\x86\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA5"],
        ["\x97\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8C"],

        ["\xF3\xB1\x86\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA6"],
        ["\x97\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8D"],

        ["\xF3\xB1\x86\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA7"],
        ["\x97\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8E"],

        ["\xF3\xB1\x86\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA8"],
        ["\x97\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8F"],

        ["\xF3\xB1\x86\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA9"],
        ["\x97\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x90"],

        ["\xF3\xB1\x86\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAA"],
        ["\x97\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x91"],

        ["\xF3\xB1\x86\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAB"],
        ["\x97\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x92"],

        ["\xF3\xB1\x86\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAC"],
        ["\x97\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x93"],

        ["\xF3\xB1\x86\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAD"],
        ["\x97\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x94"],

        ["\xF3\xB1\x86\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAE"],
        ["\x97\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x95"],

        ["\xF3\xB1\x86\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAF"],
        ["\x97\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x96"],

        ["\xF3\xB1\x86\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB0"],
        ["\x97\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x97"],

        ["\xF3\xB1\x86\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB1"],
        ["\x97\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x98"],

        ["\xF3\xB1\x86\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB2"],
        ["\x97\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x99"],

        ["\xF3\xB1\x86\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB3"],
        ["\x97\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9A"],

        ["\xF3\xB1\x86\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB4"],
        ["\x97\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9B"],

        ["\xF3\xB1\x86\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB5"],
        ["\x97\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9C"],

        ["\xF3\xB1\x86\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB6"],
        ["\x97\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9D"],

        ["\xF3\xB1\x86\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB7"],
        ["\x97\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9E"],

        ["\xF3\xB1\x86\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB8"],
        ["\x97\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9F"],

        ["\xF3\xB1\x86\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB9"],
        ["\x97\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA0"],

        ["\xF3\xB1\x86\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBA"],
        ["\x97\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA1"],

        ["\xF3\xB1\x86\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBB"],
        ["\x97\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA2"],

        ["\xF3\xB1\x86\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBC"],
        ["\x97\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA3"],

        ["\xF3\xB1\x86\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBD"],
        ["\x97\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA4"],

        ["\xF3\xB1\x86\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBE"],
        ["\x97\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA5"],

        ["\xF3\xB1\x86\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBF"],
        ["\x97\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA6"],

        ["\xF3\xB1\x86\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC0"],
        ["\x97\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA7"],

        ["\xF3\xB1\x86\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC1"],
        ["\x97\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA8"],

        ["\xF3\xB1\x86\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC2"],
        ["\x97\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA9"],

        ["\xF3\xB1\x86\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC3"],
        ["\x97\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAA"],

        ["\xF3\xB1\x86\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC4"],
        ["\x97\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAB"],

        ["\xF3\xB1\x86\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC5"],
        ["\x97\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAC"],

        ["\xF3\xB1\x86\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC6"],
        ["\x97\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAD"],

        ["\xF3\xB1\x86\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC7"],
        ["\x97\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAE"],

        ["\xF3\xB1\x86\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC8"],
        ["\x97\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAF"],

        ["\xF3\xB1\x86\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xC9"],
        ["\x97\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB0"],

        ["\xF3\xB1\x86\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCA"],
        ["\x97\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB1"],

        ["\xF3\xB1\x86\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCB"],
        ["\x97\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB2"],

        ["\xF3\xB1\x86\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCC"],
        ["\x97\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB3"],

        ["\xF3\xB1\x86\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCD"],
        ["\x97\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB4"],

        ["\xF3\xB1\x86\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCE"],
        ["\x97\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB5"],

        ["\xF3\xB1\x86\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCF"],
        ["\x97\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB6"],

        ["\xF3\xB1\x86\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD0"],
        ["\x97\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB7"],

        ["\xF3\xB1\x86\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD1"],
        ["\x97\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB8"],

        ["\xF3\xB1\x86\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD2"],
        ["\x97\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB9"],

        ["\xF3\xB1\x86\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD3"],
        ["\x97\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBA"],

        ["\xF3\xB1\x86\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD4"],
        ["\x97\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBB"],

        ["\xF3\xB1\x86\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD5"],
        ["\x97\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBC"],

        ["\xF3\xB1\x86\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD6"],
        ["\x97\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBD"],

        ["\xF3\xB1\x86\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD7"],
        ["\x97\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBE"],

        ["\xF3\xB1\x86\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD8"],
        ["\x97\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBF"],

        ["\xF3\xB1\x87\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xD9"],
        ["\x97\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x80"],

        ["\xF3\xB1\x87\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDA"],
        ["\x97\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x81"],

        ["\xF3\xB1\x87\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDB"],
        ["\x97\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x82"],

        ["\xF3\xB1\x87\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDC"],
        ["\x97\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x83"],

        ["\xF3\xB1\x87\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDD"],
        ["\x97\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x84"],

        ["\xF3\xB1\x87\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDE"],
        ["\x97\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x85"],

        ["\xF3\xB1\x87\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xDF"],
        ["\x97\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x86"],

        ["\xF3\xB1\x87\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE0"],
        ["\x97\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x87"],

        ["\xF3\xB1\x87\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE1"],
        ["\x97\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x88"],

        ["\xF3\xB1\x87\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE2"],
        ["\x97\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x89"],

        ["\xF3\xB1\x87\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE3"],
        ["\x97\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8A"],

        ["\xF3\xB1\x87\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE4"],
        ["\x97\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8B"],

        ["\xF3\xB1\x87\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE5"],
        ["\x97\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8C"],

        ["\xF3\xB1\x87\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE6"],
        ["\x97\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8D"],

        ["\xF3\xB1\x87\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE7"],
        ["\x97\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8E"],

        ["\xF3\xB1\x87\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE8"],
        ["\x97\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8F"],

        ["\xF3\xB1\x87\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xE9"],
        ["\x97\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x90"],

        ["\xF3\xB1\x87\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEA"],
        ["\x97\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x91"],

        ["\xF3\xB1\x87\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEB"],
        ["\x97\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x92"],

        ["\xF3\xB1\x87\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEC"],
        ["\x97\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x93"],

        ["\xF3\xB1\x87\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xED"],
        ["\x97\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x94"],

        ["\xF3\xB1\x87\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEE"],
        ["\x97\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x95"],

        ["\xF3\xB1\x87\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEF"],
        ["\x97\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x96"],

        ["\xF3\xB1\x87\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF0"],
        ["\x97\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x97"],

        ["\xF3\xB1\x87\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF1"],
        ["\x97\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x98"],

        ["\xF3\xB1\x87\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF2"],
        ["\x97\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x99"],

        ["\xF3\xB1\x87\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF3"],
        ["\x97\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9A"],

        ["\xF3\xB1\x87\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF4"],
        ["\x97\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9B"],

        ["\xF3\xB1\x87\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF5"],
        ["\x97\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9C"],

        ["\xF3\xB1\x87\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF6"],
        ["\x97\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9D"],

        ["\xF3\xB1\x87\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF7"],
        ["\x97\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9E"],

        ["\xF3\xB1\x87\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF8"],
        ["\x97\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9F"],

        ["\xF3\xB1\x87\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xF9"],
        ["\x97\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA0"],

        ["\xF3\xB1\x87\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xFA"],
        ["\x97\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA1"],

        ["\xF3\xB1\x87\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xFB"],
        ["\x97\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA2"],

        ["\xF3\xB1\x87\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xFC"],
        ["\x97\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA3"],

        ["\xF3\xB1\x87\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x40"],
        ["\x98\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA4"],

        ["\xF3\xB1\x87\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x41"],
        ["\x98\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA5"],

        ["\xF3\xB1\x87\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x42"],
        ["\x98\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA6"],

        ["\xF3\xB1\x87\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x43"],
        ["\x98\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA7"],

        ["\xF3\xB1\x87\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x44"],
        ["\x98\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA8"],

        ["\xF3\xB1\x87\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x45"],
        ["\x98\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA9"],

        ["\xF3\xB1\x87\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x46"],
        ["\x98\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAA"],

        ["\xF3\xB1\x87\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x47"],
        ["\x98\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAB"],

        ["\xF3\xB1\x87\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x48"],
        ["\x98\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAC"],

        ["\xF3\xB1\x87\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x49"],
        ["\x98\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAD"],

        ["\xF3\xB1\x87\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4A"],
        ["\x98\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAE"],

        ["\xF3\xB1\x87\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4B"],
        ["\x98\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAF"],

        ["\xF3\xB1\x87\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4C"],
        ["\x98\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB0"],

        ["\xF3\xB1\x87\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4D"],
        ["\x98\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB1"],

        ["\xF3\xB1\x87\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4E"],
        ["\x98\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB2"],

        ["\xF3\xB1\x87\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x4F"],
        ["\x98\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB3"],

        ["\xF3\xB1\x87\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x50"],
        ["\x98\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB4"],

        ["\xF3\xB1\x87\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x51"],
        ["\x98\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB5"],

        ["\xF3\xB1\x87\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x52"],
        ["\x98\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB6"],

        ["\xF3\xB1\x87\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x53"],
        ["\x98\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB7"],

        ["\xF3\xB1\x87\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x54"],
        ["\x98\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB8"],

        ["\xF3\xB1\x87\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x55"],
        ["\x98\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB9"],

        ["\xF3\xB1\x87\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x56"],
        ["\x98\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBA"],

        ["\xF3\xB1\x87\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x57"],
        ["\x98\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBB"],

        ["\xF3\xB1\x87\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x58"],
        ["\x98\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBC"],

        ["\xF3\xB1\x87\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x59"],
        ["\x98\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBD"],

        ["\xF3\xB1\x87\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5A"],
        ["\x98\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBE"],

        ["\xF3\xB1\x87\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5B"],
        ["\x98\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBF"],

        ["\xF3\xB1\x88\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5C"],
        ["\x98\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x80"],

        ["\xF3\xB1\x88\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5D"],
        ["\x98\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x81"],

        ["\xF3\xB1\x88\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5E"],
        ["\x98\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x82"],

        ["\xF3\xB1\x88\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x5F"],
        ["\x98\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x83"],

        ["\xF3\xB1\x88\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x60"],
        ["\x98\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x84"],

        ["\xF3\xB1\x88\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x61"],
        ["\x98\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x85"],

        ["\xF3\xB1\x88\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x62"],
        ["\x98\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x86"],

        ["\xF3\xB1\x88\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x63"],
        ["\x98\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x87"],

        ["\xF3\xB1\x88\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x64"],
        ["\x98\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x88"],

        ["\xF3\xB1\x88\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x65"],
        ["\x98\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x89"],

        ["\xF3\xB1\x88\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x66"],
        ["\x98\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8A"],

        ["\xF3\xB1\x88\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x67"],
        ["\x98\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8B"],

        ["\xF3\xB1\x88\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x68"],
        ["\x98\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8C"],

        ["\xF3\xB1\x88\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x69"],
        ["\x98\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8D"],

        ["\xF3\xB1\x88\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6A"],
        ["\x98\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8E"],

        ["\xF3\xB1\x88\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6B"],
        ["\x98\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8F"],

        ["\xF3\xB1\x88\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6C"],
        ["\x98\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x90"],

        ["\xF3\xB1\x88\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6D"],
        ["\x98\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x91"],

        ["\xF3\xB1\x88\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6E"],
        ["\x98\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x92"],

        ["\xF3\xB1\x88\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x6F"],
        ["\x98\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x93"],

        ["\xF3\xB1\x88\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x70"],
        ["\x98\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x94"],

        ["\xF3\xB1\x88\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x71"],
        ["\x98\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x95"],

        ["\xF3\xB1\x88\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x72"],
        ["\x98\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x96"],

        ["\xF3\xB1\x89\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x9F"],
        ["\x98\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x82"],

        ["\xF3\xB1\x89\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA0"],
        ["\x98\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x83"],

        ["\xF3\xB1\x89\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA1"],
        ["\x98\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x84"],

        ["\xF3\xB1\x89\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA2"],
        ["\x98\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x85"],

        ["\xF3\xB1\x89\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA3"],
        ["\x98\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x86"],

        ["\xF3\xB1\x89\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA4"],
        ["\x98\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x87"],

        ["\xF3\xB1\x89\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA5"],
        ["\x98\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x88"],

        ["\xF3\xB1\x89\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA6"],
        ["\x98\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x89"],

        ["\xF3\xB1\x89\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA7"],
        ["\x98\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8A"],

        ["\xF3\xB1\x89\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA8"],
        ["\x98\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8B"],

        ["\xF3\xB1\x89\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA9"],
        ["\x98\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8C"],

        ["\xF3\xB1\x89\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAA"],
        ["\x98\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8D"],

        ["\xF3\xB1\x89\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAB"],
        ["\x98\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8E"],

        ["\xF3\xB1\x89\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAC"],
        ["\x98\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8F"],

        ["\xF3\xB1\x89\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAD"],
        ["\x98\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x90"],

        ["\xF3\xB1\x89\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAE"],
        ["\x98\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x91"],

        ["\xF3\xB1\x89\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAF"],
        ["\x98\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x92"],

        ["\xF3\xB1\x89\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB0"],
        ["\x98\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x93"],

        ["\xF3\xB1\x89\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB1"],
        ["\x98\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x94"],

        ["\xF3\xB1\x89\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB2"],
        ["\x98\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x95"],

        ["\xF3\xB1\x89\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB3"],
        ["\x98\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x96"],

        ["\xF3\xB1\x89\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB4"],
        ["\x98\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x97"],

        ["\xF3\xB1\x89\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB5"],
        ["\x98\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x98"],

        ["\xF3\xB1\x89\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB6"],
        ["\x98\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x99"],

        ["\xF3\xB1\x89\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB7"],
        ["\x98\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9A"],

        ["\xF3\xB1\x89\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB8"],
        ["\x98\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9B"],

        ["\xF3\xB1\x89\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB9"],
        ["\x98\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9C"],

        ["\xF3\xB1\x89\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBA"],
        ["\x98\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9D"],

        ["\xF3\xB1\x89\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBB"],
        ["\x98\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9E"],

        ["\xF3\xB1\x89\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBC"],
        ["\x98\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9F"],

        ["\xF3\xB1\x89\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBD"],
        ["\x98\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA0"],

        ["\xF3\xB1\x89\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBE"],
        ["\x98\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA1"],

        ["\xF3\xB1\x89\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBF"],
        ["\x98\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA2"],

        ["\xF3\xB1\x89\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC0"],
        ["\x98\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA3"],

        ["\xF3\xB1\x89\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC1"],
        ["\x98\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA4"],

        ["\xF3\xB1\x89\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC2"],
        ["\x98\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA5"],

        ["\xF3\xB1\x89\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC3"],
        ["\x98\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA6"],

        ["\xF3\xB1\x89\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC4"],
        ["\x98\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA7"],

        ["\xF3\xB1\x89\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC5"],
        ["\x98\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA8"],

        ["\xF3\xB1\x89\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC6"],
        ["\x98\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA9"],

        ["\xF3\xB1\x89\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC7"],
        ["\x98\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAA"],

        ["\xF3\xB1\x89\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC8"],
        ["\x98\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAB"],

        ["\xF3\xB1\x89\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xC9"],
        ["\x98\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAC"],

        ["\xF3\xB1\x89\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCA"],
        ["\x98\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAD"],

        ["\xF3\xB1\x89\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCB"],
        ["\x98\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAE"],

        ["\xF3\xB1\x89\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCC"],
        ["\x98\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAF"],

        ["\xF3\xB1\x89\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCD"],
        ["\x98\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB0"],

        ["\xF3\xB1\x89\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCE"],
        ["\x98\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB1"],

        ["\xF3\xB1\x89\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCF"],
        ["\x98\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB2"],

        ["\xF3\xB1\x89\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD0"],
        ["\x98\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB3"],

        ["\xF3\xB1\x89\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD1"],
        ["\x98\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB4"],

        ["\xF3\xB1\x89\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD2"],
        ["\x98\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB5"],

        ["\xF3\xB1\x89\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD3"],
        ["\x98\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB6"],

        ["\xF3\xB1\x89\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD4"],
        ["\x98\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB7"],

        ["\xF3\xB1\x89\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD5"],
        ["\x98\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB8"],

        ["\xF3\xB1\x89\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD6"],
        ["\x98\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB9"],

        ["\xF3\xB1\x89\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD7"],
        ["\x98\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBA"],

        ["\xF3\xB1\x89\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD8"],
        ["\x98\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBB"],

        ["\xF3\xB1\x89\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xD9"],
        ["\x98\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBC"],

        ["\xF3\xB1\x89\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDA"],
        ["\x98\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBD"],

        ["\xF3\xB1\x89\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDB"],
        ["\x98\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBE"],

        ["\xF3\xB1\x89\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDC"],
        ["\x98\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBF"],

        ["\xF3\xB1\x8A\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDD"],
        ["\x98\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x80"],

        ["\xF3\xB1\x8A\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDE"],
        ["\x98\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x81"],

        ["\xF3\xB1\x8A\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDF"],
        ["\x98\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x82"],

        ["\xF3\xB1\x8A\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE0"],
        ["\x98\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x83"],

        ["\xF3\xB1\x8A\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE1"],
        ["\x98\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x84"],

        ["\xF3\xB1\x8A\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE2"],
        ["\x98\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x85"],

        ["\xF3\xB1\x8A\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE3"],
        ["\x98\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x86"],

        ["\xF3\xB1\x8A\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE4"],
        ["\x98\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x87"],

        ["\xF3\xB1\x8A\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE5"],
        ["\x98\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x88"],

        ["\xF3\xB1\x8A\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE6"],
        ["\x98\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x89"],

        ["\xF3\xB1\x8A\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE7"],
        ["\x98\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8A"],

        ["\xF3\xB1\x8A\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE8"],
        ["\x98\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8B"],

        ["\xF3\xB1\x8A\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xE9"],
        ["\x98\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8C"],

        ["\xF3\xB1\x8A\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEA"],
        ["\x98\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8D"],

        ["\xF3\xB1\x8A\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEB"],
        ["\x98\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8E"],

        ["\xF3\xB1\x8A\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEC"],
        ["\x98\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8F"],

        ["\xF3\xB1\x8A\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xED"],
        ["\x98\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x90"],

        ["\xF3\xB1\x8A\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEE"],
        ["\x98\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x91"],

        ["\xF3\xB1\x8A\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEF"],
        ["\x98\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x92"],

        ["\xF3\xB1\x8A\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF0"],
        ["\x98\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x93"],

        ["\xF3\xB1\x8A\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF1"],
        ["\x98\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x94"],

        ["\xF3\xB1\x8A\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF2"],
        ["\x98\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x95"],

        ["\xF3\xB1\x8A\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF3"],
        ["\x98\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x96"],

        ["\xF3\xB1\x8A\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF4"],
        ["\x98\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x97"],

        ["\xF3\xB1\x8A\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF5"],
        ["\x98\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x98"],

        ["\xF3\xB1\x8A\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF6"],
        ["\x98\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x99"],

        ["\xF3\xB1\x8A\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF7"],
        ["\x98\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9A"],

        ["\xF3\xB1\x8A\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF8"],
        ["\x98\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9B"],

        ["\xF3\xB1\x8A\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xF9"],
        ["\x98\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9C"],

        ["\xF3\xB1\x8A\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xFA"],
        ["\x98\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9D"],

        ["\xF3\xB1\x8A\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xFB"],
        ["\x98\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9E"],

        ["\xF3\xB1\x8A\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xFC"],
        ["\x98\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9F"],

        ["\xF3\xB1\x8A\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x40"],
        ["\x99\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA0"],

        ["\xF3\xB1\x8A\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x41"],
        ["\x99\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA1"],

        ["\xF3\xB1\x8A\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x42"],
        ["\x99\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA2"],

        ["\xF3\xB1\x8A\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x43"],
        ["\x99\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA3"],

        ["\xF3\xB1\x8A\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x44"],
        ["\x99\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA4"],

        ["\xF3\xB1\x8A\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x45"],
        ["\x99\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA5"],

        ["\xF3\xB1\x8A\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x46"],
        ["\x99\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA6"],

        ["\xF3\xB1\x8A\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x47"],
        ["\x99\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA7"],

        ["\xF3\xB1\x8A\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x48"],
        ["\x99\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA8"],

        ["\xF3\xB1\x8A\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x49"],
        ["\x99\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA9"],

        ["\xF3\xB1\x8A\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4A"],
        ["\x99\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAA"],

        ["\xF3\xB1\x8A\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4B"],
        ["\x99\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAB"],

        ["\xF3\xB1\x8A\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4C"],
        ["\x99\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAC"],

        ["\xF3\xB1\x8A\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4D"],
        ["\x99\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAD"],

        ["\xF3\xB1\x8A\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4E"],
        ["\x99\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAE"],

        ["\xF3\xB1\x8A\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x4F"],
        ["\x99\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAF"],

        ["\xF3\xB1\x8A\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x50"],
        ["\x99\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB0"],

        ["\xF3\xB1\x8A\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x51"],
        ["\x99\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB1"],

        ["\xF3\xB1\x8A\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x52"],
        ["\x99\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB2"],

        ["\xF3\xB1\x8A\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x53"],
        ["\x99\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB3"],

        ["\xF3\xB1\x8A\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x54"],
        ["\x99\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB4"],

        ["\xF3\xB1\x8A\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x55"],
        ["\x99\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB5"],

        ["\xF3\xB1\x8A\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x56"],
        ["\x99\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB6"],

        ["\xF3\xB1\x8A\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x57"],
        ["\x99\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB7"],

        ["\xF3\xB1\x8A\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x58"],
        ["\x99\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB8"],

        ["\xF3\xB1\x8A\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x59"],
        ["\x99\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB9"],

        ["\xF3\xB1\x8A\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5A"],
        ["\x99\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBA"],

        ["\xF3\xB1\x8A\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5B"],
        ["\x99\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBB"],

        ["\xF3\xB1\x8A\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5C"],
        ["\x99\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBC"],

        ["\xF3\xB1\x8A\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5D"],
        ["\x99\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBD"],

        ["\xF3\xB1\x8A\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5E"],
        ["\x99\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBE"],

        ["\xF3\xB1\x8A\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x5F"],
        ["\x99\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBF"],

        ["\xF3\xB1\x8B\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x60"],
        ["\x99\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x80"],

        ["\xF3\xB1\x8B\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x61"],
        ["\x99\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x81"],

        ["\xF3\xB1\x8B\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x62"],
        ["\x99\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x82"],

        ["\xF3\xB1\x8B\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x63"],
        ["\x99\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x83"],

        ["\xF3\xB1\x8B\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x64"],
        ["\x99\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x84"],

        ["\xF3\xB1\x8B\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x65"],
        ["\x99\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x85"],

        ["\xF3\xB1\x8B\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x66"],
        ["\x99\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x86"],

        ["\xF3\xB1\x8B\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x67"],
        ["\x99\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x87"],

        ["\xF3\xB1\x8B\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x68"],
        ["\x99\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x88"],

        ["\xF3\xB1\x8B\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x69"],
        ["\x99\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x89"],

        ["\xF3\xB1\x8B\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6A"],
        ["\x99\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8A"],

        ["\xF3\xB1\x8B\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6B"],
        ["\x99\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8B"],

        ["\xF3\xB1\x8B\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6C"],
        ["\x99\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8C"],

        ["\xF3\xB1\x8B\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6D"],
        ["\x99\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8D"],

        ["\xF3\xB1\x8B\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6E"],
        ["\x99\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8E"],

        ["\xF3\xB1\x8B\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x6F"],
        ["\x99\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8F"],

        ["\xF3\xB1\x8B\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x70"],
        ["\x99\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x90"],

        ["\xF3\xB1\x8B\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x71"],
        ["\x99\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x91"],

        ["\xF3\xB1\x8B\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x72"],
        ["\x99\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x92"],

        ["\xF3\xB1\x8B\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x73"],
        ["\x99\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x93"],

        ["\xF3\xB1\x8B\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x74"],
        ["\x99\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x94"],

        ["\xF3\xB1\x8B\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x75"],
        ["\x99\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x95"],

        ["\xF3\xB1\x8B\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x76"],
        ["\x99\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x96"],

        ["\xF3\xB1\x8B\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x77"],
        ["\x99\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x97"],

        ["\xF3\xB1\x8B\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x78"],
        ["\x99\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x98"],

        ["\xF3\xB1\x8B\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x79"],
        ["\x99\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x99"],

        ["\xF3\xB1\x8B\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x7A"],
        ["\x99\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9A"],

        ["\xF3\xB1\x8B\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x7B"],
        ["\x99\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9B"],

        ["\xF3\xB1\x8B\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x7C"],
        ["\x99\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9C"],

        ["\xF3\xB1\x8B\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x7D"],
        ["\x99\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9D"],

        ["\xF3\xB1\x8B\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x7E"],
        ["\x99\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9E"],

        ["\xF3\xB1\x8B\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x80"],
        ["\x99\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9F"],

        ["\xF3\xB1\x8B\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x81"],
        ["\x99\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA0"],

        ["\xF3\xB1\x8B\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x82"],
        ["\x99\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA1"],

        ["\xF3\xB1\x8B\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x83"],
        ["\x99\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA2"],

        ["\xF3\xB1\x8B\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x84"],
        ["\x99\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA3"],

        ["\xF3\xB1\x8B\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x85"],
        ["\x99\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA4"],

        ["\xF3\xB1\x8B\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x86"],
        ["\x99\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA5"],

        ["\xF3\xB1\x8B\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x87"],
        ["\x99\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA6"],

        ["\xF3\xB1\x8B\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x88"],
        ["\x99\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA7"],

        ["\xF3\xB1\x8B\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x89"],
        ["\x99\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA8"],

        ["\xF3\xB1\x8B\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8A"],
        ["\x99\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA9"],

        ["\xF3\xB1\x8B\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8B"],
        ["\x99\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAA"],

        ["\xF3\xB1\x8B\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8C"],
        ["\x99\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAB"],

        ["\xF3\xB1\x8B\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8D"],
        ["\x99\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAC"],

        ["\xF3\xB1\x8B\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8E"],
        ["\x99\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAD"],

        ["\xF3\xB1\x8B\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8F"],
        ["\x99\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAE"],

        ["\xF3\xB1\x8B\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x90"],
        ["\x99\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAF"],

        ["\xF3\xB1\x8B\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x91"],
        ["\x99\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB0"],

        ["\xF3\xB1\x8B\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x92"],
        ["\x99\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB1"],

        ["\xF3\xB1\x8B\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x93"],
        ["\x99\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB2"],

        ["\xF3\xB1\x8B\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x94"],
        ["\x99\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB3"],

        ["\xF3\xB1\x8B\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x95"],
        ["\x99\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB4"],

        ["\xF3\xB1\x8B\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x96"],
        ["\x99\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB5"],

        ["\xF3\xB1\x8B\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x97"],
        ["\x99\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB6"],

        ["\xF3\xB1\x8B\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x98"],
        ["\x99\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB7"],

        ["\xF3\xB1\x8B\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x99"],
        ["\x99\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB8"],

        ["\xF3\xB1\x8B\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9A"],
        ["\x99\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB9"],

        ["\xF3\xB1\x8B\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9B"],
        ["\x99\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBA"],

        ["\xF3\xB1\x8B\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9C"],
        ["\x99\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBB"],

        ["\xF3\xB1\x8B\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9D"],
        ["\x99\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBC"],

        ["\xF3\xB1\x8B\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9E"],
        ["\x99\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBD"],

        ["\xF3\xB1\x8B\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9F"],
        ["\x99\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBE"],

        ["\xF3\xB1\x8B\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA0"],
        ["\x99\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBF"],

        ["\xF3\xB1\x8C\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA1"],
        ["\x99\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x80"],

        ["\xF3\xB1\x8C\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA2"],
        ["\x99\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x81"],

        ["\xF3\xB1\x8C\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA3"],
        ["\x99\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x82"],

        ["\xF3\xB1\x8C\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA4"],
        ["\x99\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x83"],

        ["\xF3\xB1\x8C\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA5"],
        ["\x99\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x84"],

        ["\xF3\xB1\x8C\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA6"],
        ["\x99\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x85"],

        ["\xF3\xB1\x8C\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA7"],
        ["\x99\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x86"],

        ["\xF3\xB1\x8C\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA8"],
        ["\x99\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x87"],

        ["\xF3\xB1\x8C\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA9"],
        ["\x99\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x88"],

        ["\xF3\xB1\x8C\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAA"],
        ["\x99\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x89"],

        ["\xF3\xB1\x8C\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAB"],
        ["\x99\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8A"],

        ["\xF3\xB1\x8C\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAC"],
        ["\x99\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8B"],

        ["\xF3\xB1\x8C\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAD"],
        ["\x99\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8C"],

        ["\xF3\xB1\x8C\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAE"],
        ["\x99\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8D"],

        ["\xF3\xB1\x8C\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAF"],
        ["\x99\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8E"],

        ["\xF3\xB1\x8C\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB0"],
        ["\x99\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8F"],

        ["\xF3\xB1\x8C\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB1"],
        ["\x99\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x90"],

        ["\xF3\xB1\x8C\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB2"],
        ["\x99\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x91"],

        ["\xF3\xB1\x8C\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB3"],
        ["\x99\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x92"],

        ["\xF3\xB1\x8C\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB4"],
        ["\x99\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x93"],

        ["\xF3\xB1\x8C\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB5"],
        ["\x99\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x94"],

        ["\xF3\xB1\x8C\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB6"],
        ["\x99\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x95"],

        ["\xF3\xB1\x8C\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB7"],
        ["\x99\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x96"],

        ["\xF3\xB1\x8C\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB8"],
        ["\x99\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x97"],

        ["\xF3\xB1\x8C\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB9"],
        ["\x99\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x98"],

        ["\xF3\xB1\x8C\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBA"],
        ["\x99\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x99"],

        ["\xF3\xB1\x8C\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBB"],
        ["\x99\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9A"],

        ["\xF3\xB1\x8C\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBC"],
        ["\x99\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9B"],

        ["\xF3\xB1\x8C\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBD"],
        ["\x99\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9C"],

        ["\xF3\xB1\x8C\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBE"],
        ["\x99\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9D"],

        ["\xF3\xB1\x8C\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBF"],
        ["\x99\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9E"],

        ["\xF3\xB1\x8C\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC0"],
        ["\x99\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9F"],

        ["\xF3\xB1\x8C\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC1"],
        ["\x99\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA0"],

        ["\xF3\xB1\x8C\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC2"],
        ["\x99\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA1"],

        ["\xF3\xB1\x8C\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC3"],
        ["\x99\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA2"],

        ["\xF3\xB1\x8C\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC4"],
        ["\x99\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA3"],

        ["\xF3\xB1\x8C\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC5"],
        ["\x99\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA4"],

        ["\xF3\xB1\x8C\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC6"],
        ["\x99\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA5"],

        ["\xF3\xB1\x8C\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC7"],
        ["\x99\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA6"],

        ["\xF3\xB1\x8C\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC8"],
        ["\x99\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA7"],

        ["\xF3\xB1\x8C\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xC9"],
        ["\x99\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA8"],

        ["\xF3\xB1\x8C\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCA"],
        ["\x99\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA9"],

        ["\xF3\xB1\x8C\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCB"],
        ["\x99\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAA"],

        ["\xF3\xB1\x8C\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCC"],
        ["\x99\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAB"],

        ["\xF3\xB1\x8C\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCD"],
        ["\x99\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAC"],

        ["\xF3\xB1\x8C\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCE"],
        ["\x99\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAD"],

        ["\xF3\xB1\x8C\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCF"],
        ["\x99\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAE"],

        ["\xF3\xB1\x8C\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD0"],
        ["\x99\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAF"],

        ["\xF3\xB1\x8C\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD1"],
        ["\x99\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB0"],

        ["\xF3\xB1\x8C\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD2"],
        ["\x99\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB1"],

        ["\xF3\xB1\x8C\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD3"],
        ["\x99\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB2"],

        ["\xF3\xB1\x8C\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD4"],
        ["\x99\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB3"],

        ["\xF3\xB1\x8C\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD5"],
        ["\x99\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB4"],

        ["\xF3\xB1\x8C\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD6"],
        ["\x99\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB5"],

        ["\xF3\xB1\x8C\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD7"],
        ["\x99\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB6"],

        ["\xF3\xB1\x8C\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD8"],
        ["\x99\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB7"],

        ["\xF3\xB1\x8C\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xD9"],
        ["\x99\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB8"],

        ["\xF3\xB1\x8C\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDA"],
        ["\x99\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB9"],

        ["\xF3\xB1\x8C\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDB"],
        ["\x99\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBA"],

        ["\xF3\xB1\x8C\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDC"],
        ["\x99\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBB"],

        ["\xF3\xB1\x8C\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDD"],
        ["\x99\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBC"],

        ["\xF3\xB1\x8C\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDE"],
        ["\x99\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBD"],

        ["\xF3\xB1\x8C\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDF"],
        ["\x99\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBE"],

        ["\xF3\xB1\x8C\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE0"],
        ["\x99\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBF"],

        ["\xF3\xB1\x8D\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE1"],
        ["\x99\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x80"],

        ["\xF3\xB1\x8D\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE2"],
        ["\x99\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x81"],

        ["\xF3\xB1\x8D\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE3"],
        ["\x99\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x82"],

        ["\xF3\xB1\x8D\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE4"],
        ["\x99\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x83"],

        ["\xF3\xB1\x8D\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE5"],
        ["\x99\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x84"],

        ["\xF3\xB1\x8D\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE6"],
        ["\x99\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x85"],

        ["\xF3\xB1\x8D\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE7"],
        ["\x99\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x86"],

        ["\xF3\xB1\x8D\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE8"],
        ["\x99\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x87"],

        ["\xF3\xB1\x8D\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xE9"],
        ["\x99\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x88"],

        ["\xF3\xB1\x8D\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEA"],
        ["\x99\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x89"],

        ["\xF3\xB1\x8D\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEB"],
        ["\x99\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8A"],

        ["\xF3\xB1\x8D\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEC"],
        ["\x99\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8B"],

        ["\xF3\xB1\x8D\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xED"],
        ["\x99\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8C"],

        ["\xF3\xB1\x8D\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEE"],
        ["\x99\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8D"],

        ["\xF3\xB1\x8D\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEF"],
        ["\x99\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8E"],

        ["\xF3\xB1\x8D\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF0"],
        ["\x99\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8F"],

        ["\xF3\xB1\x8D\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF1"],
        ["\x99\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x90"],

        ["\xF3\xB1\x8D\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF2"],
        ["\x99\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x91"],

        ["\xF3\xB1\x8D\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF3"],
        ["\x99\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x92"],

        ["\xF3\xB1\x8D\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF4"],
        ["\x99\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x93"],

        ["\xF3\xB1\x8D\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF5"],
        ["\x99\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x94"],

        ["\xF3\xB1\x8D\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF6"],
        ["\x99\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x95"],

        ["\xF3\xB1\x8D\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF7"],
        ["\x99\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x96"],

        ["\xF3\xB1\x8D\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF8"],
        ["\x99\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x97"],

        ["\xF3\xB1\x8D\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xF9"],
        ["\x99\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x98"],

        ["\xF3\xB1\x8D\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xFA"],
        ["\x99\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x99"],

        ["\xF3\xB1\x8D\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xFB"],
        ["\x99\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9A"],

        ["\xF3\xB1\x8D\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xFC"],
        ["\x99\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9B"],

        ["\xF3\xB1\x8D\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x40"],
        ["\x9A\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9C"],

        ["\xF3\xB1\x8D\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x41"],
        ["\x9A\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9D"],

        ["\xF3\xB1\x8D\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x42"],
        ["\x9A\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9E"],

        ["\xF3\xB1\x8D\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x43"],
        ["\x9A\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9F"],

        ["\xF3\xB1\x8D\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x44"],
        ["\x9A\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA0"],

        ["\xF3\xB1\x8D\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x45"],
        ["\x9A\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA1"],

        ["\xF3\xB1\x8D\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x46"],
        ["\x9A\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA2"],

        ["\xF3\xB1\x8D\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x47"],
        ["\x9A\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA3"],

        ["\xF3\xB1\x8D\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x48"],
        ["\x9A\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA4"],

        ["\xF3\xB1\x8D\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x49"],
        ["\x9A\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA5"],

        ["\xF3\xB1\x8D\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4A"],
        ["\x9A\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA6"],

        ["\xF3\xB1\x8D\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4B"],
        ["\x9A\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA7"],

        ["\xF3\xB1\x8D\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4C"],
        ["\x9A\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA8"],

        ["\xF3\xB1\x8D\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4D"],
        ["\x9A\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA9"],

        ["\xF3\xB1\x8D\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4E"],
        ["\x9A\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAA"],

        ["\xF3\xB1\x8D\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x4F"],
        ["\x9A\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAB"],

        ["\xF3\xB1\x8D\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x50"],
        ["\x9A\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAC"],

        ["\xF3\xB1\x8D\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x51"],
        ["\x9A\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAD"],

        ["\xF3\xB1\x8D\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x52"],
        ["\x9A\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAE"],

        ["\xF3\xB1\x8D\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x53"],
        ["\x9A\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAF"],

        ["\xF3\xB1\x8D\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x54"],
        ["\x9A\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB0"],

        ["\xF3\xB1\x8D\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x55"],
        ["\x9A\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB1"],

        ["\xF3\xB1\x8D\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x56"],
        ["\x9A\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB2"],

        ["\xF3\xB1\x8D\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x57"],
        ["\x9A\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB3"],

        ["\xF3\xB1\x8D\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x58"],
        ["\x9A\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB4"],

        ["\xF3\xB1\x8D\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x59"],
        ["\x9A\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB5"],

        ["\xF3\xB1\x8D\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5A"],
        ["\x9A\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB6"],

        ["\xF3\xB1\x8D\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5B"],
        ["\x9A\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB7"],

        ["\xF3\xB1\x8D\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5C"],
        ["\x9A\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB8"],

        ["\xF3\xB1\x8D\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5D"],
        ["\x9A\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB9"],

        ["\xF3\xB1\x8D\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5E"],
        ["\x9A\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBA"],

        ["\xF3\xB1\x8D\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x5F"],
        ["\x9A\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBB"],

        ["\xF3\xB1\x8D\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x60"],
        ["\x9A\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBC"],

        ["\xF3\xB1\x8D\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x61"],
        ["\x9A\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBD"],

        ["\xF3\xB1\x8D\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x62"],
        ["\x9A\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBE"],

        ["\xF3\xB1\x8D\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x63"],
        ["\x9A\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBF"],

        ["\xF3\xB1\x8E\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x64"],
        ["\x9A\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x80"],

        ["\xF3\xB1\x8E\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x65"],
        ["\x9A\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x81"],

        ["\xF3\xB1\x8E\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x66"],
        ["\x9A\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x82"],

        ["\xF3\xB1\x8E\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x67"],
        ["\x9A\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x83"],

        ["\xF3\xB1\x8E\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x68"],
        ["\x9A\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x84"],

        ["\xF3\xB1\x8E\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x69"],
        ["\x9A\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x85"],

        ["\xF3\xB1\x8E\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6A"],
        ["\x9A\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x86"],

        ["\xF3\xB1\x8E\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6B"],
        ["\x9A\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x87"],

        ["\xF3\xB1\x8E\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6C"],
        ["\x9A\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x88"],

        ["\xF3\xB1\x8E\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6D"],
        ["\x9A\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x89"],

        ["\xF3\xB1\x8E\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6E"],
        ["\x9A\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8A"],

        ["\xF3\xB1\x8E\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x6F"],
        ["\x9A\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8B"],

        ["\xF3\xB1\x8E\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x70"],
        ["\x9A\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8C"],

        ["\xF3\xB1\x8E\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x71"],
        ["\x9A\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8D"],

        ["\xF3\xB1\x8E\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x72"],
        ["\x9A\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8E"],

        ["\xF3\xB1\x8E\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x73"],
        ["\x9A\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8F"],

        ["\xF3\xB1\x8E\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x74"],
        ["\x9A\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x90"],

        ["\xF3\xB1\x8E\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x75"],
        ["\x9A\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x91"],

        ["\xF3\xB1\x8E\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x76"],
        ["\x9A\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x92"],

        ["\xF3\xB1\x8E\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x77"],
        ["\x9A\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x93"],

        ["\xF3\xB1\x8E\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x78"],
        ["\x9A\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x94"],

        ["\xF3\xB1\x8E\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x79"],
        ["\x9A\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x95"],

        ["\xF3\xB1\x8E\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x7A"],
        ["\x9A\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x96"],

        ["\xF3\xB1\x8E\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x7B"],
        ["\x9A\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x97"],

        ["\xF3\xB1\x8E\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x7C"],
        ["\x9A\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x98"],

        ["\xF3\xB1\x8E\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x7D"],
        ["\x9A\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x99"],

        ["\xF3\xB1\x8E\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x7E"],
        ["\x9A\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9A"],

        ["\xF3\xB1\x8E\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x80"],
        ["\x9A\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9B"],

        ["\xF3\xB1\x8E\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x81"],
        ["\x9A\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9C"],

        ["\xF3\xB1\x8E\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x82"],
        ["\x9A\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9D"],

        ["\xF3\xB1\x8E\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x83"],
        ["\x9A\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9E"],

        ["\xF3\xB1\x8E\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x84"],
        ["\x9A\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9F"],

        ["\xF3\xB1\x8E\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x85"],
        ["\x9A\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA0"],

        ["\xF3\xB1\x8E\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x86"],
        ["\x9A\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA1"],

        ["\xF3\xB1\x8E\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x87"],
        ["\x9A\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA2"],

        ["\xF3\xB1\x8E\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x88"],
        ["\x9A\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA3"],

        ["\xF3\xB1\x8E\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x89"],
        ["\x9A\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA4"],

        ["\xF3\xB1\x8E\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8A"],
        ["\x9A\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA5"],

        ["\xF3\xB1\x8E\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8B"],
        ["\x9A\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA6"],

        ["\xF3\xB1\x8E\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8C"],
        ["\x9A\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA7"],

        ["\xF3\xB1\x8E\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8D"],
        ["\x9A\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA8"],

        ["\xF3\xB1\x8E\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8E"],
        ["\x9A\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA9"],

        ["\xF3\xB1\x8E\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8F"],
        ["\x9A\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAA"],

        ["\xF3\xB1\x8E\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x90"],
        ["\x9A\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAB"],

        ["\xF3\xB1\x8E\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x91"],
        ["\x9A\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAC"],

        ["\xF3\xB1\x8E\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x92"],
        ["\x9A\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAD"],

        ["\xF3\xB1\x8E\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x93"],
        ["\x9A\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAE"],

        ["\xF3\xB1\x8E\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x94"],
        ["\x9A\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAF"],

        ["\xF3\xB1\x8E\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x95"],
        ["\x9A\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB0"],

        ["\xF3\xB1\x8E\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x96"],
        ["\x9A\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB1"],

        ["\xF3\xB1\x8E\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x97"],
        ["\x9A\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB2"],

        ["\xF3\xB1\x8E\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x98"],
        ["\x9A\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB3"],

        ["\xF3\xB1\x8E\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x99"],
        ["\x9A\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB4"],

        ["\xF3\xB1\x8E\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9A"],
        ["\x9A\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB5"],

        ["\xF3\xB1\x8E\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9B"],
        ["\x9A\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB6"],

        ["\xF3\xB1\x8E\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9C"],
        ["\x9A\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB7"],

        ["\xF3\xB1\x8E\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9D"],
        ["\x9A\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB8"],

        ["\xF3\xB1\x8E\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9E"],
        ["\x9A\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB9"],

        ["\xF3\xB1\x8E\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x9F"],
        ["\x9A\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBA"],

        ["\xF3\xB1\x8E\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA0"],
        ["\x9A\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBB"],

        ["\xF3\xB1\x8E\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA1"],
        ["\x9A\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBC"],

        ["\xF3\xB1\x8E\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA2"],
        ["\x9A\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBD"],

        ["\xF3\xB1\x8E\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA3"],
        ["\x9A\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBE"],

        ["\xF3\xB1\x8E\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA4"],
        ["\x9A\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBF"],

        ["\xF3\xB1\x8F\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA5"],
        ["\x9A\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x80"],

        ["\xF3\xB1\x8F\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA6"],
        ["\x9A\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x81"],

        ["\xF3\xB1\x8F\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA7"],
        ["\x9A\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x82"],

        ["\xF3\xB1\x8F\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA8"],
        ["\x9A\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x83"],

        ["\xF3\xB1\x8F\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA9"],
        ["\x9A\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x84"],

        ["\xF3\xB1\x8F\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAA"],
        ["\x9A\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x85"],

        ["\xF3\xB1\x8F\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAB"],
        ["\x9A\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x86"],

        ["\xF3\xB1\x8F\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAC"],
        ["\x9A\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x87"],

        ["\xF3\xB1\x8F\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAD"],
        ["\x9A\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x88"],

        ["\xF3\xB1\x8F\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAE"],
        ["\x9A\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x89"],

        ["\xF3\xB1\x8F\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAF"],
        ["\x9A\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8A"],

        ["\xF3\xB1\x8F\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB0"],
        ["\x9A\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8B"],

        ["\xF3\xB1\x8F\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB1"],
        ["\x9A\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8C"],

        ["\xF3\xB1\x8F\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB2"],
        ["\x9A\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8D"],

        ["\xF3\xB1\x8F\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB3"],
        ["\x9A\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8E"],

        ["\xF3\xB1\x8F\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB4"],
        ["\x9A\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8F"],

        ["\xF3\xB1\x8F\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB5"],
        ["\x9A\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x90"],

        ["\xF3\xB1\x8F\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB6"],
        ["\x9A\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x91"],

        ["\xF3\xB1\x8F\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB7"],
        ["\x9A\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x92"],

        ["\xF3\xB1\x8F\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB8"],
        ["\x9A\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x93"],

        ["\xF3\xB1\x8F\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB9"],
        ["\x9A\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x94"],

        ["\xF3\xB1\x8F\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBA"],
        ["\x9A\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x95"],

        ["\xF3\xB1\x8F\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBB"],
        ["\x9A\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x96"],

        ["\xF3\xB1\x8F\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBC"],
        ["\x9A\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x97"],

        ["\xF3\xB1\x8F\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBD"],
        ["\x9A\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x98"],

        ["\xF3\xB1\x8F\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBE"],
        ["\x9A\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x99"],

        ["\xF3\xB1\x8F\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBF"],
        ["\x9A\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9A"],

        ["\xF3\xB1\x8F\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC0"],
        ["\x9A\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9B"],

        ["\xF3\xB1\x8F\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC1"],
        ["\x9A\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9C"],

        ["\xF3\xB1\x8F\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC2"],
        ["\x9A\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9D"],

        ["\xF3\xB1\x8F\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC3"],
        ["\x9A\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9E"],

        ["\xF3\xB1\x8F\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC4"],
        ["\x9A\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9F"],

        ["\xF3\xB1\x8F\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC5"],
        ["\x9A\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA0"],

        ["\xF3\xB1\x8F\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC6"],
        ["\x9A\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA1"],

        ["\xF3\xB1\x8F\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC7"],
        ["\x9A\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA2"],

        ["\xF3\xB1\x8F\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC8"],
        ["\x9A\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA3"],

        ["\xF3\xB1\x8F\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xC9"],
        ["\x9A\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA4"],

        ["\xF3\xB1\x8F\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCA"],
        ["\x9A\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA5"],

        ["\xF3\xB1\x8F\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCB"],
        ["\x9A\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA6"],

        ["\xF3\xB1\x8F\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCC"],
        ["\x9A\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA7"],

        ["\xF3\xB1\x8F\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCD"],
        ["\x9A\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA8"],

        ["\xF3\xB1\x8F\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCE"],
        ["\x9A\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA9"],

        ["\xF3\xB1\x8F\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCF"],
        ["\x9A\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAA"],

        ["\xF3\xB1\x8F\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD0"],
        ["\x9A\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAB"],

        ["\xF3\xB1\x8F\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD1"],
        ["\x9A\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAC"],

        ["\xF3\xB1\x8F\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD2"],
        ["\x9A\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAD"],

        ["\xF3\xB1\x8F\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD3"],
        ["\x9A\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAE"],

        ["\xF3\xB1\x8F\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD4"],
        ["\x9A\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAF"],

        ["\xF3\xB1\x8F\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD5"],
        ["\x9A\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB0"],

        ["\xF3\xB1\x8F\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD6"],
        ["\x9A\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB1"],

        ["\xF3\xB1\x8F\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD7"],
        ["\x9A\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB2"],

        ["\xF3\xB1\x8F\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD8"],
        ["\x9A\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB3"],

        ["\xF3\xB1\x8F\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xD9"],
        ["\x9A\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB4"],

        ["\xF3\xB1\x8F\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDA"],
        ["\x9A\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB5"],

        ["\xF3\xB1\x8F\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDB"],
        ["\x9A\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB6"],

        ["\xF3\xB1\x8F\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDC"],
        ["\x9A\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB7"],

        ["\xF3\xB1\x8F\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDD"],
        ["\x9A\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB8"],

        ["\xF3\xB1\x8F\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDE"],
        ["\x9A\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB9"],

        ["\xF3\xB1\x8F\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDF"],
        ["\x9A\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBA"],

        ["\xF3\xB1\x8F\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE0"],
        ["\x9A\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBB"],

        ["\xF3\xB1\x8F\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE1"],
        ["\x9A\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBC"],

        ["\xF3\xB1\x8F\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE2"],
        ["\x9A\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBD"],

        ["\xF3\xB1\x8F\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE3"],
        ["\x9A\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBE"],

        ["\xF3\xB1\x8F\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE4"],
        ["\x9A\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBF"],

        ["\xF3\xB1\x90\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE5"],
        ["\x9A\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x80"],

        ["\xF3\xB1\x90\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE6"],
        ["\x9A\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x81"],

        ["\xF3\xB1\x90\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE7"],
        ["\x9A\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x82"],

        ["\xF3\xB1\x90\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE8"],
        ["\x9A\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x83"],

        ["\xF3\xB1\x90\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xE9"],
        ["\x9A\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x84"],

        ["\xF3\xB1\x90\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEA"],
        ["\x9A\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x85"],

        ["\xF3\xB1\x90\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEB"],
        ["\x9A\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x86"],

        ["\xF3\xB1\x90\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEC"],
        ["\x9A\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x87"],

        ["\xF3\xB1\x90\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xED"],
        ["\x9A\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x88"],

        ["\xF3\xB1\x90\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEE"],
        ["\x9A\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x89"],

        ["\xF3\xB1\x90\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEF"],
        ["\x9A\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8A"],

        ["\xF3\xB1\x90\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF0"],
        ["\x9A\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8B"],

        ["\xF3\xB1\x90\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF1"],
        ["\x9A\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8C"],

        ["\xF3\xB1\x90\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF2"],
        ["\x9A\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8D"],

        ["\xF3\xB1\x90\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF3"],
        ["\x9A\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8E"],

        ["\xF3\xB1\x90\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF4"],
        ["\x9A\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8F"],

        ["\xF3\xB1\x90\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF5"],
        ["\x9A\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x90"],

        ["\xF3\xB1\x90\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF6"],
        ["\x9A\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x91"],

        ["\xF3\xB1\x90\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF7"],
        ["\x9A\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x92"],

        ["\xF3\xB1\x90\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF8"],
        ["\x9A\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x93"],

        ["\xF3\xB1\x90\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xF9"],
        ["\x9A\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x94"],

        ["\xF3\xB1\x90\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xFA"],
        ["\x9A\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x95"],

        ["\xF3\xB1\x90\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xFB"],
        ["\x9A\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x96"],

        ["\xF3\xB1\x90\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xFC"],
        ["\x9A\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x97"],

        ["\xF3\xB1\x90\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x40"],
        ["\x9B\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x98"],

        ["\xF3\xB1\x90\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x41"],
        ["\x9B\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x99"],

        ["\xF3\xB1\x90\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x42"],
        ["\x9B\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9A"],

        ["\xF3\xB1\x90\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x43"],
        ["\x9B\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9B"],

        ["\xF3\xB1\x90\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x44"],
        ["\x9B\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9C"],

        ["\xF3\xB1\x90\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x45"],
        ["\x9B\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9D"],

        ["\xF3\xB1\x90\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x46"],
        ["\x9B\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9E"],

        ["\xF3\xB1\x90\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x47"],
        ["\x9B\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9F"],

        ["\xF3\xB1\x90\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x48"],
        ["\x9B\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA0"],

        ["\xF3\xB1\x90\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x49"],
        ["\x9B\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA1"],

        ["\xF3\xB1\x90\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4A"],
        ["\x9B\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA2"],

        ["\xF3\xB1\x90\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4B"],
        ["\x9B\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA3"],

        ["\xF3\xB1\x90\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4C"],
        ["\x9B\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA4"],

        ["\xF3\xB1\x90\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4D"],
        ["\x9B\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA5"],

        ["\xF3\xB1\x90\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4E"],
        ["\x9B\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA6"],

        ["\xF3\xB1\x90\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x4F"],
        ["\x9B\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA7"],

        ["\xF3\xB1\x90\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x50"],
        ["\x9B\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA8"],

        ["\xF3\xB1\x90\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x51"],
        ["\x9B\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA9"],

        ["\xF3\xB1\x90\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x52"],
        ["\x9B\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAA"],

        ["\xF3\xB1\x90\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x53"],
        ["\x9B\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAB"],

        ["\xF3\xB1\x90\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x54"],
        ["\x9B\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAC"],

        ["\xF3\xB1\x90\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x55"],
        ["\x9B\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAD"],

        ["\xF3\xB1\x90\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x56"],
        ["\x9B\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAE"],

        ["\xF3\xB1\x90\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x57"],
        ["\x9B\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAF"],

        ["\xF3\xB1\x90\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x58"],
        ["\x9B\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB0"],

        ["\xF3\xB1\x90\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x59"],
        ["\x9B\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB1"],

        ["\xF3\xB1\x90\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5A"],
        ["\x9B\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB2"],

        ["\xF3\xB1\x90\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5B"],
        ["\x9B\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB3"],

        ["\xF3\xB1\x90\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5C"],
        ["\x9B\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB4"],

        ["\xF3\xB1\x90\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5D"],
        ["\x9B\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB5"],

        ["\xF3\xB1\x90\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5E"],
        ["\x9B\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB6"],

        ["\xF3\xB1\x90\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x5F"],
        ["\x9B\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB7"],

        ["\xF3\xB1\x90\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x60"],
        ["\x9B\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB8"],

        ["\xF3\xB1\x90\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x61"],
        ["\x9B\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB9"],

        ["\xF3\xB1\x90\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x62"],
        ["\x9B\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBA"],

        ["\xF3\xB1\x90\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x63"],
        ["\x9B\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBB"],

        ["\xF3\xB1\x90\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x64"],
        ["\x9B\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBC"],

        ["\xF3\xB1\x90\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x65"],
        ["\x9B\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBD"],

        ["\xF3\xB1\x90\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x66"],
        ["\x9B\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBE"],

        ["\xF3\xB1\x90\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x67"],
        ["\x9B\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBF"],

        ["\xF3\xB1\x91\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x68"],
        ["\x9B\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x80"],

        ["\xF3\xB1\x91\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x69"],
        ["\x9B\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x81"],

        ["\xF3\xB1\x91\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6A"],
        ["\x9B\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x82"],

        ["\xF3\xB1\x91\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6B"],
        ["\x9B\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x83"],

        ["\xF3\xB1\x91\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6C"],
        ["\x9B\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x84"],

        ["\xF3\xB1\x91\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6D"],
        ["\x9B\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x85"],

        ["\xF3\xB1\x91\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6E"],
        ["\x9B\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x86"],

        ["\xF3\xB1\x91\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x6F"],
        ["\x9B\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x87"],

        ["\xF3\xB1\x91\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x70"],
        ["\x9B\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x88"],

        ["\xF3\xB1\x91\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x71"],
        ["\x9B\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x89"],

        ["\xF3\xB1\x91\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x72"],
        ["\x9B\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8A"],

        ["\xF3\xB1\x91\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x73"],
        ["\x9B\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8B"],

        ["\xF3\xB1\x91\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x74"],
        ["\x9B\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8C"],

        ["\xF3\xB1\x91\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x75"],
        ["\x9B\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8D"],

        ["\xF3\xB1\x91\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x76"],
        ["\x9B\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8E"],

        ["\xF3\xB1\x91\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x77"],
        ["\x9B\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8F"],

        ["\xF3\xB1\x91\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x78"],
        ["\x9B\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x90"],

        ["\xF3\xB1\x91\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x79"],
        ["\x9B\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x91"],

        ["\xF3\xB1\x91\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x7A"],
        ["\x9B\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x92"],

        ["\xF3\xB1\x91\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x7B"],
        ["\x9B\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x93"],

        ["\xF3\xB1\x91\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x7C"],
        ["\x9B\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x94"],

        ["\xF3\xB1\x91\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x7D"],
        ["\x9B\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x95"],

        ["\xF3\xB1\x91\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x7E"],
        ["\x9B\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x96"],

        ["\xF3\xB1\x91\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x80"],
        ["\x9B\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x97"],

        ["\xF3\xB1\x91\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x81"],
        ["\x9B\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x98"],

        ["\xF3\xB1\x91\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x82"],
        ["\x9B\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x99"],

        ["\xF3\xB1\x91\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x83"],
        ["\x9B\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9A"],

        ["\xF3\xB1\x91\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x84"],
        ["\x9B\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9B"],

        ["\xF3\xB1\x91\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x85"],
        ["\x9B\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9C"],

        ["\xF3\xB1\x91\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x86"],
        ["\x9B\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9D"],

        ["\xF3\xB1\x91\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x87"],
        ["\x9B\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9E"],

        ["\xF3\xB1\x91\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x88"],
        ["\x9B\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9F"],

        ["\xF3\xB1\x91\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x89"],
        ["\x9B\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA0"],

        ["\xF3\xB1\x91\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8A"],
        ["\x9B\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA1"],

        ["\xF3\xB1\x91\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8B"],
        ["\x9B\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA2"],

        ["\xF3\xB1\x91\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8C"],
        ["\x9B\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA3"],

        ["\xF3\xB1\x91\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8D"],
        ["\x9B\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA4"],

        ["\xF3\xB1\x91\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8E"],
        ["\x9B\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA5"],

        ["\xF3\xB1\x91\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x8F"],
        ["\x9B\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA6"],

        ["\xF3\xB1\x91\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x90"],
        ["\x9B\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA7"],

        ["\xF3\xB1\x91\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x91"],
        ["\x9B\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA8"],

        ["\xF3\xB1\x91\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x92"],
        ["\x9B\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA9"],

        ["\xF3\xB1\x91\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x93"],
        ["\x9B\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAA"],

        ["\xF3\xB1\x91\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x94"],
        ["\x9B\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAB"],

        ["\xF3\xB1\x91\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x95"],
        ["\x9B\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAC"],

        ["\xF3\xB1\x91\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x96"],
        ["\x9B\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAD"],

        ["\xF3\xB1\x91\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x97"],
        ["\x9B\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAE"],

        ["\xF3\xB1\x91\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x98"],
        ["\x9B\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAF"],

        ["\xF3\xB1\x91\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x99"],
        ["\x9B\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB0"],

        ["\xF3\xB1\x91\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9A"],
        ["\x9B\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB1"],

        ["\xF3\xB1\x91\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9B"],
        ["\x9B\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB2"],

        ["\xF3\xB1\x91\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9C"],
        ["\x9B\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB3"],

        ["\xF3\xB1\x91\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9D"],
        ["\x9B\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB4"],

        ["\xF3\xB1\x91\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9E"],
        ["\x9B\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB5"],

        ["\xF3\xB1\x91\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\x9F"],
        ["\x9B\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB6"],

        ["\xF3\xB1\x91\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA0"],
        ["\x9B\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB7"],

        ["\xF3\xB1\x91\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA1"],
        ["\x9B\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB8"],

        ["\xF3\xB1\x91\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA2"],
        ["\x9B\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB9"],

        ["\xF3\xB1\x91\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA3"],
        ["\x9B\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBA"],

        ["\xF3\xB1\x91\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA4"],
        ["\x9B\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBB"],

        ["\xF3\xB1\x91\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA5"],
        ["\x9B\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBC"],

        ["\xF3\xB1\x91\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA6"],
        ["\x9B\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBD"],

        ["\xF3\xB1\x91\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA7"],
        ["\x9B\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBE"],

        ["\xF3\xB1\x91\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA8"],
        ["\x9B\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBF"],

        ["\xF3\xB1\x92\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xA9"],
        ["\x9B\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x80"],

        ["\xF3\xB1\x92\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAA"],
        ["\x9B\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x81"],

        ["\xF3\xB1\x92\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAB"],
        ["\x9B\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x82"],

        ["\xF3\xB1\x92\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAC"],
        ["\x9B\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x83"],

        ["\xF3\xB1\x92\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAD"],
        ["\x9B\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x84"],

        ["\xF3\xB1\x92\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAE"],
        ["\x9B\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x85"],

        ["\xF3\xB1\x92\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xAF"],
        ["\x9B\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x86"],

        ["\xF3\xB1\x92\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB0"],
        ["\x9B\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x87"],

        ["\xF3\xB1\x92\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB1"],
        ["\x9B\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x88"],

        ["\xF3\xB1\x92\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB2"],
        ["\x9B\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x89"],

        ["\xF3\xB1\x92\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB3"],
        ["\x9B\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8A"],

        ["\xF3\xB1\x92\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB4"],
        ["\x9B\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8B"],

        ["\xF3\xB1\x92\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB5"],
        ["\x9B\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8C"],

        ["\xF3\xB1\x92\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB6"],
        ["\x9B\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8D"],

        ["\xF3\xB1\x92\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB7"],
        ["\x9B\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8E"],

        ["\xF3\xB1\x92\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB8"],
        ["\x9B\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8F"],

        ["\xF3\xB1\x92\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xB9"],
        ["\x9B\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x90"],

        ["\xF3\xB1\x92\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBA"],
        ["\x9B\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x91"],

        ["\xF3\xB1\x92\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBB"],
        ["\x9B\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x92"],

        ["\xF3\xB1\x92\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBC"],
        ["\x9B\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x93"],

        ["\xF3\xB1\x92\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBD"],
        ["\x9B\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x94"],

        ["\xF3\xB1\x92\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBE"],
        ["\x9B\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x95"],

        ["\xF3\xB1\x92\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xBF"],
        ["\x9B\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x96"],

        ["\xF3\xB1\x92\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC0"],
        ["\x9B\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x97"],

        ["\xF3\xB1\x92\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC1"],
        ["\x9B\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x98"],

        ["\xF3\xB1\x92\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC2"],
        ["\x9B\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x99"],

        ["\xF3\xB1\x92\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC3"],
        ["\x9B\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9A"],

        ["\xF3\xB1\x92\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC4"],
        ["\x9B\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9B"],

        ["\xF3\xB1\x92\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC5"],
        ["\x9B\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9C"],

        ["\xF3\xB1\x92\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC6"],
        ["\x9B\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9D"],

        ["\xF3\xB1\x92\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC7"],
        ["\x9B\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9E"],

        ["\xF3\xB1\x92\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC8"],
        ["\x9B\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9F"],

        ["\xF3\xB1\x92\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xC9"],
        ["\x9B\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA0"],

        ["\xF3\xB1\x92\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCA"],
        ["\x9B\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA1"],

        ["\xF3\xB1\x92\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCB"],
        ["\x9B\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA2"],

        ["\xF3\xB1\x92\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCC"],
        ["\x9B\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA3"],

        ["\xF3\xB1\x92\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCD"],
        ["\x9B\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA4"],

        ["\xF3\xB1\x92\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCE"],
        ["\x9B\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA5"],

        ["\xF3\xB1\x92\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xCF"],
        ["\x9B\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA6"],

        ["\xF3\xB1\x92\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD0"],
        ["\x9B\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA7"],

        ["\xF3\xB1\x92\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD1"],
        ["\x9B\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA8"],

        ["\xF3\xB1\x92\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD2"],
        ["\x9B\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA9"],

        ["\xF3\xB1\x92\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD3"],
        ["\x9B\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAA"],

        ["\xF3\xB1\x92\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD4"],
        ["\x9B\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAB"],

        ["\xF3\xB1\x92\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD5"],
        ["\x9B\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAC"],

        ["\xF3\xB1\x92\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD6"],
        ["\x9B\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAD"],

        ["\xF3\xB1\x92\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD7"],
        ["\x9B\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAE"],

        ["\xF3\xB1\x92\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD8"],
        ["\x9B\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAF"],

        ["\xF3\xB1\x92\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xD9"],
        ["\x9B\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB0"],

        ["\xF3\xB1\x92\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDA"],
        ["\x9B\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB1"],

        ["\xF3\xB1\x92\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDB"],
        ["\x9B\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB2"],

        ["\xF3\xB1\x92\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDC"],
        ["\x9B\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB3"],

        ["\xF3\xB1\x92\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDD"],
        ["\x9B\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB4"],

        ["\xF3\xB1\x92\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDE"],
        ["\x9B\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB5"],

        ["\xF3\xB1\x92\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xDF"],
        ["\x9B\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB6"],

        ["\xF3\xB1\x92\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE0"],
        ["\x9B\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB7"],

        ["\xF3\xB1\x92\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE1"],
        ["\x9B\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB8"],

        ["\xF3\xB1\x92\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE2"],
        ["\x9B\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB9"],

        ["\xF3\xB1\x92\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE3"],
        ["\x9B\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBA"],

        ["\xF3\xB1\x92\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE4"],
        ["\x9B\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBB"],

        ["\xF3\xB1\x92\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE5"],
        ["\x9B\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBC"],

        ["\xF3\xB1\x92\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE6"],
        ["\x9B\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBD"],

        ["\xF3\xB1\x92\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE7"],
        ["\x9B\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBE"],

        ["\xF3\xB1\x92\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE8"],
        ["\x9B\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBF"],

        ["\xF3\xB1\x93\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xE9"],
        ["\x9B\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x80"],

        ["\xF3\xB1\x93\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xEA"],
        ["\x9B\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x81"],

        ["\xF3\xB1\x93\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xEB"],
        ["\x9B\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x82"],

        ["\xF3\xB1\x93\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xEC"],
        ["\x9B\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x83"],

        ["\xF3\xB1\x93\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xED"],
        ["\x9B\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x84"],

        ["\xF3\xB1\x93\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xEE"],
        ["\x9B\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x85"],

        ["\xF3\xB1\x93\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xEF"],
        ["\x9B\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x86"],

        ["\xF3\xB1\x93\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF0"],
        ["\x9B\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x87"],

        ["\xF3\xB1\x93\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF1"],
        ["\x9B\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x88"],

        ["\xF3\xB1\x93\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF2"],
        ["\x9B\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x89"],

        ["\xF3\xB1\x93\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF3"],
        ["\x9B\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8A"],

        ["\xF3\xB1\x93\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF4"],
        ["\x9B\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8B"],

        ["\xF3\xB1\x93\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF5"],
        ["\x9B\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8C"],

        ["\xF3\xB1\x93\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF6"],
        ["\x9B\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8D"],

        ["\xF3\xB1\x93\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF7"],
        ["\x9B\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8E"],

        ["\xF3\xB1\x93\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF8"],
        ["\x9B\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8F"],

        ["\xF3\xB1\x93\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xF9"],
        ["\x9B\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x90"],

        ["\xF3\xB1\x93\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xFA"],
        ["\x9B\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x91"],

        ["\xF3\xB1\x93\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xFB"],
        ["\x9B\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x92"],

        ["\xF3\xB1\x93\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B\xFC"],
        ["\x9B\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x93"],

        ["\xF3\xB1\x93\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x40"],
        ["\x9C\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x94"],

        ["\xF3\xB1\x93\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x41"],
        ["\x9C\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x95"],

        ["\xF3\xB1\x93\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x42"],
        ["\x9C\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x96"],

        ["\xF3\xB1\x93\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x43"],
        ["\x9C\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x97"],

        ["\xF3\xB1\x93\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x44"],
        ["\x9C\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x98"],

        ["\xF3\xB1\x93\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x45"],
        ["\x9C\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x99"],

        ["\xF3\xB1\x93\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x46"],
        ["\x9C\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9A"],

        ["\xF3\xB1\x93\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x47"],
        ["\x9C\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9B"],

        ["\xF3\xB1\x93\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x48"],
        ["\x9C\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9C"],

        ["\xF3\xB1\x93\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x49"],
        ["\x9C\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9D"],

        ["\xF3\xB1\x93\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4A"],
        ["\x9C\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9E"],

        ["\xF3\xB1\x93\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4B"],
        ["\x9C\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9F"],

        ["\xF3\xB1\x93\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4C"],
        ["\x9C\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA0"],

        ["\xF3\xB1\x93\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4D"],
        ["\x9C\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA1"],

        ["\xF3\xB1\x93\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4E"],
        ["\x9C\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA2"],

        ["\xF3\xB1\x93\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x4F"],
        ["\x9C\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA3"],

        ["\xF3\xB1\x93\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x50"],
        ["\x9C\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA4"],

        ["\xF3\xB1\x93\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x51"],
        ["\x9C\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA5"],

        ["\xF3\xB1\x93\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x52"],
        ["\x9C\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA6"],

        ["\xF3\xB1\x93\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x53"],
        ["\x9C\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA7"],

        ["\xF3\xB1\x93\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x54"],
        ["\x9C\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA8"],

        ["\xF3\xB1\x93\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x55"],
        ["\x9C\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA9"],

        ["\xF3\xB1\x93\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x56"],
        ["\x9C\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAA"],

        ["\xF3\xB1\x93\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x57"],
        ["\x9C\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAB"],

        ["\xF3\xB1\x93\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x58"],
        ["\x9C\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAC"],

        ["\xF3\xB1\x93\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x59"],
        ["\x9C\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAD"],

        ["\xF3\xB1\x93\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5B"],
        ["\x9C\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAF"],

        ["\xF3\xB1\x93\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5C"],
        ["\x9C\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB0"],

        ["\xF3\xB1\x93\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5D"],
        ["\x9C\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB1"],

        ["\xF3\xB1\x93\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5E"],
        ["\x9C\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB2"],

        ["\xF3\xB1\x93\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x5F"],
        ["\x9C\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB3"],

        ["\xF3\xB1\x93\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x60"],
        ["\x9C\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB4"],

        ["\xF3\xB1\x93\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x61"],
        ["\x9C\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB5"],

        ["\xF3\xB1\x93\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x62"],
        ["\x9C\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB6"],

        ["\xF3\xB1\x93\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x63"],
        ["\x9C\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB7"],

        ["\xF3\xB1\x93\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x64"],
        ["\x9C\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB8"],

        ["\xF3\xB1\x93\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x65"],
        ["\x9C\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB9"],

        ["\xF3\xB1\x93\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x66"],
        ["\x9C\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBA"],

        ["\xF3\xB1\x93\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x67"],
        ["\x9C\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBB"],

        ["\xF3\xB1\x93\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x68"],
        ["\x9C\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBC"],

        ["\xF3\xB1\x93\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x69"],
        ["\x9C\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBD"],

        ["\xF3\xB1\x93\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6A"],
        ["\x9C\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBE"],

        ["\xF3\xB1\x93\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6B"],
        ["\x9C\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBF"],

        ["\xF3\xB1\x94\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6C"],
        ["\x9C\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x80"],

        ["\xF3\xB1\x94\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6D"],
        ["\x9C\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x81"],

        ["\xF3\xB1\x94\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6E"],
        ["\x9C\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x82"],

        ["\xF3\xB1\x94\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x6F"],
        ["\x9C\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x83"],

        ["\xF3\xB1\x94\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x70"],
        ["\x9C\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x84"],

        ["\xF3\xB1\x94\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x71"],
        ["\x9C\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x85"],

        ["\xF3\xB1\x94\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x72"],
        ["\x9C\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x86"],

        ["\xF3\xB1\x94\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x73"],
        ["\x9C\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x87"],

        ["\xF3\xB1\x94\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x74"],
        ["\x9C\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x88"],

        ["\xF3\xB1\x94\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x75"],
        ["\x9C\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x89"],

        ["\xF3\xB1\x94\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x76"],
        ["\x9C\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8A"],

        ["\xF3\xB1\x94\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x77"],
        ["\x9C\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8B"],

        ["\xF3\xB1\x94\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x78"],
        ["\x9C\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8C"],

        ["\xF3\xB1\x94\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x79"],
        ["\x9C\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8D"],

        ["\xF3\xB1\x94\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x7A"],
        ["\x9C\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8E"],

        ["\xF3\xB1\x94\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x7B"],
        ["\x9C\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8F"],

        ["\xF3\xB1\x94\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x7C"],
        ["\x9C\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x90"],

        ["\xF3\xB1\x94\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x7D"],
        ["\x9C\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x91"],

        ["\xF3\xB1\x94\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x7E"],
        ["\x9C\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x92"],

        ["\xF3\xB1\x94\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x80"],
        ["\x9C\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x93"],

        ["\xF3\xB1\x94\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x81"],
        ["\x9C\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x94"],

        ["\xF3\xB1\x94\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x82"],
        ["\x9C\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x95"],

        ["\xF3\xB1\x94\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x83"],
        ["\x9C\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x96"],

        ["\xF3\xB1\x94\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x84"],
        ["\x9C\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x97"],

        ["\xF3\xB1\x94\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x85"],
        ["\x9C\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x98"],

        ["\xF3\xB1\x94\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x86"],
        ["\x9C\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x99"],

        ["\xF3\xB1\x94\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x87"],
        ["\x9C\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9A"],

        ["\xF3\xB1\x94\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x88"],
        ["\x9C\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9B"],

        ["\xF3\xB1\x94\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x89"],
        ["\x9C\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9C"],

        ["\xF3\xB1\x94\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8A"],
        ["\x9C\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9D"],

        ["\xF3\xB1\x94\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8B"],
        ["\x9C\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9E"],

        ["\xF3\xB1\x94\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8C"],
        ["\x9C\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9F"],

        ["\xF3\xB1\x94\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8D"],
        ["\x9C\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA0"],

        ["\xF3\xB1\x94\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8E"],
        ["\x9C\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA1"],

        ["\xF3\xB1\x94\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x8F"],
        ["\x9C\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA2"],

        ["\xF3\xB1\x94\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x90"],
        ["\x9C\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA3"],

        ["\xF3\xB1\x94\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x91"],
        ["\x9C\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA4"],

        ["\xF3\xB1\x94\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x92"],
        ["\x9C\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA5"],

        ["\xF3\xB1\x94\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x93"],
        ["\x9C\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA6"],

        ["\xF3\xB1\x94\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x94"],
        ["\x9C\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA7"],

        ["\xF3\xB1\x94\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x95"],
        ["\x9C\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA8"],

        ["\xF3\xB1\x94\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x96"],
        ["\x9C\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA9"],

        ["\xF3\xB1\x94\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x97"],
        ["\x9C\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAA"],

        ["\xF3\xB1\x94\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x98"],
        ["\x9C\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAB"],

        ["\xF3\xB1\x94\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x99"],
        ["\x9C\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAC"],

        ["\xF3\xB1\x94\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9A"],
        ["\x9C\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAD"],

        ["\xF3\xB1\x94\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9B"],
        ["\x9C\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAE"],

        ["\xF3\xB1\x94\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9C"],
        ["\x9C\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAF"],

        ["\xF3\xB1\x94\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9D"],
        ["\x9C\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB0"],

        ["\xF3\xB1\x94\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9E"],
        ["\x9C\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB1"],

        ["\xF3\xB1\x94\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\x9F"],
        ["\x9C\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB2"],

        ["\xF3\xB1\x94\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA0"],
        ["\x9C\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB3"],

        ["\xF3\xB1\x94\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA1"],
        ["\x9C\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB4"],

        ["\xF3\xB1\x94\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA2"],
        ["\x9C\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB5"],

        ["\xF3\xB1\x94\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA3"],
        ["\x9C\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB6"],

        ["\xF3\xB1\x94\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA4"],
        ["\x9C\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB7"],

        ["\xF3\xB1\x94\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA5"],
        ["\x9C\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB8"],

        ["\xF3\xB1\x94\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA6"],
        ["\x9C\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB9"],

        ["\xF3\xB1\x94\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA7"],
        ["\x9C\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBA"],

        ["\xF3\xB1\x94\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA8"],
        ["\x9C\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBB"],

        ["\xF3\xB1\x94\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xA9"],
        ["\x9C\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBC"],

        ["\xF3\xB1\x94\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAA"],
        ["\x9C\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBD"],

        ["\xF3\xB1\x94\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAB"],
        ["\x9C\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBE"],

        ["\xF3\xB1\x94\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAC"],
        ["\x9C\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBF"],

        ["\xF3\xB1\x95\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAD"],
        ["\x9C\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x80"],

        ["\xF3\xB1\x95\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAE"],
        ["\x9C\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x81"],

        ["\xF3\xB1\x95\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xAF"],
        ["\x9C\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x82"],

        ["\xF3\xB1\x95\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB0"],
        ["\x9C\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x83"],

        ["\xF3\xB1\x95\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB1"],
        ["\x9C\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x84"],

        ["\xF3\xB1\x95\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB2"],
        ["\x9C\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x85"],

        ["\xF3\xB1\x95\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB3"],
        ["\x9C\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x86"],

        ["\xF3\xB1\x95\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB4"],
        ["\x9C\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x87"],

        ["\xF3\xB1\x95\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB5"],
        ["\x9C\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x88"],

        ["\xF3\xB1\x95\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB6"],
        ["\x9C\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x89"],

        ["\xF3\xB1\x95\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB7"],
        ["\x9C\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8A"],

        ["\xF3\xB1\x95\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB8"],
        ["\x9C\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8B"],

        ["\xF3\xB1\x95\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xB9"],
        ["\x9C\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8C"],

        ["\xF3\xB1\x95\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBA"],
        ["\x9C\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8D"],

        ["\xF3\xB1\x95\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBB"],
        ["\x9C\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8E"],

        ["\xF3\xB1\x95\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBC"],
        ["\x9C\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8F"],

        ["\xF3\xB1\x95\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBD"],
        ["\x9C\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x90"],

        ["\xF3\xB1\x95\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBE"],
        ["\x9C\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x91"],

        ["\xF3\xB1\x95\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xBF"],
        ["\x9C\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x92"],

        ["\xF3\xB1\x95\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC0"],
        ["\x9C\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x93"],

        ["\xF3\xB1\x95\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC1"],
        ["\x9C\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x94"],

        ["\xF3\xB1\x95\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC2"],
        ["\x9C\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x95"],

        ["\xF3\xB1\x95\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC3"],
        ["\x9C\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x96"],

        ["\xF3\xB1\x95\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC4"],
        ["\x9C\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x97"],

        ["\xF3\xB1\x95\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC5"],
        ["\x9C\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x98"],

        ["\xF3\xB1\x95\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC6"],
        ["\x9C\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x99"],

        ["\xF3\xB1\x95\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC7"],
        ["\x9C\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9A"],

        ["\xF3\xB1\x95\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC8"],
        ["\x9C\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9B"],

        ["\xF3\xB1\x95\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xC9"],
        ["\x9C\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9C"],

        ["\xF3\xB1\x95\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCA"],
        ["\x9C\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9D"],

        ["\xF3\xB1\x95\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCB"],
        ["\x9C\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9E"],

        ["\xF3\xB1\x95\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCC"],
        ["\x9C\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9F"],

        ["\xF3\xB1\x95\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCD"],
        ["\x9C\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA0"],

        ["\xF3\xB1\x95\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCE"],
        ["\x9C\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA1"],

        ["\xF3\xB1\x95\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xCF"],
        ["\x9C\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA2"],

        ["\xF3\xB1\x95\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD0"],
        ["\x9C\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA3"],

        ["\xF3\xB1\x95\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD1"],
        ["\x9C\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA4"],

        ["\xF3\xB1\x95\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD2"],
        ["\x9C\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA5"],

        ["\xF3\xB1\x95\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD3"],
        ["\x9C\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA6"],

        ["\xF3\xB1\x95\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD4"],
        ["\x9C\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA7"],

        ["\xF3\xB1\x95\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD5"],
        ["\x9C\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA8"],

        ["\xF3\xB1\x95\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD6"],
        ["\x9C\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA9"],

        ["\xF3\xB1\x95\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD7"],
        ["\x9C\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAA"],

        ["\xF3\xB1\x95\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD8"],
        ["\x9C\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAB"],

        ["\xF3\xB1\x95\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xD9"],
        ["\x9C\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAC"],

        ["\xF3\xB1\x95\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDA"],
        ["\x9C\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAD"],

        ["\xF3\xB1\x95\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDB"],
        ["\x9C\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAE"],

        ["\xF3\xB1\x95\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDC"],
        ["\x9C\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAF"],

        ["\xF3\xB1\x95\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDD"],
        ["\x9C\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB0"],

        ["\xF3\xB1\x95\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDE"],
        ["\x9C\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB1"],

        ["\xF3\xB1\x95\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xDF"],
        ["\x9C\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB2"],

        ["\xF3\xB1\x95\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE0"],
        ["\x9C\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB3"],

        ["\xF3\xB1\x95\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE1"],
        ["\x9C\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB4"],

        ["\xF3\xB1\x95\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE2"],
        ["\x9C\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB5"],

        ["\xF3\xB1\x95\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE3"],
        ["\x9C\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB6"],

        ["\xF3\xB1\x95\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE4"],
        ["\x9C\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB7"],

        ["\xF3\xB1\x95\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE5"],
        ["\x9C\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB8"],

        ["\xF3\xB1\x95\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE6"],
        ["\x9C\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB9"],

        ["\xF3\xB1\x95\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE7"],
        ["\x9C\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBA"],

        ["\xF3\xB1\x95\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE8"],
        ["\x9C\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBB"],

        ["\xF3\xB1\x95\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xE9"],
        ["\x9C\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBC"],

        ["\xF3\xB1\x95\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xEA"],
        ["\x9C\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBD"],

        ["\xF3\xB1\x95\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xEB"],
        ["\x9C\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBE"],

        ["\xF3\xB1\x95\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xEC"],
        ["\x9C\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBF"],

        ["\xF3\xB1\x96\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xED"],
        ["\x9C\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x80"],

        ["\xF3\xB1\x96\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xEE"],
        ["\x9C\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x81"],

        ["\xF3\xB1\x96\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xEF"],
        ["\x9C\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x82"],

        ["\xF3\xB1\x96\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF0"],
        ["\x9C\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x83"],

        ["\xF3\xB1\x96\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF1"],
        ["\x9C\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x84"],

        ["\xF3\xB1\x96\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF2"],
        ["\x9C\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x85"],

        ["\xF3\xB1\x96\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF3"],
        ["\x9C\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x86"],

        ["\xF3\xB1\x96\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF4"],
        ["\x9C\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x87"],

        ["\xF3\xB1\x96\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF5"],
        ["\x9C\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x88"],

        ["\xF3\xB1\x96\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF6"],
        ["\x9C\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x89"],

        ["\xF3\xB1\x96\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF7"],
        ["\x9C\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8A"],

        ["\xF3\xB1\x96\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF8"],
        ["\x9C\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8B"],

        ["\xF3\xB1\x96\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xF9"],
        ["\x9C\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8C"],

        ["\xF3\xB1\x96\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xFA"],
        ["\x9C\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8D"],

        ["\xF3\xB1\x96\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xFB"],
        ["\x9C\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8E"],

        ["\xF3\xB1\x96\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C\xFC"],
        ["\x9C\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8F"],

        ["\xF3\xB1\x96\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x40"],
        ["\x9D\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x90"],

        ["\xF3\xB1\x96\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x41"],
        ["\x9D\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x91"],

        ["\xF3\xB1\x96\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x42"],
        ["\x9D\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x92"],

        ["\xF3\xB1\x96\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x43"],
        ["\x9D\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x93"],

        ["\xF3\xB1\x96\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x44"],
        ["\x9D\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x94"],

        ["\xF3\xB1\x96\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x45"],
        ["\x9D\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x95"],

        ["\xF3\xB1\x96\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x46"],
        ["\x9D\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x96"],

        ["\xF3\xB1\x96\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x47"],
        ["\x9D\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x97"],

        ["\xF3\xB1\x96\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x48"],
        ["\x9D\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x98"],

        ["\xF3\xB1\x96\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x49"],
        ["\x9D\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x99"],

        ["\xF3\xB1\x96\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4A"],
        ["\x9D\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9A"],

        ["\xF3\xB1\x96\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4B"],
        ["\x9D\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9B"],

        ["\xF3\xB1\x96\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4C"],
        ["\x9D\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9C"],

        ["\xF3\xB1\x96\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4D"],
        ["\x9D\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9D"],

        ["\xF3\xB1\x96\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4E"],
        ["\x9D\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9E"],

        ["\xF3\xB1\x96\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x4F"],
        ["\x9D\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9F"],

        ["\xF3\xB1\x96\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x50"],
        ["\x9D\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA0"],

        ["\xF3\xB1\x96\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x51"],
        ["\x9D\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA1"],

        ["\xF3\xB1\x96\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x52"],
        ["\x9D\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA2"],

        ["\xF3\xB1\x96\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x53"],
        ["\x9D\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA3"],

        ["\xF3\xB1\x96\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x54"],
        ["\x9D\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA4"],

        ["\xF3\xB1\x96\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x55"],
        ["\x9D\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA5"],

        ["\xF3\xB1\x96\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x56"],
        ["\x9D\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA6"],

        ["\xF3\xB1\x96\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x57"],
        ["\x9D\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA7"],

        ["\xF3\xB1\x96\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x58"],
        ["\x9D\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA8"],

        ["\xF3\xB1\x96\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x59"],
        ["\x9D\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA9"],

        ["\xF3\xB1\x96\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5A"],
        ["\x9D\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAA"],

        ["\xF3\xB1\x96\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5B"],
        ["\x9D\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAB"],

        ["\xF3\xB1\x96\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5C"],
        ["\x9D\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAC"],

        ["\xF3\xB1\x96\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5D"],
        ["\x9D\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAD"],

        ["\xF3\xB1\x96\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5E"],
        ["\x9D\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAE"],

        ["\xF3\xB1\x96\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x5F"],
        ["\x9D\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAF"],

        ["\xF3\xB1\x96\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x60"],
        ["\x9D\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB0"],

        ["\xF3\xB1\x96\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x61"],
        ["\x9D\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB1"],

        ["\xF3\xB1\x96\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x62"],
        ["\x9D\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB2"],

        ["\xF3\xB1\x96\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x63"],
        ["\x9D\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB3"],

        ["\xF3\xB1\x96\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x64"],
        ["\x9D\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB4"],

        ["\xF3\xB1\x96\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x65"],
        ["\x9D\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB5"],

        ["\xF3\xB1\x96\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x66"],
        ["\x9D\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB6"],

        ["\xF3\xB1\x96\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x67"],
        ["\x9D\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB7"],

        ["\xF3\xB1\x96\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x68"],
        ["\x9D\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB8"],

        ["\xF3\xB1\x96\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x69"],
        ["\x9D\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB9"],

        ["\xF3\xB1\x96\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6A"],
        ["\x9D\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBA"],

        ["\xF3\xB1\x96\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6B"],
        ["\x9D\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBB"],

        ["\xF3\xB1\x96\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6C"],
        ["\x9D\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBC"],

        ["\xF3\xB1\x96\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6D"],
        ["\x9D\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBD"],

        ["\xF3\xB1\x96\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6E"],
        ["\x9D\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBE"],

        ["\xF3\xB1\x96\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x6F"],
        ["\x9D\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBF"],

        ["\xF3\xB1\x97\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x70"],
        ["\x9D\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x80"],

        ["\xF3\xB1\x97\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x71"],
        ["\x9D\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x81"],

        ["\xF3\xB1\x97\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x72"],
        ["\x9D\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x82"],

        ["\xF3\xB1\x97\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x73"],
        ["\x9D\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x83"],

        ["\xF3\xB1\x97\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x74"],
        ["\x9D\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x84"],

        ["\xF3\xB1\x97\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x75"],
        ["\x9D\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x85"],

        ["\xF3\xB1\x97\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x76"],
        ["\x9D\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x86"],

        ["\xF3\xB1\x97\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x77"],
        ["\x9D\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x87"],

        ["\xF3\xB1\x97\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x78"],
        ["\x9D\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x88"],

        ["\xF3\xB1\x97\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x79"],
        ["\x9D\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x89"],

        ["\xF3\xB1\x97\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x7A"],
        ["\x9D\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8A"],

        ["\xF3\xB1\x97\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x7B"],
        ["\x9D\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8B"],

        ["\xF3\xB1\x97\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x7C"],
        ["\x9D\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8C"],

        ["\xF3\xB1\x97\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x7D"],
        ["\x9D\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8D"],

        ["\xF3\xB1\x97\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x7E"],
        ["\x9D\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8E"],

        ["\xF3\xB1\x97\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x80"],
        ["\x9D\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8F"],

        ["\xF3\xB1\x97\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x81"],
        ["\x9D\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x90"],

        ["\xF3\xB1\x97\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x82"],
        ["\x9D\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x91"],

        ["\xF3\xB1\x97\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x83"],
        ["\x9D\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x92"],

        ["\xF3\xB1\x97\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x84"],
        ["\x9D\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x93"],

        ["\xF3\xB1\x97\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x85"],
        ["\x9D\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x94"],

        ["\xF3\xB1\x97\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x86"],
        ["\x9D\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x95"],

        ["\xF3\xB1\x97\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x87"],
        ["\x9D\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x96"],

        ["\xF3\xB1\x97\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x88"],
        ["\x9D\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x97"],

        ["\xF3\xB1\x97\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x89"],
        ["\x9D\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x98"],

        ["\xF3\xB1\x97\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8A"],
        ["\x9D\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x99"],

        ["\xF3\xB1\x97\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8B"],
        ["\x9D\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9A"],

        ["\xF3\xB1\x97\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8C"],
        ["\x9D\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9B"],

        ["\xF3\xB1\x97\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8D"],
        ["\x9D\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9C"],

        ["\xF3\xB1\x97\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8E"],
        ["\x9D\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9D"],

        ["\xF3\xB1\x97\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x8F"],
        ["\x9D\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9E"],

        ["\xF3\xB1\x97\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x90"],
        ["\x9D\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9F"],

        ["\xF3\xB1\x97\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x91"],
        ["\x9D\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA0"],

        ["\xF3\xB1\x97\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x92"],
        ["\x9D\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA1"],

        ["\xF3\xB1\x97\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x93"],
        ["\x9D\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA2"],

        ["\xF3\xB1\x97\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x94"],
        ["\x9D\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA3"],

        ["\xF3\xB1\x97\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x95"],
        ["\x9D\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA4"],

        ["\xF3\xB1\x97\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x96"],
        ["\x9D\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA5"],

        ["\xF3\xB1\x97\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x97"],
        ["\x9D\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA6"],

        ["\xF3\xB1\x97\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x98"],
        ["\x9D\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA7"],

        ["\xF3\xB1\x97\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x99"],
        ["\x9D\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA8"],

        ["\xF3\xB1\x97\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9A"],
        ["\x9D\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA9"],

        ["\xF3\xB1\x97\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9B"],
        ["\x9D\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAA"],

        ["\xF3\xB1\x97\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9C"],
        ["\x9D\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAB"],

        ["\xF3\xB1\x97\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9D"],
        ["\x9D\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAC"],

        ["\xF3\xB1\x97\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9E"],
        ["\x9D\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAD"],

        ["\xF3\xB1\x97\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x9F"],
        ["\x9D\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAE"],

        ["\xF3\xB1\x97\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA0"],
        ["\x9D\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAF"],

        ["\xF3\xB1\x97\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA1"],
        ["\x9D\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB0"],

        ["\xF3\xB1\x97\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA2"],
        ["\x9D\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB1"],

        ["\xF3\xB1\x97\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA3"],
        ["\x9D\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB2"],

        ["\xF3\xB1\x97\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA4"],
        ["\x9D\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB3"],

        ["\xF3\xB1\x97\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA5"],
        ["\x9D\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB4"],

        ["\xF3\xB1\x97\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA6"],
        ["\x9D\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB5"],

        ["\xF3\xB1\x97\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA7"],
        ["\x9D\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB6"],

        ["\xF3\xB1\x97\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA8"],
        ["\x9D\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB7"],

        ["\xF3\xB1\x97\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA9"],
        ["\x9D\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB8"],

        ["\xF3\xB1\x97\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAA"],
        ["\x9D\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB9"],

        ["\xF3\xB1\x97\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAB"],
        ["\x9D\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBA"],

        ["\xF3\xB1\x97\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAC"],
        ["\x9D\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBB"],

        ["\xF3\xB1\x97\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAD"],
        ["\x9D\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBC"],

        ["\xF3\xB1\x97\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAE"],
        ["\x9D\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBD"],

        ["\xF3\xB1\x97\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xAF"],
        ["\x9D\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBE"],

        ["\xF3\xB1\x97\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB0"],
        ["\x9D\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBF"],

        ["\xF3\xB1\x98\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB1"],
        ["\x9D\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x80"],

        ["\xF3\xB1\x98\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB2"],
        ["\x9D\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x81"],

        ["\xF3\xB1\x98\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB3"],
        ["\x9D\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x82"],

        ["\xF3\xB1\x98\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB4"],
        ["\x9D\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x83"],

        ["\xF3\xB1\x98\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB5"],
        ["\x9D\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x84"],

        ["\xF3\xB1\x98\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB6"],
        ["\x9D\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x85"],

        ["\xF3\xB1\x98\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB7"],
        ["\x9D\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x86"],

        ["\xF3\xB1\x98\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB8"],
        ["\x9D\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x87"],

        ["\xF3\xB1\x98\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB9"],
        ["\x9D\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x88"],

        ["\xF3\xB1\x98\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBA"],
        ["\x9D\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x89"],

        ["\xF3\xB1\x98\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBB"],
        ["\x9D\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8A"],

        ["\xF3\xB1\x98\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBC"],
        ["\x9D\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8B"],

        ["\xF3\xB1\x98\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBD"],
        ["\x9D\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8C"],

        ["\xF3\xB1\x98\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBE"],
        ["\x9D\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8D"],

        ["\xF3\xB1\x98\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBF"],
        ["\x9D\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8E"],

        ["\xF3\xB1\x98\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC0"],
        ["\x9D\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8F"],

        ["\xF3\xB1\x98\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC1"],
        ["\x9D\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x90"],

        ["\xF3\xB1\x98\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC2"],
        ["\x9D\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x91"],

        ["\xF3\xB1\x98\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC3"],
        ["\x9D\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x92"],

        ["\xF3\xB1\x98\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC4"],
        ["\x9D\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x93"],

        ["\xF3\xB1\x98\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC5"],
        ["\x9D\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x94"],

        ["\xF3\xB1\x98\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC6"],
        ["\x9D\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x95"],

        ["\xF3\xB1\x98\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC7"],
        ["\x9D\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x96"],

        ["\xF3\xB1\x98\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC8"],
        ["\x9D\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x97"],

        ["\xF3\xB1\x98\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xC9"],
        ["\x9D\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x98"],

        ["\xF3\xB1\x98\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCA"],
        ["\x9D\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x99"],

        ["\xF3\xB1\x98\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCB"],
        ["\x9D\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9A"],

        ["\xF3\xB1\x98\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCC"],
        ["\x9D\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9B"],

        ["\xF3\xB1\x98\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCD"],
        ["\x9D\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9C"],

        ["\xF3\xB1\x98\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCE"],
        ["\x9D\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9D"],

        ["\xF3\xB1\x98\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xCF"],
        ["\x9D\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9E"],

        ["\xF3\xB1\x98\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD0"],
        ["\x9D\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9F"],

        ["\xF3\xB1\x98\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD1"],
        ["\x9D\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA0"],

        ["\xF3\xB1\x98\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD2"],
        ["\x9D\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA1"],

        ["\xF3\xB1\x98\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD3"],
        ["\x9D\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA2"],

        ["\xF3\xB1\x98\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD4"],
        ["\x9D\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA3"],

        ["\xF3\xB1\x98\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD5"],
        ["\x9D\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA4"],

        ["\xF3\xB1\x98\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD6"],
        ["\x9D\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA5"],

        ["\xF3\xB1\x98\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD7"],
        ["\x9D\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA6"],

        ["\xF3\xB1\x98\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD8"],
        ["\x9D\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA7"],

        ["\xF3\xB1\x98\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xD9"],
        ["\x9D\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA8"],

        ["\xF3\xB1\x98\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDA"],
        ["\x9D\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA9"],

        ["\xF3\xB1\x98\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDB"],
        ["\x9D\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAA"],

        ["\xF3\xB1\x98\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDC"],
        ["\x9D\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAB"],

        ["\xF3\xB1\x98\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDD"],
        ["\x9D\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAC"],

        ["\xF3\xB1\x98\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDE"],
        ["\x9D\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAD"],

        ["\xF3\xB1\x98\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDF"],
        ["\x9D\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAE"],

        ["\xF3\xB1\x98\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE0"],
        ["\x9D\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAF"],

        ["\xF3\xB1\x98\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE1"],
        ["\x9D\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB0"],

        ["\xF3\xB1\x98\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE2"],
        ["\x9D\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB1"],

        ["\xF3\xB1\x98\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE3"],
        ["\x9D\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB2"],

        ["\xF3\xB1\x98\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE4"],
        ["\x9D\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB3"],

        ["\xF3\xB1\x98\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE5"],
        ["\x9D\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB4"],

        ["\xF3\xB1\x98\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE6"],
        ["\x9D\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB5"],

        ["\xF3\xB1\x98\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE7"],
        ["\x9D\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB6"],

        ["\xF3\xB1\x98\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE8"],
        ["\x9D\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB7"],

        ["\xF3\xB1\x98\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xE9"],
        ["\x9D\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB8"],

        ["\xF3\xB1\x98\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xEA"],
        ["\x9D\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB9"],

        ["\xF3\xB1\x98\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xEB"],
        ["\x9D\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBA"],

        ["\xF3\xB1\x98\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xEC"],
        ["\x9D\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBB"],

        ["\xF3\xB1\x98\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xED"],
        ["\x9D\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBC"],

        ["\xF3\xB1\x98\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xEE"],
        ["\x9D\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBD"],

        ["\xF3\xB1\x98\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xEF"],
        ["\x9D\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBE"],

        ["\xF3\xB1\x98\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF0"],
        ["\x9D\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBF"],

        ["\xF3\xB1\x99\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF1"],
        ["\x9D\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x80"],

        ["\xF3\xB1\x99\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF2"],
        ["\x9D\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x81"],

        ["\xF3\xB1\x99\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF3"],
        ["\x9D\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x82"],

        ["\xF3\xB1\x99\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF4"],
        ["\x9D\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x83"],

        ["\xF3\xB1\x99\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF5"],
        ["\x9D\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x84"],

        ["\xF3\xB1\x99\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF6"],
        ["\x9D\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x85"],

        ["\xF3\xB1\x99\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF7"],
        ["\x9D\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x86"],

        ["\xF3\xB1\x99\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF8"],
        ["\x9D\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x87"],

        ["\xF3\xB1\x99\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xF9"],
        ["\x9D\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x88"],

        ["\xF3\xB1\x99\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xFA"],
        ["\x9D\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x89"],

        ["\xF3\xB1\x99\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xFB"],
        ["\x9D\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8A"],

        ["\xF3\xB1\x99\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xFC"],
        ["\x9D\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8B"],

        ["\xF3\xB1\x99\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x40"],
        ["\x9E\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8C"],

        ["\xF3\xB1\x99\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x41"],
        ["\x9E\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8D"],

        ["\xF3\xB1\x99\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x42"],
        ["\x9E\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8E"],

        ["\xF3\xB1\x99\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x43"],
        ["\x9E\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8F"],

        ["\xF3\xB1\x99\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x44"],
        ["\x9E\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x90"],

        ["\xF3\xB1\x99\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x45"],
        ["\x9E\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x91"],

        ["\xF3\xB1\x99\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x46"],
        ["\x9E\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x92"],

        ["\xF3\xB1\x99\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x47"],
        ["\x9E\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x93"],

        ["\xF3\xB1\x99\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x48"],
        ["\x9E\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x94"],

        ["\xF3\xB1\x99\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x49"],
        ["\x9E\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x95"],

        ["\xF3\xB1\x99\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4A"],
        ["\x9E\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x96"],

        ["\xF3\xB1\x99\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4B"],
        ["\x9E\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x97"],

        ["\xF3\xB1\x99\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4C"],
        ["\x9E\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x98"],

        ["\xF3\xB1\x99\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4D"],
        ["\x9E\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x99"],

        ["\xF3\xB1\x99\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4E"],
        ["\x9E\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9A"],

        ["\xF3\xB1\x99\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x4F"],
        ["\x9E\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9B"],

        ["\xF3\xB1\x99\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x50"],
        ["\x9E\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9C"],

        ["\xF3\xB1\x99\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x51"],
        ["\x9E\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9D"],

        ["\xF3\xB1\x99\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x52"],
        ["\x9E\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9E"],

        ["\xF3\xB1\x99\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x53"],
        ["\x9E\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9F"],

        ["\xF3\xB1\x99\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x54"],
        ["\x9E\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA0"],

        ["\xF3\xB1\x99\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x55"],
        ["\x9E\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA1"],

        ["\xF3\xB1\x99\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x56"],
        ["\x9E\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA2"],

        ["\xF3\xB1\x99\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x57"],
        ["\x9E\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA3"],

        ["\xF3\xB1\x99\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x58"],
        ["\x9E\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA4"],

        ["\xF3\xB1\x99\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x59"],
        ["\x9E\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA5"],

        ["\xF3\xB1\x99\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5A"],
        ["\x9E\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA6"],

        ["\xF3\xB1\x99\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5B"],
        ["\x9E\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA7"],

        ["\xF3\xB1\x99\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5C"],
        ["\x9E\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA8"],

        ["\xF3\xB1\x99\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5D"],
        ["\x9E\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA9"],

        ["\xF3\xB1\x99\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5E"],
        ["\x9E\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAA"],

        ["\xF3\xB1\x99\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x5F"],
        ["\x9E\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAB"],

        ["\xF3\xB1\x99\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x60"],
        ["\x9E\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAC"],

        ["\xF3\xB1\x99\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x61"],
        ["\x9E\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAD"],

        ["\xF3\xB1\x99\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x62"],
        ["\x9E\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAE"],

        ["\xF3\xB1\x99\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x63"],
        ["\x9E\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAF"],

        ["\xF3\xB1\x99\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x64"],
        ["\x9E\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB0"],

        ["\xF3\xB1\x99\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x65"],
        ["\x9E\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB1"],

        ["\xF3\xB1\x99\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x66"],
        ["\x9E\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB2"],

        ["\xF3\xB1\x99\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x67"],
        ["\x9E\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB3"],

        ["\xF3\xB1\x99\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x68"],
        ["\x9E\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB4"],

        ["\xF3\xB1\x99\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x69"],
        ["\x9E\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB5"],

        ["\xF3\xB1\x99\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6A"],
        ["\x9E\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB6"],

        ["\xF3\xB1\x99\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6B"],
        ["\x9E\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB7"],

        ["\xF3\xB1\x99\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6C"],
        ["\x9E\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB8"],

        ["\xF3\xB1\x99\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6D"],
        ["\x9E\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB9"],

        ["\xF3\xB1\x99\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6E"],
        ["\x9E\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBA"],

        ["\xF3\xB1\x99\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x6F"],
        ["\x9E\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBB"],

        ["\xF3\xB1\x99\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x70"],
        ["\x9E\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBC"],

        ["\xF3\xB1\x99\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x71"],
        ["\x9E\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBD"],

        ["\xF3\xB1\x99\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x72"],
        ["\x9E\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBE"],

        ["\xF3\xB1\x99\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x73"],
        ["\x9E\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBF"],

        ["\xF3\xB1\x9A\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x74"],
        ["\x9E\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x80"],

        ["\xF3\xB1\x9A\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x75"],
        ["\x9E\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x81"],

        ["\xF3\xB1\x9A\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x76"],
        ["\x9E\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x82"],

        ["\xF3\xB1\x9A\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x77"],
        ["\x9E\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x83"],

        ["\xF3\xB1\x9A\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x78"],
        ["\x9E\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x84"],

        ["\xF3\xB1\x9A\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x79"],
        ["\x9E\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x85"],

        ["\xF3\xB1\x9A\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x7A"],
        ["\x9E\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x86"],

        ["\xF3\xB1\x9A\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x7B"],
        ["\x9E\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x87"],

        ["\xF3\xB1\x9A\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x7C"],
        ["\x9E\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x88"],

        ["\xF3\xB1\x9A\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x7D"],
        ["\x9E\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x89"],

        ["\xF3\xB1\x9A\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x7E"],
        ["\x9E\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8A"],

        ["\xF3\xB1\x9A\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x80"],
        ["\x9E\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8B"],

        ["\xF3\xB1\x9A\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x81"],
        ["\x9E\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8C"],

        ["\xF3\xB1\x9A\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x82"],
        ["\x9E\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8D"],

        ["\xF3\xB1\x9A\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x83"],
        ["\x9E\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8E"],

        ["\xF3\xB1\x9A\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x84"],
        ["\x9E\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8F"],

        ["\xF3\xB1\x9A\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x85"],
        ["\x9E\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x90"],

        ["\xF3\xB1\x9A\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x86"],
        ["\x9E\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x91"],

        ["\xF3\xB1\x9A\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x87"],
        ["\x9E\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x92"],

        ["\xF3\xB1\x9A\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x88"],
        ["\x9E\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x93"],

        ["\xF3\xB1\x9A\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x89"],
        ["\x9E\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x94"],

        ["\xF3\xB1\x9A\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8A"],
        ["\x9E\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x95"],

        ["\xF3\xB1\x9A\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8B"],
        ["\x9E\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x96"],

        ["\xF3\xB1\x9A\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8C"],
        ["\x9E\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x97"],

        ["\xF3\xB1\x9A\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8D"],
        ["\x9E\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x98"],

        ["\xF3\xB1\x9A\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8E"],
        ["\x9E\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x99"],

        ["\xF3\xB1\x9A\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x8F"],
        ["\x9E\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9A"],

        ["\xF3\xB1\x9A\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x90"],
        ["\x9E\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9B"],

        ["\xF3\xB1\x9A\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x91"],
        ["\x9E\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9C"],

        ["\xF3\xB1\x9A\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x92"],
        ["\x9E\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9D"],

        ["\xF3\xB1\x9A\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x93"],
        ["\x9E\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9E"],

        ["\xF3\xB1\x9A\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x94"],
        ["\x9E\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9F"],

        ["\xF3\xB1\x9A\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x95"],
        ["\x9E\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA0"],

        ["\xF3\xB1\x9A\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x96"],
        ["\x9E\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA1"],

        ["\xF3\xB1\x9A\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x97"],
        ["\x9E\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA2"],

        ["\xF3\xB1\x9A\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x98"],
        ["\x9E\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA3"],

        ["\xF3\xB1\x9A\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x99"],
        ["\x9E\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA4"],

        ["\xF3\xB1\x9A\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9A"],
        ["\x9E\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA5"],

        ["\xF3\xB1\x9A\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9B"],
        ["\x9E\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA6"],

        ["\xF3\xB1\x9A\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9C"],
        ["\x9E\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA7"],

        ["\xF3\xB1\x9A\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9D"],
        ["\x9E\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA8"],

        ["\xF3\xB1\x9A\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9E"],
        ["\x9E\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA9"],

        ["\xF3\xB1\x9A\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x9F"],
        ["\x9E\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAA"],

        ["\xF3\xB1\x9A\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA0"],
        ["\x9E\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAB"],

        ["\xF3\xB1\x9A\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA1"],
        ["\x9E\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAC"],

        ["\xF3\xB1\x9A\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA2"],
        ["\x9E\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAD"],

        ["\xF3\xB1\x9A\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA3"],
        ["\x9E\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAE"],

        ["\xF3\xB1\x9A\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA4"],
        ["\x9E\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAF"],

        ["\xF3\xB1\x9A\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA5"],
        ["\x9E\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB0"],

        ["\xF3\xB1\x9A\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA6"],
        ["\x9E\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB1"],

        ["\xF3\xB1\x9A\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA7"],
        ["\x9E\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB2"],

        ["\xF3\xB1\x9A\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA8"],
        ["\x9E\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB3"],

        ["\xF3\xB1\x9A\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA9"],
        ["\x9E\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB4"],

        ["\xF3\xB1\x9A\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAA"],
        ["\x9E\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB5"],

        ["\xF3\xB1\x9A\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAB"],
        ["\x9E\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB6"],

        ["\xF3\xB1\x9A\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAC"],
        ["\x9E\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB7"],

        ["\xF3\xB1\x9A\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAD"],
        ["\x9E\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB8"],

        ["\xF3\xB1\x9A\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAE"],
        ["\x9E\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB9"],

        ["\xF3\xB1\x9A\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xAF"],
        ["\x9E\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBA"],

        ["\xF3\xB1\x9A\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB0"],
        ["\x9E\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBB"],

        ["\xF3\xB1\x9A\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB1"],
        ["\x9E\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBC"],

        ["\xF3\xB1\x9A\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB2"],
        ["\x9E\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBD"],

        ["\xF3\xB1\x9A\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB3"],
        ["\x9E\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBE"],

        ["\xF3\xB1\x9A\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB4"],
        ["\x9E\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBF"],

        ["\xF3\xB1\x9B\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB5"],
        ["\x9E\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x80"],

        ["\xF3\xB1\x9B\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB6"],
        ["\x9E\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x81"],

        ["\xF3\xB1\x9B\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB7"],
        ["\x9E\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x82"],

        ["\xF3\xB1\x9B\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB8"],
        ["\x9E\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x83"],

        ["\xF3\xB1\x9B\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB9"],
        ["\x9E\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x84"],

        ["\xF3\xB1\x9B\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBA"],
        ["\x9E\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x85"],

        ["\xF3\xB1\x9B\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBB"],
        ["\x9E\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x86"],

        ["\xF3\xB1\x9B\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBC"],
        ["\x9E\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x87"],

        ["\xF3\xB1\x9B\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBD"],
        ["\x9E\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x88"],

        ["\xF3\xB1\x9B\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBE"],
        ["\x9E\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x89"],

        ["\xF3\xB1\x9B\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xBF"],
        ["\x9E\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8A"],

        ["\xF3\xB1\x9B\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC0"],
        ["\x9E\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8B"],

        ["\xF3\xB1\x9B\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC1"],
        ["\x9E\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8C"],

        ["\xF3\xB1\x9B\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC2"],
        ["\x9E\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8D"],

        ["\xF3\xB1\x9B\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC3"],
        ["\x9E\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8E"],

        ["\xF3\xB1\x9B\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC4"],
        ["\x9E\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8F"],

        ["\xF3\xB1\x9B\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC5"],
        ["\x9E\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x90"],

        ["\xF3\xB1\x9B\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC6"],
        ["\x9E\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x91"],

        ["\xF3\xB1\x9B\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC7"],
        ["\x9E\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x92"],

        ["\xF3\xB1\x9B\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC8"],
        ["\x9E\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x93"],

        ["\xF3\xB1\x9B\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xC9"],
        ["\x9E\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x94"],

        ["\xF3\xB1\x9B\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCA"],
        ["\x9E\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x95"],

        ["\xF3\xB1\x9B\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCB"],
        ["\x9E\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x96"],

        ["\xF3\xB1\x9B\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCC"],
        ["\x9E\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x97"],

        ["\xF3\xB1\x9B\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCD"],
        ["\x9E\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x98"],

        ["\xF3\xB1\x9B\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCE"],
        ["\x9E\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x99"],

        ["\xF3\xB1\x9B\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xCF"],
        ["\x9E\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9A"],

        ["\xF3\xB1\x9B\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD0"],
        ["\x9E\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9B"],

        ["\xF3\xB1\x9B\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD1"],
        ["\x9E\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9C"],

        ["\xF3\xB1\x9B\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD2"],
        ["\x9E\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9D"],

        ["\xF3\xB1\x9B\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD3"],
        ["\x9E\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9E"],

        ["\xF3\xB1\x9B\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD4"],
        ["\x9E\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9F"],

        ["\xF3\xB1\x9B\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD5"],
        ["\x9E\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA0"],

        ["\xF3\xB1\x9B\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD6"],
        ["\x9E\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA1"],

        ["\xF3\xB1\x9B\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD7"],
        ["\x9E\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA2"],

        ["\xF3\xB1\x9B\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD8"],
        ["\x9E\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA3"],

        ["\xF3\xB1\x9B\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xD9"],
        ["\x9E\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA4"],

        ["\xF3\xB1\x9B\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDA"],
        ["\x9E\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA5"],

        ["\xF3\xB1\x9B\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDB"],
        ["\x9E\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA6"],

        ["\xF3\xB1\x9B\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDC"],
        ["\x9E\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA7"],

        ["\xF3\xB1\x9B\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDD"],
        ["\x9E\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA8"],

        ["\xF3\xB1\x9B\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDE"],
        ["\x9E\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA9"],

        ["\xF3\xB1\x9B\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xDF"],
        ["\x9E\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAA"],

        ["\xF3\xB1\x9B\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE0"],
        ["\x9E\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAB"],

        ["\xF3\xB1\x9B\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE1"],
        ["\x9E\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAC"],

        ["\xF3\xB1\x9B\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE2"],
        ["\x9E\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAD"],

        ["\xF3\xB1\x9B\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE3"],
        ["\x9E\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAE"],

        ["\xF3\xB1\x9B\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE4"],
        ["\x9E\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAF"],

        ["\xF3\xB1\x9B\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE5"],
        ["\x9E\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB0"],

        ["\xF3\xB1\x9B\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE6"],
        ["\x9E\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB1"],

        ["\xF3\xB1\x9B\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE7"],
        ["\x9E\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB2"],

        ["\xF3\xB1\x9B\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE8"],
        ["\x9E\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB3"],

        ["\xF3\xB1\x9B\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xE9"],
        ["\x9E\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB4"],

        ["\xF3\xB1\x9B\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEA"],
        ["\x9E\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB5"],

        ["\xF3\xB1\x9B\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEB"],
        ["\x9E\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB6"],

        ["\xF3\xB1\x9B\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEC"],
        ["\x9E\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB7"],

        ["\xF3\xB1\x9B\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xED"],
        ["\x9E\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB8"],

        ["\xF3\xB1\x9B\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEE"],
        ["\x9E\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB9"],

        ["\xF3\xB1\x9B\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEF"],
        ["\x9E\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBA"],

        ["\xF3\xB1\x9B\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF0"],
        ["\x9E\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBB"],

        ["\xF3\xB1\x9B\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF1"],
        ["\x9E\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBC"],

        ["\xF3\xB1\x9B\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF2"],
        ["\x9E\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBD"],

        ["\xF3\xB1\x9B\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF3"],
        ["\x9E\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBE"],

        ["\xF3\xB1\x9B\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF4"],
        ["\x9E\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBF"],

        ["\xF3\xB1\x9C\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF5"],
        ["\x9E\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x80"],

        ["\xF3\xB1\x9C\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF6"],
        ["\x9E\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x81"],

        ["\xF3\xB1\x9C\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF7"],
        ["\x9E\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x82"],

        ["\xF3\xB1\x9C\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF8"],
        ["\x9E\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x83"],

        ["\xF3\xB1\x9C\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xF9"],
        ["\x9E\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x84"],

        ["\xF3\xB1\x9C\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xFA"],
        ["\x9E\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x85"],

        ["\xF3\xB1\x9C\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xFB"],
        ["\x9E\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x86"],

        ["\xF3\xB1\x9C\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xFC"],
        ["\x9E\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x87"],

        ["\xF3\xB1\x9C\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x40"],
        ["\x9F\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x88"],

        ["\xF3\xB1\x9C\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x41"],
        ["\x9F\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x89"],

        ["\xF3\xB1\x9C\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x42"],
        ["\x9F\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8A"],

        ["\xF3\xB1\x9C\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x43"],
        ["\x9F\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8B"],

        ["\xF3\xB1\x9C\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x44"],
        ["\x9F\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8C"],

        ["\xF3\xB1\x9C\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x45"],
        ["\x9F\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8D"],

        ["\xF3\xB1\x9C\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x46"],
        ["\x9F\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8E"],

        ["\xF3\xB1\x9C\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x47"],
        ["\x9F\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8F"],

        ["\xF3\xB1\x9C\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x48"],
        ["\x9F\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x90"],

        ["\xF3\xB1\x9C\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x49"],
        ["\x9F\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x91"],

        ["\xF3\xB1\x9C\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4A"],
        ["\x9F\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x92"],

        ["\xF3\xB1\x9C\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4B"],
        ["\x9F\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x93"],

        ["\xF3\xB1\x9C\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4C"],
        ["\x9F\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x94"],

        ["\xF3\xB1\x9C\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4D"],
        ["\x9F\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x95"],

        ["\xF3\xB1\x9C\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4E"],
        ["\x9F\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x96"],

        ["\xF3\xB1\x9C\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x4F"],
        ["\x9F\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x97"],

        ["\xF3\xB1\x9C\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x50"],
        ["\x9F\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x98"],

        ["\xF3\xB1\x9C\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x51"],
        ["\x9F\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x99"],

        ["\xF3\xB1\x9C\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x52"],
        ["\x9F\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9A"],

        ["\xF3\xB1\x9C\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x53"],
        ["\x9F\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9B"],

        ["\xF3\xB1\x9C\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x54"],
        ["\x9F\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9C"],

        ["\xF3\xB1\x9C\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x55"],
        ["\x9F\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9D"],

        ["\xF3\xB1\x9C\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x56"],
        ["\x9F\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9E"],

        ["\xF3\xB1\x9C\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x57"],
        ["\x9F\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9F"],

        ["\xF3\xB1\x9C\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x58"],
        ["\x9F\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA0"],

        ["\xF3\xB1\x9C\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x59"],
        ["\x9F\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA1"],

        ["\xF3\xB1\x9C\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5A"],
        ["\x9F\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA2"],

        ["\xF3\xB1\x9C\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5B"],
        ["\x9F\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA3"],

        ["\xF3\xB1\x9C\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5C"],
        ["\x9F\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA4"],

        ["\xF3\xB1\x9C\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5D"],
        ["\x9F\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA5"],

        ["\xF3\xB1\x9C\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5E"],
        ["\x9F\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA6"],

        ["\xF3\xB1\x9C\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x5F"],
        ["\x9F\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA7"],

        ["\xF3\xB1\x9C\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x60"],
        ["\x9F\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA8"],

        ["\xF3\xB1\x9C\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x61"],
        ["\x9F\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA9"],

        ["\xF3\xB1\x9C\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x62"],
        ["\x9F\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAA"],

        ["\xF3\xB1\x9C\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x63"],
        ["\x9F\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAB"],

        ["\xF3\xB1\x9C\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x64"],
        ["\x9F\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAC"],

        ["\xF3\xB1\x9C\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x65"],
        ["\x9F\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAD"],

        ["\xF3\xB1\x9C\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x66"],
        ["\x9F\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAE"],

        ["\xF3\xB1\x9C\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x67"],
        ["\x9F\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAF"],

        ["\xF3\xB1\x9C\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x68"],
        ["\x9F\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB0"],

        ["\xF3\xB1\x9C\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x69"],
        ["\x9F\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB1"],

        ["\xF3\xB1\x9C\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6A"],
        ["\x9F\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB2"],

        ["\xF3\xB1\x9C\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6B"],
        ["\x9F\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB3"],

        ["\xF3\xB1\x9C\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6C"],
        ["\x9F\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB4"],

        ["\xF3\xB1\x9C\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6D"],
        ["\x9F\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB5"],

        ["\xF3\xB1\x9C\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6E"],
        ["\x9F\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB6"],

        ["\xF3\xB1\x9C\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x6F"],
        ["\x9F\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB7"],

        ["\xF3\xB1\x9C\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x70"],
        ["\x9F\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB8"],

        ["\xF3\xB1\x9C\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x71"],
        ["\x9F\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB9"],

        ["\xF3\xB1\x9C\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x72"],
        ["\x9F\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBA"],

        ["\xF3\xB1\x9C\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x73"],
        ["\x9F\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBB"],

        ["\xF3\xB1\x9C\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x74"],
        ["\x9F\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBC"],

        ["\xF3\xB1\x9C\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x75"],
        ["\x9F\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBD"],

        ["\xF3\xB1\x9C\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x76"],
        ["\x9F\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBE"],

        ["\xF3\xB1\x9C\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x77"],
        ["\x9F\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBF"],

        ["\xF3\xB1\x9D\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x78"],
        ["\x9F\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x80"],

        ["\xF3\xB1\x9D\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x79"],
        ["\x9F\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x81"],

        ["\xF3\xB1\x9D\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x7A"],
        ["\x9F\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x82"],

        ["\xF3\xB1\x9D\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x7B"],
        ["\x9F\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x83"],

        ["\xF3\xB1\x9D\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x7C"],
        ["\x9F\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x84"],

        ["\xF3\xB1\x9D\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x7D"],
        ["\x9F\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x85"],

        ["\xF3\xB1\x9D\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x7E"],
        ["\x9F\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x86"],

        ["\xF3\xB1\x9D\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x80"],
        ["\x9F\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x87"],

        ["\xF3\xB1\x9D\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x81"],
        ["\x9F\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x88"],

        ["\xF3\xB1\x9D\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x82"],
        ["\x9F\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x89"],

        ["\xF3\xB1\x9D\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x83"],
        ["\x9F\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8A"],

        ["\xF3\xB1\x9D\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x84"],
        ["\x9F\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8B"],

        ["\xF3\xB1\x9D\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x85"],
        ["\x9F\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8C"],

        ["\xF3\xB1\x9D\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x86"],
        ["\x9F\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8D"],

        ["\xF3\xB1\x9D\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x87"],
        ["\x9F\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8E"],

        ["\xF3\xB1\x9D\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x88"],
        ["\x9F\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8F"],

        ["\xF3\xB1\x9D\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x89"],
        ["\x9F\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x90"],

        ["\xF3\xB1\x9D\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8A"],
        ["\x9F\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x91"],

        ["\xF3\xB1\x9D\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8B"],
        ["\x9F\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x92"],

        ["\xF3\xB1\x9D\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8C"],
        ["\x9F\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x93"],

        ["\xF3\xB1\x9D\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8D"],
        ["\x9F\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x94"],

        ["\xF3\xB1\x9D\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8E"],
        ["\x9F\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x95"],

        ["\xF3\xB1\x9D\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x8F"],
        ["\x9F\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x96"],

        ["\xF3\xB1\x9D\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x90"],
        ["\x9F\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x97"],

        ["\xF3\xB1\x9D\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x91"],
        ["\x9F\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x98"],

        ["\xF3\xB1\x9D\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x92"],
        ["\x9F\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x99"],

        ["\xF3\xB1\x9D\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x93"],
        ["\x9F\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9A"],

        ["\xF3\xB1\x9D\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x94"],
        ["\x9F\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9B"],

        ["\xF3\xB1\x9D\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x95"],
        ["\x9F\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9C"],

        ["\xF3\xB1\x9D\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x96"],
        ["\x9F\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9D"],

        ["\xF3\xB1\x9D\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x97"],
        ["\x9F\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9E"],

        ["\xF3\xB1\x9D\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x98"],
        ["\x9F\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9F"],

        ["\xF3\xB1\x9D\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x99"],
        ["\x9F\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA0"],

        ["\xF3\xB1\x9D\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9A"],
        ["\x9F\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA1"],

        ["\xF3\xB1\x9D\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9B"],
        ["\x9F\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA2"],

        ["\xF3\xB1\x9D\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9C"],
        ["\x9F\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA3"],

        ["\xF3\xB1\x9D\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9D"],
        ["\x9F\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA4"],

        ["\xF3\xB1\x9D\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9E"],
        ["\x9F\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA5"],

        ["\xF3\xB1\x9D\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9F"],
        ["\x9F\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA6"],

        ["\xF3\xB1\x9D\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA0"],
        ["\x9F\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA7"],

        ["\xF3\xB1\x9D\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"],
        ["\x9F\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA8"],

        ["\xF3\xB1\x9D\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA2"],
        ["\x9F\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA9"],

        ["\xF3\xB1\x9D\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"],
        ["\x9F\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAA"],

        ["\xF3\xB1\x9D\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA4"],
        ["\x9F\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAB"],

        ["\xF3\xB1\x9D\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA5"],
        ["\x9F\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAC"],

        ["\xF3\xB1\x9D\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"],
        ["\x9F\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAD"],

        ["\xF3\xB1\x9D\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA7"],
        ["\x9F\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAE"],

        ["\xF3\xB1\x9D\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA8"],
        ["\x9F\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAF"],

        ["\xF3\xB1\x9D\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"],
        ["\x9F\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB0"],

        ["\xF3\xB1\x9D\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAA"],
        ["\x9F\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB1"],

        ["\xF3\xB1\x9D\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAB"],
        ["\x9F\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB2"],

        ["\xF3\xB1\x9D\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"],
        ["\x9F\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB3"],

        ["\xF3\xB1\x9D\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAD"],
        ["\x9F\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB4"],

        ["\xF3\xB1\x9D\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAE"],
        ["\x9F\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB5"],

        ["\xF3\xB1\x9D\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\x9F\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB6"],

        ["\xF3\xB1\x9D\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB0"],
        ["\x9F\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB7"],

        ["\xF3\xB1\x9D\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB1"],
        ["\x9F\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB8"],

        ["\xF3\xB1\x9D\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB2"],
        ["\x9F\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB9"],

        ["\xF3\xB1\x9D\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB3"],
        ["\x9F\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBA"],

        ["\xF3\xB1\x9D\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB4"],
        ["\x9F\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBB"],

        ["\xF3\xB1\x9D\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB5"],
        ["\x9F\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBC"],

        ["\xF3\xB1\x9D\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"],
        ["\x9F\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBD"],

        ["\xF3\xB1\x9D\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB7"],
        ["\x9F\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBE"],

        ["\xF3\xB1\x9D\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB8"],
        ["\x9F\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBF"],

        ["\xF3\xB1\x9E\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"],
        ["\x9F\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x80"],

        ["\xF3\xB1\x9E\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"],
        ["\x9F\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x81"],

        ["\xF3\xB1\x9E\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBB"],
        ["\x9F\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x82"],

        ["\xF3\xB1\x9E\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBC"],
        ["\x9F\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x83"],

        ["\xF3\xB1\x9E\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBD"],
        ["\x9F\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x84"],

        ["\xF3\xB1\x9E\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBE"],
        ["\x9F\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x85"],

        ["\xF3\xB1\x9E\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xBF"],
        ["\x9F\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x86"],

        ["\xF3\xB1\x9E\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC0"],
        ["\x9F\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x87"],

        ["\xF3\xB1\x9E\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC1"],
        ["\x9F\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x88"],

        ["\xF3\xB1\x9E\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC2"],
        ["\x9F\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x89"],

        ["\xF3\xB1\x9E\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC3"],
        ["\x9F\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8A"],

        ["\xF3\xB1\x9E\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC4"],
        ["\x9F\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8B"],

        ["\xF3\xB1\x9E\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC5"],
        ["\x9F\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8C"],

        ["\xF3\xB1\x9E\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC6"],
        ["\x9F\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8D"],

        ["\xF3\xB1\x9E\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC7"],
        ["\x9F\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8E"],

        ["\xF3\xB1\x9E\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC8"],
        ["\x9F\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8F"],

        ["\xF3\xB1\x9E\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xC9"],
        ["\x9F\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x90"],

        ["\xF3\xB1\x9E\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"],
        ["\x9F\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x91"],

        ["\xF3\xB1\x9E\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\x9F\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x92"],

        ["\xF3\xB1\x9E\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\x9F\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x93"],

        ["\xF3\xB1\x9E\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"],
        ["\x9F\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x94"],

        ["\xF3\xB1\x9E\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"],
        ["\x9F\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x95"],

        ["\xF3\xB1\x9E\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\x9F\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x96"],

        ["\xF3\xB1\x9E\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD0"],
        ["\x9F\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x97"],

        ["\xF3\xB1\x9E\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD1"],
        ["\x9F\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x98"],

        ["\xF3\xB1\x9E\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"],
        ["\x9F\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x99"],

        ["\xF3\xB1\x9E\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"],
        ["\x9F\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9A"],

        ["\xF3\xB1\x9E\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD4"],
        ["\x9F\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9B"],

        ["\xF3\xB1\x9E\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD5"],
        ["\x9F\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9C"],

        ["\xF3\xB1\x9E\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD6"],
        ["\x9F\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9D"],

        ["\xF3\xB1\x9E\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD7"],
        ["\x9F\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9E"],

        ["\xF3\xB1\x9E\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"],
        ["\x9F\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9F"],

        ["\xF3\xB1\x9E\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xD9"],
        ["\x9F\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA0"],

        ["\xF3\xB1\x9E\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDA"],
        ["\x9F\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA1"],

        ["\xF3\xB1\x9E\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDB"],
        ["\x9F\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA2"],

        ["\xF3\xB1\x9E\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDC"],
        ["\x9F\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA3"],

        ["\xF3\xB1\x9E\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDD"],
        ["\x9F\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA4"],

        ["\xF3\xB1\x9E\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDE"],
        ["\x9F\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA5"],

        ["\xF3\xB1\x9E\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDF"],
        ["\x9F\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA6"],

        ["\xF3\xB1\x9E\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE0"],
        ["\x9F\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA7"],

        ["\xF3\xB1\x9E\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE1"],
        ["\x9F\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA8"],

        ["\xF3\xB1\x9E\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE2"],
        ["\x9F\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA9"],

        ["\xF3\xB1\x9E\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE3"],
        ["\x9F\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAA"],

        ["\xF3\xB1\x9E\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE4"],
        ["\x9F\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAB"],

        ["\xF3\xB1\x9E\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE5"],
        ["\x9F\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAC"],

        ["\xF3\xB1\x9E\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE6"],
        ["\x9F\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAD"],

        ["\xF3\xB1\x9E\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE7"],
        ["\x9F\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAE"],

        ["\xF3\xB1\x9E\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE8"],
        ["\x9F\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAF"],

        ["\xF3\xB1\x9E\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xE9"],
        ["\x9F\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB0"],

        ["\xF3\xB1\x9E\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xEA"],
        ["\x9F\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB1"],

        ["\xF3\xB1\x9E\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xEB"],
        ["\x9F\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB2"],

        ["\xF3\xB1\x9E\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xEC"],
        ["\x9F\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB3"],

        ["\xF3\xB1\x9E\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xED"],
        ["\x9F\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB4"],

        ["\xF3\xB1\x9E\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xEE"],
        ["\x9F\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB5"],

        ["\xF3\xB1\x9E\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xEF"],
        ["\x9F\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB6"],

        ["\xF3\xB1\x9E\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF0"],
        ["\x9F\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB7"],

        ["\xF3\xB1\x9E\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF1"],
        ["\x9F\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB8"],

        ["\xF3\xB1\x9E\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF2"],
        ["\x9F\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB9"],

        ["\xF3\xB1\x9E\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF3"],
        ["\x9F\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBA"],

        ["\xF3\xB1\x9E\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF4"],
        ["\x9F\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBB"],

        ["\xF3\xB1\x9E\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF5"],
        ["\x9F\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBC"],

        ["\xF3\xB1\x9E\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF6"],
        ["\x9F\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBD"],

        ["\xF3\xB1\x9E\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF7"],
        ["\x9F\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBE"],

        ["\xF3\xB1\x9E\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF8"],
        ["\x9F\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBF"],

        ["\xF3\xB1\x9F\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xF9"],
        ["\x9F\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x80"],

        ["\xF3\xB1\x9F\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xFA"],
        ["\x9F\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x81"],

        ["\xF3\xB1\x9F\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xFB"],
        ["\x9F\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x82"],

        ["\xF3\xB1\x9F\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xFC"],
        ["\x9F\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x83"],

        ["\xF3\xB1\x9F\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x40"],
        ["\xE0\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x84"],

        ["\xF3\xB1\x9F\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x41"],
        ["\xE0\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x85"],

        ["\xF3\xB1\x9F\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x42"],
        ["\xE0\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x86"],

        ["\xF3\xB1\x9F\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x43"],
        ["\xE0\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x87"],

        ["\xF3\xB1\x9F\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x44"],
        ["\xE0\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x88"],

        ["\xF3\xB1\x9F\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x45"],
        ["\xE0\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x89"],

        ["\xF3\xB1\x9F\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x46"],
        ["\xE0\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8A"],

        ["\xF3\xB1\x9F\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x47"],
        ["\xE0\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8B"],

        ["\xF3\xB1\x9F\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x48"],
        ["\xE0\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8C"],

        ["\xF3\xB1\x9F\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x49"],
        ["\xE0\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8D"],

        ["\xF3\xB1\x9F\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],
        ["\xE0\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8E"],

        ["\xF3\xB1\x9F\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],
        ["\xE0\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8F"],

        ["\xF3\xB1\x9F\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],
        ["\xE0\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x90"],

        ["\xF3\xB1\x9F\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],
        ["\xE0\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x91"],

        ["\xF3\xB1\x9F\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],
        ["\xE0\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x92"],

        ["\xF3\xB1\x9F\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],
        ["\xE0\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x93"],

        ["\xF3\xB1\x9F\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],
        ["\xE0\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x94"],

        ["\xF3\xB1\x9F\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x51"],
        ["\xE0\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x95"],

        ["\xF3\xB1\x9F\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x52"],
        ["\xE0\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x96"],

        ["\xF3\xB1\x9F\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x53"],
        ["\xE0\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x97"],

        ["\xF3\xB1\x9F\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x54"],
        ["\xE0\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x98"],

        ["\xF3\xB1\x9F\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x55"],
        ["\xE0\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x99"],

        ["\xF3\xB1\x9F\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x56"],
        ["\xE0\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9A"],

        ["\xF3\xB1\x9F\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],
        ["\xE0\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9B"],

        ["\xF3\xB1\x9F\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x58"],
        ["\xE0\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9C"],

        ["\xF3\xB1\x9F\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\xE0\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9D"],

        ["\xF3\xB1\x9F\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],
        ["\xE0\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9E"],

        ["\xF3\xB1\x9F\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],
        ["\xE0\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9F"],

        ["\xF3\xB1\x9F\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],
        ["\xE0\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA0"],

        ["\xF3\xB1\x9F\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],
        ["\xE0\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA1"],

        ["\xF3\xB1\x9F\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],
        ["\xE0\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA2"],

        ["\xF3\xB1\x9F\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],
        ["\xE0\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA3"],

        ["\xF3\xB1\x9F\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],
        ["\xE0\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA4"],

        ["\xF3\xB1\x9F\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],
        ["\xE0\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA5"],

        ["\xF3\xB1\x9F\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],
        ["\xE0\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA6"],

        ["\xF3\xB1\x9F\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\xE0\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA7"],

        ["\xF3\xB1\x9F\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],
        ["\xE0\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA8"],

        ["\xF3\xB1\x9F\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],
        ["\xE0\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA9"],

        ["\xF3\xB1\x9F\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],
        ["\xE0\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAA"],

        ["\xF3\xB1\x9F\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],
        ["\xE0\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAB"],

        ["\xF3\xB1\x9F\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\xE0\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAC"],

        ["\xF3\xB1\x9F\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\xE0\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAD"],

        ["\xF3\xB1\x9F\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6A"],
        ["\xE0\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAE"],

        ["\xF3\xB1\x9F\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],
        ["\xE0\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAF"],

        ["\xF3\xB1\x9F\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],
        ["\xE0\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB0"],

        ["\xF3\xB1\x9F\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],
        ["\xE0\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB1"],

        ["\xF3\xB1\x9F\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\xE0\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB2"],

        ["\xF3\xB1\x9F\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],
        ["\xE0\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB3"],

        ["\xF3\xB1\x9F\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],
        ["\xE0\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB4"],

        ["\xF3\xB1\x9F\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],
        ["\xE0\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB5"],

        ["\xF3\xB1\x9F\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],
        ["\xE0\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB6"],

        ["\xF3\xB1\x9F\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],
        ["\xE0\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB7"],

        ["\xF3\xB1\x9F\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\xE0\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB8"],

        ["\xF3\xB1\x9F\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\xE0\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB9"],

        ["\xF3\xB1\x9F\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\xE0\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBA"],

        ["\xF3\xB1\x9F\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],
        ["\xE0\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBB"],

        ["\xF3\xB1\x9F\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\xE0\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBC"],

        ["\xF3\xB1\x9F\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\xE0\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBD"],

        ["\xF3\xB1\x9F\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],
        ["\xE0\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBE"],

        ["\xF3\xB1\x9F\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],
        ["\xE0\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBF"],

        ["\xF3\xB1\xA0\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],
        ["\xE0\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x80"],

        ["\xF3\xB1\xA0\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],
        ["\xE0\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x81"],

        ["\xF3\xB1\xA0\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],
        ["\xE0\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x82"],

        ["\xF3\xB1\xA0\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x80"],
        ["\xE0\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x83"],

        ["\xF3\xB1\xA0\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x81"],
        ["\xE0\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x84"],

        ["\xF3\xB1\xA0\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x82"],
        ["\xE0\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x85"],

        ["\xF3\xB1\xA0\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x83"],
        ["\xE0\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x86"],

        ["\xF3\xB1\xA0\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x84"],
        ["\xE0\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x87"],

        ["\xF3\xB1\xA0\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x85"],
        ["\xE0\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x88"],

        ["\xF3\xB1\xA0\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x86"],
        ["\xE0\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x89"],

        ["\xF3\xB1\xA0\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x87"],
        ["\xE0\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8A"],

        ["\xF3\xB1\xA0\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x88"],
        ["\xE0\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8B"],

        ["\xF3\xB1\xA0\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x89"],
        ["\xE0\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8C"],

        ["\xF3\xB1\xA0\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8A"],
        ["\xE0\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8D"],

        ["\xF3\xB1\xA0\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8B"],
        ["\xE0\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8E"],

        ["\xF3\xB1\xA0\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8C"],
        ["\xE0\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8F"],

        ["\xF3\xB1\xA0\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8D"],
        ["\xE0\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x90"],

        ["\xF3\xB1\xA0\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8E"],
        ["\xE0\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x91"],

        ["\xF3\xB1\xA0\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x8F"],
        ["\xE0\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x92"],

        ["\xF3\xB1\xA0\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x90"],
        ["\xE0\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x93"],

        ["\xF3\xB1\xA0\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x91"],
        ["\xE0\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x94"],

        ["\xF3\xB1\xA0\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x92"],
        ["\xE0\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x95"],

        ["\xF3\xB1\xA0\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x93"],
        ["\xE0\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x96"],

        ["\xF3\xB1\xA0\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x94"],
        ["\xE0\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x97"],

        ["\xF3\xB1\xA0\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x95"],
        ["\xE0\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x98"],

        ["\xF3\xB1\xA0\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x96"],
        ["\xE0\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x99"],

        ["\xF3\xB1\xA0\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x97"],
        ["\xE0\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9A"],

        ["\xF3\xB1\xA0\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x98"],
        ["\xE0\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9B"],

        ["\xF3\xB1\xA0\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x99"],
        ["\xE0\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9C"],

        ["\xF3\xB1\xA0\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9A"],
        ["\xE0\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9D"],

        ["\xF3\xB1\xA0\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9B"],
        ["\xE0\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9E"],

        ["\xF3\xB1\xA0\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9C"],
        ["\xE0\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9F"],

        ["\xF3\xB1\xA0\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9D"],
        ["\xE0\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA0"],

        ["\xF3\xB1\xA0\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9E"],
        ["\xE0\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA1"],

        ["\xF3\xB1\xA0\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x9F"],
        ["\xE0\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA2"],

        ["\xF3\xB1\xA0\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA0"],
        ["\xE0\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA3"],

        ["\xF3\xB1\xA0\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xE0\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA4"],

        ["\xF3\xB1\xA0\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xE0\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA5"],

        ["\xF3\xB1\xA0\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xE0\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA6"],

        ["\xF3\xB1\xA0\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xE0\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA7"],

        ["\xF3\xB1\xA0\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xE0\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA8"],

        ["\xF3\xB1\xA0\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xE0\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA9"],

        ["\xF3\xB1\xA0\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xE0\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAA"],

        ["\xF3\xB1\xA0\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xE0\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAB"],

        ["\xF3\xB1\xA0\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xE0\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAC"],

        ["\xF3\xB1\xA0\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xE0\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAD"],

        ["\xF3\xB1\xA0\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xE0\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAE"],

        ["\xF3\xB1\xA0\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE0\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAF"],

        ["\xF3\xB1\xA0\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xE0\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB0"],

        ["\xF3\xB1\xA0\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xE0\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB1"],

        ["\xF3\xB1\xA0\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xE0\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB2"],

        ["\xF3\xB1\xA0\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xE0\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB3"],

        ["\xF3\xB1\xA0\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xE0\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB4"],

        ["\xF3\xB1\xA0\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xE0\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB5"],

        ["\xF3\xB1\xA0\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xE0\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB6"],

        ["\xF3\xB1\xA0\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xE0\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB7"],

        ["\xF3\xB1\xA0\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xE0\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB8"],

        ["\xF3\xB1\xA0\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xE0\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB9"],

        ["\xF3\xB1\xA0\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xE0\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBA"],

        ["\xF3\xB1\xA0\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xE0\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBB"],

        ["\xF3\xB1\xA0\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xE0\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBC"],

        ["\xF3\xB1\xA0\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xE0\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBD"],

        ["\xF3\xB1\xA0\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xE0\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBE"],

        ["\xF3\xB1\xA0\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xE0\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBF"],

        ["\xF3\xB1\xA1\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xE0\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x80"],

        ["\xF3\xB1\xA1\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xE0\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x81"],

        ["\xF3\xB1\xA1\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xE0\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x82"],

        ["\xF3\xB1\xA1\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xE0\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x83"],

        ["\xF3\xB1\xA1\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE0\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x84"],

        ["\xF3\xB1\xA1\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE0\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x85"],

        ["\xF3\xB1\xA1\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE0\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x86"],

        ["\xF3\xB1\xA1\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE0\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x87"],

        ["\xF3\xB1\xA1\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE0\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x88"],

        ["\xF3\xB1\xA1\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE0\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x89"],

        ["\xF3\xB1\xA1\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE0\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8A"],

        ["\xF3\xB1\xA1\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE0\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8B"],

        ["\xF3\xB1\xA1\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE0\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8C"],

        ["\xF3\xB1\xA1\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xE0\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8D"],

        ["\xF3\xB1\xA1\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xE0\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8E"],

        ["\xF3\xB1\xA1\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xE0\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8F"],

        ["\xF3\xB1\xA1\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xE0\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x90"],

        ["\xF3\xB1\xA1\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xE0\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x91"],

        ["\xF3\xB1\xA1\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xE0\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x92"],

        ["\xF3\xB1\xA1\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xE0\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x93"],

        ["\xF3\xB1\xA1\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE0\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x94"],

        ["\xF3\xB1\xA1\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE0\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x95"],

        ["\xF3\xB1\xA1\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE0\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x96"],

        ["\xF3\xB1\xA1\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE0\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x97"],

        ["\xF3\xB1\xA1\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE0\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x98"],

        ["\xF3\xB1\xA1\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE0\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x99"],

        ["\xF3\xB1\xA1\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE0\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9A"],

        ["\xF3\xB1\xA1\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE0\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9B"],

        ["\xF3\xB1\xA1\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE0\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9C"],

        ["\xF3\xB1\xA1\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xE0\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9D"],

        ["\xF3\xB1\xA1\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xE0\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9E"],

        ["\xF3\xB1\xA1\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xE0\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9F"],

        ["\xF3\xB1\xA1\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xE0\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA0"],

        ["\xF3\xB1\xA1\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xE0\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA1"],

        ["\xF3\xB1\xA1\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xE0\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA2"],

        ["\xF3\xB1\xA1\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE0\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA3"],

        ["\xF3\xB1\xA1\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xE0\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA4"],

        ["\xF3\xB1\xA1\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE0\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA5"],

        ["\xF3\xB1\xA1\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE0\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA6"],

        ["\xF3\xB1\xA1\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE0\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA7"],

        ["\xF3\xB1\xA1\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE0\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA8"],

        ["\xF3\xB1\xA1\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE0\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA9"],

        ["\xF3\xB1\xA1\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE0\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAA"],

        ["\xF3\xB1\xA1\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE0\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAB"],

        ["\xF3\xB1\xA1\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE0\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAC"],

        ["\xF3\xB1\xA1\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xE0\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAD"],

        ["\xF3\xB1\xA1\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xE0\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAE"],

        ["\xF3\xB1\xA1\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xE0\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAF"],

        ["\xF3\xB1\xA1\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xE0\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB0"],

        ["\xF3\xB1\xA1\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE0\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB1"],

        ["\xF3\xB1\xA1\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE0\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB2"],

        ["\xF3\xB1\xA1\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE0\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB3"],

        ["\xF3\xB1\xA1\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE0\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB4"],

        ["\xF3\xB1\xA1\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE0\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB5"],

        ["\xF3\xB1\xA1\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xE0\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB6"],

        ["\xF3\xB1\xA1\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE0\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB7"],

        ["\xF3\xB1\xA1\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE0\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB8"],

        ["\xF3\xB1\xA1\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE0\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB9"],

        ["\xF3\xB1\xA1\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE0\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBA"],

        ["\xF3\xB1\xA1\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE0\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBB"],

        ["\xF3\xB1\xA1\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE0\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBC"],

        ["\xF3\xB1\xA1\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE0\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBD"],

        ["\xF3\xB1\xA1\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE0\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBE"],

        ["\xF3\xB1\xA1\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE0\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBF"],

        ["\xF3\xB1\xA2\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x40"],
        ["\xE1\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x80"],

        ["\xF3\xB1\xA2\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x41"],
        ["\xE1\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x81"],

        ["\xF3\xB1\xA2\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x42"],
        ["\xE1\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x82"],

        ["\xF3\xB1\xA2\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\xE1\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x83"],

        ["\xF3\xB1\xA2\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\xE1\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x84"],

        ["\xF3\xB1\xA2\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\xE1\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x85"],

        ["\xF3\xB1\xA2\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x46"],
        ["\xE1\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x86"],

        ["\xF3\xB1\xA2\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x47"],
        ["\xE1\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x87"],

        ["\xF3\xB1\xA2\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x48"],
        ["\xE1\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x88"],

        ["\xF3\xB1\xA2\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x49"],
        ["\xE1\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x89"],

        ["\xF3\xB1\xA2\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4A"],
        ["\xE1\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8A"],

        ["\xF3\xB1\xA2\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4B"],
        ["\xE1\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8B"],

        ["\xF3\xB1\xA2\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4C"],
        ["\xE1\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8C"],

        ["\xF3\xB1\xA2\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4D"],
        ["\xE1\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8D"],

        ["\xF3\xB1\xA2\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4E"],
        ["\xE1\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8E"],

        ["\xF3\xB1\xA2\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x4F"],
        ["\xE1\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8F"],

        ["\xF3\xB1\xA2\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x50"],
        ["\xE1\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x90"],

        ["\xF3\xB1\xA2\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x51"],
        ["\xE1\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x91"],

        ["\xF3\xB1\xA2\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x52"],
        ["\xE1\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x92"],

        ["\xF3\xB1\xA2\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x53"],
        ["\xE1\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x93"],

        ["\xF3\xB1\xA2\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x54"],
        ["\xE1\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x94"],

        ["\xF3\xB1\xA2\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x55"],
        ["\xE1\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x95"],

        ["\xF3\xB1\xA2\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x56"],
        ["\xE1\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x96"],

        ["\xF3\xB1\xA2\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x57"],
        ["\xE1\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x97"],

        ["\xF3\xB1\xA2\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x58"],
        ["\xE1\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x98"],

        ["\xF3\xB1\xA2\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x59"],
        ["\xE1\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x99"],

        ["\xF3\xB1\xA2\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5A"],
        ["\xE1\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9A"],

        ["\xF3\xB1\xA2\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5B"],
        ["\xE1\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9B"],

        ["\xF3\xB1\xA2\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5C"],
        ["\xE1\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9C"],

        ["\xF3\xB1\xA2\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5D"],
        ["\xE1\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9D"],

        ["\xF3\xB1\xA2\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5E"],
        ["\xE1\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9E"],

        ["\xF3\xB1\xA2\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x5F"],
        ["\xE1\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9F"],

        ["\xF3\xB1\xA2\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x60"],
        ["\xE1\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA0"],

        ["\xF3\xB1\xA2\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x61"],
        ["\xE1\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA1"],

        ["\xF3\xB1\xA2\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x62"],
        ["\xE1\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA2"],

        ["\xF3\xB1\xA2\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x63"],
        ["\xE1\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA3"],

        ["\xF3\xB1\xA2\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x64"],
        ["\xE1\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA4"],

        ["\xF3\xB1\xA2\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x65"],
        ["\xE1\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA5"],

        ["\xF3\xB1\xA2\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x66"],
        ["\xE1\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA6"],

        ["\xF3\xB1\xA2\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x67"],
        ["\xE1\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA7"],

        ["\xF3\xB1\xA2\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x68"],
        ["\xE1\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA8"],

        ["\xF3\xB1\xA2\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x69"],
        ["\xE1\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA9"],

        ["\xF3\xB1\xA2\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6A"],
        ["\xE1\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAA"],

        ["\xF3\xB1\xA2\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6B"],
        ["\xE1\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAB"],

        ["\xF3\xB1\xA2\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6C"],
        ["\xE1\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAC"],

        ["\xF3\xB1\xA2\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6D"],
        ["\xE1\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAD"],

        ["\xF3\xB1\xA2\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6E"],
        ["\xE1\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAE"],

        ["\xF3\xB1\xA2\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x6F"],
        ["\xE1\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAF"],

        ["\xF3\xB1\xA2\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x70"],
        ["\xE1\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB0"],

        ["\xF3\xB1\xA2\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x71"],
        ["\xE1\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB1"],

        ["\xF3\xB1\xA2\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x72"],
        ["\xE1\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB2"],

        ["\xF3\xB1\xA2\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x73"],
        ["\xE1\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB3"],

        ["\xF3\xB1\xA2\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x74"],
        ["\xE1\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB4"],

        ["\xF3\xB1\xA2\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x75"],
        ["\xE1\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB5"],

        ["\xF3\xB1\xA2\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x76"],
        ["\xE1\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB6"],

        ["\xF3\xB1\xA2\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x77"],
        ["\xE1\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB7"],

        ["\xF3\xB1\xA2\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x78"],
        ["\xE1\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB8"],

        ["\xF3\xB1\xA2\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x79"],
        ["\xE1\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB9"],

        ["\xF3\xB1\xA2\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x7A"],
        ["\xE1\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBA"],

        ["\xF3\xB1\xA2\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x7B"],
        ["\xE1\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBB"],

        ["\xF3\xB1\xA2\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x7C"],
        ["\xE1\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBC"],

        ["\xF3\xB1\xA2\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x7D"],
        ["\xE1\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBD"],

        ["\xF3\xB1\xA2\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x7E"],
        ["\xE1\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBE"],

        ["\xF3\xB1\xA2\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x80"],
        ["\xE1\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBF"],

        ["\xF3\xB1\xA3\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x81"],
        ["\xE1\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x80"],

        ["\xF3\xB1\xA3\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x82"],
        ["\xE1\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x81"],

        ["\xF3\xB1\xA3\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x83"],
        ["\xE1\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x82"],

        ["\xF3\xB1\xA3\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x84"],
        ["\xE1\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x83"],

        ["\xF3\xB1\xA3\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x85"],
        ["\xE1\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x84"],

        ["\xF3\xB1\xA3\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x86"],
        ["\xE1\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x85"],

        ["\xF3\xB1\xA3\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x87"],
        ["\xE1\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x86"],

        ["\xF3\xB1\xA3\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x88"],
        ["\xE1\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x87"],

        ["\xF3\xB1\xA3\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x89"],
        ["\xE1\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x88"],

        ["\xF3\xB1\xA3\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8A"],
        ["\xE1\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x89"],

        ["\xF3\xB1\xA3\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8B"],
        ["\xE1\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8A"],

        ["\xF3\xB1\xA3\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8C"],
        ["\xE1\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8B"],

        ["\xF3\xB1\xA3\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8D"],
        ["\xE1\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8C"],

        ["\xF3\xB1\xA3\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8E"],
        ["\xE1\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8D"],

        ["\xF3\xB1\xA3\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x8F"],
        ["\xE1\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8E"],

        ["\xF3\xB1\xA3\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x90"],
        ["\xE1\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8F"],

        ["\xF3\xB1\xA3\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x91"],
        ["\xE1\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x90"],

        ["\xF3\xB1\xA3\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x92"],
        ["\xE1\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x91"],

        ["\xF3\xB1\xA3\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x93"],
        ["\xE1\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x92"],

        ["\xF3\xB1\xA3\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x94"],
        ["\xE1\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x93"],

        ["\xF3\xB1\xA3\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x95"],
        ["\xE1\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x94"],

        ["\xF3\xB1\xA3\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x96"],
        ["\xE1\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x95"],

        ["\xF3\xB1\xA3\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x97"],
        ["\xE1\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x96"],

        ["\xF3\xB1\xA3\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x98"],
        ["\xE1\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x97"],

        ["\xF3\xB1\xA3\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x99"],
        ["\xE1\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x98"],

        ["\xF3\xB1\xA3\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9A"],
        ["\xE1\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x99"],

        ["\xF3\xB1\xA3\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9B"],
        ["\xE1\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9A"],

        ["\xF3\xB1\xA3\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9C"],
        ["\xE1\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9B"],

        ["\xF3\xB1\xA3\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9D"],
        ["\xE1\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9C"],

        ["\xF3\xB1\xA3\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9E"],
        ["\xE1\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9D"],

        ["\xF3\xB1\xA3\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\x9F"],
        ["\xE1\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9E"],

        ["\xF3\xB1\xA3\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA0"],
        ["\xE1\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9F"],

        ["\xF3\xB1\xA3\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xE1\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA0"],

        ["\xF3\xB1\xA3\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xE1\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA1"],

        ["\xF3\xB1\xA3\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xE1\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA2"],

        ["\xF3\xB1\xA3\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xE1\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA3"],

        ["\xF3\xB1\xA3\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xE1\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA4"],

        ["\xF3\xB1\xA3\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xE1\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA5"],

        ["\xF3\xB1\xA3\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xE1\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA6"],

        ["\xF3\xB1\xA3\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xE1\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA7"],

        ["\xF3\xB1\xA3\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xE1\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA8"],

        ["\xF3\xB1\xA3\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xE1\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA9"],

        ["\xF3\xB1\xA3\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xE1\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAA"],

        ["\xF3\xB1\xA3\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xE1\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAB"],

        ["\xF3\xB1\xA3\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xE1\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAC"],

        ["\xF3\xB1\xA3\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xE1\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAD"],

        ["\xF3\xB1\xA3\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xE1\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAE"],

        ["\xF3\xB1\xA3\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xE1\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAF"],

        ["\xF3\xB1\xA3\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xE1\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB0"],

        ["\xF3\xB1\xA3\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xE1\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB1"],

        ["\xF3\xB1\xA3\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xE1\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB2"],

        ["\xF3\xB1\xA3\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xE1\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB3"],

        ["\xF3\xB1\xA3\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xE1\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB4"],

        ["\xF3\xB1\xA3\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xE1\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB5"],

        ["\xF3\xB1\xA3\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xE1\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB6"],

        ["\xF3\xB1\xA3\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xE1\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB7"],

        ["\xF3\xB1\xA3\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xE1\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB8"],

        ["\xF3\xB1\xA3\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xE1\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB9"],

        ["\xF3\xB1\xA3\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xE1\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBA"],

        ["\xF3\xB1\xA3\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xE1\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBB"],

        ["\xF3\xB1\xA3\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xE1\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBC"],

        ["\xF3\xB1\xA3\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xE1\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBD"],

        ["\xF3\xB1\xA3\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xE1\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBE"],

        ["\xF3\xB1\xA3\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xE1\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBF"],

        ["\xF3\xB1\xA4\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xE1\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x80"],

        ["\xF3\xB1\xA4\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xE1\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x81"],

        ["\xF3\xB1\xA4\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xE1\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x82"],

        ["\xF3\xB1\xA4\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xE1\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x83"],

        ["\xF3\xB1\xA4\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xE1\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x84"],

        ["\xF3\xB1\xA4\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xE1\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x85"],

        ["\xF3\xB1\xA4\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xE1\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x86"],

        ["\xF3\xB1\xA4\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xE1\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x87"],

        ["\xF3\xB1\xA4\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xE1\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x88"],

        ["\xF3\xB1\xA4\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xE1\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x89"],

        ["\xF3\xB1\xA4\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xE1\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8A"],

        ["\xF3\xB1\xA4\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xE1\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8B"],

        ["\xF3\xB1\xA4\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xE1\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8C"],

        ["\xF3\xB1\xA4\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xE1\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8D"],

        ["\xF3\xB1\xA4\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xE1\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8E"],

        ["\xF3\xB1\xA4\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xE1\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8F"],

        ["\xF3\xB1\xA4\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xE1\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x90"],

        ["\xF3\xB1\xA4\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xE1\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x91"],

        ["\xF3\xB1\xA4\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xE1\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x92"],

        ["\xF3\xB1\xA4\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xE1\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x93"],

        ["\xF3\xB1\xA4\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xE1\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x94"],

        ["\xF3\xB1\xA4\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xE1\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x95"],

        ["\xF3\xB1\xA4\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xE1\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x96"],

        ["\xF3\xB1\xA4\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xE1\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x97"],

        ["\xF3\xB1\xA4\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xE1\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x98"],

        ["\xF3\xB1\xA4\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xE1\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x99"],

        ["\xF3\xB1\xA4\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xE1\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9A"],

        ["\xF3\xB1\xA4\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xE1\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9B"],

        ["\xF3\xB1\xA4\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xE1\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9C"],

        ["\xF3\xB1\xA4\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xE1\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9D"],

        ["\xF3\xB1\xA4\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xE1\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9E"],

        ["\xF3\xB1\xA4\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xE1\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9F"],

        ["\xF3\xB1\xA4\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xE1\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA0"],

        ["\xF3\xB1\xA4\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xE1\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA1"],

        ["\xF3\xB1\xA4\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xE1\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA2"],

        ["\xF3\xB1\xA4\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xE1\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA3"],

        ["\xF3\xB1\xA4\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xE1\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA4"],

        ["\xF3\xB1\xA4\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xE1\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA5"],

        ["\xF3\xB1\xA4\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xE1\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA6"],

        ["\xF3\xB1\xA4\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xE1\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA7"],

        ["\xF3\xB1\xA4\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xE1\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA8"],

        ["\xF3\xB1\xA4\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xE1\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA9"],

        ["\xF3\xB1\xA4\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xE1\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAA"],

        ["\xF3\xB1\xA4\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xE1\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAB"],

        ["\xF3\xB1\xA4\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xE1\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAC"],

        ["\xF3\xB1\xA4\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xE1\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAD"],

        ["\xF3\xB1\xA4\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xE1\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAE"],

        ["\xF3\xB1\xA4\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xE1\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAF"],

        ["\xF3\xB1\xA4\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xE1\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB0"],

        ["\xF3\xB1\xA4\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xE1\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB1"],

        ["\xF3\xB1\xA4\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xE1\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB2"],

        ["\xF3\xB1\xA4\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xE1\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB3"],

        ["\xF3\xB1\xA4\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xE1\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB4"],

        ["\xF3\xB1\xA4\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xE1\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB5"],

        ["\xF3\xB1\xA4\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xE1\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB6"],

        ["\xF3\xB1\xA4\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xE1\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB7"],

        ["\xF3\xB1\xA4\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xE1\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB8"],

        ["\xF3\xB1\xA4\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xE1\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB9"],

        ["\xF3\xB1\xA4\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xE1\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBA"],

        ["\xF3\xB1\xA4\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xE1\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBB"],

        ["\xF3\xB1\xA4\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x40"],
        ["\xE2\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBC"],

        ["\xF3\xB1\xA4\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x41"],
        ["\xE2\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBD"],

        ["\xF3\xB1\xA4\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x42"],
        ["\xE2\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBE"],

        ["\xF3\xB1\xA4\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x43"],
        ["\xE2\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBF"],

        ["\xF3\xB1\xA5\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x44"],
        ["\xE2\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x80"],

        ["\xF3\xB1\xA5\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x45"],
        ["\xE2\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x81"],

        ["\xF3\xB1\xA5\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x46"],
        ["\xE2\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x82"],

        ["\xF3\xB1\xA5\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x47"],
        ["\xE2\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x83"],

        ["\xF3\xB1\xA5\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x48"],
        ["\xE2\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x84"],

        ["\xF3\xB1\xA5\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x49"],
        ["\xE2\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x85"],

        ["\xF3\xB1\xA5\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\xE2\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x86"],

        ["\xF3\xB1\xA5\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\xE2\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x87"],

        ["\xF3\xB1\xA5\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\xE2\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x88"],

        ["\xF3\xB1\xA5\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],
        ["\xE2\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x89"],

        ["\xF3\xB1\xA5\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],
        ["\xE2\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8A"],

        ["\xF3\xB1\xA5\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],
        ["\xE2\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8B"],

        ["\xF3\xB1\xA5\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],
        ["\xE2\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8C"],

        ["\xF3\xB1\xA5\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x51"],
        ["\xE2\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8D"],

        ["\xF3\xB1\xA5\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x52"],
        ["\xE2\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8E"],

        ["\xF3\xB1\xA5\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x53"],
        ["\xE2\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8F"],

        ["\xF3\xB1\xA5\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x54"],
        ["\xE2\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x90"],

        ["\xF3\xB1\xA5\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x55"],
        ["\xE2\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x91"],

        ["\xF3\xB1\xA5\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x56"],
        ["\xE2\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x92"],

        ["\xF3\xB1\xA5\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],
        ["\xE2\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x93"],

        ["\xF3\xB1\xA5\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x58"],
        ["\xE2\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x94"],

        ["\xF3\xB1\xA5\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],
        ["\xE2\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x95"],

        ["\xF3\xB1\xA5\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],
        ["\xE2\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x96"],

        ["\xF3\xB1\xA5\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\xE2\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x97"],

        ["\xF3\xB1\xA5\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],
        ["\xE2\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x98"],

        ["\xF3\xB1\xA5\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],
        ["\xE2\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x99"],

        ["\xF3\xB1\xA5\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],
        ["\xE2\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9A"],

        ["\xF3\xB1\xA5\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],
        ["\xE2\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9B"],

        ["\xF3\xB1\xA5\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],
        ["\xE2\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9C"],

        ["\xF3\xB1\xA5\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],
        ["\xE2\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9D"],

        ["\xF3\xB1\xA5\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],
        ["\xE2\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9E"],

        ["\xF3\xB1\xA5\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],
        ["\xE2\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9F"],

        ["\xF3\xB1\xA5\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],
        ["\xE2\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA0"],

        ["\xF3\xB1\xA5\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],
        ["\xE2\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA1"],

        ["\xF3\xB1\xA5\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],
        ["\xE2\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA2"],

        ["\xF3\xB1\xA5\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],
        ["\xE2\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA3"],

        ["\xF3\xB1\xA5\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],
        ["\xE2\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA4"],

        ["\xF3\xB1\xA5\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],
        ["\xE2\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA5"],

        ["\xF3\xB1\xA5\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],
        ["\xE2\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA6"],

        ["\xF3\xB1\xA5\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],
        ["\xE2\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA7"],

        ["\xF3\xB1\xA5\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],
        ["\xE2\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA8"],

        ["\xF3\xB1\xA5\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],
        ["\xE2\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA9"],

        ["\xF3\xB1\xA5\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],
        ["\xE2\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAA"],

        ["\xF3\xB1\xA5\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\xE2\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAB"],

        ["\xF3\xB1\xA5\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xE2\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAC"],

        ["\xF3\xB1\xA5\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xE2\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAD"],

        ["\xF3\xB1\xA5\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xE2\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAE"],

        ["\xF3\xB1\xA5\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xE2\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAF"],

        ["\xF3\xB1\xA5\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xE2\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB0"],

        ["\xF3\xB1\xA5\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xE2\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB1"],

        ["\xF3\xB1\xA5\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xE2\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB2"],

        ["\xF3\xB1\xA5\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xE2\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB3"],

        ["\xF3\xB1\xA5\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xE2\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB4"],

        ["\xF3\xB1\xA5\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xE2\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB5"],

        ["\xF3\xB1\xA5\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xE2\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB6"],

        ["\xF3\xB1\xA5\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xE2\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB7"],

        ["\xF3\xB1\xA5\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xE2\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB8"],

        ["\xF3\xB1\xA5\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xE2\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB9"],

        ["\xF3\xB1\xA5\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xE2\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBA"],

        ["\xF3\xB1\xA5\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xE2\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBB"],

        ["\xF3\xB1\xA5\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\xE2\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBC"],

        ["\xF3\xB1\xA5\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\xE2\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBD"],

        ["\xF3\xB1\xA5\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\xE2\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBE"],

        ["\xF3\xB1\xA5\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x84"],
        ["\xE2\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBF"],

        ["\xF3\xB1\xA6\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x85"],
        ["\xE2\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x80"],

        ["\xF3\xB1\xA6\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x86"],
        ["\xE2\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x81"],

        ["\xF3\xB1\xA6\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x87"],
        ["\xE2\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x82"],

        ["\xF3\xB1\xA6\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x88"],
        ["\xE2\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x83"],

        ["\xF3\xB1\xA6\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x89"],
        ["\xE2\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x84"],

        ["\xF3\xB1\xA6\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A"],
        ["\xE2\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x85"],

        ["\xF3\xB1\xA6\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],
        ["\xE2\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x86"],

        ["\xF3\xB1\xA6\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C"],
        ["\xE2\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x87"],

        ["\xF3\xB1\xA6\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8D"],
        ["\xE2\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x88"],

        ["\xF3\xB1\xA6\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E"],
        ["\xE2\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x89"],

        ["\xF3\xB1\xA6\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F"],
        ["\xE2\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8A"],

        ["\xF3\xB1\xA6\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x90"],
        ["\xE2\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8B"],

        ["\xF3\xB1\xA6\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x91"],
        ["\xE2\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8C"],

        ["\xF3\xB1\xA6\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x92"],
        ["\xE2\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8D"],

        ["\xF3\xB1\xA6\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x93"],
        ["\xE2\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8E"],

        ["\xF3\xB1\xA6\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x94"],
        ["\xE2\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8F"],

        ["\xF3\xB1\xA6\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x95"],
        ["\xE2\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x90"],

        ["\xF3\xB1\xA6\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x96"],
        ["\xE2\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x91"],

        ["\xF3\xB1\xA6\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x97"],
        ["\xE2\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x92"],

        ["\xF3\xB1\xA6\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x98"],
        ["\xE2\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x93"],

        ["\xF3\xB1\xA6\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x99"],
        ["\xE2\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x94"],

        ["\xF3\xB1\xA6\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9A"],
        ["\xE2\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x95"],

        ["\xF3\xB1\xA6\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],
        ["\xE2\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x96"],

        ["\xF3\xB1\xA6\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],
        ["\xE2\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x97"],

        ["\xF3\xB1\xA6\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D"],
        ["\xE2\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x98"],

        ["\xF3\xB1\xA6\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9E"],
        ["\xE2\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x99"],

        ["\xF3\xB1\xA6\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9F"],
        ["\xE2\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9A"],

        ["\xF3\xB1\xA6\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],
        ["\xE2\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9B"],

        ["\xF3\xB1\xA6\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE2\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9C"],

        ["\xF3\xB1\xA6\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xE2\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9D"],

        ["\xF3\xB1\xA6\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xE2\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9E"],

        ["\xF3\xB1\xA6\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xE2\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9F"],

        ["\xF3\xB1\xA6\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xE2\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA0"],

        ["\xF3\xB1\xA6\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xE2\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA1"],

        ["\xF3\xB1\xA6\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xE2\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA2"],

        ["\xF3\xB1\xA6\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xE2\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA3"],

        ["\xF3\xB1\xA6\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xE2\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA4"],

        ["\xF3\xB1\xA6\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xE2\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA5"],

        ["\xF3\xB1\xA6\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE2\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA6"],

        ["\xF3\xB1\xA6\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xE2\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA7"],

        ["\xF3\xB1\xA6\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xE2\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA8"],

        ["\xF3\xB1\xA6\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xE2\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA9"],

        ["\xF3\xB1\xA6\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xE2\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAA"],

        ["\xF3\xB1\xA6\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE2\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAB"],

        ["\xF3\xB1\xA6\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xE2\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAC"],

        ["\xF3\xB1\xA6\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xE2\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAD"],

        ["\xF3\xB1\xA6\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xE2\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAE"],

        ["\xF3\xB1\xA6\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xE2\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAF"],

        ["\xF3\xB1\xA6\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xE2\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB0"],

        ["\xF3\xB1\xA6\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xE2\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB1"],

        ["\xF3\xB1\xA6\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xE2\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB2"],

        ["\xF3\xB1\xA6\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xE2\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB3"],

        ["\xF3\xB1\xA6\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xE2\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB4"],

        ["\xF3\xB1\xA6\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xE2\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB5"],

        ["\xF3\xB1\xA6\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xE2\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB6"],

        ["\xF3\xB1\xA6\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xE2\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB7"],

        ["\xF3\xB1\xA6\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xE2\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB8"],

        ["\xF3\xB1\xA6\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xE2\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB9"],

        ["\xF3\xB1\xA6\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xE2\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBA"],

        ["\xF3\xB1\xA6\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE2\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBB"],

        ["\xF3\xB1\xA6\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE2\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBC"],

        ["\xF3\xB1\xA6\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE2\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBD"],

        ["\xF3\xB1\xA6\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xE2\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBE"],

        ["\xF3\xB1\xA6\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE2\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBF"],

        ["\xF3\xB1\xA7\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE2\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x80"],

        ["\xF3\xB1\xA7\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE2\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x81"],

        ["\xF3\xB1\xA7\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE2\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x82"],

        ["\xF3\xB1\xA7\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE2\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x83"],

        ["\xF3\xB1\xA7\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE2\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x84"],

        ["\xF3\xB1\xA7\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xE2\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x85"],

        ["\xF3\xB1\xA7\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xE2\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x86"],

        ["\xF3\xB1\xA7\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xE2\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x87"],

        ["\xF3\xB1\xA7\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xE2\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x88"],

        ["\xF3\xB1\xA7\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xE2\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x89"],

        ["\xF3\xB1\xA7\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xE2\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8A"],

        ["\xF3\xB1\xA7\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE2\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8B"],

        ["\xF3\xB1\xA7\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE2\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8C"],

        ["\xF3\xB1\xA7\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE2\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8D"],

        ["\xF3\xB1\xA7\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE2\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8E"],

        ["\xF3\xB1\xA7\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE2\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8F"],

        ["\xF3\xB1\xA7\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE2\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x90"],

        ["\xF3\xB1\xA7\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE2\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x91"],

        ["\xF3\xB1\xA7\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE2\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x92"],

        ["\xF3\xB1\xA7\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE2\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x93"],

        ["\xF3\xB1\xA7\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE2\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x94"],

        ["\xF3\xB1\xA7\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xE2\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x95"],

        ["\xF3\xB1\xA7\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xE2\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x96"],

        ["\xF3\xB1\xA7\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xE2\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x97"],

        ["\xF3\xB1\xA7\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xE2\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x98"],

        ["\xF3\xB1\xA7\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xE2\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x99"],

        ["\xF3\xB1\xA7\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xE2\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9A"],

        ["\xF3\xB1\xA7\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE2\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9B"],

        ["\xF3\xB1\xA7\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE2\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9C"],

        ["\xF3\xB1\xA7\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE2\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9D"],

        ["\xF3\xB1\xA7\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE2\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9E"],

        ["\xF3\xB1\xA7\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE2\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9F"],

        ["\xF3\xB1\xA7\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE2\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA0"],

        ["\xF3\xB1\xA7\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE2\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA1"],

        ["\xF3\xB1\xA7\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE2\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA2"],

        ["\xF3\xB1\xA7\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE2\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA3"],

        ["\xF3\xB1\xA7\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE2\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA4"],

        ["\xF3\xB1\xA7\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE2\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA5"],

        ["\xF3\xB1\xA7\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE2\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA6"],

        ["\xF3\xB1\xA7\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE2\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA7"],

        ["\xF3\xB1\xA7\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE2\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA8"],

        ["\xF3\xB1\xA7\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE2\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA9"],

        ["\xF3\xB1\xA7\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE2\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAA"],

        ["\xF3\xB1\xA7\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE2\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAB"],

        ["\xF3\xB1\xA7\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE2\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAC"],

        ["\xF3\xB1\xA7\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE2\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAD"],

        ["\xF3\xB1\xA7\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE2\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAE"],

        ["\xF3\xB1\xA7\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE2\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAF"],

        ["\xF3\xB1\xA7\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE2\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB0"],

        ["\xF3\xB1\xA7\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE2\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB1"],

        ["\xF3\xB1\xA7\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE2\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB2"],

        ["\xF3\xB1\xA7\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE2\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB3"],

        ["\xF3\xB1\xA7\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE2\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB4"],

        ["\xF3\xB1\xA7\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xE2\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB5"],

        ["\xF3\xB1\xA7\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE2\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB6"],

        ["\xF3\xB1\xA7\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE2\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB7"],

        ["\xF3\xB1\xA7\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x40"],
        ["\xE3\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB8"],

        ["\xF3\xB1\xA7\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\xE3\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB9"],

        ["\xF3\xB1\xA7\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x42"],
        ["\xE3\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBA"],

        ["\xF3\xB1\xA7\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x43"],
        ["\xE3\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBB"],

        ["\xF3\xB1\xA7\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x44"],
        ["\xE3\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBC"],

        ["\xF3\xB1\xA7\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x45"],
        ["\xE3\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBD"],

        ["\xF3\xB1\xA7\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x46"],
        ["\xE3\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBE"],

        ["\xF3\xB1\xA7\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x47"],
        ["\xE3\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBF"],

        ["\xF3\xB1\xA8\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x48"],
        ["\xE3\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x80"],

        ["\xF3\xB1\xA8\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x49"],
        ["\xE3\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x81"],

        ["\xF3\xB1\xA8\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\xE3\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x82"],

        ["\xF3\xB1\xA8\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\xE3\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x83"],

        ["\xF3\xB1\xA8\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\xE3\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x84"],

        ["\xF3\xB1\xA8\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\xE3\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x85"],

        ["\xF3\xB1\xA8\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\xE3\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x86"],

        ["\xF3\xB1\xA8\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\xE3\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x87"],

        ["\xF3\xB1\xA8\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\xE3\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x88"],

        ["\xF3\xB1\xA8\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x51"],
        ["\xE3\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x89"],

        ["\xF3\xB1\xA8\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x52"],
        ["\xE3\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8A"],

        ["\xF3\xB1\xA8\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x53"],
        ["\xE3\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8B"],

        ["\xF3\xB1\xA8\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x54"],
        ["\xE3\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8C"],

        ["\xF3\xB1\xA8\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x55"],
        ["\xE3\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8D"],

        ["\xF3\xB1\xA8\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x56"],
        ["\xE3\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8E"],

        ["\xF3\xB1\xA8\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],
        ["\xE3\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8F"],

        ["\xF3\xB1\xA8\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x58"],
        ["\xE3\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x90"],

        ["\xF3\xB1\xA8\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],
        ["\xE3\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x91"],

        ["\xF3\xB1\xA8\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\xE3\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x92"],

        ["\xF3\xB1\xA8\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],
        ["\xE3\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x93"],

        ["\xF3\xB1\xA8\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],
        ["\xE3\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x94"],

        ["\xF3\xB1\xA8\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],
        ["\xE3\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x95"],

        ["\xF3\xB1\xA8\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],
        ["\xE3\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x96"],

        ["\xF3\xB1\xA8\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\xE3\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x97"],

        ["\xF3\xB1\xA8\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\xE3\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x98"],

        ["\xF3\xB1\xA8\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\xE3\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x99"],

        ["\xF3\xB1\xA8\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],
        ["\xE3\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9A"],

        ["\xF3\xB1\xA8\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\xE3\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9B"],

        ["\xF3\xB1\xA8\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],
        ["\xE3\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9C"],

        ["\xF3\xB1\xA8\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],
        ["\xE3\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9D"],

        ["\xF3\xB1\xA8\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],
        ["\xE3\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9E"],

        ["\xF3\xB1\xA8\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],
        ["\xE3\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9F"],

        ["\xF3\xB1\xA8\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\xE3\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA0"],

        ["\xF3\xB1\xA8\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\xE3\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA1"],

        ["\xF3\xB1\xA8\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],
        ["\xE3\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA2"],

        ["\xF3\xB1\xA8\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],
        ["\xE3\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA3"],

        ["\xF3\xB1\xA8\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],
        ["\xE3\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA4"],

        ["\xF3\xB1\xA8\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],
        ["\xE3\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA5"],

        ["\xF3\xB1\xA8\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],
        ["\xE3\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA6"],

        ["\xF3\xB1\xA8\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],
        ["\xE3\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA7"],

        ["\xF3\xB1\xA8\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],
        ["\xE3\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA8"],

        ["\xF3\xB1\xA8\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\xE3\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA9"],

        ["\xF3\xB1\xA8\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\xE3\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAA"],

        ["\xF3\xB1\xA8\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],
        ["\xE3\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAB"],

        ["\xF3\xB1\xA8\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],
        ["\xE3\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAC"],

        ["\xF3\xB1\xA8\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],
        ["\xE3\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAD"],

        ["\xF3\xB1\xA8\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],
        ["\xE3\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAE"],

        ["\xF3\xB1\xA8\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],
        ["\xE3\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAF"],

        ["\xF3\xB1\xA8\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\xE3\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB0"],

        ["\xF3\xB1\xA8\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\xE3\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB1"],

        ["\xF3\xB1\xA8\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],
        ["\xE3\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB2"],

        ["\xF3\xB1\xA8\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],
        ["\xE3\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB3"],

        ["\xF3\xB1\xA8\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],
        ["\xE3\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB4"],

        ["\xF3\xB1\xA8\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],
        ["\xE3\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB5"],

        ["\xF3\xB1\xA8\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],
        ["\xE3\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB6"],

        ["\xF3\xB1\xA8\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],
        ["\xE3\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB7"],

        ["\xF3\xB1\xA8\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x81"],
        ["\xE3\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB8"],

        ["\xF3\xB1\xA8\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x82"],
        ["\xE3\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB9"],

        ["\xF3\xB1\xA8\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x83"],
        ["\xE3\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBA"],

        ["\xF3\xB1\xA8\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x84"],
        ["\xE3\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBB"],

        ["\xF3\xB1\xA8\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x85"],
        ["\xE3\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBC"],

        ["\xF3\xB1\xA8\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x86"],
        ["\xE3\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBD"],

        ["\xF3\xB1\xA8\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x87"],
        ["\xE3\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBE"],

        ["\xF3\xB1\xA8\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x88"],
        ["\xE3\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBF"],

        ["\xF3\xB1\xA9\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x89"],
        ["\xE3\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x80"],

        ["\xF3\xB1\xA9\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A"],
        ["\xE3\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x81"],

        ["\xF3\xB1\xA9\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],
        ["\xE3\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x82"],

        ["\xF3\xB1\xA9\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C"],
        ["\xE3\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x83"],

        ["\xF3\xB1\xA9\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D"],
        ["\xE3\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x84"],

        ["\xF3\xB1\xA9\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E"],
        ["\xE3\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x85"],

        ["\xF3\xB1\xA9\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F"],
        ["\xE3\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x86"],

        ["\xF3\xB1\xA9\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x90"],
        ["\xE3\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x87"],

        ["\xF3\xB1\xA9\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x91"],
        ["\xE3\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x88"],

        ["\xF3\xB1\xA9\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x92"],
        ["\xE3\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x89"],

        ["\xF3\xB1\xA9\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x93"],
        ["\xE3\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8A"],

        ["\xF3\xB1\xA9\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x94"],
        ["\xE3\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8B"],

        ["\xF3\xB1\xA9\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x95"],
        ["\xE3\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8C"],

        ["\xF3\xB1\xA9\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x96"],
        ["\xE3\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8D"],

        ["\xF3\xB1\xA9\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x97"],
        ["\xE3\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8E"],

        ["\xF3\xB1\xA9\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x98"],
        ["\xE3\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8F"],

        ["\xF3\xB1\xA9\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x99"],
        ["\xE3\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x90"],

        ["\xF3\xB1\xA9\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A"],
        ["\xE3\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x91"],

        ["\xF3\xB1\xA9\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],
        ["\xE3\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x92"],

        ["\xF3\xB1\xA9\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],
        ["\xE3\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x93"],

        ["\xF3\xB1\xA9\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D"],
        ["\xE3\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x94"],

        ["\xF3\xB1\xA9\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E"],
        ["\xE3\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x95"],

        ["\xF3\xB1\xA9\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F"],
        ["\xE3\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x96"],

        ["\xF3\xB1\xA9\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],
        ["\xE3\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x97"],

        ["\xF3\xB1\xA9\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE3\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x98"],

        ["\xF3\xB1\xA9\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xE3\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x99"],

        ["\xF3\xB1\xA9\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xE3\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9A"],

        ["\xF3\xB1\xA9\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xE3\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9B"],

        ["\xF3\xB1\xA9\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xE3\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9C"],

        ["\xF3\xB1\xA9\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xE3\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9D"],

        ["\xF3\xB1\xA9\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xE3\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9E"],

        ["\xF3\xB1\xA9\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xE3\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9F"],

        ["\xF3\xB1\xA9\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xE3\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA0"],

        ["\xF3\xB1\xA9\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xE3\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA1"],

        ["\xF3\xB1\xA9\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE3\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA2"],

        ["\xF3\xB1\xA9\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xE3\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA3"],

        ["\xF3\xB1\xA9\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xE3\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA4"],

        ["\xF3\xB1\xA9\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xE3\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA5"],

        ["\xF3\xB1\xA9\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xE3\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA6"],

        ["\xF3\xB1\xA9\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE3\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA7"],

        ["\xF3\xB1\xA9\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xE3\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA8"],

        ["\xF3\xB1\xA9\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xE3\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA9"],

        ["\xF3\xB1\xA9\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xE3\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAA"],

        ["\xF3\xB1\xA9\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xE3\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAB"],

        ["\xF3\xB1\xA9\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xE3\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAC"],

        ["\xF3\xB1\xA9\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xE3\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAD"],

        ["\xF3\xB1\xA9\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xE3\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAE"],

        ["\xF3\xB1\xA9\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xE3\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAF"],

        ["\xF3\xB1\xA9\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xE3\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB0"],

        ["\xF3\xB1\xA9\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xE3\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB1"],

        ["\xF3\xB1\xA9\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xE3\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB2"],

        ["\xF3\xB1\xA9\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xE3\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB3"],

        ["\xF3\xB1\xA9\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xE3\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB4"],

        ["\xF3\xB1\xA9\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xE3\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB5"],

        ["\xF3\xB1\xA9\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xE3\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB6"],

        ["\xF3\xB1\xA9\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE3\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB7"],

        ["\xF3\xB1\xA9\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE3\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB8"],

        ["\xF3\xB1\xA9\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE3\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB9"],

        ["\xF3\xB1\xA9\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE3\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBA"],

        ["\xF3\xB1\xA9\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE3\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBB"],

        ["\xF3\xB1\xA9\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE3\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBC"],

        ["\xF3\xB1\xA9\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE3\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBD"],

        ["\xF3\xB1\xA9\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE3\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBE"],

        ["\xF3\xB1\xA9\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE3\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBF"],

        ["\xF3\xB1\xAA\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE3\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x80"],

        ["\xF3\xB1\xAA\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xE3\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x81"],

        ["\xF3\xB1\xAA\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xE3\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x82"],

        ["\xF3\xB1\xAA\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xE3\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x83"],

        ["\xF3\xB1\xAA\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xE3\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x84"],

        ["\xF3\xB1\xAA\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xE3\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x85"],

        ["\xF3\xB1\xAA\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xE3\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x86"],

        ["\xF3\xB1\xAA\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE3\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x87"],

        ["\xF3\xB1\xAA\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE3\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x88"],

        ["\xF3\xB1\xAA\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE3\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x89"],

        ["\xF3\xB1\xAA\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE3\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8A"],

        ["\xF3\xB1\xAA\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE3\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8B"],

        ["\xF3\xB1\xAA\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE3\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8C"],

        ["\xF3\xB1\xAA\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE3\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8D"],

        ["\xF3\xB1\xAA\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE3\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8E"],

        ["\xF3\xB1\xAA\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE3\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8F"],

        ["\xF3\xB1\xAA\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE3\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x90"],

        ["\xF3\xB1\xAA\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xE3\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x91"],

        ["\xF3\xB1\xAA\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xE3\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x92"],

        ["\xF3\xB1\xAA\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xE3\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x93"],

        ["\xF3\xB1\xAA\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xE3\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x94"],

        ["\xF3\xB1\xAA\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xE3\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x95"],

        ["\xF3\xB1\xAA\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xE3\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x96"],

        ["\xF3\xB1\xAA\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE3\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x97"],

        ["\xF3\xB1\xAA\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE3\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x98"],

        ["\xF3\xB1\xAA\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE3\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x99"],

        ["\xF3\xB1\xAA\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE3\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9A"],

        ["\xF3\xB1\xAA\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE3\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9B"],

        ["\xF3\xB1\xAA\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE3\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9C"],

        ["\xF3\xB1\xAA\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE3\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9D"],

        ["\xF3\xB1\xAA\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE3\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9E"],

        ["\xF3\xB1\xAA\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE3\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9F"],

        ["\xF3\xB1\xAA\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE3\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA0"],

        ["\xF3\xB1\xAA\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xE3\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA1"],

        ["\xF3\xB1\xAA\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xE3\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA2"],

        ["\xF3\xB1\xAA\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE3\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA3"],

        ["\xF3\xB1\xAA\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE3\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA4"],

        ["\xF3\xB1\xAA\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xE3\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA5"],

        ["\xF3\xB1\xAA\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xE3\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA6"],

        ["\xF3\xB1\xAA\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE3\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA7"],

        ["\xF3\xB1\xAA\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE3\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA8"],

        ["\xF3\xB1\xAA\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE3\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA9"],

        ["\xF3\xB1\xAA\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE3\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAA"],

        ["\xF3\xB1\xAA\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE3\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAB"],

        ["\xF3\xB1\xAA\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE3\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAC"],

        ["\xF3\xB1\xAA\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE3\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAD"],

        ["\xF3\xB1\xAA\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE3\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAE"],

        ["\xF3\xB1\xAA\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE3\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAF"],

        ["\xF3\xB1\xAA\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE3\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB0"],

        ["\xF3\xB1\xAA\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE3\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB1"],

        ["\xF3\xB1\xAA\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xE3\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB2"],

        ["\xF3\xB1\xAA\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xE3\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB3"],

        ["\xF3\xB1\xAA\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x40"],
        ["\xE4\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB4"],

        ["\xF3\xB1\xAA\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x41"],
        ["\xE4\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB5"],

        ["\xF3\xB1\xAA\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x42"],
        ["\xE4\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB6"],

        ["\xF3\xB1\xAA\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x43"],
        ["\xE4\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB7"],

        ["\xF3\xB1\xAA\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x44"],
        ["\xE4\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB8"],

        ["\xF3\xB1\xAA\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x45"],
        ["\xE4\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB9"],

        ["\xF3\xB1\xAA\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x46"],
        ["\xE4\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBA"],

        ["\xF3\xB1\xAA\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x47"],
        ["\xE4\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBB"],

        ["\xF3\xB1\xAA\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x48"],
        ["\xE4\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBC"],

        ["\xF3\xB1\xAA\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x49"],
        ["\xE4\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBD"],

        ["\xF3\xB1\xAA\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],
        ["\xE4\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBE"],

        ["\xF3\xB1\xAA\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\xE4\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBF"],

        ["\xF3\xB1\xAB\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],
        ["\xE4\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x80"],

        ["\xF3\xB1\xAB\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],
        ["\xE4\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x81"],

        ["\xF3\xB1\xAB\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],
        ["\xE4\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x82"],

        ["\xF3\xB1\xAB\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\xE4\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x83"],

        ["\xF3\xB1\xAB\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\xE4\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x84"],

        ["\xF3\xB1\xAB\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x51"],
        ["\xE4\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x85"],

        ["\xF3\xB1\xAB\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x52"],
        ["\xE4\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x86"],

        ["\xF3\xB1\xAB\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x53"],
        ["\xE4\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x87"],

        ["\xF3\xB1\xAB\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x54"],
        ["\xE4\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x88"],

        ["\xF3\xB1\xAB\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x55"],
        ["\xE4\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x89"],

        ["\xF3\xB1\xAB\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x56"],
        ["\xE4\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8A"],

        ["\xF3\xB1\xAB\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],
        ["\xE4\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8B"],

        ["\xF3\xB1\xAB\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x58"],
        ["\xE4\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8C"],

        ["\xF3\xB1\xAB\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],
        ["\xE4\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8D"],

        ["\xF3\xB1\xAB\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],
        ["\xE4\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8E"],

        ["\xF3\xB1\xAB\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\xE4\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8F"],

        ["\xF3\xB1\xAB\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\xE4\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x90"],

        ["\xF3\xB1\xAB\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\xE4\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x91"],

        ["\xF3\xB1\xAB\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\xE4\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x92"],

        ["\xF3\xB1\xAB\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],
        ["\xE4\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x93"],

        ["\xF3\xB1\xAB\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\xE4\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x94"],

        ["\xF3\xB1\xAB\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],
        ["\xE4\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x95"],

        ["\xF3\xB1\xAB\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],
        ["\xE4\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x96"],

        ["\xF3\xB1\xAB\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],
        ["\xE4\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x97"],

        ["\xF3\xB1\xAB\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],
        ["\xE4\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x98"],

        ["\xF3\xB1\xAB\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],
        ["\xE4\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x99"],

        ["\xF3\xB1\xAB\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],
        ["\xE4\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9A"],

        ["\xF3\xB1\xAB\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],
        ["\xE4\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9B"],

        ["\xF3\xB1\xAB\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\xE4\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9C"],

        ["\xF3\xB1\xAB\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xE4\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9D"],

        ["\xF3\xB1\xAB\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xE4\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9E"],

        ["\xF3\xB1\xAB\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\xE4\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9F"],

        ["\xF3\xB1\xAB\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],
        ["\xE4\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA0"],

        ["\xF3\xB1\xAB\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],
        ["\xE4\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA1"],

        ["\xF3\xB1\xAB\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],
        ["\xE4\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA2"],

        ["\xF3\xB1\xAB\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\xE4\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA3"],

        ["\xF3\xB1\xAB\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],
        ["\xE4\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA4"],

        ["\xF3\xB1\xAB\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],
        ["\xE4\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA5"],

        ["\xF3\xB1\xAB\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],
        ["\xE4\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA6"],

        ["\xF3\xB1\xAB\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\xE4\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA7"],

        ["\xF3\xB1\xAB\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\xE4\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA8"],

        ["\xF3\xB1\xAB\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],
        ["\xE4\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA9"],

        ["\xF3\xB1\xAB\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],
        ["\xE4\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAA"],

        ["\xF3\xB1\xAB\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],
        ["\xE4\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAB"],

        ["\xF3\xB1\xAB\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],
        ["\xE4\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAC"],

        ["\xF3\xB1\xAB\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],
        ["\xE4\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAD"],

        ["\xF3\xB1\xAB\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\xE4\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAE"],

        ["\xF3\xB1\xAB\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],
        ["\xE4\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAF"],

        ["\xF3\xB1\xAB\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],
        ["\xE4\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB0"],

        ["\xF3\xB1\xAB\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],
        ["\xE4\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB1"],

        ["\xF3\xB1\xAB\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\xE4\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB2"],

        ["\xF3\xB1\xAB\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],
        ["\xE4\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB3"],

        ["\xF3\xB1\xAB\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x81"],
        ["\xE4\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB4"],

        ["\xF3\xB1\xAB\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x82"],
        ["\xE4\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB5"],

        ["\xF3\xB1\xAB\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x83"],
        ["\xE4\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB6"],

        ["\xF3\xB1\xAB\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x84"],
        ["\xE4\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB7"],

        ["\xF3\xB1\xAB\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x85"],
        ["\xE4\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB8"],

        ["\xF3\xB1\xAB\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x86"],
        ["\xE4\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB9"],

        ["\xF3\xB1\xAB\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x87"],
        ["\xE4\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBA"],

        ["\xF3\xB1\xAB\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x88"],
        ["\xE4\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBB"],

        ["\xF3\xB1\xAB\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x89"],
        ["\xE4\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBC"],

        ["\xF3\xB1\xAB\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8A"],
        ["\xE4\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBD"],

        ["\xF3\xB1\xAB\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],
        ["\xE4\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBE"],

        ["\xF3\xB1\xAB\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C"],
        ["\xE4\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBF"],

        ["\xF3\xB1\xAC\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8D"],
        ["\xE4\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x80"],

        ["\xF3\xB1\xAC\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8E"],
        ["\xE4\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x81"],

        ["\xF3\xB1\xAC\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F"],
        ["\xE4\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x82"],

        ["\xF3\xB1\xAC\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x90"],
        ["\xE4\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x83"],

        ["\xF3\xB1\xAC\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x91"],
        ["\xE4\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x84"],

        ["\xF3\xB1\xAC\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x92"],
        ["\xE4\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x85"],

        ["\xF3\xB1\xAC\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x93"],
        ["\xE4\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x86"],

        ["\xF3\xB1\xAC\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x94"],
        ["\xE4\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x87"],

        ["\xF3\xB1\xAC\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x95"],
        ["\xE4\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x88"],

        ["\xF3\xB1\xAC\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x96"],
        ["\xE4\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x89"],

        ["\xF3\xB1\xAC\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x97"],
        ["\xE4\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8A"],

        ["\xF3\xB1\xAC\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x98"],
        ["\xE4\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8B"],

        ["\xF3\xB1\xAC\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x99"],
        ["\xE4\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8C"],

        ["\xF3\xB1\xAC\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A"],
        ["\xE4\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8D"],

        ["\xF3\xB1\xAC\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],
        ["\xE4\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8E"],

        ["\xF3\xB1\xAC\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],
        ["\xE4\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8F"],

        ["\xF3\xB1\xAC\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9D"],
        ["\xE4\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x90"],

        ["\xF3\xB1\xAC\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9E"],
        ["\xE4\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x91"],

        ["\xF3\xB1\xAC\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9F"],
        ["\xE4\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x92"],

        ["\xF3\xB1\xAC\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],
        ["\xE4\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x93"],

        ["\xF3\xB1\xAC\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE4\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x94"],

        ["\xF3\xB1\xAC\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xE4\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x95"],

        ["\xF3\xB1\xAC\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xE4\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x96"],

        ["\xF3\xB1\xAC\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xE4\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x97"],

        ["\xF3\xB1\xAC\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xE4\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x98"],

        ["\xF3\xB1\xAC\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xE4\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x99"],

        ["\xF3\xB1\xAC\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xE4\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9A"],

        ["\xF3\xB1\xAC\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xE4\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9B"],

        ["\xF3\xB1\xAC\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xE4\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9C"],

        ["\xF3\xB1\xAC\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xE4\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9D"],

        ["\xF3\xB1\xAC\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE4\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9E"],

        ["\xF3\xB1\xAC\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xE4\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9F"],

        ["\xF3\xB1\xAC\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xE4\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA0"],

        ["\xF3\xB1\xAC\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xE4\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA1"],

        ["\xF3\xB1\xAC\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xE4\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA2"],

        ["\xF3\xB1\xAC\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE4\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA3"],

        ["\xF3\xB1\xAC\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xE4\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA4"],

        ["\xF3\xB1\xAC\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xE4\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA5"],

        ["\xF3\xB1\xAC\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xE4\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA6"],

        ["\xF3\xB1\xAC\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xE4\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA7"],

        ["\xF3\xB1\xAC\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xE4\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA8"],

        ["\xF3\xB1\xAC\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xE4\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA9"],

        ["\xF3\xB1\xAC\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xE4\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAA"],

        ["\xF3\xB1\xAC\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xE4\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAB"],

        ["\xF3\xB1\xAC\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xE4\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAC"],

        ["\xF3\xB1\xAC\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xE4\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAD"],

        ["\xF3\xB1\xAC\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xE4\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAE"],

        ["\xF3\xB1\xAC\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xE4\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAF"],

        ["\xF3\xB1\xAC\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xE4\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB0"],

        ["\xF3\xB1\xAC\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE4\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB1"],

        ["\xF3\xB1\xAC\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE4\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB2"],

        ["\xF3\xB1\xAC\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE4\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB3"],

        ["\xF3\xB1\xAC\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE4\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB4"],

        ["\xF3\xB1\xAC\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE4\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB5"],

        ["\xF3\xB1\xAC\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE4\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB6"],

        ["\xF3\xB1\xAC\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE4\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB7"],

        ["\xF3\xB1\xAC\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE4\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB8"],

        ["\xF3\xB1\xAC\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE4\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB9"],

        ["\xF3\xB1\xAC\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE4\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBA"],

        ["\xF3\xB1\xAC\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE4\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBB"],

        ["\xF3\xB1\xAC\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE4\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBC"],

        ["\xF3\xB1\xAC\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE4\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBD"],

        ["\xF3\xB1\xAC\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE4\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBE"],

        ["\xF3\xB1\xAC\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE4\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBF"],

        ["\xF3\xB1\xAD\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xE4\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x80"],

        ["\xF3\xB1\xAD\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xE4\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x81"],

        ["\xF3\xB1\xAD\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xE4\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x82"],

        ["\xF3\xB1\xAD\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE4\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x83"],

        ["\xF3\xB1\xAD\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE4\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x84"],

        ["\xF3\xB1\xAD\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE4\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x85"],

        ["\xF3\xB1\xAD\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE4\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x86"],

        ["\xF3\xB1\xAD\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE4\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x87"],

        ["\xF3\xB1\xAD\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE4\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x88"],

        ["\xF3\xB1\xAD\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE4\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x89"],

        ["\xF3\xB1\xAD\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE4\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8A"],

        ["\xF3\xB1\xAD\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE4\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8B"],

        ["\xF3\xB1\xAD\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE4\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8C"],

        ["\xF3\xB1\xAD\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xE4\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8D"],

        ["\xF3\xB1\xAD\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xE4\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8E"],

        ["\xF3\xB1\xAD\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xE4\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8F"],

        ["\xF3\xB1\xAD\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xE4\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x90"],

        ["\xF3\xB1\xAD\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xE4\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x91"],

        ["\xF3\xB1\xAD\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xE4\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x92"],

        ["\xF3\xB1\xAD\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE4\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x93"],

        ["\xF3\xB1\xAD\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xE4\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x94"],

        ["\xF3\xB1\xAD\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE4\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x95"],

        ["\xF3\xB1\xAD\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE4\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x96"],

        ["\xF3\xB1\xAD\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE4\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x97"],

        ["\xF3\xB1\xAD\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE4\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x98"],

        ["\xF3\xB1\xAD\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE4\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x99"],

        ["\xF3\xB1\xAD\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE4\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9A"],

        ["\xF3\xB1\xAD\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE4\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9B"],

        ["\xF3\xB1\xAD\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE4\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9C"],

        ["\xF3\xB1\xAD\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xE4\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9D"],

        ["\xF3\xB1\xAD\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xE4\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9E"],

        ["\xF3\xB1\xAD\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xE4\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9F"],

        ["\xF3\xB1\xAD\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xE4\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA0"],

        ["\xF3\xB1\xAD\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xE4\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA1"],

        ["\xF3\xB1\xAD\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xE4\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA2"],

        ["\xF3\xB1\xAD\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE4\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA3"],

        ["\xF3\xB1\xAD\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE4\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA4"],

        ["\xF3\xB1\xAD\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE4\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA5"],

        ["\xF3\xB1\xAD\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE4\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA6"],

        ["\xF3\xB1\xAD\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE4\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA7"],

        ["\xF3\xB1\xAD\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE4\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA8"],

        ["\xF3\xB1\xAD\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE4\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA9"],

        ["\xF3\xB1\xAD\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE4\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAA"],

        ["\xF3\xB1\xAD\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE4\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAB"],

        ["\xF3\xB1\xAD\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE4\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAC"],

        ["\xF3\xB1\xAD\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xE4\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAD"],

        ["\xF3\xB1\xAD\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xE4\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAE"],

        ["\xF3\xB1\xAD\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xE4\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAF"],

        ["\xF3\xB1\xAD\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x40"],
        ["\xE5\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB0"],

        ["\xF3\xB1\xAD\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x41"],
        ["\xE5\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB1"],

        ["\xF3\xB1\xAD\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x42"],
        ["\xE5\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB2"],

        ["\xF3\xB1\xAD\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x43"],
        ["\xE5\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB3"],

        ["\xF3\xB1\xAD\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x44"],
        ["\xE5\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB4"],

        ["\xF3\xB1\xAD\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x45"],
        ["\xE5\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB5"],

        ["\xF3\xB1\xAD\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x46"],
        ["\xE5\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB6"],

        ["\xF3\xB1\xAD\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x47"],
        ["\xE5\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB7"],

        ["\xF3\xB1\xAD\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x48"],
        ["\xE5\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB8"],

        ["\xF3\xB1\xAD\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x49"],
        ["\xE5\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB9"],

        ["\xF3\xB1\xAD\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\xE5\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBA"],

        ["\xF3\xB1\xAD\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],
        ["\xE5\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBB"],

        ["\xF3\xB1\xAD\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],
        ["\xE5\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBC"],

        ["\xF3\xB1\xAD\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],
        ["\xE5\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBD"],

        ["\xF3\xB1\xAD\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],
        ["\xE5\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBE"],

        ["\xF3\xB1\xAD\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],
        ["\xE5\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBF"],

        ["\xF3\xB1\xAE\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\xE5\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x80"],

        ["\xF3\xB1\xAE\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x51"],
        ["\xE5\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x81"],

        ["\xF3\xB1\xAE\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x52"],
        ["\xE5\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x82"],

        ["\xF3\xB1\xAE\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x53"],
        ["\xE5\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x83"],

        ["\xF3\xB1\xAE\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x54"],
        ["\xE5\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x84"],

        ["\xF3\xB1\xAE\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x55"],
        ["\xE5\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x85"],

        ["\xF3\xB1\xAE\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x56"],
        ["\xE5\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x86"],

        ["\xF3\xB1\xAE\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],
        ["\xE5\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x87"],

        ["\xF3\xB1\xAE\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x58"],
        ["\xE5\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x88"],

        ["\xF3\xB1\xAE\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],
        ["\xE5\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x89"],

        ["\xF3\xB1\xAE\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],
        ["\xE5\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8A"],

        ["\xF3\xB1\xAE\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],
        ["\xE5\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8B"],

        ["\xF3\xB1\xAE\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],
        ["\xE5\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8C"],

        ["\xF3\xB1\xAE\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],
        ["\xE5\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8D"],

        ["\xF3\xB1\xAE\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],
        ["\xE5\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8E"],

        ["\xF3\xB1\xAE\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],
        ["\xE5\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8F"],

        ["\xF3\xB1\xAE\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],
        ["\xE5\x60",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x90"],

        ["\xF3\xB1\xAE\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],
        ["\xE5\x61",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x91"],

        ["\xF3\xB1\xAE\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\xE5\x62",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x92"],

        ["\xF3\xB1\xAE\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],
        ["\xE5\x63",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x93"],

        ["\xF3\xB1\xAE\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\xE5\x64",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x94"],

        ["\xF3\xB1\xAE\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],
        ["\xE5\x65",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x95"],

        ["\xF3\xB1\xAE\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],
        ["\xE5\x66",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x96"],

        ["\xF3\xB1\xAE\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],
        ["\xE5\x67",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x97"],

        ["\xF3\xB1\xAE\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],
        ["\xE5\x68",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x98"],

        ["\xF3\xB1\xAE\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],
        ["\xE5\x69",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x99"],

        ["\xF3\xB1\xAE\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\xE5\x6A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9A"],

        ["\xF3\xB1\xAE\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\xE5\x6B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9B"],

        ["\xF3\xB1\xAE\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\xE5\x6C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9C"],

        ["\xF3\xB1\xAE\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],
        ["\xE5\x6D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9D"],

        ["\xF3\xB1\xAE\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],
        ["\xE5\x6E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9E"],

        ["\xF3\xB1\xAE\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],
        ["\xE5\x6F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9F"],

        ["\xF3\xB1\xAE\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],
        ["\xE5\x70",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA0"],

        ["\xF3\xB1\xAE\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],
        ["\xE5\x71",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA1"],

        ["\xF3\xB1\xAE\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],
        ["\xE5\x72",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA2"],

        ["\xF3\xB1\xAE\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],
        ["\xE5\x73",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA3"],

        ["\xF3\xB1\xAE\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],
        ["\xE5\x74",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA4"],

        ["\xF3\xB1\xAE\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\xE5\x75",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA5"],

        ["\xF3\xB1\xAE\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],
        ["\xE5\x76",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA6"],

        ["\xF3\xB1\xAE\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],
        ["\xE5\x77",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA7"],

        ["\xF3\xB1\xAE\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],
        ["\xE5\x78",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA8"],

        ["\xF3\xB1\xAE\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\xE5\x79",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA9"],

        ["\xF3\xB1\xAE\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],
        ["\xE5\x7A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAA"],

        ["\xF3\xB1\xAE\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],
        ["\xE5\x7B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAB"],

        ["\xF3\xB1\xAE\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],
        ["\xE5\x7C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAC"],

        ["\xF3\xB1\xAE\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],
        ["\xE5\x7D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAD"],

        ["\xF3\xB1\xAE\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],
        ["\xE5\x7E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAE"],

        ["\xF3\xB1\xAE\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],
        ["\xE5\x80",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAF"],

        ["\xF3\xB1\xAE\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x81"],
        ["\xE5\x81",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB0"],

        ["\xF3\xB1\xAE\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x82"],
        ["\xE5\x82",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB1"],

        ["\xF3\xB1\xAE\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x83"],
        ["\xE5\x83",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB2"],

        ["\xF3\xB1\xAE\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x84"],
        ["\xE5\x84",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB3"],

        ["\xF3\xB1\xAE\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x85"],
        ["\xE5\x85",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB4"],

        ["\xF3\xB1\xAE\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x86"],
        ["\xE5\x86",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB5"],

        ["\xF3\xB1\xAE\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x87"],
        ["\xE5\x87",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB6"],

        ["\xF3\xB1\xAE\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x88"],
        ["\xE5\x88",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB7"],

        ["\xF3\xB1\xAE\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x89"],
        ["\xE5\x89",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB8"],

        ["\xF3\xB1\xAE\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A"],
        ["\xE5\x8A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB9"],

        ["\xF3\xB1\xAE\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],
        ["\xE5\x8B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBA"],

        ["\xF3\xB1\xAE\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C"],
        ["\xE5\x8C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBB"],

        ["\xF3\xB1\xAE\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D"],
        ["\xE5\x8D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBC"],

        ["\xF3\xB1\xAE\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E"],
        ["\xE5\x8E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBD"],

        ["\xF3\xB1\xAE\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F"],
        ["\xE5\x8F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBE"],

        ["\xF3\xB1\xAE\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x90"],
        ["\xE5\x90",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBF"],

        ["\xF3\xB1\xAF\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x91"],
        ["\xE5\x91",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x80"],

        ["\xF3\xB1\xAF\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x92"],
        ["\xE5\x92",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x81"],

        ["\xF3\xB1\xAF\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x93"],
        ["\xE5\x93",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x82"],

        ["\xF3\xB1\xAF\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x94"],
        ["\xE5\x94",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x83"],

        ["\xF3\xB1\xAF\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x95"],
        ["\xE5\x95",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x84"],

        ["\xF3\xB1\xAF\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x96"],
        ["\xE5\x96",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x85"],

        ["\xF3\xB1\xAF\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x97"],
        ["\xE5\x97",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x86"],

        ["\xF3\xB1\xAF\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x98"],
        ["\xE5\x98",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x87"],

        ["\xF3\xB1\xAF\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x99"],
        ["\xE5\x99",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x88"],

        ["\xF3\xB1\xAF\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A"],
        ["\xE5\x9A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x89"],

        ["\xF3\xB1\xAF\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],
        ["\xE5\x9B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8A"],

        ["\xF3\xB1\xAF\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],
        ["\xE5\x9C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8B"],

        ["\xF3\xB1\xAF\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D"],
        ["\xE5\x9D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8C"],

        ["\xF3\xB1\xAF\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E"],
        ["\xE5\x9E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8D"],

        ["\xF3\xB1\xAF\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F"],
        ["\xE5\x9F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8E"],

        ["\xF3\xB1\xAF\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],
        ["\xE5\xA0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8F"],

        ["\xF3\xB1\xAF\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xE5\xA1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x90"],

        ["\xF3\xB1\xAF\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xE5\xA2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x91"],

        ["\xF3\xB1\xAF\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xE5\xA3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x92"],

        ["\xF3\xB1\xAF\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xE5\xA4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x93"],

        ["\xF3\xB1\xAF\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xE5\xA5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x94"],

        ["\xF3\xB1\xAF\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xE5\xA6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x95"],

        ["\xF3\xB1\xAF\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xE5\xA7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x96"],

        ["\xF3\xB1\xAF\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xE5\xA8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x97"],

        ["\xF3\xB1\xAF\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xE5\xA9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x98"],

        ["\xF3\xB1\xAF\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xE5\xAA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x99"],

        ["\xF3\xB1\xAF\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xE5\xAB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9A"],

        ["\xF3\xB1\xAF\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xE5\xAC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9B"],

        ["\xF3\xB1\xAF\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xE5\xAD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9C"],

        ["\xF3\xB1\xAF\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xE5\xAE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9D"],

        ["\xF3\xB1\xAF\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xE5\xAF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9E"],

        ["\xF3\xB1\xAF\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xE5\xB0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9F"],

        ["\xF3\xB1\xAF\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xE5\xB1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA0"],

        ["\xF3\xB1\xAF\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xE5\xB2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA1"],

        ["\xF3\xB1\xAF\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xE5\xB3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA2"],

        ["\xF3\xB1\xAF\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xE5\xB4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA3"],

        ["\xF3\xB1\xAF\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xE5\xB5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA4"],

        ["\xF3\xB1\xAF\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xE5\xB6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA5"],

        ["\xF3\xB1\xAF\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xE5\xB7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA6"],

        ["\xF3\xB1\xAF\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xE5\xB8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA7"],

        ["\xF3\xB1\xAF\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xE5\xB9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA8"],

        ["\xF3\xB1\xAF\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xE5\xBA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA9"],

        ["\xF3\xB1\xAF\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xE5\xBB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAA"],

        ["\xF3\xB1\xAF\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xE5\xBC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAB"],

        ["\xF3\xB1\xAF\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xE5\xBD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAC"],

        ["\xF3\xB1\xAF\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xE5\xBE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAD"],

        ["\xF3\xB1\xAF\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xE5\xBF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAE"],

        ["\xF3\xB1\xAF\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xE5\xC0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAF"],

        ["\xF3\xB1\xAF\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xE5\xC1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB0"],

        ["\xF3\xB1\xAF\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xE5\xC2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB1"],

        ["\xF3\xB1\xAF\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xE5\xC3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB2"],

        ["\xF3\xB1\xAF\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xE5\xC4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB3"],

        ["\xF3\xB1\xAF\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xE5\xC5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB4"],

        ["\xF3\xB1\xAF\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xE5\xC6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB5"],

        ["\xF3\xB1\xAF\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xE5\xC7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB6"],

        ["\xF3\xB1\xAF\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xE5\xC8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB7"],

        ["\xF3\xB1\xAF\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xE5\xC9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB8"],

        ["\xF3\xB1\xAF\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xE5\xCA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB9"],

        ["\xF3\xB1\xAF\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xE5\xCB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBA"],

        ["\xF3\xB1\xAF\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xE5\xCC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBB"],

        ["\xF3\xB1\xAF\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xE5\xCD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBC"],

        ["\xF3\xB1\xAF\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xE5\xCE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBD"],

        ["\xF3\xB1\xAF\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xE5\xCF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBE"],

        ["\xF3\xB1\xAF\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xE5\xD0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBF"],

        ["\xF3\xB1\xB0\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xE5\xD1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x80"],

        ["\xF3\xB1\xB0\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xE5\xD2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x81"],

        ["\xF3\xB1\xB0\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xE5\xD3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x82"],

        ["\xF3\xB1\xB0\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xE5\xD4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x83"],

        ["\xF3\xB1\xB0\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xE5\xD5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x84"],

        ["\xF3\xB1\xB0\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xE5\xD6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x85"],

        ["\xF3\xB1\xB0\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xE5\xD7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x86"],

        ["\xF3\xB1\xB0\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xE5\xD8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x87"],

        ["\xF3\xB1\xB0\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xE5\xD9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x88"],

        ["\xF3\xB1\xB0\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xE5\xDA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x89"],

        ["\xF3\xB1\xB0\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xE5\xDB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8A"],

        ["\xF3\xB1\xB0\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xE5\xDC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8B"],

        ["\xF3\xB1\xB0\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xE5\xDD",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8C"],

        ["\xF3\xB1\xB0\x8D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xE5\xDE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8D"],

        ["\xF3\xB1\xB0\x8E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xE5\xDF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8E"],

        ["\xF3\xB1\xB0\x8F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xE5\xE0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8F"],

        ["\xF3\xB1\xB0\x90",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xE5\xE1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x90"],

        ["\xF3\xB1\xB0\x91",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xE5\xE2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x91"],

        ["\xF3\xB1\xB0\x92",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xE5\xE3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x92"],

        ["\xF3\xB1\xB0\x93",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xE5\xE4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x93"],

        ["\xF3\xB1\xB0\x94",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xE5\xE5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x94"],

        ["\xF3\xB1\xB0\x95",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xE5\xE6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x95"],

        ["\xF3\xB1\xB0\x96",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xE5\xE7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x96"],

        ["\xF3\xB1\xB0\x97",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xE5\xE8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x97"],

        ["\xF3\xB1\xB0\x98",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xE5\xE9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x98"],

        ["\xF3\xB1\xB0\x99",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xE5\xEA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x99"],

        ["\xF3\xB1\xB0\x9A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xE5\xEB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9A"],

        ["\xF3\xB1\xB0\x9B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xE5\xEC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9B"],

        ["\xF3\xB1\xB0\x9C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xE5\xED",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9C"],

        ["\xF3\xB1\xB0\x9D",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xE5\xEE",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9D"],

        ["\xF3\xB1\xB0\x9E",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xE5\xEF",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9E"],

        ["\xF3\xB1\xB0\x9F",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xE5\xF0",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9F"],

        ["\xF3\xB1\xB0\xA0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xE5\xF1",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA0"],

        ["\xF3\xB1\xB0\xA1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xE5\xF2",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA1"],

        ["\xF3\xB1\xB0\xA2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xE5\xF3",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA2"],

        ["\xF3\xB1\xB0\xA3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xE5\xF4",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA3"],

        ["\xF3\xB1\xB0\xA4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xE5\xF5",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA4"],

        ["\xF3\xB1\xB0\xA5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xE5\xF6",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA5"],

        ["\xF3\xB1\xB0\xA6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xE5\xF7",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA6"],

        ["\xF3\xB1\xB0\xA7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xE5\xF8",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA7"],

        ["\xF3\xB1\xB0\xA8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xE5\xF9",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA8"],

        ["\xF3\xB1\xB0\xA9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xE5\xFA",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA9"],

        ["\xF3\xB1\xB0\xAA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xE5\xFB",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAA"],

        ["\xF3\xB1\xB0\xAB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xE5\xFC",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAB"],

        ["\xF3\xB1\xB0\xAC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x40"],
        ["\xE6\x40",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAC"],

        ["\xF3\xB1\xB0\xAD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x41"],
        ["\xE6\x41",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAD"],

        ["\xF3\xB1\xB0\xAE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x42"],
        ["\xE6\x42",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAE"],

        ["\xF3\xB1\xB0\xAF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x43"],
        ["\xE6\x43",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAF"],

        ["\xF3\xB1\xB0\xB0",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x44"],
        ["\xE6\x44",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB0"],

        ["\xF3\xB1\xB0\xB1",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x45"],
        ["\xE6\x45",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB1"],

        ["\xF3\xB1\xB0\xB2",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x46"],
        ["\xE6\x46",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB2"],

        ["\xF3\xB1\xB0\xB3",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x47"],
        ["\xE6\x47",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB3"],

        ["\xF3\xB1\xB0\xB4",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x48"],
        ["\xE6\x48",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB4"],

        ["\xF3\xB1\xB0\xB5",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x49"],
        ["\xE6\x49",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB5"],

        ["\xF3\xB1\xB0\xB6",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\xE6\x4A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB6"],

        ["\xF3\xB1\xB0\xB7",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],
        ["\xE6\x4B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB7"],

        ["\xF3\xB1\xB0\xB8",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],
        ["\xE6\x4C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB8"],

        ["\xF3\xB1\xB0\xB9",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],
        ["\xE6\x4D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB9"],

        ["\xF3\xB1\xB0\xBA",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],
        ["\xE6\x4E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBA"],

        ["\xF3\xB1\xB0\xBB",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],
        ["\xE6\x4F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBB"],

        ["\xF3\xB1\xB0\xBC",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],
        ["\xE6\x50",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBC"],

        ["\xF3\xB1\xB0\xBD",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x51"],
        ["\xE6\x51",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBD"],

        ["\xF3\xB1\xB0\xBE",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x52"],
        ["\xE6\x52",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBE"],

        ["\xF3\xB1\xB0\xBF",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x53"],
        ["\xE6\x53",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBF"],

        ["\xF3\xB1\xB1\x80",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x54"],
        ["\xE6\x54",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x80"],

        ["\xF3\xB1\xB1\x81",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x55"],
        ["\xE6\x55",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x81"],

        ["\xF3\xB1\xB1\x82",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x56"],
        ["\xE6\x56",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x82"],

        ["\xF3\xB1\xB1\x83",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],
        ["\xE6\x57",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x83"],

        ["\xF3\xB1\xB1\x84",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x58"],
        ["\xE6\x58",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x84"],

        ["\xF3\xB1\xB1\x85",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],
        ["\xE6\x59",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x85"],

        ["\xF3\xB1\xB1\x86",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],
        ["\xE6\x5A",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x86"],

        ["\xF3\xB1\xB1\x87",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],
        ["\xE6\x5B",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x87"],

        ["\xF3\xB1\xB1\x88",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],
        ["\xE6\x5C",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x88"],

        ["\xF3\xB1\xB1\x89",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],
        ["\xE6\x5D",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x89"],

        ["\xF3\xB1\xB1\x8A",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5E"],
        ["\xE6\x5E",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8A"],

        ["\xF3\xB1\xB1\x8B",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],
        ["\xE6\x5F",'utf8jp','cp932x',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8B"],

        ["\xF3\xB1\xB1\x8C",'cp932x','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],
        ["\xE6\x60",'utf8jp','cp932x',{'INPUT_LAYOUT