package Daje::Workflow::GeneratePerl::Generate::Class;
use Mojo::Base 'Daje::Workflow::GeneratePerl::Base::Common' ,-base, -signatures;

use String::CamelCase qw(camelize);

# NAME
# ====
#
# Daje::Workflow::GeneratePerl::Generate::Class - Create class
#
#
# REQUIRES
# ========
#
#    use String::CamelCase
#
#
#
# METHODS
# =======
#
#

our $VERSION = '0.01';

has 'methods';
has 'fields';
has 'config';

sub generate($self) {
    my $tpl = $self->templates->get_data_section('class');
    my $table_name = $self->json->{table_name};
    my $name_space = $self->context->{context}->{perl}->{name_space};
    my $base_name_space = $self->context->{context}->{perl}->{base_name_space};
    my $class_name = camelize($table_name);
    my $base_class_name = "Base";

    my $select_fields = $self->methods->select_fields();
    my $pkey = $self->methods->pkey();
    my $fkey = $self->methods->fkey();
    my $insert = $self->methods->insert();
    my $update = $self->methods->update();
    my $select_method = $self->methods->select_method();
    my $select_from_index = $self->methods->select_index_method();

    my $date = localtime();

    $tpl =~ s/<<date>>/$date/ig;
    $tpl =~ s/<<fields>>/$select_fields/ig;
    $tpl =~ s/<<name_space>>/$name_space/ig;
    $tpl =~ s/<<classname>>/$class_name/ig;
    $tpl =~ s/<<base_name_space>>/$base_name_space/ig;
    $tpl =~ s/<<base_class_name>>/$base_class_name/ig;

    $tpl =~ s/<<pkey>>/$pkey/ig;
    $tpl =~ s/<<fkey>>/$fkey/ig;
    $tpl =~ s/<<insert>>/$insert/ig;
    $tpl =~ s/<<update>>/$update/ig;

    $tpl =~ s/<<select>>/$select_method/ig;
    $tpl =~ s/<<methods>>/$select_from_index/ig;

    return $tpl;
}
1;


#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::GeneratePerl::Generate::Class - Create class




=head1 REQUIRES


   use String::CamelCase





=head1 METHODS





=cut

