package Stancer::Refund::Status;

use 5.020;
use strict;
use warnings;

# ABSTRACT: Refund status values
our $VERSION = '1.0.1'; # TRIAL VERSION

use Moo;
use namespace::clean;

use constant {
    NOT_HONORED => 'not_honored',
    PAYMENT_CANCELED => 'payment_canceled',
    REFUND_SENT => 'refund_sent',
    REFUNDED => 'refunded',
    TO_REFUND => 'to_refund',
};


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Stancer::Refund::Status - Refund status values

=head1 VERSION

version 1.0.1

=head1

=head2 failed

The refund has failed, refer to the response field for more details.

=head2 not_honored

When payment is disputed while trying to refund.

=head2 refund_sent

The refund has been sent to the bank, awaiting an answer.

=head2 refunded

The amount of the refund have been credited to your account.

=head2 to_refund

Refund will be processed within the day.

=head1 USAGE

=head2 Logging



We use the L<Log::Any> framework for logging events.
You may tell where it should log using any available L<Log::Any::Adapter> module.

For example, to log everything to a file you just have to add a line to your script, like this:
    #! /usr/bin/env perl
    use Log::Any::Adapter (File => '/var/log/payment.log');
    use Stancer::Refund::Status;

You must import C<Log::Any::Adapter> before our libraries, to initialize the logger instance before use.

You can choose your log level on import directly:
    use Log::Any::Adapter (File => '/var/log/payment.log', log_level => 'info');

Read the L<Log::Any> documentation to know what other options you have.

=cut

=head1 SECURITY

=over

=item *

Never, never, NEVER register a card or a bank account number in your database.

=item *

Always uses HTTPS in card/SEPA in communication.

=item *

Our API will never give you a complete card/SEPA number, only the last four digits.
If you need to keep track, use these last four digit.

=back

=cut

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://gitlab.com/wearestancer/library/lib-perl/-/issues> or by email to
L<bug-stancer@rt.cpan.org|mailto:bug-stancer@rt.cpan.org>.

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Joel Da Silva <jdasilva@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2024 by Stancer / Iliad78.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
