# Generated by default/object.tt
package Paws::EFS::BackupPolicy;
  use Moose;
  has Status => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EFS::BackupPolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EFS::BackupPolicy object:

  $service_obj->Method(Att1 => { Status => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EFS::BackupPolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->Status

=head1 DESCRIPTION

The backup policy for the file system used to create automatic daily
backups. If status has a value of C<ENABLED>, the file system is being
automatically backed up. For more information, see Automatic backups
(https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups).

=head1 ATTRIBUTES


=head2 B<REQUIRED> Status => Str

Describes the status of the file system's backup policy.

=over

=item *

B<C<ENABLED> > - EFS is automatically backing up the file system.

=item *

B<C<ENABLING> > - EFS is turning on automatic backups for the file
system.

=item *

B<C<DISABLED> > - automatic back ups are turned off for the file
system.

=item *

B<C<DISABLING> > - EFS is turning off automatic backups for the file
system.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EFS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

