# Generated by default/object.tt
package Paws::LexModelsV2::BotLocaleImportSpecification;
  use Moose;
  has BotId => (is => 'ro', isa => 'Str', request_name => 'botId', traits => ['NameInRequest'], required => 1);
  has BotVersion => (is => 'ro', isa => 'Str', request_name => 'botVersion', traits => ['NameInRequest'], required => 1);
  has LocaleId => (is => 'ro', isa => 'Str', request_name => 'localeId', traits => ['NameInRequest'], required => 1);
  has NluIntentConfidenceThreshold => (is => 'ro', isa => 'Num', request_name => 'nluIntentConfidenceThreshold', traits => ['NameInRequest']);
  has VoiceSettings => (is => 'ro', isa => 'Paws::LexModelsV2::VoiceSettings', request_name => 'voiceSettings', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::BotLocaleImportSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::BotLocaleImportSpecification object:

  $service_obj->Method(Att1 => { BotId => $value, ..., VoiceSettings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::BotLocaleImportSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->BotId

=head1 DESCRIPTION

Provides the bot locale parameters required for importing a bot locale.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BotId => Str

The identifier of the bot to import the locale to.


=head2 B<REQUIRED> BotVersion => Str

The version of the bot to import the locale to. This can only be the
C<DRAFT> version of the bot.


=head2 B<REQUIRED> LocaleId => Str

The identifier of the language and locale that the bot will be used in.
The string must match one of the supported locales. All of the intents,
slot types, and slots used in the bot must have the same locale. For
more information, see Supported languages
(https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).


=head2 NluIntentConfidenceThreshold => Num

Determines the threshold where Amazon Lex will insert the
C<AMAZON.FallbackIntent>, C<AMAZON.KendraSearchIntent>, or both when
returning alternative intents. C<AMAZON.FallbackIntent> and
C<AMAZON.KendraSearchIntent> are only inserted if they are configured
for the bot.

For example, suppose a bot is configured with the confidence threshold
of 0.80 and the C<AMAZON.FallbackIntent>. Amazon Lex returns three
alternative intents with the following confidence scores: IntentA
(0.70), IntentB (0.60), IntentC (0.50). The response from the
C<PostText> operation would be:

=over

=item *

C<AMAZON.FallbackIntent>

=item *

C<IntentA>

=item *

C<IntentB>

=item *

C<IntentC>

=back



=head2 VoiceSettings => L<Paws::LexModelsV2::VoiceSettings>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

