use strict;
use warnings;
use Test::More;
BEGIN { use_ok 'UUID', qw(uuid1 parse type variant) }

my $bin;
my $str = uuid1();
note '';
note $str;

ok defined($str),      'defined';
ok length($str) == 36, 'length';
ok !parse($str, $bin), 'parsable';

# must be v1
my $type = type($bin);
is $type, 1, 'correct type';

# all are variant 1
is variant($bin), 1, 'correct variant';

done_testing;
