# Generated by default/object.tt
package Paws::AuditManager::Delegation;
  use Moose;
  has AssessmentId => (is => 'ro', isa => 'Str', request_name => 'assessmentId', traits => ['NameInRequest']);
  has AssessmentName => (is => 'ro', isa => 'Str', request_name => 'assessmentName', traits => ['NameInRequest']);
  has Comment => (is => 'ro', isa => 'Str', request_name => 'comment', traits => ['NameInRequest']);
  has ControlSetId => (is => 'ro', isa => 'Str', request_name => 'controlSetId', traits => ['NameInRequest']);
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest']);
  has CreationTime => (is => 'ro', isa => 'Str', request_name => 'creationTime', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has LastUpdated => (is => 'ro', isa => 'Str', request_name => 'lastUpdated', traits => ['NameInRequest']);
  has RoleArn => (is => 'ro', isa => 'Str', request_name => 'roleArn', traits => ['NameInRequest']);
  has RoleType => (is => 'ro', isa => 'Str', request_name => 'roleType', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::Delegation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::Delegation object:

  $service_obj->Method(Att1 => { AssessmentId => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::Delegation object:

  $result = $service_obj->Method(...);
  $result->Att1->AssessmentId

=head1 DESCRIPTION

The assignment of a control set to a delegate for review.

=head1 ATTRIBUTES


=head2 AssessmentId => Str

The identifier for the associated assessment.


=head2 AssessmentName => Str

The name of the associated assessment.


=head2 Comment => Str

The comment related to the delegation.


=head2 ControlSetId => Str

The identifier for the associated control set.


=head2 CreatedBy => Str

The IAM user or role that created the delegation.


=head2 CreationTime => Str

Specifies when the delegation was created.


=head2 Id => Str

The unique identifier for the delegation.


=head2 LastUpdated => Str

Specifies when the delegation was last updated.


=head2 RoleArn => Str

The Amazon Resource Name (ARN) of the IAM role.


=head2 RoleType => Str

The type of customer persona.

In C<CreateAssessment>, C<roleType> can only be C<PROCESS_OWNER>.

In C<UpdateSettings>, C<roleType> can only be C<PROCESS_OWNER>.

In C<BatchCreateDelegationByAssessment>, C<roleType> can only be
C<RESOURCE_OWNER>.


=head2 Status => Str

The status of the delegation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

