/*
 * Decompiled with CFR 0.152.
 */
package be.fivebyfive.lingua.stanfordcorenlp;

import be.fivebyfive.lingua.stanfordcorenlp.PipelineItem;
import be.fivebyfive.lingua.stanfordcorenlp.PipelineToken;
import edu.stanford.nlp.trees.GrammaticalRelation;

public class PipelineDependency
extends PipelineItem {
    private PipelineToken governor;
    private PipelineToken dependent;
    private int govIndex;
    private int depIndex;
    private String relation;
    private String longRelation;

    public PipelineToken getGovernor() {
        return this.governor;
    }

    public PipelineToken getDependent() {
        return this.dependent;
    }

    public int getGovernorIndex() {
        return this.govIndex;
    }

    public int getDependentIndex() {
        return this.depIndex;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getLongRelation() {
        return this.longRelation;
    }

    public PipelineDependency(PipelineToken pipelineToken, PipelineToken pipelineToken2, int n, int n2, GrammaticalRelation grammaticalRelation) {
        this.governor = pipelineToken;
        this.dependent = pipelineToken2;
        this.govIndex = n;
        this.depIndex = n2;
        this.relation = grammaticalRelation.toString();
        this.longRelation = grammaticalRelation.getLongName();
    }

    @Override
    public String toCompactString() {
        return this.toCompactString(false);
    }

    public String toCompactString(boolean bl) {
        return this.relation + "(" + this.governor.getWord() + (bl ? "-" + this.govIndex : "") + ", " + this.dependent.getWord() + (bl ? "-" + this.depIndex : "") + ")";
    }

    public String toString(boolean bl) {
        return this.toCompactString(bl) + " [" + this.longRelation + "]";
    }

    public String toString() {
        return this.toString(true);
    }
}

