/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunction;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.optimization.CmdEvaluator;
import edu.stanford.nlp.stats.MultiClassChunkEvalStats;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;

public class CRFClassifierEvaluator<IN extends CoreMap>
extends CmdEvaluator {
    private CRFClassifier<IN> classifier;
    private CRFLogConditionalObjectiveFunction func;
    private String cmdStr = "/u/nlp/bin/conlleval -r";
    private String[] cmd;
    Collection<List<IN>> data;
    List<Pair<int[][][], int[]>> featurizedData;

    public CRFClassifierEvaluator(String description, CRFClassifier<IN> classifier, CRFLogConditionalObjectiveFunction func, Collection<List<IN>> data, List<Pair<int[][][], int[]>> featurizedData) {
        this.description = description;
        this.classifier = classifier;
        this.func = func;
        this.data = data;
        this.featurizedData = featurizedData;
        this.cmd = CRFClassifierEvaluator.getCmd(this.cmdStr);
    }

    public CRFClassifierEvaluator(String description, CRFClassifier<IN> classifier) {
        this.description = description;
        this.classifier = classifier;
    }

    public void setHelperFunction(CRFLogConditionalObjectiveFunction func) {
        this.func = func;
    }

    public void setTestData(Collection<List<IN>> data, List<Pair<int[][][], int[]>> featurizedData) {
        this.data = data;
        this.featurizedData = featurizedData;
    }

    public void setEvalCmd(String evalCmd) {
        this.cmdStr = evalCmd;
        if (this.cmdStr != null) {
            this.cmdStr = this.cmdStr.trim();
            if (this.cmdStr.length() == 0) {
                this.cmdStr = null;
            }
        }
        this.cmd = CRFClassifierEvaluator.getCmd(this.cmdStr);
    }

    @Override
    public void setValues(double[] x) {
        this.classifier.weights = this.func.to2D(x);
    }

    @Override
    public String[] getCmd() {
        return this.cmd;
    }

    @Override
    public void outputToCmd(OutputStream outputStream) {
        try {
            PrintWriter pw = IOUtils.encodedOutputStreamPrintWriter(outputStream, null, true);
            this.classifier.classifyAndWriteAnswers(this.data, this.featurizedData, pw, this.classifier.makeReaderAndWriter());
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    @Override
    public double evaluate(double[] x) {
        double score = 0.0;
        this.setValues(x);
        if (this.getCmd() != null) {
            this.evaluateCmd(this.getCmd());
        } else {
            try {
                File f = File.createTempFile("CRFClassifierEvaluator", "txt");
                f.deleteOnExit();
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(f));
                PrintWriter pw = IOUtils.encodedOutputStreamPrintWriter(outputStream, null, true);
                this.classifier.classifyAndWriteAnswers(this.data, this.featurizedData, pw, this.classifier.makeReaderAndWriter());
                ((OutputStream)outputStream).close();
                BufferedReader br = new BufferedReader(new FileReader(f));
                MultiClassChunkEvalStats stats = new MultiClassChunkEvalStats("O");
                score = stats.score(br, "\t");
                System.err.println(stats.getConllEvalString());
                f.delete();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return score;
    }
}

