/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Iterator;

public class CompositeTreebank
extends Treebank {
    private Treebank t1;
    private Treebank t2;

    public CompositeTreebank(Treebank t1, Treebank t2) {
        this.t1 = t1;
        this.t2 = t2;
    }

    @Override
    public void clear() {
        this.t1.clear();
        this.t2.clear();
    }

    @Override
    public void loadPath(File path, FileFilter filt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void apply(TreeVisitor tp) {
        for (Tree tree : this) {
            tp.visitTree(tree);
        }
    }

    @Override
    public Iterator<Tree> iterator() {
        return new CompositeTreebankIterator(this.t1, this.t2);
    }

    private static class CompositeTreebankIterator
    implements Iterator<Tree> {
        private final Iterator<Tree> it1;
        private final Iterator<Tree> it2;

        public CompositeTreebankIterator(Collection<Tree> c1, Collection<Tree> c2) {
            this.it1 = c1.iterator();
            this.it2 = c2.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it1.hasNext() || this.it2.hasNext();
        }

        @Override
        public Tree next() {
            Tree tree = this.it1.hasNext() ? this.it1.next() : this.it2.next();
            return tree;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

