package Mojolicious::Command::db_env;
use Mojo::Base 'Mojolicious::Command';


has description => 'Shell command to generate environment variables to access database';
has usage => sub { shift->extract_usage };


use C;



sub run {
	my( $self, @args ) =  @_;

	my $DB  =  C::config->{ DbAccess };
	$DB->{ DSN } =  sprintf "dbi:%s:dbname=%s;host=%s;port=%s",
		@$DB{ qw/ DRVR NAME HOST PORT / };

	print "DB_$_=$DB->{ $_ }\n"   for sort keys %$DB;
}

1;


=encoding utf8

=head1 NAME

Mojolicious::Command::db_env - Print database config as environment variables

=head1 SYNOPSIS

  Usage: APPLICATION db_env [OPTIONS]

  Options:
    NONE

=head1 DESCRIPTION

This command reads C<C::config-E<gt>{DbAccess}> and prints one line per config
key:

  DB_KEY=value

This is convenient for shell usage. For example, in a POSIX shell:

  eval "$(APPLICATION db_env)"

Note: this prints all keys, including passwords.

=head1 OPTIONS

None.

=head1 METHODS

=head2 run

Implements the command.

=head1 SEE ALSO

L<Mojolicious::Plugin::DbAccess>, L<D>

=cut
