#!/usr/local/bin/perl
#
$Header = "MAsearch.pl  Vers. 1.4.7 		- L.Fini, Aug 1995";
#
# -------
# See the CUSTOMIZATION SECTION in this script for things to change
# -------
#
# This program is invoked via http with method: GET or POST and with an 
# url like:
#
#   http://<address>/cgi-bin/MAsearch?DirPath=xxx&RegExp=yyy
#
# The procedure operates onto an archive generated by MailArchive.
#
# The procedure founds archive files containing strings matching the
# specified RegExp and returns an HTML formatted list of the files
# found with links to the archive files. The return format is the same
# as the list file generated by MailArchive.
#
# The query is intended to be performed by an HTML form where the
# archive specification can be set via a 'hidden' input tag.
# An example form can be found in file admlog.html
#
#----------------------------------------------------------------
# DEBUGGING AIDS.
#
# When invoking the procedure from a form, an input tag with name=Debug
# and value=1 can be added to get back useful information.
#
#
# The function may be called from an interactive shell as in the following 
# example:
#
# setenv REQUEST_METHOD GET
# setenv QUERY_STRING 'DirPath=xxx&RegExp=yyy&Case=1&Debug=1'
# MAsearch.pl
#
#----------------------------------------------------------------
# CREDITS
# This script uses the 'cgi-lib' package by Steven E. Brenner, with
# modifications by Meng Weng Wong.

#########################################################################
# CUSTOMIZATION SECTION - You may need to change the following paths 
#                         according to setting on your system

push(@INC,"/usr/local/etc/httpd/cgi-bin");	# path of cgi-lib.pl

$Glimpse = "/usr/local/bin/glimpse";		# path of glimpse
#########################################################################

$BeginFlag = '<!--Begin>';
$EndFlag = '<!--End>';

require 'cgi-lib.pl';

&ReadParse;

$RegExp=$in{Prefix}.$in{RegExp};
$Debug=$in{Debug};

$DirPath=$in{DirPath};			# The path to archive directory
#$wwwPath=$in{wwwPath};			# The path to archive directory
					# as seen from outside www client

if($DirPath =~ /\/$/) { chop $DirPath; }
#if($wwwPath =~ /\/$/) { chop $wwwPath; }

#if($wwwPath =~ /^\s*$/) { $wwwPath=$DirPath; }

$ListFile   = "$DirPath/index.html";
$ConfigFile = "$DirPath/.MAconfig";

if($in{'Case'}) {
	$case = '';
} else {
	$case = '-i';
}

if($in{SpellErrs}) {
	$Spell="-$in{SpellErrs}";
} else {
	$Spell='';
}

$|=1;

print "Content-type: text/html\n\n";
open(STDERR,">&STDOUT");


				###################################
if($Debug) { 			# Debugging section. 		  #
	print "<pre>\n";
	print "$Header\n";
	foreach $key (sort keys(%ENV)) {
		print "ENV> $key = $ENV{$key}\n";
	}
	foreach $key (sort keys(%in)) {
		print "INP> $key = $in{$key}\n"
	}

	print "\nDBG>   List File: $ListFile\n";
	print   "DBG> Config File: $ConfigFile\n";

	print "\n";						  #
} 				###################################

$FlatList=0;
$Glimpseup=0;
$ListLine='';
$ListHead='';
$ListTail='';
undef %AllYears;

if(open(TEMP,$ConfigFile) ) {
	while(<TEMP>) {
		if(/^Flat\s+List/i) {
			$FlatList=1;
		} elsif(/^Nested\s+List/i) {
			$FlatList=0;
		} elsif(/^List\s+Head:\s+([^#]+)\s*#?/i) {
			$ListHead=$1;
		} elsif(/^List\s+Tail:\s+([^#]+)\s*#?/i) {
			$ListTail=$1;
		} elsif(/^List\s+Line:\s+([^#]+)\s*#?/i) {
			$ListLine=$1;
		} elsif(/^Glimpseindex/i) {
			$Glimpseup=1;
		}
	}
	close TEMP;
	if($Debug) {
		print "DBG> From Config file.\nDBG> ";
		if($FlatList) {
			print "Flat";
		} else {
			print "Nested";
		}
		print " List\n";
		if($ListLine) { 
			local($ll) = $ListLine;
			$ll =~ s/\</&lt;/g;
			$ll =~ s/\>/&gt;/g;
			print "DBG> List Line: $ll\n";
		 }
		if($ListHead) { 
			local($ll) = $ListHead;
			$ll =~ s/\</&lt;/g;
			$ll =~ s/\>/&gt;/g;
			print "DBG> List Head: $ll\n"; 
		}
		if($ListTail) { 
			local($ll) = $ListTail;
			$ll =~ s/\</&lt;/g;
			$ll =~ s/\>/&gt;/g;
			print "DBG> List Tail: $ll\n"; 
		}
	}
} else {
	&ErrExit("Error opening config file: $ConfigFile");
}

if($Glimpseup) {
	$Cmd = "$Glimpse $Spell -y $case -l -H $DirPath -F '". '\.txt$' . "' -e '$RegExp' |";
} else {
	$Cmd = "grep -l $case " . "'$RegExp' $DirPath/[12][92][0-9][0-9]/*.txt |";
}

if($Debug) {
	print "DBG> Search Cmd: $Cmd\n";
}
	
unless(open(SEARCH,$Cmd)) {		# reading glimpse output
	&ErrExit("Error opening Search pipe: $Cmd");
}
while(<SEARCH>) {
	chop;
	if($Debug) {
		print "DBG> From Search: $_\n";
	}
	if(/\/(\d{4})\/([^\/]+)$/) {
		$Yr=$1;
		$AllYears{$Yr}=1;
		$HashN="f$Yr";
		push(@{$HashN},$2);
	}
}
if($Debug) {
	print "DBG> Reading from Search pipe ends\n";
}
close SEARCH;

if($FlatList) {		# Check wether it's a flat list
	undef %AllYears;
	$AllYears{0}=1;
}

$Cnt = 0;
&Header();

if($FlatList) {
	if(defined %AllYears) {
		$ListFile = "$DirPath/index.html";
		&Extract;
	}
} else {
	foreach $Yr (sort revnum keys %AllYears) {	# if found
		$ListFile = "$DirPath/${Yr}index.html";
		$HashN="f$Yr";
		&Extract;
	}
}

if($Cnt==0) {
	print "<h2> Nothing found</h2>\n";
} else {
	print "$EndFlag\n";
	if($ListTail) {
		print $ListTail, "\n";
	} else {
		print "</dl>\n";
	}
}

&Footer();
1;

sub Header {			# output HTML header
	if($Debug) { print "</pre>\n"; }
	print "<h1> Result of Search </h1>\n";
	print "<strong> Search string was:</strong> <code>$RegExp</code> <p>\n";
	if($ListHead) {
		print $ListHead, "\n";
	} else {
		print "<dl>\n";
	}
	print "$BeginFlag\n";
}

sub Footer {
	print "</body>\n";
	print "</html>\n";
}

sub Extract {			# Extracts lines from the archive index(es)
	local($l,$Fn);
	unless(open(INDEX,"$ListFile")) {
		&ErrExit("Error opening list file: $ListFile");
	}
	while(<INDEX>) {
		if(/$BeginFlag/) { last; }
	}
	while($l=<INDEX>) {
		if($l=~/$EndFlag/) { last; }
		
		if($l=~/href=.*\d{4}\/([^>]+)>/) {
			local(@a);
			$Fn=$1;	
			if(grep(/$Fn/,@{$HashN})) {
				$Cnt++;
#				$l=~ s/href=/href=$wwwPath\//;
				print $l;
			}
		}
	}
}

sub ErrExit {
	local($msg)=@_;
	print "<h1> Error Report: </h1>\n";
	print "<h3> $msg </h3>\n";
	print "</body></html>\n";
	exit;
}

sub revnum { $b <=> $a; }
