# This file was automatically generated by SWIG
package LWES;
require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
package LWESc;
bootstrap LWES;
package LWES;
@EXPORT = qw( );

# ---------- BASE METHODS -------------

package LWES;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package LWES;

*create_db = *LWESc::create_db;
*destroy_db = *LWESc::destroy_db;
*create_emitter = *LWESc::create_emitter;
*create_emitter_with_ttl = *LWESc::create_emitter_with_ttl;
*emit = *LWESc::emit;
*emitto = *LWESc::emitto;
*destroy_emitter = *LWESc::destroy_emitter;
*create_event = *LWESc::create_event;
*create_event_with_encoding = *LWESc::create_event_with_encoding;
*set_uint16 = *LWESc::set_uint16;
*get_uint16 = *LWESc::get_uint16;
*set_int16 = *LWESc::set_int16;
*get_int16 = *LWESc::get_int16;
*set_uint32 = *LWESc::set_uint32;
*get_uint32 = *LWESc::get_uint32;
*set_int32 = *LWESc::set_int32;
*get_int32 = *LWESc::get_int32;
*set_uint64 = *LWESc::set_uint64;
*get_uint64 = *LWESc::get_uint64;
*set_int64 = *LWESc::set_int64;
*get_int64 = *LWESc::get_int64;
*set_string = *LWESc::set_string;
*get_string = *LWESc::get_string;
*set_ip_addr = *LWESc::set_ip_addr;
*get_ip_addr = *LWESc::get_ip_addr;
*set_boolean = *LWESc::set_boolean;
*get_boolean = *LWESc::get_boolean;
*destroy_event = *LWESc::destroy_event;
*current_time_millis = *LWESc::current_time_millis;

# ------- VARIABLE STUBS --------

package LWES;



=head1 NAME

LWES - Perl extension for the Light Weight Event System

=head1 SYNOPSIS

  use LWES;
  use LWES::EventParser;
  use IO::Socket::Multicast;

  my $LWES_ADDRESS = "224.1.1.1";
  my $LWES_PORT = 9000;

  # load an event schema from a file to validate events
  my $event_db = LWES::create_db("eventTypes.esf");

  # create an emitter for sending events
  my $emitter = LWES::create_emitter($LWES_ADDRESS, 0, $LWES_PORT, 0, 60);

  # create an event and validate it against the DB
  my $event = LWES::create_event($event_db, "MyEvent");

  # or create an unvalidated event
  my $event2 = LWES::create_event(undef, "MyOtherEvent");

  # set some fields
  LWES::set_string($event, "MyField", "MyValue");
  LWES::set_int32($event2, "MyNumber", 123);

  # emit the events
  LWES::emit($emitter, $event);
  LWES::emit($emitter, $event2);

  # listen to some events on the network
  my $socket = IO::Socket::Multicast->new(LocalPort => $LWES_PORT,
                                          Reuse     => 1);
  $socket->mcast_add($LWES_ADDRESS);
  my ($message, $peer);
  $peer = recv($socket, $message, 65535, 0);
  my ($port, $peeraddr) = sockaddr_in($peer);

  # deserialize the event into a perl hash
  my $event = bytesToEvent($message);

  # access the various event fields
  my $data = $event->{'MyField'}; 

  # cleanup
  LWES::destroy_event($event);
  LWES::destroy_emitter($emitter);
  LWES::destroy_db($event_db);

=head1 DESCRIPTION

This is the Perl interface to the Light Weight Event System.  The
Light Weight Event System is a UDP-based communication toolkit with
built-in serialization, formatting, and type-checking.

=head1 EXPORT

None by default.

=head1 AUTHOR

Anthony Molinaro, E<lt>molinaro@users.sourceforge.netE<gt>
Michael P. Lum, E<lt>mlum@users.sourceforge.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 Light Weight Event System
All rights reserved.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

=cut

1;
