#!perl -T

use warnings;
use strict;

use Test::More tests => 6;
use Test::Exception;

use Test::MockFile::Light module => 'main';

can_ok('main', qw/define_file_mocker undefine_file_mocker/);

throws_ok {
	define_file_mocker;
} qr/The first parameter should be the name of the file to be mocked/
, 'attempting to call define_file_mocker() with invalid parameter';

throws_ok {
	undefine_file_mocker;
} qr/The first parameter should be the name of the file to be mocked/
, 'attempting to call undefine_file_mocker() with invalid parameter';

my $fh;
my $input_file_name = 'input_data.txt';
my $input_content = '...';

throws_ok {
	open $fh, '<', $input_file_name or die $!;
} qr/No such file or directory/, 'attempting to open nonexisting file mocker';

define_file_mocker($input_file_name, $input_content);

lives_ok {
	open $fh, '<', $input_file_name or die $!;
} 'opening file mocker';

undefine_file_mocker($input_file_name);

throws_ok {
	open $fh, '<', $input_file_name or die $!;
} qr/No such file or directory/, 'attempting to open deleted file mocker';
