unit module Locale::Codes::Language_Codes;

my $data = q{
AA:AAR:AAR:Afar
AB:ABK:ABK:Abkhazian
AE:AVE:AVE:Avestan
AF:AFR:AFR:Afrikaans
AK:AKA:AKA:Akan
AM:AMH:AMH:Amharic
AN:ARG:ARG:Aragonese
AR:ARA:ARA:Arabic
AS:ASM:ASM:Assamese
AV:AVA:AVA:Avaric
AY:AYM:AYM:Aymara
AZ:AZE:AZE:Azerbaijani
BA:BAK:BAK:Bashkir
BE:BEL:BEL:Belarusian
BG:BUL:BUL:Bulgarian
BH:BIH:BIH:Bihari languages
BI:BIS:BIS:Bislama
BM:BAM:BAM:Bambara
BN:BEN:BEN:Bengali
BO:TIB:BOD:Tibetan
BR:BRE:BRE:Breton
BS:BOS:BOS:Bosnian
CA:CAT:CAT:Catalan
CE:CHE:CHE:Chechen
CH:CHA:CHA:Chamorro
CO:COS:COS:Corsican
CR:CRE:CRE:Cree
CS:CZE:CES:Czech
CU:CHU:CHU:Church Slavic
CV:CHV:CHV:Chuvash
CY:WEL:CYM:Welsh
DA:DAN:DAN:Danish
DE:GER:DEU:German
DV:::Dhivehi
DZ:DZO:DZO:Dzongkha
EE:EWE:EWE:Ewe
EL:::Modern Greek (1453-)
EN:ENG:ENG:English
EO:EPO:EPO:Esperanto
ES:SPA:SPA:Spanish
ET:EST:EST:Estonian
EU:BAQ:EUS:Basque
FA:PER:FAS:Persian
FF:FUL:FUL:Fulah
FI:FIN:FIN:Finnish
FJ:FIJ:FIJ:Fijian
FO:FAO:FAO:Faroese
FR:FRE:FRA:French
FY:FRY:FRY:Western Frisian
GA:GLE:GLE:Irish
GD:::Scottish Gaelic
GL:GLG:GLG:Galician
GN:GRN:GRN:Guarani
GU:GUJ:GUJ:Gujarati
GV:GLV:GLV:Manx
HA:HAU:HAU:Hausa
HE:HEB:HEB:Hebrew
HI:HIN:HIN:Hindi
HO:HMO:HMO:Hiri Motu
HR:HRV:HRV:Croatian
HT:HAT:HAT:Haitian
HU:HUN:HUN:Hungarian
HY:ARM:HYE:Armenian
HZ:HER:HER:Herero
IA:INA:INA:Interlingua (International Auxiliary Language Association)
ID:IND:IND:Indonesian
IE:ILE:ILE:Interlingue
IG:IBO:IBO:Igbo
II:III:III:Sichuan Yi
IK:IPK:IPK:Inupiaq
IO:IDO:IDO:Ido
IS:ICE:ISL:Icelandic
IT:ITA:ITA:Italian
IU:IKU:IKU:Inuktitut
JA:JPN:JPN:Japanese
JV:JAV:JAV:Javanese
KA:GEO:KAT:Georgian
KG:KON:KON:Kongo
KI:KIK:KIK:Kikuyu
KJ:KUA:KUA:Kuanyama
KK:KAZ:KAZ:Kazakh
KL:KAL:KAL:Kalaallisut
KM:KHM:KHM:Central Khmer
KN:KAN:KAN:Kannada
KO:KOR:KOR:Korean
KR:KAU:KAU:Kanuri
KS:KAS:KAS:Kashmiri
KU:KUR:KUR:Kurdish
KV:KOM:KOM:Komi
KW:COR:COR:Cornish
KY:KIR:KIR:Kirghiz
LA:LAT:LAT:Latin
LB:LTZ:LTZ:Luxembourgish
LG:LUG:LUG:Ganda
LI:LIM:LIM:Limburgan
LN:LIN:LIN:Lingala
LO:LAO:LAO:Lao
LT:LIT:LIT:Lithuanian
LU:LUB:LUB:Luba-Katanga
LV:LAV:LAV:Latvian
MG:MLG:MLG:Malagasy
MH:MAH:MAH:Marshallese
MI:MAO:MRI:Maori
MK:MAC:MKD:Macedonian
ML:MAL:MAL:Malayalam
MN:MON:MON:Mongolian
MR:MAR:MAR:Marathi
MS:::Malay (macrolanguage)
MT:MLT:MLT:Maltese
MY:BUR:MYA:Burmese
NA:NAU:NAU:Nauru
NB:::Norwegian Bokmal
ND:::North Ndebele
NE:::Nepali (macrolanguage)
NG:NDO:NDO:Ndonga
NL:DUT:NLD:Dutch
NN:NNO:NNO:Norwegian Nynorsk
NO:NOR:NOR:Norwegian
NR:::South Ndebele
NV:NAV:NAV:Navajo
NY:::Nyanja
OC:OCI:OCI:Occitan (post 1500)
OJ:OJI:OJI:Ojibwa
OM:ORM:ORM:Oromo
OR:::Oriya (macrolanguage)
OS:OSS:OSS:Ossetian
PA:PAN:PAN:Panjabi
PI:PLI:PLI:Pali
PL:POL:POL:Polish
PS:PUS:PUS:Pushto
PT:POR:POR:Portuguese
QU:QUE:QUE:Quechua
RM:ROH:ROH:Romansh
RN:RUN:RUN:Rundi
RO:RUM:RON:Romanian
RU:RUS:RUS:Russian
RW:KIN:KIN:Kinyarwanda
SA:SAN:SAN:Sanskrit
SC:SRD:SRD:Sardinian
SD:SND:SND:Sindhi
SE:SME:SME:Northern Sami
SG:SAG:SAG:Sango
SH:::Serbo-Croatian
SI:SIN:SIN:Sinhala
SK:SLO:SLK:Slovak
SL:SLV:SLV:Slovenian
SM:SMO:SMO:Samoan
SN:SNA:SNA:Shona
SO:SOM:SOM:Somali
SQ:ALB:SQI:Albanian
SR:SRP:SRP:Serbian
SS:SSW:SSW:Swati
ST:::Southern Sotho
SU:SUN:SUN:Sundanese
SV:SWE:SWE:Swedish
SW:::Swahili (macrolanguage)
TA:TAM:TAM:Tamil
TE:TEL:TEL:Telugu
TG:TGK:TGK:Tajik
TH:THA:THA:Thai
TI:TIR:TIR:Tigrinya
TK:TUK:TUK:Turkmen
TL:TGL:TGL:Tagalog
TN:TSN:TSN:Tswana
TO:TON:TON:Tonga (Tonga Islands)
TR:TUR:TUR:Turkish
TS:TSO:TSO:Tsonga
TT:TAT:TAT:Tatar
TW:TWI:TWI:Twi
TY:TAH:TAH:Tahitian
UG:UIG:UIG:Uighur
UK:UKR:UKR:Ukrainian
UR:URD:URD:Urdu
UZ:UZB:UZB:Uzbek
VE:VEN:VEN:Venda
VI:VIE:VIE:Vietnamese
VO:VOL:VOL:Volapuk
WA:WLN:WLN:Walloon
WO:WOL:WOL:Wolof
XH:XHO:XHO:Xhosa
YI:YID:YID:Yiddish
YO:YOR:YOR:Yoruba
ZA:ZHA:ZHA:Zhuang
ZH:CHI:ZHO:Chinese
ZU:ZUL:ZUL:Zulu
};

our %data;
for $data.trim.split("\n") -> $line {
    my @parts = $line.split(':');
    %data<code><alpha-2>{@parts[0]} = @parts[3];
    %data<code><alpha-3>{@parts[1]} = @parts[3] if @parts[1].chars;
    %data<code><term>{@parts[2]}    = @parts[3] if @parts[2].chars;
    %data<name><alpha-2>{lc @parts[3]} = @parts[0];
    %data<name><alpha-3>{lc @parts[3]} = @parts[1] if @parts[1].chars;
    %data<name><term>{lc @parts[3]}    = @parts[2] if @parts[2].chars;
}

