#!/usr/bin/perl

package eBay::API::XML::Call::GetItemShipping;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetItemShipping.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetItemShipping

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetItemShipping inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetItemShipping::GetItemShippingRequestType;
use eBay::API::XML::Call::GetItemShipping::GetItemShippingResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetItemShipping';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetItemShipping::GetItemShippingRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetItemShipping::GetItemShippingResponseType';
}

#
# input properties
#

=head2 setDestinationCountryCode()

Destination country code. If DestinationCountryCode is US,
postal code is required and represents US zip code.

Default: US

  RequiredInput: Conditionally
#    Argument: 'ns:CountryCodeType'

=cut
       
sub setDestinationCountryCode {
   my $self   = shift;
   my $sDestinationCountryCode = shift;
   $self->getRequestDataType()->setDestinationCountryCode($sDestinationCountryCode);
}

=head2 setDestinationPostalCode()

Destination country postal code (or zipcode, for US). Ignored if no
country code is provided. Optional tag for some countries. More likely to
be required for large countries.

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setDestinationPostalCode {
   my $self   = shift;
   my $sDestinationPostalCode = shift;
   $self->getRequestDataType()->setDestinationPostalCode($sDestinationPostalCode);
}

=head2 setItemID()

The item ID that uniquely identifies the item listing for which
to retrieve the data. Required input.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setQuantitySold()

Number of items sold to a single buyer and to be shipped together.

  RequiredInput: No
#    Argument: 'xs:int'

=cut
       
sub setQuantitySold {
   my $self   = shift;
   my $sQuantitySold = shift;
   $self->getRequestDataType()->setQuantitySold($sQuantitySold);
}



#
# output properties
#

=head2 getShippingDetails()

Shipping-related details for the specified item. Any error about shipping services
(returned by a vendor of eBay's who calculates shipping costs) is returned in
ShippingRateErrorMessage. Errors from a shipping service are likely to be related to
issues with shipping specifications, such as package size and the selected shipping
method not supported by a particular shipping service.<br>
<br>It is possible for a seller to offer a shipping service which turns out
to be a mismatch in some way with the item(s) being shipped. For example, if a
buyer purchases more than one of an item, the weight might be too great for First
Class mail. In such a case, GetItemShipping will omit that shipping service from
the response.

  Returned: Always
#    Returns: 'ns:ShippingDetailsType'

=cut
       
sub getShippingDetails {
   my $self = shift;
   return $self->getResponseDataType()->getShippingDetails();
}





1;   
