#!/usr/bin/perl

package eBay::API::XML::Call::GetNotificationPreferences::GetNotificationPreferencesResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetNotificationPreferencesResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetNotificationPreferences::GetNotificationPreferencesResponseType

=head1 DESCRIPTION

Contains the requesting application's notification preferences.
GetNotificationPreferences retrieves preferences that you have
deliberately set. For example, if you enable the EndOfAuction event and
then later disable it, the response shows the EndOfAuction event
preference as Disabled. But if you have never set a preference for the
EndOfAuction event, no EndOfAuction preference is returned at all.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetNotificationPreferences::GetNotificationPreferencesResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::ApplicationDeliveryPreferencesType;
use eBay::API::XML::DataType::NotificationEnableArrayType;
use eBay::API::XML::DataType::NotificationEventPropertyType;
use eBay::API::XML::DataType::NotificationUserDataType;


my @gaProperties = ( [ 'ApplicationDeliveryPreferences', 'ns:ApplicationDeliveryPreferencesType', ''
	     ,'eBay::API::XML::DataType::ApplicationDeliveryPreferencesType', '1' ]
	, [ 'DeliveryURLName', 'xs:string', '', '', '' ]
	, [ 'EventProperty', 'ns:NotificationEventPropertyType', '1'
	     ,'eBay::API::XML::DataType::NotificationEventPropertyType', '1' ]
	, [ 'UserData', 'ns:NotificationUserDataType', ''
	     ,'eBay::API::XML::DataType::NotificationUserDataType', '1' ]
	, [ 'UserDeliveryPreferenceArray', 'ns:NotificationEnableArrayType', ''
	     ,'eBay::API::XML::DataType::NotificationEnableArrayType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setApplicationDeliveryPreferences()

Specifies application-based event preferences that have been enabled.

#    Argument: 'ns:ApplicationDeliveryPreferencesType'

=cut

sub setApplicationDeliveryPreferences {
  my $self = shift;
  $self->{'ApplicationDeliveryPreferences'} = shift
}

=head2 getApplicationDeliveryPreferences()

  Returned: Conditionally
#    Returns: 'ns:ApplicationDeliveryPreferencesType'

=cut

sub getApplicationDeliveryPreferences {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ApplicationDeliveryPreferences'
		,'eBay::API::XML::DataType::ApplicationDeliveryPreferencesType');
}


=head2 setDeliveryURLName()

Specifies application delivery URL Name associated with this user.

#    Argument: 'xs:string'

=cut

sub setDeliveryURLName {
  my $self = shift;
  $self->{'DeliveryURLName'} = shift
}

=head2 getDeliveryURLName()

  Returned: Conditionally
#    Returns: 'xs:string'

=cut

sub getDeliveryURLName {
  my $self = shift;
  return $self->{'DeliveryURLName'};
}


=head2 setEventProperty()

Characteristics or details of an event such as type, name and value.

#    Argument: reference to an array  
                      of 'ns:NotificationEventPropertyType'

=cut

sub setEventProperty {
  my $self = shift;
  $self->{'EventProperty'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getEventProperty()

  Returned: Conditionally
#    Returns: reference to an array  
                      of 'ns:NotificationEventPropertyType'

=cut

sub getEventProperty {
  my $self = shift;
  return $self->_getDataTypeArray('EventProperty');
}


=head2 setUserData()

return user data for notification settings such as set mobile phone number etc.

#    Argument: 'ns:NotificationUserDataType'

=cut

sub setUserData {
  my $self = shift;
  $self->{'UserData'} = shift
}

=head2 getUserData()

  Returned: Conditionally
#    Returns: 'ns:NotificationUserDataType'

=cut

sub getUserData {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserData'
		,'eBay::API::XML::DataType::NotificationUserDataType');
}


=head2 setUserDeliveryPreferenceArray()

Specifies user-based event preferences that have been enabled or disabled.

#    Argument: 'ns:NotificationEnableArrayType'

=cut

sub setUserDeliveryPreferenceArray {
  my $self = shift;
  $self->{'UserDeliveryPreferenceArray'} = shift
}

=head2 getUserDeliveryPreferenceArray()

  Returned: Conditionally
#    Returns: 'ns:NotificationEnableArrayType'

=cut

sub getUserDeliveryPreferenceArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserDeliveryPreferenceArray'
		,'eBay::API::XML::DataType::NotificationEnableArrayType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
