#!/usr/bin/perl

package eBay::API::XML::Call::ApproveLiveAuctionBidders;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ApproveLiveAuctionBidders.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::ApproveLiveAuctionBidders

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::ApproveLiveAuctionBidders inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::ApproveLiveAuctionBidders::ApproveLiveAuctionBiddersRequestType;
use eBay::API::XML::Call::ApproveLiveAuctionBidders::ApproveLiveAuctionBiddersResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'ApproveLiveAuctionBidders';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::ApproveLiveAuctionBidders::ApproveLiveAuctionBiddersRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::ApproveLiveAuctionBidders::ApproveLiveAuctionBiddersResponseType';
}

#
# input properties
#

=head2 setAllApprovedBiddingLimit()

This is the amount that bidders are beings approved for.
This is required if user has set ApproveAllPending to true.
It only applies to bidder requests that are in pending status.

  RequiredInput: Conditionally
#    Argument: 'ns:AmountType'

=cut
       
sub setAllApprovedBiddingLimit {
   my $self   = shift;
   my $pAllApprovedBiddingLimit = shift;
   $self->getRequestDataType()->setAllApprovedBiddingLimit($pAllApprovedBiddingLimit);
}

=head2 setApproveAllPending()

This will approve all bidders in the catalog in the pending status only.
This is an optional field. If provided and set to true, do not send BidApproval.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setApproveAllPending {
   my $self   = shift;
   my $sApproveAllPending = shift;
   $self->getRequestDataType()->setApproveAllPending($sApproveAllPending);
}

=head2 setBidApproval()

Approval details for a specific set of bidders.

  RequiredInput: No
#    Argument: 'ns:BidApprovalArrayType'

=cut
       
sub setBidApproval {
   my $self   = shift;
   my $pBidApproval = shift;
   $self->getRequestDataType()->setBidApproval($pBidApproval);
}

=head2 setUserCatalogID()

Number that identifies the seller's eBay Live Auctions catalog for which
they want to set bidding limits and approve or decline bidders.

  RequiredInput: Yes
#    Argument: 'xs:int'

=cut
       
sub setUserCatalogID {
   my $self   = shift;
   my $sUserCatalogID = shift;
   $self->getRequestDataType()->setUserCatalogID($sUserCatalogID);
}



#
# output properties
#

=head2 getBidderUpdateStatus()

Contains the results of the request for each item.
Mulitple bidders can be approved with one call.

  Returned: Always
#    Returns: 'ns:LiveAuctionApprovalStatusArrayType'

=cut
       
sub getBidderUpdateStatus {
   my $self = shift;
   return $self->getResponseDataType()->getBidderUpdateStatus();
}





1;   
