#!/usr/bin/perl

package eBay::API::XML::Call::GetCategoryMappings::GetCategoryMappingsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCategoryMappingsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCategoryMappings::GetCategoryMappingsRequestType

=head1 DESCRIPTION

Retrieves a map of old category IDs and corresponding active
category IDs defined for the site to which the request is sent.
Typically used to update an older item definition with a new
category ID prior to listing the item.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCategoryMappings::GetCategoryMappingsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");



my @gaProperties = ( [ 'CategoryVersion', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryVersion()

A version of the category mapping for the site. Filters
out data from the call to return only the category
mappings for which the data has changed since the
specified version. If not specified, all category
mappings are returned. Typically, an application passes
the version value of the last set of category mappings
that the application stored locally. The latest version
value is not necessarily greater than the previous value
that was returned. Therefore, when comparing versions,
only compare whether the value has changed.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setCategoryVersion {
  my $self = shift;
  $self->{'CategoryVersion'} = shift
}

=head2 getCategoryVersion()

#    Returns: 'xs:string'

=cut

sub getCategoryVersion {
  my $self = shift;
  return $self->{'CategoryVersion'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
