#!/usr/bin/env perl

use strict;
use warnings;

use Module::Build;

my $abstraction = <<DESCRIPTION;
Bandana - a light and powerful web framework
DESCRIPTION

my %dist_info = (
    dist_version  => 0.01,
    dist_name     => 'Bandana',
    dist_author   => 'backslash001',
    dist_abstract => $abstraction,
);

my %contact_info = (
    author => 'backslash001',
    email  => 'telegin.vlad132@gmail.com',
);

my %module_info = (
    name         => 'Bandana',
    version      => 0.01,
    license      => 'perl_5',
    release_type => 'unstable',
    module_name  => 'Bandana',
);

my $module = Module::Build->new(
    %dist_info,
    %contact_info,
    %module_info,
    requires     => {
        'Test::Spec' => 0.54,
    },
);

$module->create_build_script();
$module->create_license();
$module->create_makefile_pl();
$module->create_mymeta();
$module->create_packlist();
$module->create_readme();