#! /usr/bin/env false

use v6.d;

use App::Rakuman;

unit module App::Rakuman::Bin;

#| Render a Raku module's main Pod6 document.
multi sub MAIN (
	#| Name of a Raku module, or a path to a file.
	Str:D $document,

	#| Don't pipe the output through a pager.
	Bool:D :$skip-pager = False,
) is export {
	exit rakuman(
		$document,
		:$skip-pager,
		try-resolving => !($document.IO.f),
	);
}

=begin pod

=NAME    App::Rakuman::Bin
=AUTHOR  Patrick Spek <p.spek@tyil.work>
=VERSION 0.1.0

=head1 Synopsis

=head1 Description

=head1 Examples

=head1 See also

=end pod

# vim: ft=perl6 noet
