# Generated by default/object.tt
package Paws::SageMaker::LabelingJobSnsDataSource;
  use Moose;
  has SnsTopicArn => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::LabelingJobSnsDataSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::LabelingJobSnsDataSource object:

  $service_obj->Method(Att1 => { SnsTopicArn => $value, ..., SnsTopicArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::LabelingJobSnsDataSource object:

  $result = $service_obj->Method(...);
  $result->Att1->SnsTopicArn

=head1 DESCRIPTION

An Amazon SNS data source used for streaming labeling jobs.

=head1 ATTRIBUTES


=head2 B<REQUIRED> SnsTopicArn => Str

The Amazon SNS input topic Amazon Resource Name (ARN). Specify the ARN
of the input topic you will use to send new data objects to a streaming
labeling job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

