/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.BinaryStoreCommand;
import org.couchbase.mock.memcached.protocol.BinaryStoreResponse;
import org.couchbase.mock.memcached.protocol.CommandCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

class AppendCommandExecutor
implements CommandExecutor {
    AppendCommandExecutor() {
    }

    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        BinaryStoreCommand command = (BinaryStoreCommand)cmd;
        ErrorCode err = ErrorCode.SUCCESS;
        Item item = command.getItem();
        Item existing = server.getDatastore().get(server, cmd.getVBucketId(), cmd.getKey());
        if (existing == null) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.NOT_STORED));
            return;
        }
        existing.append(item);
        err = server.getDatastore().replace(server, cmd.getVBucketId(), existing);
        if (err == ErrorCode.SUCCESS && cmd.getComCode() == CommandCode.APPENDQ) {
            return;
        }
        client.sendResponse(new BinaryStoreResponse(command, err, existing.getCas()));
    }
}

