package Bundle::Math::Approx;
use strict;
use warnings;

$VERSION = '1.00';

1;

__END__

=head1 NAME

Bundle::Math::Approx - Bundle related to interpolation and approximation

=head1 SYNOPSIS

 perl -MCPAN -e 'install Bundle::Math::Approx'

=head1 CONTENTS

Math::Approx

Math::Approx::Symbolic

Math::Bezier

Math::Bezier::Convert

Math::CatmullRom

Math::Gradient

Math::Interpolate

Math::Round

Math::RungeKutta

Math::SigFigs

Math::Spline

=head1 DESCRIPTION

This is a bundle of modules related to interpolation and approximation of
functions and data.

Please have a look at L<Bundle::Math>.

If you would like to see a specific module included in a future version of
this bundle, please send me an email or use rt.cpan.org.

=head1 AUTHOR

Steffen Mueller E<lt>bundlemath-module at steffen-mueller dot netE<gt>

=cut 
