package HTML::Dojo::editions;
1;
__DATA__
__CPAN_EDITION__ ajax dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:3,flag:"",revision:Number("$Rev: 8617 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
dojo.hostenv._djInitFired=false;
function dj_load_init(e){
dojo.hostenv._djInitFired=true;
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_f4,_f5){
var out="";
for(var i=0;i<_f4;i++){
out+=str;
if(_f5&&i<_f4-1){
out+=_f5;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_103,_104){
if(!dojo.lang.isFunction(_104)){
dojo.raise("dojo.inherits: superclass argument ["+_104+"] must be a function (subclass: ["+_103+"']");
}
_103.prototype=new _104();
_103.prototype.constructor=_103;
_103.superclass=_104.prototype;
_103["super"]=_104.prototype;
};
dojo.lang._mixin=function(obj,_106){
var tobj={};
for(var x in _106){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_106[x])){
obj[x]=_106[x];
}
}
if(dojo.render.html.ie&&(typeof (_106["toString"])=="function")&&(_106["toString"]!=obj["toString"])&&(_106["toString"]!=tobj["toString"])){
obj.toString=_106.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_10a){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_10d,_10e){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_10d.prototype,arguments[i]);
}
return _10d;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_111,_112,_113,_114){
if(!dojo.lang.isArrayLike(_111)&&dojo.lang.isArrayLike(_112)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_111;
_111=_112;
_112=temp;
}
var _116=dojo.lang.isString(_111);
if(_116){
_111=_111.split("");
}
if(_114){
var step=-1;
var i=_111.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_111.length;
}
if(_113){
while(i!=end){
if(_111[i]===_112){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_111[i]==_112){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_11a,_11b,_11c){
return dojo.lang.find(_11a,_11b,_11c,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_11d,_11e){
return dojo.lang.find(_11d,_11e)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_12a){
var _12b=window,_12c=2;
if(!dojo.lang.isFunction(func)){
_12b=func;
func=_12a;
_12a=arguments[2];
_12c++;
}
if(dojo.lang.isString(func)){
func=_12b[func];
}
var args=[];
for(var i=_12c;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_12b,args);
},_12a);
};
dojo.lang.clearTimeout=function(_12f){
dojo.global().clearTimeout(_12f);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_138,_139,_13a){
with(dojo.parseObjPath(_138,_139,_13a)){
return dojo.evalProp(prop,obj,_13a);
}
};
dojo.lang.setObjPathValue=function(_13b,_13c,_13d,_13e){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_13e=true;
}
with(dojo.parseObjPath(_13b,_13d,_13e)){
if(obj&&(_13e||(prop in obj))){
obj[prop]=_13c;
}
}
};
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_140,_141,_142){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_140){
this.mimetype=_140;
}
if(_141){
this.transport=_141;
}
if(arguments.length>=4){
this.changeUrl=_142;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,jsonFilter:function(_143){
if((this.mimetype=="text/json-comment-filtered")||(this.mimetype=="application/json-comment-filtered")){
var _144=_143.indexOf("/*");
var _145=_143.lastIndexOf("*/");
if((_144==-1)||(_145==-1)){
dojo.debug("your JSON wasn't comment filtered!");
return "";
}
return _143.substring(_144+2,_145);
}
dojo.debug("please consider using a mimetype of text/json-comment-filtered to avoid potential security issues with JSON endpoints");
return _143;
},load:function(type,data,_148,_149){
},error:function(type,_14b,_14c,_14d){
},timeout:function(type,_14f,_150,_151){
},handle:function(type,data,_154,_155){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_156){
if(_156["url"]){
_156.url=_156.url.toString();
}
if(_156["formNode"]){
_156.formNode=dojo.byId(_156.formNode);
}
if(!_156["method"]&&_156["formNode"]&&_156["formNode"].method){
_156.method=_156["formNode"].method;
}
if(!_156["handle"]&&_156["handler"]){
_156.handle=_156.handler;
}
if(!_156["load"]&&_156["loaded"]){
_156.load=_156.loaded;
}
if(!_156["changeUrl"]&&_156["changeURL"]){
_156.changeUrl=_156.changeURL;
}
_156.encoding=dojo.lang.firstValued(_156["encoding"],djConfig["bindEncoding"],"");
_156.sendTransport=dojo.lang.firstValued(_156["sendTransport"],djConfig["ioSendTransport"],false);
var _157=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_156[fn]&&_157(_156[fn])){
continue;
}
if(_156["handle"]&&_157(_156["handle"])){
_156[fn]=_156.handle;
}
}
dojo.lang.mixin(this,_156);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_15e){
if(!(_15e instanceof dojo.io.Request)){
try{
_15e=new dojo.io.Request(_15e);
}
catch(e){
dojo.debug(e);
}
}
var _15f="";
if(_15e["transport"]){
_15f=_15e["transport"];
if(!this[_15f]){
dojo.io.sendBindError(_15e,"No dojo.io.bind() transport with name '"+_15e["transport"]+"'.");
return _15e;
}
if(!this[_15f].canHandle(_15e)){
dojo.io.sendBindError(_15e,"dojo.io.bind() transport with name '"+_15e["transport"]+"' cannot handle this type of request.");
return _15e;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_15e))){
_15f=tmp;
break;
}
}
if(_15f==""){
dojo.io.sendBindError(_15e,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _15e;
}
}
this[_15f].bind(_15e);
_15e.bindSuccess=true;
return _15e;
};
dojo.io.sendBindError=function(_162,_163){
if((typeof _162.error=="function"||typeof _162.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _164=new dojo.io.Error(_163);
setTimeout(function(){
_162[(typeof _162.error=="function")?"error":"handle"]("error",_164,null,_162);
},50);
}else{
dojo.raise(_163);
}
};
dojo.io.queueBind=function(_165){
if(!(_165 instanceof dojo.io.Request)){
try{
_165=new dojo.io.Request(_165);
}
catch(e){
dojo.debug(e);
}
}
var _166=_165.load;
_165.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_166.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _168=_165.error;
_165.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_168.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_165);
dojo.io._dispatchNextQueueBind();
return _165;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_16b,last){
var enc=/utf/i.test(_16b||"")?encodeURIComponent:dojo.string.encodeAscii;
var _16e=[];
var _16f=new Object();
for(var name in map){
var _171=function(elt){
var val=enc(name)+"="+enc(elt);
_16e[(last==name)?"push":"unshift"](val);
};
if(!_16f[name]){
var _174=map[name];
if(dojo.lang.isArray(_174)){
dojo.lang.forEach(_174,_171);
}else{
_171(_174);
}
}
}
return _16e.join("&");
};
dojo.io.setIFrameSrc=function(_175,src,_177){
try{
var r=dojo.render.html;
if(!_177){
if(r.safari){
_175.location=src;
}else{
frames[_175.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_175.contentWindow.document;
}else{
if(r.safari){
idoc=_175.document;
}else{
idoc=_175.contentWindow;
}
}
if(!idoc){
_175.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _17e=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_17e++;
break;
}
}
return _17e==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_182){
var _183=dojo.lang.isString(arr);
if(_183){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_182)){
_182=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_182){
var _184=obj;
obj=_182;
_182=_184;
}
}
if(Array.map){
var _185=Array.map(arr,_182,obj);
}else{
var _185=[];
for(var i=0;i<arr.length;++i){
_185.push(_182.call(obj,arr[i]));
}
}
if(_183){
return _185.join("");
}else{
return _185;
}
},reduce:function(arr,_188,obj,_18a){
var _18b=_188;
if(arguments.length==2){
_18a=_188;
_18b=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_18a=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_18a;
_18a=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_18b=_18a.call(ob,_18b,val);
});
return _18b;
},forEach:function(_18f,_190,_191){
if(dojo.lang.isString(_18f)){
_18f=_18f.split("");
}
if(Array.forEach){
Array.forEach(_18f,_190,_191);
}else{
if(!_191){
_191=dj_global;
}
for(var i=0,l=_18f.length;i<l;i++){
_190.call(_191,_18f[i],i,_18f);
}
}
},_everyOrSome:function(_194,arr,_196,_197){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_194?"every":"some"](arr,_196,_197);
}else{
if(!_197){
_197=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _19a=_196.call(_197,arr[i],i,arr);
if(_194&&!_19a){
return false;
}else{
if((!_194)&&(_19a)){
return true;
}
}
}
return Boolean(_194);
}
},every:function(arr,_19c,_19d){
return this._everyOrSome(true,arr,_19c,_19d);
},some:function(arr,_19f,_1a0){
return this._everyOrSome(false,arr,_19f,_1a0);
},filter:function(arr,_1a2,_1a3){
var _1a4=dojo.lang.isString(arr);
if(_1a4){
arr=arr.split("");
}
var _1a5;
if(Array.filter){
_1a5=Array.filter(arr,_1a2,_1a3);
}else{
if(!_1a3){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_1a3=dj_global;
}
_1a5=[];
for(var i=0;i<arr.length;i++){
if(_1a2.call(_1a3,arr[i],i,arr)){
_1a5.push(arr[i]);
}
}
}
if(_1a4){
return _1a5.join("");
}else{
return _1a5;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_1aa,_1ab){
var _1ac=[];
for(var i=_1ab||0;i<_1aa.length;i++){
_1ac.push(_1aa[i]);
}
return _1ac;
}});
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_1ae,_1af){
var args=[];
for(var x=2;x<arguments.length;x++){
args.push(arguments[x]);
}
var fcn=(dojo.lang.isString(_1af)?_1ae[_1af]:_1af)||function(){
};
return function(){
var ta=args.concat([]);
for(var x=0;x<arguments.length;x++){
ta.push(arguments[x]);
}
return fcn.apply(_1ae,ta);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_1b5,_1b6,_1b7){
var nso=(_1b6||dojo.lang.anon);
if((_1b7)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_1b5){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_1b5;
return ret;
};
dojo.lang.forward=function(_1bb){
return function(){
return this[_1bb].apply(this,arguments);
};
};
dojo.lang.curry=function(_1bc,func){
var _1be=[];
_1bc=_1bc||dj_global;
if(dojo.lang.isString(func)){
func=_1bc[func];
}
for(var x=2;x<arguments.length;x++){
_1be.push(arguments[x]);
}
var _1c0=(func["__preJoinArity"]||func.length)-_1be.length;
function gather(_1c1,_1c2,_1c3){
var _1c4=_1c3;
var _1c5=_1c2.slice(0);
for(var x=0;x<_1c1.length;x++){
_1c5.push(_1c1[x]);
}
_1c3=_1c3-_1c1.length;
if(_1c3<=0){
var res=func.apply(_1bc,_1c5);
_1c3=_1c4;
return res;
}else{
return function(){
return gather(arguments,_1c5,_1c3);
};
}
}
return gather([],_1be,_1c0);
};
dojo.lang.curryArguments=function(_1c8,func,args,_1cb){
var _1cc=[];
var x=_1cb||0;
for(x=_1cb;x<args.length;x++){
_1cc.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_1c8,func].concat(_1cc));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1d2,_1d3){
if(!farr.length){
if(typeof _1d3=="function"){
_1d3();
}
return;
}
if((typeof _1d2=="undefined")&&(typeof cb=="number")){
_1d2=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1d2){
_1d2=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1d2,_1d3);
},_1d2);
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_1d4,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _1d4.replace(/\%\{(\w+)\}/g,function(_1d7,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _1da=str.split(" ");
for(var i=0;i<_1da.length;i++){
_1da[i]=_1da[i].charAt(0).toUpperCase()+_1da[i].substring(1);
}
return _1da.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _1df=escape(str);
var _1e0,re=/%u([0-9A-F]{4})/i;
while((_1e0=_1df.match(re))){
var num=Number("0x"+_1e0[1]);
var _1e3=escape("&#"+num+";");
ret+=_1df.substring(0,_1e0.index)+_1e3;
_1df=_1df.substring(_1e0.index+_1e0[0].length);
}
ret+=_1df.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_1e8){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_1e8){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_1f1){
if(_1f1){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_1f5,_1f6){
if(_1f6){
str=str.toLowerCase();
_1f5=_1f5.toLowerCase();
}
return str.indexOf(_1f5)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_1fc){
if(_1fc=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_1fc=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_1fe){
var _1ff=[];
for(var i=0,_201=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_1fe){
_1ff.push(str.substring(_201,i));
_201=i+1;
}
}
_1ff.push(str.substr(_201));
return _1ff;
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _203=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_203.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_205,_206){
var node=_205.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_206&&node&&node.tagName&&node.tagName.toLowerCase()!=_206.toLowerCase()){
node=dojo.dom.nextElement(node,_206);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_208,_209){
var node=_208.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_209&&node&&node.tagName&&node.tagName.toLowerCase()!=_209.toLowerCase()){
node=dojo.dom.prevElement(node,_209);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_20c){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_20c&&_20c.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_20c);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_20e){
if(!node){
return null;
}
if(_20e){
_20e=_20e.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_20e&&_20e.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_20e);
}
return node;
};
dojo.dom.moveChildren=function(_20f,_210,trim){
var _212=0;
if(trim){
while(_20f.hasChildNodes()&&_20f.firstChild.nodeType==dojo.dom.TEXT_NODE){
_20f.removeChild(_20f.firstChild);
}
while(_20f.hasChildNodes()&&_20f.lastChild.nodeType==dojo.dom.TEXT_NODE){
_20f.removeChild(_20f.lastChild);
}
}
while(_20f.hasChildNodes()){
_210.appendChild(_20f.firstChild);
_212++;
}
return _212;
};
dojo.dom.copyChildren=function(_213,_214,trim){
var _216=_213.cloneNode(true);
return this.moveChildren(_216,_214,trim);
};
dojo.dom.replaceChildren=function(node,_218){
var _219=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_219.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_218);
for(var i=0;i<_219.length;i++){
dojo.dom.destroyNode(_219[i]);
}
};
dojo.dom.removeChildren=function(node){
var _21c=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _21c;
};
dojo.dom.replaceNode=function(node,_21e){
return node.parentNode.replaceChild(_21e,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_222,_223){
var _224=[];
var _225=(_222&&(_222 instanceof Function||typeof _222=="function"));
while(node){
if(!_225||_222(node)){
_224.push(node);
}
if(_223&&_224.length>0){
return _224[0];
}
node=node.parentNode;
}
if(_223){
return null;
}
return _224;
};
dojo.dom.getAncestorsByTag=function(node,tag,_228){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_228);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_22d,_22e){
if(_22e&&node){
node=node.parentNode;
}
while(node){
if(node==_22d){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _231=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _232=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_232.length;i++){
try{
doc=new ActiveXObject(_232[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_231.implementation)&&(_231.implementation.createDocument)){
doc=_231.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_235){
if(!_235){
_235="text/xml";
}
if(!dj_undef("DOMParser")){
var _236=new DOMParser();
return _236.parseFromString(str,_235);
}else{
if(!dj_undef("ActiveXObject")){
var _237=dojo.dom.createDocument();
if(_237){
_237.async=false;
_237.loadXML(str);
return _237;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _238=dojo.doc();
if(_238.createElement){
var tmp=_238.createElement("xml");
tmp.innerHTML=str;
if(_238.implementation&&_238.implementation.createDocument){
var _23a=_238.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_23a.importNode(tmp.childNodes.item(i),true);
}
return _23a;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_23d){
if(_23d.firstChild){
_23d.insertBefore(node,_23d.firstChild);
}else{
_23d.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_240){
if((_240!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _241=ref.parentNode;
_241.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_244){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_244!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_244);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_248){
if((!node)||(!ref)||(!_248)){
return false;
}
switch(_248.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_24a,_24b){
var _24c=_24a.childNodes;
if(!_24c.length||_24c.length==_24b){
_24a.appendChild(node);
return true;
}
if(_24b==0){
return dojo.dom.prependChild(node,_24a);
}
return dojo.dom.insertAfter(node,_24c[_24b-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _24f=dojo.doc();
dojo.dom.replaceChildren(node,_24f.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _250="";
if(node==null){
return _250;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_250+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_250+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _250;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_256,_257,_258){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_256,_257,_258);
}else{
var _259=elem.ownerDocument;
var _25a=_259.createNode(2,_257,_256);
_25a.nodeValue=_258;
elem.setAttributeNode(_25a);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:(!dj_undef("window"))?window.location.href:"",initialHash:(!dj_undef("window"))?window.location.hash:"",moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.undo.browser: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _25f=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_261){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_25f.apply(this,[_261]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _262=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_264){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_262){
_262.apply(this,[_264]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_267){
if(!dojo.render.html.opera){
var _268=this._getUrlQuery(_267.href);
if(_268==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_268==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_268==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _269=this.historyStack.pop();
if(!_269){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_269);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _270=url.split("?");
if(_270.length<2){
return null;
}else{
return _270[1];
}
},_loadIframeHistory:function(){
var url=(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
if(!dj_undef("window")){
dojo.io.checkChildrenForFile=function(node){
var _273=false;
var _274=node.getElementsByTagName("input");
dojo.lang.forEach(_274,function(_275){
if(_273){
return;
}
if(_275.getAttribute("type")=="file"){
_273=true;
}
});
return _273;
};
dojo.io.formHasFile=function(_276){
return dojo.io.checkChildrenForFile(_276);
};
dojo.io.updateNode=function(node,_278){
node=dojo.byId(node);
var args=_278;
if(dojo.lang.isString(_278)){
args={url:_278};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
dojo.dom.destroyNode(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_27f,_280,_281){
if((!_27f)||(!_27f.tagName)||(!_27f.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_281){
_281=dojo.io.formFilter;
}
var enc=/utf/i.test(_280||"")?encodeURIComponent:dojo.string.encodeAscii;
var _283=[];
for(var i=0;i<_27f.elements.length;i++){
var elm=_27f.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_281(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_283.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_283.push(name+"="+enc(elm.value));
}
}else{
_283.push(name+"="+enc(elm.value));
}
}
}
var _289=_27f.getElementsByTagName("input");
for(var i=0;i<_289.length;i++){
var _28a=_289[i];
if(_28a.type.toLowerCase()=="image"&&_28a.form==_27f&&_281(_28a)){
var name=enc(_28a.name);
_283.push(name+"="+enc(_28a.value));
_283.push(name+".x=0");
_283.push(name+".y=0");
}
}
return _283.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _290=form.getElementsByTagName("input");
for(var i=0;i<_290.length;i++){
var _291=_290[i];
if(_291.type.toLowerCase()=="image"&&_291.form==form){
this.connect(_291,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _298=false;
if(node.disabled||!node.name){
_298=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_298=node==this.clickedButton;
}else{
_298=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _298;
},connect:function(_299,_29a,_29b){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_299,_29a,this,_29b);
}else{
var fcn=dojo.lang.hitch(this,_29b);
_299[_29a]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _29e=this;
var _29f={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_2a1,_2a2){
return url+"|"+_2a1+"|"+_2a2.toLowerCase();
}
function addToCache(url,_2a4,_2a5,http){
_29f[getCacheKey(url,_2a4,_2a5)]=http;
}
function getFromCache(url,_2a8,_2a9){
return _29f[getCacheKey(url,_2a8,_2a9)];
}
this.clearCache=function(){
_29f={};
};
function doLoad(_2aa,http,url,_2ad,_2ae){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(http.status==1223)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_2aa.method.toLowerCase()=="head"){
var _2b0=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _2b0;
};
var _2b1=_2b0.split(/[\r\n]+/g);
for(var i=0;i<_2b1.length;i++){
var pair=_2b1[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_2aa.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_2aa.mimetype.substr(0,9)=="text/json"||_2aa.mimetype.substr(0,16)=="application/json"){
try{
ret=dj_eval("("+_2aa.jsonFilter(http.responseText)+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_2aa.mimetype=="application/xml")||(_2aa.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_2ae){
addToCache(url,_2ad,_2aa.method,http);
}
_2aa[(typeof _2aa.load=="function")?"load":"handle"]("load",ret,http,_2aa);
}else{
var _2b4=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_2aa[(typeof _2aa.error=="function")?"error":"handle"]("error",_2b4,http,_2aa);
}
}
function setHeaders(http,_2b6){
if(_2b6["headers"]){
for(var _2b7 in _2b6["headers"]){
if(_2b7.toLowerCase()=="content-type"&&!_2b6["contentType"]){
_2b6["contentType"]=_2b6["headers"][_2b7];
}else{
http.setRequestHeader(_2b7,_2b6["headers"][_2b7]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_29e._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _2bb=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_2bb,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _2bc=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_2bd){
var mlc=_2bd["mimetype"].toLowerCase()||"";
return _2bc&&((dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript"],mlc))||(mlc.substr(0,9)=="text/json"||mlc.substr(0,16)=="application/json"))&&!(_2bd["formNode"]&&dojo.io.formHasFile(_2bd["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_2bf){
if(!_2bf["url"]){
if(!_2bf["formNode"]&&(_2bf["backButton"]||_2bf["back"]||_2bf["changeUrl"]||_2bf["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_2bf);
return true;
}
}
var url=_2bf.url;
var _2c1="";
if(_2bf["formNode"]){
var ta=_2bf.formNode.getAttribute("action");
if((ta)&&(!_2bf["url"])){
url=ta;
}
var tp=_2bf.formNode.getAttribute("method");
if((tp)&&(!_2bf["method"])){
_2bf.method=tp;
}
_2c1+=dojo.io.encodeForm(_2bf.formNode,_2bf.encoding,_2bf["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_2bf["file"]){
_2bf.method="post";
}
if(!_2bf["method"]){
_2bf.method="get";
}
if(_2bf.method.toLowerCase()=="get"){
_2bf.multipart=false;
}else{
if(_2bf["file"]){
_2bf.multipart=true;
}else{
if(!_2bf["multipart"]){
_2bf.multipart=false;
}
}
}
if(_2bf["backButton"]||_2bf["back"]||_2bf["changeUrl"]){
dojo.undo.browser.addToHistory(_2bf);
}
var _2c4=_2bf["content"]||{};
if(_2bf.sendTransport){
_2c4["dojo.transport"]="xmlhttp";
}
do{
if(_2bf.postContent){
_2c1=_2bf.postContent;
break;
}
if(_2c4){
_2c1+=dojo.io.argsFromMap(_2c4,_2bf.encoding);
}
if(_2bf.method.toLowerCase()=="get"||!_2bf.multipart){
break;
}
var t=[];
if(_2c1.length){
var q=_2c1.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_2bf.file){
if(dojo.lang.isArray(_2bf.file)){
for(var i=0;i<_2bf.file.length;++i){
var o=_2bf.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_2bf.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_2c1=t.join("\r\n");
}
}while(false);
var _2ca=_2bf["sync"]?false:true;
var _2cb=_2bf["preventCache"]||(this.preventCache==true&&_2bf["preventCache"]!=false);
var _2cc=_2bf["useCache"]==true||(this.useCache==true&&_2bf["useCache"]!=false);
if(!_2cb&&_2cc){
var _2cd=getFromCache(url,_2c1,_2bf.method);
if(_2cd){
doLoad(_2bf,_2cd,url,_2c1,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_2bf);
var _2cf=false;
if(_2ca){
var _2d0=this.inFlight.push({"req":_2bf,"http":http,"url":url,"query":_2c1,"useCache":_2cc,"startTime":_2bf.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_29e._blockAsync=true;
}
if(_2bf.method.toLowerCase()=="post"){
if(!_2bf.user){
http.open("POST",url,_2ca);
}else{
http.open("POST",url,_2ca,_2bf.user,_2bf.password);
}
setHeaders(http,_2bf);
http.setRequestHeader("Content-Type",_2bf.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_2bf.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_2c1);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2bf,{status:404},url,_2c1,_2cc);
}
}else{
var _2d1=url;
if(_2c1!=""){
_2d1+=(_2d1.indexOf("?")>-1?"&":"?")+_2c1;
}
if(_2cb){
_2d1+=(dojo.string.endsWithAny(_2d1,"?","&")?"":(_2d1.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_2bf.user){
http.open(_2bf.method.toUpperCase(),_2d1,_2ca);
}else{
http.open(_2bf.method.toUpperCase(),_2d1,_2ca,_2bf.user,_2bf.password);
}
setHeaders(http,_2bf);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2bf,{status:404},url,_2c1,_2cc);
}
}
if(!_2ca){
doLoad(_2bf,http,url,_2c1,_2cc);
_29e._blockAsync=false;
}
_2bf.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
}
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_2d3,days,path,_2d6,_2d7){
var _2d8=-1;
if((typeof days=="number")&&(days>=0)){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_2d8=d.toGMTString();
}
_2d3=escape(_2d3);
document.cookie=name+"="+_2d3+";"+(_2d8!=-1?" expires="+_2d8+";":"")+(path?"path="+path:"")+(_2d6?"; domain="+_2d6:"")+(_2d7?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _2dc=document.cookie.substring(idx+name.length+1);
var end=_2dc.indexOf(";");
if(end==-1){
end=_2dc.length;
}
_2dc=_2dc.substring(0,end);
_2dc=unescape(_2dc);
return _2dc;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_2e3,_2e4,_2e5){
if(arguments.length==5){
_2e5=_2e3;
_2e3=null;
_2e4=null;
}
var _2e6=[],_2e7,_2e8="";
if(!_2e5){
_2e7=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_2e7){
_2e7={};
}
for(var prop in obj){
if(obj[prop]==null){
delete _2e7[prop];
}else{
if((typeof obj[prop]=="string")||(typeof obj[prop]=="number")){
_2e7[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _2e7){
_2e6.push(escape(prop)+"="+escape(_2e7[prop]));
}
_2e8=_2e6.join("&");
}
dojo.io.cookie.setCookie(name,_2e8,days,path,_2e3,_2e4);
};
dojo.io.cookie.getObjectCookie=function(name){
var _2eb=null,_2ec=dojo.io.cookie.getCookie(name);
if(_2ec){
_2eb={};
var _2ed=_2ec.split("&");
for(var i=0;i<_2ed.length;i++){
var pair=_2ed[i].split("=");
var _2f0=pair[1];
if(isNaN(_2f0)){
_2f0=unescape(pair[1]);
}
_2eb[unescape(pair[0])]=_2f0;
}
}
return _2eb;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _2f1=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_2f1=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.kwCompoundRequire({common:["dojo.io.common"],rhino:["dojo.io.RhinoIO"],browser:["dojo.io.BrowserIO","dojo.io.cookie"],dashboard:["dojo.io.BrowserIO","dojo.io.cookie"]});
dojo.provide("dojo.io.*");
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_2f3){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false,maxCalls:-1};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _2f6=dl.nameAnonFunc(args[2],ao.adviceObj,_2f3);
ao.adviceFunc=_2f6;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _2f6=dl.nameAnonFunc(args[0],ao.srcObj,_2f3);
ao.srcFunc=_2f6;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _2f6=dl.nameAnonFunc(args[1],dj_global,_2f3);
ao.srcFunc=_2f6;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _2f6=dl.nameAnonFunc(args[3],dj_global,_2f3);
ao.adviceObj=dj_global;
ao.adviceFunc=_2f6;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
ao.maxCalls=(!isNaN(parseInt(args[11])))?args[11]:-1;
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _2f6=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_2f3);
ao.aroundFunc=_2f6;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _2f8={};
for(var x in ao){
_2f8[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_2f8.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_2f8));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _300;
if((arguments.length==1)&&(typeof a1=="object")){
_300=a1;
}else{
_300={srcObj:a1,srcFunc:a2};
}
_300.adviceFunc=function(){
var _301=[];
for(var x=0;x<arguments.length;x++){
_301.push(arguments[x]);
}
dojo.debug("("+_300.srcObj+")."+_300.srcFunc,":",_301.join(", "));
};
this.kwConnect(_300);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this.connectRunOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.maxCalls=1;
return this.connect(ao);
};
this._kwConnectImpl=function(_309,_30a){
var fn=(_30a)?"disconnect":"connect";
if(typeof _309["srcFunc"]=="function"){
_309.srcObj=_309["srcObj"]||dj_global;
var _30c=dojo.lang.nameAnonFunc(_309.srcFunc,_309.srcObj,true);
_309.srcFunc=_30c;
}
if(typeof _309["adviceFunc"]=="function"){
_309.adviceObj=_309["adviceObj"]||dj_global;
var _30c=dojo.lang.nameAnonFunc(_309.adviceFunc,_309.adviceObj,true);
_309.adviceFunc=_30c;
}
_309.srcObj=_309["srcObj"]||dj_global;
_309.adviceObj=_309["adviceObj"]||_309["targetObj"]||dj_global;
_309.adviceFunc=_309["adviceFunc"]||_309["targetFunc"];
return dojo.event[fn](_309);
};
this.kwConnect=function(_30d){
return this._kwConnectImpl(_30d,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_310){
return this._kwConnectImpl(_310,true);
};
};
dojo.event.MethodInvocation=function(_311,obj,args){
this.jp_=_311;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_319){
this.object=obj||dj_global;
this.methodname=_319;
this.methodfunc=this.object[_319];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_31b){
if(!obj){
obj=dj_global;
}
var ofn=obj[_31b];
if(!ofn){
ofn=obj[_31b]=function(){
};
if(!obj[_31b]){
dojo.raise("Cannot set do-nothing method on that object "+_31b);
}
}else{
if((typeof ofn!="function")&&(!dojo.lang.isFunction(ofn))&&(!dojo.lang.isAlien(ofn))){
return null;
}
}
var _31d=_31b+"$joinpoint";
var _31e=_31b+"$joinpoint$method";
var _31f=obj[_31d];
if(!_31f){
var _320=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_320=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_31d,_31e,_31b]);
}
}
var _321=ofn.length;
obj[_31e]=ofn;
_31f=obj[_31d]=new dojo.event.MethodJoinPoint(obj,_31e);
if(!_320){
obj[_31b]=function(){
return _31f.run.apply(_31f,arguments);
};
}else{
obj[_31b]=function(){
var args=[];
if(!arguments.length){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _31f.run.apply(_31f,args);
};
}
obj[_31b].__preJoinArity=_321;
}
return _31f;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{squelch:false,unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _327=[];
for(var x=0;x<args.length;x++){
_327[x]=args[x];
}
var _329=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _32b=marr[0]||dj_global;
var _32c=marr[1];
if(!_32b[_32c]){
dojo.raise("function \""+_32c+"\" does not exist on \""+_32b+"\"");
}
var _32d=marr[2]||dj_global;
var _32e=marr[3];
var msg=marr[6];
var _330=marr[7];
if(_330>-1){
if(_330==0){
return;
}
marr[7]--;
}
var _331;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _32b[_32c].apply(_32b,to.args);
}};
to.args=_327;
var _333=parseInt(marr[4]);
var _334=((!isNaN(_333))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _337=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_329(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_32e){
_32d[_32e].call(_32d,to);
}else{
if((_334)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_32b[_32c].call(_32b,to);
}else{
_32b[_32c].apply(_32b,args);
}
},_333);
}else{
if(msg){
_32b[_32c].call(_32b,to);
}else{
_32b[_32c].apply(_32b,args);
}
}
}
};
var _33a=function(){
if(this.squelch){
try{
return _329.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _329.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_33a);
}
var _33b;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_33b=mi.proceed();
}else{
if(this.methodfunc){
_33b=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_33a);
}
return (this.methodfunc)?_33b:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"],args["maxCalls"]);
},addAdvice:function(_340,_341,_342,_343,_344,_345,once,_347,rate,_349,_34a){
var arr=this.getArr(_344);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_340,_341,_342,_343,_347,rate,_349,_34a];
if(once){
if(this.hasAdvice(_340,_341,_344,arr)>=0){
return;
}
}
if(_345=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_34d,_34e,_34f,arr){
if(!arr){
arr=this.getArr(_34f);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _34e=="object")?(new String(_34e)).toString():_34e;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_34d)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_355,_356,_357,once){
var arr=this.getArr(_357);
var ind=this.hasAdvice(_355,_356,_357,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_355,_356,_357,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_35b){
if(!this.topics[_35b]){
this.topics[_35b]=new this.TopicImpl(_35b);
}
return this.topics[_35b];
};
this.registerPublisher=function(_35c,obj,_35e){
var _35c=this.getTopic(_35c);
_35c.registerPublisher(obj,_35e);
};
this.subscribe=function(_35f,obj,_361){
var _35f=this.getTopic(_35f);
_35f.subscribe(obj,_361);
};
this.unsubscribe=function(_362,obj,_364){
var _362=this.getTopic(_362);
_362.unsubscribe(obj,_364);
};
this.destroy=function(_365){
this.getTopic(_365).destroy();
delete this.topics[_365];
};
this.publishApply=function(_366,args){
var _366=this.getTopic(_366);
_366.sendMessage.apply(_366,args);
};
this.publish=function(_368,_369){
var _368=this.getTopic(_368);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_368.sendMessage.apply(_368,args);
};
};
dojo.event.topic.TopicImpl=function(_36c){
this.topicName=_36c;
this.subscribe=function(_36d,_36e){
var tf=_36e||_36d;
var to=(!_36e)?dj_global:_36d;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_371,_372){
var tf=(!_372)?_371:_372;
var to=(!_372)?null:_371;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_375){
this._getJoinPoint().squelch=_375;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_376,_377){
dojo.event.connect(_376,_377,this,"sendMessage");
};
this.sendMessage=function(_378){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_37b){
var na;
var tna;
if(_37b){
tna=_37b.all||_37b.getElementsByTagName("*");
na=[_37b];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _37f={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _384=0;
this.normalizedEventName=function(_385){
switch(_385){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _385;
break;
default:
var lcn=_385.toLowerCase();
return (lcn.indexOf("on")==0)?lcn.substr(2):lcn;
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_38a){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_38a.length;x++){
node.__clobberAttrs__.push(_38a[x]);
}
};
this.removeListener=function(node,_38d,fp,_38f){
if(!_38f){
var _38f=false;
}
_38d=dojo.event.browser.normalizedEventName(_38d);
if(_38d=="key"){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_38f);
}
_38d="keypress";
}
if(node.removeEventListener){
node.removeEventListener(_38d,fp,_38f);
}
};
this.addListener=function(node,_391,fp,_393,_394){
if(!node){
return;
}
if(!_393){
var _393=false;
}
_391=dojo.event.browser.normalizedEventName(_391);
if(_391=="key"){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_393,_394);
}
_391="keypress";
}
if(!_394){
var _395=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_393){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_395=fp;
}
if(node.addEventListener){
node.addEventListener(_391,_395,_393);
return _395;
}else{
_391="on"+_391;
if(typeof node[_391]=="function"){
var _398=node[_391];
node[_391]=function(e){
_398(e);
return _395(e);
};
}else{
node[_391]=_395;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_391]);
}
return _395;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_39b,_39c){
if(typeof _39b!="function"){
dojo.raise("listener not a function: "+_39b);
}
dojo.event.browser.currentEvent.currentTarget=_39c;
return _39b.call(_39c,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_39f){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _3a1=evt.keyCode;
if(_3a1>=65&&_3a1<=90&&evt.shiftKey==false){
_3a1+=32;
}
if(_3a1>=1&&_3a1<=26&&evt.ctrlKey){
_3a1+=96;
}
evt.key=String.fromCharCode(_3a1);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _3a1=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_3a1+=32;
}
evt.key=String.fromCharCode(_3a1);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_39f?_39f:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _3a3=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_3a3.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_3a3.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.kwCompoundRequire({common:["dojo.event.common","dojo.event.topic"],browser:["dojo.event.browser"],dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");
dojo.provide("dojo.gfx.color");
dojo.gfx.color.Color=function(r,g,b,a){
if(dojo.lang.isArray(r)){
this.r=r[0];
this.g=r[1];
this.b=r[2];
this.a=r[3]||1;
}else{
if(dojo.lang.isString(r)){
var rgb=dojo.gfx.color.extractRGB(r);
this.r=rgb[0];
this.g=rgb[1];
this.b=rgb[2];
this.a=g||1;
}else{
if(r instanceof dojo.gfx.color.Color){
this.r=r.r;
this.b=r.b;
this.g=r.g;
this.a=r.a;
}else{
this.r=r;
this.g=g;
this.b=b;
this.a=a;
}
}
}
};
dojo.gfx.color.Color.fromArray=function(arr){
return new dojo.gfx.color.Color(arr[0],arr[1],arr[2],arr[3]);
};
dojo.extend(dojo.gfx.color.Color,{toRgb:function(_3ab){
if(_3ab){
return this.toRgba();
}else{
return [this.r,this.g,this.b];
}
},toRgba:function(){
return [this.r,this.g,this.b,this.a];
},toHex:function(){
return dojo.gfx.color.rgb2hex(this.toRgb());
},toCss:function(){
return "rgb("+this.toRgb().join()+")";
},toString:function(){
return this.toHex();
},blend:function(_3ac,_3ad){
var rgb=null;
if(dojo.lang.isArray(_3ac)){
rgb=_3ac;
}else{
if(_3ac instanceof dojo.gfx.color.Color){
rgb=_3ac.toRgb();
}else{
rgb=new dojo.gfx.color.Color(_3ac).toRgb();
}
}
return dojo.gfx.color.blend(this.toRgb(),rgb,_3ad);
}});
dojo.gfx.color.named={white:[255,255,255],black:[0,0,0],red:[255,0,0],green:[0,255,0],lime:[0,255,0],blue:[0,0,255],navy:[0,0,128],gray:[128,128,128],silver:[192,192,192]};
dojo.gfx.color.blend=function(a,b,_3b1){
if(typeof a=="string"){
return dojo.gfx.color.blendHex(a,b,_3b1);
}
if(!_3b1){
_3b1=0;
}
_3b1=Math.min(Math.max(-1,_3b1),1);
_3b1=((_3b1+1)/2);
var c=[];
for(var x=0;x<3;x++){
c[x]=parseInt(b[x]+((a[x]-b[x])*_3b1));
}
return c;
};
dojo.gfx.color.blendHex=function(a,b,_3b6){
return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a),dojo.gfx.color.hex2rgb(b),_3b6));
};
dojo.gfx.color.extractRGB=function(_3b7){
var hex="0123456789abcdef";
_3b7=_3b7.toLowerCase();
if(_3b7.indexOf("rgb")==0){
var _3b9=_3b7.match(/rgba*\((\d+), *(\d+), *(\d+)/i);
var ret=_3b9.splice(1,3);
return ret;
}else{
var _3bb=dojo.gfx.color.hex2rgb(_3b7);
if(_3bb){
return _3bb;
}else{
return dojo.gfx.color.named[_3b7]||[255,255,255];
}
}
};
dojo.gfx.color.hex2rgb=function(hex){
var _3bd="0123456789ABCDEF";
var rgb=new Array(3);
if(hex.indexOf("#")==0){
hex=hex.substring(1);
}
hex=hex.toUpperCase();
if(hex.replace(new RegExp("["+_3bd+"]","g"),"")!=""){
return null;
}
if(hex.length==3){
rgb[0]=hex.charAt(0)+hex.charAt(0);
rgb[1]=hex.charAt(1)+hex.charAt(1);
rgb[2]=hex.charAt(2)+hex.charAt(2);
}else{
rgb[0]=hex.substring(0,2);
rgb[1]=hex.substring(2,4);
rgb[2]=hex.substring(4);
}
for(var i=0;i<rgb.length;i++){
rgb[i]=_3bd.indexOf(rgb[i].charAt(0))*16+_3bd.indexOf(rgb[i].charAt(1));
}
return rgb;
};
dojo.gfx.color.rgb2hex=function(r,g,b){
if(dojo.lang.isArray(r)){
g=r[1]||0;
b=r[2]||0;
r=r[0]||0;
}
var ret=dojo.lang.map([r,g,b],function(x){
x=new Number(x);
var s=x.toString(16);
while(s.length<2){
s="0"+s;
}
return s;
});
ret.unshift("#");
return ret.join("");
};
dojo.provide("dojo.lfx.Animation");
dojo.lfx.Line=function(_3c6,end){
this.start=_3c6;
this.end=end;
if(dojo.lang.isArray(_3c6)){
var diff=[];
dojo.lang.forEach(this.start,function(s,i){
diff[i]=this.end[i]-s;
},this);
this.getValue=function(n){
var res=[];
dojo.lang.forEach(this.start,function(s,i){
res[i]=(diff[i]*n)+s;
},this);
return res;
};
}else{
var diff=end-_3c6;
this.getValue=function(n){
return (diff*n)+this.start;
};
}
};
if((dojo.render.html.khtml)&&(!dojo.render.html.safari)){
dojo.lfx.easeDefault=function(n){
return (parseFloat("0.5")+((Math.sin((n+parseFloat("1.5"))*Math.PI))/2));
};
}else{
dojo.lfx.easeDefault=function(n){
return (0.5+((Math.sin((n+1.5)*Math.PI))/2));
};
}
dojo.lfx.easeIn=function(n){
return Math.pow(n,3);
};
dojo.lfx.easeOut=function(n){
return (1-Math.pow(1-n,3));
};
dojo.lfx.easeInOut=function(n){
return ((3*Math.pow(n,2))-(2*Math.pow(n,3)));
};
dojo.lfx.IAnimation=function(){
};
dojo.lang.extend(dojo.lfx.IAnimation,{curve:null,duration:1000,easing:null,repeatCount:0,rate:10,handler:null,beforeBegin:null,onBegin:null,onAnimate:null,onEnd:null,onPlay:null,onPause:null,onStop:null,play:null,pause:null,stop:null,connect:function(evt,_3d6,_3d7){
if(!_3d7){
_3d7=_3d6;
_3d6=this;
}
_3d7=dojo.lang.hitch(_3d6,_3d7);
var _3d8=this[evt]||function(){
};
this[evt]=function(){
var ret=_3d8.apply(this,arguments);
_3d7.apply(this,arguments);
return ret;
};
return this;
},fire:function(evt,args){
if(this[evt]){
this[evt].apply(this,(args||[]));
}
return this;
},repeat:function(_3dc){
this.repeatCount=_3dc;
return this;
},_active:false,_paused:false});
dojo.lfx.Animation=function(_3dd,_3de,_3df,_3e0,_3e1,rate){
dojo.lfx.IAnimation.call(this);
if(dojo.lang.isNumber(_3dd)||(!_3dd&&_3de.getValue)){
rate=_3e1;
_3e1=_3e0;
_3e0=_3df;
_3df=_3de;
_3de=_3dd;
_3dd=null;
}else{
if(_3dd.getValue||dojo.lang.isArray(_3dd)){
rate=_3e0;
_3e1=_3df;
_3e0=_3de;
_3df=_3dd;
_3de=null;
_3dd=null;
}
}
if(dojo.lang.isArray(_3df)){
this.curve=new dojo.lfx.Line(_3df[0],_3df[1]);
}else{
this.curve=_3df;
}
if(_3de!=null&&_3de>0){
this.duration=_3de;
}
if(_3e1){
this.repeatCount=_3e1;
}
if(rate){
this.rate=rate;
}
if(_3dd){
dojo.lang.forEach(["handler","beforeBegin","onBegin","onEnd","onPlay","onStop","onAnimate"],function(item){
if(_3dd[item]){
this.connect(item,_3dd[item]);
}
},this);
}
if(_3e0&&dojo.lang.isFunction(_3e0)){
this.easing=_3e0;
}
};
dojo.inherits(dojo.lfx.Animation,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Animation,{_startTime:null,_endTime:null,_timer:null,_percent:0,_startRepeatCount:0,play:function(_3e4,_3e5){
if(_3e5){
clearTimeout(this._timer);
this._active=false;
this._paused=false;
this._percent=0;
}else{
if(this._active&&!this._paused){
return this;
}
}
this.fire("handler",["beforeBegin"]);
this.fire("beforeBegin");
if(_3e4>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3e5);
}),_3e4);
return this;
}
this._startTime=new Date().valueOf();
if(this._paused){
this._startTime-=(this.duration*this._percent/100);
}
this._endTime=this._startTime+this.duration;
this._active=true;
this._paused=false;
var step=this._percent/100;
var _3e7=this.curve.getValue(step);
if(this._percent==0){
if(!this._startRepeatCount){
this._startRepeatCount=this.repeatCount;
}
this.fire("handler",["begin",_3e7]);
this.fire("onBegin",[_3e7]);
}
this.fire("handler",["play",_3e7]);
this.fire("onPlay",[_3e7]);
this._cycle();
return this;
},pause:function(){
clearTimeout(this._timer);
if(!this._active){
return this;
}
this._paused=true;
var _3e8=this.curve.getValue(this._percent/100);
this.fire("handler",["pause",_3e8]);
this.fire("onPause",[_3e8]);
return this;
},gotoPercent:function(pct,_3ea){
clearTimeout(this._timer);
this._active=true;
this._paused=true;
this._percent=pct;
if(_3ea){
this.play();
}
return this;
},stop:function(_3eb){
clearTimeout(this._timer);
var step=this._percent/100;
if(_3eb){
step=1;
}
var _3ed=this.curve.getValue(step);
this.fire("handler",["stop",_3ed]);
this.fire("onStop",[_3ed]);
this._active=false;
this._paused=false;
return this;
},status:function(){
if(this._active){
return this._paused?"paused":"playing";
}else{
return "stopped";
}
return this;
},_cycle:function(){
clearTimeout(this._timer);
if(this._active){
var curr=new Date().valueOf();
var step=(curr-this._startTime)/(this._endTime-this._startTime);
if(step>=1){
step=1;
this._percent=100;
}else{
this._percent=step*100;
}
if((this.easing)&&(dojo.lang.isFunction(this.easing))){
step=this.easing(step);
}
var _3f0=this.curve.getValue(step);
this.fire("handler",["animate",_3f0]);
this.fire("onAnimate",[_3f0]);
if(step<1){
this._timer=setTimeout(dojo.lang.hitch(this,"_cycle"),this.rate);
}else{
this._active=false;
this.fire("handler",["end"]);
this.fire("onEnd");
if(this.repeatCount>0){
this.repeatCount--;
this.play(null,true);
}else{
if(this.repeatCount==-1){
this.play(null,true);
}else{
if(this._startRepeatCount){
this.repeatCount=this._startRepeatCount;
this._startRepeatCount=0;
}
}
}
}
}
return this;
}});
dojo.lfx.Combine=function(_3f1){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._animsEnded=0;
var _3f2=arguments;
if(_3f2.length==1&&(dojo.lang.isArray(_3f2[0])||dojo.lang.isArrayLike(_3f2[0]))){
_3f2=_3f2[0];
}
dojo.lang.forEach(_3f2,function(anim){
this._anims.push(anim);
anim.connect("onEnd",dojo.lang.hitch(this,"_onAnimsEnded"));
},this);
};
dojo.inherits(dojo.lfx.Combine,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Combine,{_animsEnded:0,play:function(_3f4,_3f5){
if(!this._anims.length){
return this;
}
this.fire("beforeBegin");
if(_3f4>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3f5);
}),_3f4);
return this;
}
if(_3f5||this._anims[0].percent==0){
this.fire("onBegin");
}
this.fire("onPlay");
this._animsCall("play",null,_3f5);
return this;
},pause:function(){
this.fire("onPause");
this._animsCall("pause");
return this;
},stop:function(_3f6){
this.fire("onStop");
this._animsCall("stop",_3f6);
return this;
},_onAnimsEnded:function(){
this._animsEnded++;
if(this._animsEnded>=this._anims.length){
this.fire("onEnd");
}
return this;
},_animsCall:function(_3f7){
var args=[];
if(arguments.length>1){
for(var i=1;i<arguments.length;i++){
args.push(arguments[i]);
}
}
var _3fa=this;
dojo.lang.forEach(this._anims,function(anim){
anim[_3f7](args);
},_3fa);
return this;
}});
dojo.lfx.Chain=function(_3fc){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._currAnim=-1;
var _3fd=arguments;
if(_3fd.length==1&&(dojo.lang.isArray(_3fd[0])||dojo.lang.isArrayLike(_3fd[0]))){
_3fd=_3fd[0];
}
var _3fe=this;
dojo.lang.forEach(_3fd,function(anim,i,_401){
this._anims.push(anim);
if(i<_401.length-1){
anim.connect("onEnd",dojo.lang.hitch(this,"_playNext"));
}else{
anim.connect("onEnd",dojo.lang.hitch(this,function(){
this.fire("onEnd");
}));
}
},this);
};
dojo.inherits(dojo.lfx.Chain,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Chain,{_currAnim:-1,play:function(_402,_403){
if(!this._anims.length){
return this;
}
if(_403||!this._anims[this._currAnim]){
this._currAnim=0;
}
var _404=this._anims[this._currAnim];
this.fire("beforeBegin");
if(_402>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_403);
}),_402);
return this;
}
if(_404){
if(this._currAnim==0){
this.fire("handler",["begin",this._currAnim]);
this.fire("onBegin",[this._currAnim]);
}
this.fire("onPlay",[this._currAnim]);
_404.play(null,_403);
}
return this;
},pause:function(){
if(this._anims[this._currAnim]){
this._anims[this._currAnim].pause();
this.fire("onPause",[this._currAnim]);
}
return this;
},playPause:function(){
if(this._anims.length==0){
return this;
}
if(this._currAnim==-1){
this._currAnim=0;
}
var _405=this._anims[this._currAnim];
if(_405){
if(!_405._active||_405._paused){
this.play();
}else{
this.pause();
}
}
return this;
},stop:function(){
var _406=this._anims[this._currAnim];
if(_406){
_406.stop();
this.fire("onStop",[this._currAnim]);
}
return _406;
},_playNext:function(){
if(this._currAnim==-1||this._anims.length==0){
return this;
}
this._currAnim++;
if(this._anims[this._currAnim]){
this._anims[this._currAnim].play(null,true);
}
return this;
}});
dojo.lfx.combine=function(_407){
var _408=arguments;
if(dojo.lang.isArray(arguments[0])){
_408=arguments[0];
}
if(_408.length==1){
return _408[0];
}
return new dojo.lfx.Combine(_408);
};
dojo.lfx.chain=function(_409){
var _40a=arguments;
if(dojo.lang.isArray(arguments[0])){
_40a=arguments[0];
}
if(_40a.length==1){
return _40a[0];
}
return new dojo.lfx.Chain(_40a);
};
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _40d=dojo.global();
var _40e=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_40e.documentElement.clientWidth;
h=_40d.innerHeight;
}else{
if(!dojo.render.html.opera&&_40d.innerWidth){
w=_40d.innerWidth;
h=_40d.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_40e,"documentElement.clientWidth")){
var w2=_40e.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_40e.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _412=dojo.global();
var _413=dojo.doc();
var top=_412.pageYOffset||_413.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_412.pageXOffset||_413.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _418=dojo.doc();
var _419=dojo.byId(node);
type=type.toLowerCase();
while((_419)&&(_419.nodeName.toLowerCase()!=type)){
if(_419==(_418["body"]||_418["documentElement"])){
return null;
}
_419=_419.parentNode;
}
return _419;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _421={x:0,y:0};
if(e.pageX||e.pageY){
_421.x=e.pageX;
_421.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_421.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_421.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _421;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _426=dojo.doc().createElement("script");
_426.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_426);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_429,_42a,args,_42c,_42d){
dojo.deprecated("dojo.html."+_429,"replaced by dojo.html."+_42a+"("+(_42c?"node, {"+_42c+": "+_42c+"}":"")+")"+(_42d?"."+_42d:""),"0.5");
var _42e=[];
if(_42c){
var _42f={};
_42f[_42c]=args[1];
_42e.push(args[0]);
_42e.push(_42f);
}else{
_42e=args;
}
var ret=dojo.html[_42a].apply(dojo.html,args);
if(_42d){
return ret[_42d];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_432,uri){
var loc=dojo.hostenv.getModuleSymbols(_432).join("/");
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
var _435=loc.indexOf(":");
var _436=loc.indexOf("/");
if(loc.charAt(0)!="/"&&(_435==-1||_435>_436)){
loc=dojo.hostenv.getBaseScriptUri()+loc;
}
return new dojo.uri.Uri(loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _439=new dojo.uri.Uri(arguments[i].toString());
var _43a=new dojo.uri.Uri(uri.toString());
if((_439.path=="")&&(_439.scheme==null)&&(_439.authority==null)&&(_439.query==null)){
if(_439.fragment!=null){
_43a.fragment=_439.fragment;
}
_439=_43a;
}else{
if(_439.scheme==null){
_439.scheme=_43a.scheme;
if(_439.authority==null){
_439.authority=_43a.authority;
if(_439.path.charAt(0)!="/"){
var path=_43a.path.substring(0,_43a.path.lastIndexOf("/")+1)+_439.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_439.path=segs.join("/");
}
}
}
}
uri="";
if(_439.scheme!=null){
uri+=_439.scheme+":";
}
if(_439.authority!=null){
uri+="//"+_439.authority;
}
uri+=_439.path;
if(_439.query!=null){
uri+="?"+_439.query;
}
if(_439.fragment!=null){
uri+="#"+_439.fragment;
}
}
this.uri=uri.toString();
var _43e="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_43e));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_43e="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_43e));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_445){
return (new RegExp("(^|\\s+)"+_445+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_447){
_447+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_447);
};
dojo.html.addClass=function(node,_449){
if(dojo.html.hasClass(node,_449)){
return false;
}
_449=(dojo.html.getClass(node)+" "+_449).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_449);
};
dojo.html.setClass=function(node,_44b){
node=dojo.byId(node);
var cs=new String(_44b);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_44b);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_44e,_44f){
try{
if(!_44f){
var _450=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_44e+"(\\s+|$)"),"$1$2");
}else{
var _450=dojo.html.getClass(node).replace(_44e,"");
}
dojo.html.setClass(node,_450);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_452,_453){
dojo.html.removeClass(node,_453);
dojo.html.addClass(node,_452);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_454,_455,_456,_457,_458){
_458=false;
var _459=dojo.doc();
_455=dojo.byId(_455)||_459;
var _45a=_454.split(/\s+/g);
var _45b=[];
if(_457!=1&&_457!=2){
_457=0;
}
var _45c=new RegExp("(\\s|^)(("+_45a.join(")|(")+"))(\\s|$)");
var _45d=_45a.join(" ").length;
var _45e=[];
if(!_458&&_459.evaluate){
var _45f=".//"+(_456||"*")+"[contains(";
if(_457!=dojo.html.classMatchType.ContainsAny){
_45f+="concat(' ',@class,' '), ' "+_45a.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_457==2){
_45f+=" and string-length(@class)="+_45d+"]";
}else{
_45f+="]";
}
}else{
_45f+="concat(' ',@class,' '), ' "+_45a.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _460=_459.evaluate(_45f,_455,null,XPathResult.ANY_TYPE,null);
var _461=_460.iterateNext();
while(_461){
try{
_45e.push(_461);
_461=_460.iterateNext();
}
catch(e){
break;
}
}
return _45e;
}else{
if(!_456){
_456="*";
}
_45e=_455.getElementsByTagName(_456);
var node,i=0;
outer:
while(node=_45e[i++]){
var _464=dojo.html.getClasses(node);
if(_464.length==0){
continue outer;
}
var _465=0;
for(var j=0;j<_464.length;j++){
if(_45c.test(_464[j])){
if(_457==dojo.html.classMatchType.ContainsAny){
_45b.push(node);
continue outer;
}else{
_465++;
}
}else{
if(_457==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_465==_45a.length){
if((_457==dojo.html.classMatchType.IsOnly)&&(_465==_464.length)){
_45b.push(node);
}else{
if(_457==dojo.html.classMatchType.ContainsAll){
_45b.push(node);
}
}
}
}
return _45b;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_467){
var arr=_467.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_46b){
return _46b.replace(/([A-Z])/g,"-$1").toLowerCase();
};
if(dojo.render.html.ie){
dojo.html.getComputedStyle=function(node,_46d,_46e){
node=dojo.byId(node);
if(!node||!node.currentStyle){
return _46e;
}
return node.currentStyle[dojo.html.toCamelCase(_46d)];
};
dojo.html.getComputedStyles=function(node){
return node.currentStyle;
};
}else{
dojo.html.getComputedStyle=function(node,_471,_472){
node=dojo.byId(node);
if(!node||!node.style){
return _472;
}
var s=document.defaultView.getComputedStyle(node,null);
return (s&&s[dojo.html.toCamelCase(_471)])||"";
};
dojo.html.getComputedStyles=function(node){
return document.defaultView.getComputedStyle(node,null);
};
}
dojo.html.getStyleProperty=function(node,_476){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_476)]:undefined);
};
dojo.html.getStyle=function(node,_478){
var _479=dojo.html.getStyleProperty(node,_478);
return (_479?_479:dojo.html.getComputedStyle(node,_478));
};
dojo.html.setStyle=function(node,_47b,_47c){
node=dojo.byId(node);
if(node&&node.style){
var _47d=dojo.html.toCamelCase(_47b);
node.style[_47d]=_47c;
}
};
dojo.html.setStyleText=function(_47e,text){
try{
_47e.style.cssText=text;
}
catch(e){
_47e.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_480,_481){
if(!_481.style.cssText){
_480.setAttribute("style",_481.getAttribute("style"));
}else{
_480.style.cssText=_481.style.cssText;
}
dojo.html.addClass(_480,dojo.html.getClass(_481));
};
dojo.html.getUnitValue=function(node,_483,_484){
var s=dojo.html.getComputedStyle(node,_483);
if((!s)||((s=="auto")&&(_484))){
return {value:0,units:"px"};
}
var _486=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_486){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_486[1]),units:_486[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
if(dojo.render.html.ie){
dojo.html.toPixelValue=function(_487,_488){
if(!_488){
return 0;
}
if(_488.slice(-2)=="px"){
return parseFloat(_488);
}
var _489=0;
with(_487){
var _48a=style.left;
var _48b=runtimeStyle.left;
runtimeStyle.left=currentStyle.left;
try{
style.left=_488||0;
_489=style.pixelLeft;
style.left=_48a;
runtimeStyle.left=_48b;
}
catch(e){
}
}
return _489;
};
}else{
dojo.html.toPixelValue=function(_48c,_48d){
return (_48d&&(_48d.slice(-2)=="px")?parseFloat(_48d):0);
};
}
dojo.html.getPixelValue=function(node,_48f,_490){
return dojo.html.toPixelValue(node,dojo.html.getComputedStyle(node,_48f));
};
dojo.html.setPositivePixelValue=function(node,_492,_493){
if(isNaN(_493)){
return false;
}
node.style[_492]=Math.max(0,_493)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_494,_495,_496){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_496=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_496=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_494+" { "+_495+" }";
return dojo.html.styleSheet.insertRule(rule,_496);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_494,_495,_496);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_498){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_498){
_498=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_498);
}
}else{
if(document.styleSheets[0]){
if(!_498){
_498=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_498);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_49b,_49c){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _49d=dojo.hostenv.getText(URI,false,_49c);
if(_49d===null){
return;
}
_49d=dojo.html.fixPathsInCssText(_49d,URI);
if(_49b){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_49d)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _4a2=doc.getElementsByTagName("style");
for(var i=0;i<_4a2.length;i++){
if(_4a2[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _4a3=dojo.html.insertCssText(_49d,doc);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_49d,"nodeRef":_4a3});
if(_4a3&&djConfig.isDebug){
_4a3.setAttribute("dbgHref",URI);
}
return _4a3;
};
dojo.html.insertCssText=function(_4a4,doc,URI){
if(!_4a4){
return;
}
if(!doc){
doc=document;
}
if(URI){
_4a4=dojo.html.fixPathsInCssText(_4a4,URI);
}
var _4a7=doc.createElement("style");
_4a7.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_4a7);
}
if(_4a7.styleSheet){
var _4a9=function(){
try{
_4a7.styleSheet.cssText=_4a4;
}
catch(e){
dojo.debug(e);
}
};
if(_4a7.styleSheet.disabled){
setTimeout(_4a9,10);
}else{
_4a9();
}
}else{
var _4aa=doc.createTextNode(_4a4);
_4a7.appendChild(_4aa);
}
return _4a7;
};
dojo.html.fixPathsInCssText=function(_4ab,URI){
if(!_4ab||!URI){
return;
}
var _4ad,str="",url="",_4b0="[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
var _4b1=new RegExp("url\\(\\s*("+_4b0+")\\s*\\)");
var _4b2=/(file|https?|ftps?):\/\//;
regexTrim=new RegExp("^[\\s]*(['\"]?)("+_4b0+")\\1[\\s]*?$");
if(dojo.render.html.ie55||dojo.render.html.ie60){
var _4b3=new RegExp("AlphaImageLoader\\((.*)src=['\"]("+_4b0+")['\"]");
while(_4ad=_4b3.exec(_4ab)){
url=_4ad[2].replace(regexTrim,"$2");
if(!_4b2.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_4ab.substring(0,_4ad.index)+"AlphaImageLoader("+_4ad[1]+"src='"+url+"'";
_4ab=_4ab.substr(_4ad.index+_4ad[0].length);
}
_4ab=str+_4ab;
str="";
}
while(_4ad=_4b1.exec(_4ab)){
url=_4ad[1].replace(regexTrim,"$2");
if(!_4b2.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_4ab.substring(0,_4ad.index)+"url("+url+")";
_4ab=_4ab.substr(_4ad.index+_4ad[0].length);
}
return str+_4ab;
};
dojo.html.setActiveStyleSheet=function(_4b4){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_4b4){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("rel").indexOf("alt")==-1&&a.getAttribute("title")){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _4c0={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _4c0){
if(_4c0[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_4c3,_4c4){
node=dojo.byId(node);
_4c4(node,!_4c3(node));
return _4c3(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
dojo.html.setStyle(node,"display",(node.dojoDisplayCache||""));
node.dojoDisplayCache=undefined;
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
if(typeof node["dojoDisplayCache"]=="undefined"){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.dojoDisplayCache=d;
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_4c9){
dojo.html[(_4c9?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_4cf){
dojo.html.setStyle(node,"display",((_4cf instanceof String||typeof _4cf=="string")?_4cf:(_4cf?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_4d3){
dojo.html.setStyle(node,"visibility",((_4d3 instanceof String||typeof _4d3=="string")?_4d3:(_4d3?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_4d7,_4d8){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_4d8){
if(_4d7>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_4d7=0.999999;
}
}else{
if(_4d7<0){
_4d7=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_4d7*100+")";
}
}
node.style.filter="Alpha(Opacity="+_4d7*100+")";
}else{
if(h.moz){
node.style.opacity=_4d7;
node.style.MozOpacity=_4d7;
}else{
if(h.safari){
node.style.opacity=_4d7;
node.style.KhtmlOpacity=_4d7;
}else{
node.style.opacity=_4d7;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.color");
dojo.html.getBackgroundColor=function(node){
node=dojo.byId(node);
var _4e3;
do{
_4e3=dojo.html.getStyle(node,"background-color");
if(_4e3.toLowerCase()=="rgba(0, 0, 0, 0)"){
_4e3="transparent";
}
if(node==document.getElementsByTagName("body")[0]){
node=null;
break;
}
node=node.parentNode;
}while(node&&dojo.lang.inArray(["transparent",""],_4e3));
if(_4e3=="transparent"){
_4e3=[255,255,255,0];
}else{
_4e3=dojo.gfx.color.extractRGB(_4e3);
}
return _4e3;
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _4e6=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_4e6+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _4e6;
};
dojo.html.setStyleAttributes=function(node,_4e9){
node=dojo.byId(node);
var _4ea=_4e9.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_4ea.length;i++){
var _4ec=_4ea[i].split(":");
var name=_4ec[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _4ee=_4ec[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_4ee);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_4ee});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_4ee});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_4ee});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_4ee});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_4ee;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_4f0,_4f1){
node=dojo.byId(node,node.ownerDocument);
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_4f1){
_4f1=bs.CONTENT_BOX;
}
var _4f4=2;
var _4f5;
switch(_4f1){
case bs.MARGIN_BOX:
_4f5=3;
break;
case bs.BORDER_BOX:
_4f5=2;
break;
case bs.PADDING_BOX:
default:
_4f5=1;
break;
case bs.CONTENT_BOX:
_4f5=0;
break;
}
var h=dojo.render.html;
var db=document["body"]||document["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(document.getBoxObjectFor){
_4f4=1;
try{
var bo=document.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _4f9;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_4f9=db;
}else{
_4f9=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _4fb=node;
do{
var n=_4fb["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_4fb["offsetTop"];
ret.y+=isNaN(m)?0:m;
_4fb=_4fb.offsetParent;
}while((_4fb!=_4f9)&&(_4fb!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_4f0){
var _4fe=dojo.html.getScroll();
ret.y+=_4fe.top;
ret.x+=_4fe.left;
}
var _4ff=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_4f4>_4f5){
for(var i=_4f5;i<_4f4;++i){
ret.y+=_4ff[i](node,"top");
ret.x+=_4ff[i](node,"left");
}
}else{
if(_4f4<_4f5){
for(var i=_4f5;i>_4f4;--i){
ret.y-=_4ff[i-1](node,"top");
ret.x-=_4ff[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._sumPixelValues=function(node,_503,_504){
var _505=0;
for(var x=0;x<_503.length;x++){
_505+=dojo.html.getPixelValue(node,_503[x],_504);
}
return _505;
};
dojo.html.getMargin=function(node){
return {width:dojo.html._sumPixelValues(node,["margin-left","margin-right"],(dojo.html.getComputedStyle(node,"position")=="absolute")),height:dojo.html._sumPixelValues(node,["margin-top","margin-bottom"],(dojo.html.getComputedStyle(node,"position")=="absolute"))};
};
dojo.html.getBorder=function(node){
return {width:dojo.html.getBorderExtent(node,"left")+dojo.html.getBorderExtent(node,"right"),height:dojo.html.getBorderExtent(node,"top")+dojo.html.getBorderExtent(node,"bottom")};
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html._sumPixelValues(node,["margin-"+side],dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html._sumPixelValues(node,["padding-"+side],true);
};
dojo.html.getPadding=function(node){
return {width:dojo.html._sumPixelValues(node,["padding-left","padding-right"],true),height:dojo.html._sumPixelValues(node,["padding-top","padding-bottom"],true)};
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _512=dojo.html.getBorder(node);
return {width:pad.width+_512.width,height:pad.height+_512.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if(((h.ie)||(h.opera))&&node.nodeName.toLowerCase()!="img"){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _517;
if(!h.ie){
_517=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_517){
_517=dojo.html.getStyle(node,"box-sizing");
}
}
return (_517?_517:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _51c=dojo.html.getBorder(node);
return {width:box.width-_51c.width,height:box.height-_51c.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _51e=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_51e.width,height:node.offsetHeight-_51e.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _521=0;
var _522=0;
var isbb=dojo.html.isBorderBox(node);
var _524=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_521=args.width+_524.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_521);
}
if(typeof args.height!="undefined"){
_522=args.height+_524.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_522);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _527=dojo.html.getBorderBox(node);
var _528=dojo.html.getMargin(node);
return {width:_527.width+_528.width,height:_527.height+_528.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _52b=0;
var _52c=0;
var isbb=dojo.html.isBorderBox(node);
var _52e=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _52f=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_52b=args.width-_52e.width;
_52b-=_52f.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_52b);
}
if(typeof args.height!="undefined"){
_52c=args.height-_52e.height;
_52c-=_52f.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_52c);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_534,_535,_536){
if(_534 instanceof Array||typeof _534=="array"){
dojo.deprecated("dojo.html.toCoordinateArray","use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead","0.5");
while(_534.length<4){
_534.push(0);
}
while(_534.length>4){
_534.pop();
}
var ret={left:_534[0],top:_534[1],width:_534[2],height:_534[3]};
}else{
if(!_534.nodeType&&!(_534 instanceof String||typeof _534=="string")&&("width" in _534||"height" in _534||"left" in _534||"x" in _534||"top" in _534||"y" in _534)){
var ret={left:_534.left||_534.x||0,top:_534.top||_534.y||0,width:_534.width||0,height:_534.height||0};
}else{
var node=dojo.byId(_534);
var pos=dojo.html.abs(node,_535,_536);
var _53a=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_53a.width,height:_53a.height};
}
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_53c){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_53f){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_541){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_543){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_545){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_547){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_551){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_553){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.lfx.html");
dojo.lfx.html._byId=function(_554){
if(!_554){
return [];
}
if(dojo.lang.isArrayLike(_554)){
if(!_554.alreadyChecked){
var n=[];
dojo.lang.forEach(_554,function(node){
n.push(dojo.byId(node));
});
n.alreadyChecked=true;
return n;
}else{
return _554;
}
}else{
var n=[];
n.push(dojo.byId(_554));
n.alreadyChecked=true;
return n;
}
};
dojo.lfx.html.propertyAnimation=function(_557,_558,_559,_55a,_55b){
_557=dojo.lfx.html._byId(_557);
var _55c={"propertyMap":_558,"nodes":_557,"duration":_559,"easing":_55a||dojo.lfx.easeDefault};
var _55d=function(args){
if(args.nodes.length==1){
var pm=args.propertyMap;
if(!dojo.lang.isArray(args.propertyMap)){
var parr=[];
for(var _561 in pm){
pm[_561].property=_561;
parr.push(pm[_561]);
}
pm=args.propertyMap=parr;
}
dojo.lang.forEach(pm,function(prop){
if(dj_undef("start",prop)){
if(prop.property!="opacity"){
prop.start=parseInt(dojo.html.getComputedStyle(args.nodes[0],prop.property));
}else{
prop.start=dojo.html.getOpacity(args.nodes[0]);
}
}
});
}
};
var _563=function(_564){
var _565=[];
dojo.lang.forEach(_564,function(c){
_565.push(Math.round(c));
});
return _565;
};
var _567=function(n,_569){
n=dojo.byId(n);
if(!n||!n.style){
return;
}
for(var s in _569){
try{
if(s=="opacity"){
dojo.html.setOpacity(n,_569[s]);
}else{
n.style[s]=_569[s];
}
}
catch(e){
dojo.debug(e);
}
}
};
var _56b=function(_56c){
this._properties=_56c;
this.diffs=new Array(_56c.length);
dojo.lang.forEach(_56c,function(prop,i){
if(dojo.lang.isFunction(prop.start)){
prop.start=prop.start(prop,i);
}
if(dojo.lang.isFunction(prop.end)){
prop.end=prop.end(prop,i);
}
if(dojo.lang.isArray(prop.start)){
this.diffs[i]=null;
}else{
if(prop.start instanceof dojo.gfx.color.Color){
prop.startRgb=prop.start.toRgb();
prop.endRgb=prop.end.toRgb();
}else{
this.diffs[i]=prop.end-prop.start;
}
}
},this);
this.getValue=function(n){
var ret={};
dojo.lang.forEach(this._properties,function(prop,i){
var _573=null;
if(dojo.lang.isArray(prop.start)){
}else{
if(prop.start instanceof dojo.gfx.color.Color){
_573=(prop.units||"rgb")+"(";
for(var j=0;j<prop.startRgb.length;j++){
_573+=Math.round(((prop.endRgb[j]-prop.startRgb[j])*n)+prop.startRgb[j])+(j<prop.startRgb.length-1?",":"");
}
_573+=")";
}else{
_573=((this.diffs[i])*n)+prop.start+(prop.property!="opacity"?prop.units||"px":"");
}
}
ret[dojo.html.toCamelCase(prop.property)]=_573;
},this);
return ret;
};
};
var anim=new dojo.lfx.Animation({beforeBegin:function(){
_55d(_55c);
anim.curve=new _56b(_55c.propertyMap);
},onAnimate:function(_576){
dojo.lang.forEach(_55c.nodes,function(node){
_567(node,_576);
});
}},_55c.duration,null,_55c.easing);
if(_55b){
for(var x in _55b){
if(dojo.lang.isFunction(_55b[x])){
anim.connect(x,anim,_55b[x]);
}
}
}
return anim;
};
dojo.lfx.html._makeFadeable=function(_579){
var _57a=function(node){
if(dojo.render.html.ie){
if((node.style.zoom.length==0)&&(dojo.html.getStyle(node,"zoom")=="normal")){
node.style.zoom="1";
}
if((node.style.width.length==0)&&(dojo.html.getStyle(node,"width")=="auto")){
node.style.width="auto";
}
}
};
if(dojo.lang.isArrayLike(_579)){
dojo.lang.forEach(_579,_57a);
}else{
_57a(_579);
}
};
dojo.lfx.html.fade=function(_57c,_57d,_57e,_57f,_580){
_57c=dojo.lfx.html._byId(_57c);
var _581={property:"opacity"};
if(!dj_undef("start",_57d)){
_581.start=_57d.start;
}else{
_581.start=function(){
return dojo.html.getOpacity(_57c[0]);
};
}
if(!dj_undef("end",_57d)){
_581.end=_57d.end;
}else{
dojo.raise("dojo.lfx.html.fade needs an end value");
}
var anim=dojo.lfx.propertyAnimation(_57c,[_581],_57e,_57f);
anim.connect("beforeBegin",function(){
dojo.lfx.html._makeFadeable(_57c);
});
if(_580){
anim.connect("onEnd",function(){
_580(_57c,anim);
});
}
return anim;
};
dojo.lfx.html.fadeIn=function(_583,_584,_585,_586){
return dojo.lfx.html.fade(_583,{end:1},_584,_585,_586);
};
dojo.lfx.html.fadeOut=function(_587,_588,_589,_58a){
return dojo.lfx.html.fade(_587,{end:0},_588,_589,_58a);
};
dojo.lfx.html.fadeShow=function(_58b,_58c,_58d,_58e){
_58b=dojo.lfx.html._byId(_58b);
dojo.lang.forEach(_58b,function(node){
dojo.html.setOpacity(node,0);
});
var anim=dojo.lfx.html.fadeIn(_58b,_58c,_58d,_58e);
anim.connect("beforeBegin",function(){
if(dojo.lang.isArrayLike(_58b)){
dojo.lang.forEach(_58b,dojo.html.show);
}else{
dojo.html.show(_58b);
}
});
return anim;
};
dojo.lfx.html.fadeHide=function(_591,_592,_593,_594){
var anim=dojo.lfx.html.fadeOut(_591,_592,_593,function(){
if(dojo.lang.isArrayLike(_591)){
dojo.lang.forEach(_591,dojo.html.hide);
}else{
dojo.html.hide(_591);
}
if(_594){
_594(_591,anim);
}
});
return anim;
};
dojo.lfx.html.wipeIn=function(_596,_597,_598,_599){
_596=dojo.lfx.html._byId(_596);
var _59a=[];
dojo.lang.forEach(_596,function(node){
var _59c={};
var _59d,_59e,_59f;
with(node.style){
_59d=top;
_59e=left;
_59f=position;
top="-9999px";
left="-9999px";
position="absolute";
display="";
}
var _5a0=dojo.html.getBorderBox(node).height;
with(node.style){
top=_59d;
left=_59e;
position=_59f;
display="none";
}
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:1,end:function(){
return _5a0;
}}},_597,_598);
anim.connect("beforeBegin",function(){
_59c.overflow=node.style.overflow;
_59c.height=node.style.height;
with(node.style){
overflow="hidden";
height="1px";
}
dojo.html.show(node);
});
anim.connect("onEnd",function(){
with(node.style){
overflow=_59c.overflow;
height=_59c.height;
}
if(_599){
_599(node,anim);
}
});
_59a.push(anim);
});
return dojo.lfx.combine(_59a);
};
dojo.lfx.html.wipeOut=function(_5a2,_5a3,_5a4,_5a5){
_5a2=dojo.lfx.html._byId(_5a2);
var _5a6=[];
dojo.lang.forEach(_5a2,function(node){
var _5a8={};
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:function(){
return dojo.html.getContentBox(node).height;
},end:1}},_5a3,_5a4,{"beforeBegin":function(){
_5a8.overflow=node.style.overflow;
_5a8.height=node.style.height;
with(node.style){
overflow="hidden";
}
dojo.html.show(node);
},"onEnd":function(){
dojo.html.hide(node);
with(node.style){
overflow=_5a8.overflow;
height=_5a8.height;
}
if(_5a5){
_5a5(node,anim);
}
}});
_5a6.push(anim);
});
return dojo.lfx.combine(_5a6);
};
dojo.lfx.html.slideTo=function(_5aa,_5ab,_5ac,_5ad,_5ae){
_5aa=dojo.lfx.html._byId(_5aa);
var _5af=[];
var _5b0=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_5ab)){
dojo.deprecated("dojo.lfx.html.slideTo(node, array)","use dojo.lfx.html.slideTo(node, {top: value, left: value});","0.5");
_5ab={top:_5ab[0],left:_5ab[1]};
}
dojo.lang.forEach(_5aa,function(node){
var top=null;
var left=null;
var init=(function(){
var _5b5=node;
return function(){
var pos=_5b0(_5b5,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_5b0(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_5b0(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_5b5,true);
dojo.html.setStyleAttributes(_5b5,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:(_5ab.top||0)},"left":{start:left,end:(_5ab.left||0)}},_5ac,_5ad,{"beforeBegin":init});
if(_5ae){
anim.connect("onEnd",function(){
_5ae(_5aa,anim);
});
}
_5af.push(anim);
});
return dojo.lfx.combine(_5af);
};
dojo.lfx.html.slideBy=function(_5b9,_5ba,_5bb,_5bc,_5bd){
_5b9=dojo.lfx.html._byId(_5b9);
var _5be=[];
var _5bf=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_5ba)){
dojo.deprecated("dojo.lfx.html.slideBy(node, array)","use dojo.lfx.html.slideBy(node, {top: value, left: value});","0.5");
_5ba={top:_5ba[0],left:_5ba[1]};
}
dojo.lang.forEach(_5b9,function(node){
var top=null;
var left=null;
var init=(function(){
var _5c4=node;
return function(){
var pos=_5bf(_5c4,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_5bf(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_5bf(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_5c4,true);
dojo.html.setStyleAttributes(_5c4,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:top+(_5ba.top||0)},"left":{start:left,end:left+(_5ba.left||0)}},_5bb,_5bc).connect("beforeBegin",init);
if(_5bd){
anim.connect("onEnd",function(){
_5bd(_5b9,anim);
});
}
_5be.push(anim);
});
return dojo.lfx.combine(_5be);
};
dojo.lfx.html.explode=function(_5c8,_5c9,_5ca,_5cb,_5cc){
var h=dojo.html;
_5c8=dojo.byId(_5c8);
_5c9=dojo.byId(_5c9);
var _5ce=h.toCoordinateObject(_5c8,true);
var _5cf=document.createElement("div");
h.copyStyle(_5cf,_5c9);
if(_5c9.explodeClassName){
_5cf.className=_5c9.explodeClassName;
}
with(_5cf.style){
position="absolute";
display="none";
var _5d0=h.getStyle(_5c8,"background-color");
backgroundColor=_5d0?_5d0.toLowerCase():"transparent";
backgroundColor=(backgroundColor=="transparent")?"rgb(221, 221, 221)":backgroundColor;
}
dojo.body().appendChild(_5cf);
with(_5c9.style){
visibility="hidden";
display="block";
}
var _5d1=h.toCoordinateObject(_5c9,true);
with(_5c9.style){
display="none";
visibility="visible";
}
var _5d2={opacity:{start:0.5,end:1}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_5d2[type]={start:_5ce[type],end:_5d1[type]};
});
var anim=new dojo.lfx.propertyAnimation(_5cf,_5d2,_5ca,_5cb,{"beforeBegin":function(){
h.setDisplay(_5cf,"block");
},"onEnd":function(){
h.setDisplay(_5c9,"block");
_5cf.parentNode.removeChild(_5cf);
}});
if(_5cc){
anim.connect("onEnd",function(){
_5cc(_5c9,anim);
});
}
return anim;
};
dojo.lfx.html.implode=function(_5d5,end,_5d7,_5d8,_5d9){
var h=dojo.html;
_5d5=dojo.byId(_5d5);
end=dojo.byId(end);
var _5db=dojo.html.toCoordinateObject(_5d5,true);
var _5dc=dojo.html.toCoordinateObject(end,true);
var _5dd=document.createElement("div");
dojo.html.copyStyle(_5dd,_5d5);
if(_5d5.explodeClassName){
_5dd.className=_5d5.explodeClassName;
}
dojo.html.setOpacity(_5dd,0.3);
with(_5dd.style){
position="absolute";
display="none";
backgroundColor=h.getStyle(_5d5,"background-color").toLowerCase();
}
dojo.body().appendChild(_5dd);
var _5de={opacity:{start:1,end:0.5}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_5de[type]={start:_5db[type],end:_5dc[type]};
});
var anim=new dojo.lfx.propertyAnimation(_5dd,_5de,_5d7,_5d8,{"beforeBegin":function(){
dojo.html.hide(_5d5);
dojo.html.show(_5dd);
},"onEnd":function(){
_5dd.parentNode.removeChild(_5dd);
}});
if(_5d9){
anim.connect("onEnd",function(){
_5d9(_5d5,anim);
});
}
return anim;
};
dojo.lfx.html.highlight=function(_5e1,_5e2,_5e3,_5e4,_5e5){
_5e1=dojo.lfx.html._byId(_5e1);
var _5e6=[];
dojo.lang.forEach(_5e1,function(node){
var _5e8=dojo.html.getBackgroundColor(node);
var bg=dojo.html.getStyle(node,"background-color").toLowerCase();
var _5ea=dojo.html.getStyle(node,"background-image");
var _5eb=(bg=="transparent"||bg=="rgba(0, 0, 0, 0)");
while(_5e8.length>3){
_5e8.pop();
}
var rgb=new dojo.gfx.color.Color(_5e2);
var _5ed=new dojo.gfx.color.Color(_5e8);
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:rgb,end:_5ed}},_5e3,_5e4,{"beforeBegin":function(){
if(_5ea){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+rgb.toRgb().join(",")+")";
},"onEnd":function(){
if(_5ea){
node.style.backgroundImage=_5ea;
}
if(_5eb){
node.style.backgroundColor="transparent";
}
if(_5e5){
_5e5(node,anim);
}
}});
_5e6.push(anim);
});
return dojo.lfx.combine(_5e6);
};
dojo.lfx.html.unhighlight=function(_5ef,_5f0,_5f1,_5f2,_5f3){
_5ef=dojo.lfx.html._byId(_5ef);
var _5f4=[];
dojo.lang.forEach(_5ef,function(node){
var _5f6=new dojo.gfx.color.Color(dojo.html.getBackgroundColor(node));
var rgb=new dojo.gfx.color.Color(_5f0);
var _5f8=dojo.html.getStyle(node,"background-image");
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:_5f6,end:rgb}},_5f1,_5f2,{"beforeBegin":function(){
if(_5f8){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+_5f6.toRgb().join(",")+")";
},"onEnd":function(){
if(_5f3){
_5f3(node,anim);
}
}});
_5f4.push(anim);
});
return dojo.lfx.combine(_5f4);
};
dojo.lang.mixin(dojo.lfx,dojo.lfx.html);
dojo.kwCompoundRequire({browser:["dojo.lfx.html"],dashboard:["dojo.lfx.html"]});
dojo.provide("dojo.lfx.*");


__CPAN_EDITION__ ajax build.txt
Files baked into this build:

dojo.js:
dojoGuardStart.js
../src/bootstrap1.js
../src/loader.js
dojoGuardEnd.js
../src/hostenv_browser.js
../src/string/common.js
../src/string.js
../src/lang/common.js
../src/lang/extras.js
../src/io/common.js
../src/lang/array.js
../src/lang/func.js
../src/string/extras.js
../src/dom.js
../src/undo/browser.js
../src/io/BrowserIO.js
../src/io/cookie.js
../src/io/__package__.js
../src/event/common.js
../src/event/topic.js
../src/event/browser.js
../src/event/__package__.js
../src/gfx/color.js
../src/lfx/Animation.js
../src/html/common.js
../src/uri/Uri.js
../src/html/style.js
../src/html/display.js
../src/html/color.js
../src/html/layout.js
../src/lfx/html.js
../src/lfx/__package__.js

__CPAN_EDITION__ charting dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:3,flag:"",revision:Number("$Rev: 8617 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
dojo.hostenv._djInitFired=false;
function dj_load_init(e){
dojo.hostenv._djInitFired=true;
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_ee,_ef){
if(!dojo.lang.isFunction(_ef)){
dojo.raise("dojo.inherits: superclass argument ["+_ef+"] must be a function (subclass: ["+_ee+"']");
}
_ee.prototype=new _ef();
_ee.prototype.constructor=_ee;
_ee.superclass=_ef.prototype;
_ee["super"]=_ef.prototype;
};
dojo.lang._mixin=function(obj,_f1){
var _f2={};
for(var x in _f1){
if((typeof _f2[x]=="undefined")||(_f2[x]!=_f1[x])){
obj[x]=_f1[x];
}
}
if(dojo.render.html.ie&&(typeof (_f1["toString"])=="function")&&(_f1["toString"]!=obj["toString"])&&(_f1["toString"]!=_f2["toString"])){
obj.toString=_f1.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_f5){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_f8,_f9){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_f8.prototype,arguments[i]);
}
return _f8;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_fc,_fd,_fe,_ff){
if(!dojo.lang.isArrayLike(_fc)&&dojo.lang.isArrayLike(_fd)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_fc;
_fc=_fd;
_fd=temp;
}
var _101=dojo.lang.isString(_fc);
if(_101){
_fc=_fc.split("");
}
if(_ff){
var step=-1;
var i=_fc.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_fc.length;
}
if(_fe){
while(i!=end){
if(_fc[i]===_fd){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_fc[i]==_fd){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_105,_106,_107){
return dojo.lang.find(_105,_106,_107,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_108,_109){
return dojo.lang.find(_108,_109)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_114,_115){
var args=[];
for(var x=2;x<arguments.length;x++){
args.push(arguments[x]);
}
var fcn=(dojo.lang.isString(_115)?_114[_115]:_115)||function(){
};
return function(){
var ta=args.concat([]);
for(var x=0;x<arguments.length;x++){
ta.push(arguments[x]);
}
return fcn.apply(_114,ta);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_11b,_11c,_11d){
var nso=(_11c||dojo.lang.anon);
if((_11d)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_11b){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_11b;
return ret;
};
dojo.lang.forward=function(_121){
return function(){
return this[_121].apply(this,arguments);
};
};
dojo.lang.curry=function(_122,func){
var _124=[];
_122=_122||dj_global;
if(dojo.lang.isString(func)){
func=_122[func];
}
for(var x=2;x<arguments.length;x++){
_124.push(arguments[x]);
}
var _126=(func["__preJoinArity"]||func.length)-_124.length;
function gather(_127,_128,_129){
var _12a=_129;
var _12b=_128.slice(0);
for(var x=0;x<_127.length;x++){
_12b.push(_127[x]);
}
_129=_129-_127.length;
if(_129<=0){
var res=func.apply(_122,_12b);
_129=_12a;
return res;
}else{
return function(){
return gather(arguments,_12b,_129);
};
}
}
return gather([],_124,_126);
};
dojo.lang.curryArguments=function(_12e,func,args,_131){
var _132=[];
var x=_131||0;
for(x=_131;x<args.length;x++){
_132.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_12e,func].concat(_132));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_138,_139){
if(!farr.length){
if(typeof _139=="function"){
_139();
}
return;
}
if((typeof _138=="undefined")&&(typeof cb=="number")){
_138=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_138){
_138=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_138,_139);
},_138);
};
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_140,_141){
var out="";
for(var i=0;i<_140;i++){
out+=str;
if(_141&&i<_140-1){
out+=_141;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _153=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_153++;
break;
}
}
return _153==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_157){
var _158=dojo.lang.isString(arr);
if(_158){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_157)){
_157=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_157){
var _159=obj;
obj=_157;
_157=_159;
}
}
if(Array.map){
var _15a=Array.map(arr,_157,obj);
}else{
var _15a=[];
for(var i=0;i<arr.length;++i){
_15a.push(_157.call(obj,arr[i]));
}
}
if(_158){
return _15a.join("");
}else{
return _15a;
}
},reduce:function(arr,_15d,obj,_15f){
var _160=_15d;
if(arguments.length==2){
_15f=_15d;
_160=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_15f=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_15f;
_15f=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_160=_15f.call(ob,_160,val);
});
return _160;
},forEach:function(_164,_165,_166){
if(dojo.lang.isString(_164)){
_164=_164.split("");
}
if(Array.forEach){
Array.forEach(_164,_165,_166);
}else{
if(!_166){
_166=dj_global;
}
for(var i=0,l=_164.length;i<l;i++){
_165.call(_166,_164[i],i,_164);
}
}
},_everyOrSome:function(_169,arr,_16b,_16c){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_169?"every":"some"](arr,_16b,_16c);
}else{
if(!_16c){
_16c=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _16f=_16b.call(_16c,arr[i],i,arr);
if(_169&&!_16f){
return false;
}else{
if((!_169)&&(_16f)){
return true;
}
}
}
return Boolean(_169);
}
},every:function(arr,_171,_172){
return this._everyOrSome(true,arr,_171,_172);
},some:function(arr,_174,_175){
return this._everyOrSome(false,arr,_174,_175);
},filter:function(arr,_177,_178){
var _179=dojo.lang.isString(arr);
if(_179){
arr=arr.split("");
}
var _17a;
if(Array.filter){
_17a=Array.filter(arr,_177,_178);
}else{
if(!_178){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_178=dj_global;
}
_17a=[];
for(var i=0;i<arr.length;i++){
if(_177.call(_178,arr[i],i,arr)){
_17a.push(arr[i]);
}
}
}
if(_179){
return _17a.join("");
}else{
return _17a;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_17f,_180){
var _181=[];
for(var i=_180||0;i<_17f.length;i++){
_181.push(_17f[i]);
}
return _181;
}});
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_183,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _183.replace(/\%\{(\w+)\}/g,function(_186,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _189=str.split(" ");
for(var i=0;i<_189.length;i++){
_189[i]=_189[i].charAt(0).toUpperCase()+_189[i].substring(1);
}
return _189.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _18e=escape(str);
var _18f,re=/%u([0-9A-F]{4})/i;
while((_18f=_18e.match(re))){
var num=Number("0x"+_18f[1]);
var _192=escape("&#"+num+";");
ret+=_18e.substring(0,_18f.index)+_192;
_18e=_18e.substring(_18f.index+_18f[0].length);
}
ret+=_18e.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_197){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_197){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_1a0){
if(_1a0){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_1a4,_1a5){
if(_1a5){
str=str.toLowerCase();
_1a4=_1a4.toLowerCase();
}
return str.indexOf(_1a4)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_1ab){
if(_1ab=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_1ab=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_1ad){
var _1ae=[];
for(var i=0,_1b0=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_1ad){
_1ae.push(str.substring(_1b0,i));
_1b0=i+1;
}
}
_1ae.push(str.substr(_1b0));
return _1ae;
};
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_1b1){
this.pairs=[];
this.returnWrappers=_1b1||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_1b3,wrap,_1b5,_1b6){
var type=(_1b6)?"unshift":"push";
this.pairs[type]([name,_1b3,wrap,_1b5]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.json");
dojo.json={jsonRegistry:new dojo.AdapterRegistry(),register:function(name,_1be,wrap,_1c0){
dojo.json.jsonRegistry.register(name,_1be,wrap,_1c0);
},evalJson:function(json){
try{
return eval("("+json+")");
}
catch(e){
dojo.debug(e);
return json;
}
},serialize:function(o){
var _1c3=typeof (o);
if(_1c3=="undefined"){
return "undefined";
}else{
if((_1c3=="number")||(_1c3=="boolean")){
return o+"";
}else{
if(o===null){
return "null";
}
}
}
if(_1c3=="string"){
return dojo.string.escapeString(o);
}
var me=arguments.callee;
var _1c5;
if(typeof (o.__json__)=="function"){
_1c5=o.__json__();
if(o!==_1c5){
return me(_1c5);
}
}
if(typeof (o.json)=="function"){
_1c5=o.json();
if(o!==_1c5){
return me(_1c5);
}
}
if(_1c3!="function"&&typeof (o.length)=="number"){
var res=[];
for(var i=0;i<o.length;i++){
var val=me(o[i]);
if(typeof (val)!="string"){
val="undefined";
}
res.push(val);
}
return "["+res.join(",")+"]";
}
try{
window.o=o;
_1c5=dojo.json.jsonRegistry.match(o);
return me(_1c5);
}
catch(e){
}
if(_1c3=="function"){
return null;
}
res=[];
for(var k in o){
var _1ca;
if(typeof (k)=="number"){
_1ca="\""+k+"\"";
}else{
if(typeof (k)=="string"){
_1ca=dojo.string.escapeString(k);
}else{
continue;
}
}
val=me(o[k]);
if(typeof (val)!="string"){
continue;
}
res.push(_1ca+":"+val);
}
return "{"+res.join(",")+"}";
}};
dojo.provide("dojo.collections.Store");
dojo.collections.Store=function(_1cb){
var data=[];
var _1cd={};
this.keyField="Id";
this.get=function(){
return data;
};
this.getByKey=function(key){
return _1cd[key];
};
this.getByIndex=function(idx){
return data[idx];
};
this.getIndexOf=function(key){
for(var i=0;i<data.length;i++){
if(data[i].key==key){
return i;
}
}
return -1;
};
this.getData=function(){
var arr=[];
for(var i=0;i<data.length;i++){
arr.push(data[i].src);
}
return arr;
};
this.getDataByKey=function(key){
if(_1cd[key]!=null){
return _1cd[key].src;
}
return null;
};
this.getIndexOfData=function(obj){
for(var i=0;i<data.length;i++){
if(data[i].src==obj){
return i;
}
}
return -1;
};
this.getDataByIndex=function(idx){
if(data[idx]){
return data[idx].src;
}
return null;
};
this.update=function(obj,_1d9,val,_1db){
var _1dc=_1d9.split("."),i=0,o=obj,_1df;
if(_1dc.length>1){
_1df=_1dc.pop();
do{
if(_1dc[i].indexOf("()")>-1){
var temp=_1dc[i++].split("()")[0];
if(!o[temp]){
dojo.raise("dojo.collections.Store.getField(obj, '"+_1df+"'): '"+temp+"' is not a property of the passed object.");
}else{
o=o[temp]();
}
}else{
o=o[_1dc[i++]];
}
}while(i<_1dc.length&&o!=null);
}else{
_1df=_1dc[0];
}
obj[_1df]=val;
if(!_1db){
this.onUpdateField(obj,_1d9,val);
}
};
this.forEach=function(fn){
if(Array.forEach){
Array.forEach(data,fn,this);
}else{
for(var i=0;i<data.length;i++){
fn.call(this,data[i]);
}
}
};
this.forEachData=function(fn){
if(Array.forEach){
Array.forEach(this.getData(),fn,this);
}else{
var a=this.getData();
for(var i=0;i<a.length;i++){
fn.call(this,a[i]);
}
}
};
this.setData=function(arr,_1e7){
data=[];
for(var i=0;i<arr.length;i++){
var o={key:arr[i][this.keyField],src:arr[i]};
data.push(o);
_1cd[o.key]=o;
}
if(!_1e7){
this.onSetData();
}
};
this.clearData=function(_1ea){
data=[];
_1cd={};
if(!_1ea){
this.onClearData();
}
};
this.addData=function(obj,key,_1ed){
var k=key||obj[this.keyField];
if(_1cd[k]!=null){
var o=_1cd[k];
o.src=obj;
}else{
var o={key:k,src:obj};
data.push(o);
_1cd[o.key]=o;
}
if(!_1ed){
this.onAddData(o);
}
};
this.addDataRange=function(arr,_1f1){
var _1f2=[];
for(var i=0;i<arr.length;i++){
var k=arr[i][this.keyField];
if(_1cd[k]!=null){
var o=_1cd[k];
o.src=arr[i];
}else{
var o={key:k,src:arr[i]};
data.push(o);
_1cd[k]=o;
}
_1f2.push(o);
}
if(!_1f1){
this.onAddDataRange(_1f2);
}
};
this.addDataByIndex=function(obj,idx,key,_1f9){
var k=key||obj[this.keyField];
if(_1cd[k]!=null){
var i=this.getIndexOf(k);
var o=data.splice(i,1);
o.src=obj;
}else{
var o={key:k,src:obj};
_1cd[k]=o;
}
data.splice(idx,0,o);
if(!_1f9){
this.onAddData(o);
}
};
this.addDataRangeByIndex=function(arr,idx,_1ff){
var _200=[];
for(var i=0;i<arr.length;i++){
var k=arr[i][this.keyField];
if(_1cd[k]!=null){
var j=this.getIndexOf(k);
var o=data.splice(j,1);
o.src=arr[i];
}else{
var o={key:k,src:arr[i]};
_1cd[k]=o;
}
_200.push(o);
}
data.splice(idx,0,_200);
if(!_1ff){
this.onAddDataRange(_200);
}
};
this.removeData=function(obj,_206){
var idx=-1;
var o=null;
for(var i=0;i<data.length;i++){
if(data[i].src==obj){
idx=i;
o=data[i];
break;
}
}
if(!_206){
this.onRemoveData(o);
}
if(idx>-1){
data.splice(idx,1);
delete _1cd[o.key];
}
};
this.removeDataRange=function(idx,_20b,_20c){
var ret=data.splice(idx,_20b);
for(var i=0;i<ret.length;i++){
delete _1cd[ret[i].key];
}
if(!_20c){
this.onRemoveDataRange(ret);
}
return ret;
};
this.removeDataByKey=function(key,_210){
this.removeData(this.getDataByKey(key),_210);
};
this.removeDataByIndex=function(idx,_212){
this.removeData(this.getDataByIndex(idx),_212);
};
if(_1cb&&_1cb.length&&_1cb[0]){
this.setData(_1cb,true);
}
};
dojo.extend(dojo.collections.Store,{getField:function(obj,_214){
var _215=_214.split("."),i=0,o=obj;
do{
if(_215[i].indexOf("()")>-1){
var temp=_215[i++].split("()")[0];
if(!o[temp]){
dojo.raise("dojo.collections.Store.getField(obj, '"+_214+"'): '"+temp+"' is not a property of the passed object.");
}else{
o=o[temp]();
}
}else{
o=o[_215[i++]];
}
}while(i<_215.length&&o!=null);
if(i<_215.length){
dojo.raise("dojo.collections.Store.getField(obj, '"+_214+"'): '"+_214+"' is not a property of the passed object.");
}
return o;
},getFromHtml:function(meta,body,_21b){
var rows=body.rows;
var ctor=function(row){
var obj={};
for(var i=0;i<meta.length;i++){
var o=obj;
var data=row.cells[i].innerHTML;
var p=meta[i].getField();
if(p.indexOf(".")>-1){
p=p.split(".");
while(p.length>1){
var pr=p.shift();
o[pr]={};
o=o[pr];
}
p=p[0];
}
var type=meta[i].getType();
if(type==String){
o[p]=data;
}else{
if(data){
o[p]=new type(data);
}else{
o[p]=new type();
}
}
}
return obj;
};
var arr=[];
for(var i=0;i<rows.length;i++){
var o=ctor(rows[i]);
if(_21b){
_21b(o,rows[i]);
}
arr.push(o);
}
return arr;
},onSetData:function(){
},onClearData:function(){
},onAddData:function(obj){
},onAddDataRange:function(arr){
},onRemoveData:function(obj){
},onRemoveDataRange:function(arr){
},onUpdateField:function(obj,_22e,val){
}});
dojo.provide("dojo.gfx.color");
dojo.gfx.color.Color=function(r,g,b,a){
if(dojo.lang.isArray(r)){
this.r=r[0];
this.g=r[1];
this.b=r[2];
this.a=r[3]||1;
}else{
if(dojo.lang.isString(r)){
var rgb=dojo.gfx.color.extractRGB(r);
this.r=rgb[0];
this.g=rgb[1];
this.b=rgb[2];
this.a=g||1;
}else{
if(r instanceof dojo.gfx.color.Color){
this.r=r.r;
this.b=r.b;
this.g=r.g;
this.a=r.a;
}else{
this.r=r;
this.g=g;
this.b=b;
this.a=a;
}
}
}
};
dojo.gfx.color.Color.fromArray=function(arr){
return new dojo.gfx.color.Color(arr[0],arr[1],arr[2],arr[3]);
};
dojo.extend(dojo.gfx.color.Color,{toRgb:function(_236){
if(_236){
return this.toRgba();
}else{
return [this.r,this.g,this.b];
}
},toRgba:function(){
return [this.r,this.g,this.b,this.a];
},toHex:function(){
return dojo.gfx.color.rgb2hex(this.toRgb());
},toCss:function(){
return "rgb("+this.toRgb().join()+")";
},toString:function(){
return this.toHex();
},blend:function(_237,_238){
var rgb=null;
if(dojo.lang.isArray(_237)){
rgb=_237;
}else{
if(_237 instanceof dojo.gfx.color.Color){
rgb=_237.toRgb();
}else{
rgb=new dojo.gfx.color.Color(_237).toRgb();
}
}
return dojo.gfx.color.blend(this.toRgb(),rgb,_238);
}});
dojo.gfx.color.named={white:[255,255,255],black:[0,0,0],red:[255,0,0],green:[0,255,0],lime:[0,255,0],blue:[0,0,255],navy:[0,0,128],gray:[128,128,128],silver:[192,192,192]};
dojo.gfx.color.blend=function(a,b,_23c){
if(typeof a=="string"){
return dojo.gfx.color.blendHex(a,b,_23c);
}
if(!_23c){
_23c=0;
}
_23c=Math.min(Math.max(-1,_23c),1);
_23c=((_23c+1)/2);
var c=[];
for(var x=0;x<3;x++){
c[x]=parseInt(b[x]+((a[x]-b[x])*_23c));
}
return c;
};
dojo.gfx.color.blendHex=function(a,b,_241){
return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a),dojo.gfx.color.hex2rgb(b),_241));
};
dojo.gfx.color.extractRGB=function(_242){
var hex="0123456789abcdef";
_242=_242.toLowerCase();
if(_242.indexOf("rgb")==0){
var _244=_242.match(/rgba*\((\d+), *(\d+), *(\d+)/i);
var ret=_244.splice(1,3);
return ret;
}else{
var _246=dojo.gfx.color.hex2rgb(_242);
if(_246){
return _246;
}else{
return dojo.gfx.color.named[_242]||[255,255,255];
}
}
};
dojo.gfx.color.hex2rgb=function(hex){
var _248="0123456789ABCDEF";
var rgb=new Array(3);
if(hex.indexOf("#")==0){
hex=hex.substring(1);
}
hex=hex.toUpperCase();
if(hex.replace(new RegExp("["+_248+"]","g"),"")!=""){
return null;
}
if(hex.length==3){
rgb[0]=hex.charAt(0)+hex.charAt(0);
rgb[1]=hex.charAt(1)+hex.charAt(1);
rgb[2]=hex.charAt(2)+hex.charAt(2);
}else{
rgb[0]=hex.substring(0,2);
rgb[1]=hex.substring(2,4);
rgb[2]=hex.substring(4);
}
for(var i=0;i<rgb.length;i++){
rgb[i]=_248.indexOf(rgb[i].charAt(0))*16+_248.indexOf(rgb[i].charAt(1));
}
return rgb;
};
dojo.gfx.color.rgb2hex=function(r,g,b){
if(dojo.lang.isArray(r)){
g=r[1]||0;
b=r[2]||0;
r=r[0]||0;
}
var ret=dojo.lang.map([r,g,b],function(x){
x=new Number(x);
var s=x.toString(16);
while(s.length<2){
s="0"+s;
}
return s;
});
ret.unshift("#");
return ret.join("");
};
dojo.provide("dojo.gfx.color.hsl");
dojo.lang.extend(dojo.gfx.color.Color,{toHsl:function(){
return dojo.gfx.color.rgb2hsl(this.toRgb());
}});
dojo.gfx.color.rgb2hsl=function(r,g,b){
if(dojo.lang.isArray(r)){
b=r[2]||0;
g=r[1]||0;
r=r[0]||0;
}
r/=255;
g/=255;
b/=255;
var h=null;
var s=null;
var l=null;
var min=Math.min(r,g,b);
var max=Math.max(r,g,b);
var _259=max-min;
l=(min+max)/2;
s=0;
if((l>0)&&(l<1)){
s=_259/((l<0.5)?(2*l):(2-2*l));
}
h=0;
if(_259>0){
if((max==r)&&(max!=g)){
h+=(g-b)/_259;
}
if((max==g)&&(max!=b)){
h+=(2+(b-r)/_259);
}
if((max==b)&&(max!=r)){
h+=(4+(r-g)/_259);
}
h*=60;
}
h=(h==0)?360:Math.ceil((h/360)*255);
s=Math.ceil(s*255);
l=Math.ceil(l*255);
return [h,s,l];
};
dojo.gfx.color.hsl2rgb=function(h,s,l){
if(dojo.lang.isArray(h)){
l=h[2]||0;
s=h[1]||0;
h=h[0]||0;
}
h=(h/255)*360;
if(h==360){
h=0;
}
s=s/255;
l=l/255;
while(h<0){
h+=360;
}
while(h>360){
h-=360;
}
var r,g,b;
if(h<120){
r=(120-h)/60;
g=h/60;
b=0;
}else{
if(h<240){
r=0;
g=(240-h)/60;
b=(h-120)/60;
}else{
r=(h-240)/60;
g=0;
b=(360-h)/60;
}
}
r=Math.min(r,1);
g=Math.min(g,1);
b=Math.min(b,1);
r=2*s*r+(1-s);
g=2*s*g+(1-s);
b=2*s*b+(1-s);
if(l<0.5){
r=l*r;
g=l*g;
b=l*b;
}else{
r=(1-l)*r+2*l-1;
g=(1-l)*g+2*l-1;
b=(1-l)*b+2*l-1;
}
r=Math.ceil(r*255);
g=Math.ceil(g*255);
b=Math.ceil(b*255);
return [r,g,b];
};
dojo.gfx.color.hsl2hex=function(h,s,l){
var rgb=dojo.gfx.color.hsl2rgb(h,s,l);
return dojo.gfx.color.rgb2hex(rgb[0],rgb[1],rgb[2]);
};
dojo.gfx.color.hex2hsl=function(hex){
var rgb=dojo.gfx.color.hex2rgb(hex);
return dojo.gfx.color.rgb2hsl(rgb[0],rgb[1],rgb[2]);
};
dojo.provide("dojo.charting.*");
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _267=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_267.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_269,_26a){
var node=_269.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_26a&&node&&node.tagName&&node.tagName.toLowerCase()!=_26a.toLowerCase()){
node=dojo.dom.nextElement(node,_26a);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_26c,_26d){
var node=_26c.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_26d&&node&&node.tagName&&node.tagName.toLowerCase()!=_26d.toLowerCase()){
node=dojo.dom.prevElement(node,_26d);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_270){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_270&&_270.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_270);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_272){
if(!node){
return null;
}
if(_272){
_272=_272.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_272&&_272.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_272);
}
return node;
};
dojo.dom.moveChildren=function(_273,_274,trim){
var _276=0;
if(trim){
while(_273.hasChildNodes()&&_273.firstChild.nodeType==dojo.dom.TEXT_NODE){
_273.removeChild(_273.firstChild);
}
while(_273.hasChildNodes()&&_273.lastChild.nodeType==dojo.dom.TEXT_NODE){
_273.removeChild(_273.lastChild);
}
}
while(_273.hasChildNodes()){
_274.appendChild(_273.firstChild);
_276++;
}
return _276;
};
dojo.dom.copyChildren=function(_277,_278,trim){
var _27a=_277.cloneNode(true);
return this.moveChildren(_27a,_278,trim);
};
dojo.dom.replaceChildren=function(node,_27c){
var _27d=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_27d.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_27c);
for(var i=0;i<_27d.length;i++){
dojo.dom.destroyNode(_27d[i]);
}
};
dojo.dom.removeChildren=function(node){
var _280=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _280;
};
dojo.dom.replaceNode=function(node,_282){
return node.parentNode.replaceChild(_282,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_286,_287){
var _288=[];
var _289=(_286&&(_286 instanceof Function||typeof _286=="function"));
while(node){
if(!_289||_286(node)){
_288.push(node);
}
if(_287&&_288.length>0){
return _288[0];
}
node=node.parentNode;
}
if(_287){
return null;
}
return _288;
};
dojo.dom.getAncestorsByTag=function(node,tag,_28c){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_28c);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_291,_292){
if(_292&&node){
node=node.parentNode;
}
while(node){
if(node==_291){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _295=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _296=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_296.length;i++){
try{
doc=new ActiveXObject(_296[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_295.implementation)&&(_295.implementation.createDocument)){
doc=_295.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_299){
if(!_299){
_299="text/xml";
}
if(!dj_undef("DOMParser")){
var _29a=new DOMParser();
return _29a.parseFromString(str,_299);
}else{
if(!dj_undef("ActiveXObject")){
var _29b=dojo.dom.createDocument();
if(_29b){
_29b.async=false;
_29b.loadXML(str);
return _29b;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _29c=dojo.doc();
if(_29c.createElement){
var tmp=_29c.createElement("xml");
tmp.innerHTML=str;
if(_29c.implementation&&_29c.implementation.createDocument){
var _29e=_29c.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_29e.importNode(tmp.childNodes.item(i),true);
}
return _29e;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_2a1){
if(_2a1.firstChild){
_2a1.insertBefore(node,_2a1.firstChild);
}else{
_2a1.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_2a4){
if((_2a4!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _2a5=ref.parentNode;
_2a5.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_2a8){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_2a8!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_2a8);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_2ac){
if((!node)||(!ref)||(!_2ac)){
return false;
}
switch(_2ac.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_2ae,_2af){
var _2b0=_2ae.childNodes;
if(!_2b0.length||_2b0.length==_2af){
_2ae.appendChild(node);
return true;
}
if(_2af==0){
return dojo.dom.prependChild(node,_2ae);
}
return dojo.dom.insertAfter(node,_2b0[_2af-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _2b3=dojo.doc();
dojo.dom.replaceChildren(node,_2b3.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _2b4="";
if(node==null){
return _2b4;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_2b4+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_2b4+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _2b4;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_2ba,_2bb,_2bc){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_2ba,_2bb,_2bc);
}else{
var _2bd=elem.ownerDocument;
var _2be=_2bd.createNode(2,_2bb,_2ba);
_2be.nodeValue=_2bc;
elem.setAttributeNode(_2be);
}
};
dojo.provide("dojo.svg");
dojo.mixin(dojo.svg,dojo.dom);
dojo.svg.graphics=dojo.svg.g=new function(d){
this.suspend=function(){
try{
d.documentElement.suspendRedraw(0);
}
catch(e){
}
};
this.resume=function(){
try{
d.documentElement.unsuspendRedraw(0);
}
catch(e){
}
};
this.force=function(){
try{
d.documentElement.forceRedraw();
}
catch(e){
}
};
}(document);
dojo.svg.animations=dojo.svg.anim=new function(d){
this.arePaused=function(){
try{
return d.documentElement.animationsPaused();
}
catch(e){
return false;
}
};
this.pause=function(){
try{
d.documentElement.pauseAnimations();
}
catch(e){
}
};
this.resume=function(){
try{
d.documentElement.unpauseAnimations();
}
catch(e){
}
};
}(document);
dojo.svg.toCamelCase=function(_2c1){
var arr=_2c1.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.svg.toSelectorCase=function(_2c5){
return _2c5.replace(/([A-Z])/g,"-$1").toLowerCase();
};
dojo.svg.getStyle=function(node,_2c7){
return document.defaultView.getComputedStyle(node,_2c7);
};
dojo.svg.getNumericStyle=function(node,_2c9){
return parseFloat(dojo.svg.getStyle(node,_2c9));
};
dojo.svg.getOpacity=function(node){
return Math.min(1,dojo.svg.getNumericStyle(node,"fill-opacity"));
};
dojo.svg.setOpacity=function(node,_2cc){
node.setAttributeNS(this.xmlns.svg,"fill-opacity",_2cc);
node.setAttributeNS(this.xmlns.svg,"stroke-opacity",_2cc);
};
dojo.svg.clearOpacity=function(node){
node.setAttributeNS(this.xmlns.svg,"fill-opacity","1.0");
node.setAttributeNS(this.xmlns.svg,"stroke-opacity","1.0");
};
dojo.svg.getCoords=function(node){
if(node.getBBox){
var box=node.getBBox();
return {x:box.x,y:box.y};
}
return null;
};
dojo.svg.setCoords=function(node,_2d1){
var p=dojo.svg.getCoords();
if(!p){
return;
}
var dx=p.x-_2d1.x;
var dy=p.y-_2d1.y;
dojo.svg.translate(node,dx,dy);
};
dojo.svg.getDimensions=function(node){
if(node.getBBox){
var box=node.getBBox();
return {width:box.width,height:box.height};
}
return null;
};
dojo.svg.setDimensions=function(node,dim){
if(node.width){
node.width.baseVal.value=dim.width;
node.height.baseVal.value=dim.height;
}else{
if(node.r){
node.r.baseVal.value=Math.min(dim.width,dim.height)/2;
}else{
if(node.rx){
node.rx.baseVal.value=dim.width/2;
node.ry.baseVal.value=dim.height/2;
}
}
}
};
dojo.svg.translate=function(node,dx,dy){
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
t.setTranslate(dx,dy);
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.scale=function(node,_2de,_2df){
if(!_2df){
var _2df=_2de;
}
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
t.setScale(_2de,_2df);
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.rotate=function(node,ang,cx,cy){
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
if(cx==null){
t.setMatrix(t.matrix.rotate(ang));
}else{
t.setRotate(ang,cx,cy);
}
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.skew=function(node,ang,axis){
var dir=axis||"x";
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
if(dir!="x"){
t.setSkewY(ang);
}else{
t.setSkewX(ang);
}
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.flip=function(node,axis){
var dir=axis||"x";
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
t.setMatrix((dir!="x")?t.matrix.flipY():t.matrix.flipX());
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.invert=function(node){
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var t=node.ownerSVGElement.createSVGTransform();
t.setMatrix(t.matrix.inverse());
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.applyMatrix=function(node,a,b,c,d,e,f){
if(node.transform&&node.ownerSVGElement&&node.ownerSVGElement.createSVGTransform){
var m;
if(b){
var m=node.ownerSVGElement.createSVGMatrix();
m.a=a;
m.b=b;
m.c=c;
m.d=d;
m.e=e;
m.f=f;
}else{
m=a;
}
var t=node.ownerSVGElement.createSVGTransform();
t.setMatrix(m);
node.transform.baseVal.appendItem(t);
}
};
dojo.svg.group=function(_2fa){
var p=_2fa.item(0).parentNode;
var g=document.createElementNS(this.xmlns.svg,"g");
for(var i=0;i<_2fa.length;i++){
g.appendChild(_2fa.item(i));
}
p.appendChild(g);
return g;
};
dojo.svg.ungroup=function(g){
var p=g.parentNode;
while(g.childNodes.length>0){
p.appendChild(g.childNodes.item(0));
}
p.removeChild(g);
};
dojo.svg.getGroup=function(node){
var a=this.getAncestors(node);
for(var i=0;i<a.length;i++){
if(a[i].nodeType==this.ELEMENT_NODE&&a[i].nodeName.toLowerCase()=="g"){
return a[i];
}
}
return null;
};
dojo.svg.bringToFront=function(node){
var n=this.getGroup(node)||node;
n.ownerSVGElement.appendChild(n);
};
dojo.svg.sendToBack=function(node){
var n=this.getGroup(node)||node;
n.ownerSVGElement.insertBefore(n,n.ownerSVGElement.firstChild);
};
dojo.svg.bringForward=function(node){
var n=this.getGroup(node)||node;
if(this.getLastChildElement(n.parentNode)!=n){
this.insertAfter(n,this.getNextSiblingElement(n),true);
}
};
dojo.svg.sendBackward=function(node){
var n=this.getGroup(node)||node;
if(this.getFirstChildElement(n.parentNode)!=n){
this.insertBefore(n,this.getPreviousSiblingElement(n),true);
}
};
dojo.svg.createNodesFromText=function(txt,wrap){
var _30d=(new DOMParser()).parseFromString(txt,"text/xml").normalize();
if(wrap){
return [_30d.firstChild.cloneNode(true)];
}
var _30e=[];
for(var x=0;x<_30d.childNodes.length;x++){
_30e.push(_30d.childNodes.item(x).cloneNode(true));
}
return _30e;
};
dojo.provide("dojo.charting.Axis");
dojo.charting.Axis=function(_310,_311,_312){
var id="dojo-charting-axis-"+dojo.charting.Axis.count++;
this.getId=function(){
return id;
};
this.setId=function(key){
id=key;
};
this.scale=_311||"linear";
this.label=_310||"";
this.showLabel=true;
this.showLabels=true;
this.showLines=false;
this.showTicks=false;
this.range={upper:100,lower:0};
this.origin="min";
this._origin=null;
this.labels=_312||[];
this._labels=[];
this.nodes={main:null,axis:null,label:null,labels:null,lines:null,ticks:null};
this._rerender=false;
};
dojo.charting.Axis.count=0;
dojo.extend(dojo.charting.Axis,{getCoord:function(val,_316,plot){
val=parseFloat(val,10);
var area=_316.getArea();
if(plot.axisX==this){
var _319=0-this.range.lower;
var min=this.range.lower+_319;
var max=this.range.upper+_319;
val+=_319;
return (val*((area.right-area.left)/max))+area.left;
}else{
var max=this.range.upper;
var min=this.range.lower;
var _319=0;
if(min<0){
_319+=Math.abs(min);
}
max+=_319;
min+=_319;
val+=_319;
var pmin=area.bottom;
var pmax=area.top;
return (((pmin-pmax)/(max-min))*(max-val))+pmax;
}
},initializeOrigin:function(_31e,_31f){
if(this._origin==null){
this._origin=this.origin;
}
if(isNaN(this._origin)){
if(this._origin.toLowerCase()=="max"){
this.origin=_31e.range[(_31f=="y")?"upper":"lower"];
}else{
if(this._origin.toLowerCase()=="min"){
this.origin=_31e.range[(_31f=="y")?"lower":"upper"];
}else{
this.origin=0;
}
}
}
},initializeLabels:function(){
this._labels=[];
if(this.labels.length==0){
this.showLabels=false;
this.showLines=false;
this.showTicks=false;
}else{
if(this.labels[0].label&&this.labels[0].value!=null){
for(var i=0;i<this.labels.length;i++){
this._labels.push(this.labels[i]);
}
}else{
if(!isNaN(this.labels[0])){
for(var i=0;i<this.labels.length;i++){
this._labels.push({label:this.labels[i],value:this.labels[i]});
}
}else{
var a=[];
for(var i=0;i<this.labels.length;i++){
a.push(this.labels[i]);
}
var s=a.shift();
this._labels.push({label:s,value:this.range.lower});
if(a.length>0){
var s=a.pop();
this._labels.push({label:s,value:this.range.upper});
}
if(a.length>0){
var _323=this.range.upper-this.range.lower;
var step=_323/(this.labels.length-1);
for(var i=1;i<=a.length;i++){
this._labels.push({label:a[i-1],value:this.range.lower+(step*i)});
}
}
}
}
}
},initialize:function(_325,plot,_327,_328){
this.destroy();
this.initializeOrigin(_327,_328);
this.initializeLabels();
var node=this.render(_325,plot,_327,_328);
return node;
},destroy:function(){
for(var p in this.nodes){
while(this.nodes[p]&&this.nodes[p].childNodes.length>0){
this.nodes[p].removeChild(this.nodes[p].childNodes[0]);
}
if(this.nodes[p]&&this.nodes[p].parentNode){
this.nodes[p].parentNode.removeChild(this.nodes[p]);
}
this.nodes[p]=null;
}
}});
dojo.provide("dojo.charting.svg.Axis");
if(dojo.render.svg.capable){
dojo.extend(dojo.charting.Axis,{renderLines:function(_32b,plot,_32d){
if(this.nodes.lines){
while(this.nodes.lines.childNodes.length>0){
this.nodes.lines.removeChild(this.nodes.lines.childNodes[0]);
}
if(this.nodes.lines.parentNode){
this.nodes.lines.parentNode.removeChild(this.nodes.lines);
this.nodes.lines=null;
}
}
var area=_32b.getArea();
var g=this.nodes.lines=document.createElementNS(dojo.svg.xmlns.svg,"g");
g.setAttribute("id",this.getId()+"-lines");
for(var i=0;i<this._labels.length;i++){
if(this._labels[i].value==this.origin){
continue;
}
var v=this.getCoord(this._labels[i].value,_32b,plot);
var l=document.createElementNS(dojo.svg.xmlns.svg,"line");
l.setAttribute("style","stroke:#999;stroke-width:1px;stroke-dasharray:1,4;");
if(_32d=="x"){
l.setAttribute("y1",area.top);
l.setAttribute("y2",area.bottom);
l.setAttribute("x1",v);
l.setAttribute("x2",v);
}else{
if(_32d=="y"){
l.setAttribute("y1",v);
l.setAttribute("y2",v);
l.setAttribute("x1",area.left);
l.setAttribute("x2",area.right);
}
}
g.appendChild(l);
}
return g;
},renderTicks:function(_333,plot,_335,_336){
if(this.nodes.ticks){
while(this.nodes.ticks.childNodes.length>0){
this.nodes.ticks.removeChild(this.nodes.ticks.childNodes[0]);
}
if(this.nodes.ticks.parentNode){
this.nodes.ticks.parentNode.removeChild(this.nodes.ticks);
this.nodes.ticks=null;
}
}
var g=this.nodes.ticks=document.createElementNS(dojo.svg.xmlns.svg,"g");
g.setAttribute("id",this.getId()+"-ticks");
for(var i=0;i<this._labels.length;i++){
var v=this.getCoord(this._labels[i].value,_333,plot);
var l=document.createElementNS(dojo.svg.xmlns.svg,"line");
l.setAttribute("style","stroke:#000;stroke-width:1pt;");
if(_335=="x"){
l.setAttribute("y1",_336);
l.setAttribute("y2",_336+3);
l.setAttribute("x1",v);
l.setAttribute("x2",v);
}else{
if(_335=="y"){
l.setAttribute("y1",v);
l.setAttribute("y2",v);
l.setAttribute("x1",_336-2);
l.setAttribute("x2",_336+2);
}
}
g.appendChild(l);
}
return g;
},renderLabels:function(_33b,plot,_33d,_33e,_33f,_340){
function createLabel(_341,x,y,_344,_345){
var text=document.createElementNS(dojo.svg.xmlns.svg,"text");
text.setAttribute("x",x);
text.setAttribute("y",(_33d=="x"?y:y+2));
text.setAttribute("style","text-anchor:"+_345+";font-family:sans-serif;font-size:"+_344+"px;fill:#000;");
text.appendChild(document.createTextNode(_341));
return text;
}
if(this.nodes.labels){
while(this.nodes.labels.childNodes.length>0){
this.nodes.labels.removeChild(this.nodes.labels.childNodes[0]);
}
if(this.nodes.labels.parentNode){
this.nodes.labels.parentNode.removeChild(this.nodes.labels);
this.nodes.labels=null;
}
}
var g=this.nodes.labels=document.createElementNS(dojo.svg.xmlns.svg,"g");
g.setAttribute("id",this.getId()+"-labels");
for(var i=0;i<this._labels.length;i++){
var v=this.getCoord(this._labels[i].value,_33b,plot);
if(_33d=="x"){
g.appendChild(createLabel(this._labels[i].label,v,_33e,_33f,_340));
}else{
if(_33d=="y"){
g.appendChild(createLabel(this._labels[i].label,_33e,v,_33f,_340));
}
}
}
return g;
},render:function(_34a,plot,_34c,_34d){
if(!this._rerender&&this.nodes.main){
return this.nodes.main;
}
this._rerender=false;
var area=_34a.getArea();
var _34f=1;
var _350="stroke:#000;stroke-width:"+_34f+"px;";
var _351=10;
var _352=_34c.getCoord(this.origin,_34a,plot);
this.nodes.main=document.createElementNS(dojo.svg.xmlns.svg,"g");
var g=this.nodes.main;
g.setAttribute("id",this.getId());
var line=this.nodes.axis=document.createElementNS(dojo.svg.xmlns.svg,"line");
if(_34d=="x"){
line.setAttribute("y1",_352);
line.setAttribute("y2",_352);
line.setAttribute("x1",area.left-_34f);
line.setAttribute("x2",area.right+_34f);
line.setAttribute("style",_350);
var y=_352+_351+2;
if(this.showLines){
g.appendChild(this.renderLines(_34a,plot,_34d,y));
}
if(this.showTicks){
g.appendChild(this.renderTicks(_34a,plot,_34d,_352));
}
if(this.showLabels){
g.appendChild(this.renderLabels(_34a,plot,_34d,y,_351,"middle"));
}
if(this.showLabel&&this.label){
var x=_34a.size.width/2;
var text=document.createElementNS(dojo.svg.xmlns.svg,"text");
text.setAttribute("x",x);
text.setAttribute("y",(_352+(_351*2)+(_351/2)));
text.setAttribute("style","text-anchor:middle;font-family:sans-serif;font-weight:bold;font-size:"+(_351+2)+"px;fill:#000;");
text.appendChild(document.createTextNode(this.label));
g.appendChild(text);
}
}else{
line.setAttribute("x1",_352);
line.setAttribute("x2",_352);
line.setAttribute("y1",area.top);
line.setAttribute("y2",area.bottom);
line.setAttribute("style",_350);
var _358=this.origin==_34c.range.upper;
var x=_352+(_358?4:-4);
var _359=_358?"start":"end";
if(this.showLines){
g.appendChild(this.renderLines(_34a,plot,_34d,x));
}
if(this.showTicks){
g.appendChild(this.renderTicks(_34a,plot,_34d,_352));
}
if(this.showLabels){
g.appendChild(this.renderLabels(_34a,plot,_34d,x,_351,_359));
}
if(this.showLabel&&this.label){
var x=_358?(_352+(_351*2)+(_351/2)):(_352-(_351*4));
var y=_34a.size.height/2;
var text=document.createElementNS(dojo.svg.xmlns.svg,"text");
text.setAttribute("x",x);
text.setAttribute("y",y);
text.setAttribute("transform","rotate(90, "+x+", "+y+")");
text.setAttribute("style","text-anchor:middle;font-family:sans-serif;font-weight:bold;font-size:"+(_351+2)+"px;fill:#000;");
text.appendChild(document.createTextNode(this.label));
g.appendChild(text);
}
}
g.appendChild(line);
return g;
}});
}
dojo.provide("dojo.charting.vml.Axis");
if(dojo.render.vml.capable){
dojo.extend(dojo.charting.Axis,{renderLines:function(_35a,plot,_35c){
if(this.nodes.lines){
while(this.nodes.lines.childNodes.length>0){
this.nodes.lines.removeChild(this.nodes.lines.childNodes[0]);
}
if(this.nodes.lines.parentNode){
this.nodes.lines.parentNode.removeChild(this.nodes.lines);
this.nodes.lines=null;
}
}
var area=_35a.getArea();
var g=this.nodes.lines=document.createElement("div");
g.setAttribute("id",this.getId()+"-lines");
for(var i=0;i<this._labels.length;i++){
if(this._labels[i].value==this.origin){
continue;
}
var v=this.getCoord(this._labels[i].value,_35a,plot);
var l=document.createElement("v:line");
var str=document.createElement("v:stroke");
str.dashstyle="dot";
l.appendChild(str);
l.setAttribute("strokecolor","#666");
l.setAttribute("strokeweight","1px");
var s=l.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
if(_35c=="x"){
l.setAttribute("from",v+"px,"+area.top+"px");
l.setAttribute("to",v+"px,"+area.bottom+"px");
}else{
if(_35c=="y"){
l.setAttribute("from",area.left+"px,"+v+"px");
l.setAttribute("to",area.right+"px,"+v+"px");
}
}
g.appendChild(l);
}
return g;
},renderTicks:function(_364,plot,_366,_367){
if(this.nodes.ticks){
while(this.nodes.ticks.childNodes.length>0){
this.nodes.ticks.removeChild(this.nodes.ticks.childNodes[0]);
}
if(this.nodes.ticks.parentNode){
this.nodes.ticks.parentNode.removeChild(this.nodes.ticks);
this.nodes.ticks=null;
}
}
var g=this.nodes.ticks=document.createElement("div");
g.setAttribute("id",this.getId()+"-ticks");
for(var i=0;i<this._labels.length;i++){
var v=this.getCoord(this._labels[i].value,_364,plot);
var l=document.createElement("v:line");
l.setAttribute("strokecolor","#000");
l.setAttribute("strokeweight","1px");
var s=l.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
if(_366=="x"){
l.setAttribute("from",v+"px,"+_367+"px");
l.setAttribute("to",v+"px,"+(_367+3)+"px");
}else{
if(_366=="y"){
l.setAttribute("from",(_367-2)+"px,"+v+"px");
l.setAttribute("to",(_367+2)+"px,"+v+"px");
}
}
g.appendChild(l);
}
return g;
},renderLabels:function(_36d,plot,_36f,_370,_371,_372){
function createLabel(_373,x,y,_376,_377){
var text=document.createElement("div");
var s=text.style;
text.innerHTML=_373;
s.fontSize=_376+"px";
s.fontFamily="sans-serif";
s.position="absolute";
s.top=y+"px";
if(_377=="center"){
s.left=x+"px";
s.textAlign="center";
}else{
if(_377=="left"){
s.left=x+"px";
s.textAlign="left";
}else{
if(_377=="right"){
s.right=x+"px";
s.textAlign="right";
}
}
}
return text;
}
if(this.nodes.labels){
while(this.nodes.labels.childNodes.length>0){
this.nodes.labels.removeChild(this.nodes.labels.childNodes[0]);
}
if(this.nodes.labels.parentNode){
this.nodes.labels.parentNode.removeChild(this.nodes.labels);
this.nodes.labels=null;
}
}
var g=this.nodes.labels=document.createElement("div");
g.setAttribute("id",this.getId()+"-labels");
for(var i=0;i<this._labels.length;i++){
var v=this.getCoord(this._labels[i].value,_36d,plot);
if(_36f=="x"){
var node=createLabel(this._labels[i].label,v,_370,_371,_372);
document.body.appendChild(node);
node.style.left=v-(node.offsetWidth/2)+"px";
g.appendChild(node);
}else{
if(_36f=="y"){
var node=createLabel(this._labels[i].label,_370,v,_371,_372);
document.body.appendChild(node);
node.style.top=v-(node.offsetHeight/2)+"px";
g.appendChild(node);
}
}
}
return g;
},render:function(_37e,plot,_380,_381){
if(!this._rerender&&this.nodes.main){
return this.nodes.main;
}
this._rerender=false;
var area=_37e.getArea();
var _383=1;
var _384="stroke:#000;stroke-width:"+_383+"px;";
var _385=10;
var _386=_380.getCoord(this.origin,_37e,plot);
var g=this.nodes.main=document.createElement("div");
g.setAttribute("id",this.getId());
var line=this.nodes.axis=document.createElement("v:line");
line.setAttribute("strokecolor","#000");
line.setAttribute("strokeweight",_383+"px");
var s=line.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
if(_381=="x"){
line.setAttribute("from",area.left+"px,"+_386+"px");
line.setAttribute("to",area.right+"px,"+_386+"px");
var y=_386+Math.floor(_385/2);
if(this.showLines){
g.appendChild(this.renderLines(_37e,plot,_381,y));
}
if(this.showTicks){
g.appendChild(this.renderTicks(_37e,plot,_381,_386));
}
if(this.showLabels){
g.appendChild(this.renderLabels(_37e,plot,_381,y,_385,"center"));
}
if(this.showLabel&&this.label){
var x=_37e.size.width/2;
var y=_386+Math.round(_385*1.5);
var text=document.createElement("div");
var s=text.style;
text.innerHTML=this.label;
s.fontSize=(_385+2)+"px";
s.fontFamily="sans-serif";
s.fontWeight="bold";
s.position="absolute";
s.top=y+"px";
s.left=x+"px";
s.textAlign="center";
document.body.appendChild(text);
text.style.left=x-(text.offsetWidth/2)+"px";
g.appendChild(text);
}
}else{
line.setAttribute("from",_386+"px,"+area.top+"px");
line.setAttribute("to",_386+"px,"+area.bottom+"px");
var _38d=this.origin==_380.range.upper;
var x=_386+4;
var _38e="left";
if(!_38d){
x=area.right-_386+_385+4;
_38e="right";
if(_386==area.left){
x+=(_385*2)-(_385/2);
}
}
if(this.showLines){
g.appendChild(this.renderLines(_37e,plot,_381,x));
}
if(this.showTicks){
g.appendChild(this.renderTicks(_37e,plot,_381,_386));
}
if(this.showLabels){
g.appendChild(this.renderLabels(_37e,plot,_381,x,_385,_38e));
}
if(this.showLabel&&this.label){
x+=(_385*2)-2;
var y=_37e.size.height/2;
var text=document.createElement("div");
var s=text.style;
text.innerHTML=this.label;
s.fontSize=(_385+2)+"px";
s.fontFamily="sans-serif";
s.fontWeight="bold";
s.position="absolute";
s.height=_37e.size.height+"px";
s.writingMode="tb-rl";
s.textAlign="center";
s[_38e]=x+"px";
document.body.appendChild(text);
s.top=y-(text.offsetHeight/2)+"px";
g.appendChild(text);
}
}
g.appendChild(line);
return g;
}});
}
dojo.provide("dojo.charting.Plotters");
dojo.provide("dojo.charting.svg.Plotters");
if(dojo.render.svg.capable){
dojo.mixin(dojo.charting.Plotters,{Bar:function(_38f,plot,_391,_392){
var area=_38f.getArea();
var _394=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_391);
data.push(tmp);
}
var _399=8;
var _39a=data[0].length;
if(_39a==0){
return _394;
}
var _39b=((area.right-area.left)-(_399*(_39a-1)))/_39a;
var _39c=_39b/n;
var _39d=plot.axisY.getCoord(plot.axisX.origin,_38f,plot);
for(var i=0;i<_39a;i++){
var _39e=area.left+(_39b*i)+(_399*i);
for(var j=0;j<n;j++){
var _3a0=data[j][i].y;
var yA=_39d;
var x=_39e+(_39c*j);
var y=plot.axisY.getCoord(_3a0,_38f,plot);
var h=Math.abs(yA-y);
if(_3a0<plot.axisX.origin){
yA=y;
y=_39d;
}
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[j][i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",_39c);
bar.setAttribute("height",h);
bar.setAttribute("fill-opacity","0.6");
if(_392){
_392(bar,data[j][i].src);
}
_394.appendChild(bar);
}
}
return _394;
},HorizontalBar:function(_3a6,plot,_3a8,_3a9){
var area=_3a6.getArea();
var _3ab=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_3a8);
data.push(tmp);
}
var _3b0=6;
var _3b1=data[0].length;
if(_3b1==0){
return _3ab;
}
var h=((area.bottom-area.top)-(_3b0*(_3b1-1)))/_3b1;
var barH=h/n;
var _3b4=plot.axisX.getCoord(0,_3a6,plot);
for(var i=0;i<_3b1;i++){
var _3b5=area.top+(h*i)+(_3b0*i);
for(var j=0;j<n;j++){
var _3b7=data[j][i].y;
var y=_3b5+(barH*j);
var xA=_3b4;
var x=plot.axisX.getCoord(_3b7,_3a6,plot);
var w=Math.abs(x-xA);
if(_3b7>0){
x=_3b4;
}
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[j][i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",xA);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",barH);
bar.setAttribute("fill-opacity","0.6");
if(_3a9){
_3a9(bar,data[j][i].src);
}
_3ab.appendChild(bar);
}
}
return _3ab;
},Gantt:function(_3bd,plot,_3bf,_3c0){
var area=_3bd.getArea();
var _3c2=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_3bf);
data.push(tmp);
}
var _3c7=2;
var _3c8=data[0].length;
if(_3c8==0){
return _3c2;
}
var h=((area.bottom-area.top)-(_3c7*(_3c8-1)))/_3c8;
var barH=h/n;
for(var i=0;i<_3c8;i++){
var _3cb=area.top+(h*i)+(_3c7*i);
for(var j=0;j<n;j++){
var high=data[j][i].high;
var low=data[j][i].low;
if(low>high){
var t=high;
high=low;
low=t;
}
var x=plot.axisX.getCoord(low,_3bd,plot);
var w=plot.axisX.getCoord(high,_3bd,plot)-x;
var y=_3cb+(barH*j);
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[j][i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",barH);
bar.setAttribute("fill-opacity","0.6");
if(_3c0){
_3c0(bar,data[j][i].src);
}
_3c2.appendChild(bar);
}
}
return _3c2;
},StackedArea:function(_3d4,plot,_3d6,_3d7){
var area=_3d4.getArea();
var _3d9=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=plot.series.length;
var data=[];
var _3dc=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_3d6);
for(var j=0;j<tmp.length;j++){
if(i==0){
_3dc.push(tmp[j].y);
}else{
_3dc[j]+=tmp[j].y;
}
tmp[j].y=_3dc[j];
}
data.push(tmp);
}
for(var i=n-1;i>=0;i--){
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
path.setAttribute("fill",data[i][0].series.color);
path.setAttribute("fill-opacity","0.4");
path.setAttribute("stroke",data[i][0].series.color);
path.setAttribute("stroke-width","1");
path.setAttribute("stroke-opacity","0.85");
var cmd=[];
var r=3;
for(var j=0;j<data[i].length;j++){
var _3e3=data[i];
var x=plot.axisX.getCoord(_3e3[j].x,_3d4,plot);
var y=plot.axisY.getCoord(_3e3[j].y,_3d4,plot);
if(j==0){
cmd.push("M");
}else{
cmd.push("L");
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",_3e3[j].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
_3d9.appendChild(c);
if(_3d7){
_3d7(c,data[i].src);
}
}
if(i==0){
cmd.push("L");
cmd.push(x+","+plot.axisY.getCoord(plot.axisX.origin,_3d4,plot));
cmd.push("L");
cmd.push(plot.axisX.getCoord(data[0][0].x,_3d4,plot)+","+plot.axisY.getCoord(plot.axisX.origin,_3d4,plot));
cmd.push("Z");
}else{
var _3e3=data[i-1];
cmd.push("L");
cmd.push(x+","+Math.round(plot.axisY.getCoord(_3e3[_3e3.length-1].y,_3d4,plot)));
for(var j=_3e3.length-2;j>=0;j--){
var x=plot.axisX.getCoord(_3e3[j].x,_3d4,plot);
var y=plot.axisY.getCoord(_3e3[j].y,_3d4,plot);
cmd.push("L");
cmd.push(x+","+y);
}
}
path.setAttribute("d",cmd.join(" ")+" Z");
_3d9.appendChild(path);
}
return _3d9;
},StackedCurvedArea:function(_3e7,plot,_3e9,_3ea){
var _3eb=3;
var area=_3e7.getArea();
var _3ed=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=plot.series.length;
var data=[];
var _3f0=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_3e9);
for(var j=0;j<tmp.length;j++){
if(i==0){
_3f0.push(tmp[j].y);
}else{
_3f0[j]+=tmp[j].y;
}
tmp[j].y=_3f0[j];
}
data.push(tmp);
}
for(var i=n-1;i>=0;i--){
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
path.setAttribute("fill",data[i][0].series.color);
path.setAttribute("fill-opacity","0.4");
path.setAttribute("stroke",data[i][0].series.color);
path.setAttribute("stroke-width","1");
path.setAttribute("stroke-opacity","0.85");
var cmd=[];
var r=3;
for(var j=0;j<data[i].length;j++){
var _3f7=data[i];
var x=plot.axisX.getCoord(_3f7[j].x,_3e7,plot);
var y=plot.axisY.getCoord(_3f7[j].y,_3e7,plot);
var dx=area.left+1;
var dy=area.bottom;
if(j>0){
dx=x-plot.axisX.getCoord(_3f7[j-1].x,_3e7,plot);
dy=plot.axisY.getCoord(_3f7[j-1].y,_3e7,plot);
}
if(j==0){
cmd.push("M");
}else{
cmd.push("C");
var cx=x-(_3eb-1)*(dx/_3eb);
cmd.push(cx+","+dy);
cx=x-(dx/_3eb);
cmd.push(cx+","+y);
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",_3f7[j].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
_3ed.appendChild(c);
if(_3ea){
_3ea(c,data[i].src);
}
}
if(i==0){
cmd.push("L");
cmd.push(x+","+plot.axisY.getCoord(plot.axisX.origin,_3e7,plot));
cmd.push("L");
cmd.push(plot.axisX.getCoord(data[0][0].x,_3e7,plot)+","+plot.axisY.getCoord(plot.axisX.origin,_3e7,plot));
cmd.push("Z");
}else{
var _3f7=data[i-1];
cmd.push("L");
cmd.push(x+","+Math.round(plot.axisY.getCoord(_3f7[_3f7.length-1].y,_3e7,plot)));
for(var j=_3f7.length-2;j>=0;j--){
var x=plot.axisX.getCoord(_3f7[j].x,_3e7,plot);
var y=plot.axisY.getCoord(_3f7[j].y,_3e7,plot);
var dx=x-plot.axisX.getCoord(_3f7[j+1].x,_3e7,plot);
var dy=plot.axisY.getCoord(_3f7[j+1].y,_3e7,plot);
cmd.push("C");
var cx=x-(_3eb-1)*(dx/_3eb);
cmd.push(cx+","+dy);
cx=x-(dx/_3eb);
cmd.push(cx+","+y);
cmd.push(x+","+y);
}
}
path.setAttribute("d",cmd.join(" ")+" Z");
_3ed.appendChild(path);
}
return _3ed;
},DataBar:function(data,_3ff,plot,_401){
var area=_3ff.getArea();
var _403=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=data.length;
var w=(area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower);
var _406=plot.axisY.getCoord(plot.axisX.origin,_3ff,plot);
for(var i=0;i<n;i++){
var _408=data[i].y;
var yA=_406;
var x=plot.axisX.getCoord(data[i].x,_3ff,plot)-(w/2);
var y=plot.axisY.getCoord(_408,_3ff,plot);
var h=Math.abs(yA-y);
if(_408<plot.axisX.origin){
yA=y;
y=_406;
}
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",h);
bar.setAttribute("fill-opacity","0.6");
if(_401){
_401(bar,data[i].src);
}
_403.appendChild(bar);
}
return _403;
},Line:function(data,_40f,plot,_411){
var area=_40f.getArea();
var line=document.createElementNS(dojo.svg.xmlns.svg,"g");
if(data.length==0){
return line;
}
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
line.appendChild(path);
path.setAttribute("fill","none");
path.setAttribute("stroke",data[0].series.color);
path.setAttribute("stroke-width","2");
path.setAttribute("stroke-opacity","0.85");
if(data[0].series.label!=null){
path.setAttribute("title",data[0].series.label);
}
var cmd=[];
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_40f,plot);
var y=plot.axisY.getCoord(data[i].y,_40f,plot);
if(i==0){
cmd.push("M");
}else{
cmd.push("L");
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",data[i].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
line.appendChild(c);
if(_411){
_411(c,data[i].src);
}
}
path.setAttribute("d",cmd.join(" "));
return line;
},CurvedLine:function(data,_41b,plot,_41d){
var _41e=3;
var area=_41b.getArea();
var line=document.createElementNS(dojo.svg.xmlns.svg,"g");
if(data.length==0){
return line;
}
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
line.appendChild(path);
path.setAttribute("fill","none");
path.setAttribute("stroke",data[0].series.color);
path.setAttribute("stroke-width","2");
path.setAttribute("stroke-opacity","0.85");
if(data[0].series.label!=null){
path.setAttribute("title",data[0].series.label);
}
var cmd=[];
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_41b,plot);
var y=plot.axisY.getCoord(data[i].y,_41b,plot);
var dx=area.left+1;
var dy=area.bottom;
if(i>0){
dx=x-plot.axisX.getCoord(data[i-1].x,_41b,plot);
dy=plot.axisY.getCoord(data[i-1].y,_41b,plot);
}
if(i==0){
cmd.push("M");
}else{
cmd.push("C");
var cx=x-(_41e-1)*(dx/_41e);
cmd.push(cx+","+dy);
cx=x-(dx/_41e);
cmd.push(cx+","+y);
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",data[i].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
line.appendChild(c);
if(_41d){
_41d(c,data[i].src);
}
}
path.setAttribute("d",cmd.join(" "));
return line;
},Area:function(data,_42b,plot,_42d){
var area=_42b.getArea();
var line=document.createElementNS(dojo.svg.xmlns.svg,"g");
if(data.length==0){
return line;
}
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
line.appendChild(path);
path.setAttribute("fill",data[0].series.color);
path.setAttribute("fill-opacity","0.4");
path.setAttribute("stroke",data[0].series.color);
path.setAttribute("stroke-width","1");
path.setAttribute("stroke-opacity","0.85");
if(data[0].series.label!=null){
path.setAttribute("title",data[0].series.label);
}
var cmd=[];
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_42b,plot);
var y=plot.axisY.getCoord(data[i].y,_42b,plot);
if(i==0){
cmd.push("M");
}else{
cmd.push("L");
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",data[i].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
line.appendChild(c);
if(_42d){
_42d(c,data[i].src);
}
}
cmd.push("L");
cmd.push(x+","+plot.axisY.getCoord(plot.axisX.origin,_42b,plot));
cmd.push("L");
cmd.push(plot.axisX.getCoord(data[0].x,_42b,plot)+","+plot.axisY.getCoord(plot.axisX.origin,_42b,plot));
cmd.push("Z");
path.setAttribute("d",cmd.join(" "));
return line;
},CurvedArea:function(data,_437,plot,_439){
var _43a=3;
var area=_437.getArea();
var line=document.createElementNS(dojo.svg.xmlns.svg,"g");
if(data.length==0){
return line;
}
var path=document.createElementNS(dojo.svg.xmlns.svg,"path");
line.appendChild(path);
path.setAttribute("fill",data[0].series.color);
path.setAttribute("fill-opacity","0.4");
path.setAttribute("stroke",data[0].series.color);
path.setAttribute("stroke-width","1");
path.setAttribute("stroke-opacity","0.85");
if(data[0].series.label!=null){
path.setAttribute("title",data[0].series.label);
}
var cmd=[];
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_437,plot);
var y=plot.axisY.getCoord(data[i].y,_437,plot);
var dx=area.left+1;
var dy=area.bottom;
if(i>0){
dx=x-plot.axisX.getCoord(data[i-1].x,_437,plot);
dy=plot.axisY.getCoord(data[i-1].y,_437,plot);
}
if(i==0){
cmd.push("M");
}else{
cmd.push("C");
var cx=x-(_43a-1)*(dx/_43a);
cmd.push(cx+","+dy);
cx=x-(dx/_43a);
cmd.push(cx+","+y);
}
cmd.push(x+","+y);
var c=document.createElementNS(dojo.svg.xmlns.svg,"circle");
c.setAttribute("cx",x);
c.setAttribute("cy",y);
c.setAttribute("r","3");
c.setAttribute("fill",data[i].series.color);
c.setAttribute("fill-opacity","0.6");
c.setAttribute("stroke-width","1");
c.setAttribute("stroke-opacity","0.85");
line.appendChild(c);
if(_439){
_439(c,data[i].src);
}
}
cmd.push("L");
cmd.push(x+","+plot.axisY.getCoord(plot.axisX.origin,_437,plot));
cmd.push("L");
cmd.push(plot.axisX.getCoord(data[0].x,_437,plot)+","+plot.axisY.getCoord(plot.axisX.origin,_437,plot));
cmd.push("Z");
path.setAttribute("d",cmd.join(" "));
return line;
},HighLow:function(data,_447,plot,_449){
var area=_447.getArea();
var _44b=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var x=plot.axisX.getCoord(data[i].x,_447,plot)-(w/2);
var y=plot.axisY.getCoord(high,_447,plot);
var h=plot.axisY.getCoord(low,_447,plot)-y;
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",h);
bar.setAttribute("fill-opacity","0.6");
if(_449){
_449(bar,data[i].src);
}
_44b.appendChild(bar);
}
return _44b;
},HighLowClose:function(data,_458,plot,_45a){
var area=_458.getArea();
var _45c=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var c=data[i].close;
var x=plot.axisX.getCoord(data[i].x,_458,plot)-(w/2);
var y=plot.axisY.getCoord(high,_458,plot);
var h=plot.axisY.getCoord(low,_458,plot)-y;
var _468=plot.axisY.getCoord(c,_458,plot);
var g=document.createElementNS(dojo.svg.xmlns.svg,"g");
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",h);
bar.setAttribute("fill-opacity","0.6");
g.appendChild(bar);
var line=document.createElementNS(dojo.svg.xmlns.svg,"line");
line.setAttribute("x1",x);
line.setAttribute("x2",x+w+(part*2));
line.setAttribute("y1",_468);
line.setAttribute("y2",_468);
line.setAttribute("style","stroke:"+data[i].series.color+";stroke-width:1px;stroke-opacity:0.6;");
g.appendChild(line);
if(_45a){
_45a(g,data[i].src);
}
_45c.appendChild(g);
}
return _45c;
},HighLowOpenClose:function(data,_46d,plot,_46f){
var area=_46d.getArea();
var _471=document.createElementNS(dojo.svg.xmlns.svg,"g");
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var o=data[i].open;
var c=data[i].close;
var x=plot.axisX.getCoord(data[i].x,_46d,plot)-(w/2);
var y=plot.axisY.getCoord(high,_46d,plot);
var h=plot.axisY.getCoord(low,_46d,plot)-y;
var open=plot.axisY.getCoord(o,_46d,plot);
var _47f=plot.axisY.getCoord(c,_46d,plot);
var g=document.createElementNS(dojo.svg.xmlns.svg,"g");
var bar=document.createElementNS(dojo.svg.xmlns.svg,"rect");
bar.setAttribute("fill",data[i].series.color);
bar.setAttribute("stroke-width","0");
bar.setAttribute("x",x);
bar.setAttribute("y",y);
bar.setAttribute("width",w);
bar.setAttribute("height",h);
bar.setAttribute("fill-opacity","0.6");
g.appendChild(bar);
var line=document.createElementNS(dojo.svg.xmlns.svg,"line");
line.setAttribute("x1",x-(part*2));
line.setAttribute("x2",x+w);
line.setAttribute("y1",open);
line.setAttribute("y2",open);
line.setAttribute("style","stroke:"+data[i].series.color+";stroke-width:1px;stroke-opacity:0.6;");
g.appendChild(line);
var line=document.createElementNS(dojo.svg.xmlns.svg,"line");
line.setAttribute("x1",x);
line.setAttribute("x2",x+w+(part*2));
line.setAttribute("y1",_47f);
line.setAttribute("y2",_47f);
line.setAttribute("style","stroke:"+data[i].series.color+";stroke-width:1px;stroke-opacity:0.6;");
g.appendChild(line);
if(_46f){
_46f(g,data[i].src);
}
_471.appendChild(g);
}
return _471;
},Scatter:function(data,_484,plot,_486){
var r=7;
var _488=document.createElementNS(dojo.svg.xmlns.svg,"g");
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_484,plot);
var y=plot.axisY.getCoord(data[i].y,_484,plot);
var _48c=document.createElementNS(dojo.svg.xmlns.svg,"path");
_48c.setAttribute("fill",data[i].series.color);
_48c.setAttribute("stroke-width","0");
_48c.setAttribute("d","M "+x+","+(y-r)+" "+"Q "+x+","+y+" "+(x+r)+","+y+" "+"Q "+x+","+y+" "+x+","+(y+r)+" "+"Q "+x+","+y+" "+(x-r)+","+y+" "+"Q "+x+","+y+" "+x+","+(y-r)+" "+"Z");
if(_486){
_486(_48c,data[i].src);
}
_488.appendChild(_48c);
}
return _488;
},Bubble:function(data,_48e,plot,_490){
var _491=document.createElementNS(dojo.svg.xmlns.svg,"g");
var _492=1;
for(var i=0;i<data.length;i++){
var x=plot.axisX.getCoord(data[i].x,_48e,plot);
var y=plot.axisY.getCoord(data[i].y,_48e,plot);
if(i==0){
var raw=data[i].size;
var dy=plot.axisY.getCoord(data[i].y+raw,_48e,plot)-y;
_492=dy/raw;
}
if(_492<1){
_492=1;
}
var _498=document.createElementNS(dojo.svg.xmlns.svg,"circle");
_498.setAttribute("fill",data[i].series.color);
_498.setAttribute("fill-opacity","0.8");
_498.setAttribute("stroke",data[i].series.color);
_498.setAttribute("stroke-width","1");
_498.setAttribute("cx",x);
_498.setAttribute("cy",y);
_498.setAttribute("r",(data[i].size/2)*_492);
if(_490){
_490(_498,data[i].src);
}
_491.appendChild(_498);
}
return _491;
}});
dojo.charting.Plotters["Default"]=dojo.charting.Plotters.Line;
}
dojo.provide("dojo.charting.vml.Plotters");
if(dojo.render.vml.capable){
dojo.mixin(dojo.charting.Plotters,{_group:function(_499){
var _49a=document.createElement("div");
_49a.style.position="absolute";
_49a.style.top="0px";
_49a.style.left="0px";
_49a.style.width=_499.size.width+"px";
_49a.style.height=_499.size.height+"px";
return _49a;
},Bar:function(_49b,plot,_49d,_49e){
var area=_49b.getArea();
var _4a0=dojo.charting.Plotters._group(_49b);
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_49d);
data.push(tmp);
}
var _4a5=8;
var _4a6=data[0].length;
if(_4a6==0){
return _4a0;
}
var _4a7=((area.right-area.left)-(_4a5*(_4a6-1)))/_4a6;
var _4a8=Math.round(_4a7/n);
var _4a9=plot.axisY.getCoord(plot.axisX.origin,_49b,plot);
for(var i=0;i<_4a6;i++){
var _4aa=area.left+(_4a7*i)+(_4a5*i);
for(var j=0;j<n;j++){
var _4ac=data[j][i].y;
var yA=_4a9;
var x=_4aa+(_4a8*j);
var y=plot.axisY.getCoord(_4ac,_49b,plot);
var h=Math.abs(yA-y);
if(_4ac<plot.axisX.origin){
yA=y;
y=_4a9;
}
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=_4a8+"px";
bar.style.height=h+"px";
bar.setAttribute("fillColor",data[j][i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
if(_49e){
_49e(bar,data[j][i].src);
}
_4a0.appendChild(bar);
}
}
return _4a0;
},HorizontalBar:function(_4b3,plot,_4b5,_4b6){
var area=_4b3.getArea();
var _4b8=dojo.charting.Plotters._group(_4b3);
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_4b5);
data.push(tmp);
}
var _4bd=6;
var _4be=data[0].length;
if(_4be==0){
return _4b8;
}
var h=((area.bottom-area.top)-(_4bd*(_4be-1)))/_4be;
var barH=h/n;
var _4c1=plot.axisX.getCoord(0,_4b3,plot);
for(var i=0;i<_4be;i++){
var _4c2=area.top+(h*i)+(_4bd*i);
for(var j=0;j<n;j++){
var _4c4=data[j][i].y;
var y=_4c2+(barH*j);
var xA=_4c1;
var x=plot.axisX.getCoord(_4c4,_4b3,plot);
var w=Math.abs(x-xA);
if(_4c4>0){
x=_4c1;
}
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=xA+"px";
bar.style.width=w+"px";
bar.style.height=barH+"px";
bar.setAttribute("fillColor",data[j][i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
if(_4b6){
_4b6(bar,data[j][i].src);
}
_4b8.appendChild(bar);
}
}
var _4bd=4;
var n=plot.series.length;
var h=((area.bottom-area.top)-(_4bd*(n-1)))/n;
var _4c1=plot.axisX.getCoord(0,_4b3,plot);
for(var i=0;i<n;i++){
var _4cb=plot.series[i];
var data=_4cb.data.evaluate(_4b5);
var y=area.top+(h*i)+(_4bd*i);
var _4c4=data[data.length-1].y;
var xA=_4c1;
var x=plot.axisX.getCoord(_4c4,_4b3,plot);
var w=Math.abs(xA-x);
if(_4c4>0){
xA=x;
x=_4c1;
}
}
return _4b8;
},Gantt:function(_4cc,plot,_4ce,_4cf){
var area=_4cc.getArea();
var _4d1=dojo.charting.Plotters._group(_4cc);
var n=plot.series.length;
var data=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_4ce);
data.push(tmp);
}
var _4d6=2;
var _4d7=data[0].length;
if(_4d7==0){
return _4d1;
}
var h=((area.bottom-area.top)-(_4d6*(_4d7-1)))/_4d7;
var barH=h/n;
for(var i=0;i<_4d7;i++){
var _4da=area.top+(h*i)+(_4d6*i);
for(var j=0;j<n;j++){
var high=data[j][i].high;
var low=data[j][i].low;
if(low>high){
var t=high;
high=low;
low=t;
}
var x=plot.axisX.getCoord(low,_4cc,plot);
var w=plot.axisX.getCoord(high,_4cc,plot)-x;
var y=_4da+(barH*j);
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=w+"px";
bar.style.height=barH+"px";
bar.setAttribute("fillColor",data[j][i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
if(_4cf){
_4cf(bar,data[j][i].src);
}
_4d1.appendChild(bar);
}
}
return _4d1;
},StackedArea:function(_4e4,plot,_4e6,_4e7){
var area=_4e4.getArea();
var _4e9=dojo.charting.Plotters._group(_4e4);
var n=plot.series.length;
var data=[];
var _4ec=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_4e6);
for(var j=0;j<tmp.length;j++){
if(i==0){
_4ec.push(tmp[j].y);
}else{
_4ec[j]+=tmp[j].y;
}
tmp[j].y=_4ec[j];
}
data.push(tmp);
}
for(var i=n-1;i>=0;i--){
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","1px");
path.setAttribute("strokecolor",data[i][0].series.color);
path.setAttribute("fillcolor",data[i][0].series.color);
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _4f1=document.createElement("v:stroke");
_4f1.setAttribute("opacity","0.8");
path.appendChild(_4f1);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.4");
path.appendChild(fill);
var cmd=[];
var r=3;
for(var j=0;j<data[i].length;j++){
var _4f5=data[i];
var x=Math.round(plot.axisX.getCoord(_4f5[j].x,_4e4,plot));
var y=Math.round(plot.axisY.getCoord(_4f5[j].y,_4e4,plot));
if(j==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
cmd.push("l");
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",_4f5[j].series.color);
c.setAttribute("fillcolor",_4f5[j].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_4e9.appendChild(c);
if(_4e7){
_4e7(c,data[j].src);
}
}
if(i==0){
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_4e4,plot)));
cmd.push("l");
cmd.push(Math.round(plot.axisX.getCoord(data[0][0].x,_4e4,plot))+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_4e4,plot)));
}else{
var _4f5=data[i-1];
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(_4f5[_4f5.length-1].y,_4e4,plot)));
for(var j=_4f5.length-2;j>=0;j--){
var x=Math.round(plot.axisX.getCoord(_4f5[j].x,_4e4,plot));
var y=Math.round(plot.axisY.getCoord(_4f5[j].y,_4e4,plot));
cmd.push("l");
cmd.push(x+","+y);
}
}
path.setAttribute("path",cmd.join(" ")+" x e");
_4e9.appendChild(path);
}
return _4e9;
},StackedCurvedArea:function(_4fb,plot,_4fd,_4fe){
var _4ff=3;
var area=_4fb.getArea();
var _501=dojo.charting.Plotters._group(_4fb);
var n=plot.series.length;
var data=[];
var _504=[];
for(var i=0;i<n;i++){
var tmp=plot.series[i].data.evaluate(_4fd);
for(var j=0;j<tmp.length;j++){
if(i==0){
_504.push(tmp[j].y);
}else{
_504[j]+=tmp[j].y;
}
tmp[j].y=_504[j];
}
data.push(tmp);
}
for(var i=n-1;i>=0;i--){
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","1px");
path.setAttribute("strokecolor",data[i][0].series.color);
path.setAttribute("fillcolor",data[i][0].series.color);
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _509=document.createElement("v:stroke");
_509.setAttribute("opacity","0.8");
path.appendChild(_509);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.4");
path.appendChild(fill);
var cmd=[];
var r=3;
for(var j=0;j<data[i].length;j++){
var _50d=data[i];
var x=Math.round(plot.axisX.getCoord(_50d[j].x,_4fb,plot));
var y=Math.round(plot.axisY.getCoord(_50d[j].y,_4fb,plot));
if(j==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
var _510=Math.round(plot.axisX.getCoord(_50d[j-1].x,_4fb,plot));
var _511=Math.round(plot.axisY.getCoord(_50d[j-1].y,_4fb,plot));
var dx=x-_510;
var dy=y-_511;
cmd.push("c");
var cx=Math.round((x-(_4ff-1)*(dx/_4ff)));
cmd.push(cx+","+_511);
cx=Math.round((x-(dx/_4ff)));
cmd.push(cx+","+y);
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",_50d[j].series.color);
c.setAttribute("fillcolor",_50d[j].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_501.appendChild(c);
if(_4fe){
_4fe(c,data[j].src);
}
}
if(i==0){
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_4fb,plot)));
cmd.push("l");
cmd.push(Math.round(plot.axisX.getCoord(data[0][0].x,_4fb,plot))+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_4fb,plot)));
}else{
var _50d=data[i-1];
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(_50d[_50d.length-1].y,_4fb,plot)));
for(var j=_50d.length-2;j>=0;j--){
var x=Math.round(plot.axisX.getCoord(_50d[j].x,_4fb,plot));
var y=Math.round(plot.axisY.getCoord(_50d[j].y,_4fb,plot));
var _510=Math.round(plot.axisX.getCoord(_50d[j+1].x,_4fb,plot));
var _511=Math.round(plot.axisY.getCoord(_50d[j+1].y,_4fb,plot));
var dx=x-_510;
var dy=y-_511;
cmd.push("c");
var cx=Math.round((x-(_4ff-1)*(dx/_4ff)));
cmd.push(cx+","+_511);
cx=Math.round((x-(dx/_4ff)));
cmd.push(cx+","+y);
cmd.push(x+","+y);
}
}
path.setAttribute("path",cmd.join(" ")+" x e");
_501.appendChild(path);
}
return _501;
},DataBar:function(data,_519,plot,_51b){
var area=_519.getArea();
var _51d=dojo.charting.Plotters._group(_519);
var n=data.length;
var w=(area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower);
var _520=plot.axisY.getCoord(plot.axisX.origin,_519,plot);
for(var i=0;i<n;i++){
var _522=data[i].y;
var yA=_520;
var x=plot.axisX.getCoord(data[i].x,_519,plot)-(w/2)+1;
var y=plot.axisY.getCoord(_522,_519,plot);
var h=Math.abs(yA-y);
if(_522<plot.axisX.origin){
yA=y;
y=_520;
}
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=w+"px";
bar.style.height=h+"px";
bar.setAttribute("fillColor",data[i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
if(_51b){
_51b(bar,data[i].src);
}
_51d.appendChild(bar);
}
return _51d;
},Line:function(data,_52a,plot,_52c){
var area=_52a.getArea();
var _52e=dojo.charting.Plotters._group(_52a);
if(data.length==0){
return _52e;
}
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","2px");
path.setAttribute("strokecolor",data[0].series.color);
path.setAttribute("fillcolor","none");
path.setAttribute("filled","false");
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _530=document.createElement("v:stroke");
_530.setAttribute("opacity","0.8");
path.appendChild(_530);
var cmd=[];
var r=3;
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_52a,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_52a,plot));
if(i==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
cmd.push("l");
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",data[i].series.color);
c.setAttribute("fillcolor",data[i].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_52e.appendChild(c);
if(_52c){
_52c(c,data[i].src);
}
}
path.setAttribute("path",cmd.join(" ")+" e");
_52e.appendChild(path);
return _52e;
},CurvedLine:function(data,_53a,plot,_53c){
var _53d=3;
var area=_53a.getArea();
var _53f=dojo.charting.Plotters._group(_53a);
if(data.length==0){
return _53f;
}
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","2px");
path.setAttribute("strokecolor",data[0].series.color);
path.setAttribute("fillcolor","none");
path.setAttribute("filled","false");
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _541=document.createElement("v:stroke");
_541.setAttribute("opacity","0.8");
path.appendChild(_541);
var cmd=[];
var r=3;
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_53a,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_53a,plot));
if(i==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
var _547=Math.round(plot.axisX.getCoord(data[i-1].x,_53a,plot));
var _548=Math.round(plot.axisY.getCoord(data[i-1].y,_53a,plot));
var dx=x-_547;
var dy=y-_548;
cmd.push("c");
var cx=Math.round((x-(_53d-1)*(dx/_53d)));
cmd.push(cx+","+_548);
cx=Math.round((x-(dx/_53d)));
cmd.push(cx+","+y);
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",data[i].series.color);
c.setAttribute("fillcolor",data[i].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_53f.appendChild(c);
if(_53c){
_53c(c,data[i].src);
}
}
path.setAttribute("path",cmd.join(" ")+" e");
_53f.appendChild(path);
return _53f;
},Area:function(data,_550,plot,_552){
var area=_550.getArea();
var _554=dojo.charting.Plotters._group(_550);
if(data.length==0){
return _554;
}
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","1px");
path.setAttribute("strokecolor",data[0].series.color);
path.setAttribute("fillcolor",data[0].series.color);
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _556=document.createElement("v:stroke");
_556.setAttribute("opacity","0.8");
path.appendChild(_556);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.4");
path.appendChild(fill);
var cmd=[];
var r=3;
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_550,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_550,plot));
if(i==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
cmd.push("l");
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",data[i].series.color);
c.setAttribute("fillcolor",data[i].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_554.appendChild(c);
if(_552){
_552(c,data[i].src);
}
}
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_550,plot)));
cmd.push("l");
cmd.push(Math.round(plot.axisX.getCoord(data[0].x,_550,plot))+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_550,plot)));
path.setAttribute("path",cmd.join(" ")+" x e");
_554.appendChild(path);
return _554;
},CurvedArea:function(data,_561,plot,_563){
var _564=3;
var area=_561.getArea();
var _566=dojo.charting.Plotters._group(_561);
if(data.length==0){
return _566;
}
var path=document.createElement("v:shape");
path.setAttribute("strokeweight","1px");
path.setAttribute("strokecolor",data[0].series.color);
path.setAttribute("fillcolor",data[0].series.color);
path.setAttribute("coordsize",(area.right-area.left)+","+(area.bottom-area.top));
path.style.position="absolute";
path.style.top="0px";
path.style.left="0px";
path.style.width=area.right-area.left+"px";
path.style.height=area.bottom-area.top+"px";
var _568=document.createElement("v:stroke");
_568.setAttribute("opacity","0.8");
path.appendChild(_568);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.4");
path.appendChild(fill);
var cmd=[];
var r=3;
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_561,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_561,plot));
if(i==0){
cmd.push("m");
cmd.push(x+","+y);
}else{
var _56f=Math.round(plot.axisX.getCoord(data[i-1].x,_561,plot));
var _570=Math.round(plot.axisY.getCoord(data[i-1].y,_561,plot));
var dx=x-_56f;
var dy=y-_570;
cmd.push("c");
var cx=Math.round((x-(_564-1)*(dx/_564)));
cmd.push(cx+","+_570);
cx=Math.round((x-(dx/_564)));
cmd.push(cx+","+y);
cmd.push(x+","+y);
}
var c=document.createElement("v:oval");
c.setAttribute("strokeweight","1px");
c.setAttribute("strokecolor",data[i].series.color);
c.setAttribute("fillcolor",data[i].series.color);
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.8");
c.appendChild(str);
str=document.createElement("v:fill");
str.setAttribute("opacity","0.6");
c.appendChild(str);
var s=c.style;
s.position="absolute";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_566.appendChild(c);
if(_563){
_563(c,data[i].src);
}
}
cmd.push("l");
cmd.push(x+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_561,plot)));
cmd.push("l");
cmd.push(Math.round(plot.axisX.getCoord(data[0].x,_561,plot))+","+Math.round(plot.axisY.getCoord(plot.axisX.origin,_561,plot)));
path.setAttribute("path",cmd.join(" ")+" x e");
_566.appendChild(path);
return _566;
},HighLow:function(data,_578,plot,_57a){
var area=_578.getArea();
var _57c=dojo.charting.Plotters._group(_578);
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var x=plot.axisX.getCoord(data[i].x,_578,plot)-(w/2);
var y=plot.axisY.getCoord(high,_578,plot);
var h=plot.axisY.getCoord(low,_578,plot)-y;
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=w+"px";
bar.style.height=h+"px";
bar.setAttribute("fillColor",data[i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
if(_57a){
_57a(bar,data[i].src);
}
_57c.appendChild(bar);
}
return _57c;
},HighLowClose:function(data,_58a,plot,_58c){
var area=_58a.getArea();
var _58e=dojo.charting.Plotters._group(_58a);
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var c=data[i].close;
var x=plot.axisX.getCoord(data[i].x,_58a,plot)-(w/2);
var y=plot.axisY.getCoord(high,_58a,plot);
var h=plot.axisY.getCoord(low,_58a,plot)-y;
var _59a=plot.axisY.getCoord(c,_58a,plot);
var g=document.createElement("div");
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=w+"px";
bar.style.height=h+"px";
bar.setAttribute("fillColor",data[i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
g.appendChild(bar);
var line=document.createElement("v:line");
line.setAttribute("strokecolor",data[i].series.color);
line.setAttribute("strokeweight","1px");
line.setAttribute("from",x+"px,"+_59a+"px");
line.setAttribute("to",(x+w+(part*2)-2)+"px,"+_59a+"px");
var s=line.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.6");
line.appendChild(str);
g.appendChild(line);
if(_58c){
_58c(g,data[i].src);
}
_58e.appendChild(g);
}
return _58e;
},HighLowOpenClose:function(data,_5a2,plot,_5a4){
var area=_5a2.getArea();
var _5a6=dojo.charting.Plotters._group(_5a2);
var n=data.length;
var part=((area.right-area.left)/(plot.axisX.range.upper-plot.axisX.range.lower))/4;
var w=part*2;
for(var i=0;i<n;i++){
var high=data[i].high;
var low=data[i].low;
if(low>high){
var t=low;
low=high;
high=t;
}
var o=data[i].open;
var c=data[i].close;
var x=plot.axisX.getCoord(data[i].x,_5a2,plot)-(w/2);
var y=plot.axisY.getCoord(high,_5a2,plot);
var h=plot.axisY.getCoord(low,_5a2,plot)-y;
var open=plot.axisY.getCoord(o,_5a2,plot);
var _5b4=plot.axisY.getCoord(c,_5a2,plot);
var g=document.createElement("div");
var bar=document.createElement("v:rect");
bar.style.position="absolute";
bar.style.top=y+1+"px";
bar.style.left=x+"px";
bar.style.width=w+"px";
bar.style.height=h+"px";
bar.setAttribute("fillColor",data[i].series.color);
bar.setAttribute("stroked","false");
bar.style.antialias="false";
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
bar.appendChild(fill);
g.appendChild(bar);
var line=document.createElement("v:line");
line.setAttribute("strokecolor",data[i].series.color);
line.setAttribute("strokeweight","1px");
line.setAttribute("from",(x-(part*2))+"px,"+open+"px");
line.setAttribute("to",(x+w-2)+"px,"+open+"px");
var s=line.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.6");
line.appendChild(str);
g.appendChild(line);
var line=document.createElement("v:line");
line.setAttribute("strokecolor",data[i].series.color);
line.setAttribute("strokeweight","1px");
line.setAttribute("from",x+"px,"+_5b4+"px");
line.setAttribute("to",(x+w+(part*2)-2)+"px,"+_5b4+"px");
var s=line.style;
s.position="absolute";
s.top="0px";
s.left="0px";
s.antialias="false";
var str=document.createElement("v:stroke");
str.setAttribute("opacity","0.6");
line.appendChild(str);
g.appendChild(line);
if(_5a4){
_5a4(g,data[i].src);
}
_5a6.appendChild(g);
}
return _5a6;
},Scatter:function(data,_5bc,plot,_5be){
var r=6;
var mod=r/2;
var area=_5bc.getArea();
var _5c2=dojo.charting.Plotters._group(_5bc);
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_5bc,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_5bc,plot));
var _5c6=document.createElement("v:rect");
_5c6.setAttribute("strokecolor",data[i].series.color);
_5c6.setAttribute("fillcolor",data[i].series.color);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
_5c6.appendChild(fill);
var s=_5c6.style;
s.position="absolute";
s.rotation="45";
s.top=(y-mod)+"px";
s.left=(x-mod)+"px";
s.width=r+"px";
s.height=r+"px";
_5c2.appendChild(_5c6);
if(_5be){
_5be(_5c6,data[i].src);
}
}
return _5c2;
},Bubble:function(data,_5ca,plot,_5cc){
var _5cd=1;
var area=_5ca.getArea();
var _5cf=dojo.charting.Plotters._group(_5ca);
for(var i=0;i<data.length;i++){
var x=Math.round(plot.axisX.getCoord(data[i].x,_5ca,plot));
var y=Math.round(plot.axisY.getCoord(data[i].y,_5ca,plot));
if(i==0){
var raw=data[i].size;
var dy=plot.axisY.getCoord(data[i].y+raw,_5ca,plot)-y;
_5cd=dy/raw;
}
if(_5cd<1){
_5cd=1;
}
var r=(data[i].size/2)*_5cd;
var _5d6=document.createElement("v:oval");
_5d6.setAttribute("strokecolor",data[i].series.color);
_5d6.setAttribute("fillcolor",data[i].series.color);
var fill=document.createElement("v:fill");
fill.setAttribute("opacity","0.6");
_5d6.appendChild(fill);
var s=_5d6.style;
s.position="absolute";
s.rotation="45";
s.top=(y-r)+"px";
s.left=(x-r)+"px";
s.width=(r*2)+"px";
s.height=(r*2)+"px";
_5cf.appendChild(_5d6);
if(_5cc){
_5cc(_5d6,data[i].src);
}
}
return _5cf;
}});
dojo.charting.Plotters["Default"]=dojo.charting.Plotters.Line;
}
dojo.provide("dojo.charting.Series");
dojo.charting.Series=function(_5d9){
var args=_5d9||{length:1};
this.dataSource=args.dataSource||null;
this.bindings={};
this.color=args.color;
this.label=args.label;
if(args.bindings){
for(var p in args.bindings){
this.addBinding(p,args.bindings[p]);
}
}
};
dojo.extend(dojo.charting.Series,{bind:function(src,_5dd){
this.dataSource=src;
this.bindings=_5dd;
},addBinding:function(name,_5df){
this.bindings[name]=_5df;
},evaluate:function(_5e0){
var ret=[];
var a=this.dataSource.getData();
var l=a.length;
var _5e4=0;
var end=l;
if(_5e0){
if(_5e0.between){
for(var i=0;i<l;i++){
var fld=this.dataSource.getField(a[i],_5e0.between.field);
if(fld>=_5e0.between.low&&fld<=_5e0.between.high){
var o={src:a[i],series:this};
for(var p in this.bindings){
o[p]=this.dataSource.getField(a[i],this.bindings[p]);
}
ret.push(o);
}
}
}else{
if(_5e0.from||_5e0.length){
if(_5e0.from){
_5e4=Math.max(_5e0.from,0);
if(_5e0.to){
end=Math.min(_5e0.to,end);
}
}else{
if(_5e0.length<0){
_5e4=Math.max((end+length),0);
}else{
end=Math.min((_5e4+length),end);
}
}
for(var i=_5e4;i<end;i++){
var o={src:a[i],series:this};
for(var p in this.bindings){
o[p]=this.dataSource.getField(a[i],this.bindings[p]);
}
ret.push(o);
}
}
}
}else{
for(var i=_5e4;i<end;i++){
var o={src:a[i],series:this};
for(var p in this.bindings){
o[p]=this.dataSource.getField(a[i],this.bindings[p]);
}
ret.push(o);
}
}
if(ret.length>0&&typeof (ret[0].x)!="undefined"){
ret.sort(function(a,b){
if(a.x>b.x){
return 1;
}
if(a.x<b.x){
return -1;
}
return 0;
});
}
return ret;
},trends:{createRange:function(_5ec,len){
var idx=_5ec.length-1;
var _5ef=(len||_5ec.length);
return {"index":idx,"length":_5ef,"start":Math.max(idx-_5ef,0)};
},mean:function(_5f0,len){
var _5f2=this.createRange(_5f0,len);
if(_5f2.index<0){
return 0;
}
var _5f3=0;
var _5f4=0;
for(var i=_5f2.index;i>=_5f2.start;i--){
_5f3+=_5f0[i].y;
_5f4++;
}
_5f3/=Math.max(_5f4,1);
return _5f3;
},variance:function(_5f6,len){
var _5f8=this.createRange(_5f6,len);
if(_5f8.index<0){
return 0;
}
var _5f9=0;
var _5fa=0;
var _5fb=0;
for(var i=_5f8.index;i>=_5f8.start;i--){
_5f9+=_5f6[i].y;
_5fa+=Math.pow(_5f6[i].y,2);
_5fb++;
}
return (_5fa/_5fb)-Math.pow(_5f9/_5fb,2);
},standardDeviation:function(_5fd,len){
return Math.sqrt(this.getVariance(_5fd,len));
},max:function(_5ff,len){
var _601=this.createRange(_5ff,len);
if(_601.index<0){
return 0;
}
var max=Number.MIN_VALUE;
for(var i=_601.index;i>=_601.start;i--){
max=Math.max(_5ff[i].y,max);
}
return max;
},min:function(_604,len){
var _606=this.createRange(_604,len);
if(_606.index<0){
return 0;
}
var min=Number.MAX_VALUE;
for(var i=_606.index;i>=_606.start;i--){
min=Math.min(_604[i].y,min);
}
return min;
},median:function(_609,len){
var _60b=this.createRange(_609,len);
if(_60b.index<0){
return 0;
}
var a=[];
for(var i=_60b.index;i>=_60b.start;i--){
var b=false;
for(var j=0;j<a.length;j++){
if(_609[i].y==a[j]){
b=true;
break;
}
}
if(!b){
a.push(_609[i].y);
}
}
a.sort();
if(a.length>0){
return a[Math.ceil(a.length/2)];
}
return 0;
},mode:function(_610,len){
var _612=this.createRange(_610,len);
if(_612.index<0){
return 0;
}
var o={};
var ret=0;
var _615=Number.MIN_VALUE;
for(var i=_612.index;i>=_612.start;i--){
if(!o[_610[i].y]){
o[_610[i].y]=1;
}else{
o[_610[i].y]++;
}
}
for(var p in o){
if(_615<o[p]){
_615=o[p];
ret=p;
}
}
return ret;
}}});
dojo.provide("dojo.charting.Plot");
dojo.charting.RenderPlotSeries={Singly:"single",Grouped:"grouped"};
dojo.charting.Plot=function(_618,_619,_61a){
var id="dojo-charting-plot-"+dojo.charting.Plot.count++;
this.getId=function(){
return id;
};
this.setId=function(key){
id=key;
};
this.axisX=null;
this.axisY=null;
this.series=[];
this.dataNode=null;
this.renderType=dojo.charting.RenderPlotSeries.Singly;
if(_618){
this.setAxis(_618,"x");
}
if(_619){
this.setAxis(_619,"y");
}
if(_61a){
for(var i=0;i<_61a.length;i++){
this.addSeries(_61a[i]);
}
}
};
dojo.charting.Plot.count=0;
dojo.extend(dojo.charting.Plot,{addSeries:function(_61e,_61f){
if(_61e.plotter){
this.series.push(_61e);
}else{
this.series.push({data:_61e,plotter:_61f||dojo.charting.Plotters["Default"]});
}
},setAxis:function(axis,_621){
if(_621.toLowerCase()=="x"){
this.axisX=axis;
}else{
if(_621.toLowerCase()=="y"){
this.axisY=axis;
}
}
},getRanges:function(){
var xmin,xmax,ymin,ymax;
xmin=ymin=Number.MAX_VALUE;
xmax=ymax=Number.MIN_VALUE;
for(var i=0;i<this.series.length;i++){
var _627=this.series[i].data.evaluate();
for(var j=0;j<_627.length;j++){
var comp=_627[j];
xmin=Math.min(comp.x,xmin);
ymin=Math.min(comp.y,ymin);
xmax=Math.max(comp.x,xmax);
ymax=Math.max(comp.y,ymax);
}
}
return {x:{upper:xmax,lower:xmin},y:{upper:ymax,lower:ymin},toString:function(){
return "[ x:"+xmax+" - "+xmin+", y:"+ymax+" - "+ymin+"]";
}};
},destroy:function(){
var node=this.dataNode;
while(node&&node.childNodes&&node.childNodes.length>0){
node.removeChild(node.childNodes[0]);
}
this.dataNode=null;
}});
dojo.provide("dojo.charting.PlotArea");
dojo.charting.PlotArea=function(){
var id="dojo-charting-plotarea-"+dojo.charting.PlotArea.count++;
this.getId=function(){
return id;
};
this.setId=function(key){
id=key;
};
this.areaType="standard";
this.plots=[];
this.size={width:600,height:400};
this.padding={top:10,right:10,bottom:20,left:20};
this.nodes={main:null,area:null,background:null,axes:null,plots:null};
this._color={h:140,s:120,l:120,step:27};
};
dojo.charting.PlotArea.count=0;
dojo.extend(dojo.charting.PlotArea,{nextColor:function(){
var rgb=dojo.gfx.color.hsl2rgb(this._color.h,this._color.s,this._color.l);
this._color.h=(this._color.h+this._color.step)%360;
while(this._color.h<140){
this._color.h+=this._color.step;
}
return dojo.gfx.color.rgb2hex(rgb[0],rgb[1],rgb[2]);
},getArea:function(){
return {left:this.padding.left,right:this.size.width-this.padding.right,top:this.padding.top,bottom:this.size.height-this.padding.bottom,toString:function(){
var a=[this.top,this.right,this.bottom,this.left];
return "["+a.join()+"]";
}};
},getAxes:function(){
var axes={};
for(var i=0;i<this.plots.length;i++){
var plot=this.plots[i];
axes[plot.axisX.getId()]={axis:plot.axisX,drawAgainst:plot.axisY,plot:plot,plane:"x"};
axes[plot.axisY.getId()]={axis:plot.axisY,drawAgainst:plot.axisX,plot:plot,plane:"y"};
}
return axes;
},getLegendInfo:function(){
var a=[];
for(var i=0;i<this.plots.length;i++){
for(var j=0;j<this.plots[i].series.length;j++){
var data=this.plots[i].series[j].data;
a.push({label:data.label,color:data.color});
}
}
return a;
},setAxesRanges:function(){
var _636={};
var axes={};
for(var i=0;i<this.plots.length;i++){
var plot=this.plots[i];
var _636=plot.getRanges();
var x=_636.x;
var y=_636.y;
var ax,ay;
if(!axes[plot.axisX.getId()]){
axes[plot.axisX.getId()]=plot.axisX;
_636[plot.axisX.getId()]={upper:x.upper,lower:x.lower};
}
ax=_636[plot.axisX.getId()];
ax.upper=Math.max(ax.upper,x.upper);
ax.lower=Math.min(ax.lower,x.lower);
if(!axes[plot.axisY.getId()]){
axes[plot.axisY.getId()]=plot.axisY;
_636[plot.axisY.getId()]={upper:y.upper,lower:y.lower};
}
ay=_636[plot.axisY.getId()];
ay.upper=Math.max(ay.upper,y.upper);
ay.lower=Math.min(ay.lower,y.lower);
}
for(var p in axes){
axes[p].range=_636[p];
}
},render:function(_63f,_640){
if(!this.nodes.main||!this.nodes.area||!this.nodes.background||!this.nodes.plots||!this.nodes.axes){
this.initialize();
}
this.resize();
for(var i=0;i<this.plots.length;i++){
var plot=this.plots[i];
if(plot.dataNode){
this.nodes.plots.removeChild(plot.dataNode);
}
var _643=this.initializePlot(plot);
switch(plot.renderType){
case dojo.charting.RenderPlotSeries.Grouped:
if(plot.series[0]){
_643.appendChild(plot.series[0].plotter(this,plot,_63f,_640));
}
break;
case dojo.charting.RenderPlotSeries.Singly:
default:
for(var j=0;j<plot.series.length;j++){
var _645=plot.series[j];
var data=_645.data.evaluate(_63f);
_643.appendChild(_645.plotter(data,this,plot,_640));
}
}
this.nodes.plots.appendChild(_643);
}
},destroy:function(){
for(var i=0;i<this.plots.length;i++){
this.plots[i].destroy();
}
for(var p in this.nodes){
var node=this.nodes[p];
if(!node){
continue;
}
if(!node.childNodes){
continue;
}
while(node.childNodes.length>0){
node.removeChild(node.childNodes[0]);
}
this.nodes[p]=null;
}
}});
dojo.provide("dojo.charting.svg.PlotArea");
if(dojo.render.svg.capable){
dojo.extend(dojo.charting.PlotArea,{resize:function(){
var area=this.getArea();
this.nodes.area.setAttribute("width",this.size.width);
this.nodes.area.setAttribute("height",this.size.height);
var rect=this.nodes.area.getElementsByTagName("rect")[0];
rect.setAttribute("x",area.left);
rect.setAttribute("y",area.top);
rect.setAttribute("width",area.right-area.left);
rect.setAttribute("height",area.bottom-area.top);
this.nodes.background.setAttribute("width",this.size.width);
this.nodes.background.setAttribute("height",this.size.height);
if(this.nodes.plots){
this.nodes.area.removeChild(this.nodes.plots);
this.nodes.plots=null;
}
this.nodes.plots=document.createElementNS(dojo.svg.xmlns.svg,"g");
this.nodes.plots.setAttribute("id",this.getId()+"-plots");
this.nodes.plots.setAttribute("style","clip-path:url(#"+this.getId()+"-clip);");
this.nodes.area.appendChild(this.nodes.plots);
for(var i=0;i<this.plots.length;i++){
this.nodes.plots.appendChild(this.initializePlot(this.plots[i]));
}
if(this.nodes.axes){
this.nodes.area.removeChild(this.nodes.axes);
this.nodes.axes=null;
}
this.nodes.axes=document.createElementNS(dojo.svg.xmlns.svg,"g");
this.nodes.axes.setAttribute("id",this.getId()+"-axes");
this.nodes.area.appendChild(this.nodes.axes);
var axes=this.getAxes();
for(var p in axes){
var obj=axes[p];
this.nodes.axes.appendChild(obj.axis.initialize(this,obj.plot,obj.drawAgainst,obj.plane));
}
},initializePlot:function(plot){
plot.destroy();
plot.dataNode=document.createElementNS(dojo.svg.xmlns.svg,"g");
plot.dataNode.setAttribute("id",plot.getId());
return plot.dataNode;
},initialize:function(){
this.destroy();
this.nodes.main=document.createElement("div");
this.nodes.area=document.createElementNS(dojo.svg.xmlns.svg,"svg");
this.nodes.area.setAttribute("id",this.getId());
this.nodes.main.appendChild(this.nodes.area);
var defs=document.createElementNS(dojo.svg.xmlns.svg,"defs");
var clip=document.createElementNS(dojo.svg.xmlns.svg,"clipPath");
clip.setAttribute("id",this.getId()+"-clip");
var rect=document.createElementNS(dojo.svg.xmlns.svg,"rect");
clip.appendChild(rect);
defs.appendChild(clip);
this.nodes.area.appendChild(defs);
this.nodes.background=document.createElementNS(dojo.svg.xmlns.svg,"rect");
this.nodes.background.setAttribute("id",this.getId()+"-background");
this.nodes.background.setAttribute("fill","#fff");
this.nodes.area.appendChild(this.nodes.background);
this.resize();
return this.nodes.main;
}});
}
dojo.provide("dojo.charting.vml.PlotArea");
if(dojo.render.vml.capable){
dojo.extend(dojo.charting.PlotArea,{resize:function(){
var a=this.getArea();
this.nodes.area.style.width=this.size.width+"px";
this.nodes.area.style.height=this.size.height+"px";
this.nodes.background.style.width=this.size.width+"px";
this.nodes.background.style.height=this.size.height+"px";
this.nodes.plots.width=this.size.width+"px";
this.nodes.plots.height=this.size.height+"px";
this.nodes.plots.style.clip="rect("+a.top+" "+a.right+" "+a.bottom+" "+a.left+")";
if(this.nodes.axes){
this.nodes.area.removeChild(this.nodes.axes);
}
var axes=this.nodes.axes=document.createElement("div");
axes.id=this.getId()+"-axes";
this.nodes.area.appendChild(axes);
var ax=this.getAxes();
for(var p in ax){
var obj=ax[p];
axes.appendChild(obj.axis.initialize(this,obj.plot,obj.drawAgainst,obj.plane));
}
},initializePlot:function(plot){
plot.destroy();
plot.dataNode=document.createElement("div");
plot.dataNode.id=plot.getId();
return plot.dataNode;
},initialize:function(){
this.destroy();
var main=this.nodes.main=document.createElement("div");
var area=this.nodes.area=document.createElement("div");
area.id=this.getId();
area.style.position="absolute";
main.appendChild(area);
var bg=this.nodes.background=document.createElement("div");
bg.id=this.getId()+"-background";
bg.style.position="absolute";
bg.style.top="0px";
bg.style.left="0px";
bg.style.backgroundColor="#fff";
area.appendChild(bg);
var a=this.getArea();
var _65e=this.nodes.plots=document.createElement("div");
_65e.id=this.getId()+"-plots";
_65e.style.position="absolute";
_65e.style.top="0px";
_65e.style.left="0px";
area.appendChild(_65e);
for(var i=0;i<this.plots.length;i++){
_65e.appendChild(this.initializePlot(this.plots[i]));
}
this.resize();
return main;
}});
}
dojo.provide("dojo.charting.Chart");
dojo.charting.Chart=function(node,_661,_662){
this.node=node||null;
this.title=_661||"Chart";
this.description=_662||"";
this.plotAreas=[];
};
dojo.extend(dojo.charting.Chart,{addPlotArea:function(obj,_664){
if(obj.x!=null&&obj.left==null){
obj.left=obj.x;
}
if(obj.y!=null&&obj.top==null){
obj.top=obj.y;
}
this.plotAreas.push(obj);
if(_664){
this.render();
}
},onInitialize:function(_665){
},onRender:function(_666){
},onDestroy:function(_667){
},initialize:function(){
if(!this.node){
dojo.raise("dojo.charting.Chart.initialize: there must be a root node defined for the Chart.");
}
this.destroy();
this.render();
this.onInitialize(this);
},render:function(){
if(this.node.style.position!="absolute"){
this.node.style.position="relative";
}
for(var i=0;i<this.plotAreas.length;i++){
var area=this.plotAreas[i].plotArea;
var node=area.initialize();
node.style.position="absolute";
node.style.top=this.plotAreas[i].top+"px";
node.style.left=this.plotAreas[i].left+"px";
this.node.appendChild(node);
area.render();
}
},destroy:function(){
for(var i=0;i<this.plotAreas.length;i++){
this.plotAreas[i].plotArea.destroy();
}
while(this.node&&this.node.childNodes&&this.node.childNodes.length>0){
this.node.removeChild(this.node.childNodes[0]);
}
}});


__CPAN_EDITION__ charting build.txt
Files baked into this build:

dojo.js:
dojoGuardStart.js
../src/bootstrap1.js
../src/loader.js
dojoGuardEnd.js
../src/hostenv_browser.js
../src/lang/common.js
../src/lang/func.js
../src/string/common.js
../src/lang/array.js
../src/string/extras.js
../src/AdapterRegistry.js
../src/json.js
../src/collections/Store.js
../src/gfx/color.js
../src/gfx/color/hsl.js
../src/charting/__package__.js
../src/dom.js
../src/svg.js
../src/charting/Axis.js
../src/charting/svg/Axis.js
../src/charting/vml/Axis.js
../src/charting/Plotters.js
../src/charting/svg/Plotters.js
../src/charting/vml/Plotters.js
../src/charting/Series.js
../src/charting/Plot.js
../src/charting/PlotArea.js
../src/charting/svg/PlotArea.js
../src/charting/vml/PlotArea.js
../src/charting/Chart.js

__CPAN_EDITION__ editor dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:3,flag:"",revision:Number("$Rev: 8617 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
dojo.hostenv._djInitFired=false;
function dj_load_init(e){
dojo.hostenv._djInitFired=true;
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _ef=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_ef.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_f1,_f2){
var _f3=_f1.firstChild;
while(_f3&&_f3.nodeType!=dojo.dom.ELEMENT_NODE){
_f3=_f3.nextSibling;
}
if(_f2&&_f3&&_f3.tagName&&_f3.tagName.toLowerCase()!=_f2.toLowerCase()){
_f3=dojo.dom.nextElement(_f3,_f2);
}
return _f3;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_f4,_f5){
var _f6=_f4.lastChild;
while(_f6&&_f6.nodeType!=dojo.dom.ELEMENT_NODE){
_f6=_f6.previousSibling;
}
if(_f5&&_f6&&_f6.tagName&&_f6.tagName.toLowerCase()!=_f5.toLowerCase()){
_f6=dojo.dom.prevElement(_f6,_f5);
}
return _f6;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(_f7,_f8){
if(!_f7){
return null;
}
do{
_f7=_f7.nextSibling;
}while(_f7&&_f7.nodeType!=dojo.dom.ELEMENT_NODE);
if(_f7&&_f8&&_f8.toLowerCase()!=_f7.tagName.toLowerCase()){
return dojo.dom.nextElement(_f7,_f8);
}
return _f7;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(_f9,_fa){
if(!_f9){
return null;
}
if(_fa){
_fa=_fa.toLowerCase();
}
do{
_f9=_f9.previousSibling;
}while(_f9&&_f9.nodeType!=dojo.dom.ELEMENT_NODE);
if(_f9&&_fa&&_fa.toLowerCase()!=_f9.tagName.toLowerCase()){
return dojo.dom.prevElement(_f9,_fa);
}
return _f9;
};
dojo.dom.moveChildren=function(_fb,_fc,_fd){
var _fe=0;
if(_fd){
while(_fb.hasChildNodes()&&_fb.firstChild.nodeType==dojo.dom.TEXT_NODE){
_fb.removeChild(_fb.firstChild);
}
while(_fb.hasChildNodes()&&_fb.lastChild.nodeType==dojo.dom.TEXT_NODE){
_fb.removeChild(_fb.lastChild);
}
}
while(_fb.hasChildNodes()){
_fc.appendChild(_fb.firstChild);
_fe++;
}
return _fe;
};
dojo.dom.copyChildren=function(_ff,_100,trim){
var _102=_ff.cloneNode(true);
return this.moveChildren(_102,_100,trim);
};
dojo.dom.replaceChildren=function(node,_104){
var _105=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_105.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_104);
for(var i=0;i<_105.length;i++){
dojo.dom.destroyNode(_105[i]);
}
};
dojo.dom.removeChildren=function(node){
var _108=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _108;
};
dojo.dom.replaceNode=function(node,_10a){
return node.parentNode.replaceChild(_10a,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_10e,_10f){
var _110=[];
var _111=(_10e&&(_10e instanceof Function||typeof _10e=="function"));
while(node){
if(!_111||_10e(node)){
_110.push(node);
}
if(_10f&&_110.length>0){
return _110[0];
}
node=node.parentNode;
}
if(_10f){
return null;
}
return _110;
};
dojo.dom.getAncestorsByTag=function(node,tag,_114){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_114);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_119,_11a){
if(_11a&&node){
node=node.parentNode;
}
while(node){
if(node==_119){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _11d=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _11e=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_11e.length;i++){
try{
doc=new ActiveXObject(_11e[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_11d.implementation)&&(_11d.implementation.createDocument)){
doc=_11d.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_121){
if(!_121){
_121="text/xml";
}
if(!dj_undef("DOMParser")){
var _122=new DOMParser();
return _122.parseFromString(str,_121);
}else{
if(!dj_undef("ActiveXObject")){
var _123=dojo.dom.createDocument();
if(_123){
_123.async=false;
_123.loadXML(str);
return _123;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _124=dojo.doc();
if(_124.createElement){
var tmp=_124.createElement("xml");
tmp.innerHTML=str;
if(_124.implementation&&_124.implementation.createDocument){
var _126=_124.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_126.importNode(tmp.childNodes.item(i),true);
}
return _126;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_129){
if(_129.firstChild){
_129.insertBefore(node,_129.firstChild);
}else{
_129.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_12c){
if((_12c!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _12d=ref.parentNode;
_12d.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_130){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_130!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_130);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_134){
if((!node)||(!ref)||(!_134)){
return false;
}
switch(_134.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_136,_137){
var _138=_136.childNodes;
if(!_138.length||_138.length==_137){
_136.appendChild(node);
return true;
}
if(_137==0){
return dojo.dom.prependChild(node,_136);
}
return dojo.dom.insertAfter(node,_138[_137-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _13b=dojo.doc();
dojo.dom.replaceChildren(node,_13b.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _13c="";
if(node==null){
return _13c;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_13c+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_13c+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _13c;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_142,_143,_144){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_142,_143,_144);
}else{
var _145=elem.ownerDocument;
var _146=_145.createNode(2,_143,_142);
_146.nodeValue=_144;
elem.setAttributeNode(_146);
}
};
dojo.provide("dojo.xml.Parse");
dojo.xml.Parse=function(){
var isIE=((dojo.render.html.capable)&&(dojo.render.html.ie));
function getTagName(node){
try{
return node.tagName.toLowerCase();
}
catch(e){
return "";
}
}
function getDojoTagName(node){
var _14a=getTagName(node);
if(!_14a){
return "";
}
if((dojo.widget)&&(dojo.widget.tags[_14a])){
return _14a;
}
var p=_14a.indexOf(":");
if(p>=0){
return _14a;
}
if(_14a.substr(0,5)=="dojo:"){
return _14a;
}
if(dojo.render.html.capable&&dojo.render.html.ie&&node.scopeName!="HTML"){
return node.scopeName.toLowerCase()+":"+_14a;
}
if(_14a.substr(0,4)=="dojo"){
return "dojo:"+_14a.substring(4);
}
var djt=node.getAttribute("dojoType")||node.getAttribute("dojotype");
if(djt){
if(djt.indexOf(":")<0){
djt="dojo:"+djt;
}
return djt.toLowerCase();
}
djt=node.getAttributeNS&&node.getAttributeNS(dojo.dom.dojoml,"type");
if(djt){
return "dojo:"+djt.toLowerCase();
}
try{
djt=node.getAttribute("dojo:type");
}
catch(e){
}
if(djt){
return "dojo:"+djt.toLowerCase();
}
if((dj_global["djConfig"])&&(!djConfig["ignoreClassNames"])){
var _14d=node.className||node.getAttribute("class");
if((_14d)&&(_14d.indexOf)&&(_14d.indexOf("dojo-")!=-1)){
var _14e=_14d.split(" ");
for(var x=0,c=_14e.length;x<c;x++){
if(_14e[x].slice(0,5)=="dojo-"){
return "dojo:"+_14e[x].substr(5).toLowerCase();
}
}
}
}
return "";
}
this.parseElement=function(node,_152,_153,_154){
var _155=getTagName(node);
if(isIE&&_155.indexOf("/")==0){
return null;
}
try{
var attr=node.getAttribute("parseWidgets");
if(attr&&attr.toLowerCase()=="false"){
return {};
}
}
catch(e){
}
var _157=true;
if(_153){
var _158=getDojoTagName(node);
_155=_158||_155;
_157=Boolean(_158);
}
var _159={};
_159[_155]=[];
var pos=_155.indexOf(":");
if(pos>0){
var ns=_155.substring(0,pos);
_159["ns"]=ns;
if((dojo.ns)&&(!dojo.ns.allow(ns))){
_157=false;
}
}
if(_157){
var _15c=this.parseAttributes(node);
for(var attr in _15c){
if((!_159[_155][attr])||(typeof _159[_155][attr]!="array")){
_159[_155][attr]=[];
}
_159[_155][attr].push(_15c[attr]);
}
_159[_155].nodeRef=node;
_159.tagName=_155;
_159.index=_154||0;
}
var _15d=0;
for(var i=0;i<node.childNodes.length;i++){
var tcn=node.childNodes.item(i);
switch(tcn.nodeType){
case dojo.dom.ELEMENT_NODE:
var ctn=getDojoTagName(tcn)||getTagName(tcn);
if(!_159[ctn]){
_159[ctn]=[];
}
_159[ctn].push(this.parseElement(tcn,true,_153,_15d));
if((tcn.childNodes.length==1)&&(tcn.childNodes.item(0).nodeType==dojo.dom.TEXT_NODE)){
_159[ctn][_159[ctn].length-1].value=tcn.childNodes.item(0).nodeValue;
}
_15d++;
break;
case dojo.dom.TEXT_NODE:
if(node.childNodes.length==1){
_159[_155].push({value:node.childNodes.item(0).nodeValue});
}
break;
default:
break;
}
}
return _159;
};
this.parseAttributes=function(node){
var _162={};
var atts=node.attributes;
var _164,i=0;
while((_164=atts[i++])){
if(isIE){
if(!_164){
continue;
}
if((typeof _164=="object")&&(typeof _164.nodeValue=="undefined")||(_164.nodeValue==null)||(_164.nodeValue=="")){
continue;
}
}
var nn=_164.nodeName.split(":");
nn=(nn.length==2)?nn[1]:_164.nodeName;
_162[nn]={value:_164.nodeValue};
}
return _162;
};
};
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_167,_168){
if(!dojo.lang.isFunction(_168)){
dojo.raise("dojo.inherits: superclass argument ["+_168+"] must be a function (subclass: ["+_167+"']");
}
_167.prototype=new _168();
_167.prototype.constructor=_167;
_167.superclass=_168.prototype;
_167["super"]=_168.prototype;
};
dojo.lang._mixin=function(obj,_16a){
var tobj={};
for(var x in _16a){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_16a[x])){
obj[x]=_16a[x];
}
}
if(dojo.render.html.ie&&(typeof (_16a["toString"])=="function")&&(_16a["toString"]!=obj["toString"])&&(_16a["toString"]!=tobj["toString"])){
obj.toString=_16a.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_16e){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_171,_172){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_171.prototype,arguments[i]);
}
return _171;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_175,_176,_177,_178){
if(!dojo.lang.isArrayLike(_175)&&dojo.lang.isArrayLike(_176)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_175;
_175=_176;
_176=temp;
}
var _17a=dojo.lang.isString(_175);
if(_17a){
_175=_175.split("");
}
if(_178){
var step=-1;
var i=_175.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_175.length;
}
if(_177){
while(i!=end){
if(_175[i]===_176){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_175[i]==_176){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_17e,_17f,_180){
return dojo.lang.find(_17e,_17f,_180,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_181,_182){
return dojo.lang.find(_181,_182)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_18d,_18e){
var args=[];
for(var x=2;x<arguments.length;x++){
args.push(arguments[x]);
}
var fcn=(dojo.lang.isString(_18e)?_18d[_18e]:_18e)||function(){
};
return function(){
var ta=args.concat([]);
for(var x=0;x<arguments.length;x++){
ta.push(arguments[x]);
}
return fcn.apply(_18d,ta);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_194,_195,_196){
var nso=(_195||dojo.lang.anon);
if((_196)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_194){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_194;
return ret;
};
dojo.lang.forward=function(_19a){
return function(){
return this[_19a].apply(this,arguments);
};
};
dojo.lang.curry=function(_19b,func){
var _19d=[];
_19b=_19b||dj_global;
if(dojo.lang.isString(func)){
func=_19b[func];
}
for(var x=2;x<arguments.length;x++){
_19d.push(arguments[x]);
}
var _19f=(func["__preJoinArity"]||func.length)-_19d.length;
function gather(_1a0,_1a1,_1a2){
var _1a3=_1a2;
var _1a4=_1a1.slice(0);
for(var x=0;x<_1a0.length;x++){
_1a4.push(_1a0[x]);
}
_1a2=_1a2-_1a0.length;
if(_1a2<=0){
var res=func.apply(_19b,_1a4);
_1a2=_1a3;
return res;
}else{
return function(){
return gather(arguments,_1a4,_1a2);
};
}
}
return gather([],_19d,_19f);
};
dojo.lang.curryArguments=function(_1a7,func,args,_1aa){
var _1ab=[];
var x=_1aa||0;
for(x=_1aa;x<args.length;x++){
_1ab.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_1a7,func].concat(_1ab));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1b1,_1b2){
if(!farr.length){
if(typeof _1b2=="function"){
_1b2();
}
return;
}
if((typeof _1b1=="undefined")&&(typeof cb=="number")){
_1b1=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1b1){
_1b1=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1b1,_1b2);
},_1b1);
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _1b7=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_1b7++;
break;
}
}
return _1b7==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_1bb){
var _1bc=dojo.lang.isString(arr);
if(_1bc){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_1bb)){
_1bb=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_1bb){
var _1bd=obj;
obj=_1bb;
_1bb=_1bd;
}
}
if(Array.map){
var _1be=Array.map(arr,_1bb,obj);
}else{
var _1be=[];
for(var i=0;i<arr.length;++i){
_1be.push(_1bb.call(obj,arr[i]));
}
}
if(_1bc){
return _1be.join("");
}else{
return _1be;
}
},reduce:function(arr,_1c1,obj,_1c3){
var _1c4=_1c1;
if(arguments.length==2){
_1c3=_1c1;
_1c4=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_1c3=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_1c3;
_1c3=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_1c4=_1c3.call(ob,_1c4,val);
});
return _1c4;
},forEach:function(_1c8,_1c9,_1ca){
if(dojo.lang.isString(_1c8)){
_1c8=_1c8.split("");
}
if(Array.forEach){
Array.forEach(_1c8,_1c9,_1ca);
}else{
if(!_1ca){
_1ca=dj_global;
}
for(var i=0,l=_1c8.length;i<l;i++){
_1c9.call(_1ca,_1c8[i],i,_1c8);
}
}
},_everyOrSome:function(_1cd,arr,_1cf,_1d0){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_1cd?"every":"some"](arr,_1cf,_1d0);
}else{
if(!_1d0){
_1d0=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _1d3=_1cf.call(_1d0,arr[i],i,arr);
if(_1cd&&!_1d3){
return false;
}else{
if((!_1cd)&&(_1d3)){
return true;
}
}
}
return Boolean(_1cd);
}
},every:function(arr,_1d5,_1d6){
return this._everyOrSome(true,arr,_1d5,_1d6);
},some:function(arr,_1d8,_1d9){
return this._everyOrSome(false,arr,_1d8,_1d9);
},filter:function(arr,_1db,_1dc){
var _1dd=dojo.lang.isString(arr);
if(_1dd){
arr=arr.split("");
}
var _1de;
if(Array.filter){
_1de=Array.filter(arr,_1db,_1dc);
}else{
if(!_1dc){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_1dc=dj_global;
}
_1de=[];
for(var i=0;i<arr.length;i++){
if(_1db.call(_1dc,arr[i],i,arr)){
_1de.push(arr[i]);
}
}
}
if(_1dd){
return _1de.join("");
}else{
return _1de;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_1e3,_1e4){
var _1e5=[];
for(var i=_1e4||0;i<_1e3.length;i++){
_1e5.push(_1e3[i]);
}
return _1e5;
}});
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_1e8){
var _1e9=window,_1ea=2;
if(!dojo.lang.isFunction(func)){
_1e9=func;
func=_1e8;
_1e8=arguments[2];
_1ea++;
}
if(dojo.lang.isString(func)){
func=_1e9[func];
}
var args=[];
for(var i=_1ea;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_1e9,args);
},_1e8);
};
dojo.lang.clearTimeout=function(_1ed){
dojo.global().clearTimeout(_1ed);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_1f6,_1f7,_1f8){
with(dojo.parseObjPath(_1f6,_1f7,_1f8)){
return dojo.evalProp(prop,obj,_1f8);
}
};
dojo.lang.setObjPathValue=function(_1f9,_1fa,_1fb,_1fc){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_1fc=true;
}
with(dojo.parseObjPath(_1f9,_1fb,_1fc)){
if(obj&&(_1fc||(prop in obj))){
obj[prop]=_1fa;
}
}
};
dojo.provide("dojo.lang.declare");
dojo.lang.declare=function(_1fd,_1fe,init,_200){
if((dojo.lang.isFunction(_200))||((!_200)&&(!dojo.lang.isFunction(init)))){
var temp=_200;
_200=init;
init=temp;
}
var _202=[];
if(dojo.lang.isArray(_1fe)){
_202=_1fe;
_1fe=_202.shift();
}
if(!init){
init=dojo.evalObjPath(_1fd,false);
if((init)&&(!dojo.lang.isFunction(init))){
init=null;
}
}
var ctor=dojo.lang.declare._makeConstructor();
var scp=(_1fe?_1fe.prototype:null);
if(scp){
scp.prototyping=true;
ctor.prototype=new _1fe();
scp.prototyping=false;
}
ctor.superclass=scp;
ctor.mixins=_202;
for(var i=0,l=_202.length;i<l;i++){
dojo.lang.extend(ctor,_202[i].prototype);
}
ctor.prototype.initializer=null;
ctor.prototype.declaredClass=_1fd;
if(dojo.lang.isArray(_200)){
dojo.lang.extend.apply(dojo.lang,[ctor].concat(_200));
}else{
dojo.lang.extend(ctor,(_200)||{});
}
dojo.lang.extend(ctor,dojo.lang.declare._common);
ctor.prototype.constructor=ctor;
ctor.prototype.initializer=(ctor.prototype.initializer)||(init)||(function(){
});
var _207=dojo.parseObjPath(_1fd,null,true);
_207.obj[_207.prop]=ctor;
return ctor;
};
dojo.lang.declare._makeConstructor=function(){
return function(){
var self=this._getPropContext();
var s=self.constructor.superclass;
if((s)&&(s.constructor)){
if(s.constructor==arguments.callee){
this._inherited("constructor",arguments);
}else{
this._contextMethod(s,"constructor",arguments);
}
}
var ms=(self.constructor.mixins)||([]);
for(var i=0,m;(m=ms[i]);i++){
(((m.prototype)&&(m.prototype.initializer))||(m)).apply(this,arguments);
}
if((!this.prototyping)&&(self.initializer)){
self.initializer.apply(this,arguments);
}
};
};
dojo.lang.declare._common={_getPropContext:function(){
return (this.___proto||this);
},_contextMethod:function(_20d,_20e,args){
var _210,_211=this.___proto;
this.___proto=_20d;
try{
_210=_20d[_20e].apply(this,(args||[]));
}
catch(e){
throw e;
}
finally{
this.___proto=_211;
}
return _210;
},_inherited:function(prop,args){
var p=this._getPropContext();
do{
if((!p.constructor)||(!p.constructor.superclass)){
return;
}
p=p.constructor.superclass;
}while(!(prop in p));
return (dojo.lang.isFunction(p[prop])?this._contextMethod(p,prop,args):p[prop]);
},inherited:function(prop,args){
dojo.deprecated("'inherited' method is dangerous, do not up-call! 'inherited' is slated for removal in 0.5; name your super class (or use superclass property) instead.","0.5");
this._inherited(prop,args);
}};
dojo.declare=dojo.lang.declare;
dojo.provide("dojo.ns");
dojo.ns={namespaces:{},failed:{},loading:{},loaded:{},register:function(name,_218,_219,_21a){
if(!_21a||!this.namespaces[name]){
this.namespaces[name]=new dojo.ns.Ns(name,_218,_219);
}
},allow:function(name){
if(this.failed[name]){
return false;
}
if((djConfig.excludeNamespace)&&(dojo.lang.inArray(djConfig.excludeNamespace,name))){
return false;
}
return ((name==this.dojo)||(!djConfig.includeNamespace)||(dojo.lang.inArray(djConfig.includeNamespace,name)));
},get:function(name){
return this.namespaces[name];
},require:function(name){
var ns=this.namespaces[name];
if((ns)&&(this.loaded[name])){
return ns;
}
if(!this.allow(name)){
return false;
}
if(this.loading[name]){
dojo.debug("dojo.namespace.require: re-entrant request to load namespace \""+name+"\" must fail.");
return false;
}
var req=dojo.require;
this.loading[name]=true;
try{
if(name=="dojo"){
req("dojo.namespaces.dojo");
}else{
if(!dojo.hostenv.moduleHasPrefix(name)){
dojo.registerModulePath(name,"../"+name);
}
req([name,"manifest"].join("."),false,true);
}
if(!this.namespaces[name]){
this.failed[name]=true;
}
}
finally{
this.loading[name]=false;
}
return this.namespaces[name];
}};
dojo.ns.Ns=function(name,_221,_222){
this.name=name;
this.module=_221;
this.resolver=_222;
this._loaded=[];
this._failed=[];
};
dojo.ns.Ns.prototype.resolve=function(name,_224,_225){
if(!this.resolver||djConfig["skipAutoRequire"]){
return false;
}
var _226=this.resolver(name,_224);
if((_226)&&(!this._loaded[_226])&&(!this._failed[_226])){
var req=dojo.require;
req(_226,false,true);
if(dojo.hostenv.findModule(_226,false)){
this._loaded[_226]=true;
}else{
if(!_225){
dojo.raise("dojo.ns.Ns.resolve: module '"+_226+"' not found after loading via namespace '"+this.name+"'");
}
this._failed[_226]=true;
}
}
return Boolean(this._loaded[_226]);
};
dojo.registerNamespace=function(name,_229,_22a){
dojo.ns.register.apply(dojo.ns,arguments);
};
dojo.registerNamespaceResolver=function(name,_22c){
var n=dojo.ns.namespaces[name];
if(n){
n.resolver=_22c;
}
};
dojo.registerNamespaceManifest=function(_22e,path,name,_231,_232){
dojo.registerModulePath(name,path);
dojo.registerNamespace(name,_231,_232);
};
dojo.registerNamespace("dojo","dojo.widget");
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_234){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false,maxCalls:-1};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _237=dl.nameAnonFunc(args[2],ao.adviceObj,_234);
ao.adviceFunc=_237;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _237=dl.nameAnonFunc(args[0],ao.srcObj,_234);
ao.srcFunc=_237;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _237=dl.nameAnonFunc(args[1],dj_global,_234);
ao.srcFunc=_237;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _237=dl.nameAnonFunc(args[3],dj_global,_234);
ao.adviceObj=dj_global;
ao.adviceFunc=_237;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
ao.maxCalls=(!isNaN(parseInt(args[11])))?args[11]:-1;
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _237=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_234);
ao.aroundFunc=_237;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _239={};
for(var x in ao){
_239[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_239.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_239));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _241;
if((arguments.length==1)&&(typeof a1=="object")){
_241=a1;
}else{
_241={srcObj:a1,srcFunc:a2};
}
_241.adviceFunc=function(){
var _242=[];
for(var x=0;x<arguments.length;x++){
_242.push(arguments[x]);
}
dojo.debug("("+_241.srcObj+")."+_241.srcFunc,":",_242.join(", "));
};
this.kwConnect(_241);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this.connectRunOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.maxCalls=1;
return this.connect(ao);
};
this._kwConnectImpl=function(_24a,_24b){
var fn=(_24b)?"disconnect":"connect";
if(typeof _24a["srcFunc"]=="function"){
_24a.srcObj=_24a["srcObj"]||dj_global;
var _24d=dojo.lang.nameAnonFunc(_24a.srcFunc,_24a.srcObj,true);
_24a.srcFunc=_24d;
}
if(typeof _24a["adviceFunc"]=="function"){
_24a.adviceObj=_24a["adviceObj"]||dj_global;
var _24d=dojo.lang.nameAnonFunc(_24a.adviceFunc,_24a.adviceObj,true);
_24a.adviceFunc=_24d;
}
_24a.srcObj=_24a["srcObj"]||dj_global;
_24a.adviceObj=_24a["adviceObj"]||_24a["targetObj"]||dj_global;
_24a.adviceFunc=_24a["adviceFunc"]||_24a["targetFunc"];
return dojo.event[fn](_24a);
};
this.kwConnect=function(_24e){
return this._kwConnectImpl(_24e,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_251){
return this._kwConnectImpl(_251,true);
};
};
dojo.event.MethodInvocation=function(_252,obj,args){
this.jp_=_252;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_25a){
this.object=obj||dj_global;
this.methodname=_25a;
this.methodfunc=this.object[_25a];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_25c){
if(!obj){
obj=dj_global;
}
var ofn=obj[_25c];
if(!ofn){
ofn=obj[_25c]=function(){
};
if(!obj[_25c]){
dojo.raise("Cannot set do-nothing method on that object "+_25c);
}
}else{
if((typeof ofn!="function")&&(!dojo.lang.isFunction(ofn))&&(!dojo.lang.isAlien(ofn))){
return null;
}
}
var _25e=_25c+"$joinpoint";
var _25f=_25c+"$joinpoint$method";
var _260=obj[_25e];
if(!_260){
var _261=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_261=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_25e,_25f,_25c]);
}
}
var _262=ofn.length;
obj[_25f]=ofn;
_260=obj[_25e]=new dojo.event.MethodJoinPoint(obj,_25f);
if(!_261){
obj[_25c]=function(){
return _260.run.apply(_260,arguments);
};
}else{
obj[_25c]=function(){
var args=[];
if(!arguments.length){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _260.run.apply(_260,args);
};
}
obj[_25c].__preJoinArity=_262;
}
return _260;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{squelch:false,unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _268=[];
for(var x=0;x<args.length;x++){
_268[x]=args[x];
}
var _26a=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _26c=marr[0]||dj_global;
var _26d=marr[1];
if(!_26c[_26d]){
dojo.raise("function \""+_26d+"\" does not exist on \""+_26c+"\"");
}
var _26e=marr[2]||dj_global;
var _26f=marr[3];
var msg=marr[6];
var _271=marr[7];
if(_271>-1){
if(_271==0){
return;
}
marr[7]--;
}
var _272;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _26c[_26d].apply(_26c,to.args);
}};
to.args=_268;
var _274=parseInt(marr[4]);
var _275=((!isNaN(_274))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _278=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_26a(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_26f){
_26e[_26f].call(_26e,to);
}else{
if((_275)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_26c[_26d].call(_26c,to);
}else{
_26c[_26d].apply(_26c,args);
}
},_274);
}else{
if(msg){
_26c[_26d].call(_26c,to);
}else{
_26c[_26d].apply(_26c,args);
}
}
}
};
var _27b=function(){
if(this.squelch){
try{
return _26a.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _26a.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_27b);
}
var _27c;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_27c=mi.proceed();
}else{
if(this.methodfunc){
_27c=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_27b);
}
return (this.methodfunc)?_27c:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"],args["maxCalls"]);
},addAdvice:function(_281,_282,_283,_284,_285,_286,once,_288,rate,_28a,_28b){
var arr=this.getArr(_285);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_281,_282,_283,_284,_288,rate,_28a,_28b];
if(once){
if(this.hasAdvice(_281,_282,_285,arr)>=0){
return;
}
}
if(_286=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_28e,_28f,_290,arr){
if(!arr){
arr=this.getArr(_290);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _28f=="object")?(new String(_28f)).toString():_28f;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_28e)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_296,_297,_298,once){
var arr=this.getArr(_298);
var ind=this.hasAdvice(_296,_297,_298,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_296,_297,_298,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_29c){
if(!this.topics[_29c]){
this.topics[_29c]=new this.TopicImpl(_29c);
}
return this.topics[_29c];
};
this.registerPublisher=function(_29d,obj,_29f){
var _29d=this.getTopic(_29d);
_29d.registerPublisher(obj,_29f);
};
this.subscribe=function(_2a0,obj,_2a2){
var _2a0=this.getTopic(_2a0);
_2a0.subscribe(obj,_2a2);
};
this.unsubscribe=function(_2a3,obj,_2a5){
var _2a3=this.getTopic(_2a3);
_2a3.unsubscribe(obj,_2a5);
};
this.destroy=function(_2a6){
this.getTopic(_2a6).destroy();
delete this.topics[_2a6];
};
this.publishApply=function(_2a7,args){
var _2a7=this.getTopic(_2a7);
_2a7.sendMessage.apply(_2a7,args);
};
this.publish=function(_2a9,_2aa){
var _2a9=this.getTopic(_2a9);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_2a9.sendMessage.apply(_2a9,args);
};
};
dojo.event.topic.TopicImpl=function(_2ad){
this.topicName=_2ad;
this.subscribe=function(_2ae,_2af){
var tf=_2af||_2ae;
var to=(!_2af)?dj_global:_2ae;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_2b2,_2b3){
var tf=(!_2b3)?_2b2:_2b3;
var to=(!_2b3)?null:_2b2;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_2b6){
this._getJoinPoint().squelch=_2b6;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_2b7,_2b8){
dojo.event.connect(_2b7,_2b8,this,"sendMessage");
};
this.sendMessage=function(_2b9){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_2bc){
var na;
var tna;
if(_2bc){
tna=_2bc.all||_2bc.getElementsByTagName("*");
na=[_2bc];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _2c0={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _2c5=0;
this.normalizedEventName=function(_2c6){
switch(_2c6){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _2c6;
break;
default:
var lcn=_2c6.toLowerCase();
return (lcn.indexOf("on")==0)?lcn.substr(2):lcn;
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_2cb){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_2cb.length;x++){
node.__clobberAttrs__.push(_2cb[x]);
}
};
this.removeListener=function(node,_2ce,fp,_2d0){
if(!_2d0){
var _2d0=false;
}
_2ce=dojo.event.browser.normalizedEventName(_2ce);
if(_2ce=="key"){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_2d0);
}
_2ce="keypress";
}
if(node.removeEventListener){
node.removeEventListener(_2ce,fp,_2d0);
}
};
this.addListener=function(node,_2d2,fp,_2d4,_2d5){
if(!node){
return;
}
if(!_2d4){
var _2d4=false;
}
_2d2=dojo.event.browser.normalizedEventName(_2d2);
if(_2d2=="key"){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_2d4,_2d5);
}
_2d2="keypress";
}
if(!_2d5){
var _2d6=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_2d4){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_2d6=fp;
}
if(node.addEventListener){
node.addEventListener(_2d2,_2d6,_2d4);
return _2d6;
}else{
_2d2="on"+_2d2;
if(typeof node[_2d2]=="function"){
var _2d9=node[_2d2];
node[_2d2]=function(e){
_2d9(e);
return _2d6(e);
};
}else{
node[_2d2]=_2d6;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_2d2]);
}
return _2d6;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_2dc,_2dd){
if(typeof _2dc!="function"){
dojo.raise("listener not a function: "+_2dc);
}
dojo.event.browser.currentEvent.currentTarget=_2dd;
return _2dc.call(_2dd,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_2e0){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _2e2=evt.keyCode;
if(_2e2>=65&&_2e2<=90&&evt.shiftKey==false){
_2e2+=32;
}
if(_2e2>=1&&_2e2<=26&&evt.ctrlKey){
_2e2+=96;
}
evt.key=String.fromCharCode(_2e2);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _2e2=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_2e2+=32;
}
evt.key=String.fromCharCode(_2e2);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_2e0?_2e0:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _2e4=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_2e4.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_2e4.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.kwCompoundRequire({common:["dojo.event.common","dojo.event.topic"],browser:["dojo.event.browser"],dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");
dojo.provide("dojo.widget.Manager");
dojo.widget.manager=new function(){
this.widgets=[];
this.widgetIds=[];
this.topWidgets={};
var _2e6={};
var _2e7=[];
this.getUniqueId=function(_2e8){
var _2e9;
do{
_2e9=_2e8+"_"+(_2e6[_2e8]!=undefined?++_2e6[_2e8]:_2e6[_2e8]=0);
}while(this.getWidgetById(_2e9));
return _2e9;
};
this.add=function(_2ea){
this.widgets.push(_2ea);
if(!_2ea.extraArgs["id"]){
_2ea.extraArgs["id"]=_2ea.extraArgs["ID"];
}
if(_2ea.widgetId==""){
if(_2ea["id"]){
_2ea.widgetId=_2ea["id"];
}else{
if(_2ea.extraArgs["id"]){
_2ea.widgetId=_2ea.extraArgs["id"];
}else{
_2ea.widgetId=this.getUniqueId(_2ea.ns+"_"+_2ea.widgetType);
}
}
}
if(this.widgetIds[_2ea.widgetId]){
dojo.debug("widget ID collision on ID: "+_2ea.widgetId);
}
this.widgetIds[_2ea.widgetId]=_2ea;
};
this.destroyAll=function(){
for(var x=this.widgets.length-1;x>=0;x--){
try{
this.widgets[x].destroy(true);
delete this.widgets[x];
}
catch(e){
}
}
};
this.remove=function(_2ec){
if(dojo.lang.isNumber(_2ec)){
var tw=this.widgets[_2ec].widgetId;
delete this.topWidgets[tw];
delete this.widgetIds[tw];
this.widgets.splice(_2ec,1);
}else{
this.removeById(_2ec);
}
};
this.removeById=function(id){
if(!dojo.lang.isString(id)){
id=id["widgetId"];
if(!id){
dojo.debug("invalid widget or id passed to removeById");
return;
}
}
for(var i=0;i<this.widgets.length;i++){
if(this.widgets[i].widgetId==id){
this.remove(i);
break;
}
}
};
this.getWidgetById=function(id){
if(dojo.lang.isString(id)){
return this.widgetIds[id];
}
return id;
};
this.getWidgetsByType=function(type){
var lt=type.toLowerCase();
var _2f3=(type.indexOf(":")<0?function(x){
return x.widgetType.toLowerCase();
}:function(x){
return x.getNamespacedType();
});
var ret=[];
dojo.lang.forEach(this.widgets,function(x){
if(_2f3(x)==lt){
ret.push(x);
}
});
return ret;
};
this.getWidgetsByFilter=function(_2f8,_2f9){
var ret=[];
dojo.lang.every(this.widgets,function(x){
if(_2f8(x)){
ret.push(x);
if(_2f9){
return false;
}
}
return true;
});
return (_2f9?ret[0]:ret);
};
this.getAllWidgets=function(){
return this.widgets.concat();
};
this.getWidgetByNode=function(node){
var w=this.getAllWidgets();
node=dojo.byId(node);
for(var i=0;i<w.length;i++){
if(w[i].domNode==node){
return w[i];
}
}
return null;
};
this.byId=this.getWidgetById;
this.byType=this.getWidgetsByType;
this.byFilter=this.getWidgetsByFilter;
this.byNode=this.getWidgetByNode;
var _2ff={};
var _300=["dojo.widget"];
for(var i=0;i<_300.length;i++){
_300[_300[i]]=true;
}
this.registerWidgetPackage=function(_302){
if(!_300[_302]){
_300[_302]=true;
_300.push(_302);
}
};
this.getWidgetPackageList=function(){
return dojo.lang.map(_300,function(elt){
return (elt!==true?elt:undefined);
});
};
this.getImplementation=function(_304,_305,_306,ns){
var impl=this.getImplementationName(_304,ns);
if(impl){
var ret=_305?new impl(_305):new impl();
return ret;
}
};
function buildPrefixCache(){
for(var _30a in dojo.render){
if(dojo.render[_30a]["capable"]===true){
var _30b=dojo.render[_30a].prefixes;
for(var i=0;i<_30b.length;i++){
_2e7.push(_30b[i].toLowerCase());
}
}
}
}
var _30d=function(_30e,_30f){
if(!_30f){
return null;
}
for(var i=0,l=_2e7.length,_312;i<=l;i++){
_312=(i<l?_30f[_2e7[i]]:_30f);
if(!_312){
continue;
}
for(var name in _312){
if(name.toLowerCase()==_30e){
return _312[name];
}
}
}
return null;
};
var _314=function(_315,_316){
var _317=dojo.evalObjPath(_316,false);
return (_317?_30d(_315,_317):null);
};
this.getImplementationName=function(_318,ns){
var _31a=_318.toLowerCase();
ns=ns||"dojo";
var imps=_2ff[ns]||(_2ff[ns]={});
var impl=imps[_31a];
if(impl){
return impl;
}
if(!_2e7.length){
buildPrefixCache();
}
var _31d=dojo.ns.get(ns);
if(!_31d){
dojo.ns.register(ns,ns+".widget");
_31d=dojo.ns.get(ns);
}
if(_31d){
_31d.resolve(_318);
}
impl=_314(_31a,_31d.module);
if(impl){
return (imps[_31a]=impl);
}
_31d=dojo.ns.require(ns);
if((_31d)&&(_31d.resolver)){
_31d.resolve(_318);
impl=_314(_31a,_31d.module);
if(impl){
return (imps[_31a]=impl);
}
}
dojo.deprecated("dojo.widget.Manager.getImplementationName","Could not locate widget implementation for \""+_318+"\" in \""+_31d.module+"\" registered to namespace \""+_31d.name+"\". "+"Developers must specify correct namespaces for all non-Dojo widgets","0.5");
for(var i=0;i<_300.length;i++){
impl=_314(_31a,_300[i]);
if(impl){
return (imps[_31a]=impl);
}
}
throw new Error("Could not locate widget implementation for \""+_318+"\" in \""+_31d.module+"\" registered to namespace \""+_31d.name+"\"");
};
this.resizing=false;
this.onWindowResized=function(){
if(this.resizing){
return;
}
try{
this.resizing=true;
for(var id in this.topWidgets){
var _320=this.topWidgets[id];
if(_320.checkSize){
_320.checkSize();
}
}
}
catch(e){
}
finally{
this.resizing=false;
}
};
if(typeof window!="undefined"){
dojo.addOnLoad(this,"onWindowResized");
dojo.event.connect(window,"onresize",this,"onWindowResized");
}
};
(function(){
var dw=dojo.widget;
var dwm=dw.manager;
var h=dojo.lang.curry(dojo.lang,"hitch",dwm);
var g=function(_325,_326){
dw[(_326||_325)]=h(_325);
};
g("add","addWidget");
g("destroyAll","destroyAllWidgets");
g("remove","removeWidget");
g("removeById","removeWidgetById");
g("getWidgetById");
g("getWidgetById","byId");
g("getWidgetsByType");
g("getWidgetsByFilter");
g("getWidgetsByType","byType");
g("getWidgetsByFilter","byFilter");
g("getWidgetByNode","byNode");
dw.all=function(n){
var _328=dwm.getAllWidgets.apply(dwm,arguments);
if(arguments.length>0){
return _328[n];
}
return _328;
};
g("registerWidgetPackage");
g("getImplementation","getWidgetImplementation");
g("getImplementationName","getWidgetImplementationName");
dw.widgets=dwm.widgets;
dw.widgetIds=dwm.widgetIds;
dw.root=dwm.root;
})();
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_32a,uri){
var loc=dojo.hostenv.getModuleSymbols(_32a).join("/");
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
var _32d=loc.indexOf(":");
var _32e=loc.indexOf("/");
if(loc.charAt(0)!="/"&&(_32d==-1||_32d>_32e)){
loc=dojo.hostenv.getBaseScriptUri()+loc;
}
return new dojo.uri.Uri(loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _331=new dojo.uri.Uri(arguments[i].toString());
var _332=new dojo.uri.Uri(uri.toString());
if((_331.path=="")&&(_331.scheme==null)&&(_331.authority==null)&&(_331.query==null)){
if(_331.fragment!=null){
_332.fragment=_331.fragment;
}
_331=_332;
}else{
if(_331.scheme==null){
_331.scheme=_332.scheme;
if(_331.authority==null){
_331.authority=_332.authority;
if(_331.path.charAt(0)!="/"){
var path=_332.path.substring(0,_332.path.lastIndexOf("/")+1)+_331.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_331.path=segs.join("/");
}
}
}
}
uri="";
if(_331.scheme!=null){
uri+=_331.scheme+":";
}
if(_331.authority!=null){
uri+="//"+_331.authority;
}
uri+=_331.path;
if(_331.query!=null){
uri+="?"+_331.query;
}
if(_331.fragment!=null){
uri+="#"+_331.fragment;
}
}
this.uri=uri.toString();
var _336="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_336));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_336="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_336));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.kwCompoundRequire({common:[["dojo.uri.Uri",false,false]]});
dojo.provide("dojo.uri.*");
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _33a=dojo.global();
var _33b=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_33b.documentElement.clientWidth;
h=_33a.innerHeight;
}else{
if(!dojo.render.html.opera&&_33a.innerWidth){
w=_33a.innerWidth;
h=_33a.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_33b,"documentElement.clientWidth")){
var w2=_33b.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_33b.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _33f=dojo.global();
var _340=dojo.doc();
var top=_33f.pageYOffset||_340.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_33f.pageXOffset||_340.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _345=dojo.doc();
var _346=dojo.byId(node);
type=type.toLowerCase();
while((_346)&&(_346.nodeName.toLowerCase()!=type)){
if(_346==(_345["body"]||_345["documentElement"])){
return null;
}
_346=_346.parentNode;
}
return _346;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _34e={x:0,y:0};
if(e.pageX||e.pageY){
_34e.x=e.pageX;
_34e.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_34e.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_34e.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _34e;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _353=dojo.doc().createElement("script");
_353.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_353);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_356,_357,args,_359,_35a){
dojo.deprecated("dojo.html."+_356,"replaced by dojo.html."+_357+"("+(_359?"node, {"+_359+": "+_359+"}":"")+")"+(_35a?"."+_35a:""),"0.5");
var _35b=[];
if(_359){
var _35c={};
_35c[_359]=args[1];
_35b.push(args[0]);
_35b.push(_35c);
}else{
_35b=args;
}
var ret=dojo.html[_357].apply(dojo.html,args);
if(_35a){
return ret[_35a];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.a11y");
dojo.a11y={imgPath:dojo.uri.moduleUri("dojo.widget","templates/images"),doAccessibleCheck:true,accessible:null,checkAccessible:function(){
if(this.accessible===null){
this.accessible=false;
if(this.doAccessibleCheck==true){
this.accessible=this.testAccessible();
}
}
return this.accessible;
},testAccessible:function(){
this.accessible=false;
if(dojo.render.html.ie||dojo.render.html.mozilla){
var div=document.createElement("div");
div.style.backgroundImage="url(\""+this.imgPath+"/tab_close.gif\")";
dojo.body().appendChild(div);
var _35f=null;
if(window.getComputedStyle){
var _360=getComputedStyle(div,"");
_35f=_360.getPropertyValue("background-image");
}else{
_35f=div.currentStyle.backgroundImage;
}
var _361=false;
if(_35f!=null&&(_35f=="none"||_35f=="url(invalid-url:)")){
this.accessible=true;
}
dojo.body().removeChild(div);
}
return this.accessible;
},setCheckAccessible:function(_362){
this.doAccessibleCheck=_362;
},setAccessibleMode:function(){
if(this.accessible===null){
if(this.checkAccessible()){
dojo.render.html.prefixes.unshift("a11y");
}
}
return this.accessible;
}};
dojo.provide("dojo.widget.Widget");
dojo.declare("dojo.widget.Widget",null,function(){
this.children=[];
this.extraArgs={};
},{parent:null,isTopLevel:false,disabled:false,isContainer:false,widgetId:"",widgetType:"Widget",ns:"dojo",getNamespacedType:function(){
return (this.ns?this.ns+":"+this.widgetType:this.widgetType).toLowerCase();
},toString:function(){
return "[Widget "+this.getNamespacedType()+", "+(this.widgetId||"NO ID")+"]";
},repr:function(){
return this.toString();
},enable:function(){
this.disabled=false;
},disable:function(){
this.disabled=true;
},onResized:function(){
this.notifyChildrenOfResize();
},notifyChildrenOfResize:function(){
for(var i=0;i<this.children.length;i++){
var _364=this.children[i];
if(_364.onResized){
_364.onResized();
}
}
},create:function(args,_366,_367,ns){
if(ns){
this.ns=ns;
}
this.satisfyPropertySets(args,_366,_367);
this.mixInProperties(args,_366,_367);
this.postMixInProperties(args,_366,_367);
dojo.widget.manager.add(this);
this.buildRendering(args,_366,_367);
this.initialize(args,_366,_367);
this.postInitialize(args,_366,_367);
this.postCreate(args,_366,_367);
return this;
},destroy:function(_369){
if(this.parent){
this.parent.removeChild(this);
}
this.destroyChildren();
this.uninitialize();
this.destroyRendering(_369);
dojo.widget.manager.removeById(this.widgetId);
},destroyChildren:function(){
var _36a;
var i=0;
while(this.children.length>i){
_36a=this.children[i];
if(_36a instanceof dojo.widget.Widget){
this.removeChild(_36a);
_36a.destroy();
continue;
}
i++;
}
},getChildrenOfType:function(type,_36d){
var ret=[];
var _36f=dojo.lang.isFunction(type);
if(!_36f){
type=type.toLowerCase();
}
for(var x=0;x<this.children.length;x++){
if(_36f){
if(this.children[x] instanceof type){
ret.push(this.children[x]);
}
}else{
if(this.children[x].widgetType.toLowerCase()==type){
ret.push(this.children[x]);
}
}
if(_36d){
ret=ret.concat(this.children[x].getChildrenOfType(type,_36d));
}
}
return ret;
},getDescendants:function(){
var _371=[];
var _372=[this];
var elem;
while((elem=_372.pop())){
_371.push(elem);
if(elem.children){
dojo.lang.forEach(elem.children,function(elem){
_372.push(elem);
});
}
}
return _371;
},isFirstChild:function(){
return this===this.parent.children[0];
},isLastChild:function(){
return this===this.parent.children[this.parent.children.length-1];
},satisfyPropertySets:function(args){
return args;
},mixInProperties:function(args,frag){
if((args["fastMixIn"])||(frag["fastMixIn"])){
for(var x in args){
this[x]=args[x];
}
return;
}
var _379;
var _37a=dojo.widget.lcArgsCache[this.widgetType];
if(_37a==null){
_37a={};
for(var y in this){
_37a[((new String(y)).toLowerCase())]=y;
}
dojo.widget.lcArgsCache[this.widgetType]=_37a;
}
var _37c={};
for(var x in args){
if(!this[x]){
var y=_37a[(new String(x)).toLowerCase()];
if(y){
args[y]=args[x];
x=y;
}
}
if(_37c[x]){
continue;
}
_37c[x]=true;
if((typeof this[x])!=(typeof _379)){
if(typeof args[x]!="string"){
this[x]=args[x];
}else{
if(dojo.lang.isString(this[x])){
this[x]=args[x];
}else{
if(dojo.lang.isNumber(this[x])){
this[x]=new Number(args[x]);
}else{
if(dojo.lang.isBoolean(this[x])){
this[x]=(args[x].toLowerCase()=="false")?false:true;
}else{
if(dojo.lang.isFunction(this[x])){
if(args[x].search(/[^\w\.]+/i)==-1){
this[x]=dojo.evalObjPath(args[x],false);
}else{
var tn=dojo.lang.nameAnonFunc(new Function(args[x]),this);
dojo.event.kwConnect({srcObj:this,srcFunc:x,adviceObj:this,adviceFunc:tn});
}
}else{
if(dojo.lang.isArray(this[x])){
this[x]=args[x].split(";");
}else{
if(this[x] instanceof Date){
this[x]=new Date(Number(args[x]));
}else{
if(typeof this[x]=="object"){
if(this[x] instanceof dojo.uri.Uri){
this[x]=dojo.uri.dojoUri(args[x]);
}else{
var _37e=args[x].split(";");
for(var y=0;y<_37e.length;y++){
var si=_37e[y].indexOf(":");
if((si!=-1)&&(_37e[y].length>si)){
this[x][_37e[y].substr(0,si).replace(/^\s+|\s+$/g,"")]=_37e[y].substr(si+1);
}
}
}
}else{
this[x]=args[x];
}
}
}
}
}
}
}
}
}else{
this.extraArgs[x.toLowerCase()]=args[x];
}
}
},postMixInProperties:function(args,frag,_382){
},initialize:function(args,frag,_385){
return false;
},postInitialize:function(args,frag,_388){
return false;
},postCreate:function(args,frag,_38b){
return false;
},uninitialize:function(){
return false;
},buildRendering:function(args,frag,_38e){
dojo.unimplemented("dojo.widget.Widget.buildRendering, on "+this.toString()+", ");
return false;
},destroyRendering:function(){
dojo.unimplemented("dojo.widget.Widget.destroyRendering");
return false;
},addedTo:function(_38f){
},addChild:function(_390){
dojo.unimplemented("dojo.widget.Widget.addChild");
return false;
},removeChild:function(_391){
for(var x=0;x<this.children.length;x++){
if(this.children[x]===_391){
this.children.splice(x,1);
_391.parent=null;
break;
}
}
return _391;
},getPreviousSibling:function(){
var idx=this.getParentIndex();
if(idx<=0){
return null;
}
return this.parent.children[idx-1];
},getSiblings:function(){
return this.parent.children;
},getParentIndex:function(){
return dojo.lang.indexOf(this.parent.children,this,true);
},getNextSibling:function(){
var idx=this.getParentIndex();
if(idx==this.parent.children.length-1){
return null;
}
if(idx<0){
return null;
}
return this.parent.children[idx+1];
}});
dojo.widget.lcArgsCache={};
dojo.widget.tags={};
dojo.widget.tags.addParseTreeHandler=function(type){
dojo.deprecated("addParseTreeHandler",". ParseTreeHandlers are now reserved for components. Any unfiltered DojoML tag without a ParseTreeHandler is assumed to be a widget","0.5");
};
dojo.widget.tags["dojo:propertyset"]=function(_396,_397,_398){
var _399=_397.parseProperties(_396["dojo:propertyset"]);
};
dojo.widget.tags["dojo:connect"]=function(_39a,_39b,_39c){
var _39d=_39b.parseProperties(_39a["dojo:connect"]);
};
dojo.widget.buildWidgetFromParseTree=function(type,frag,_3a0,_3a1,_3a2,_3a3){
dojo.a11y.setAccessibleMode();
var _3a4=type.split(":");
_3a4=(_3a4.length==2)?_3a4[1]:type;
var _3a5=_3a3||_3a0.parseProperties(frag[frag["ns"]+":"+_3a4]);
var _3a6=dojo.widget.manager.getImplementation(_3a4,null,null,frag["ns"]);
if(!_3a6){
throw new Error("cannot find \""+type+"\" widget");
}else{
if(!_3a6.create){
throw new Error("\""+type+"\" widget object has no \"create\" method and does not appear to implement *Widget");
}
}
_3a5["dojoinsertionindex"]=_3a2;
var ret=_3a6.create(_3a5,frag,_3a1,frag["ns"]);
return ret;
};
dojo.widget.defineWidget=function(_3a8,_3a9,_3aa,init,_3ac){
if(dojo.lang.isString(arguments[3])){
dojo.widget._defineWidget(arguments[0],arguments[3],arguments[1],arguments[4],arguments[2]);
}else{
var args=[arguments[0]],p=3;
if(dojo.lang.isString(arguments[1])){
args.push(arguments[1],arguments[2]);
}else{
args.push("",arguments[1]);
p=2;
}
if(dojo.lang.isFunction(arguments[p])){
args.push(arguments[p],arguments[p+1]);
}else{
args.push(null,arguments[p]);
}
dojo.widget._defineWidget.apply(this,args);
}
};
dojo.widget.defineWidget.renderers="html|svg|vml";
dojo.widget._defineWidget=function(_3af,_3b0,_3b1,init,_3b3){
var _3b4=_3af.split(".");
var type=_3b4.pop();
var regx="\\.("+(_3b0?_3b0+"|":"")+dojo.widget.defineWidget.renderers+")\\.";
var r=_3af.search(new RegExp(regx));
_3b4=(r<0?_3b4.join("."):_3af.substr(0,r));
dojo.widget.manager.registerWidgetPackage(_3b4);
var pos=_3b4.indexOf(".");
var _3b9=(pos>-1)?_3b4.substring(0,pos):_3b4;
_3b3=(_3b3)||{};
_3b3.widgetType=type;
if((!init)&&(_3b3["classConstructor"])){
init=_3b3.classConstructor;
delete _3b3.classConstructor;
}
dojo.declare(_3af,_3b1,init,_3b3);
};
dojo.provide("dojo.widget.Parse");
dojo.widget.Parse=function(_3ba){
this.propertySetsList=[];
this.fragment=_3ba;
this.createComponents=function(frag,_3bc){
var _3bd=[];
var _3be=false;
try{
if(frag&&frag.tagName&&(frag!=frag.nodeRef)){
var _3bf=dojo.widget.tags;
var tna=String(frag.tagName).split(";");
for(var x=0;x<tna.length;x++){
var ltn=tna[x].replace(/^\s+|\s+$/g,"").toLowerCase();
frag.tagName=ltn;
var ret;
if(_3bf[ltn]){
_3be=true;
ret=_3bf[ltn](frag,this,_3bc,frag.index);
_3bd.push(ret);
}else{
if(ltn.indexOf(":")==-1){
ltn="dojo:"+ltn;
}
ret=dojo.widget.buildWidgetFromParseTree(ltn,frag,this,_3bc,frag.index);
if(ret){
_3be=true;
_3bd.push(ret);
}
}
}
}
}
catch(e){
dojo.debug("dojo.widget.Parse: error:",e);
}
if(!_3be){
_3bd=_3bd.concat(this.createSubComponents(frag,_3bc));
}
return _3bd;
};
this.createSubComponents=function(_3c4,_3c5){
var frag,_3c7=[];
for(var item in _3c4){
frag=_3c4[item];
if(frag&&typeof frag=="object"&&(frag!=_3c4.nodeRef)&&(frag!=_3c4.tagName)&&(!dojo.dom.isNode(frag))){
_3c7=_3c7.concat(this.createComponents(frag,_3c5));
}
}
return _3c7;
};
this.parsePropertySets=function(_3c9){
return [];
};
this.parseProperties=function(_3ca){
var _3cb={};
for(var item in _3ca){
if((_3ca[item]==_3ca.tagName)||(_3ca[item]==_3ca.nodeRef)){
}else{
var frag=_3ca[item];
if(frag.tagName&&dojo.widget.tags[frag.tagName.toLowerCase()]){
}else{
if(frag[0]&&frag[0].value!=""&&frag[0].value!=null){
try{
if(item.toLowerCase()=="dataprovider"){
var _3ce=this;
this.getDataProvider(_3ce,frag[0].value);
_3cb.dataProvider=this.dataProvider;
}
_3cb[item]=frag[0].value;
var _3cf=this.parseProperties(frag);
for(var _3d0 in _3cf){
_3cb[_3d0]=_3cf[_3d0];
}
}
catch(e){
dojo.debug(e);
}
}
}
switch(item.toLowerCase()){
case "checked":
case "disabled":
if(typeof _3cb[item]!="boolean"){
_3cb[item]=true;
}
break;
}
}
}
return _3cb;
};
this.getDataProvider=function(_3d1,_3d2){
dojo.io.bind({url:_3d2,load:function(type,_3d4){
if(type=="load"){
_3d1.dataProvider=_3d4;
}
},mimetype:"text/javascript",sync:true});
};
this.getPropertySetById=function(_3d5){
for(var x=0;x<this.propertySetsList.length;x++){
if(_3d5==this.propertySetsList[x]["id"][0].value){
return this.propertySetsList[x];
}
}
return "";
};
this.getPropertySetsByType=function(_3d7){
var _3d8=[];
for(var x=0;x<this.propertySetsList.length;x++){
var cpl=this.propertySetsList[x];
var cpcc=cpl.componentClass||cpl.componentType||null;
var _3dc=this.propertySetsList[x]["id"][0].value;
if(cpcc&&(_3dc==cpcc[0].value)){
_3d8.push(cpl);
}
}
return _3d8;
};
this.getPropertySets=function(_3dd){
var ppl="dojo:propertyproviderlist";
var _3df=[];
var _3e0=_3dd.tagName;
if(_3dd[ppl]){
var _3e1=_3dd[ppl].value.split(" ");
for(var _3e2 in _3e1){
if((_3e2.indexOf("..")==-1)&&(_3e2.indexOf("://")==-1)){
var _3e3=this.getPropertySetById(_3e2);
if(_3e3!=""){
_3df.push(_3e3);
}
}else{
}
}
}
return this.getPropertySetsByType(_3e0).concat(_3df);
};
this.createComponentFromScript=function(_3e4,_3e5,_3e6,ns){
_3e6.fastMixIn=true;
var ltn=(ns||"dojo")+":"+_3e5.toLowerCase();
if(dojo.widget.tags[ltn]){
return [dojo.widget.tags[ltn](_3e6,this,null,null,_3e6)];
}
return [dojo.widget.buildWidgetFromParseTree(ltn,_3e6,this,null,null,_3e6)];
};
};
dojo.widget._parser_collection={"dojo":new dojo.widget.Parse()};
dojo.widget.getParser=function(name){
if(!name){
name="dojo";
}
if(!this._parser_collection[name]){
this._parser_collection[name]=new dojo.widget.Parse();
}
return this._parser_collection[name];
};
dojo.widget.createWidget=function(name,_3eb,_3ec,_3ed){
var _3ee=false;
var _3ef=(typeof name=="string");
if(_3ef){
var pos=name.indexOf(":");
var ns=(pos>-1)?name.substring(0,pos):"dojo";
if(pos>-1){
name=name.substring(pos+1);
}
var _3f2=name.toLowerCase();
var _3f3=ns+":"+_3f2;
_3ee=(dojo.byId(name)&&!dojo.widget.tags[_3f3]);
}
if((arguments.length==1)&&(_3ee||!_3ef)){
var xp=new dojo.xml.Parse();
var tn=_3ee?dojo.byId(name):name;
return dojo.widget.getParser().createComponents(xp.parseElement(tn,null,true))[0];
}
function fromScript(_3f6,name,_3f8,ns){
_3f8[_3f3]={dojotype:[{value:_3f2}],nodeRef:_3f6,fastMixIn:true};
_3f8.ns=ns;
return dojo.widget.getParser().createComponentFromScript(_3f6,name,_3f8,ns);
}
_3eb=_3eb||{};
var _3fa=false;
var tn=null;
var h=dojo.render.html.capable;
if(h){
tn=document.createElement("span");
}
if(!_3ec){
_3fa=true;
_3ec=tn;
if(h){
dojo.body().appendChild(_3ec);
}
}else{
if(_3ed){
dojo.dom.insertAtPosition(tn,_3ec,_3ed);
}else{
tn=_3ec;
}
}
var _3fc=fromScript(tn,name.toLowerCase(),_3eb,ns);
if((!_3fc)||(!_3fc[0])||(typeof _3fc[0].widgetType=="undefined")){
throw new Error("createWidget: Creation of \""+name+"\" widget failed.");
}
try{
if(_3fa&&_3fc[0].domNode.parentNode){
_3fc[0].domNode.parentNode.removeChild(_3fc[0].domNode);
}
}
catch(e){
dojo.debug(e);
}
return _3fc[0];
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_402){
return (new RegExp("(^|\\s+)"+_402+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_404){
_404+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_404);
};
dojo.html.addClass=function(node,_406){
if(dojo.html.hasClass(node,_406)){
return false;
}
_406=(dojo.html.getClass(node)+" "+_406).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_406);
};
dojo.html.setClass=function(node,_408){
node=dojo.byId(node);
var cs=new String(_408);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_408);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_40b,_40c){
try{
if(!_40c){
var _40d=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_40b+"(\\s+|$)"),"$1$2");
}else{
var _40d=dojo.html.getClass(node).replace(_40b,"");
}
dojo.html.setClass(node,_40d);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_40f,_410){
dojo.html.removeClass(node,_410);
dojo.html.addClass(node,_40f);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_411,_412,_413,_414,_415){
_415=false;
var _416=dojo.doc();
_412=dojo.byId(_412)||_416;
var _417=_411.split(/\s+/g);
var _418=[];
if(_414!=1&&_414!=2){
_414=0;
}
var _419=new RegExp("(\\s|^)(("+_417.join(")|(")+"))(\\s|$)");
var _41a=_417.join(" ").length;
var _41b=[];
if(!_415&&_416.evaluate){
var _41c=".//"+(_413||"*")+"[contains(";
if(_414!=dojo.html.classMatchType.ContainsAny){
_41c+="concat(' ',@class,' '), ' "+_417.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_414==2){
_41c+=" and string-length(@class)="+_41a+"]";
}else{
_41c+="]";
}
}else{
_41c+="concat(' ',@class,' '), ' "+_417.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _41d=_416.evaluate(_41c,_412,null,XPathResult.ANY_TYPE,null);
var _41e=_41d.iterateNext();
while(_41e){
try{
_41b.push(_41e);
_41e=_41d.iterateNext();
}
catch(e){
break;
}
}
return _41b;
}else{
if(!_413){
_413="*";
}
_41b=_412.getElementsByTagName(_413);
var node,i=0;
outer:
while(node=_41b[i++]){
var _421=dojo.html.getClasses(node);
if(_421.length==0){
continue outer;
}
var _422=0;
for(var j=0;j<_421.length;j++){
if(_419.test(_421[j])){
if(_414==dojo.html.classMatchType.ContainsAny){
_418.push(node);
continue outer;
}else{
_422++;
}
}else{
if(_414==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_422==_417.length){
if((_414==dojo.html.classMatchType.IsOnly)&&(_422==_421.length)){
_418.push(node);
}else{
if(_414==dojo.html.classMatchType.ContainsAll){
_418.push(node);
}
}
}
}
return _418;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_424){
var arr=_424.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_428){
return _428.replace(/([A-Z])/g,"-$1").toLowerCase();
};
if(dojo.render.html.ie){
dojo.html.getComputedStyle=function(node,_42a,_42b){
node=dojo.byId(node);
if(!node||!node.currentStyle){
return _42b;
}
return node.currentStyle[dojo.html.toCamelCase(_42a)];
};
dojo.html.getComputedStyles=function(node){
return node.currentStyle;
};
}else{
dojo.html.getComputedStyle=function(node,_42e,_42f){
node=dojo.byId(node);
if(!node||!node.style){
return _42f;
}
var s=document.defaultView.getComputedStyle(node,null);
return (s&&s[dojo.html.toCamelCase(_42e)])||"";
};
dojo.html.getComputedStyles=function(node){
return document.defaultView.getComputedStyle(node,null);
};
}
dojo.html.getStyleProperty=function(node,_433){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_433)]:undefined);
};
dojo.html.getStyle=function(node,_435){
var _436=dojo.html.getStyleProperty(node,_435);
return (_436?_436:dojo.html.getComputedStyle(node,_435));
};
dojo.html.setStyle=function(node,_438,_439){
node=dojo.byId(node);
if(node&&node.style){
var _43a=dojo.html.toCamelCase(_438);
node.style[_43a]=_439;
}
};
dojo.html.setStyleText=function(_43b,text){
try{
_43b.style.cssText=text;
}
catch(e){
_43b.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_43d,_43e){
if(!_43e.style.cssText){
_43d.setAttribute("style",_43e.getAttribute("style"));
}else{
_43d.style.cssText=_43e.style.cssText;
}
dojo.html.addClass(_43d,dojo.html.getClass(_43e));
};
dojo.html.getUnitValue=function(node,_440,_441){
var s=dojo.html.getComputedStyle(node,_440);
if((!s)||((s=="auto")&&(_441))){
return {value:0,units:"px"};
}
var _443=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_443){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_443[1]),units:_443[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
if(dojo.render.html.ie){
dojo.html.toPixelValue=function(_444,_445){
if(!_445){
return 0;
}
if(_445.slice(-2)=="px"){
return parseFloat(_445);
}
var _446=0;
with(_444){
var _447=style.left;
var _448=runtimeStyle.left;
runtimeStyle.left=currentStyle.left;
try{
style.left=_445||0;
_446=style.pixelLeft;
style.left=_447;
runtimeStyle.left=_448;
}
catch(e){
}
}
return _446;
};
}else{
dojo.html.toPixelValue=function(_449,_44a){
return (_44a&&(_44a.slice(-2)=="px")?parseFloat(_44a):0);
};
}
dojo.html.getPixelValue=function(node,_44c,_44d){
return dojo.html.toPixelValue(node,dojo.html.getComputedStyle(node,_44c));
};
dojo.html.setPositivePixelValue=function(node,_44f,_450){
if(isNaN(_450)){
return false;
}
node.style[_44f]=Math.max(0,_450)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_451,_452,_453){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_453=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_453=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_451+" { "+_452+" }";
return dojo.html.styleSheet.insertRule(rule,_453);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_451,_452,_453);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_455){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_455){
_455=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_455);
}
}else{
if(document.styleSheets[0]){
if(!_455){
_455=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_455);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_458,_459){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _45a=dojo.hostenv.getText(URI,false,_459);
if(_45a===null){
return;
}
_45a=dojo.html.fixPathsInCssText(_45a,URI);
if(_458){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_45a)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _45f=doc.getElementsByTagName("style");
for(var i=0;i<_45f.length;i++){
if(_45f[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _460=dojo.html.insertCssText(_45a,doc);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_45a,"nodeRef":_460});
if(_460&&djConfig.isDebug){
_460.setAttribute("dbgHref",URI);
}
return _460;
};
dojo.html.insertCssText=function(_461,doc,URI){
if(!_461){
return;
}
if(!doc){
doc=document;
}
if(URI){
_461=dojo.html.fixPathsInCssText(_461,URI);
}
var _464=doc.createElement("style");
_464.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_464);
}
if(_464.styleSheet){
var _466=function(){
try{
_464.styleSheet.cssText=_461;
}
catch(e){
dojo.debug(e);
}
};
if(_464.styleSheet.disabled){
setTimeout(_466,10);
}else{
_466();
}
}else{
var _467=doc.createTextNode(_461);
_464.appendChild(_467);
}
return _464;
};
dojo.html.fixPathsInCssText=function(_468,URI){
if(!_468||!URI){
return;
}
var _46a,str="",url="",_46d="[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
var _46e=new RegExp("url\\(\\s*("+_46d+")\\s*\\)");
var _46f=/(file|https?|ftps?):\/\//;
regexTrim=new RegExp("^[\\s]*(['\"]?)("+_46d+")\\1[\\s]*?$");
if(dojo.render.html.ie55||dojo.render.html.ie60){
var _470=new RegExp("AlphaImageLoader\\((.*)src=['\"]("+_46d+")['\"]");
while(_46a=_470.exec(_468)){
url=_46a[2].replace(regexTrim,"$2");
if(!_46f.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_468.substring(0,_46a.index)+"AlphaImageLoader("+_46a[1]+"src='"+url+"'";
_468=_468.substr(_46a.index+_46a[0].length);
}
_468=str+_468;
str="";
}
while(_46a=_46e.exec(_468)){
url=_46a[1].replace(regexTrim,"$2");
if(!_46f.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_468.substring(0,_46a.index)+"url("+url+")";
_468=_468.substr(_46a.index+_46a[0].length);
}
return str+_468;
};
dojo.html.setActiveStyleSheet=function(_471){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_471){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("rel").indexOf("alt")==-1&&a.getAttribute("title")){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _47d={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _47d){
if(_47d[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.provide("dojo.widget.DomWidget");
dojo.widget._cssFiles={};
dojo.widget._cssStrings={};
dojo.widget._templateCache={};
dojo.widget.defaultStrings={dojoRoot:dojo.hostenv.getBaseScriptUri(),dojoWidgetModuleUri:dojo.uri.moduleUri("dojo.widget"),baseScriptUri:dojo.hostenv.getBaseScriptUri()};
dojo.widget.fillFromTemplateCache=function(obj,_480,_481,_482){
var _483=_480||obj.templatePath;
var _484=dojo.widget._templateCache;
if(!_483&&!obj["widgetType"]){
do{
var _485="__dummyTemplate__"+dojo.widget._templateCache.dummyCount++;
}while(_484[_485]);
obj.widgetType=_485;
}
var wt=_483?_483.toString():obj.widgetType;
var ts=_484[wt];
if(!ts){
_484[wt]={"string":null,"node":null};
if(_482){
ts={};
}else{
ts=_484[wt];
}
}
if((!obj.templateString)&&(!_482)){
obj.templateString=_481||ts["string"];
}
if(obj.templateString){
obj.templateString=this._sanitizeTemplateString(obj.templateString);
}
if((!obj.templateNode)&&(!_482)){
obj.templateNode=ts["node"];
}
if((!obj.templateNode)&&(!obj.templateString)&&(_483)){
var _488=this._sanitizeTemplateString(dojo.hostenv.getText(_483));
obj.templateString=_488;
if(!_482){
_484[wt]["string"]=_488;
}
}
if((!ts["string"])&&(!_482)){
ts.string=obj.templateString;
}
};
dojo.widget._sanitizeTemplateString=function(_489){
if(_489){
_489=_489.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");
var _48a=_489.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_48a){
_489=_48a[1];
}
}else{
_489="";
}
return _489;
};
dojo.widget._templateCache.dummyCount=0;
dojo.widget.attachProperties=["dojoAttachPoint","id"];
dojo.widget.eventAttachProperty="dojoAttachEvent";
dojo.widget.onBuildProperty="dojoOnBuild";
dojo.widget.waiNames=["waiRole","waiState"];
dojo.widget.wai={waiRole:{name:"waiRole","namespace":"http://www.w3.org/TR/xhtml2",alias:"x2",prefix:"wairole:"},waiState:{name:"waiState","namespace":"http://www.w3.org/2005/07/aaa",alias:"aaa",prefix:""},setAttr:function(node,ns,attr,_48e){
if(dojo.render.html.ie){
node.setAttribute(this[ns].alias+":"+attr,this[ns].prefix+_48e);
}else{
node.setAttributeNS(this[ns]["namespace"],attr,this[ns].prefix+_48e);
}
},getAttr:function(node,ns,attr){
if(dojo.render.html.ie){
return node.getAttribute(this[ns].alias+":"+attr);
}else{
return node.getAttributeNS(this[ns]["namespace"],attr);
}
},removeAttr:function(node,ns,attr){
var _495=true;
if(dojo.render.html.ie){
_495=node.removeAttribute(this[ns].alias+":"+attr);
}else{
node.removeAttributeNS(this[ns]["namespace"],attr);
}
return _495;
}};
dojo.widget.attachTemplateNodes=function(_496,_497,_498){
var _499=dojo.dom.ELEMENT_NODE;
function trim(str){
return str.replace(/^\s+|\s+$/g,"");
}
if(!_496){
_496=_497.domNode;
}
if(_496.nodeType!=_499){
return;
}
var _49b=_496.all||_496.getElementsByTagName("*");
var _49c=_497;
for(var x=-1;x<_49b.length;x++){
var _49e=(x==-1)?_496:_49b[x];
var _49f=[];
if(!_497.widgetsInTemplate||!_49e.getAttribute("dojoType")){
for(var y=0;y<this.attachProperties.length;y++){
var _4a1=_49e.getAttribute(this.attachProperties[y]);
if(_4a1){
_49f=_4a1.split(";");
for(var z=0;z<_49f.length;z++){
if(dojo.lang.isArray(_497[_49f[z]])){
_497[_49f[z]].push(_49e);
}else{
_497[_49f[z]]=_49e;
}
}
break;
}
}
var _4a3=_49e.getAttribute(this.eventAttachProperty);
if(_4a3){
var evts=_4a3.split(";");
for(var y=0;y<evts.length;y++){
if((!evts[y])||(!evts[y].length)){
continue;
}
var _4a5=null;
var tevt=trim(evts[y]);
if(evts[y].indexOf(":")>=0){
var _4a7=tevt.split(":");
tevt=trim(_4a7[0]);
_4a5=trim(_4a7[1]);
}
if(!_4a5){
_4a5=tevt;
}
var tf=function(){
var ntf=new String(_4a5);
return function(evt){
if(_49c[ntf]){
_49c[ntf](dojo.event.browser.fixEvent(evt,this));
}
};
}();
dojo.event.browser.addListener(_49e,tevt,tf,false,true);
}
}
for(var y=0;y<_498.length;y++){
var _4ab=_49e.getAttribute(_498[y]);
if((_4ab)&&(_4ab.length)){
var _4a5=null;
var _4ac=_498[y].substr(4);
_4a5=trim(_4ab);
var _4ad=[_4a5];
if(_4a5.indexOf(";")>=0){
_4ad=dojo.lang.map(_4a5.split(";"),trim);
}
for(var z=0;z<_4ad.length;z++){
if(!_4ad[z].length){
continue;
}
var tf=function(){
var ntf=new String(_4ad[z]);
return function(evt){
if(_49c[ntf]){
_49c[ntf](dojo.event.browser.fixEvent(evt,this));
}
};
}();
dojo.event.browser.addListener(_49e,_4ac,tf,false,true);
}
}
}
}
var _4b0=_49e.getAttribute(this.templateProperty);
if(_4b0){
_497[_4b0]=_49e;
}
dojo.lang.forEach(dojo.widget.waiNames,function(name){
var wai=dojo.widget.wai[name];
var val=_49e.getAttribute(wai.name);
if(val){
if(val.indexOf("-")==-1){
dojo.widget.wai.setAttr(_49e,wai.name,"role",val);
}else{
var _4b4=val.split("-");
dojo.widget.wai.setAttr(_49e,wai.name,_4b4[0],_4b4[1]);
}
}
},this);
var _4b5=_49e.getAttribute(this.onBuildProperty);
if(_4b5){
eval("var node = baseNode; var widget = targetObj; "+_4b5);
}
}
};
dojo.widget.getDojoEventsFromStr=function(str){
var re=/(dojoOn([a-z]+)(\s?))=/gi;
var evts=str?str.match(re)||[]:[];
var ret=[];
var lem={};
for(var x=0;x<evts.length;x++){
if(evts[x].length<1){
continue;
}
var cm=evts[x].replace(/\s/,"");
cm=(cm.slice(0,cm.length-1));
if(!lem[cm]){
lem[cm]=true;
ret.push(cm);
}
}
return ret;
};
dojo.declare("dojo.widget.DomWidget",dojo.widget.Widget,function(){
if((arguments.length>0)&&(typeof arguments[0]=="object")){
this.create(arguments[0]);
}
},{templateNode:null,templateString:null,templateCssString:null,preventClobber:false,domNode:null,containerNode:null,widgetsInTemplate:false,addChild:function(_4bd,_4be,pos,ref,_4c1){
if(!this.isContainer){
dojo.debug("dojo.widget.DomWidget.addChild() attempted on non-container widget");
return null;
}else{
if(_4c1==undefined){
_4c1=this.children.length;
}
this.addWidgetAsDirectChild(_4bd,_4be,pos,ref,_4c1);
this.registerChild(_4bd,_4c1);
}
return _4bd;
},addWidgetAsDirectChild:function(_4c2,_4c3,pos,ref,_4c6){
if((!this.containerNode)&&(!_4c3)){
this.containerNode=this.domNode;
}
var cn=(_4c3)?_4c3:this.containerNode;
if(!pos){
pos="after";
}
if(!ref){
if(!cn){
cn=dojo.body();
}
ref=cn.lastChild;
}
if(!_4c6){
_4c6=0;
}
_4c2.domNode.setAttribute("dojoinsertionindex",_4c6);
if(!ref){
cn.appendChild(_4c2.domNode);
}else{
if(pos=="insertAtIndex"){
dojo.dom.insertAtIndex(_4c2.domNode,ref.parentNode,_4c6);
}else{
if((pos=="after")&&(ref===cn.lastChild)){
cn.appendChild(_4c2.domNode);
}else{
dojo.dom.insertAtPosition(_4c2.domNode,cn,pos);
}
}
}
},registerChild:function(_4c8,_4c9){
_4c8.dojoInsertionIndex=_4c9;
var idx=-1;
for(var i=0;i<this.children.length;i++){
if(this.children[i].dojoInsertionIndex<=_4c9){
idx=i;
}
}
this.children.splice(idx+1,0,_4c8);
_4c8.parent=this;
_4c8.addedTo(this,idx+1);
delete dojo.widget.manager.topWidgets[_4c8.widgetId];
},removeChild:function(_4cc){
dojo.dom.removeNode(_4cc.domNode);
return dojo.widget.DomWidget.superclass.removeChild.call(this,_4cc);
},getFragNodeRef:function(frag){
if(!frag){
return null;
}
if(!frag[this.getNamespacedType()]){
dojo.raise("Error: no frag for widget type "+this.getNamespacedType()+", id "+this.widgetId+" (maybe a widget has set it's type incorrectly)");
}
return frag[this.getNamespacedType()]["nodeRef"];
},postInitialize:function(args,frag,_4d0){
var _4d1=this.getFragNodeRef(frag);
if(_4d0&&(_4d0.snarfChildDomOutput||!_4d1)){
_4d0.addWidgetAsDirectChild(this,"","insertAtIndex","",args["dojoinsertionindex"],_4d1);
}else{
if(_4d1){
if(this.domNode&&(this.domNode!==_4d1)){
this._sourceNodeRef=dojo.dom.replaceNode(_4d1,this.domNode);
}
}
}
if(_4d0){
_4d0.registerChild(this,args.dojoinsertionindex);
}else{
dojo.widget.manager.topWidgets[this.widgetId]=this;
}
if(this.widgetsInTemplate){
var _4d2=new dojo.xml.Parse();
var _4d3;
var _4d4=this.domNode.getElementsByTagName("*");
for(var i=0;i<_4d4.length;i++){
if(_4d4[i].getAttribute("dojoAttachPoint")=="subContainerWidget"){
_4d3=_4d4[i];
}
if(_4d4[i].getAttribute("dojoType")){
_4d4[i].setAttribute("isSubWidget",true);
}
}
if(this.isContainer&&!this.containerNode){
if(_4d3){
var src=this.getFragNodeRef(frag);
if(src){
dojo.dom.moveChildren(src,_4d3);
frag["dojoDontFollow"]=true;
}
}else{
dojo.debug("No subContainerWidget node can be found in template file for widget "+this);
}
}
var _4d7=_4d2.parseElement(this.domNode,null,true);
dojo.widget.getParser().createSubComponents(_4d7,this);
var _4d8=[];
var _4d9=[this];
var w;
while((w=_4d9.pop())){
for(var i=0;i<w.children.length;i++){
var _4db=w.children[i];
if(_4db._processedSubWidgets||!_4db.extraArgs["issubwidget"]){
continue;
}
_4d8.push(_4db);
if(_4db.isContainer){
_4d9.push(_4db);
}
}
}
for(var i=0;i<_4d8.length;i++){
var _4dc=_4d8[i];
if(_4dc._processedSubWidgets){
dojo.debug("This should not happen: widget._processedSubWidgets is already true!");
return;
}
_4dc._processedSubWidgets=true;
if(_4dc.extraArgs["dojoattachevent"]){
var evts=_4dc.extraArgs["dojoattachevent"].split(";");
for(var j=0;j<evts.length;j++){
var _4df=null;
var tevt=dojo.string.trim(evts[j]);
if(tevt.indexOf(":")>=0){
var _4e1=tevt.split(":");
tevt=dojo.string.trim(_4e1[0]);
_4df=dojo.string.trim(_4e1[1]);
}
if(!_4df){
_4df=tevt;
}
if(dojo.lang.isFunction(_4dc[tevt])){
dojo.event.kwConnect({srcObj:_4dc,srcFunc:tevt,targetObj:this,targetFunc:_4df});
}else{
alert(tevt+" is not a function in widget "+_4dc);
}
}
}
if(_4dc.extraArgs["dojoattachpoint"]){
this[_4dc.extraArgs["dojoattachpoint"]]=_4dc;
}
}
}
if(this.isContainer&&!frag["dojoDontFollow"]){
dojo.widget.getParser().createSubComponents(frag,this);
}
},buildRendering:function(args,frag){
var ts=dojo.widget._templateCache[this.widgetType];
if(args["templatecsspath"]){
args["templateCssPath"]=args["templatecsspath"];
}
var _4e5=args["templateCssPath"]||this.templateCssPath;
if(_4e5&&!dojo.widget._cssFiles[_4e5.toString()]){
if((!this.templateCssString)&&(_4e5)){
this.templateCssString=dojo.hostenv.getText(_4e5);
this.templateCssPath=null;
}
dojo.widget._cssFiles[_4e5.toString()]=true;
}
if((this["templateCssString"])&&(!dojo.widget._cssStrings[this.templateCssString])){
dojo.html.insertCssText(this.templateCssString,null,_4e5);
dojo.widget._cssStrings[this.templateCssString]=true;
}
if((!this.preventClobber)&&((this.templatePath)||(this.templateNode)||((this["templateString"])&&(this.templateString.length))||((typeof ts!="undefined")&&((ts["string"])||(ts["node"]))))){
this.buildFromTemplate(args,frag);
}else{
this.domNode=this.getFragNodeRef(frag);
}
this.fillInTemplate(args,frag);
},buildFromTemplate:function(args,frag){
var _4e8=false;
if(args["templatepath"]){
args["templatePath"]=args["templatepath"];
}
dojo.widget.fillFromTemplateCache(this,args["templatePath"],null,_4e8);
var ts=dojo.widget._templateCache[this.templatePath?this.templatePath.toString():this.widgetType];
if((ts)&&(!_4e8)){
if(!this.templateString.length){
this.templateString=ts["string"];
}
if(!this.templateNode){
this.templateNode=ts["node"];
}
}
var _4ea=false;
var node=null;
var tstr=this.templateString;
if((!this.templateNode)&&(this.templateString)){
_4ea=this.templateString.match(/\$\{([^\}]+)\}/g);
if(_4ea){
var hash=this.strings||{};
for(var key in dojo.widget.defaultStrings){
if(dojo.lang.isUndefined(hash[key])){
hash[key]=dojo.widget.defaultStrings[key];
}
}
for(var i=0;i<_4ea.length;i++){
var key=_4ea[i];
key=key.substring(2,key.length-1);
var kval=(key.substring(0,5)=="this.")?dojo.lang.getObjPathValue(key.substring(5),this):hash[key];
var _4f1;
if((kval)||(dojo.lang.isString(kval))){
_4f1=new String((dojo.lang.isFunction(kval))?kval.call(this,key,this.templateString):kval);
while(_4f1.indexOf("\"")>-1){
_4f1=_4f1.replace("\"","&quot;");
}
tstr=tstr.replace(_4ea[i],_4f1);
}
}
}else{
this.templateNode=this.createNodesFromText(this.templateString,true)[0];
if(!_4e8){
ts.node=this.templateNode;
}
}
}
if((!this.templateNode)&&(!_4ea)){
dojo.debug("DomWidget.buildFromTemplate: could not create template");
return false;
}else{
if(!_4ea){
node=this.templateNode.cloneNode(true);
if(!node){
return false;
}
}else{
node=this.createNodesFromText(tstr,true)[0];
}
}
this.domNode=node;
this.attachTemplateNodes();
if(this.isContainer&&this.containerNode){
var src=this.getFragNodeRef(frag);
if(src){
dojo.dom.moveChildren(src,this.containerNode);
}
}
},attachTemplateNodes:function(_4f3,_4f4){
if(!_4f3){
_4f3=this.domNode;
}
if(!_4f4){
_4f4=this;
}
return dojo.widget.attachTemplateNodes(_4f3,_4f4,dojo.widget.getDojoEventsFromStr(this.templateString));
},fillInTemplate:function(){
},destroyRendering:function(){
try{
dojo.dom.destroyNode(this.domNode);
delete this.domNode;
}
catch(e){
}
if(this._sourceNodeRef){
try{
dojo.dom.destroyNode(this._sourceNodeRef);
}
catch(e){
}
}
},createNodesFromText:function(){
dojo.unimplemented("dojo.widget.DomWidget.createNodesFromText");
}});
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_4f6,_4f7){
node=dojo.byId(node);
_4f7(node,!_4f6(node));
return _4f6(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
dojo.html.setStyle(node,"display",(node.dojoDisplayCache||""));
node.dojoDisplayCache=undefined;
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
if(typeof node["dojoDisplayCache"]=="undefined"){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.dojoDisplayCache=d;
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_4fc){
dojo.html[(_4fc?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_502){
dojo.html.setStyle(node,"display",((_502 instanceof String||typeof _502=="string")?_502:(_502?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_506){
dojo.html.setStyle(node,"visibility",((_506 instanceof String||typeof _506=="string")?_506:(_506?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_50a,_50b){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_50b){
if(_50a>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_50a=0.999999;
}
}else{
if(_50a<0){
_50a=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_50a*100+")";
}
}
node.style.filter="Alpha(Opacity="+_50a*100+")";
}else{
if(h.moz){
node.style.opacity=_50a;
node.style.MozOpacity=_50a;
}else{
if(h.safari){
node.style.opacity=_50a;
node.style.KhtmlOpacity=_50a;
}else{
node.style.opacity=_50a;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _517=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_517+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _517;
};
dojo.html.setStyleAttributes=function(node,_51a){
node=dojo.byId(node);
var _51b=_51a.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_51b.length;i++){
var _51d=_51b[i].split(":");
var name=_51d[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _51f=_51d[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_51f);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_51f});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_51f});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_51f});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_51f});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_51f;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_521,_522){
node=dojo.byId(node,node.ownerDocument);
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_522){
_522=bs.CONTENT_BOX;
}
var _525=2;
var _526;
switch(_522){
case bs.MARGIN_BOX:
_526=3;
break;
case bs.BORDER_BOX:
_526=2;
break;
case bs.PADDING_BOX:
default:
_526=1;
break;
case bs.CONTENT_BOX:
_526=0;
break;
}
var h=dojo.render.html;
var db=document["body"]||document["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(document.getBoxObjectFor){
_525=1;
try{
var bo=document.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _52a;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_52a=db;
}else{
_52a=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _52c=node;
do{
var n=_52c["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_52c["offsetTop"];
ret.y+=isNaN(m)?0:m;
_52c=_52c.offsetParent;
}while((_52c!=_52a)&&(_52c!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_521){
var _52f=dojo.html.getScroll();
ret.y+=_52f.top;
ret.x+=_52f.left;
}
var _530=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_525>_526){
for(var i=_526;i<_525;++i){
ret.y+=_530[i](node,"top");
ret.x+=_530[i](node,"left");
}
}else{
if(_525<_526){
for(var i=_526;i>_525;--i){
ret.y-=_530[i-1](node,"top");
ret.x-=_530[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._sumPixelValues=function(node,_534,_535){
var _536=0;
for(var x=0;x<_534.length;x++){
_536+=dojo.html.getPixelValue(node,_534[x],_535);
}
return _536;
};
dojo.html.getMargin=function(node){
return {width:dojo.html._sumPixelValues(node,["margin-left","margin-right"],(dojo.html.getComputedStyle(node,"position")=="absolute")),height:dojo.html._sumPixelValues(node,["margin-top","margin-bottom"],(dojo.html.getComputedStyle(node,"position")=="absolute"))};
};
dojo.html.getBorder=function(node){
return {width:dojo.html.getBorderExtent(node,"left")+dojo.html.getBorderExtent(node,"right"),height:dojo.html.getBorderExtent(node,"top")+dojo.html.getBorderExtent(node,"bottom")};
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html._sumPixelValues(node,["margin-"+side],dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html._sumPixelValues(node,["padding-"+side],true);
};
dojo.html.getPadding=function(node){
return {width:dojo.html._sumPixelValues(node,["padding-left","padding-right"],true),height:dojo.html._sumPixelValues(node,["padding-top","padding-bottom"],true)};
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _543=dojo.html.getBorder(node);
return {width:pad.width+_543.width,height:pad.height+_543.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if(((h.ie)||(h.opera))&&node.nodeName.toLowerCase()!="img"){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _548;
if(!h.ie){
_548=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_548){
_548=dojo.html.getStyle(node,"box-sizing");
}
}
return (_548?_548:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _54d=dojo.html.getBorder(node);
return {width:box.width-_54d.width,height:box.height-_54d.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _54f=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_54f.width,height:node.offsetHeight-_54f.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _552=0;
var _553=0;
var isbb=dojo.html.isBorderBox(node);
var _555=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_552=args.width+_555.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_552);
}
if(typeof args.height!="undefined"){
_553=args.height+_555.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_553);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _558=dojo.html.getBorderBox(node);
var _559=dojo.html.getMargin(node);
return {width:_558.width+_559.width,height:_558.height+_559.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _55c=0;
var _55d=0;
var isbb=dojo.html.isBorderBox(node);
var _55f=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _560=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_55c=args.width-_55f.width;
_55c-=_560.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_55c);
}
if(typeof args.height!="undefined"){
_55d=args.height-_55f.height;
_55d-=_560.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_55d);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_565,_566,_567){
if(_565 instanceof Array||typeof _565=="array"){
dojo.deprecated("dojo.html.toCoordinateArray","use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead","0.5");
while(_565.length<4){
_565.push(0);
}
while(_565.length>4){
_565.pop();
}
var ret={left:_565[0],top:_565[1],width:_565[2],height:_565[3]};
}else{
if(!_565.nodeType&&!(_565 instanceof String||typeof _565=="string")&&("width" in _565||"height" in _565||"left" in _565||"x" in _565||"top" in _565||"y" in _565)){
var ret={left:_565.left||_565.x||0,top:_565.top||_565.y||0,width:_565.width||0,height:_565.height||0};
}else{
var node=dojo.byId(_565);
var pos=dojo.html.abs(node,_566,_567);
var _56b=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_56b.width,height:_56b.height};
}
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_56d){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_570){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_572){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_574){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_576){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_578){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_582){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_584){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.html.util");
dojo.html.getElementWindow=function(_585){
return dojo.html.getDocumentWindow(_585.ownerDocument);
};
dojo.html.getDocumentWindow=function(doc){
if(dojo.render.html.safari&&!doc._parentWindow){
var fix=function(win){
win.document._parentWindow=win;
for(var i=0;i<win.frames.length;i++){
fix(win.frames[i]);
}
};
fix(window.top);
}
if(dojo.render.html.ie&&window!==document.parentWindow&&!doc._parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc._parentWindow||doc.parentWindow||doc.defaultView;
};
dojo.html.gravity=function(node,e){
node=dojo.byId(node);
var _58d=dojo.html.getCursorPosition(e);
with(dojo.html){
var _58e=getAbsolutePosition(node,true);
var bb=getBorderBox(node);
var _590=_58e.x+(bb.width/2);
var _591=_58e.y+(bb.height/2);
}
with(dojo.html.gravity){
return ((_58d.x<_590?WEST:EAST)|(_58d.y<_591?NORTH:SOUTH));
}
};
dojo.html.gravity.NORTH=1;
dojo.html.gravity.SOUTH=1<<1;
dojo.html.gravity.EAST=1<<2;
dojo.html.gravity.WEST=1<<3;
dojo.html.overElement=function(_592,e){
_592=dojo.byId(_592);
var _594=dojo.html.getCursorPosition(e);
var bb=dojo.html.getBorderBox(_592);
var _596=dojo.html.getAbsolutePosition(_592,true,dojo.html.boxSizing.BORDER_BOX);
var top=_596.y;
var _598=top+bb.height;
var left=_596.x;
var _59a=left+bb.width;
return (_594.x>=left&&_594.x<=_59a&&_594.y>=top&&_594.y<=_598);
};
dojo.html.renderedTextContent=function(node){
node=dojo.byId(node);
var _59c="";
if(node==null){
return _59c;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
var _59e="unknown";
try{
_59e=dojo.html.getStyle(node.childNodes[i],"display");
}
catch(E){
}
switch(_59e){
case "block":
case "list-item":
case "run-in":
case "table":
case "table-row-group":
case "table-header-group":
case "table-footer-group":
case "table-row":
case "table-column-group":
case "table-column":
case "table-cell":
case "table-caption":
_59c+="\n";
_59c+=dojo.html.renderedTextContent(node.childNodes[i]);
_59c+="\n";
break;
case "none":
break;
default:
if(node.childNodes[i].tagName&&node.childNodes[i].tagName.toLowerCase()=="br"){
_59c+="\n";
}else{
_59c+=dojo.html.renderedTextContent(node.childNodes[i]);
}
break;
}
break;
case 3:
case 2:
case 4:
var text=node.childNodes[i].nodeValue;
var _5a0="unknown";
try{
_5a0=dojo.html.getStyle(node,"text-transform");
}
catch(E){
}
switch(_5a0){
case "capitalize":
var _5a1=text.split(" ");
for(var i=0;i<_5a1.length;i++){
_5a1[i]=_5a1[i].charAt(0).toUpperCase()+_5a1[i].substring(1);
}
text=_5a1.join(" ");
break;
case "uppercase":
text=text.toUpperCase();
break;
case "lowercase":
text=text.toLowerCase();
break;
default:
break;
}
switch(_5a0){
case "nowrap":
break;
case "pre-wrap":
break;
case "pre-line":
break;
case "pre":
break;
default:
text=text.replace(/\s+/," ");
if(/\s$/.test(_59c)){
text.replace(/^\s/,"");
}
break;
}
_59c+=text;
break;
default:
break;
}
}
return _59c;
};
dojo.html.createNodesFromText=function(txt,trim){
if(trim){
txt=txt.replace(/^\s+|\s+$/g,"");
}
var tn=dojo.doc().createElement("div");
tn.style.visibility="hidden";
dojo.body().appendChild(tn);
var _5a5="none";
if((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody><tr>"+txt+"</tr></tbody></table>";
_5a5="cell";
}else{
if((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody>"+txt+"</tbody></table>";
_5a5="row";
}else{
if((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table>"+txt+"</table>";
_5a5="section";
}
}
}
tn.innerHTML=txt;
if(tn["normalize"]){
tn.normalize();
}
var _5a6=null;
switch(_5a5){
case "cell":
_5a6=tn.getElementsByTagName("tr")[0];
break;
case "row":
_5a6=tn.getElementsByTagName("tbody")[0];
break;
case "section":
_5a6=tn.getElementsByTagName("table")[0];
break;
default:
_5a6=tn;
break;
}
var _5a7=[];
for(var x=0;x<_5a6.childNodes.length;x++){
_5a7.push(_5a6.childNodes[x].cloneNode(true));
}
tn.style.display="none";
dojo.html.destroyNode(tn);
return _5a7;
};
dojo.html.placeOnScreen=function(node,_5aa,_5ab,_5ac,_5ad,_5ae,_5af){
if(_5aa instanceof Array||typeof _5aa=="array"){
_5af=_5ae;
_5ae=_5ad;
_5ad=_5ac;
_5ac=_5ab;
_5ab=_5aa[1];
_5aa=_5aa[0];
}
if(_5ae instanceof String||typeof _5ae=="string"){
_5ae=_5ae.split(",");
}
if(!isNaN(_5ac)){
_5ac=[Number(_5ac),Number(_5ac)];
}else{
if(!(_5ac instanceof Array||typeof _5ac=="array")){
_5ac=[0,0];
}
}
var _5b0=dojo.html.getScroll().offset;
var view=dojo.html.getViewport();
node=dojo.byId(node);
var _5b2=node.style.display;
node.style.display="";
var bb=dojo.html.getBorderBox(node);
var w=bb.width;
var h=bb.height;
node.style.display=_5b2;
if(!(_5ae instanceof Array||typeof _5ae=="array")){
_5ae=["TL"];
}
var _5b6,_5b7,_5b8=Infinity,_5b9;
for(var _5ba=0;_5ba<_5ae.length;++_5ba){
var _5bb=_5ae[_5ba];
var _5bc=true;
var tryX=_5aa-(_5bb.charAt(1)=="L"?0:w)+_5ac[0]*(_5bb.charAt(1)=="L"?1:-1);
var tryY=_5ab-(_5bb.charAt(0)=="T"?0:h)+_5ac[1]*(_5bb.charAt(0)=="T"?1:-1);
if(_5ad){
tryX-=_5b0.x;
tryY-=_5b0.y;
}
if(tryX<0){
tryX=0;
_5bc=false;
}
if(tryY<0){
tryY=0;
_5bc=false;
}
var x=tryX+w;
if(x>view.width){
x=view.width-w;
_5bc=false;
}else{
x=tryX;
}
x=Math.max(_5ac[0],x)+_5b0.x;
var y=tryY+h;
if(y>view.height){
y=view.height-h;
_5bc=false;
}else{
y=tryY;
}
y=Math.max(_5ac[1],y)+_5b0.y;
if(_5bc){
_5b6=x;
_5b7=y;
_5b8=0;
_5b9=_5bb;
break;
}else{
var dist=Math.pow(x-tryX-_5b0.x,2)+Math.pow(y-tryY-_5b0.y,2);
if(_5b8>dist){
_5b8=dist;
_5b6=x;
_5b7=y;
_5b9=_5bb;
}
}
}
if(!_5af){
node.style.left=_5b6+"px";
node.style.top=_5b7+"px";
}
return {left:_5b6,top:_5b7,x:_5b6,y:_5b7,dist:_5b8,corner:_5b9};
};
dojo.html.placeOnScreenPoint=function(node,_5c3,_5c4,_5c5,_5c6){
dojo.deprecated("dojo.html.placeOnScreenPoint","use dojo.html.placeOnScreen() instead","0.5");
return dojo.html.placeOnScreen(node,_5c3,_5c4,_5c5,_5c6,["TL","TR","BL","BR"]);
};
dojo.html.placeOnScreenAroundElement=function(node,_5c8,_5c9,_5ca,_5cb,_5cc){
var best,_5ce=Infinity;
_5c8=dojo.byId(_5c8);
var _5cf=_5c8.style.display;
_5c8.style.display="";
var mb=dojo.html.getElementBox(_5c8,_5ca);
var _5d1=mb.width;
var _5d2=mb.height;
var _5d3=dojo.html.getAbsolutePosition(_5c8,true,_5ca);
_5c8.style.display=_5cf;
for(var _5d4 in _5cb){
var pos,_5d6,_5d7;
var _5d8=_5cb[_5d4];
_5d6=_5d3.x+(_5d4.charAt(1)=="L"?0:_5d1);
_5d7=_5d3.y+(_5d4.charAt(0)=="T"?0:_5d2);
pos=dojo.html.placeOnScreen(node,_5d6,_5d7,_5c9,true,_5d8,true);
if(pos.dist==0){
best=pos;
break;
}else{
if(_5ce>pos.dist){
_5ce=pos.dist;
best=pos;
}
}
}
if(!_5cc){
node.style.left=best.left+"px";
node.style.top=best.top+"px";
}
return best;
};
dojo.html.scrollIntoView=function(node){
if(!node){
return;
}
if(dojo.render.html.ie){
if(dojo.html.getBorderBox(node.parentNode).height<=node.parentNode.scrollHeight){
node.scrollIntoView(false);
}
}else{
if(dojo.render.html.mozilla){
node.scrollIntoView(false);
}else{
var _5da=node.parentNode;
var _5db=_5da.scrollTop+dojo.html.getBorderBox(_5da).height;
var _5dc=node.offsetTop+dojo.html.getMarginBox(node).height;
if(_5db<_5dc){
_5da.scrollTop+=(_5dc-_5db);
}else{
if(_5da.scrollTop>node.offsetTop){
_5da.scrollTop-=(_5da.scrollTop-node.offsetTop);
}
}
}
}
};
dojo.provide("dojo.gfx.color");
dojo.gfx.color.Color=function(r,g,b,a){
if(dojo.lang.isArray(r)){
this.r=r[0];
this.g=r[1];
this.b=r[2];
this.a=r[3]||1;
}else{
if(dojo.lang.isString(r)){
var rgb=dojo.gfx.color.extractRGB(r);
this.r=rgb[0];
this.g=rgb[1];
this.b=rgb[2];
this.a=g||1;
}else{
if(r instanceof dojo.gfx.color.Color){
this.r=r.r;
this.b=r.b;
this.g=r.g;
this.a=r.a;
}else{
this.r=r;
this.g=g;
this.b=b;
this.a=a;
}
}
}
};
dojo.gfx.color.Color.fromArray=function(arr){
return new dojo.gfx.color.Color(arr[0],arr[1],arr[2],arr[3]);
};
dojo.extend(dojo.gfx.color.Color,{toRgb:function(_5e3){
if(_5e3){
return this.toRgba();
}else{
return [this.r,this.g,this.b];
}
},toRgba:function(){
return [this.r,this.g,this.b,this.a];
},toHex:function(){
return dojo.gfx.color.rgb2hex(this.toRgb());
},toCss:function(){
return "rgb("+this.toRgb().join()+")";
},toString:function(){
return this.toHex();
},blend:function(_5e4,_5e5){
var rgb=null;
if(dojo.lang.isArray(_5e4)){
rgb=_5e4;
}else{
if(_5e4 instanceof dojo.gfx.color.Color){
rgb=_5e4.toRgb();
}else{
rgb=new dojo.gfx.color.Color(_5e4).toRgb();
}
}
return dojo.gfx.color.blend(this.toRgb(),rgb,_5e5);
}});
dojo.gfx.color.named={white:[255,255,255],black:[0,0,0],red:[255,0,0],green:[0,255,0],lime:[0,255,0],blue:[0,0,255],navy:[0,0,128],gray:[128,128,128],silver:[192,192,192]};
dojo.gfx.color.blend=function(a,b,_5e9){
if(typeof a=="string"){
return dojo.gfx.color.blendHex(a,b,_5e9);
}
if(!_5e9){
_5e9=0;
}
_5e9=Math.min(Math.max(-1,_5e9),1);
_5e9=((_5e9+1)/2);
var c=[];
for(var x=0;x<3;x++){
c[x]=parseInt(b[x]+((a[x]-b[x])*_5e9));
}
return c;
};
dojo.gfx.color.blendHex=function(a,b,_5ee){
return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a),dojo.gfx.color.hex2rgb(b),_5ee));
};
dojo.gfx.color.extractRGB=function(_5ef){
var hex="0123456789abcdef";
_5ef=_5ef.toLowerCase();
if(_5ef.indexOf("rgb")==0){
var _5f1=_5ef.match(/rgba*\((\d+), *(\d+), *(\d+)/i);
var ret=_5f1.splice(1,3);
return ret;
}else{
var _5f3=dojo.gfx.color.hex2rgb(_5ef);
if(_5f3){
return _5f3;
}else{
return dojo.gfx.color.named[_5ef]||[255,255,255];
}
}
};
dojo.gfx.color.hex2rgb=function(hex){
var _5f5="0123456789ABCDEF";
var rgb=new Array(3);
if(hex.indexOf("#")==0){
hex=hex.substring(1);
}
hex=hex.toUpperCase();
if(hex.replace(new RegExp("["+_5f5+"]","g"),"")!=""){
return null;
}
if(hex.length==3){
rgb[0]=hex.charAt(0)+hex.charAt(0);
rgb[1]=hex.charAt(1)+hex.charAt(1);
rgb[2]=hex.charAt(2)+hex.charAt(2);
}else{
rgb[0]=hex.substring(0,2);
rgb[1]=hex.substring(2,4);
rgb[2]=hex.substring(4);
}
for(var i=0;i<rgb.length;i++){
rgb[i]=_5f5.indexOf(rgb[i].charAt(0))*16+_5f5.indexOf(rgb[i].charAt(1));
}
return rgb;
};
dojo.gfx.color.rgb2hex=function(r,g,b){
if(dojo.lang.isArray(r)){
g=r[1]||0;
b=r[2]||0;
r=r[0]||0;
}
var ret=dojo.lang.map([r,g,b],function(x){
x=new Number(x);
var s=x.toString(16);
while(s.length<2){
s="0"+s;
}
return s;
});
ret.unshift("#");
return ret.join("");
};
dojo.provide("dojo.lfx.Animation");
dojo.lfx.Line=function(_5fe,end){
this.start=_5fe;
this.end=end;
if(dojo.lang.isArray(_5fe)){
var diff=[];
dojo.lang.forEach(this.start,function(s,i){
diff[i]=this.end[i]-s;
},this);
this.getValue=function(n){
var res=[];
dojo.lang.forEach(this.start,function(s,i){
res[i]=(diff[i]*n)+s;
},this);
return res;
};
}else{
var diff=end-_5fe;
this.getValue=function(n){
return (diff*n)+this.start;
};
}
};
if((dojo.render.html.khtml)&&(!dojo.render.html.safari)){
dojo.lfx.easeDefault=function(n){
return (parseFloat("0.5")+((Math.sin((n+parseFloat("1.5"))*Math.PI))/2));
};
}else{
dojo.lfx.easeDefault=function(n){
return (0.5+((Math.sin((n+1.5)*Math.PI))/2));
};
}
dojo.lfx.easeIn=function(n){
return Math.pow(n,3);
};
dojo.lfx.easeOut=function(n){
return (1-Math.pow(1-n,3));
};
dojo.lfx.easeInOut=function(n){
return ((3*Math.pow(n,2))-(2*Math.pow(n,3)));
};
dojo.lfx.IAnimation=function(){
};
dojo.lang.extend(dojo.lfx.IAnimation,{curve:null,duration:1000,easing:null,repeatCount:0,rate:10,handler:null,beforeBegin:null,onBegin:null,onAnimate:null,onEnd:null,onPlay:null,onPause:null,onStop:null,play:null,pause:null,stop:null,connect:function(evt,_60e,_60f){
if(!_60f){
_60f=_60e;
_60e=this;
}
_60f=dojo.lang.hitch(_60e,_60f);
var _610=this[evt]||function(){
};
this[evt]=function(){
var ret=_610.apply(this,arguments);
_60f.apply(this,arguments);
return ret;
};
return this;
},fire:function(evt,args){
if(this[evt]){
this[evt].apply(this,(args||[]));
}
return this;
},repeat:function(_614){
this.repeatCount=_614;
return this;
},_active:false,_paused:false});
dojo.lfx.Animation=function(_615,_616,_617,_618,_619,rate){
dojo.lfx.IAnimation.call(this);
if(dojo.lang.isNumber(_615)||(!_615&&_616.getValue)){
rate=_619;
_619=_618;
_618=_617;
_617=_616;
_616=_615;
_615=null;
}else{
if(_615.getValue||dojo.lang.isArray(_615)){
rate=_618;
_619=_617;
_618=_616;
_617=_615;
_616=null;
_615=null;
}
}
if(dojo.lang.isArray(_617)){
this.curve=new dojo.lfx.Line(_617[0],_617[1]);
}else{
this.curve=_617;
}
if(_616!=null&&_616>0){
this.duration=_616;
}
if(_619){
this.repeatCount=_619;
}
if(rate){
this.rate=rate;
}
if(_615){
dojo.lang.forEach(["handler","beforeBegin","onBegin","onEnd","onPlay","onStop","onAnimate"],function(item){
if(_615[item]){
this.connect(item,_615[item]);
}
},this);
}
if(_618&&dojo.lang.isFunction(_618)){
this.easing=_618;
}
};
dojo.inherits(dojo.lfx.Animation,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Animation,{_startTime:null,_endTime:null,_timer:null,_percent:0,_startRepeatCount:0,play:function(_61c,_61d){
if(_61d){
clearTimeout(this._timer);
this._active=false;
this._paused=false;
this._percent=0;
}else{
if(this._active&&!this._paused){
return this;
}
}
this.fire("handler",["beforeBegin"]);
this.fire("beforeBegin");
if(_61c>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_61d);
}),_61c);
return this;
}
this._startTime=new Date().valueOf();
if(this._paused){
this._startTime-=(this.duration*this._percent/100);
}
this._endTime=this._startTime+this.duration;
this._active=true;
this._paused=false;
var step=this._percent/100;
var _61f=this.curve.getValue(step);
if(this._percent==0){
if(!this._startRepeatCount){
this._startRepeatCount=this.repeatCount;
}
this.fire("handler",["begin",_61f]);
this.fire("onBegin",[_61f]);
}
this.fire("handler",["play",_61f]);
this.fire("onPlay",[_61f]);
this._cycle();
return this;
},pause:function(){
clearTimeout(this._timer);
if(!this._active){
return this;
}
this._paused=true;
var _620=this.curve.getValue(this._percent/100);
this.fire("handler",["pause",_620]);
this.fire("onPause",[_620]);
return this;
},gotoPercent:function(pct,_622){
clearTimeout(this._timer);
this._active=true;
this._paused=true;
this._percent=pct;
if(_622){
this.play();
}
return this;
},stop:function(_623){
clearTimeout(this._timer);
var step=this._percent/100;
if(_623){
step=1;
}
var _625=this.curve.getValue(step);
this.fire("handler",["stop",_625]);
this.fire("onStop",[_625]);
this._active=false;
this._paused=false;
return this;
},status:function(){
if(this._active){
return this._paused?"paused":"playing";
}else{
return "stopped";
}
return this;
},_cycle:function(){
clearTimeout(this._timer);
if(this._active){
var curr=new Date().valueOf();
var step=(curr-this._startTime)/(this._endTime-this._startTime);
if(step>=1){
step=1;
this._percent=100;
}else{
this._percent=step*100;
}
if((this.easing)&&(dojo.lang.isFunction(this.easing))){
step=this.easing(step);
}
var _628=this.curve.getValue(step);
this.fire("handler",["animate",_628]);
this.fire("onAnimate",[_628]);
if(step<1){
this._timer=setTimeout(dojo.lang.hitch(this,"_cycle"),this.rate);
}else{
this._active=false;
this.fire("handler",["end"]);
this.fire("onEnd");
if(this.repeatCount>0){
this.repeatCount--;
this.play(null,true);
}else{
if(this.repeatCount==-1){
this.play(null,true);
}else{
if(this._startRepeatCount){
this.repeatCount=this._startRepeatCount;
this._startRepeatCount=0;
}
}
}
}
}
return this;
}});
dojo.lfx.Combine=function(_629){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._animsEnded=0;
var _62a=arguments;
if(_62a.length==1&&(dojo.lang.isArray(_62a[0])||dojo.lang.isArrayLike(_62a[0]))){
_62a=_62a[0];
}
dojo.lang.forEach(_62a,function(anim){
this._anims.push(anim);
anim.connect("onEnd",dojo.lang.hitch(this,"_onAnimsEnded"));
},this);
};
dojo.inherits(dojo.lfx.Combine,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Combine,{_animsEnded:0,play:function(_62c,_62d){
if(!this._anims.length){
return this;
}
this.fire("beforeBegin");
if(_62c>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_62d);
}),_62c);
return this;
}
if(_62d||this._anims[0].percent==0){
this.fire("onBegin");
}
this.fire("onPlay");
this._animsCall("play",null,_62d);
return this;
},pause:function(){
this.fire("onPause");
this._animsCall("pause");
return this;
},stop:function(_62e){
this.fire("onStop");
this._animsCall("stop",_62e);
return this;
},_onAnimsEnded:function(){
this._animsEnded++;
if(this._animsEnded>=this._anims.length){
this.fire("onEnd");
}
return this;
},_animsCall:function(_62f){
var args=[];
if(arguments.length>1){
for(var i=1;i<arguments.length;i++){
args.push(arguments[i]);
}
}
var _632=this;
dojo.lang.forEach(this._anims,function(anim){
anim[_62f](args);
},_632);
return this;
}});
dojo.lfx.Chain=function(_634){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._currAnim=-1;
var _635=arguments;
if(_635.length==1&&(dojo.lang.isArray(_635[0])||dojo.lang.isArrayLike(_635[0]))){
_635=_635[0];
}
var _636=this;
dojo.lang.forEach(_635,function(anim,i,_639){
this._anims.push(anim);
if(i<_639.length-1){
anim.connect("onEnd",dojo.lang.hitch(this,"_playNext"));
}else{
anim.connect("onEnd",dojo.lang.hitch(this,function(){
this.fire("onEnd");
}));
}
},this);
};
dojo.inherits(dojo.lfx.Chain,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Chain,{_currAnim:-1,play:function(_63a,_63b){
if(!this._anims.length){
return this;
}
if(_63b||!this._anims[this._currAnim]){
this._currAnim=0;
}
var _63c=this._anims[this._currAnim];
this.fire("beforeBegin");
if(_63a>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_63b);
}),_63a);
return this;
}
if(_63c){
if(this._currAnim==0){
this.fire("handler",["begin",this._currAnim]);
this.fire("onBegin",[this._currAnim]);
}
this.fire("onPlay",[this._currAnim]);
_63c.play(null,_63b);
}
return this;
},pause:function(){
if(this._anims[this._currAnim]){
this._anims[this._currAnim].pause();
this.fire("onPause",[this._currAnim]);
}
return this;
},playPause:function(){
if(this._anims.length==0){
return this;
}
if(this._currAnim==-1){
this._currAnim=0;
}
var _63d=this._anims[this._currAnim];
if(_63d){
if(!_63d._active||_63d._paused){
this.play();
}else{
this.pause();
}
}
return this;
},stop:function(){
var _63e=this._anims[this._currAnim];
if(_63e){
_63e.stop();
this.fire("onStop",[this._currAnim]);
}
return _63e;
},_playNext:function(){
if(this._currAnim==-1||this._anims.length==0){
return this;
}
this._currAnim++;
if(this._anims[this._currAnim]){
this._anims[this._currAnim].play(null,true);
}
return this;
}});
dojo.lfx.combine=function(_63f){
var _640=arguments;
if(dojo.lang.isArray(arguments[0])){
_640=arguments[0];
}
if(_640.length==1){
return _640[0];
}
return new dojo.lfx.Combine(_640);
};
dojo.lfx.chain=function(_641){
var _642=arguments;
if(dojo.lang.isArray(arguments[0])){
_642=arguments[0];
}
if(_642.length==1){
return _642[0];
}
return new dojo.lfx.Chain(_642);
};
dojo.provide("dojo.html.color");
dojo.html.getBackgroundColor=function(node){
node=dojo.byId(node);
var _644;
do{
_644=dojo.html.getStyle(node,"background-color");
if(_644.toLowerCase()=="rgba(0, 0, 0, 0)"){
_644="transparent";
}
if(node==document.getElementsByTagName("body")[0]){
node=null;
break;
}
node=node.parentNode;
}while(node&&dojo.lang.inArray(["transparent",""],_644));
if(_644=="transparent"){
_644=[255,255,255,0];
}else{
_644=dojo.gfx.color.extractRGB(_644);
}
return _644;
};
dojo.provide("dojo.lfx.html");
dojo.lfx.html._byId=function(_645){
if(!_645){
return [];
}
if(dojo.lang.isArrayLike(_645)){
if(!_645.alreadyChecked){
var n=[];
dojo.lang.forEach(_645,function(node){
n.push(dojo.byId(node));
});
n.alreadyChecked=true;
return n;
}else{
return _645;
}
}else{
var n=[];
n.push(dojo.byId(_645));
n.alreadyChecked=true;
return n;
}
};
dojo.lfx.html.propertyAnimation=function(_648,_649,_64a,_64b,_64c){
_648=dojo.lfx.html._byId(_648);
var _64d={"propertyMap":_649,"nodes":_648,"duration":_64a,"easing":_64b||dojo.lfx.easeDefault};
var _64e=function(args){
if(args.nodes.length==1){
var pm=args.propertyMap;
if(!dojo.lang.isArray(args.propertyMap)){
var parr=[];
for(var _652 in pm){
pm[_652].property=_652;
parr.push(pm[_652]);
}
pm=args.propertyMap=parr;
}
dojo.lang.forEach(pm,function(prop){
if(dj_undef("start",prop)){
if(prop.property!="opacity"){
prop.start=parseInt(dojo.html.getComputedStyle(args.nodes[0],prop.property));
}else{
prop.start=dojo.html.getOpacity(args.nodes[0]);
}
}
});
}
};
var _654=function(_655){
var _656=[];
dojo.lang.forEach(_655,function(c){
_656.push(Math.round(c));
});
return _656;
};
var _658=function(n,_65a){
n=dojo.byId(n);
if(!n||!n.style){
return;
}
for(var s in _65a){
try{
if(s=="opacity"){
dojo.html.setOpacity(n,_65a[s]);
}else{
n.style[s]=_65a[s];
}
}
catch(e){
dojo.debug(e);
}
}
};
var _65c=function(_65d){
this._properties=_65d;
this.diffs=new Array(_65d.length);
dojo.lang.forEach(_65d,function(prop,i){
if(dojo.lang.isFunction(prop.start)){
prop.start=prop.start(prop,i);
}
if(dojo.lang.isFunction(prop.end)){
prop.end=prop.end(prop,i);
}
if(dojo.lang.isArray(prop.start)){
this.diffs[i]=null;
}else{
if(prop.start instanceof dojo.gfx.color.Color){
prop.startRgb=prop.start.toRgb();
prop.endRgb=prop.end.toRgb();
}else{
this.diffs[i]=prop.end-prop.start;
}
}
},this);
this.getValue=function(n){
var ret={};
dojo.lang.forEach(this._properties,function(prop,i){
var _664=null;
if(dojo.lang.isArray(prop.start)){
}else{
if(prop.start instanceof dojo.gfx.color.Color){
_664=(prop.units||"rgb")+"(";
for(var j=0;j<prop.startRgb.length;j++){
_664+=Math.round(((prop.endRgb[j]-prop.startRgb[j])*n)+prop.startRgb[j])+(j<prop.startRgb.length-1?",":"");
}
_664+=")";
}else{
_664=((this.diffs[i])*n)+prop.start+(prop.property!="opacity"?prop.units||"px":"");
}
}
ret[dojo.html.toCamelCase(prop.property)]=_664;
},this);
return ret;
};
};
var anim=new dojo.lfx.Animation({beforeBegin:function(){
_64e(_64d);
anim.curve=new _65c(_64d.propertyMap);
},onAnimate:function(_667){
dojo.lang.forEach(_64d.nodes,function(node){
_658(node,_667);
});
}},_64d.duration,null,_64d.easing);
if(_64c){
for(var x in _64c){
if(dojo.lang.isFunction(_64c[x])){
anim.connect(x,anim,_64c[x]);
}
}
}
return anim;
};
dojo.lfx.html._makeFadeable=function(_66a){
var _66b=function(node){
if(dojo.render.html.ie){
if((node.style.zoom.length==0)&&(dojo.html.getStyle(node,"zoom")=="normal")){
node.style.zoom="1";
}
if((node.style.width.length==0)&&(dojo.html.getStyle(node,"width")=="auto")){
node.style.width="auto";
}
}
};
if(dojo.lang.isArrayLike(_66a)){
dojo.lang.forEach(_66a,_66b);
}else{
_66b(_66a);
}
};
dojo.lfx.html.fade=function(_66d,_66e,_66f,_670,_671){
_66d=dojo.lfx.html._byId(_66d);
var _672={property:"opacity"};
if(!dj_undef("start",_66e)){
_672.start=_66e.start;
}else{
_672.start=function(){
return dojo.html.getOpacity(_66d[0]);
};
}
if(!dj_undef("end",_66e)){
_672.end=_66e.end;
}else{
dojo.raise("dojo.lfx.html.fade needs an end value");
}
var anim=dojo.lfx.propertyAnimation(_66d,[_672],_66f,_670);
anim.connect("beforeBegin",function(){
dojo.lfx.html._makeFadeable(_66d);
});
if(_671){
anim.connect("onEnd",function(){
_671(_66d,anim);
});
}
return anim;
};
dojo.lfx.html.fadeIn=function(_674,_675,_676,_677){
return dojo.lfx.html.fade(_674,{end:1},_675,_676,_677);
};
dojo.lfx.html.fadeOut=function(_678,_679,_67a,_67b){
return dojo.lfx.html.fade(_678,{end:0},_679,_67a,_67b);
};
dojo.lfx.html.fadeShow=function(_67c,_67d,_67e,_67f){
_67c=dojo.lfx.html._byId(_67c);
dojo.lang.forEach(_67c,function(node){
dojo.html.setOpacity(node,0);
});
var anim=dojo.lfx.html.fadeIn(_67c,_67d,_67e,_67f);
anim.connect("beforeBegin",function(){
if(dojo.lang.isArrayLike(_67c)){
dojo.lang.forEach(_67c,dojo.html.show);
}else{
dojo.html.show(_67c);
}
});
return anim;
};
dojo.lfx.html.fadeHide=function(_682,_683,_684,_685){
var anim=dojo.lfx.html.fadeOut(_682,_683,_684,function(){
if(dojo.lang.isArrayLike(_682)){
dojo.lang.forEach(_682,dojo.html.hide);
}else{
dojo.html.hide(_682);
}
if(_685){
_685(_682,anim);
}
});
return anim;
};
dojo.lfx.html.wipeIn=function(_687,_688,_689,_68a){
_687=dojo.lfx.html._byId(_687);
var _68b=[];
dojo.lang.forEach(_687,function(node){
var _68d={};
var _68e,_68f,_690;
with(node.style){
_68e=top;
_68f=left;
_690=position;
top="-9999px";
left="-9999px";
position="absolute";
display="";
}
var _691=dojo.html.getBorderBox(node).height;
with(node.style){
top=_68e;
left=_68f;
position=_690;
display="none";
}
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:1,end:function(){
return _691;
}}},_688,_689);
anim.connect("beforeBegin",function(){
_68d.overflow=node.style.overflow;
_68d.height=node.style.height;
with(node.style){
overflow="hidden";
height="1px";
}
dojo.html.show(node);
});
anim.connect("onEnd",function(){
with(node.style){
overflow=_68d.overflow;
height=_68d.height;
}
if(_68a){
_68a(node,anim);
}
});
_68b.push(anim);
});
return dojo.lfx.combine(_68b);
};
dojo.lfx.html.wipeOut=function(_693,_694,_695,_696){
_693=dojo.lfx.html._byId(_693);
var _697=[];
dojo.lang.forEach(_693,function(node){
var _699={};
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:function(){
return dojo.html.getContentBox(node).height;
},end:1}},_694,_695,{"beforeBegin":function(){
_699.overflow=node.style.overflow;
_699.height=node.style.height;
with(node.style){
overflow="hidden";
}
dojo.html.show(node);
},"onEnd":function(){
dojo.html.hide(node);
with(node.style){
overflow=_699.overflow;
height=_699.height;
}
if(_696){
_696(node,anim);
}
}});
_697.push(anim);
});
return dojo.lfx.combine(_697);
};
dojo.lfx.html.slideTo=function(_69b,_69c,_69d,_69e,_69f){
_69b=dojo.lfx.html._byId(_69b);
var _6a0=[];
var _6a1=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_69c)){
dojo.deprecated("dojo.lfx.html.slideTo(node, array)","use dojo.lfx.html.slideTo(node, {top: value, left: value});","0.5");
_69c={top:_69c[0],left:_69c[1]};
}
dojo.lang.forEach(_69b,function(node){
var top=null;
var left=null;
var init=(function(){
var _6a6=node;
return function(){
var pos=_6a1(_6a6,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_6a1(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_6a1(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_6a6,true);
dojo.html.setStyleAttributes(_6a6,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:(_69c.top||0)},"left":{start:left,end:(_69c.left||0)}},_69d,_69e,{"beforeBegin":init});
if(_69f){
anim.connect("onEnd",function(){
_69f(_69b,anim);
});
}
_6a0.push(anim);
});
return dojo.lfx.combine(_6a0);
};
dojo.lfx.html.slideBy=function(_6aa,_6ab,_6ac,_6ad,_6ae){
_6aa=dojo.lfx.html._byId(_6aa);
var _6af=[];
var _6b0=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_6ab)){
dojo.deprecated("dojo.lfx.html.slideBy(node, array)","use dojo.lfx.html.slideBy(node, {top: value, left: value});","0.5");
_6ab={top:_6ab[0],left:_6ab[1]};
}
dojo.lang.forEach(_6aa,function(node){
var top=null;
var left=null;
var init=(function(){
var _6b5=node;
return function(){
var pos=_6b0(_6b5,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_6b0(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_6b0(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_6b5,true);
dojo.html.setStyleAttributes(_6b5,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:top+(_6ab.top||0)},"left":{start:left,end:left+(_6ab.left||0)}},_6ac,_6ad).connect("beforeBegin",init);
if(_6ae){
anim.connect("onEnd",function(){
_6ae(_6aa,anim);
});
}
_6af.push(anim);
});
return dojo.lfx.combine(_6af);
};
dojo.lfx.html.explode=function(_6b9,_6ba,_6bb,_6bc,_6bd){
var h=dojo.html;
_6b9=dojo.byId(_6b9);
_6ba=dojo.byId(_6ba);
var _6bf=h.toCoordinateObject(_6b9,true);
var _6c0=document.createElement("div");
h.copyStyle(_6c0,_6ba);
if(_6ba.explodeClassName){
_6c0.className=_6ba.explodeClassName;
}
with(_6c0.style){
position="absolute";
display="none";
var _6c1=h.getStyle(_6b9,"background-color");
backgroundColor=_6c1?_6c1.toLowerCase():"transparent";
backgroundColor=(backgroundColor=="transparent")?"rgb(221, 221, 221)":backgroundColor;
}
dojo.body().appendChild(_6c0);
with(_6ba.style){
visibility="hidden";
display="block";
}
var _6c2=h.toCoordinateObject(_6ba,true);
with(_6ba.style){
display="none";
visibility="visible";
}
var _6c3={opacity:{start:0.5,end:1}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_6c3[type]={start:_6bf[type],end:_6c2[type]};
});
var anim=new dojo.lfx.propertyAnimation(_6c0,_6c3,_6bb,_6bc,{"beforeBegin":function(){
h.setDisplay(_6c0,"block");
},"onEnd":function(){
h.setDisplay(_6ba,"block");
_6c0.parentNode.removeChild(_6c0);
}});
if(_6bd){
anim.connect("onEnd",function(){
_6bd(_6ba,anim);
});
}
return anim;
};
dojo.lfx.html.implode=function(_6c6,end,_6c8,_6c9,_6ca){
var h=dojo.html;
_6c6=dojo.byId(_6c6);
end=dojo.byId(end);
var _6cc=dojo.html.toCoordinateObject(_6c6,true);
var _6cd=dojo.html.toCoordinateObject(end,true);
var _6ce=document.createElement("div");
dojo.html.copyStyle(_6ce,_6c6);
if(_6c6.explodeClassName){
_6ce.className=_6c6.explodeClassName;
}
dojo.html.setOpacity(_6ce,0.3);
with(_6ce.style){
position="absolute";
display="none";
backgroundColor=h.getStyle(_6c6,"background-color").toLowerCase();
}
dojo.body().appendChild(_6ce);
var _6cf={opacity:{start:1,end:0.5}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_6cf[type]={start:_6cc[type],end:_6cd[type]};
});
var anim=new dojo.lfx.propertyAnimation(_6ce,_6cf,_6c8,_6c9,{"beforeBegin":function(){
dojo.html.hide(_6c6);
dojo.html.show(_6ce);
},"onEnd":function(){
_6ce.parentNode.removeChild(_6ce);
}});
if(_6ca){
anim.connect("onEnd",function(){
_6ca(_6c6,anim);
});
}
return anim;
};
dojo.lfx.html.highlight=function(_6d2,_6d3,_6d4,_6d5,_6d6){
_6d2=dojo.lfx.html._byId(_6d2);
var _6d7=[];
dojo.lang.forEach(_6d2,function(node){
var _6d9=dojo.html.getBackgroundColor(node);
var bg=dojo.html.getStyle(node,"background-color").toLowerCase();
var _6db=dojo.html.getStyle(node,"background-image");
var _6dc=(bg=="transparent"||bg=="rgba(0, 0, 0, 0)");
while(_6d9.length>3){
_6d9.pop();
}
var rgb=new dojo.gfx.color.Color(_6d3);
var _6de=new dojo.gfx.color.Color(_6d9);
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:rgb,end:_6de}},_6d4,_6d5,{"beforeBegin":function(){
if(_6db){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+rgb.toRgb().join(",")+")";
},"onEnd":function(){
if(_6db){
node.style.backgroundImage=_6db;
}
if(_6dc){
node.style.backgroundColor="transparent";
}
if(_6d6){
_6d6(node,anim);
}
}});
_6d7.push(anim);
});
return dojo.lfx.combine(_6d7);
};
dojo.lfx.html.unhighlight=function(_6e0,_6e1,_6e2,_6e3,_6e4){
_6e0=dojo.lfx.html._byId(_6e0);
var _6e5=[];
dojo.lang.forEach(_6e0,function(node){
var _6e7=new dojo.gfx.color.Color(dojo.html.getBackgroundColor(node));
var rgb=new dojo.gfx.color.Color(_6e1);
var _6e9=dojo.html.getStyle(node,"background-image");
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:_6e7,end:rgb}},_6e2,_6e3,{"beforeBegin":function(){
if(_6e9){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+_6e7.toRgb().join(",")+")";
},"onEnd":function(){
if(_6e4){
_6e4(node,anim);
}
}});
_6e5.push(anim);
});
return dojo.lfx.combine(_6e5);
};
dojo.lang.mixin(dojo.lfx,dojo.lfx.html);
dojo.kwCompoundRequire({browser:["dojo.lfx.html"],dashboard:["dojo.lfx.html"]});
dojo.provide("dojo.lfx.*");
dojo.provide("dojo.lfx.toggle");
dojo.lfx.toggle.plain={show:function(node,_6ec,_6ed,_6ee){
dojo.html.show(node);
if(dojo.lang.isFunction(_6ee)){
_6ee();
}
},hide:function(node,_6f0,_6f1,_6f2){
dojo.html.hide(node);
if(dojo.lang.isFunction(_6f2)){
_6f2();
}
}};
dojo.lfx.toggle.fade={show:function(node,_6f4,_6f5,_6f6){
dojo.lfx.fadeShow(node,_6f4,_6f5,_6f6).play();
},hide:function(node,_6f8,_6f9,_6fa){
dojo.lfx.fadeHide(node,_6f8,_6f9,_6fa).play();
}};
dojo.lfx.toggle.wipe={show:function(node,_6fc,_6fd,_6fe){
dojo.lfx.wipeIn(node,_6fc,_6fd,_6fe).play();
},hide:function(node,_700,_701,_702){
dojo.lfx.wipeOut(node,_700,_701,_702).play();
}};
dojo.lfx.toggle.explode={show:function(node,_704,_705,_706,_707){
dojo.lfx.explode(_707||{x:0,y:0,width:0,height:0},node,_704,_705,_706).play();
},hide:function(node,_709,_70a,_70b,_70c){
dojo.lfx.implode(node,_70c||{x:0,y:0,width:0,height:0},_709,_70a,_70b).play();
}};
dojo.provide("dojo.widget.HtmlWidget");
dojo.declare("dojo.widget.HtmlWidget",dojo.widget.DomWidget,{templateCssPath:null,templatePath:null,lang:"",toggle:"plain",toggleDuration:150,initialize:function(args,frag){
},postMixInProperties:function(args,frag){
if(this.lang===""){
this.lang=null;
}
this.toggleObj=dojo.lfx.toggle[this.toggle.toLowerCase()]||dojo.lfx.toggle.plain;
},createNodesFromText:function(txt,wrap){
return dojo.html.createNodesFromText(txt,wrap);
},destroyRendering:function(_713){
try{
if(this.bgIframe){
this.bgIframe.remove();
delete this.bgIframe;
}
if(!_713&&this.domNode){
dojo.event.browser.clean(this.domNode);
}
dojo.widget.HtmlWidget.superclass.destroyRendering.call(this);
}
catch(e){
}
},isShowing:function(){
return dojo.html.isShowing(this.domNode);
},toggleShowing:function(){
if(this.isShowing()){
this.hide();
}else{
this.show();
}
},show:function(){
if(this.isShowing()){
return;
}
this.animationInProgress=true;
this.toggleObj.show(this.domNode,this.toggleDuration,null,dojo.lang.hitch(this,this.onShow),this.explodeSrc);
},onShow:function(){
this.animationInProgress=false;
this.checkSize();
},hide:function(){
if(!this.isShowing()){
return;
}
this.animationInProgress=true;
this.toggleObj.hide(this.domNode,this.toggleDuration,null,dojo.lang.hitch(this,this.onHide),this.explodeSrc);
},onHide:function(){
this.animationInProgress=false;
},_isResized:function(w,h){
if(!this.isShowing()){
return false;
}
var wh=dojo.html.getMarginBox(this.domNode);
var _717=w||wh.width;
var _718=h||wh.height;
if(this.width==_717&&this.height==_718){
return false;
}
this.width=_717;
this.height=_718;
return true;
},checkSize:function(){
if(!this._isResized()){
return;
}
this.onResized();
},resizeTo:function(w,h){
dojo.html.setMarginBox(this.domNode,{width:w,height:h});
if(this.isShowing()){
this.onResized();
}
},resizeSoon:function(){
if(this.isShowing()){
dojo.lang.setTimeout(this,this.onResized,0);
}
},onResized:function(){
dojo.lang.forEach(this.children,function(_71b){
if(_71b.checkSize){
_71b.checkSize();
}
});
}});
dojo.kwCompoundRequire({common:["dojo.xml.Parse","dojo.widget.Widget","dojo.widget.Parse","dojo.widget.Manager"],browser:["dojo.widget.DomWidget","dojo.widget.HtmlWidget"],dashboard:["dojo.widget.DomWidget","dojo.widget.HtmlWidget"],svg:["dojo.widget.SvgWidget"],rhino:["dojo.widget.SwtWidget"]});
dojo.provide("dojo.widget.*");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_722,_723){
var out="";
for(var i=0;i<_722;i++){
out+=str;
if(_723&&i<_722-1){
out+=_723;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_732,_733,_734){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_732){
this.mimetype=_732;
}
if(_733){
this.transport=_733;
}
if(arguments.length>=4){
this.changeUrl=_734;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,jsonFilter:function(_735){
if((this.mimetype=="text/json-comment-filtered")||(this.mimetype=="application/json-comment-filtered")){
var _736=_735.indexOf("/*");
var _737=_735.lastIndexOf("*/");
if((_736==-1)||(_737==-1)){
dojo.debug("your JSON wasn't comment filtered!");
return "";
}
return _735.substring(_736+2,_737);
}
dojo.debug("please consider using a mimetype of text/json-comment-filtered to avoid potential security issues with JSON endpoints");
return _735;
},load:function(type,data,_73a,_73b){
},error:function(type,_73d,_73e,_73f){
},timeout:function(type,_741,_742,_743){
},handle:function(type,data,_746,_747){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_748){
if(_748["url"]){
_748.url=_748.url.toString();
}
if(_748["formNode"]){
_748.formNode=dojo.byId(_748.formNode);
}
if(!_748["method"]&&_748["formNode"]&&_748["formNode"].method){
_748.method=_748["formNode"].method;
}
if(!_748["handle"]&&_748["handler"]){
_748.handle=_748.handler;
}
if(!_748["load"]&&_748["loaded"]){
_748.load=_748.loaded;
}
if(!_748["changeUrl"]&&_748["changeURL"]){
_748.changeUrl=_748.changeURL;
}
_748.encoding=dojo.lang.firstValued(_748["encoding"],djConfig["bindEncoding"],"");
_748.sendTransport=dojo.lang.firstValued(_748["sendTransport"],djConfig["ioSendTransport"],false);
var _749=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_748[fn]&&_749(_748[fn])){
continue;
}
if(_748["handle"]&&_749(_748["handle"])){
_748[fn]=_748.handle;
}
}
dojo.lang.mixin(this,_748);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_750){
if(!(_750 instanceof dojo.io.Request)){
try{
_750=new dojo.io.Request(_750);
}
catch(e){
dojo.debug(e);
}
}
var _751="";
if(_750["transport"]){
_751=_750["transport"];
if(!this[_751]){
dojo.io.sendBindError(_750,"No dojo.io.bind() transport with name '"+_750["transport"]+"'.");
return _750;
}
if(!this[_751].canHandle(_750)){
dojo.io.sendBindError(_750,"dojo.io.bind() transport with name '"+_750["transport"]+"' cannot handle this type of request.");
return _750;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_750))){
_751=tmp;
break;
}
}
if(_751==""){
dojo.io.sendBindError(_750,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _750;
}
}
this[_751].bind(_750);
_750.bindSuccess=true;
return _750;
};
dojo.io.sendBindError=function(_754,_755){
if((typeof _754.error=="function"||typeof _754.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _756=new dojo.io.Error(_755);
setTimeout(function(){
_754[(typeof _754.error=="function")?"error":"handle"]("error",_756,null,_754);
},50);
}else{
dojo.raise(_755);
}
};
dojo.io.queueBind=function(_757){
if(!(_757 instanceof dojo.io.Request)){
try{
_757=new dojo.io.Request(_757);
}
catch(e){
dojo.debug(e);
}
}
var _758=_757.load;
_757.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_758.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _75a=_757.error;
_757.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_75a.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_757);
dojo.io._dispatchNextQueueBind();
return _757;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_75d,last){
var enc=/utf/i.test(_75d||"")?encodeURIComponent:dojo.string.encodeAscii;
var _760=[];
var _761=new Object();
for(var name in map){
var _763=function(elt){
var val=enc(name)+"="+enc(elt);
_760[(last==name)?"push":"unshift"](val);
};
if(!_761[name]){
var _766=map[name];
if(dojo.lang.isArray(_766)){
dojo.lang.forEach(_766,_763);
}else{
_763(_766);
}
}
}
return _760.join("&");
};
dojo.io.setIFrameSrc=function(_767,src,_769){
try{
var r=dojo.render.html;
if(!_769){
if(r.safari){
_767.location=src;
}else{
frames[_767.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_767.contentWindow.document;
}else{
if(r.safari){
idoc=_767.document;
}else{
idoc=_767.contentWindow;
}
}
if(!idoc){
_767.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_76c,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _76c.replace(/\%\{(\w+)\}/g,function(_76f,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _772=str.split(" ");
for(var i=0;i<_772.length;i++){
_772[i]=_772[i].charAt(0).toUpperCase()+_772[i].substring(1);
}
return _772.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _777=escape(str);
var _778,re=/%u([0-9A-F]{4})/i;
while((_778=_777.match(re))){
var num=Number("0x"+_778[1]);
var _77b=escape("&#"+num+";");
ret+=_777.substring(0,_778.index)+_77b;
_777=_777.substring(_778.index+_778[0].length);
}
ret+=_777.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_780){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_780){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_789){
if(_789){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_78d,_78e){
if(_78e){
str=str.toLowerCase();
_78d=_78d.toLowerCase();
}
return str.indexOf(_78d)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_794){
if(_794=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_794=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_796){
var _797=[];
for(var i=0,_799=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_796){
_797.push(str.substring(_799,i));
_799=i+1;
}
}
_797.push(str.substr(_799));
return _797;
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:(!dj_undef("window"))?window.location.href:"",initialHash:(!dj_undef("window"))?window.location.hash:"",moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.undo.browser: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _79e=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_7a0){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_79e.apply(this,[_7a0]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _7a1=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_7a3){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_7a1){
_7a1.apply(this,[_7a3]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_7a6){
if(!dojo.render.html.opera){
var _7a7=this._getUrlQuery(_7a6.href);
if(_7a7==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_7a7==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_7a7==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _7a8=this.historyStack.pop();
if(!_7a8){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_7a8);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _7af=url.split("?");
if(_7af.length<2){
return null;
}else{
return _7af[1];
}
},_loadIframeHistory:function(){
var url=(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
if(!dj_undef("window")){
dojo.io.checkChildrenForFile=function(node){
var _7b2=false;
var _7b3=node.getElementsByTagName("input");
dojo.lang.forEach(_7b3,function(_7b4){
if(_7b2){
return;
}
if(_7b4.getAttribute("type")=="file"){
_7b2=true;
}
});
return _7b2;
};
dojo.io.formHasFile=function(_7b5){
return dojo.io.checkChildrenForFile(_7b5);
};
dojo.io.updateNode=function(node,_7b7){
node=dojo.byId(node);
var args=_7b7;
if(dojo.lang.isString(_7b7)){
args={url:_7b7};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
dojo.dom.destroyNode(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_7be,_7bf,_7c0){
if((!_7be)||(!_7be.tagName)||(!_7be.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_7c0){
_7c0=dojo.io.formFilter;
}
var enc=/utf/i.test(_7bf||"")?encodeURIComponent:dojo.string.encodeAscii;
var _7c2=[];
for(var i=0;i<_7be.elements.length;i++){
var elm=_7be.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_7c0(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_7c2.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_7c2.push(name+"="+enc(elm.value));
}
}else{
_7c2.push(name+"="+enc(elm.value));
}
}
}
var _7c8=_7be.getElementsByTagName("input");
for(var i=0;i<_7c8.length;i++){
var _7c9=_7c8[i];
if(_7c9.type.toLowerCase()=="image"&&_7c9.form==_7be&&_7c0(_7c9)){
var name=enc(_7c9.name);
_7c2.push(name+"="+enc(_7c9.value));
_7c2.push(name+".x=0");
_7c2.push(name+".y=0");
}
}
return _7c2.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _7cf=form.getElementsByTagName("input");
for(var i=0;i<_7cf.length;i++){
var _7d0=_7cf[i];
if(_7d0.type.toLowerCase()=="image"&&_7d0.form==form){
this.connect(_7d0,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _7d7=false;
if(node.disabled||!node.name){
_7d7=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_7d7=node==this.clickedButton;
}else{
_7d7=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _7d7;
},connect:function(_7d8,_7d9,_7da){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_7d8,_7d9,this,_7da);
}else{
var fcn=dojo.lang.hitch(this,_7da);
_7d8[_7d9]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _7dd=this;
var _7de={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_7e0,_7e1){
return url+"|"+_7e0+"|"+_7e1.toLowerCase();
}
function addToCache(url,_7e3,_7e4,http){
_7de[getCacheKey(url,_7e3,_7e4)]=http;
}
function getFromCache(url,_7e7,_7e8){
return _7de[getCacheKey(url,_7e7,_7e8)];
}
this.clearCache=function(){
_7de={};
};
function doLoad(_7e9,http,url,_7ec,_7ed){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(http.status==1223)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_7e9.method.toLowerCase()=="head"){
var _7ef=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _7ef;
};
var _7f0=_7ef.split(/[\r\n]+/g);
for(var i=0;i<_7f0.length;i++){
var pair=_7f0[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_7e9.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_7e9.mimetype.substr(0,9)=="text/json"||_7e9.mimetype.substr(0,16)=="application/json"){
try{
ret=dj_eval("("+_7e9.jsonFilter(http.responseText)+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_7e9.mimetype=="application/xml")||(_7e9.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_7ed){
addToCache(url,_7ec,_7e9.method,http);
}
_7e9[(typeof _7e9.load=="function")?"load":"handle"]("load",ret,http,_7e9);
}else{
var _7f3=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_7e9[(typeof _7e9.error=="function")?"error":"handle"]("error",_7f3,http,_7e9);
}
}
function setHeaders(http,_7f5){
if(_7f5["headers"]){
for(var _7f6 in _7f5["headers"]){
if(_7f6.toLowerCase()=="content-type"&&!_7f5["contentType"]){
_7f5["contentType"]=_7f5["headers"][_7f6];
}else{
http.setRequestHeader(_7f6,_7f5["headers"][_7f6]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_7dd._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _7fa=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_7fa,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _7fb=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_7fc){
var mlc=_7fc["mimetype"].toLowerCase()||"";
return _7fb&&((dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript"],mlc))||(mlc.substr(0,9)=="text/json"||mlc.substr(0,16)=="application/json"))&&!(_7fc["formNode"]&&dojo.io.formHasFile(_7fc["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_7fe){
if(!_7fe["url"]){
if(!_7fe["formNode"]&&(_7fe["backButton"]||_7fe["back"]||_7fe["changeUrl"]||_7fe["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_7fe);
return true;
}
}
var url=_7fe.url;
var _800="";
if(_7fe["formNode"]){
var ta=_7fe.formNode.getAttribute("action");
if((ta)&&(!_7fe["url"])){
url=ta;
}
var tp=_7fe.formNode.getAttribute("method");
if((tp)&&(!_7fe["method"])){
_7fe.method=tp;
}
_800+=dojo.io.encodeForm(_7fe.formNode,_7fe.encoding,_7fe["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_7fe["file"]){
_7fe.method="post";
}
if(!_7fe["method"]){
_7fe.method="get";
}
if(_7fe.method.toLowerCase()=="get"){
_7fe.multipart=false;
}else{
if(_7fe["file"]){
_7fe.multipart=true;
}else{
if(!_7fe["multipart"]){
_7fe.multipart=false;
}
}
}
if(_7fe["backButton"]||_7fe["back"]||_7fe["changeUrl"]){
dojo.undo.browser.addToHistory(_7fe);
}
var _803=_7fe["content"]||{};
if(_7fe.sendTransport){
_803["dojo.transport"]="xmlhttp";
}
do{
if(_7fe.postContent){
_800=_7fe.postContent;
break;
}
if(_803){
_800+=dojo.io.argsFromMap(_803,_7fe.encoding);
}
if(_7fe.method.toLowerCase()=="get"||!_7fe.multipart){
break;
}
var t=[];
if(_800.length){
var q=_800.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_7fe.file){
if(dojo.lang.isArray(_7fe.file)){
for(var i=0;i<_7fe.file.length;++i){
var o=_7fe.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_7fe.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_800=t.join("\r\n");
}
}while(false);
var _809=_7fe["sync"]?false:true;
var _80a=_7fe["preventCache"]||(this.preventCache==true&&_7fe["preventCache"]!=false);
var _80b=_7fe["useCache"]==true||(this.useCache==true&&_7fe["useCache"]!=false);
if(!_80a&&_80b){
var _80c=getFromCache(url,_800,_7fe.method);
if(_80c){
doLoad(_7fe,_80c,url,_800,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_7fe);
var _80e=false;
if(_809){
var _80f=this.inFlight.push({"req":_7fe,"http":http,"url":url,"query":_800,"useCache":_80b,"startTime":_7fe.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_7dd._blockAsync=true;
}
if(_7fe.method.toLowerCase()=="post"){
if(!_7fe.user){
http.open("POST",url,_809);
}else{
http.open("POST",url,_809,_7fe.user,_7fe.password);
}
setHeaders(http,_7fe);
http.setRequestHeader("Content-Type",_7fe.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_7fe.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_800);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_7fe,{status:404},url,_800,_80b);
}
}else{
var _810=url;
if(_800!=""){
_810+=(_810.indexOf("?")>-1?"&":"?")+_800;
}
if(_80a){
_810+=(dojo.string.endsWithAny(_810,"?","&")?"":(_810.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_7fe.user){
http.open(_7fe.method.toUpperCase(),_810,_809);
}else{
http.open(_7fe.method.toUpperCase(),_810,_809,_7fe.user,_7fe.password);
}
setHeaders(http,_7fe);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_7fe,{status:404},url,_800,_80b);
}
}
if(!_809){
doLoad(_7fe,http,url,_800,_80b);
_7dd._blockAsync=false;
}
_7fe.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
}
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_812,days,path,_815,_816){
var _817=-1;
if((typeof days=="number")&&(days>=0)){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_817=d.toGMTString();
}
_812=escape(_812);
document.cookie=name+"="+_812+";"+(_817!=-1?" expires="+_817+";":"")+(path?"path="+path:"")+(_815?"; domain="+_815:"")+(_816?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _81b=document.cookie.substring(idx+name.length+1);
var end=_81b.indexOf(";");
if(end==-1){
end=_81b.length;
}
_81b=_81b.substring(0,end);
_81b=unescape(_81b);
return _81b;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_822,_823,_824){
if(arguments.length==5){
_824=_822;
_822=null;
_823=null;
}
var _825=[],_826,_827="";
if(!_824){
_826=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_826){
_826={};
}
for(var prop in obj){
if(obj[prop]==null){
delete _826[prop];
}else{
if((typeof obj[prop]=="string")||(typeof obj[prop]=="number")){
_826[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _826){
_825.push(escape(prop)+"="+escape(_826[prop]));
}
_827=_825.join("&");
}
dojo.io.cookie.setCookie(name,_827,days,path,_822,_823);
};
dojo.io.cookie.getObjectCookie=function(name){
var _82a=null,_82b=dojo.io.cookie.getCookie(name);
if(_82b){
_82a={};
var _82c=_82b.split("&");
for(var i=0;i<_82c.length;i++){
var pair=_82c[i].split("=");
var _82f=pair[1];
if(isNaN(_82f)){
_82f=unescape(pair[1]);
}
_82a[unescape(pair[0])]=_82f;
}
}
return _82a;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _830=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_830=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.kwCompoundRequire({common:["dojo.io.common"],rhino:["dojo.io.RhinoIO"],browser:["dojo.io.BrowserIO","dojo.io.cookie"],dashboard:["dojo.io.BrowserIO","dojo.io.cookie"]});
dojo.provide("dojo.io.*");
dojo.kwCompoundRequire({common:["dojo.html.common","dojo.html.style"]});
dojo.provide("dojo.html.*");
dojo.provide("dojo.html.selection");
dojo.html.selectionType={NONE:0,TEXT:1,CONTROL:2};
dojo.html.clearSelection=function(){
var _831=dojo.global();
var _832=dojo.doc();
try{
if(_831["getSelection"]){
if(dojo.render.html.safari){
_831.getSelection().collapse();
}else{
_831.getSelection().removeAllRanges();
}
}else{
if(_832.selection){
if(_832.selection.empty){
_832.selection.empty();
}else{
if(_832.selection.clear){
_832.selection.clear();
}
}
}
}
return true;
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.html.disableSelection=function(_833){
_833=dojo.byId(_833)||dojo.body();
var h=dojo.render.html;
if(h.mozilla){
_833.style.MozUserSelect="none";
}else{
if(h.safari){
_833.style.KhtmlUserSelect="none";
}else{
if(h.ie){
_833.unselectable="on";
}else{
return false;
}
}
}
return true;
};
dojo.html.enableSelection=function(_835){
_835=dojo.byId(_835)||dojo.body();
var h=dojo.render.html;
if(h.mozilla){
_835.style.MozUserSelect="";
}else{
if(h.safari){
_835.style.KhtmlUserSelect="";
}else{
if(h.ie){
_835.unselectable="off";
}else{
return false;
}
}
}
return true;
};
dojo.html.selectElement=function(_837){
dojo.deprecated("dojo.html.selectElement","replaced by dojo.html.selection.selectElementChildren",0.5);
};
dojo.html.selectInputText=function(_838){
var _839=dojo.global();
var _83a=dojo.doc();
_838=dojo.byId(_838);
if(_83a["selection"]&&dojo.body()["createTextRange"]){
var _83b=_838.createTextRange();
_83b.moveStart("character",0);
_83b.moveEnd("character",_838.value.length);
_83b.select();
}else{
if(_839["getSelection"]){
var _83c=_839.getSelection();
_838.setSelectionRange(0,_838.value.length);
}
}
_838.focus();
};
dojo.html.isSelectionCollapsed=function(){
dojo.deprecated("dojo.html.isSelectionCollapsed","replaced by dojo.html.selection.isCollapsed",0.5);
return dojo.html.selection.isCollapsed();
};
dojo.lang.mixin(dojo.html.selection,{getType:function(){
if(dojo.doc()["selection"]){
return dojo.html.selectionType[dojo.doc().selection.type.toUpperCase()];
}else{
var _83d=dojo.html.selectionType.TEXT;
var oSel;
try{
oSel=dojo.global().getSelection();
}
catch(e){
}
if(oSel&&oSel.rangeCount==1){
var _83f=oSel.getRangeAt(0);
if(_83f.startContainer==_83f.endContainer&&(_83f.endOffset-_83f.startOffset)==1&&_83f.startContainer.nodeType!=dojo.dom.TEXT_NODE){
_83d=dojo.html.selectionType.CONTROL;
}
}
return _83d;
}
},isCollapsed:function(){
var _840=dojo.global();
var _841=dojo.doc();
if(_841["selection"]){
return _841.selection.createRange().text=="";
}else{
if(_840["getSelection"]){
var _842=_840.getSelection();
if(dojo.lang.isString(_842)){
return _842=="";
}else{
return _842.isCollapsed||_842.toString()=="";
}
}
}
},getSelectedElement:function(){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
if(dojo.doc()["selection"]){
var _843=dojo.doc().selection.createRange();
if(_843&&_843.item){
return dojo.doc().selection.createRange().item(0);
}
}else{
var _844=dojo.global().getSelection();
return _844.anchorNode.childNodes[_844.anchorOffset];
}
}
},getParentElement:function(){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
var p=dojo.html.selection.getSelectedElement();
if(p){
return p.parentNode;
}
}else{
if(dojo.doc()["selection"]){
return dojo.doc().selection.createRange().parentElement();
}else{
var _846=dojo.global().getSelection();
if(_846){
var node=_846.anchorNode;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.parentNode;
}
return node;
}
}
}
},getSelectedText:function(){
if(dojo.doc()["selection"]){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
return null;
}
return dojo.doc().selection.createRange().text;
}else{
var _848=dojo.global().getSelection();
if(_848){
return _848.toString();
}
}
},getSelectedHtml:function(){
if(dojo.doc()["selection"]){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
return null;
}
return dojo.doc().selection.createRange().htmlText;
}else{
var _849=dojo.global().getSelection();
if(_849&&_849.rangeCount){
var frag=_849.getRangeAt(0).cloneContents();
var div=document.createElement("div");
div.appendChild(frag);
return div.innerHTML;
}
return null;
}
},hasAncestorElement:function(_84c){
return (dojo.html.selection.getAncestorElement.apply(this,arguments)!=null);
},getAncestorElement:function(_84d){
var node=dojo.html.selection.getSelectedElement()||dojo.html.selection.getParentElement();
while(node){
if(dojo.html.selection.isTag(node,arguments).length>0){
return node;
}
node=node.parentNode;
}
return null;
},isTag:function(node,tags){
if(node&&node.tagName){
for(var i=0;i<tags.length;i++){
if(node.tagName.toLowerCase()==String(tags[i]).toLowerCase()){
return String(tags[i]).toLowerCase();
}
}
}
return "";
},selectElement:function(_852){
var _853=dojo.global();
var _854=dojo.doc();
_852=dojo.byId(_852);
if(_854.selection&&dojo.body().createTextRange){
try{
var _855=dojo.body().createControlRange();
_855.addElement(_852);
_855.select();
}
catch(e){
dojo.html.selection.selectElementChildren(_852);
}
}else{
if(_853["getSelection"]){
var _856=_853.getSelection();
if(_856["removeAllRanges"]){
var _855=_854.createRange();
_855.selectNode(_852);
_856.removeAllRanges();
_856.addRange(_855);
}
}
}
},selectElementChildren:function(_857){
var _858=dojo.global();
var _859=dojo.doc();
_857=dojo.byId(_857);
if(_859.selection&&dojo.body().createTextRange){
var _85a=dojo.body().createTextRange();
_85a.moveToElementText(_857);
_85a.select();
}else{
if(_858["getSelection"]){
var _85b=_858.getSelection();
if(_85b["setBaseAndExtent"]){
_85b.setBaseAndExtent(_857,0,_857,_857.innerText.length-1);
}else{
if(_85b["selectAllChildren"]){
_85b.selectAllChildren(_857);
}
}
}
}
},getBookmark:function(){
var _85c;
var _85d=dojo.doc();
if(_85d["selection"]){
var _85e=_85d.selection.createRange();
_85c=_85e.getBookmark();
}else{
var _85f;
try{
_85f=dojo.global().getSelection();
}
catch(e){
}
if(_85f){
var _85e=_85f.getRangeAt(0);
_85c=_85e.cloneRange();
}else{
dojo.debug("No idea how to store the current selection for this browser!");
}
}
return _85c;
},moveToBookmark:function(_860){
var _861=dojo.doc();
if(_861["selection"]){
var _862=_861.selection.createRange();
_862.moveToBookmark(_860);
_862.select();
}else{
var _863;
try{
_863=dojo.global().getSelection();
}
catch(e){
}
if(_863&&_863["removeAllRanges"]){
_863.removeAllRanges();
_863.addRange(_860);
}else{
dojo.debug("No idea how to restore selection for this browser!");
}
}
},collapse:function(_864){
if(dojo.global()["getSelection"]){
var _865=dojo.global().getSelection();
if(_865.removeAllRanges){
if(_864){
_865.collapseToStart();
}else{
_865.collapseToEnd();
}
}else{
dojo.global().getSelection().collapse(_864);
}
}else{
if(dojo.doc().selection){
var _866=dojo.doc().selection.createRange();
_866.collapse(_864);
_866.select();
}
}
},remove:function(){
if(dojo.doc().selection){
var _867=dojo.doc().selection;
if(_867.type.toUpperCase()!="NONE"){
_867.clear();
}
return _867;
}else{
var _867=dojo.global().getSelection();
for(var i=0;i<_867.rangeCount;i++){
_867.getRangeAt(i).deleteContents();
}
return _867;
}
}});
dojo.provide("dojo.Deferred");
dojo.Deferred=function(_869){
this.chain=[];
this.id=this._nextId();
this.fired=-1;
this.paused=0;
this.results=[null,null];
this.canceller=_869;
this.silentlyCancelled=false;
};
dojo.lang.extend(dojo.Deferred,{getFunctionFromArgs:function(){
var a=arguments;
if((a[0])&&(!a[1])){
if(dojo.lang.isFunction(a[0])){
return a[0];
}else{
if(dojo.lang.isString(a[0])){
return dj_global[a[0]];
}
}
}else{
if((a[0])&&(a[1])){
return dojo.lang.hitch(a[0],a[1]);
}
}
return null;
},makeCalled:function(){
var _86b=new dojo.Deferred();
_86b.callback();
return _86b;
},repr:function(){
var _86c;
if(this.fired==-1){
_86c="unfired";
}else{
if(this.fired==0){
_86c="success";
}else{
_86c="error";
}
}
return "Deferred("+this.id+", "+_86c+")";
},toString:dojo.lang.forward("repr"),_nextId:(function(){
var n=1;
return function(){
return n++;
};
})(),cancel:function(){
if(this.fired==-1){
if(this.canceller){
this.canceller(this);
}else{
this.silentlyCancelled=true;
}
if(this.fired==-1){
this.errback(new Error(this.repr()));
}
}else{
if((this.fired==0)&&(this.results[0] instanceof dojo.Deferred)){
this.results[0].cancel();
}
}
},_pause:function(){
this.paused++;
},_unpause:function(){
this.paused--;
if((this.paused==0)&&(this.fired>=0)){
this._fire();
}
},_continue:function(res){
this._resback(res);
this._unpause();
},_resback:function(res){
this.fired=((res instanceof Error)?1:0);
this.results[this.fired]=res;
this._fire();
},_check:function(){
if(this.fired!=-1){
if(!this.silentlyCancelled){
dojo.raise("already called!");
}
this.silentlyCancelled=false;
return;
}
},callback:function(res){
this._check();
this._resback(res);
},errback:function(res){
this._check();
if(!(res instanceof Error)){
res=new Error(res);
}
this._resback(res);
},addBoth:function(cb,cbfn){
var _874=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_874=dojo.lang.curryArguments(null,_874,arguments,2);
}
return this.addCallbacks(_874,_874);
},addCallback:function(cb,cbfn){
var _877=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_877=dojo.lang.curryArguments(null,_877,arguments,2);
}
return this.addCallbacks(_877,null);
},addErrback:function(cb,cbfn){
var _87a=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_87a=dojo.lang.curryArguments(null,_87a,arguments,2);
}
return this.addCallbacks(null,_87a);
return this.addCallbacks(null,cbfn);
},addCallbacks:function(cb,eb){
this.chain.push([cb,eb]);
if(this.fired>=0){
this._fire();
}
return this;
},_fire:function(){
var _87d=this.chain;
var _87e=this.fired;
var res=this.results[_87e];
var self=this;
var cb=null;
while(_87d.length>0&&this.paused==0){
var pair=_87d.shift();
var f=pair[_87e];
if(f==null){
continue;
}
try{
res=f(res);
_87e=((res instanceof Error)?1:0);
if(res instanceof dojo.Deferred){
cb=function(res){
self._continue(res);
};
this._pause();
}
}
catch(err){
_87e=1;
res=err;
}
}
this.fired=_87e;
this.results[_87e]=res;
if((cb)&&(this.paused)){
res.addBoth(cb);
}
}});
dojo.provide("dojo.widget.RichText");
if(!djConfig["useXDomain"]||djConfig["allowXdRichTextSave"]){
if(dojo.hostenv.post_load_){
(function(){
var _885=dojo.doc().createElement("textarea");
_885.id="dojo.widget.RichText.savedContent";
_885.style="display:none;position:absolute;top:-100px;left:-100px;height:3px;width:3px;overflow:hidden;";
dojo.body().appendChild(_885);
})();
}else{
try{
dojo.doc().write("<textarea id=\"dojo.widget.RichText.savedContent\" "+"style=\"display:none;position:absolute;top:-100px;left:-100px;height:3px;width:3px;overflow:hidden;\"></textarea>");
}
catch(e){
}
}
}
dojo.widget.defineWidget("dojo.widget.RichText",dojo.widget.HtmlWidget,function(){
this.contentPreFilters=[];
this.contentPostFilters=[];
this.contentDomPreFilters=[];
this.contentDomPostFilters=[];
this.editingAreaStyleSheets=[];
if(dojo.render.html.moz){
this.contentPreFilters.push(this._fixContentForMoz);
}
this._keyHandlers={};
if(dojo.Deferred){
this.onLoadDeferred=new dojo.Deferred();
}
},{inheritWidth:false,focusOnLoad:false,saveName:"",styleSheets:"",_content:"",height:"",minHeight:"1em",isClosed:true,isLoaded:false,useActiveX:false,relativeImageUrls:false,_SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@",onLoadDeferred:null,fillInTemplate:function(){
dojo.event.topic.publish("dojo.widget.RichText::init",this);
this.open();
dojo.event.connect(this,"onKeyPressed",this,"afterKeyPress");
dojo.event.connect(this,"onKeyPress",this,"keyPress");
dojo.event.connect(this,"onKeyDown",this,"keyDown");
dojo.event.connect(this,"onKeyUp",this,"keyUp");
this.setupDefaultShortcuts();
},setupDefaultShortcuts:function(){
var ctrl=this.KEY_CTRL;
var exec=function(cmd,arg){
return arguments.length==1?function(){
this.execCommand(cmd);
}:function(){
this.execCommand(cmd,arg);
};
};
this.addKeyHandler("b",ctrl,exec("bold"));
this.addKeyHandler("i",ctrl,exec("italic"));
this.addKeyHandler("u",ctrl,exec("underline"));
this.addKeyHandler("a",ctrl,exec("selectall"));
this.addKeyHandler("s",ctrl,function(){
this.save(true);
});
this.addKeyHandler("1",ctrl,exec("formatblock","h1"));
this.addKeyHandler("2",ctrl,exec("formatblock","h2"));
this.addKeyHandler("3",ctrl,exec("formatblock","h3"));
this.addKeyHandler("4",ctrl,exec("formatblock","h4"));
this.addKeyHandler("\\",ctrl,exec("insertunorderedlist"));
if(!dojo.render.html.ie){
this.addKeyHandler("Z",ctrl,exec("redo"));
}
},events:["onBlur","onFocus","onKeyPress","onKeyDown","onKeyUp","onClick"],open:function(_88a){
if(this.onLoadDeferred.fired>=0){
this.onLoadDeferred=new dojo.Deferred();
}
var h=dojo.render.html;
if(!this.isClosed){
this.close();
}
dojo.event.topic.publish("dojo.widget.RichText::open",this);
this._content="";
if((arguments.length==1)&&(_88a["nodeName"])){
this.domNode=_88a;
}
if((this.domNode["nodeName"])&&(this.domNode.nodeName.toLowerCase()=="textarea")){
this.textarea=this.domNode;
var html=this._preFilterContent(this.textarea.value);
this.domNode=dojo.doc().createElement("div");
dojo.html.copyStyle(this.domNode,this.textarea);
var _88d=dojo.lang.hitch(this,function(){
with(this.textarea.style){
display="block";
position="absolute";
left=top="-1000px";
if(h.ie){
this.__overflow=overflow;
overflow="hidden";
}
}
});
if(h.ie){
setTimeout(_88d,10);
}else{
_88d();
}
if(!h.safari){
dojo.html.insertBefore(this.domNode,this.textarea);
}
if(this.textarea.form){
dojo.event.connect("before",this.textarea.form,"onsubmit",dojo.lang.hitch(this,function(){
this.textarea.value=this.getEditorContent();
}));
}
var _88e=this;
dojo.event.connect(this,"postCreate",function(){
dojo.html.insertAfter(_88e.textarea,_88e.domNode);
});
}else{
var html=this._preFilterContent(dojo.string.trim(this.domNode.innerHTML));
}
if(html==""){
html="&nbsp;";
}
var _88f=dojo.html.getContentBox(this.domNode);
this._oldHeight=_88f.height;
this._oldWidth=_88f.width;
this._firstChildContributingMargin=this._getContributingMargin(this.domNode,"top");
this._lastChildContributingMargin=this._getContributingMargin(this.domNode,"bottom");
this.savedContent=html;
this.domNode.innerHTML="";
this.editingArea=dojo.doc().createElement("div");
this.domNode.appendChild(this.editingArea);
if((this.domNode["nodeName"])&&(this.domNode.nodeName=="LI")){
this.domNode.innerHTML=" <br>";
}
if(this.saveName!=""&&(!djConfig["useXDomain"]||djConfig["allowXdRichTextSave"])){
var _890=dojo.doc().getElementById("dojo.widget.RichText.savedContent");
if(_890.value!=""){
var _891=_890.value.split(this._SEPARATOR);
for(var i=0;i<_891.length;i++){
var data=_891[i].split(":");
if(data[0]==this.saveName){
html=data[1];
_891.splice(i,1);
break;
}
}
}
dojo.event.connect("before",window,"onunload",this,"_saveContent");
}
if(h.ie70&&this.useActiveX){
dojo.debug("activeX in ie70 is not currently supported, useActiveX is ignored for now.");
this.useActiveX=false;
}
if(this.useActiveX&&h.ie){
var self=this;
setTimeout(function(){
self._drawObject(html);
},0);
}else{
if(h.ie||this._safariIsLeopard()||h.opera){
this.iframe=dojo.doc().createElement("iframe");
this.iframe.src="javascript:void(0)";
this.editorObject=this.iframe;
with(this.iframe.style){
border="0";
width="100%";
}
this.iframe.frameBorder=0;
this.editingArea.appendChild(this.iframe);
this.window=this.iframe.contentWindow;
this.document=this.window.document;
this.document.open();
this.document.write("<html><head><style>body{margin:0;padding:0;border:0;overflow:hidden;}</style></head><body><div></div></body></html>");
this.document.close();
this.editNode=this.document.body.firstChild;
this.editNode.contentEditable=true;
with(this.iframe.style){
if(h.ie70){
if(this.height){
height=this.height;
}
if(this.minHeight){
minHeight=this.minHeight;
}
}else{
height=this.height?this.height:this.minHeight;
}
}
var _895=["p","pre","address","h1","h2","h3","h4","h5","h6","ol","div","ul"];
var _896="";
for(var i in _895){
if(_895[i].charAt(1)!="l"){
_896+="<"+_895[i]+"><span>content</span></"+_895[i]+">";
}else{
_896+="<"+_895[i]+"><li>content</li></"+_895[i]+">";
}
}
with(this.editNode.style){
position="absolute";
left="-2000px";
top="-2000px";
}
this.editNode.innerHTML=_896;
var node=this.editNode.firstChild;
while(node){
dojo.withGlobal(this.window,"selectElement",dojo.html.selection,[node.firstChild]);
var _898=node.tagName.toLowerCase();
this._local2NativeFormatNames[_898]=this.queryCommandValue("formatblock");
this._native2LocalFormatNames[this._local2NativeFormatNames[_898]]=_898;
node=node.nextSibling;
}
with(this.editNode.style){
position="";
left="";
top="";
}
this.editNode.innerHTML=html;
if(this.height){
this.document.body.style.overflowY="scroll";
}
dojo.lang.forEach(this.events,function(e){
dojo.event.connect(this.editNode,e.toLowerCase(),this,e);
},this);
this.onLoad();
}else{
this._drawIframe(html);
this.editorObject=this.iframe;
}
}
if(this.domNode.nodeName=="LI"){
this.domNode.lastChild.style.marginTop="-1.2em";
}
dojo.html.addClass(this.domNode,"RichTextEditable");
this.isClosed=false;
},_hasCollapseableMargin:function(_89a,side){
if(dojo.html.getPixelValue(_89a,"border-"+side+"-width",false)){
return false;
}else{
if(dojo.html.getPixelValue(_89a,"padding-"+side,false)){
return false;
}else{
return true;
}
}
},_getContributingMargin:function(_89c,_89d){
if(_89d=="top"){
var _89e="previousSibling";
var _89f="nextSibling";
var _8a0="firstChild";
var _8a1="margin-top";
var _8a2="margin-bottom";
}else{
var _89e="nextSibling";
var _89f="previousSibling";
var _8a0="lastChild";
var _8a1="margin-bottom";
var _8a2="margin-top";
}
var _8a3=dojo.html.getPixelValue(_89c,_8a1,false);
function isSignificantNode(_8a4){
return !(_8a4.nodeType==3&&dojo.string.isBlank(_8a4.data))&&dojo.html.getStyle(_8a4,"display")!="none"&&!dojo.html.isPositionAbsolute(_8a4);
}
var _8a5=0;
var _8a6=_89c[_8a0];
while(_8a6){
while((!isSignificantNode(_8a6))&&_8a6[_89f]){
_8a6=_8a6[_89f];
}
_8a5=Math.max(_8a5,dojo.html.getPixelValue(_8a6,_8a1,false));
if(!this._hasCollapseableMargin(_8a6,_89d)){
break;
}
_8a6=_8a6[_8a0];
}
if(!this._hasCollapseableMargin(_89c,_89d)){
return parseInt(_8a5);
}
var _8a7=0;
var _8a8=_89c[_89e];
while(_8a8){
if(isSignificantNode(_8a8)){
_8a7=dojo.html.getPixelValue(_8a8,_8a2,false);
break;
}
_8a8=_8a8[_89e];
}
if(!_8a8){
_8a7=dojo.html.getPixelValue(_89c.parentNode,_8a1,false);
}
if(_8a5>_8a3){
return parseInt(Math.max((_8a5-_8a3)-_8a7,0));
}else{
return 0;
}
},_drawIframe:function(html){
var _8aa=Boolean(dojo.render.html.moz&&(typeof window.XML=="undefined"));
if(!this.iframe){
var _8ab=(new dojo.uri.Uri(dojo.doc().location)).host;
this.iframe=dojo.doc().createElement("iframe");
with(this.iframe){
style.border="none";
style.lineHeight="0";
style.verticalAlign="bottom";
scrolling=this.height?"auto":"no";
}
}
if(djConfig["useXDomain"]&&!djConfig["dojoRichTextFrameUrl"]){
dojo.debug("dojo.widget.RichText: When using cross-domain Dojo builds,"+" please save src/widget/templates/richtextframe.html to your domain and set djConfig.dojoRichTextFrameUrl"+" to the path on your domain to richtextframe.html");
}
this.iframe.src=(djConfig["dojoRichTextFrameUrl"]||dojo.uri.moduleUri("dojo.widget","templates/richtextframe.html"))+((dojo.doc().domain!=_8ab)?("#"+dojo.doc().domain):"");
this.iframe.width=this.inheritWidth?this._oldWidth:"100%";
if(this.height){
this.iframe.style.height=this.height;
}else{
var _8ac=this._oldHeight;
if(this._hasCollapseableMargin(this.domNode,"top")){
_8ac+=this._firstChildContributingMargin;
}
if(this._hasCollapseableMargin(this.domNode,"bottom")){
_8ac+=this._lastChildContributingMargin;
}
this.iframe.height=_8ac;
}
var _8ad=dojo.doc().createElement("div");
_8ad.innerHTML=html;
this.editingArea.appendChild(_8ad);
if(this.relativeImageUrls){
var imgs=_8ad.getElementsByTagName("img");
for(var i=0;i<imgs.length;i++){
imgs[i].src=(new dojo.uri.Uri(dojo.global().location,imgs[i].src)).toString();
}
html=_8ad.innerHTML;
}
var _8b0=dojo.html.firstElement(_8ad);
var _8b1=dojo.html.lastElement(_8ad);
if(_8b0){
_8b0.style.marginTop=this._firstChildContributingMargin+"px";
}
if(_8b1){
_8b1.style.marginBottom=this._lastChildContributingMargin+"px";
}
this.editingArea.appendChild(this.iframe);
if(dojo.render.html.safari){
this.iframe.src=this.iframe.src;
}
var _8b2=false;
var _8b3=dojo.lang.hitch(this,function(){
if(!_8b2){
_8b2=true;
}else{
return;
}
if(!this.editNode){
if(this.iframe.contentWindow){
this.window=this.iframe.contentWindow;
this.document=this.iframe.contentWindow.document;
}else{
if(this.iframe.contentDocument){
this.window=this.iframe.contentDocument.window;
this.document=this.iframe.contentDocument;
}
}
var _8b4=(function(_8b5){
return function(_8b6){
return dojo.html.getStyle(_8b5,_8b6);
};
})(this.domNode);
var font=_8b4("font-weight")+" "+_8b4("font-size")+" "+_8b4("font-family");
var _8b8="1.0";
var _8b9=dojo.html.getUnitValue(this.domNode,"line-height");
if(_8b9.value&&_8b9.units==""){
_8b8=_8b9.value;
}
dojo.html.insertCssText("body,html{background:transparent;padding:0;margin:0;}"+"body{top:0;left:0;right:0;"+(((this.height)||(dojo.render.html.opera))?"":"position:fixed;")+"font:"+font+";"+"min-height:"+this.minHeight+";"+"line-height:"+_8b8+"}"+"p{margin: 1em 0 !important;}"+"body > *:first-child{padding-top:0 !important;margin-top:"+this._firstChildContributingMargin+"px !important;}"+"body > *:last-child{padding-bottom:0 !important;margin-bottom:"+this._lastChildContributingMargin+"px !important;}"+"li > ul:-moz-first-node, li > ol:-moz-first-node{padding-top:1.2em;}\n"+"li{min-height:1.2em;}"+"",this.document);
dojo.html.removeNode(_8ad);
this.document.body.innerHTML=html;
if(_8aa||dojo.render.html.safari){
this.document.designMode="on";
}
this.onLoad();
}else{
dojo.html.removeNode(_8ad);
this.editNode.innerHTML=html;
this.onDisplayChanged();
}
});
if(this.editNode){
_8b3();
}else{
if(dojo.render.html.moz){
this.iframe.onload=function(){
setTimeout(_8b3,250);
};
}else{
this.iframe.onload=_8b3;
}
}
},_applyEditingAreaStyleSheets:function(){
var _8ba=[];
if(this.styleSheets){
_8ba=this.styleSheets.split(";");
this.styleSheets="";
}
_8ba=_8ba.concat(this.editingAreaStyleSheets);
this.editingAreaStyleSheets=[];
if(_8ba.length>0){
for(var i=0;i<_8ba.length;i++){
var url=_8ba[i];
if(url){
this.addStyleSheet(dojo.uri.dojoUri(url));
}
}
}
},addStyleSheet:function(uri){
var url=uri.toString();
if(dojo.lang.find(this.editingAreaStyleSheets,url)>-1){
dojo.debug("dojo.widget.RichText.addStyleSheet: Style sheet "+url+" is already applied to the editing area!");
return;
}
if(url.charAt(0)=="."||(url.charAt(0)!="/"&&!uri.host)){
url=(new dojo.uri.Uri(dojo.global().location,url)).toString();
}
this.editingAreaStyleSheets.push(url);
if(this.document.createStyleSheet){
this.document.createStyleSheet(url);
}else{
var head=this.document.getElementsByTagName("head")[0];
var _8c0=this.document.createElement("link");
with(_8c0){
rel="stylesheet";
type="text/css";
href=url;
}
head.appendChild(_8c0);
}
},removeStyleSheet:function(uri){
var url=uri.toString();
if(url.charAt(0)=="."||(url.charAt(0)!="/"&&!uri.host)){
url=(new dojo.uri.Uri(dojo.global().location,url)).toString();
}
var _8c3=dojo.lang.find(this.editingAreaStyleSheets,url);
if(_8c3==-1){
dojo.debug("dojo.widget.RichText.removeStyleSheet: Style sheet "+url+" is not applied to the editing area so it can not be removed!");
return;
}
delete this.editingAreaStyleSheets[_8c3];
var _8c4=this.document.getElementsByTagName("link");
for(var i=0;i<_8c4.length;i++){
if(_8c4[i].href==url){
if(dojo.render.html.ie){
_8c4[i].href="";
}
dojo.html.removeNode(_8c4[i]);
break;
}
}
},_drawObject:function(html){
this.object=dojo.html.createExternalElement(dojo.doc(),"object");
with(this.object){
classid="clsid:2D360201-FFF5-11D1-8D03-00A0C959BC0A";
width=this.inheritWidth?this._oldWidth:"100%";
style.height=this.height?this.height:(this._oldHeight+"px");
Scrollbars=this.height?true:false;
Appearance=this._activeX.appearance.flat;
}
this.editorObject=this.object;
this.editingArea.appendChild(this.object);
this.object.attachEvent("DocumentComplete",dojo.lang.hitch(this,"onLoad"));
dojo.lang.forEach(this.events,function(e){
this.object.attachEvent(e.toLowerCase(),dojo.lang.hitch(this,e));
},this);
this.object.DocumentHTML="<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">"+"<html><title></title>"+"<style type=\"text/css\">"+"    body,html { padding: 0; margin: 0; }"+(this.height?"":"    body,  { overflow: hidden; }")+"</style>"+"<body><div>"+html+"<div></body></html>";
this._cacheLocalBlockFormatNames();
},_local2NativeFormatNames:{},_native2LocalFormatNames:{},_cacheLocalBlockFormatNames:function(){
if(!this._native2LocalFormatNames["p"]){
var obj=this.object;
var _8c9=false;
if(!obj){
try{
obj=dojo.html.createExternalElement(dojo.doc(),"object");
obj.classid="clsid:2D360201-FFF5-11D1-8D03-00A0C959BC0A";
dojo.body().appendChild(obj);
obj.DocumentHTML="<html><head></head><body></body></html>";
}
catch(e){
_8c9=true;
}
}
try{
var _8ca=new ActiveXObject("DEGetBlockFmtNamesParam.DEGetBlockFmtNamesParam");
obj.ExecCommand(this._activeX.command["getblockformatnames"],0,_8ca);
var _8cb=new VBArray(_8ca.Names);
var _8cc=_8cb.toArray();
var _8cd=["p","pre","address","h1","h2","h3","h4","h5","h6","ol","ul","","","","","div"];
for(var i=0;i<_8cd.length;++i){
if(_8cd[i].length>0){
this._local2NativeFormatNames[_8cc[i]]=_8cd[i];
this._native2LocalFormatNames[_8cd[i]]=_8cc[i];
}
}
}
catch(e){
_8c9=true;
}
if(obj&&!this.object){
dojo.body().removeChild(obj);
}
}
return !_8c9;
},_isResized:function(){
return false;
},onLoad:function(e){
this.isLoaded=true;
if(this.object){
this.document=this.object.DOM;
this.window=this.document.parentWindow;
this.editNode=this.document.body.firstChild;
this.editingArea.style.height=this.height?this.height:this.minHeight;
if(!this.height){
this.connect(this,"onDisplayChanged","_updateHeight");
}
this.window._frameElement=this.object;
}else{
if(this.iframe&&!dojo.render.html.ie){
this.editNode=this.document.body;
if(!this.height){
this.connect(this,"onDisplayChanged","_updateHeight");
}
try{
this.document.execCommand("useCSS",false,true);
this.document.execCommand("styleWithCSS",false,false);
}
catch(e2){
}
if(dojo.render.html.safari){
this.connect(this.editNode,"onblur","onBlur");
this.connect(this.editNode,"onfocus","onFocus");
this.connect(this.editNode,"onclick","onFocus");
this.interval=setInterval(dojo.lang.hitch(this,"onDisplayChanged"),750);
}else{
if(dojo.render.html.mozilla||dojo.render.html.opera){
var doc=this.document;
var _8d1=dojo.event.browser.addListener;
var self=this;
dojo.lang.forEach(this.events,function(e){
var l=_8d1(self.document,e.substr(2).toLowerCase(),dojo.lang.hitch(self,e));
if(e=="onBlur"){
var _8d5={unBlur:function(e){
dojo.event.browser.removeListener(doc,"blur",l);
}};
dojo.event.connect("before",self,"close",_8d5,"unBlur");
}
});
}
}
}else{
if(dojo.render.html.ie){
if(!this.height){
this.connect(this,"onDisplayChanged","_updateHeight");
}
this.editNode.style.zoom=1;
}
}
}
this._applyEditingAreaStyleSheets();
if(this.focusOnLoad){
this.focus();
}
this.onDisplayChanged(e);
if(this.onLoadDeferred){
this.onLoadDeferred.callback(true);
}
},onKeyDown:function(e){
if((!e)&&(this.object)){
e=dojo.event.browser.fixEvent(this.window.event);
}
if((dojo.render.html.ie)&&(e.keyCode==e.KEY_TAB)){
e.preventDefault();
e.stopPropagation();
this.execCommand((e.shiftKey?"outdent":"indent"));
}else{
if(dojo.render.html.ie){
if((65<=e.keyCode)&&(e.keyCode<=90)){
e.charCode=e.keyCode;
this.onKeyPress(e);
}
}
}
},onKeyUp:function(e){
return;
},KEY_CTRL:1,onKeyPress:function(e){
if((!e)&&(this.object)){
e=dojo.event.browser.fixEvent(this.window.event);
}
var _8da=e.ctrlKey?this.KEY_CTRL:0;
if(this._keyHandlers[e.key]){
var _8db=this._keyHandlers[e.key],i=0,_8dd;
while(_8dd=_8db[i++]){
if(_8da==_8dd.modifiers){
e.preventDefault();
_8dd.handler.call(this);
break;
}
}
}
dojo.lang.setTimeout(this,this.onKeyPressed,1,e);
},addKeyHandler:function(key,_8df,_8e0){
if(!(this._keyHandlers[key] instanceof Array)){
this._keyHandlers[key]=[];
}
this._keyHandlers[key].push({modifiers:_8df||0,handler:_8e0});
},onKeyPressed:function(e){
this.onDisplayChanged();
},onClick:function(e){
this.onDisplayChanged(e);
},onBlur:function(e){
},_initialFocus:true,onFocus:function(e){
if((dojo.render.html.mozilla)&&(this._initialFocus)){
this._initialFocus=false;
if(dojo.string.trim(this.editNode.innerHTML)=="&nbsp;"){
this.placeCursorAtStart();
}
}
},blur:function(){
if(this.iframe){
this.window.blur();
}else{
if(this.object){
this.document.body.blur();
}else{
if(this.editNode){
this.editNode.blur();
}
}
}
},focus:function(){
if(this.iframe&&!dojo.render.html.ie){
this.window.focus();
}else{
if(this.object){
this.document.focus();
}else{
if(this.editNode&&this.editNode.focus){
this.editNode.focus();
}else{
dojo.debug("Have no idea how to focus into the editor!");
}
}
}
},onDisplayChanged:function(e){
},_activeX:{command:{bold:5000,italic:5023,underline:5048,justifycenter:5024,justifyleft:5025,justifyright:5026,cut:5003,copy:5002,paste:5032,"delete":5004,undo:5049,redo:5033,removeformat:5034,selectall:5035,unlink:5050,indent:5018,outdent:5031,insertorderedlist:5030,insertunorderedlist:5051,inserttable:5022,insertcell:5019,insertcol:5020,insertrow:5021,deletecells:5005,deletecols:5006,deleterows:5007,mergecells:5029,splitcell:5047,setblockformat:5043,getblockformat:5011,getblockformatnames:5012,setfontname:5044,getfontname:5013,setfontsize:5045,getfontsize:5014,setbackcolor:5042,getbackcolor:5010,setforecolor:5046,getforecolor:5015,findtext:5008,font:5009,hyperlink:5016,image:5017,lockelement:5027,makeabsolute:5028,sendbackward:5036,bringforward:5037,sendbelowtext:5038,bringabovetext:5039,sendtoback:5040,bringtofront:5041,properties:5052},ui:{"default":0,prompt:1,noprompt:2},status:{notsupported:0,disabled:1,enabled:3,latched:7,ninched:11},appearance:{flat:0,inset:1},state:{unchecked:0,checked:1,gray:2}},_normalizeCommand:function(cmd){
var drh=dojo.render.html;
var _8e8=cmd.toLowerCase();
if(_8e8=="formatblock"){
if(drh.safari){
_8e8="heading";
}
}else{
if(this.object){
switch(_8e8){
case "createlink":
_8e8="hyperlink";
break;
case "insertimage":
_8e8="image";
break;
}
}else{
if(_8e8=="hilitecolor"&&!drh.mozilla){
_8e8="backcolor";
}
}
}
return _8e8;
},_safariIsLeopard:function(){
var _8e9=false;
if(dojo.render.html.safari){
var tmp=dojo.render.html.UA.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
_8e9=true;
}
}
return _8e9;
},queryCommandAvailable:function(_8ec){
var ie=1;
var _8ee=1<<1;
var _8ef=1<<2;
var _8f0=1<<3;
var _8f1=1<<4;
var _8f2=this._safariIsLeopard();
function isSupportedBy(_8f3){
return {ie:Boolean(_8f3&ie),mozilla:Boolean(_8f3&_8ee),safari:Boolean(_8f3&_8ef),safari420:Boolean(_8f3&_8f1),opera:Boolean(_8f3&_8f0)};
}
var _8f4=null;
switch(_8ec.toLowerCase()){
case "bold":
case "italic":
case "underline":
case "subscript":
case "superscript":
case "fontname":
case "fontsize":
case "forecolor":
case "hilitecolor":
case "justifycenter":
case "justifyfull":
case "justifyleft":
case "justifyright":
case "delete":
case "selectall":
_8f4=isSupportedBy(_8ee|ie|_8ef|_8f0);
break;
case "createlink":
case "unlink":
case "removeformat":
case "inserthorizontalrule":
case "insertimage":
case "insertorderedlist":
case "insertunorderedlist":
case "indent":
case "outdent":
case "formatblock":
case "inserthtml":
case "undo":
case "redo":
case "strikethrough":
_8f4=isSupportedBy(_8ee|ie|_8f0|_8f1);
break;
case "blockdirltr":
case "blockdirrtl":
case "dirltr":
case "dirrtl":
case "inlinedirltr":
case "inlinedirrtl":
_8f4=isSupportedBy(ie);
break;
case "cut":
case "copy":
case "paste":
_8f4=isSupportedBy(ie|_8ee|_8f1);
break;
case "inserttable":
_8f4=isSupportedBy(_8ee|(this.object?ie:0));
break;
case "insertcell":
case "insertcol":
case "insertrow":
case "deletecells":
case "deletecols":
case "deleterows":
case "mergecells":
case "splitcell":
_8f4=isSupportedBy(this.object?ie:0);
break;
default:
return false;
}
return (dojo.render.html.ie&&_8f4.ie)||(dojo.render.html.mozilla&&_8f4.mozilla)||(dojo.render.html.safari&&_8f4.safari)||(_8f2&&_8f4.safari420)||(dojo.render.html.opera&&_8f4.opera);
},execCommand:function(_8f5,_8f6){
var _8f7;
this.focus();
_8f5=this._normalizeCommand(_8f5);
if(_8f6!=undefined){
if(_8f5=="heading"){
throw new Error("unimplemented");
}else{
if(_8f5=="formatblock"){
if(this.object){
_8f6=this._native2LocalFormatNames[_8f6];
}else{
if(dojo.render.html.ie){
_8f6="<"+_8f6+">";
}
}
}
}
}
if(this.object){
switch(_8f5){
case "hilitecolor":
_8f5="setbackcolor";
break;
case "forecolor":
case "backcolor":
case "fontsize":
case "fontname":
_8f5="set"+_8f5;
break;
case "formatblock":
_8f5="setblockformat";
}
if(_8f5=="strikethrough"){
_8f5="inserthtml";
var _8f8=this.document.selection.createRange();
if(!_8f8.htmlText){
return;
}
_8f6=_8f8.htmlText.strike();
}else{
if(_8f5=="inserthorizontalrule"){
_8f5="inserthtml";
_8f6="<hr>";
}
}
if(_8f5=="inserthtml"){
var _8f8=this.document.selection.createRange();
if(this.document.selection.type.toUpperCase()=="CONTROL"){
for(var i=0;i<_8f8.length;i++){
_8f8.item(i).outerHTML=_8f6;
}
}else{
_8f8.pasteHTML(_8f6);
_8f8.select();
}
_8f7=true;
}else{
if(arguments.length==1){
_8f7=this.object.ExecCommand(this._activeX.command[_8f5],this._activeX.ui.noprompt);
}else{
_8f7=this.object.ExecCommand(this._activeX.command[_8f5],this._activeX.ui.noprompt,_8f6);
}
}
}else{
if(_8f5=="inserthtml"){
if(dojo.render.html.ie){
var _8fa=this.document.selection.createRange();
_8fa.pasteHTML(_8f6);
_8fa.select();
return true;
}else{
return this.document.execCommand(_8f5,false,_8f6);
}
}else{
if((_8f5=="unlink")&&(this.queryCommandEnabled("unlink"))&&(dojo.render.html.mozilla)){
var _8fb=this.window.getSelection();
var _8fc=_8fb.getRangeAt(0);
var _8fd=_8fc.startContainer;
var _8fe=_8fc.startOffset;
var _8ff=_8fc.endContainer;
var _900=_8fc.endOffset;
var a=dojo.withGlobal(this.window,"getAncestorElement",dojo.html.selection,["a"]);
dojo.withGlobal(this.window,"selectElement",dojo.html.selection,[a]);
_8f7=this.document.execCommand("unlink",false,null);
var _8fc=this.document.createRange();
_8fc.setStart(_8fd,_8fe);
_8fc.setEnd(_8ff,_900);
_8fb.removeAllRanges();
_8fb.addRange(_8fc);
return _8f7;
}else{
if((_8f5=="hilitecolor")&&(dojo.render.html.mozilla)){
this.document.execCommand("useCSS",false,false);
_8f7=this.document.execCommand(_8f5,false,_8f6);
this.document.execCommand("useCSS",false,true);
}else{
if((dojo.render.html.ie)&&((_8f5=="backcolor")||(_8f5=="forecolor"))){
_8f6=arguments.length>1?_8f6:null;
_8f7=this.document.execCommand(_8f5,false,_8f6);
}else{
_8f6=arguments.length>1?_8f6:null;
if(_8f6||_8f5!="createlink"){
_8f7=this.document.execCommand(_8f5,false,_8f6);
}
}
}
}
}
}
this.onDisplayChanged();
return _8f7;
},queryCommandEnabled:function(_902){
_902=this._normalizeCommand(_902);
if(this.object){
switch(_902){
case "hilitecolor":
_902="setbackcolor";
break;
case "forecolor":
case "backcolor":
case "fontsize":
case "fontname":
_902="set"+_902;
break;
case "formatblock":
_902="setblockformat";
break;
case "strikethrough":
_902="bold";
break;
case "inserthorizontalrule":
return true;
}
if(typeof this._activeX.command[_902]=="undefined"){
return false;
}
var _903=this.object.QueryStatus(this._activeX.command[_902]);
return ((_903!=this._activeX.status.notsupported)&&(_903!=this._activeX.status.disabled));
}else{
if(dojo.render.html.mozilla){
if(_902=="unlink"){
return dojo.withGlobal(this.window,"hasAncestorElement",dojo.html.selection,["a"]);
}else{
if(_902=="inserttable"){
return true;
}
}
}
var elem=(dojo.render.html.ie)?this.document.selection.createRange():this.document;
return elem.queryCommandEnabled(_902);
}
},queryCommandState:function(_905){
_905=this._normalizeCommand(_905);
if(this.object){
if(_905=="forecolor"){
_905="setforecolor";
}else{
if(_905=="backcolor"){
_905="setbackcolor";
}else{
if(_905=="strikethrough"){
return dojo.withGlobal(this.window,"hasAncestorElement",dojo.html.selection,["strike"]);
}else{
if(_905=="inserthorizontalrule"){
return false;
}
}
}
}
if(typeof this._activeX.command[_905]=="undefined"){
return null;
}
var _906=this.object.QueryStatus(this._activeX.command[_905]);
return ((_906==this._activeX.status.latched)||(_906==this._activeX.status.ninched));
}else{
return this.document.queryCommandState(_905);
}
},queryCommandValue:function(_907){
_907=this._normalizeCommand(_907);
if(this.object){
switch(_907){
case "forecolor":
case "backcolor":
case "fontsize":
case "fontname":
_907="get"+_907;
return this.object.execCommand(this._activeX.command[_907],this._activeX.ui.noprompt);
case "formatblock":
var _908=this.object.execCommand(this._activeX.command["getblockformat"],this._activeX.ui.noprompt);
if(_908){
return this._local2NativeFormatNames[_908];
}
}
}else{
if(dojo.render.html.ie&&_907=="formatblock"){
return this._local2NativeFormatNames[this.document.queryCommandValue(_907)]||this.document.queryCommandValue(_907);
}
return this.document.queryCommandValue(_907);
}
},placeCursorAtStart:function(){
this.focus();
if(dojo.render.html.moz&&this.editNode.firstChild&&this.editNode.firstChild.nodeType!=dojo.dom.TEXT_NODE){
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode.firstChild]);
}else{
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode]);
}
dojo.withGlobal(this.window,"collapse",dojo.html.selection,[true]);
},placeCursorAtEnd:function(){
this.focus();
if(dojo.render.html.moz&&this.editNode.lastChild&&this.editNode.lastChild.nodeType!=dojo.dom.TEXT_NODE){
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode.lastChild]);
}else{
dojo.withGlobal(this.window,"selectElementChildren",dojo.html.selection,[this.editNode]);
}
dojo.withGlobal(this.window,"collapse",dojo.html.selection,[false]);
},replaceEditorContent:function(html){
html=this._preFilterContent(html);
if(this.isClosed){
this.domNode.innerHTML=html;
}else{
if(this.window&&this.window.getSelection&&!dojo.render.html.moz){
this.editNode.innerHTML=html;
}else{
if((this.window&&this.window.getSelection)||(this.document&&this.document.selection)){
this.execCommand("selectall");
if(dojo.render.html.moz&&!html){
html="&nbsp;";
}
this.execCommand("inserthtml",html);
}
}
}
},_preFilterContent:function(html){
var ec=html;
dojo.lang.forEach(this.contentPreFilters,function(ef){
ec=ef(ec);
});
if(this.contentDomPreFilters.length>0){
var dom=dojo.doc().createElement("div");
dom.style.display="none";
dojo.body().appendChild(dom);
dom.innerHTML=ec;
dojo.lang.forEach(this.contentDomPreFilters,function(ef){
dom=ef(dom);
});
ec=dom.innerHTML;
dojo.body().removeChild(dom);
}
return ec;
},_postFilterContent:function(html){
var ec=html;
if(this.contentDomPostFilters.length>0){
var dom=this.document.createElement("div");
dom.innerHTML=ec;
dojo.lang.forEach(this.contentDomPostFilters,function(ef){
dom=ef(dom);
});
ec=dom.innerHTML;
}
dojo.lang.forEach(this.contentPostFilters,function(ef){
ec=ef(ec);
});
return ec;
},_lastHeight:0,_updateHeight:function(){
if(!this.isLoaded){
return;
}
if(this.height){
return;
}
var _914=dojo.html.getBorderBox(this.editNode).height;
if(!_914){
_914=dojo.html.getBorderBox(this.document.body).height;
}
if(_914==0){
dojo.debug("Can not figure out the height of the editing area!");
return;
}
this._lastHeight=_914;
this.editorObject.style.height=this._lastHeight+"px";
this.window.scrollTo(0,0);
},_saveContent:function(e){
var _916=dojo.doc().getElementById("dojo.widget.RichText.savedContent");
_916.value+=this._SEPARATOR+this.saveName+":"+this.getEditorContent();
},getEditorContent:function(){
var ec="";
try{
ec=(this._content.length>0)?this._content:this.editNode.innerHTML;
if(dojo.string.trim(ec)=="&nbsp;"){
ec="";
}
}
catch(e){
}
if(dojo.render.html.ie&&!this.object){
var re=new RegExp("(?:<p>&nbsp;</p>[\n\r]*)+$","i");
ec=ec.replace(re,"");
}
ec=this._postFilterContent(ec);
if(this.relativeImageUrls){
var _919=dojo.global().location.protocol+"//"+dojo.global().location.host;
var _91a=dojo.global().location.pathname;
if(_91a.match(/\/$/)){
}else{
var _91b=_91a.split("/");
if(_91b.length){
_91b.pop();
}
_91a=_91b.join("/")+"/";
}
var _91c=new RegExp("(<img[^>]* src=[\"'])("+_919+"("+_91a+")?)","ig");
ec=ec.replace(_91c,"$1");
}
return ec;
},close:function(save,_91e){
if(this.isClosed){
return false;
}
if(arguments.length==0){
save=true;
}
this._content=this._postFilterContent(this.editNode.innerHTML);
var _91f=(this.savedContent!=this._content);
if(this.interval){
clearInterval(this.interval);
}
if(dojo.render.html.ie&&!this.object){
dojo.event.browser.clean(this.editNode);
}
if(this.iframe){
delete this.iframe;
}
if(this.textarea){
with(this.textarea.style){
position="";
left=top="";
if(dojo.render.html.ie){
overflow=this.__overflow;
this.__overflow=null;
}
}
if(save){
this.textarea.value=this._content;
}else{
this.textarea.value=this.savedContent;
}
dojo.html.removeNode(this.domNode);
this.domNode=this.textarea;
}else{
if(save){
if(dojo.render.html.moz){
var nc=dojo.doc().createElement("span");
this.domNode.appendChild(nc);
nc.innerHTML=this.editNode.innerHTML;
}else{
this.domNode.innerHTML=this._content;
}
}else{
this.domNode.innerHTML=this.savedContent;
}
}
dojo.html.removeClass(this.domNode,"RichTextEditable");
this.isClosed=true;
this.isLoaded=false;
delete this.editNode;
if(this.window._frameElement){
this.window._frameElement=null;
}
this.window=null;
this.document=null;
this.object=null;
this.editingArea=null;
this.editorObject=null;
return _91f;
},destroyRendering:function(){
},destroy:function(){
this.destroyRendering();
if(!this.isClosed){
this.close(false);
}
dojo.widget.RichText.superclass.destroy.call(this);
},connect:function(_921,_922,_923){
dojo.event.connect(_921,_922,this,_923);
},disconnect:function(_924,_925,_926){
dojo.event.disconnect(_924,_925,this,_926);
},disconnectAllWithRoot:function(_927){
dojo.deprecated("disconnectAllWithRoot","is deprecated. No need to disconnect manually","0.5");
},_fixContentForMoz:function(html){
html=html.replace(/<strong([ \>])/gi,"<b$1");
html=html.replace(/<\/strong>/gi,"</b>");
html=html.replace(/<em([ \>])/gi,"<i$1");
html=html.replace(/<\/em>/gi,"</i>");
return html;
}});
dojo.provide("dojo.lang.type");
dojo.lang.whatAmI=function(_929){
dojo.deprecated("dojo.lang.whatAmI","use dojo.lang.getType instead","0.5");
return dojo.lang.getType(_929);
};
dojo.lang.whatAmI.custom={};
dojo.lang.getType=function(_92a){
try{
if(dojo.lang.isArray(_92a)){
return "array";
}
if(dojo.lang.isFunction(_92a)){
return "function";
}
if(dojo.lang.isString(_92a)){
return "string";
}
if(dojo.lang.isNumber(_92a)){
return "number";
}
if(dojo.lang.isBoolean(_92a)){
return "boolean";
}
if(dojo.lang.isAlien(_92a)){
return "alien";
}
if(dojo.lang.isUndefined(_92a)){
return "undefined";
}
for(var name in dojo.lang.whatAmI.custom){
if(dojo.lang.whatAmI.custom[name](_92a)){
return name;
}
}
if(dojo.lang.isObject(_92a)){
return "object";
}
}
catch(e){
}
return "unknown";
};
dojo.lang.isNumeric=function(_92c){
return (!isNaN(_92c)&&isFinite(_92c)&&(_92c!=null)&&!dojo.lang.isBoolean(_92c)&&!dojo.lang.isArray(_92c)&&!/^\s*$/.test(_92c));
};
dojo.lang.isBuiltIn=function(_92d){
return (dojo.lang.isArray(_92d)||dojo.lang.isFunction(_92d)||dojo.lang.isString(_92d)||dojo.lang.isNumber(_92d)||dojo.lang.isBoolean(_92d)||(_92d==null)||(_92d instanceof Error)||(typeof _92d=="error"));
};
dojo.lang.isPureObject=function(_92e){
return ((_92e!=null)&&dojo.lang.isObject(_92e)&&_92e.constructor==Object);
};
dojo.lang.isOfType=function(_92f,type,_931){
var _932=false;
if(_931){
_932=_931["optional"];
}
if(_932&&((_92f===null)||dojo.lang.isUndefined(_92f))){
return true;
}
if(dojo.lang.isArray(type)){
var _933=type;
for(var i in _933){
var _935=_933[i];
if(dojo.lang.isOfType(_92f,_935)){
return true;
}
}
return false;
}else{
if(dojo.lang.isString(type)){
type=type.toLowerCase();
}
switch(type){
case Array:
case "array":
return dojo.lang.isArray(_92f);
case Function:
case "function":
return dojo.lang.isFunction(_92f);
case String:
case "string":
return dojo.lang.isString(_92f);
case Number:
case "number":
return dojo.lang.isNumber(_92f);
case "numeric":
return dojo.lang.isNumeric(_92f);
case Boolean:
case "boolean":
return dojo.lang.isBoolean(_92f);
case Object:
case "object":
return dojo.lang.isObject(_92f);
case "pureobject":
return dojo.lang.isPureObject(_92f);
case "builtin":
return dojo.lang.isBuiltIn(_92f);
case "alien":
return dojo.lang.isAlien(_92f);
case "undefined":
return dojo.lang.isUndefined(_92f);
case null:
case "null":
return (_92f===null);
case "optional":
dojo.deprecated("dojo.lang.isOfType(value, [type, \"optional\"])","use dojo.lang.isOfType(value, type, {optional: true} ) instead","0.5");
return ((_92f===null)||dojo.lang.isUndefined(_92f));
default:
if(dojo.lang.isFunction(type)){
return (_92f instanceof type);
}else{
dojo.raise("dojo.lang.isOfType() was passed an invalid type");
}
}
}
dojo.raise("If we get here, it means a bug was introduced above.");
};
dojo.lang.getObject=function(str){
var _937=str.split("."),i=0,obj=dj_global;
do{
obj=obj[_937[i++]];
}while(i<_937.length&&obj);
return (obj!=dj_global)?obj:null;
};
dojo.lang.doesObjectExist=function(str){
var _93b=str.split("."),i=0,obj=dj_global;
do{
obj=obj[_93b[i++]];
}while(i<_93b.length&&obj);
return (obj&&obj!=dj_global);
};
dojo.provide("dojo.lang.assert");
dojo.lang.assert=function(_93e,_93f){
if(!_93e){
var _940="An assert statement failed.\n"+"The method dojo.lang.assert() was called with a 'false' value.\n";
if(_93f){
_940+="Here's the assert message:\n"+_93f+"\n";
}
throw new Error(_940);
}
};
dojo.lang.assertType=function(_941,type,_943){
if(dojo.lang.isString(_943)){
dojo.deprecated("dojo.lang.assertType(value, type, \"message\")","use dojo.lang.assertType(value, type) instead","0.5");
}
if(!dojo.lang.isOfType(_941,type,_943)){
if(!dojo.lang.assertType._errorMessage){
dojo.lang.assertType._errorMessage="Type mismatch: dojo.lang.assertType() failed.";
}
dojo.lang.assert(false,dojo.lang.assertType._errorMessage);
}
};
dojo.lang.assertValidKeywords=function(_944,_945,_946){
var key;
if(!_946){
if(!dojo.lang.assertValidKeywords._errorMessage){
dojo.lang.assertValidKeywords._errorMessage="In dojo.lang.assertValidKeywords(), found invalid keyword:";
}
_946=dojo.lang.assertValidKeywords._errorMessage;
}
if(dojo.lang.isArray(_945)){
for(key in _944){
if(!dojo.lang.inArray(_945,key)){
dojo.lang.assert(false,_946+" "+key);
}
}
}else{
for(key in _944){
if(!(key in _945)){
dojo.lang.assert(false,_946+" "+key);
}
}
}
};
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_948){
this.pairs=[];
this.returnWrappers=_948||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_94a,wrap,_94c,_94d){
var type=(_94d)?"unshift":"push";
this.pairs[type]([name,_94a,wrap,_94c]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.lang.repr");
dojo.lang.reprRegistry=new dojo.AdapterRegistry();
dojo.lang.registerRepr=function(name,_955,wrap,_957){
dojo.lang.reprRegistry.register(name,_955,wrap,_957);
};
dojo.lang.repr=function(obj){
if(typeof (obj)=="undefined"){
return "undefined";
}else{
if(obj===null){
return "null";
}
}
try{
if(typeof (obj["__repr__"])=="function"){
return obj["__repr__"]();
}else{
if((typeof (obj["repr"])=="function")&&(obj.repr!=arguments.callee)){
return obj["repr"]();
}
}
return dojo.lang.reprRegistry.match(obj);
}
catch(e){
if(typeof (obj.NAME)=="string"&&(obj.toString==Function.prototype.toString||obj.toString==Object.prototype.toString)){
return obj.NAME;
}
}
if(typeof (obj)=="function"){
obj=(obj+"").replace(/^\s+/,"");
var idx=obj.indexOf("{");
if(idx!=-1){
obj=obj.substr(0,idx)+"{...}";
}
}
return obj+"";
};
dojo.lang.reprArrayLike=function(arr){
try{
var na=dojo.lang.map(arr,dojo.lang.repr);
return "["+na.join(", ")+"]";
}
catch(e){
}
};
(function(){
var m=dojo.lang;
m.registerRepr("arrayLike",m.isArrayLike,m.reprArrayLike);
m.registerRepr("string",m.isString,m.reprString);
m.registerRepr("numbers",m.isNumber,m.reprNumber);
m.registerRepr("boolean",m.isBoolean,m.reprNumber);
})();
dojo.kwCompoundRequire({common:["dojo.lang.common","dojo.lang.assert","dojo.lang.array","dojo.lang.type","dojo.lang.func","dojo.lang.extras","dojo.lang.repr","dojo.lang.declare"]});
dojo.provide("dojo.lang.*");
dojo.provide("dojo.html.iframe");
dojo.html.iframeContentWindow=function(_95d){
var win=dojo.html.getDocumentWindow(dojo.html.iframeContentDocument(_95d))||dojo.html.iframeContentDocument(_95d).__parent__||(_95d.name&&document.frames[_95d.name])||null;
return win;
};
dojo.html.iframeContentDocument=function(_95f){
var doc=_95f.contentDocument||((_95f.contentWindow)&&(_95f.contentWindow.document))||((_95f.name)&&(document.frames[_95f.name])&&(document.frames[_95f.name].document))||null;
return doc;
};
dojo.html.BackgroundIframe=function(node){
if(dojo.render.html.ie55||dojo.render.html.ie60){
var html="<iframe src='javascript:false'"+" style='position: absolute; left: 0px; top: 0px; width: 100%; height: 100%;"+"z-index: -1; filter:Alpha(Opacity=\"0\");' "+">";
this.iframe=dojo.doc().createElement(html);
this.iframe.tabIndex=-1;
if(node){
node.appendChild(this.iframe);
this.domNode=node;
}else{
dojo.body().appendChild(this.iframe);
this.iframe.style.display="none";
}
}
};
dojo.lang.extend(dojo.html.BackgroundIframe,{iframe:null,onResized:function(){
if(this.iframe&&this.domNode&&this.domNode.parentNode){
var _963=dojo.html.getMarginBox(this.domNode);
if(_963.width==0||_963.height==0){
dojo.lang.setTimeout(this,this.onResized,100);
return;
}
this.iframe.style.width=_963.width+"px";
this.iframe.style.height=_963.height+"px";
}
},size:function(node){
if(!this.iframe){
return;
}
var _965=dojo.html.toCoordinateObject(node,true,dojo.html.boxSizing.BORDER_BOX);
with(this.iframe.style){
width=_965.width+"px";
height=_965.height+"px";
left=_965.left+"px";
top=_965.top+"px";
}
},setZIndex:function(node){
if(!this.iframe){
return;
}
if(dojo.dom.isNode(node)){
this.iframe.style.zIndex=dojo.html.getStyle(node,"z-index")-1;
}else{
if(!isNaN(node)){
this.iframe.style.zIndex=node;
}
}
},show:function(){
if(this.iframe){
this.iframe.style.display="block";
}
},hide:function(){
if(this.iframe){
this.iframe.style.display="none";
}
},remove:function(){
if(this.iframe){
dojo.html.removeNode(this.iframe,true);
delete this.iframe;
this.iframe=null;
}
}});
dojo.provide("dojo.widget.PopupContainer");
dojo.declare("dojo.widget.PopupContainerBase",null,function(){
this.queueOnAnimationFinish=[];
},{isShowingNow:false,currentSubpopup:null,beginZIndex:1000,parentPopup:null,parent:null,popupIndex:0,aroundBox:dojo.html.boxSizing.BORDER_BOX,openedForWindow:null,processKey:function(evt){
return false;
},applyPopupBasicStyle:function(){
with(this.domNode.style){
display="none";
position="absolute";
}
},aboutToShow:function(){
},open:function(x,y,_96a,_96b,_96c,_96d){
if(this.isShowingNow){
return;
}
if(this.animationInProgress){
this.queueOnAnimationFinish.push(this.open,arguments);
return;
}
this.aboutToShow();
var _96e=false,node,_970;
if(typeof x=="object"){
node=x;
_970=_96b;
_96b=_96a;
_96a=y;
_96e=true;
}
this.parent=_96a;
dojo.body().appendChild(this.domNode);
_96b=_96b||_96a["domNode"]||[];
var _971=null;
this.isTopLevel=true;
while(_96a){
if(_96a!==this&&(_96a.setOpenedSubpopup!=undefined&&_96a.applyPopupBasicStyle!=undefined)){
_971=_96a;
this.isTopLevel=false;
_971.setOpenedSubpopup(this);
break;
}
_96a=_96a.parent;
}
this.parentPopup=_971;
this.popupIndex=_971?_971.popupIndex+1:1;
if(this.isTopLevel){
var _972=dojo.html.isNode(_96b)?_96b:null;
dojo.widget.PopupManager.opened(this,_972);
}
if(this.isTopLevel&&!dojo.withGlobal(this.openedForWindow||dojo.global(),dojo.html.selection.isCollapsed)){
this._bookmark=dojo.withGlobal(this.openedForWindow||dojo.global(),dojo.html.selection.getBookmark);
}else{
this._bookmark=null;
}
if(_96b instanceof Array){
_96b={left:_96b[0],top:_96b[1],width:0,height:0};
}
with(this.domNode.style){
display="";
zIndex=this.beginZIndex+this.popupIndex;
}
if(_96e){
this.move(node,_96d,_970);
}else{
this.move(x,y,_96d,_96c);
}
this.domNode.style.display="none";
this.explodeSrc=_96b;
this.show();
this.isShowingNow=true;
},move:function(x,y,_975,_976){
var _977=(typeof x=="object");
if(_977){
var _978=_975;
var node=x;
_975=y;
if(!_978){
_978={"BL":"TL","TL":"BL"};
}
dojo.html.placeOnScreenAroundElement(this.domNode,node,_975,this.aroundBox,_978);
}else{
if(!_976){
_976="TL,TR,BL,BR";
}
dojo.html.placeOnScreen(this.domNode,x,y,_975,true,_976);
}
},close:function(_97a){
if(_97a){
this.domNode.style.display="none";
}
if(this.animationInProgress){
this.queueOnAnimationFinish.push(this.close,[]);
return;
}
this.closeSubpopup(_97a);
this.hide();
if(this.bgIframe){
this.bgIframe.hide();
this.bgIframe.size({left:0,top:0,width:0,height:0});
}
if(this.isTopLevel){
dojo.widget.PopupManager.closed(this);
}
this.isShowingNow=false;
if(this.parent){
setTimeout(dojo.lang.hitch(this,function(){
try{
if(this.parent["focus"]){
this.parent.focus();
}else{
this.parent.domNode.focus();
}
}
catch(e){
dojo.debug("No idea how to focus to parent",e);
}
}),10);
}
if(this._bookmark&&dojo.withGlobal(this.openedForWindow||dojo.global(),dojo.html.selection.isCollapsed)){
if(this.openedForWindow){
this.openedForWindow.focus();
}
try{
dojo.withGlobal(this.openedForWindow||dojo.global(),"moveToBookmark",dojo.html.selection,[this._bookmark]);
}
catch(e){
}
}
this._bookmark=null;
},closeAll:function(_97b){
if(this.parentPopup){
this.parentPopup.closeAll(_97b);
}else{
this.close(_97b);
}
},setOpenedSubpopup:function(_97c){
this.currentSubpopup=_97c;
},closeSubpopup:function(_97d){
if(this.currentSubpopup==null){
return;
}
this.currentSubpopup.close(_97d);
this.currentSubpopup=null;
},onShow:function(){
dojo.widget.PopupContainer.superclass.onShow.apply(this,arguments);
this.openedSize={w:this.domNode.style.width,h:this.domNode.style.height};
if(dojo.render.html.ie){
if(!this.bgIframe){
this.bgIframe=new dojo.html.BackgroundIframe();
this.bgIframe.setZIndex(this.domNode);
}
this.bgIframe.size(this.domNode);
this.bgIframe.show();
}
this.processQueue();
},processQueue:function(){
if(!this.queueOnAnimationFinish.length){
return;
}
var func=this.queueOnAnimationFinish.shift();
var args=this.queueOnAnimationFinish.shift();
func.apply(this,args);
},onHide:function(){
dojo.widget.HtmlWidget.prototype.onHide.call(this);
if(this.openedSize){
with(this.domNode.style){
width=this.openedSize.w;
height=this.openedSize.h;
}
}
this.processQueue();
}});
dojo.widget.defineWidget("dojo.widget.PopupContainer",[dojo.widget.HtmlWidget,dojo.widget.PopupContainerBase],{isContainer:true,fillInTemplate:function(){
this.applyPopupBasicStyle();
dojo.widget.PopupContainer.superclass.fillInTemplate.apply(this,arguments);
}});
dojo.widget.PopupManager=new function(){
this.currentMenu=null;
this.currentButton=null;
this.currentFocusMenu=null;
this.focusNode=null;
this.registeredWindows=[];
this.registerWin=function(win){
if(!win.__PopupManagerRegistered){
dojo.event.connect(win.document,"onmousedown",this,"onClick");
dojo.event.connect(win,"onscroll",this,"onClick");
dojo.event.connect(win.document,"onkey",this,"onKey");
win.__PopupManagerRegistered=true;
this.registeredWindows.push(win);
}
};
this.registerAllWindows=function(_981){
if(!_981){
_981=dojo.html.getDocumentWindow(window.top&&window.top.document||window.document);
}
this.registerWin(_981);
for(var i=0;i<_981.frames.length;i++){
try{
var win=dojo.html.getDocumentWindow(_981.frames[i].document);
if(win){
this.registerAllWindows(win);
}
}
catch(e){
}
}
};
this.unRegisterWin=function(win){
if(win.__PopupManagerRegistered){
dojo.event.disconnect(win.document,"onmousedown",this,"onClick");
dojo.event.disconnect(win,"onscroll",this,"onClick");
dojo.event.disconnect(win.document,"onkey",this,"onKey");
win.__PopupManagerRegistered=false;
}
};
this.unRegisterAllWindows=function(){
for(var i=0;i<this.registeredWindows.length;++i){
this.unRegisterWin(this.registeredWindows[i]);
}
this.registeredWindows=[];
};
dojo.addOnLoad(this,"registerAllWindows");
dojo.addOnUnload(this,"unRegisterAllWindows");
this.closed=function(menu){
if(this.currentMenu==menu){
this.currentMenu=null;
this.currentButton=null;
this.currentFocusMenu=null;
}
};
this.opened=function(menu,_988){
if(menu==this.currentMenu){
return;
}
if(this.currentMenu){
this.currentMenu.close();
}
this.currentMenu=menu;
this.currentFocusMenu=menu;
this.currentButton=_988;
};
this.setFocusedMenu=function(menu){
this.currentFocusMenu=menu;
};
this.onKey=function(e){
if(!e.key){
return;
}
if(!this.currentMenu||!this.currentMenu.isShowingNow){
return;
}
var m=this.currentFocusMenu;
while(m){
if(m.processKey(e)){
e.preventDefault();
e.stopPropagation();
break;
}
m=m.parentPopup||m.parentMenu;
}
},this.onClick=function(e){
if(!this.currentMenu){
return;
}
var _98d=dojo.html.getScroll().offset;
var m=this.currentMenu;
while(m){
if(dojo.html.overElement(m.domNode,e)||dojo.html.isDescendantOf(e.target,m.domNode)){
return;
}
m=m.currentSubpopup;
}
if(this.currentButton&&dojo.html.overElement(this.currentButton,e)){
return;
}
this.currentMenu.closeAll(true);
};
};
dojo.provide("dojo.widget.ColorPalette");
dojo.widget.defineWidget("dojo.widget.ColorPalette",dojo.widget.HtmlWidget,{palette:"7x10",_palettes:{"7x10":[["fff","fcc","fc9","ff9","ffc","9f9","9ff","cff","ccf","fcf"],["ccc","f66","f96","ff6","ff3","6f9","3ff","6ff","99f","f9f"],["c0c0c0","f00","f90","fc6","ff0","3f3","6cc","3cf","66c","c6c"],["999","c00","f60","fc3","fc0","3c0","0cc","36f","63f","c3c"],["666","900","c60","c93","990","090","399","33f","60c","939"],["333","600","930","963","660","060","366","009","339","636"],["000","300","630","633","330","030","033","006","309","303"]],"3x4":[["ffffff","00ff00","008000","0000ff"],["c0c0c0","ffff00","ff00ff","000080"],["808080","ff0000","800080","000000"]]},buildRendering:function(){
this.domNode=document.createElement("table");
dojo.html.disableSelection(this.domNode);
dojo.event.connect(this.domNode,"onmousedown",function(e){
e.preventDefault();
});
with(this.domNode){
cellPadding="0";
cellSpacing="1";
border="1";
style.backgroundColor="white";
}
var _990=this._palettes[this.palette];
for(var i=0;i<_990.length;i++){
var tr=this.domNode.insertRow(-1);
for(var j=0;j<_990[i].length;j++){
if(_990[i][j].length==3){
_990[i][j]=_990[i][j].replace(/(.)(.)(.)/,"$1$1$2$2$3$3");
}
var td=tr.insertCell(-1);
with(td.style){
backgroundColor="#"+_990[i][j];
border="1px solid gray";
width=height="15px";
fontSize="1px";
}
td.color="#"+_990[i][j];
td.onmouseover=function(e){
this.style.borderColor="white";
};
td.onmouseout=function(e){
this.style.borderColor="gray";
};
dojo.event.connect(td,"onmousedown",this,"onClick");
td.innerHTML="&nbsp;";
}
}
},onClick:function(e){
this.onColorSelect(e.currentTarget.color);
e.currentTarget.style.borderColor="gray";
},onColorSelect:function(_998){
}});
dojo.provide("dojo.widget.ContentPane");
dojo.widget.defineWidget("dojo.widget.ContentPane",dojo.widget.HtmlWidget,function(){
this._styleNodes=[];
this._onLoadStack=[];
this._onUnloadStack=[];
this._callOnUnload=false;
this._ioBindObj;
this.scriptScope;
this.bindArgs={};
},{isContainer:true,adjustPaths:true,href:"",extractContent:true,parseContent:true,cacheContent:true,preload:false,refreshOnShow:false,handler:"",executeScripts:false,scriptSeparation:true,loadingMessage:"Loading...",isLoaded:false,postCreate:function(args,frag,_99b){
if(this.handler!==""){
this.setHandler(this.handler);
}
if(this.isShowing()||this.preload){
this.loadContents();
}
},show:function(){
if(this.refreshOnShow){
this.refresh();
}else{
this.loadContents();
}
dojo.widget.ContentPane.superclass.show.call(this);
},refresh:function(){
this.isLoaded=false;
this.loadContents();
},loadContents:function(){
if(this.isLoaded){
return;
}
if(dojo.lang.isFunction(this.handler)){
this._runHandler();
}else{
if(this.href!=""){
this._downloadExternalContent(this.href,this.cacheContent&&!this.refreshOnShow);
}
}
},setUrl:function(url){
this.href=url;
this.isLoaded=false;
if(this.preload||this.isShowing()){
this.loadContents();
}
},abort:function(){
var bind=this._ioBindObj;
if(!bind||!bind.abort){
return;
}
bind.abort();
delete this._ioBindObj;
},_downloadExternalContent:function(url,_99f){
this.abort();
this._handleDefaults(this.loadingMessage,"onDownloadStart");
var self=this;
this._ioBindObj=dojo.io.bind(this._cacheSetting({url:url,mimetype:"text/html",handler:function(type,data,xhr){
delete self._ioBindObj;
if(type=="load"){
self.onDownloadEnd.call(self,url,data);
}else{
var e={responseText:xhr.responseText,status:xhr.status,statusText:xhr.statusText,responseHeaders:xhr.getAllResponseHeaders(),text:"Error loading '"+url+"' ("+xhr.status+" "+xhr.statusText+")"};
self._handleDefaults.call(self,e,"onDownloadError");
self.onLoad();
}
}},_99f));
},_cacheSetting:function(_9a5,_9a6){
for(var x in this.bindArgs){
if(dojo.lang.isUndefined(_9a5[x])){
_9a5[x]=this.bindArgs[x];
}
}
if(dojo.lang.isUndefined(_9a5.useCache)){
_9a5.useCache=_9a6;
}
if(dojo.lang.isUndefined(_9a5.preventCache)){
_9a5.preventCache=!_9a6;
}
if(dojo.lang.isUndefined(_9a5.mimetype)){
_9a5.mimetype="text/html";
}
return _9a5;
},onLoad:function(e){
this._runStack("_onLoadStack");
this.isLoaded=true;
},onUnLoad:function(e){
dojo.deprecated(this.widgetType+".onUnLoad, use .onUnload (lowercased load)",0.5);
},onUnload:function(e){
this._runStack("_onUnloadStack");
delete this.scriptScope;
if(this.onUnLoad!==dojo.widget.ContentPane.prototype.onUnLoad){
this.onUnLoad.apply(this,arguments);
}
},_runStack:function(_9ab){
var st=this[_9ab];
var err="";
var _9ae=this.scriptScope||window;
for(var i=0;i<st.length;i++){
try{
st[i].call(_9ae);
}
catch(e){
err+="\n"+st[i]+" failed: "+e.description;
}
}
this[_9ab]=[];
if(err.length){
var name=(_9ab=="_onLoadStack")?"addOnLoad":"addOnUnLoad";
this._handleDefaults(name+" failure\n "+err,"onExecError","debug");
}
},addOnLoad:function(obj,func){
this._pushOnStack(this._onLoadStack,obj,func);
},addOnUnload:function(obj,func){
this._pushOnStack(this._onUnloadStack,obj,func);
},addOnUnLoad:function(){
dojo.deprecated(this.widgetType+".addOnUnLoad, use addOnUnload instead. (lowercased Load)",0.5);
this.addOnUnload.apply(this,arguments);
},_pushOnStack:function(_9b5,obj,func){
if(typeof func=="undefined"){
_9b5.push(obj);
}else{
_9b5.push(function(){
obj[func]();
});
}
},destroy:function(){
this.onUnload();
dojo.widget.ContentPane.superclass.destroy.call(this);
},onExecError:function(e){
},onContentError:function(e){
},onDownloadError:function(e){
},onDownloadStart:function(e){
},onDownloadEnd:function(url,data){
data=this.splitAndFixPaths(data,url);
this.setContent(data);
},_handleDefaults:function(e,_9bf,_9c0){
if(!_9bf){
_9bf="onContentError";
}
if(dojo.lang.isString(e)){
e={text:e};
}
if(!e.text){
e.text=e.toString();
}
e.toString=function(){
return this.text;
};
if(typeof e.returnValue!="boolean"){
e.returnValue=true;
}
if(typeof e.preventDefault!="function"){
e.preventDefault=function(){
this.returnValue=false;
};
}
this[_9bf](e);
if(e.returnValue){
switch(_9c0){
case true:
case "alert":
alert(e.toString());
break;
case "debug":
dojo.debug(e.toString());
break;
default:
if(this._callOnUnload){
this.onUnload();
}
this._callOnUnload=false;
if(arguments.callee._loopStop){
dojo.debug(e.toString());
}else{
arguments.callee._loopStop=true;
this._setContent(e.toString());
}
}
}
arguments.callee._loopStop=false;
},splitAndFixPaths:function(s,url){
var _9c3=[],_9c4=[],tmp=[];
var _9c6=[],_9c7=[],attr=[],_9c9=[];
var str="",path="",fix="",_9cd="",tag="",_9cf="";
if(!url){
url="./";
}
if(s){
var _9d0=/<title[^>]*>([\s\S]*?)<\/title>/i;
while(_9c6=_9d0.exec(s)){
_9c3.push(_9c6[1]);
s=s.substring(0,_9c6.index)+s.substr(_9c6.index+_9c6[0].length);
}
if(this.adjustPaths){
var _9d1=/<[a-z][a-z0-9]*[^>]*\s(?:(?:src|href|style)=[^>])+[^>]*>/i;
var _9d2=/\s(src|href|style)=(['"]?)([\w()\[\]\/.,\\'"-:;#=&?\s@]+?)\2/i;
var _9d3=/^(?:[#]|(?:(?:https?|ftps?|file|javascript|mailto|news):))/;
while(tag=_9d1.exec(s)){
str+=s.substring(0,tag.index);
s=s.substring((tag.index+tag[0].length),s.length);
tag=tag[0];
_9cd="";
while(attr=_9d2.exec(tag)){
path="";
_9cf=attr[3];
switch(attr[1].toLowerCase()){
case "src":
case "href":
if(_9d3.exec(_9cf)){
path=_9cf;
}else{
path=(new dojo.uri.Uri(url,_9cf).toString());
}
break;
case "style":
path=dojo.html.fixPathsInCssText(_9cf,url);
break;
default:
path=_9cf;
}
fix=" "+attr[1]+"="+attr[2]+path+attr[2];
_9cd+=tag.substring(0,attr.index)+fix;
tag=tag.substring((attr.index+attr[0].length),tag.length);
}
str+=_9cd+tag;
}
s=str+s;
}
_9d0=/(?:<(style)[^>]*>([\s\S]*?)<\/style>|<link ([^>]*rel=['"]?stylesheet['"]?[^>]*)>)/i;
while(_9c6=_9d0.exec(s)){
if(_9c6[1]&&_9c6[1].toLowerCase()=="style"){
_9c9.push(dojo.html.fixPathsInCssText(_9c6[2],url));
}else{
if(attr=_9c6[3].match(/href=(['"]?)([^'">]*)\1/i)){
_9c9.push({path:attr[2]});
}
}
s=s.substring(0,_9c6.index)+s.substr(_9c6.index+_9c6[0].length);
}
var _9d0=/<script([^>]*)>([\s\S]*?)<\/script>/i;
var _9d4=/src=(['"]?)([^"']*)\1/i;
var _9d5=/.*(\bdojo\b\.js(?:\.uncompressed\.js)?)$/;
var _9d6=/(?:var )?\bdjConfig\b(?:[\s]*=[\s]*\{[^}]+\}|\.[\w]*[\s]*=[\s]*[^;\n]*)?;?|dojo\.hostenv\.writeIncludes\(\s*\);?/g;
var _9d7=/dojo\.(?:(?:require(?:After)?(?:If)?)|(?:widget\.(?:manager\.)?registerWidgetPackage)|(?:(?:hostenv\.)?setModulePrefix|registerModulePath)|defineNamespace)\((['"]).*?\1\)\s*;?/;
while(_9c6=_9d0.exec(s)){
if(this.executeScripts&&_9c6[1]){
if(attr=_9d4.exec(_9c6[1])){
if(_9d5.exec(attr[2])){
dojo.debug("Security note! inhibit:"+attr[2]+" from  being loaded again.");
}else{
_9c4.push({path:attr[2]});
}
}
}
if(_9c6[2]){
var sc=_9c6[2].replace(_9d6,"");
if(!sc){
continue;
}
while(tmp=_9d7.exec(sc)){
_9c7.push(tmp[0]);
sc=sc.substring(0,tmp.index)+sc.substr(tmp.index+tmp[0].length);
}
if(this.executeScripts){
_9c4.push(sc);
}
}
s=s.substr(0,_9c6.index)+s.substr(_9c6.index+_9c6[0].length);
}
if(this.extractContent){
_9c6=s.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_9c6){
s=_9c6[1];
}
}
if(this.executeScripts&&this.scriptSeparation){
var _9d0=/(<[a-zA-Z][a-zA-Z0-9]*\s[^>]*?\S=)((['"])[^>]*scriptScope[^>]*>)/;
var _9d9=/([\s'";:\(])scriptScope(.*)/;
str="";
while(tag=_9d0.exec(s)){
tmp=((tag[3]=="'")?"\"":"'");
fix="";
str+=s.substring(0,tag.index)+tag[1];
while(attr=_9d9.exec(tag[2])){
tag[2]=tag[2].substring(0,attr.index)+attr[1]+"dojo.widget.byId("+tmp+this.widgetId+tmp+").scriptScope"+attr[2];
}
str+=tag[2];
s=s.substr(tag.index+tag[0].length);
}
s=str+s;
}
}
return {"xml":s,"styles":_9c9,"titles":_9c3,"requires":_9c7,"scripts":_9c4,"url":url};
},_setContent:function(cont){
this.destroyChildren();
for(var i=0;i<this._styleNodes.length;i++){
if(this._styleNodes[i]&&this._styleNodes[i].parentNode){
this._styleNodes[i].parentNode.removeChild(this._styleNodes[i]);
}
}
this._styleNodes=[];
try{
var node=this.containerNode||this.domNode;
while(node.firstChild){
dojo.html.destroyNode(node.firstChild);
}
if(typeof cont!="string"){
node.appendChild(cont);
}else{
node.innerHTML=cont;
}
}
catch(e){
e.text="Couldn't load content:"+e.description;
this._handleDefaults(e,"onContentError");
}
},setContent:function(data){
this.abort();
if(this._callOnUnload){
this.onUnload();
}
this._callOnUnload=true;
if(!data||dojo.html.isNode(data)){
this._setContent(data);
this.onResized();
this.onLoad();
}else{
if(typeof data.xml!="string"){
this.href="";
data=this.splitAndFixPaths(data);
}
this._setContent(data.xml);
for(var i=0;i<data.styles.length;i++){
if(data.styles[i].path){
this._styleNodes.push(dojo.html.insertCssFile(data.styles[i].path,dojo.doc(),false,true));
}else{
this._styleNodes.push(dojo.html.insertCssText(data.styles[i]));
}
}
if(this.parseContent){
for(var i=0;i<data.requires.length;i++){
try{
eval(data.requires[i]);
}
catch(e){
e.text="ContentPane: error in package loading calls, "+(e.description||e);
this._handleDefaults(e,"onContentError","debug");
}
}
}
var _9df=this;
function asyncParse(){
if(_9df.executeScripts){
_9df._executeScripts(data.scripts);
}
if(_9df.parseContent){
var node=_9df.containerNode||_9df.domNode;
var _9e1=new dojo.xml.Parse();
var frag=_9e1.parseElement(node,null,true);
dojo.widget.getParser().createSubComponents(frag,_9df);
}
_9df.onResized();
_9df.onLoad();
}
if(dojo.hostenv.isXDomain&&data.requires.length){
dojo.addOnLoad(asyncParse);
}else{
asyncParse();
}
}
},setHandler:function(_9e3){
var fcn=dojo.lang.isFunction(_9e3)?_9e3:window[_9e3];
if(!dojo.lang.isFunction(fcn)){
this._handleDefaults("Unable to set handler, '"+_9e3+"' not a function.","onExecError",true);
return;
}
this.handler=function(){
return fcn.apply(this,arguments);
};
},_runHandler:function(){
var ret=true;
if(dojo.lang.isFunction(this.handler)){
this.handler(this,this.domNode);
ret=false;
}
this.onLoad();
return ret;
},_executeScripts:function(_9e6){
var self=this;
var tmp="",code="";
for(var i=0;i<_9e6.length;i++){
if(_9e6[i].path){
dojo.io.bind(this._cacheSetting({"url":_9e6[i].path,"load":function(type,_9ec){
dojo.lang.hitch(self,tmp=";"+_9ec);
},"error":function(type,_9ee){
_9ee.text=type+" downloading remote script";
self._handleDefaults.call(self,_9ee,"onExecError","debug");
},"mimetype":"text/plain","sync":true},this.cacheContent));
code+=tmp;
}else{
code+=_9e6[i];
}
}
try{
if(this.scriptSeparation){
delete this.scriptScope;
this.scriptScope=new (new Function("_container_",code+"; return this;"))(self);
}else{
var djg=dojo.global();
if(djg.execScript){
djg.execScript(code);
}else{
var djd=dojo.doc();
var sc=djd.createElement("script");
sc.appendChild(djd.createTextNode(code));
(this.containerNode||this.domNode).appendChild(sc);
}
}
}
catch(e){
e.text="Error running scripts from content:\n"+e.description;
this._handleDefaults(e,"onExecError","debug");
}
}});
dojo.provide("dojo.widget.Editor2Toolbar");
dojo.lang.declare("dojo.widget.HandlerManager",null,function(){
this._registeredHandlers=[];
},{registerHandler:function(obj,func){
if(arguments.length==2){
this._registeredHandlers.push(function(){
return obj[func].apply(obj,arguments);
});
}else{
this._registeredHandlers.push(obj);
}
},removeHandler:function(func){
for(var i=0;i<this._registeredHandlers.length;i++){
if(func===this._registeredHandlers[i]){
delete this._registeredHandlers[i];
return;
}
}
dojo.debug("HandlerManager handler "+func+" is not registered, can not remove.");
},destroy:function(){
for(var i=0;i<this._registeredHandlers.length;i++){
delete this._registeredHandlers[i];
}
}});
dojo.widget.Editor2ToolbarItemManager=new dojo.widget.HandlerManager;
dojo.lang.mixin(dojo.widget.Editor2ToolbarItemManager,{getToolbarItem:function(name){
var item;
name=name.toLowerCase();
for(var i=0;i<this._registeredHandlers.length;i++){
item=this._registeredHandlers[i](name);
if(item){
return item;
}
}
switch(name){
case "bold":
case "copy":
case "cut":
case "delete":
case "indent":
case "inserthorizontalrule":
case "insertorderedlist":
case "insertunorderedlist":
case "italic":
case "justifycenter":
case "justifyfull":
case "justifyleft":
case "justifyright":
case "outdent":
case "paste":
case "redo":
case "removeformat":
case "selectall":
case "strikethrough":
case "subscript":
case "superscript":
case "underline":
case "undo":
case "unlink":
case "createlink":
case "insertimage":
case "htmltoggle":
item=new dojo.widget.Editor2ToolbarButton(name);
break;
case "forecolor":
case "hilitecolor":
item=new dojo.widget.Editor2ToolbarColorPaletteButton(name);
break;
case "plainformatblock":
item=new dojo.widget.Editor2ToolbarFormatBlockPlainSelect("formatblock");
break;
case "formatblock":
item=new dojo.widget.Editor2ToolbarFormatBlockSelect("formatblock");
break;
case "fontsize":
item=new dojo.widget.Editor2ToolbarFontSizeSelect("fontsize");
break;
case "fontname":
item=new dojo.widget.Editor2ToolbarFontNameSelect("fontname");
break;
case "inserttable":
case "insertcell":
case "insertcol":
case "insertrow":
case "deletecells":
case "deletecols":
case "deleterows":
case "mergecells":
case "splitcell":
dojo.debug(name+" is implemented in dojo.widget.Editor2Plugin.TableOperation, please require it first.");
break;
case "inserthtml":
case "blockdirltr":
case "blockdirrtl":
case "dirltr":
case "dirrtl":
case "inlinedirltr":
case "inlinedirrtl":
dojo.debug("Not yet implemented toolbar item: "+name);
break;
default:
dojo.debug("dojo.widget.Editor2ToolbarItemManager.getToolbarItem: Unknown toolbar item: "+name);
}
return item;
}});
dojo.addOnUnload(dojo.widget.Editor2ToolbarItemManager,"destroy");
dojo.declare("dojo.widget.Editor2ToolbarButton",null,function(name){
this._name=name;
},{create:function(node,_9fc,_9fd){
this._domNode=node;
var cmd=_9fc.parent.getCommand(this._name);
if(cmd){
this._domNode.title=cmd.getText();
}
this.disableSelection(this._domNode);
this._parentToolbar=_9fc;
dojo.event.connect(this._domNode,"onclick",this,"onClick");
if(!_9fd){
dojo.event.connect(this._domNode,"onmouseover",this,"onMouseOver");
dojo.event.connect(this._domNode,"onmouseout",this,"onMouseOut");
}
},disableSelection:function(_9ff){
dojo.html.disableSelection(_9ff);
var _a00=_9ff.all||_9ff.getElementsByTagName("*");
for(var x=0;x<_a00.length;x++){
dojo.html.disableSelection(_a00[x]);
}
},onMouseOver:function(){
var _a02=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a02){
var _a03=_a02.getCommand(this._name);
if(_a03&&_a03.getState()!=dojo.widget.Editor2Manager.commandState.Disabled){
this.highlightToolbarItem();
}
}
},onMouseOut:function(){
this.unhighlightToolbarItem();
},destroy:function(){
this._domNode=null;
this._parentToolbar=null;
},onClick:function(e){
if(this._domNode&&!this._domNode.disabled&&this._parentToolbar.checkAvailability()){
e.preventDefault();
e.stopPropagation();
var _a05=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a05){
var _a06=_a05.getCommand(this._name);
if(_a06){
_a06.execute();
}
}
}
},refreshState:function(){
var _a07=dojo.widget.Editor2Manager.getCurrentInstance();
var em=dojo.widget.Editor2Manager;
if(_a07){
var _a09=_a07.getCommand(this._name);
if(_a09){
var _a0a=_a09.getState();
if(_a0a!=this._lastState){
switch(_a0a){
case em.commandState.Latched:
this.latchToolbarItem();
break;
case em.commandState.Enabled:
this.enableToolbarItem();
break;
case em.commandState.Disabled:
default:
this.disableToolbarItem();
}
this._lastState=_a0a;
}
}
}
return em.commandState.Enabled;
},latchToolbarItem:function(){
this._domNode.disabled=false;
this.removeToolbarItemStyle(this._domNode);
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarLatchedItemStyle);
},enableToolbarItem:function(){
this._domNode.disabled=false;
this.removeToolbarItemStyle(this._domNode);
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarEnabledItemStyle);
},disableToolbarItem:function(){
this._domNode.disabled=true;
this.removeToolbarItemStyle(this._domNode);
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarDisabledItemStyle);
},highlightToolbarItem:function(){
dojo.html.addClass(this._domNode,this._parentToolbar.ToolbarHighlightedItemStyle);
},unhighlightToolbarItem:function(){
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarHighlightedItemStyle);
},removeToolbarItemStyle:function(){
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarEnabledItemStyle);
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarLatchedItemStyle);
dojo.html.removeClass(this._domNode,this._parentToolbar.ToolbarDisabledItemStyle);
this.unhighlightToolbarItem();
}});
dojo.declare("dojo.widget.Editor2ToolbarDropDownButton",dojo.widget.Editor2ToolbarButton,{onClick:function(){
if(this._domNode&&!this._domNode.disabled&&this._parentToolbar.checkAvailability()){
if(!this._dropdown){
this._dropdown=dojo.widget.createWidget("PopupContainer",{});
this._domNode.appendChild(this._dropdown.domNode);
}
if(this._dropdown.isShowingNow){
this._dropdown.close();
}else{
this.onDropDownShown();
this._dropdown.open(this._domNode,null,this._domNode);
}
}
},destroy:function(){
this.onDropDownDestroy();
if(this._dropdown){
this._dropdown.destroy();
}
dojo.widget.Editor2ToolbarDropDownButton.superclass.destroy.call(this);
},onDropDownShown:function(){
},onDropDownDestroy:function(){
}});
dojo.declare("dojo.widget.Editor2ToolbarColorPaletteButton",dojo.widget.Editor2ToolbarDropDownButton,{onDropDownShown:function(){
if(!this._colorpalette){
this._colorpalette=dojo.widget.createWidget("ColorPalette",{});
this._dropdown.addChild(this._colorpalette);
this.disableSelection(this._dropdown.domNode);
this.disableSelection(this._colorpalette.domNode);
dojo.event.connect(this._colorpalette,"onColorSelect",this,"setColor");
dojo.event.connect(this._dropdown,"open",this,"latchToolbarItem");
dojo.event.connect(this._dropdown,"close",this,"enableToolbarItem");
}
},setColor:function(_a0b){
this._dropdown.close();
var _a0c=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a0c){
var _a0d=_a0c.getCommand(this._name);
if(_a0d){
_a0d.execute(_a0b);
}
}
}});
dojo.declare("dojo.widget.Editor2ToolbarFormatBlockPlainSelect",dojo.widget.Editor2ToolbarButton,{create:function(node,_a0f){
this._domNode=node;
this._parentToolbar=_a0f;
this._domNode=node;
this.disableSelection(this._domNode);
dojo.event.connect(this._domNode,"onchange",this,"onChange");
},destroy:function(){
this._domNode=null;
},onChange:function(){
if(this._parentToolbar.checkAvailability()){
var sv=this._domNode.value.toLowerCase();
var _a11=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a11){
var _a12=_a11.getCommand(this._name);
if(_a12){
_a12.execute(sv);
}
}
}
},refreshState:function(){
if(this._domNode){
dojo.widget.Editor2ToolbarFormatBlockPlainSelect.superclass.refreshState.call(this);
var _a13=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a13){
var _a14=_a13.getCommand(this._name);
if(_a14){
var _a15=_a14.getValue();
if(!_a15){
_a15="";
}
dojo.lang.forEach(this._domNode.options,function(item){
if(item.value.toLowerCase()==_a15.toLowerCase()){
item.selected=true;
}
});
}
}
}
}});
dojo.declare("dojo.widget.Editor2ToolbarComboItem",dojo.widget.Editor2ToolbarDropDownButton,{href:null,create:function(node,_a18){
dojo.widget.Editor2ToolbarComboItem.superclass.create.apply(this,arguments);
if(!this._contentPane){
this._contentPane=dojo.widget.createWidget("ContentPane",{preload:"true"});
this._contentPane.addOnLoad(this,"setup");
this._contentPane.setUrl(this.href);
}
},onMouseOver:function(e){
if(this._lastState!=dojo.widget.Editor2Manager.commandState.Disabled){
dojo.html.addClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectStyle);
}
},onMouseOut:function(e){
dojo.html.removeClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectStyle);
},onDropDownShown:function(){
if(!this._dropdown.__addedContentPage){
this._dropdown.addChild(this._contentPane);
this._dropdown.__addedContentPage=true;
}
},setup:function(){
},onChange:function(e){
if(this._parentToolbar.checkAvailability()){
var name=e.currentTarget.getAttribute("dropDownItemName");
var _a1d=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a1d){
var _a1e=_a1d.getCommand(this._name);
if(_a1e){
_a1e.execute(name);
}
}
}
this._dropdown.close();
},onMouseOverItem:function(e){
dojo.html.addClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectItemStyle);
},onMouseOutItem:function(e){
dojo.html.removeClass(e.currentTarget,this._parentToolbar.ToolbarHighlightedSelectItemStyle);
}});
dojo.declare("dojo.widget.Editor2ToolbarFormatBlockSelect",dojo.widget.Editor2ToolbarComboItem,{href:dojo.uri.moduleUri("dojo.widget","templates/Editor2/EditorToolbar_FormatBlock.html"),setup:function(){
dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.setup.call(this);
var _a21=this._contentPane.domNode.all||this._contentPane.domNode.getElementsByTagName("*");
this._blockNames={};
this._blockDisplayNames={};
for(var x=0;x<_a21.length;x++){
var node=_a21[x];
dojo.html.disableSelection(node);
var name=node.getAttribute("dropDownItemName");
if(name){
this._blockNames[name]=node;
var _a25=node.getElementsByTagName(name);
this._blockDisplayNames[name]=_a25[_a25.length-1].innerHTML;
}
}
for(var name in this._blockNames){
dojo.event.connect(this._blockNames[name],"onclick",this,"onChange");
dojo.event.connect(this._blockNames[name],"onmouseover",this,"onMouseOverItem");
dojo.event.connect(this._blockNames[name],"onmouseout",this,"onMouseOutItem");
}
},onDropDownDestroy:function(){
if(this._blockNames){
for(var name in this._blockNames){
delete this._blockNames[name];
delete this._blockDisplayNames[name];
}
}
},refreshState:function(){
dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.refreshState.call(this);
if(this._lastState!=dojo.widget.Editor2Manager.commandState.Disabled){
var _a27=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a27){
var _a28=_a27.getCommand(this._name);
if(_a28){
var _a29=_a28.getValue();
if(_a29==this._lastSelectedFormat&&this._blockDisplayNames){
return this._lastState;
}
this._lastSelectedFormat=_a29;
var _a2a=this._domNode.getElementsByTagName("label")[0];
var _a2b=false;
if(this._blockDisplayNames){
for(var name in this._blockDisplayNames){
if(name==_a29){
_a2a.innerHTML=this._blockDisplayNames[name];
_a2b=true;
break;
}
}
if(!_a2b){
_a2a.innerHTML="&nbsp;";
}
}
}
}
}
return this._lastState;
}});
dojo.declare("dojo.widget.Editor2ToolbarFontSizeSelect",dojo.widget.Editor2ToolbarComboItem,{href:dojo.uri.moduleUri("dojo.widget","templates/Editor2/EditorToolbar_FontSize.html"),setup:function(){
dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.setup.call(this);
var _a2d=this._contentPane.domNode.all||this._contentPane.domNode.getElementsByTagName("*");
this._fontsizes={};
this._fontSizeDisplayNames={};
for(var x=0;x<_a2d.length;x++){
var node=_a2d[x];
dojo.html.disableSelection(node);
var name=node.getAttribute("dropDownItemName");
if(name){
this._fontsizes[name]=node;
this._fontSizeDisplayNames[name]=node.getElementsByTagName("font")[0].innerHTML;
}
}
for(var name in this._fontsizes){
dojo.event.connect(this._fontsizes[name],"onclick",this,"onChange");
dojo.event.connect(this._fontsizes[name],"onmouseover",this,"onMouseOverItem");
dojo.event.connect(this._fontsizes[name],"onmouseout",this,"onMouseOutItem");
}
},onDropDownDestroy:function(){
if(this._fontsizes){
for(var name in this._fontsizes){
delete this._fontsizes[name];
delete this._fontSizeDisplayNames[name];
}
}
},refreshState:function(){
dojo.widget.Editor2ToolbarFormatBlockSelect.superclass.refreshState.call(this);
if(this._lastState!=dojo.widget.Editor2Manager.commandState.Disabled){
var _a32=dojo.widget.Editor2Manager.getCurrentInstance();
if(_a32){
var _a33=_a32.getCommand(this._name);
if(_a33){
var size=_a33.getValue();
if(size==this._lastSelectedSize&&this._fontSizeDisplayNames){
return this._lastState;
}
this._lastSelectedSize=size;
var _a35=this._domNode.getElementsByTagName("label")[0];
var _a36=false;
if(this._fontSizeDisplayNames){
for(var name in this._fontSizeDisplayNames){
if(name==size){
_a35.innerHTML=this._fontSizeDisplayNames[name];
_a36=true;
break;
}
}
if(!_a36){
_a35.innerHTML="&nbsp;";
}
}
}
}
}
return this._lastState;
}});
dojo.declare("dojo.widget.Editor2ToolbarFontNameSelect",dojo.widget.Editor2ToolbarFontSizeSelect,{href:dojo.uri.moduleUri("dojo.widget","templates/Editor2/EditorToolbar_FontName.html")});
dojo.widget.defineWidget("dojo.widget.Editor2Toolbar",dojo.widget.HtmlWidget,function(){
dojo.event.connect(this,"fillInTemplate",dojo.lang.hitch(this,function(){
if(dojo.render.html.ie){
this.domNode.style.zoom=1;
}
}));
},{templateString:"<div dojoAttachPoint=\"domNode\" class=\"EditorToolbarDomNode\" unselectable=\"on\">\n\t<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\">\n\t\t<!--\n\t\t\tour toolbar should look something like:\n\n\t\t\t+=======+=======+=======+=============================================+\n\t\t\t| w   w | style | copy  | bo | it | un | le | ce | ri |\n\t\t\t| w w w | style |=======|==============|==============|\n\t\t\t|  w w  | style | paste |  undo | redo | change style |\n\t\t\t+=======+=======+=======+=============================================+\n\t\t-->\n\t\t<tbody>\n\t\t\t<tr valign=\"top\">\n\t\t\t\t<td rowspan=\"2\">\n\t\t\t\t\t<div class=\"bigIcon\" dojoAttachPoint=\"wikiWordButton\"\n\t\t\t\t\t\tdojoOnClick=\"wikiWordClick; buttonClick;\">\n\t\t\t\t\t\t<span style=\"font-size: 30px; margin-left: 5px;\">\n\t\t\t\t\t\t\tW\n\t\t\t\t\t\t</span>\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t\t<td rowspan=\"2\">\n\t\t\t\t\t<div class=\"bigIcon\" dojoAttachPoint=\"styleDropdownButton\"\n\t\t\t\t\t\tdojoOnClick=\"styleDropdownClick; buttonClick;\">\n\t\t\t\t\t\t<span unselectable=\"on\"\n\t\t\t\t\t\t\tstyle=\"font-size: 30px; margin-left: 5px;\">\n\t\t\t\t\t\t\tS\n\t\t\t\t\t\t</span>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"StyleDropdownContainer\" style=\"display: none;\"\n\t\t\t\t\t\tdojoAttachPoint=\"styleDropdownContainer\">\n\t\t\t\t\t\t<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"\n\t\t\t\t\t\t\theight=\"100%\" width=\"100%\">\n\t\t\t\t\t\t\t<tr valign=\"top\">\n\t\t\t\t\t\t\t\t<td rowspan=\"2\">\n\t\t\t\t\t\t\t\t\t<div style=\"height: 245px; overflow: auto;\">\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"normalTextClick\">normal</div>\n\t\t\t\t\t\t\t\t\t\t<h1 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h1TextClick\">Heading 1</h1>\n\t\t\t\t\t\t\t\t\t\t<h2 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h2TextClick\">Heading 2</h2>\n\t\t\t\t\t\t\t\t\t\t<h3 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h3TextClick\">Heading 3</h3>\n\t\t\t\t\t\t\t\t\t\t<h4 class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"h4TextClick\">Heading 4</h4>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"blahTextClick\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"blahTextClick\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\"\n\t\t\t\t\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\t\t\t\t\tdojoOnClick=\"blahTextClick\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"headingContainer\">blah</div>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t<!--\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifyleft\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifycenter\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifyright\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t<span class=\"iconContainer\" dojoOnClick=\"buttonClick;\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"icon justifyfull\" \n\t\t\t\t\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span>\n\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t-->\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t<tr valign=\"top\">\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\tthud\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t</div>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<!-- copy -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"copyButton\"\n\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\tdojoOnClick=\"copyClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon copy\" \n\t\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\t\tstyle=\"float: left;\">&nbsp;</span> copy\n\t\t\t\t\t</span>\n\t\t\t\t\t<!-- \"droppable\" options -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"boldButton\"\n\t\t\t\t\t\tunselectable=\"on\"\n\t\t\t\t\t\tdojoOnClick=\"boldClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon bold\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"italicButton\"\n\t\t\t\t\t\tdojoOnClick=\"italicClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon italic\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"underlineButton\"\n\t\t\t\t\t\tdojoOnClick=\"underlineClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon underline\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"leftButton\"\n\t\t\t\t\t\tdojoOnClick=\"leftClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon justifyleft\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"fullButton\"\n\t\t\t\t\t\tdojoOnClick=\"fullClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon justifyfull\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"rightButton\"\n\t\t\t\t\t\tdojoOnClick=\"rightClick; buttonClick;\">\n\t\t\t\t\t\t<span class=\"icon justifyright\" unselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t</tr>\n\t\t\t<tr>\n\t\t\t\t<td>\n\t\t\t\t\t<!-- paste -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"pasteButton\"\n\t\t\t\t\t\tdojoOnClick=\"pasteClick; buttonClick;\" unselectable=\"on\">\n\t\t\t\t\t\t<span class=\"icon paste\" style=\"float: left;\" unselectable=\"on\">&nbsp;</span> paste\n\t\t\t\t\t</span>\n\t\t\t\t\t<!-- \"droppable\" options -->\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"undoButton\"\n\t\t\t\t\t\tdojoOnClick=\"undoClick; buttonClick;\" unselectable=\"on\">\n\t\t\t\t\t\t<span class=\"icon undo\" style=\"float: left;\" unselectable=\"on\">&nbsp;</span> undo\n\t\t\t\t\t</span>\n\t\t\t\t\t<span class=\"iconContainer\" dojoAttachPoint=\"redoButton\"\n\t\t\t\t\t\tdojoOnClick=\"redoClick; buttonClick;\" unselectable=\"on\">\n\t\t\t\t\t\t<span class=\"icon redo\" style=\"float: left;\" unselectable=\"on\">&nbsp;</span> redo\n\t\t\t\t\t</span>\n\t\t\t\t</td>\t\n\t\t\t</tr>\n\t\t</tbody>\n\t</table>\n</div>\n",templateCssString:".StyleDropdownContainer {\n\tposition: absolute;\n\tz-index: 1000;\n\toverflow: auto;\n\tcursor: default;\n\twidth: 250px;\n\theight: 250px;\n\tbackground-color: white;\n\tborder: 1px solid black;\n}\n\n.ColorDropdownContainer {\n\tposition: absolute;\n\tz-index: 1000;\n\toverflow: auto;\n\tcursor: default;\n\twidth: 250px;\n\theight: 150px;\n\tbackground-color: white;\n\tborder: 1px solid black;\n}\n\n.EditorToolbarDomNode {\n\tbackground-image: url(buttons/bg-fade.png);\n\tbackground-repeat: repeat-x;\n\tbackground-position: 0px -50px;\n}\n\n.EditorToolbarSmallBg {\n\tbackground-image: url(images/toolbar-bg.gif);\n\tbackground-repeat: repeat-x;\n\tbackground-position: 0px 0px;\n}\n\n/*\nbody {\n\tbackground:url(images/blank.gif) fixed;\n}*/\n\n.IEFixedToolbar {\n\tposition:absolute;\n\t/* top:0; */\n\ttop: expression(eval((document.documentElement||document.body).scrollTop));\n}\n\ndiv.bigIcon {\n\twidth: 40px;\n\theight: 40px; \n\t/* background-color: white; */\n\t/* border: 1px solid #a6a7a3; */\n\tfont-family: Verdana, Trebuchet, Tahoma, Arial;\n}\n\n.iconContainer {\n\tfont-family: Verdana, Trebuchet, Tahoma, Arial;\n\tfont-size: 13px;\n\tfloat: left;\n\theight: 18px;\n\tdisplay: block;\n\t/* background-color: white; */\n\tcursor: pointer;\n\tpadding: 1px 4px 1px 1px; /* almost the same as a transparent border */\n\tborder: 0px;\n}\n\n.dojoE2TBIcon {\n\tdisplay: block;\n\ttext-align: center;\n\tmin-width: 18px;\n\twidth: 18px;\n\theight: 18px;\n\t/* background-color: #a6a7a3; */\n\tbackground-repeat: no-repeat;\n\tbackground-image: url(buttons/aggregate.gif);\n}\n\n\n.dojoE2TBIcon[class~=dojoE2TBIcon] {\n}\n\n.ToolbarButtonLatched {\n    border: #316ac5 1px solid; !important;\n    padding: 0px 3px 0px 0px; !important; /* make room for border */\n    background-color: #c1d2ee;\n}\n\n.ToolbarButtonHighlighted {\n    border: #316ac5 1px solid; !important;\n    padding: 0px 3px 0px 0px; !important; /* make room for border */\n    background-color: #dff1ff;\n}\n\n.ToolbarButtonDisabled{\n    filter: gray() alpha(opacity=30); /* IE */\n    opacity: 0.30; /* Safari, Opera and Mozilla */\n}\n\n.headingContainer {\n\twidth: 150px;\n\theight: 30px;\n\tmargin: 0px;\n\t/* padding-left: 5px; */\n\toverflow: hidden;\n\tline-height: 25px;\n\tborder-bottom: 1px solid black;\n\tborder-top: 1px solid white;\n}\n\n.EditorToolbarDomNode select {\n\tfont-size: 14px;\n}\n \n.dojoE2TBIcon_Sep { width: 5px; min-width: 5px; max-width: 5px; background-position: 0px 0px}\n.dojoE2TBIcon_Backcolor { background-position: -18px 0px}\n.dojoE2TBIcon_Bold { background-position: -36px 0px}\n.dojoE2TBIcon_Cancel { background-position: -54px 0px}\n.dojoE2TBIcon_Copy { background-position: -72px 0px}\n.dojoE2TBIcon_Link { background-position: -90px 0px}\n.dojoE2TBIcon_Cut { background-position: -108px 0px}\n.dojoE2TBIcon_Delete { background-position: -126px 0px}\n.dojoE2TBIcon_TextColor { background-position: -144px 0px}\n.dojoE2TBIcon_BackgroundColor { background-position: -162px 0px}\n.dojoE2TBIcon_Indent { background-position: -180px 0px}\n.dojoE2TBIcon_HorizontalLine { background-position: -198px 0px}\n.dojoE2TBIcon_Image { background-position: -216px 0px}\n.dojoE2TBIcon_NumberedList { background-position: -234px 0px}\n.dojoE2TBIcon_Table { background-position: -252px 0px}\n.dojoE2TBIcon_BulletedList { background-position: -270px 0px}\n.dojoE2TBIcon_Italic { background-position: -288px 0px}\n.dojoE2TBIcon_CenterJustify { background-position: -306px 0px}\n.dojoE2TBIcon_BlockJustify { background-position: -324px 0px}\n.dojoE2TBIcon_LeftJustify { background-position: -342px 0px}\n.dojoE2TBIcon_RightJustify { background-position: -360px 0px}\n.dojoE2TBIcon_left_to_right { background-position: -378px 0px}\n.dojoE2TBIcon_list_bullet_indent { background-position: -396px 0px}\n.dojoE2TBIcon_list_bullet_outdent { background-position: -414px 0px}\n.dojoE2TBIcon_list_num_indent { background-position: -432px 0px}\n.dojoE2TBIcon_list_num_outdent { background-position: -450px 0px}\n.dojoE2TBIcon_Outdent { background-position: -468px 0px}\n.dojoE2TBIcon_Paste { background-position: -486px 0px}\n.dojoE2TBIcon_Redo { background-position: -504px 0px}\ndojoE2TBIcon_RemoveFormat { background-position: -522px 0px}\n.dojoE2TBIcon_right_to_left { background-position: -540px 0px}\n.dojoE2TBIcon_Save { background-position: -558px 0px}\n.dojoE2TBIcon_Space { background-position: -576px 0px}\n.dojoE2TBIcon_StrikeThrough { background-position: -594px 0px}\n.dojoE2TBIcon_Subscript { background-position: -612px 0px}\n.dojoE2TBIcon_Superscript { background-position: -630px 0px}\n.dojoE2TBIcon_Underline { background-position: -648px 0px}\n.dojoE2TBIcon_Undo { background-position: -666px 0px}\n.dojoE2TBIcon_WikiWord { background-position: -684px 0px}\n\n",templateCssPath:dojo.uri.moduleUri("dojo.widget","templates/EditorToolbar.css"),ToolbarLatchedItemStyle:"ToolbarButtonLatched",ToolbarEnabledItemStyle:"ToolbarButtonEnabled",ToolbarDisabledItemStyle:"ToolbarButtonDisabled",ToolbarHighlightedItemStyle:"ToolbarButtonHighlighted",ToolbarHighlightedSelectStyle:"ToolbarSelectHighlighted",ToolbarHighlightedSelectItemStyle:"ToolbarSelectHighlightedItem",postCreate:function(){
var _a38=dojo.html.getElementsByClass("dojoEditorToolbarItem",this.domNode);
this.items={};
for(var x=0;x<_a38.length;x++){
var node=_a38[x];
var _a3b=node.getAttribute("dojoETItemName");
if(_a3b){
var item=dojo.widget.Editor2ToolbarItemManager.getToolbarItem(_a3b);
if(item){
item.create(node,this);
this.items[_a3b.toLowerCase()]=item;
}else{
node.style.display="none";
}
}
}
},update:function(){
for(var cmd in this.items){
this.items[cmd].refreshState();
}
},shareGroup:"",checkAvailability:function(){
if(!this.shareGroup){
this.parent.focus();
return true;
}
var _a3e=dojo.widget.Editor2Manager.getCurrentInstance();
if(this.shareGroup==_a3e.toolbarGroup){
return true;
}
return false;
},destroy:function(){
for(var it in this.items){
this.items[it].destroy();
delete this.items[it];
}
dojo.widget.Editor2Toolbar.superclass.destroy.call(this);
}});
dojo.provide("dojo.uri.cache");
dojo.uri.cache={_cache:{},set:function(uri,_a41){
this._cache[uri.toString()]=_a41;
return uri;
},remove:function(uri){
delete this._cache[uri.toString()];
},get:function(uri){
var key=uri.toString();
var _a45=this._cache[key];
if(!_a45){
_a45=dojo.hostenv.getText(key);
if(_a45){
this._cache[key]=_a45;
}
}
return _a45;
},allow:function(uri){
return uri;
}};
dojo.provide("dojo.lfx.shadow");
dojo.lfx.shadow=function(node){
this.shadowPng=dojo.uri.moduleUri("dojo.html","images/shadow");
this.shadowThickness=8;
this.shadowOffset=15;
this.init(node);
};
dojo.extend(dojo.lfx.shadow,{init:function(node){
this.node=node;
this.pieces={};
var x1=-1*this.shadowThickness;
var y0=this.shadowOffset;
var y1=this.shadowOffset+this.shadowThickness;
this._makePiece("tl","top",y0,"left",x1);
this._makePiece("l","top",y1,"left",x1,"scale");
this._makePiece("tr","top",y0,"left",0);
this._makePiece("r","top",y1,"left",0,"scale");
this._makePiece("bl","top",0,"left",x1);
this._makePiece("b","top",0,"left",0,"crop");
this._makePiece("br","top",0,"left",0);
},_makePiece:function(name,_a4d,_a4e,_a4f,_a50,_a51){
var img;
var url=this.shadowPng+name.toUpperCase()+".png";
if(dojo.render.html.ie55||dojo.render.html.ie60){
img=dojo.doc().createElement("div");
img.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+url+"'"+(_a51?", sizingMethod='"+_a51+"'":"")+")";
}else{
img=dojo.doc().createElement("img");
img.src=url;
}
img.style.position="absolute";
img.style[_a4d]=_a4e+"px";
img.style[_a4f]=_a50+"px";
img.style.width=this.shadowThickness+"px";
img.style.height=this.shadowThickness+"px";
this.pieces[name]=img;
this.node.appendChild(img);
},size:function(_a54,_a55){
var _a56=_a55-(this.shadowOffset+this.shadowThickness+1);
if(_a56<0){
_a56=0;
}
if(_a55<1){
_a55=1;
}
if(_a54<1){
_a54=1;
}
with(this.pieces){
l.style.height=_a56+"px";
r.style.height=_a56+"px";
b.style.width=(_a54-1)+"px";
bl.style.top=(_a55-1)+"px";
b.style.top=(_a55-1)+"px";
br.style.top=(_a55-1)+"px";
tr.style.left=(_a54-1)+"px";
r.style.left=(_a54-1)+"px";
br.style.left=(_a54-1)+"px";
}
}});
dojo.provide("dojo.widget.html.layout");
dojo.widget.html.layout=function(_a57,_a58,_a59){
dojo.html.addClass(_a57,"dojoLayoutContainer");
_a58=dojo.lang.filter(_a58,function(_a5a,idx){
_a5a.idx=idx;
return dojo.lang.inArray(["top","bottom","left","right","client","flood"],_a5a.layoutAlign);
});
if(_a59&&_a59!="none"){
var rank=function(_a5d){
switch(_a5d.layoutAlign){
case "flood":
return 1;
case "left":
case "right":
return (_a59=="left-right")?2:3;
case "top":
case "bottom":
return (_a59=="left-right")?3:2;
default:
return 4;
}
};
_a58.sort(function(a,b){
return (rank(a)-rank(b))||(a.idx-b.idx);
});
}
var f={top:dojo.html.getPixelValue(_a57,"padding-top",true),left:dojo.html.getPixelValue(_a57,"padding-left",true)};
dojo.lang.mixin(f,dojo.html.getContentBox(_a57));
dojo.lang.forEach(_a58,function(_a61){
var elm=_a61.domNode;
var pos=_a61.layoutAlign;
with(elm.style){
left=f.left+"px";
top=f.top+"px";
bottom="auto";
right="auto";
}
dojo.html.addClass(elm,"dojoAlign"+dojo.string.capitalize(pos));
if((pos=="top")||(pos=="bottom")){
dojo.html.setMarginBox(elm,{width:f.width});
var h=dojo.html.getMarginBox(elm).height;
f.height-=h;
if(pos=="top"){
f.top+=h;
}else{
elm.style.top=f.top+f.height+"px";
}
if(_a61.onResized){
_a61.onResized();
}
}else{
if(pos=="left"||pos=="right"){
var w=dojo.html.getMarginBox(elm).width;
if(_a61.resizeTo){
_a61.resizeTo(w,f.height);
}else{
dojo.html.setMarginBox(elm,{width:w,height:f.height});
}
f.width-=w;
if(pos=="left"){
f.left+=w;
}else{
elm.style.left=f.left+f.width+"px";
}
}else{
if(pos=="flood"||pos=="client"){
if(_a61.resizeTo){
_a61.resizeTo(f.width,f.height);
}else{
dojo.html.setMarginBox(elm,{width:f.width,height:f.height});
}
}
}
}
});
};
dojo.html.insertCssText(".dojoLayoutContainer{ position: relative; display: block; overflow: hidden; }\n"+"body .dojoAlignTop, body .dojoAlignBottom, body .dojoAlignLeft, body .dojoAlignRight { position: absolute; overflow: hidden; }\n"+"body .dojoAlignClient { position: absolute }\n"+".dojoAlignClient { overflow: auto; }\n");
dojo.provide("dojo.dnd.DragAndDrop");
dojo.declare("dojo.dnd.DragSource",null,{type:"",onDragEnd:function(evt){
},onDragStart:function(evt){
},onSelected:function(evt){
},unregister:function(){
dojo.dnd.dragManager.unregisterDragSource(this);
},reregister:function(){
dojo.dnd.dragManager.registerDragSource(this);
}});
dojo.declare("dojo.dnd.DragObject",null,{type:"",register:function(){
var dm=dojo.dnd.dragManager;
if(dm["registerDragObject"]){
dm.registerDragObject(this);
}
},onDragStart:function(evt){
},onDragMove:function(evt){
},onDragOver:function(evt){
},onDragOut:function(evt){
},onDragEnd:function(evt){
},onDragLeave:dojo.lang.forward("onDragOut"),onDragEnter:dojo.lang.forward("onDragOver"),ondragout:dojo.lang.forward("onDragOut"),ondragover:dojo.lang.forward("onDragOver")});
dojo.declare("dojo.dnd.DropTarget",null,{acceptsType:function(type){
if(!dojo.lang.inArray(this.acceptedTypes,"*")){
if(!dojo.lang.inArray(this.acceptedTypes,type)){
return false;
}
}
return true;
},accepts:function(_a70){
if(!dojo.lang.inArray(this.acceptedTypes,"*")){
for(var i=0;i<_a70.length;i++){
if(!dojo.lang.inArray(this.acceptedTypes,_a70[i].type)){
return false;
}
}
}
return true;
},unregister:function(){
dojo.dnd.dragManager.unregisterDropTarget(this);
},onDragOver:function(evt){
},onDragOut:function(evt){
},onDragMove:function(evt){
},onDropStart:function(evt){
},onDrop:function(evt){
},onDropEnd:function(){
}},function(){
this.acceptedTypes=[];
});
dojo.dnd.DragEvent=function(){
this.dragSource=null;
this.dragObject=null;
this.target=null;
this.eventStatus="success";
};
dojo.declare("dojo.dnd.DragManager",null,{selectedSources:[],dragObjects:[],dragSources:[],registerDragSource:function(_a77){
},dropTargets:[],registerDropTarget:function(_a78){
},lastDragTarget:null,currentDragTarget:null,onKeyDown:function(){
},onMouseOut:function(){
},onMouseMove:function(){
},onMouseUp:function(){
}});
dojo.provide("dojo.dnd.HtmlDragManager");
dojo.declare("dojo.dnd.HtmlDragManager",dojo.dnd.DragManager,{disabled:false,nestedTargets:false,mouseDownTimer:null,dsCounter:0,dsPrefix:"dojoDragSource",dropTargetDimensions:[],currentDropTarget:null,previousDropTarget:null,_dragTriggered:false,selectedSources:[],dragObjects:[],dragSources:[],dropTargets:[],currentX:null,currentY:null,lastX:null,lastY:null,mouseDownX:null,mouseDownY:null,threshold:7,dropAcceptable:false,cancelEvent:function(e){
e.stopPropagation();
e.preventDefault();
},registerDragSource:function(ds){
if(ds["domNode"]){
var dp=this.dsPrefix;
var _a7c=dp+"Idx_"+(this.dsCounter++);
ds.dragSourceId=_a7c;
this.dragSources[_a7c]=ds;
ds.domNode.setAttribute(dp,_a7c);
if(dojo.render.html.ie){
dojo.event.browser.addListener(ds.domNode,"ondragstart",this.cancelEvent);
}
}
},unregisterDragSource:function(ds){
if(ds["domNode"]){
var dp=this.dsPrefix;
var _a7f=ds.dragSourceId;
delete ds.dragSourceId;
delete this.dragSources[_a7f];
ds.domNode.setAttribute(dp,null);
if(dojo.render.html.ie){
dojo.event.browser.removeListener(ds.domNode,"ondragstart",this.cancelEvent);
}
}
},registerDropTarget:function(dt){
this.dropTargets.push(dt);
},unregisterDropTarget:function(dt){
var _a82=dojo.lang.find(this.dropTargets,dt,true);
if(_a82>=0){
this.dropTargets.splice(_a82,1);
}
},getDragSource:function(e){
var tn=e.target;
if(tn===dojo.body()){
return;
}
var ta=dojo.html.getAttribute(tn,this.dsPrefix);
while((!ta)&&(tn)){
tn=tn.parentNode;
if((!tn)||(tn===dojo.body())){
return;
}
ta=dojo.html.getAttribute(tn,this.dsPrefix);
}
return this.dragSources[ta];
},onKeyDown:function(e){
},onMouseDown:function(e){
if(this.disabled){
return;
}
if(dojo.render.html.ie){
if(e.button!=1){
return;
}
}else{
if(e.which!=1){
return;
}
}
var _a88=e.target.nodeType==dojo.html.TEXT_NODE?e.target.parentNode:e.target;
if(dojo.html.isTag(_a88,"button","textarea","input","select","option")){
return;
}
var ds=this.getDragSource(e);
if(!ds){
return;
}
if(!dojo.lang.inArray(this.selectedSources,ds)){
this.selectedSources.push(ds);
ds.onSelected();
}
this.mouseDownX=e.pageX;
this.mouseDownY=e.pageY;
e.preventDefault();
dojo.event.connect(document,"onmousemove",this,"onMouseMove");
},onMouseUp:function(e,_a8b){
if(this.selectedSources.length==0){
return;
}
this.mouseDownX=null;
this.mouseDownY=null;
this._dragTriggered=false;
e.dragSource=this.dragSource;
if((!e.shiftKey)&&(!e.ctrlKey)){
if(this.currentDropTarget){
this.currentDropTarget.onDropStart();
}
dojo.lang.forEach(this.dragObjects,function(_a8c){
var ret=null;
if(!_a8c){
return;
}
if(this.currentDropTarget){
e.dragObject=_a8c;
var ce=this.currentDropTarget.domNode.childNodes;
if(ce.length>0){
e.dropTarget=ce[0];
while(e.dropTarget==_a8c.domNode){
e.dropTarget=e.dropTarget.nextSibling;
}
}else{
e.dropTarget=this.currentDropTarget.domNode;
}
if(this.dropAcceptable){
ret=this.currentDropTarget.onDrop(e);
}else{
this.currentDropTarget.onDragOut(e);
}
}
e.dragStatus=this.dropAcceptable&&ret?"dropSuccess":"dropFailure";
dojo.lang.delayThese([function(){
try{
_a8c.dragSource.onDragEnd(e);
}
catch(err){
var _a8f={};
for(var i in e){
if(i=="type"){
_a8f.type="mouseup";
continue;
}
_a8f[i]=e[i];
}
_a8c.dragSource.onDragEnd(_a8f);
}
},function(){
_a8c.onDragEnd(e);
}]);
},this);
this.selectedSources=[];
this.dragObjects=[];
this.dragSource=null;
if(this.currentDropTarget){
this.currentDropTarget.onDropEnd();
}
}else{
}
dojo.event.disconnect(document,"onmousemove",this,"onMouseMove");
this.currentDropTarget=null;
},onScroll:function(){
for(var i=0;i<this.dragObjects.length;i++){
if(this.dragObjects[i].updateDragOffset){
this.dragObjects[i].updateDragOffset();
}
}
if(this.dragObjects.length){
this.cacheTargetLocations();
}
},_dragStartDistance:function(x,y){
if((!this.mouseDownX)||(!this.mouseDownX)){
return;
}
var dx=Math.abs(x-this.mouseDownX);
var dx2=dx*dx;
var dy=Math.abs(y-this.mouseDownY);
var dy2=dy*dy;
return parseInt(Math.sqrt(dx2+dy2),10);
},cacheTargetLocations:function(){
dojo.profile.start("cacheTargetLocations");
this.dropTargetDimensions=[];
dojo.lang.forEach(this.dropTargets,function(_a98){
var tn=_a98.domNode;
if(!tn||!_a98.accepts([this.dragSource])){
return;
}
var abs=dojo.html.getAbsolutePosition(tn,true);
var bb=dojo.html.getBorderBox(tn);
this.dropTargetDimensions.push([[abs.x,abs.y],[abs.x+bb.width,abs.y+bb.height],_a98]);
},this);
dojo.profile.end("cacheTargetLocations");
},onMouseMove:function(e){
if((dojo.render.html.ie)&&(e.button!=1)){
this.currentDropTarget=null;
this.onMouseUp(e,true);
return;
}
if((this.selectedSources.length)&&(!this.dragObjects.length)){
var dx;
var dy;
if(!this._dragTriggered){
this._dragTriggered=(this._dragStartDistance(e.pageX,e.pageY)>this.threshold);
if(!this._dragTriggered){
return;
}
dx=e.pageX-this.mouseDownX;
dy=e.pageY-this.mouseDownY;
}
this.dragSource=this.selectedSources[0];
dojo.lang.forEach(this.selectedSources,function(_a9f){
if(!_a9f){
return;
}
var tdo=_a9f.onDragStart(e);
if(tdo){
tdo.onDragStart(e);
tdo.dragOffset.y+=dy;
tdo.dragOffset.x+=dx;
tdo.dragSource=_a9f;
this.dragObjects.push(tdo);
}
},this);
this.previousDropTarget=null;
this.cacheTargetLocations();
}
dojo.lang.forEach(this.dragObjects,function(_aa1){
if(_aa1){
_aa1.onDragMove(e);
}
});
if(this.currentDropTarget){
var c=dojo.html.toCoordinateObject(this.currentDropTarget.domNode,true);
var dtp=[[c.x,c.y],[c.x+c.width,c.y+c.height]];
}
if((!this.nestedTargets)&&(dtp)&&(this.isInsideBox(e,dtp))){
if(this.dropAcceptable){
this.currentDropTarget.onDragMove(e,this.dragObjects);
}
}else{
var _aa4=this.findBestTarget(e);
if(_aa4.target===null){
if(this.currentDropTarget){
this.currentDropTarget.onDragOut(e);
this.previousDropTarget=this.currentDropTarget;
this.currentDropTarget=null;
}
this.dropAcceptable=false;
return;
}
if(this.currentDropTarget!==_aa4.target){
if(this.currentDropTarget){
this.previousDropTarget=this.currentDropTarget;
this.currentDropTarget.onDragOut(e);
}
this.currentDropTarget=_aa4.target;
e.dragObjects=this.dragObjects;
this.dropAcceptable=this.currentDropTarget.onDragOver(e);
}else{
if(this.dropAcceptable){
this.currentDropTarget.onDragMove(e,this.dragObjects);
}
}
}
},findBestTarget:function(e){
var _aa6=this;
var _aa7=new Object();
_aa7.target=null;
_aa7.points=null;
dojo.lang.every(this.dropTargetDimensions,function(_aa8){
if(!_aa6.isInsideBox(e,_aa8)){
return true;
}
_aa7.target=_aa8[2];
_aa7.points=_aa8;
return Boolean(_aa6.nestedTargets);
});
return _aa7;
},isInsideBox:function(e,_aaa){
if((e.pageX>_aaa[0][0])&&(e.pageX<_aaa[1][0])&&(e.pageY>_aaa[0][1])&&(e.pageY<_aaa[1][1])){
return true;
}
return false;
},onMouseOver:function(e){
},onMouseOut:function(e){
}});
dojo.dnd.dragManager=new dojo.dnd.HtmlDragManager();
(function(){
var d=document;
var dm=dojo.dnd.dragManager;
dojo.event.connect(d,"onkeydown",dm,"onKeyDown");
dojo.event.connect(d,"onmouseover",dm,"onMouseOver");
dojo.event.connect(d,"onmouseout",dm,"onMouseOut");
dojo.event.connect(d,"onmousedown",dm,"onMouseDown");
dojo.event.connect(d,"onmouseup",dm,"onMouseUp");
dojo.event.connect(window,"onscroll",dm,"onScroll");
})();
dojo.provide("dojo.dnd.HtmlDragAndDrop");
dojo.declare("dojo.dnd.HtmlDragSource",dojo.dnd.DragSource,{dragClass:"",onDragStart:function(){
var _aaf=new dojo.dnd.HtmlDragObject(this.dragObject,this.type);
if(this.dragClass){
_aaf.dragClass=this.dragClass;
}
if(this.constrainToContainer){
_aaf.constrainTo(this.constrainingContainer||this.domNode.parentNode);
}
return _aaf;
},setDragHandle:function(node){
node=dojo.byId(node);
dojo.dnd.dragManager.unregisterDragSource(this);
this.domNode=node;
dojo.dnd.dragManager.registerDragSource(this);
},setDragTarget:function(node){
this.dragObject=node;
},constrainTo:function(_ab2){
this.constrainToContainer=true;
if(_ab2){
this.constrainingContainer=_ab2;
}
},onSelected:function(){
for(var i=0;i<this.dragObjects.length;i++){
dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragSource(this.dragObjects[i]));
}
},addDragObjects:function(el){
for(var i=0;i<arguments.length;i++){
this.dragObjects.push(dojo.byId(arguments[i]));
}
}},function(node,type){
node=dojo.byId(node);
this.dragObjects=[];
this.constrainToContainer=false;
if(node){
this.domNode=node;
this.dragObject=node;
this.type=(type)||(this.domNode.nodeName.toLowerCase());
dojo.dnd.DragSource.prototype.reregister.call(this);
}
});
dojo.declare("dojo.dnd.HtmlDragObject",dojo.dnd.DragObject,{dragClass:"",opacity:0.5,createIframe:true,disableX:false,disableY:false,createDragNode:function(){
var node=this.domNode.cloneNode(true);
if(this.dragClass){
dojo.html.addClass(node,this.dragClass);
}
if(this.opacity<1){
dojo.html.setOpacity(node,this.opacity);
}
var ltn=node.tagName.toLowerCase();
var isTr=(ltn=="tr");
if((isTr)||(ltn=="tbody")){
var doc=this.domNode.ownerDocument;
var _abc=doc.createElement("table");
if(isTr){
var _abd=doc.createElement("tbody");
_abc.appendChild(_abd);
_abd.appendChild(node);
}else{
_abc.appendChild(node);
}
var _abe=((isTr)?this.domNode:this.domNode.firstChild);
var _abf=((isTr)?node:node.firstChild);
var _ac0=_abe.childNodes;
var _ac1=_abf.childNodes;
for(var i=0;i<_ac0.length;i++){
if((_ac1[i])&&(_ac1[i].style)){
_ac1[i].style.width=dojo.html.getContentBox(_ac0[i]).width+"px";
}
}
node=_abc;
}
if((dojo.render.html.ie55||dojo.render.html.ie60)&&this.createIframe){
with(node.style){
top="0px";
left="0px";
}
var _ac3=document.createElement("div");
_ac3.appendChild(node);
this.bgIframe=new dojo.html.BackgroundIframe(_ac3);
_ac3.appendChild(this.bgIframe.iframe);
node=_ac3;
}
node.style.zIndex=999;
return node;
},onDragStart:function(e){
dojo.html.clearSelection();
this.scrollOffset=dojo.html.getScroll().offset;
this.dragStartPosition=dojo.html.getAbsolutePosition(this.domNode,true);
this.dragOffset={y:this.dragStartPosition.y-e.pageY,x:this.dragStartPosition.x-e.pageX};
this.dragClone=this.createDragNode();
this.containingBlockPosition=this.domNode.offsetParent?dojo.html.getAbsolutePosition(this.domNode.offsetParent,true):{x:0,y:0};
if(this.constrainToContainer){
this.constraints=this.getConstraints();
}
with(this.dragClone.style){
position="absolute";
top=this.dragOffset.y+e.pageY+"px";
left=this.dragOffset.x+e.pageX+"px";
}
dojo.body().appendChild(this.dragClone);
dojo.event.topic.publish("dragStart",{source:this});
},getConstraints:function(){
if(this.constrainingContainer.nodeName.toLowerCase()=="body"){
var _ac5=dojo.html.getViewport();
var _ac6=_ac5.width;
var _ac7=_ac5.height;
var _ac8=dojo.html.getScroll().offset;
var x=_ac8.x;
var y=_ac8.y;
}else{
var _acb=dojo.html.getContentBox(this.constrainingContainer);
_ac6=_acb.width;
_ac7=_acb.height;
x=this.containingBlockPosition.x+dojo.html.getPixelValue(this.constrainingContainer,"padding-left",true)+dojo.html.getBorderExtent(this.constrainingContainer,"left");
y=this.containingBlockPosition.y+dojo.html.getPixelValue(this.constrainingContainer,"padding-top",true)+dojo.html.getBorderExtent(this.constrainingContainer,"top");
}
var mb=dojo.html.getMarginBox(this.domNode);
return {minX:x,minY:y,maxX:x+_ac6-mb.width,maxY:y+_ac7-mb.height};
},updateDragOffset:function(){
var _acd=dojo.html.getScroll().offset;
if(_acd.y!=this.scrollOffset.y){
var diff=_acd.y-this.scrollOffset.y;
this.dragOffset.y+=diff;
this.scrollOffset.y=_acd.y;
}
if(_acd.x!=this.scrollOffset.x){
var diff=_acd.x-this.scrollOffset.x;
this.dragOffset.x+=diff;
this.scrollOffset.x=_acd.x;
}
},onDragMove:function(e){
this.updateDragOffset();
var x=this.dragOffset.x+e.pageX;
var y=this.dragOffset.y+e.pageY;
if(this.constrainToContainer){
if(x<this.constraints.minX){
x=this.constraints.minX;
}
if(y<this.constraints.minY){
y=this.constraints.minY;
}
if(x>this.constraints.maxX){
x=this.constraints.maxX;
}
if(y>this.constraints.maxY){
y=this.constraints.maxY;
}
}
this.setAbsolutePosition(x,y);
dojo.event.topic.publish("dragMove",{source:this});
},setAbsolutePosition:function(x,y){
if(!this.disableY){
this.dragClone.style.top=y+"px";
}
if(!this.disableX){
this.dragClone.style.left=x+"px";
}
},onDragEnd:function(e){
switch(e.dragStatus){
case "dropSuccess":
dojo.html.removeNode(this.dragClone);
this.dragClone=null;
break;
case "dropFailure":
var _ad5=dojo.html.getAbsolutePosition(this.dragClone,true);
var _ad6={left:this.dragStartPosition.x+1,top:this.dragStartPosition.y+1};
var anim=dojo.lfx.slideTo(this.dragClone,_ad6,300);
var _ad8=this;
dojo.event.connect(anim,"onEnd",function(e){
dojo.html.removeNode(_ad8.dragClone);
_ad8.dragClone=null;
});
anim.play();
break;
}
dojo.event.topic.publish("dragEnd",{source:this});
},constrainTo:function(_ada){
this.constrainToContainer=true;
if(_ada){
this.constrainingContainer=_ada;
}else{
this.constrainingContainer=this.domNode.parentNode;
}
}},function(node,type){
this.domNode=dojo.byId(node);
this.type=type;
this.constrainToContainer=false;
this.dragSource=null;
dojo.dnd.DragObject.prototype.register.call(this);
});
dojo.declare("dojo.dnd.HtmlDropTarget",dojo.dnd.DropTarget,{vertical:false,onDragOver:function(e){
if(!this.accepts(e.dragObjects)){
return false;
}
this.childBoxes=[];
for(var i=0,_adf;i<this.domNode.childNodes.length;i++){
_adf=this.domNode.childNodes[i];
if(_adf.nodeType!=dojo.html.ELEMENT_NODE){
continue;
}
var pos=dojo.html.getAbsolutePosition(_adf,true);
var _ae1=dojo.html.getBorderBox(_adf);
this.childBoxes.push({top:pos.y,bottom:pos.y+_ae1.height,left:pos.x,right:pos.x+_ae1.width,height:_ae1.height,width:_ae1.width,node:_adf});
}
return true;
},_getNodeUnderMouse:function(e){
for(var i=0,_ae4;i<this.childBoxes.length;i++){
with(this.childBoxes[i]){
if(e.pageX>=left&&e.pageX<=right&&e.pageY>=top&&e.pageY<=bottom){
return i;
}
}
}
return -1;
},createDropIndicator:function(){
this.dropIndicator=document.createElement("div");
with(this.dropIndicator.style){
position="absolute";
zIndex=999;
if(this.vertical){
borderLeftWidth="1px";
borderLeftColor="black";
borderLeftStyle="solid";
height=dojo.html.getBorderBox(this.domNode).height+"px";
top=dojo.html.getAbsolutePosition(this.domNode,true).y+"px";
}else{
borderTopWidth="1px";
borderTopColor="black";
borderTopStyle="solid";
width=dojo.html.getBorderBox(this.domNode).width+"px";
left=dojo.html.getAbsolutePosition(this.domNode,true).x+"px";
}
}
},onDragMove:function(e,_ae6){
var i=this._getNodeUnderMouse(e);
if(!this.dropIndicator){
this.createDropIndicator();
}
var _ae8=this.vertical?dojo.html.gravity.WEST:dojo.html.gravity.NORTH;
var hide=false;
if(i<0){
if(this.childBoxes.length){
var _aea=(dojo.html.gravity(this.childBoxes[0].node,e)&_ae8);
if(_aea){
hide=true;
}
}else{
var _aea=true;
}
}else{
var _aeb=this.childBoxes[i];
var _aea=(dojo.html.gravity(_aeb.node,e)&_ae8);
if(_aeb.node===_ae6[0].dragSource.domNode){
hide=true;
}else{
var _aec=_aea?(i>0?this.childBoxes[i-1]:_aeb):(i<this.childBoxes.length-1?this.childBoxes[i+1]:_aeb);
if(_aec.node===_ae6[0].dragSource.domNode){
hide=true;
}
}
}
if(hide){
this.dropIndicator.style.display="none";
return;
}else{
this.dropIndicator.style.display="";
}
this.placeIndicator(e,_ae6,i,_aea);
if(!dojo.html.hasParent(this.dropIndicator)){
dojo.body().appendChild(this.dropIndicator);
}
},placeIndicator:function(e,_aee,_aef,_af0){
var _af1=this.vertical?"left":"top";
var _af2;
if(_aef<0){
if(this.childBoxes.length){
_af2=_af0?this.childBoxes[0]:this.childBoxes[this.childBoxes.length-1];
}else{
this.dropIndicator.style[_af1]=dojo.html.getAbsolutePosition(this.domNode,true)[this.vertical?"x":"y"]+"px";
}
}else{
_af2=this.childBoxes[_aef];
}
if(_af2){
this.dropIndicator.style[_af1]=(_af0?_af2[_af1]:_af2[this.vertical?"right":"bottom"])+"px";
if(this.vertical){
this.dropIndicator.style.height=_af2.height+"px";
this.dropIndicator.style.top=_af2.top+"px";
}else{
this.dropIndicator.style.width=_af2.width+"px";
this.dropIndicator.style.left=_af2.left+"px";
}
}
},onDragOut:function(e){
if(this.dropIndicator){
dojo.html.removeNode(this.dropIndicator);
delete this.dropIndicator;
}
},onDrop:function(e){
this.onDragOut(e);
var i=this._getNodeUnderMouse(e);
var _af6=this.vertical?dojo.html.gravity.WEST:dojo.html.gravity.NORTH;
if(i<0){
if(this.childBoxes.length){
if(dojo.html.gravity(this.childBoxes[0].node,e)&_af6){
return this.insert(e,this.childBoxes[0].node,"before");
}else{
return this.insert(e,this.childBoxes[this.childBoxes.length-1].node,"after");
}
}
return this.insert(e,this.domNode,"append");
}
var _af7=this.childBoxes[i];
if(dojo.html.gravity(_af7.node,e)&_af6){
return this.insert(e,_af7.node,"before");
}else{
return this.insert(e,_af7.node,"after");
}
},insert:function(e,_af9,_afa){
var node=e.dragObject.domNode;
if(_afa=="before"){
return dojo.html.insertBefore(node,_af9);
}else{
if(_afa=="after"){
return dojo.html.insertAfter(node,_af9);
}else{
if(_afa=="append"){
_af9.appendChild(node);
return true;
}
}
}
return false;
}},function(node,_afd){
if(arguments.length==0){
return;
}
this.domNode=dojo.byId(node);
dojo.dnd.DropTarget.call(this);
if(_afd&&dojo.lang.isString(_afd)){
_afd=[_afd];
}
this.acceptedTypes=_afd||[];
dojo.dnd.dragManager.registerDropTarget(this);
});
dojo.kwCompoundRequire({common:["dojo.dnd.DragAndDrop"],browser:["dojo.dnd.HtmlDragAndDrop"],dashboard:["dojo.dnd.HtmlDragAndDrop"]});
dojo.provide("dojo.dnd.*");
dojo.provide("dojo.dnd.HtmlDragMove");
dojo.declare("dojo.dnd.HtmlDragMoveSource",dojo.dnd.HtmlDragSource,{onDragStart:function(){
var _afe=new dojo.dnd.HtmlDragMoveObject(this.dragObject,this.type);
if(this.constrainToContainer){
_afe.constrainTo(this.constrainingContainer);
}
return _afe;
},onSelected:function(){
for(var i=0;i<this.dragObjects.length;i++){
dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragMoveSource(this.dragObjects[i]));
}
}});
dojo.declare("dojo.dnd.HtmlDragMoveObject",dojo.dnd.HtmlDragObject,{onDragStart:function(e){
dojo.html.clearSelection();
this.dragClone=this.domNode;
if(dojo.html.getComputedStyle(this.domNode,"position")!="absolute"){
this.domNode.style.position="relative";
}
var left=parseInt(dojo.html.getComputedStyle(this.domNode,"left"));
var top=parseInt(dojo.html.getComputedStyle(this.domNode,"top"));
this.dragStartPosition={x:isNaN(left)?0:left,y:isNaN(top)?0:top};
this.scrollOffset=dojo.html.getScroll().offset;
this.dragOffset={y:this.dragStartPosition.y-e.pageY,x:this.dragStartPosition.x-e.pageX};
this.containingBlockPosition={x:0,y:0};
if(this.constrainToContainer){
this.constraints=this.getConstraints();
}
dojo.event.connect(this.domNode,"onclick",this,"_squelchOnClick");
},onDragEnd:function(e){
},setAbsolutePosition:function(x,y){
if(!this.disableY){
this.domNode.style.top=y+"px";
}
if(!this.disableX){
this.domNode.style.left=x+"px";
}
},_squelchOnClick:function(e){
dojo.event.browser.stopEvent(e);
dojo.event.disconnect(this.domNode,"onclick",this,"_squelchOnClick");
}});
dojo.provide("dojo.widget.Dialog");
dojo.declare("dojo.widget.ModalDialogBase",null,{isContainer:true,focusElement:"",bgColor:"black",bgOpacity:0.4,followScroll:true,closeOnBackgroundClick:false,trapTabs:function(e){
if(e.target==this.tabStartOuter){
if(this._fromTrap){
this.tabStart.focus();
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabEnd.focus();
}
}else{
if(e.target==this.tabStart){
if(this._fromTrap){
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabEnd.focus();
}
}else{
if(e.target==this.tabEndOuter){
if(this._fromTrap){
this.tabEnd.focus();
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabStart.focus();
}
}else{
if(e.target==this.tabEnd){
if(this._fromTrap){
this._fromTrap=false;
}else{
this._fromTrap=true;
this.tabStart.focus();
}
}
}
}
}
},clearTrap:function(e){
var _b09=this;
setTimeout(function(){
_b09._fromTrap=false;
},100);
},postCreate:function(){
with(this.domNode.style){
position="absolute";
zIndex=999;
display="none";
overflow="visible";
}
var b=dojo.body();
b.appendChild(this.domNode);
this.bg=document.createElement("div");
this.bg.className="dialogUnderlay";
with(this.bg.style){
position="absolute";
left=top="0px";
zIndex=998;
display="none";
}
b.appendChild(this.bg);
this.setBackgroundColor(this.bgColor);
this.bgIframe=new dojo.html.BackgroundIframe();
if(this.bgIframe.iframe){
with(this.bgIframe.iframe.style){
position="absolute";
left=top="0px";
zIndex=90;
display="none";
}
}
if(this.closeOnBackgroundClick){
dojo.event.kwConnect({srcObj:this.bg,srcFunc:"onclick",adviceObj:this,adviceFunc:"onBackgroundClick",once:true});
}
},uninitialize:function(){
this.bgIframe.remove();
dojo.html.removeNode(this.bg,true);
},setBackgroundColor:function(_b0b){
if(arguments.length>=3){
_b0b=new dojo.gfx.color.Color(arguments[0],arguments[1],arguments[2]);
}else{
_b0b=new dojo.gfx.color.Color(_b0b);
}
this.bg.style.backgroundColor=_b0b.toString();
return this.bgColor=_b0b;
},setBackgroundOpacity:function(op){
if(arguments.length==0){
op=this.bgOpacity;
}
dojo.html.setOpacity(this.bg,op);
try{
this.bgOpacity=dojo.html.getOpacity(this.bg);
}
catch(e){
this.bgOpacity=op;
}
return this.bgOpacity;
},_sizeBackground:function(){
if(this.bgOpacity>0){
var _b0d=dojo.html.getViewport();
var h=_b0d.height;
var w=_b0d.width;
with(this.bg.style){
width=w+"px";
height=h+"px";
}
var _b10=dojo.html.getScroll().offset;
this.bg.style.top=_b10.y+"px";
this.bg.style.left=_b10.x+"px";
var _b0d=dojo.html.getViewport();
if(_b0d.width!=w){
this.bg.style.width=_b0d.width+"px";
}
if(_b0d.height!=h){
this.bg.style.height=_b0d.height+"px";
}
}
this.bgIframe.size(this.bg);
},_showBackground:function(){
if(this.bgOpacity>0){
this.bg.style.display="block";
}
if(this.bgIframe.iframe){
this.bgIframe.iframe.style.display="block";
}
},placeModalDialog:function(){
var _b11=dojo.html.getScroll().offset;
var _b12=dojo.html.getViewport();
var mb;
if(this.isShowing()){
mb=dojo.html.getMarginBox(this.domNode);
}else{
dojo.html.setVisibility(this.domNode,false);
dojo.html.show(this.domNode);
mb=dojo.html.getMarginBox(this.domNode);
dojo.html.hide(this.domNode);
dojo.html.setVisibility(this.domNode,true);
}
var x=_b11.x+(_b12.width-mb.width)/2;
var y=_b11.y+(_b12.height-mb.height)/2;
with(this.domNode.style){
left=x+"px";
top=y+"px";
}
},_onKey:function(evt){
if(evt.key){
var node=evt.target;
while(node!=null){
if(node==this.domNode){
return;
}
node=node.parentNode;
}
if(evt.key!=evt.KEY_TAB){
dojo.event.browser.stopEvent(evt);
}else{
if(!dojo.render.html.opera){
try{
this.tabStart.focus();
}
catch(e){
}
}
}
}
},showModalDialog:function(){
if(this.followScroll&&!this._scrollConnected){
this._scrollConnected=true;
dojo.event.connect(window,"onscroll",this,"_onScroll");
}
dojo.event.connect(document.documentElement,"onkey",this,"_onKey");
this.placeModalDialog();
this.setBackgroundOpacity();
this._sizeBackground();
this._showBackground();
this._fromTrap=true;
setTimeout(dojo.lang.hitch(this,function(){
try{
this.tabStart.focus();
}
catch(e){
}
}),50);
},hideModalDialog:function(){
if(this.focusElement){
dojo.byId(this.focusElement).focus();
dojo.byId(this.focusElement).blur();
}
this.bg.style.display="none";
this.bg.style.width=this.bg.style.height="1px";
if(this.bgIframe.iframe){
this.bgIframe.iframe.style.display="none";
}
dojo.event.disconnect(document.documentElement,"onkey",this,"_onKey");
if(this._scrollConnected){
this._scrollConnected=false;
dojo.event.disconnect(window,"onscroll",this,"_onScroll");
}
},_onScroll:function(){
var _b18=dojo.html.getScroll().offset;
this.bg.style.top=_b18.y+"px";
this.bg.style.left=_b18.x+"px";
this.placeModalDialog();
},checkSize:function(){
if(this.isShowing()){
this._sizeBackground();
this.placeModalDialog();
this.onResized();
}
},onBackgroundClick:function(){
if(this.lifetime-this.timeRemaining>=this.blockDuration){
return;
}
this.hide();
}});
dojo.widget.defineWidget("dojo.widget.Dialog",[dojo.widget.ContentPane,dojo.widget.ModalDialogBase],{templateString:"<div id=\"${this.widgetId}\" class=\"dojoDialog\" dojoattachpoint=\"wrapper\">\n\t<span dojoattachpoint=\"tabStartOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\"\ttabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabStart\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<div dojoattachpoint=\"containerNode\" style=\"position: relative; z-index: 2;\"></div>\n\t<span dojoattachpoint=\"tabEnd\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabEndOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n</div>\n",blockDuration:0,lifetime:0,closeNode:"",postMixInProperties:function(){
dojo.widget.Dialog.superclass.postMixInProperties.apply(this,arguments);
if(this.closeNode){
this.setCloseControl(this.closeNode);
}
},postCreate:function(){
dojo.widget.Dialog.superclass.postCreate.apply(this,arguments);
dojo.widget.ModalDialogBase.prototype.postCreate.apply(this,arguments);
},show:function(){
if(this.lifetime){
this.timeRemaining=this.lifetime;
if(this.timerNode){
this.timerNode.innerHTML=Math.ceil(this.timeRemaining/1000);
}
if(this.blockDuration&&this.closeNode){
if(this.lifetime>this.blockDuration){
this.closeNode.style.visibility="hidden";
}else{
this.closeNode.style.display="none";
}
}
if(this.timer){
clearInterval(this.timer);
}
this.timer=setInterval(dojo.lang.hitch(this,"_onTick"),100);
}
this.showModalDialog();
dojo.widget.Dialog.superclass.show.call(this);
},onLoad:function(){
this.placeModalDialog();
dojo.widget.Dialog.superclass.onLoad.call(this);
},fillInTemplate:function(){
},hide:function(){
this.hideModalDialog();
dojo.widget.Dialog.superclass.hide.call(this);
if(this.timer){
clearInterval(this.timer);
}
},setTimerNode:function(node){
this.timerNode=node;
},setCloseControl:function(node){
this.closeNode=dojo.byId(node);
dojo.event.connect(this.closeNode,"onclick",this,"hide");
},setShowControl:function(node){
node=dojo.byId(node);
dojo.event.connect(node,"onclick",this,"show");
},_onTick:function(){
if(this.timer){
this.timeRemaining-=100;
if(this.lifetime-this.timeRemaining>=this.blockDuration){
if(this.closeNode){
this.closeNode.style.visibility="visible";
}
}
if(!this.timeRemaining){
clearInterval(this.timer);
this.hide();
}else{
if(this.timerNode){
this.timerNode.innerHTML=Math.ceil(this.timeRemaining/1000);
}
}
}
}});
dojo.provide("dojo.widget.ResizeHandle");
dojo.widget.defineWidget("dojo.widget.ResizeHandle",dojo.widget.HtmlWidget,{targetElmId:"",templateCssString:".dojoHtmlResizeHandle {\n\tfloat: right;\n\tposition: absolute;\n\tright: 2px;\n\tbottom: 2px;\n\twidth: 13px;\n\theight: 13px;\n\tz-index: 20;\n\tcursor: nw-resize;\n\tbackground-image: url(grabCorner.gif);\n\tline-height: 0px;\n}\n",templateCssPath:dojo.uri.moduleUri("dojo.widget","templates/ResizeHandle.css"),templateString:"<div class=\"dojoHtmlResizeHandle\"><div></div></div>",postCreate:function(){
dojo.event.connect(this.domNode,"onmousedown",this,"_beginSizing");
},_beginSizing:function(e){
if(this._isSizing){
return false;
}
this.targetWidget=dojo.widget.byId(this.targetElmId);
this.targetDomNode=this.targetWidget?this.targetWidget.domNode:dojo.byId(this.targetElmId);
if(!this.targetDomNode){
return;
}
this._isSizing=true;
this.startPoint={"x":e.clientX,"y":e.clientY};
var mb=dojo.html.getMarginBox(this.targetDomNode);
this.startSize={"w":mb.width,"h":mb.height};
dojo.event.kwConnect({srcObj:dojo.body(),srcFunc:"onmousemove",targetObj:this,targetFunc:"_changeSizing",rate:25});
dojo.event.connect(dojo.body(),"onmouseup",this,"_endSizing");
e.preventDefault();
},_changeSizing:function(e){
try{
if(!e.clientX||!e.clientY){
return;
}
}
catch(e){
return;
}
var dx=this.startPoint.x-e.clientX;
var dy=this.startPoint.y-e.clientY;
var newW=this.startSize.w-dx;
var newH=this.startSize.h-dy;
if(this.minSize){
var mb=dojo.html.getMarginBox(this.targetDomNode);
if(newW<this.minSize.w){
newW=mb.width;
}
if(newH<this.minSize.h){
newH=mb.height;
}
}
if(this.targetWidget){
this.targetWidget.resizeTo(newW,newH);
}else{
dojo.html.setMarginBox(this.targetDomNode,{width:newW,height:newH});
}
e.preventDefault();
},_endSizing:function(e){
dojo.event.disconnect(dojo.body(),"onmousemove",this,"_changeSizing");
dojo.event.disconnect(dojo.body(),"onmouseup",this,"_endSizing");
this._isSizing=false;
}});
dojo.provide("dojo.widget.FloatingPane");
dojo.declare("dojo.widget.FloatingPaneBase",null,{title:"",iconSrc:"",hasShadow:false,constrainToContainer:false,taskBarId:"",resizable:true,titleBarDisplay:true,windowState:"normal",displayCloseAction:false,displayMinimizeAction:false,displayMaximizeAction:false,_max_taskBarConnectAttempts:5,_taskBarConnectAttempts:0,templateString:"<div id=\"${this.widgetId}\" dojoAttachEvent=\"onMouseDown\" class=\"dojoFloatingPane\">\n\t<div dojoAttachPoint=\"titleBar\" class=\"dojoFloatingPaneTitleBar\"  style=\"display:none\">\n\t  \t<img dojoAttachPoint=\"titleBarIcon\"  class=\"dojoFloatingPaneTitleBarIcon\">\n\t\t<div dojoAttachPoint=\"closeAction\" dojoAttachEvent=\"onClick:closeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneCloseIcon\"></div>\n\t\t<div dojoAttachPoint=\"restoreAction\" dojoAttachEvent=\"onClick:restoreWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneRestoreIcon\"></div>\n\t\t<div dojoAttachPoint=\"maximizeAction\" dojoAttachEvent=\"onClick:maximizeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneMaximizeIcon\"></div>\n\t\t<div dojoAttachPoint=\"minimizeAction\" dojoAttachEvent=\"onClick:minimizeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneMinimizeIcon\"></div>\n\t  \t<div dojoAttachPoint=\"titleBarText\" class=\"dojoFloatingPaneTitleText\">${this.title}</div>\n\t</div>\n\n\t<div id=\"${this.widgetId}_container\" dojoAttachPoint=\"containerNode\" class=\"dojoFloatingPaneClient\"></div>\n\n\t<div dojoAttachPoint=\"resizeBar\" class=\"dojoFloatingPaneResizebar\" style=\"display:none\"></div>\n</div>\n",templateCssString:"\n/********** Outer Window ***************/\n\n.dojoFloatingPane {\n\t/* essential css */\n\tposition: absolute;\n\toverflow: visible;\t\t/* so drop shadow is displayed */\n\tz-index: 10;\n\n\t/* styling css */\n\tborder: 1px solid;\n\tborder-color: ThreeDHighlight ThreeDShadow ThreeDShadow ThreeDHighlight;\n\tbackground-color: ThreeDFace;\n}\n\n\n/********** Title Bar ****************/\n\n.dojoFloatingPaneTitleBar {\n\tvertical-align: top;\n\tmargin: 2px 2px 2px 2px;\n\tz-index: 10;\n\tbackground-color: #7596c6;\n\tcursor: default;\n\toverflow: hidden;\n\tborder-color: ThreeDHighlight ThreeDShadow ThreeDShadow ThreeDHighlight;\n\tvertical-align: middle;\n}\n\n.dojoFloatingPaneTitleText {\n\tfloat: left;\n\tpadding: 2px 4px 2px 2px;\n\twhite-space: nowrap;\n\tcolor: CaptionText;\n\tfont: small-caption;\n}\n\n.dojoTitleBarIcon {\n\tfloat: left;\n\theight: 22px;\n\twidth: 22px;\n\tvertical-align: middle;\n\tmargin-right: 5px;\n\tmargin-left: 5px;\n}\n\n.dojoFloatingPaneActions{\n\tfloat: right;\n\tposition: absolute;\n\tright: 2px;\n\ttop: 2px;\n\tvertical-align: middle;\n}\n\n\n.dojoFloatingPaneActionItem {\n\tvertical-align: middle;\n\tmargin-right: 1px;\n\theight: 22px;\n\twidth: 22px;\n}\n\n\n.dojoFloatingPaneTitleBarIcon {\n\t/* essential css */\n\tfloat: left;\n\n\t/* styling css */\n\tmargin-left: 2px;\n\tmargin-right: 4px;\n\theight: 22px;\n}\n\n/* minimize/maximize icons are specified by CSS only */\n.dojoFloatingPaneMinimizeIcon,\n.dojoFloatingPaneMaximizeIcon,\n.dojoFloatingPaneRestoreIcon,\n.dojoFloatingPaneCloseIcon {\n\tvertical-align: middle;\n\theight: 22px;\n\twidth: 22px;\n\tfloat: right;\n}\n.dojoFloatingPaneMinimizeIcon {\n\tbackground-image: url(images/floatingPaneMinimize.gif);\n}\n.dojoFloatingPaneMaximizeIcon {\n\tbackground-image: url(images/floatingPaneMaximize.gif);\n}\n.dojoFloatingPaneRestoreIcon {\n\tbackground-image: url(images/floatingPaneRestore.gif);\n}\n.dojoFloatingPaneCloseIcon {\n\tbackground-image: url(images/floatingPaneClose.gif);\n}\n\n/* bar at bottom of window that holds resize handle */\n.dojoFloatingPaneResizebar {\n\tz-index: 10;\n\theight: 13px;\n\tbackground-color: ThreeDFace;\n}\n\n/************* Client Area ***************/\n\n.dojoFloatingPaneClient {\n\tposition: relative;\n\tz-index: 10;\n\tborder: 1px solid;\n\tborder-color: ThreeDShadow ThreeDHighlight ThreeDHighlight ThreeDShadow;\n\tmargin: 2px;\n\tbackground-color: ThreeDFace;\n\tpadding: 8px;\n\tfont-family: Verdana, Helvetica, Garamond, sans-serif;\n\tfont-size: 12px;\n\toverflow: auto;\n}\n\n",templateCssPath:dojo.uri.moduleUri("dojo.widget","templates/FloatingPane.css"),fillInFloatingPaneTemplate:function(args,frag){
var _b27=this.getFragNodeRef(frag);
dojo.html.copyStyle(this.domNode,_b27);
dojo.body().appendChild(this.domNode);
if(!this.isShowing()){
this.windowState="minimized";
}
if(this.iconSrc==""){
dojo.html.removeNode(this.titleBarIcon);
}else{
this.titleBarIcon.src=this.iconSrc.toString();
}
if(this.titleBarDisplay){
this.titleBar.style.display="";
dojo.html.disableSelection(this.titleBar);
this.titleBarIcon.style.display=(this.iconSrc==""?"none":"");
this.minimizeAction.style.display=(this.displayMinimizeAction?"":"none");
this.maximizeAction.style.display=(this.displayMaximizeAction&&this.windowState!="maximized"?"":"none");
this.restoreAction.style.display=(this.displayMaximizeAction&&this.windowState=="maximized"?"":"none");
this.closeAction.style.display=(this.displayCloseAction?"":"none");
this.drag=new dojo.dnd.HtmlDragMoveSource(this.domNode);
if(this.constrainToContainer){
this.drag.constrainTo();
}
this.drag.setDragHandle(this.titleBar);
var self=this;
dojo.event.topic.subscribe("dragMove",function(info){
if(info.source.domNode==self.domNode){
dojo.event.topic.publish("floatingPaneMove",{source:self});
}
});
}
if(this.resizable){
this.resizeBar.style.display="";
this.resizeHandle=dojo.widget.createWidget("ResizeHandle",{targetElmId:this.widgetId,id:this.widgetId+"_resize"});
this.resizeBar.appendChild(this.resizeHandle.domNode);
}
if(this.hasShadow){
this.shadow=new dojo.lfx.shadow(this.domNode);
}
this.bgIframe=new dojo.html.BackgroundIframe(this.domNode);
if(this.taskBarId){
this._taskBarSetup();
}
dojo.body().removeChild(this.domNode);
},postCreate:function(){
if(dojo.hostenv.post_load_){
this._setInitialWindowState();
}else{
dojo.addOnLoad(this,"_setInitialWindowState");
}
},maximizeWindow:function(evt){
var mb=dojo.html.getMarginBox(this.domNode);
this.previous={width:mb.width||this.width,height:mb.height||this.height,left:this.domNode.style.left,top:this.domNode.style.top,bottom:this.domNode.style.bottom,right:this.domNode.style.right};
if(this.domNode.parentNode.style.overflow.toLowerCase()!="hidden"){
this.parentPrevious={overflow:this.domNode.parentNode.style.overflow};
dojo.debug(this.domNode.parentNode.style.overflow);
this.domNode.parentNode.style.overflow="hidden";
}
this.domNode.style.left=dojo.html.getPixelValue(this.domNode.parentNode,"padding-left",true)+"px";
this.domNode.style.top=dojo.html.getPixelValue(this.domNode.parentNode,"padding-top",true)+"px";
if((this.domNode.parentNode.nodeName.toLowerCase()=="body")){
var _b2c=dojo.html.getViewport();
var _b2d=dojo.html.getPadding(dojo.body());
this.resizeTo(_b2c.width-_b2d.width,_b2c.height-_b2d.height);
}else{
var _b2e=dojo.html.getContentBox(this.domNode.parentNode);
this.resizeTo(_b2e.width,_b2e.height);
}
this.maximizeAction.style.display="none";
this.restoreAction.style.display="";
if(this.resizeHandle){
this.resizeHandle.domNode.style.display="none";
}
this.drag.setDragHandle(null);
this.windowState="maximized";
},minimizeWindow:function(evt){
this.hide();
for(var attr in this.parentPrevious){
this.domNode.parentNode.style[attr]=this.parentPrevious[attr];
}
this.lastWindowState=this.windowState;
this.windowState="minimized";
},restoreWindow:function(evt){
if(this.windowState=="minimized"){
this.show();
if(this.lastWindowState=="maximized"){
this.domNode.parentNode.style.overflow="hidden";
this.windowState="maximized";
}else{
this.windowState="normal";
}
}else{
if(this.windowState=="maximized"){
for(var attr in this.previous){
this.domNode.style[attr]=this.previous[attr];
}
for(var attr in this.parentPrevious){
this.domNode.parentNode.style[attr]=this.parentPrevious[attr];
}
this.resizeTo(this.previous.width,this.previous.height);
this.previous=null;
this.parentPrevious=null;
this.restoreAction.style.display="none";
this.maximizeAction.style.display=this.displayMaximizeAction?"":"none";
if(this.resizeHandle){
this.resizeHandle.domNode.style.display="";
}
this.drag.setDragHandle(this.titleBar);
this.windowState="normal";
}else{
}
}
},toggleDisplay:function(){
if(this.windowState=="minimized"){
this.restoreWindow();
}else{
this.minimizeWindow();
}
},closeWindow:function(evt){
dojo.html.removeNode(this.domNode);
this.destroy();
},onMouseDown:function(evt){
this.bringToTop();
},bringToTop:function(){
var _b35=dojo.widget.manager.getWidgetsByType(this.widgetType);
var _b36=[];
for(var x=0;x<_b35.length;x++){
if(this.widgetId!=_b35[x].widgetId){
_b36.push(_b35[x]);
}
}
_b36.sort(function(a,b){
return a.domNode.style.zIndex-b.domNode.style.zIndex;
});
_b36.push(this);
var _b3a=100;
for(x=0;x<_b36.length;x++){
_b36[x].domNode.style.zIndex=_b3a+x*2;
}
},_setInitialWindowState:function(){
if(this.isShowing()){
this.width=-1;
var mb=dojo.html.getMarginBox(this.domNode);
this.resizeTo(mb.width,mb.height);
}
if(this.windowState=="maximized"){
this.maximizeWindow();
this.show();
return;
}
if(this.windowState=="normal"){
this.show();
return;
}
if(this.windowState=="minimized"){
this.hide();
return;
}
this.windowState="minimized";
},_taskBarSetup:function(){
var _b3c=dojo.widget.getWidgetById(this.taskBarId);
if(!_b3c){
if(this._taskBarConnectAttempts<this._max_taskBarConnectAttempts){
dojo.lang.setTimeout(this,this._taskBarSetup,50);
this._taskBarConnectAttempts++;
}else{
dojo.debug("Unable to connect to the taskBar");
}
return;
}
_b3c.addChild(this);
},showFloatingPane:function(){
this.bringToTop();
},onFloatingPaneShow:function(){
var mb=dojo.html.getMarginBox(this.domNode);
this.resizeTo(mb.width,mb.height);
},resizeTo:function(_b3e,_b3f){
dojo.html.setMarginBox(this.domNode,{width:_b3e,height:_b3f});
dojo.widget.html.layout(this.domNode,[{domNode:this.titleBar,layoutAlign:"top"},{domNode:this.resizeBar,layoutAlign:"bottom"},{domNode:this.containerNode,layoutAlign:"client"}]);
dojo.widget.html.layout(this.containerNode,this.children,"top-bottom");
this.bgIframe.onResized();
if(this.shadow){
this.shadow.size(_b3e,_b3f);
}
this.onResized();
},checkSize:function(){
},destroyFloatingPane:function(){
if(this.resizeHandle){
this.resizeHandle.destroy();
this.resizeHandle=null;
}
}});
dojo.widget.defineWidget("dojo.widget.FloatingPane",[dojo.widget.ContentPane,dojo.widget.FloatingPaneBase],{fillInTemplate:function(args,frag){
this.fillInFloatingPaneTemplate(args,frag);
dojo.widget.FloatingPane.superclass.fillInTemplate.call(this,args,frag);
},postCreate:function(){
dojo.widget.FloatingPaneBase.prototype.postCreate.apply(this,arguments);
dojo.widget.FloatingPane.superclass.postCreate.apply(this,arguments);
},show:function(){
dojo.widget.FloatingPane.superclass.show.apply(this,arguments);
this.showFloatingPane();
},onShow:function(){
dojo.widget.FloatingPane.superclass.onShow.call(this);
this.onFloatingPaneShow();
},destroy:function(){
this.destroyFloatingPane();
dojo.widget.FloatingPane.superclass.destroy.apply(this,arguments);
}});
dojo.widget.defineWidget("dojo.widget.ModalFloatingPane",[dojo.widget.FloatingPane,dojo.widget.ModalDialogBase],{windowState:"minimized",displayCloseAction:true,postCreate:function(){
dojo.widget.ModalDialogBase.prototype.postCreate.call(this);
dojo.widget.ModalFloatingPane.superclass.postCreate.call(this);
},show:function(){
this.showModalDialog();
dojo.widget.ModalFloatingPane.superclass.show.apply(this,arguments);
this.bg.style.zIndex=this.domNode.style.zIndex-1;
},hide:function(){
this.hideModalDialog();
dojo.widget.ModalFloatingPane.superclass.hide.apply(this,arguments);
},closeWindow:function(){
this.hide();
dojo.widget.ModalFloatingPane.superclass.closeWindow.apply(this,arguments);
}});
dojo.provide("dojo.widget.Editor2Plugin.AlwaysShowToolbar");
dojo.event.topic.subscribe("dojo.widget.Editor2::onLoad",function(_b42){
if(_b42.toolbarAlwaysVisible){
var p=new dojo.widget.Editor2Plugin.AlwaysShowToolbar(_b42);
}
});
dojo.declare("dojo.widget.Editor2Plugin.AlwaysShowToolbar",null,function(_b44){
this.editor=_b44;
this.editor.registerLoadedPlugin(this);
this.setup();
},{_scrollSetUp:false,_fixEnabled:false,_scrollThreshold:false,_handleScroll:true,setup:function(){
var tdn=this.editor.toolbarWidget;
if(!tdn.tbBgIframe){
tdn.tbBgIframe=new dojo.html.BackgroundIframe(tdn.domNode);
tdn.tbBgIframe.onResized();
}
this.scrollInterval=setInterval(dojo.lang.hitch(this,"globalOnScrollHandler"),100);
dojo.event.connect("before",this.editor.toolbarWidget,"destroy",this,"destroy");
},globalOnScrollHandler:function(){
var isIE=dojo.render.html.ie;
if(!this._handleScroll){
return;
}
var dh=dojo.html;
var tdn=this.editor.toolbarWidget.domNode;
var db=dojo.body();
if(!this._scrollSetUp){
this._scrollSetUp=true;
var _b4a=dh.getMarginBox(this.editor.domNode).width;
this._scrollThreshold=dh.abs(tdn,true).y;
if((isIE)&&(db)&&(dh.getStyle(db,"background-image")=="none")){
with(db.style){
backgroundImage="url("+dojo.uri.moduleUri("dojo.widget","templates/images/blank.gif")+")";
backgroundAttachment="fixed";
}
}
}
var _b4b=(window["pageYOffset"])?window["pageYOffset"]:(document["documentElement"]||document["body"]).scrollTop;
if(_b4b>this._scrollThreshold){
if(!this._fixEnabled){
var _b4c=dojo.html.getMarginBox(tdn);
this.editor.editorObject.style.marginTop=_b4c.height+"px";
if(isIE){
tdn.style.left=dojo.html.abs(tdn,dojo.html.boxSizing.MARGIN_BOX).x;
if(tdn.previousSibling){
this._IEOriginalPos=["after",tdn.previousSibling];
}else{
if(tdn.nextSibling){
this._IEOriginalPos=["before",tdn.nextSibling];
}else{
this._IEOriginalPos=["",tdn.parentNode];
}
}
dojo.body().appendChild(tdn);
dojo.html.addClass(tdn,"IEFixedToolbar");
}else{
with(tdn.style){
position="fixed";
top="0px";
}
}
tdn.style.width=_b4c.width+"px";
tdn.style.zIndex=1000;
this._fixEnabled=true;
}
if(!dojo.render.html.safari){
var _b4d=(this.height)?parseInt(this.editor.height):this.editor._lastHeight;
if(_b4b>(this._scrollThreshold+_b4d)){
tdn.style.display="none";
}else{
tdn.style.display="";
}
}
}else{
if(this._fixEnabled){
(this.editor.object||this.editor.iframe).style.marginTop=null;
with(tdn.style){
position="";
top="";
zIndex="";
display="";
}
if(isIE){
tdn.style.left="";
dojo.html.removeClass(tdn,"IEFixedToolbar");
if(this._IEOriginalPos){
dojo.html.insertAtPosition(tdn,this._IEOriginalPos[1],this._IEOriginalPos[0]);
this._IEOriginalPos=null;
}else{
dojo.html.insertBefore(tdn,this.editor.object||this.editor.iframe);
}
}
tdn.style.width="";
this._fixEnabled=false;
}
}
},destroy:function(){
this._IEOriginalPos=null;
this._handleScroll=false;
clearInterval(this.scrollInterval);
this.editor.unregisterLoadedPlugin(this);
if(dojo.render.html.ie){
dojo.html.removeClass(this.editor.toolbarWidget.domNode,"IEFixedToolbar");
}
}});
dojo.provide("dojo.widget.Editor2");
dojo.widget.Editor2Manager=new dojo.widget.HandlerManager;
dojo.lang.mixin(dojo.widget.Editor2Manager,{_currentInstance:null,commandState:{Disabled:0,Latched:1,Enabled:2},getCurrentInstance:function(){
return this._currentInstance;
},setCurrentInstance:function(inst){
this._currentInstance=inst;
},getCommand:function(_b4f,name){
var _b51;
name=name.toLowerCase();
for(var i=0;i<this._registeredHandlers.length;i++){
_b51=this._registeredHandlers[i](_b4f,name);
if(_b51){
return _b51;
}
}
switch(name){
case "htmltoggle":
_b51=new dojo.widget.Editor2BrowserCommand(_b4f,name);
break;
case "formatblock":
_b51=new dojo.widget.Editor2FormatBlockCommand(_b4f,name);
break;
case "anchor":
_b51=new dojo.widget.Editor2Command(_b4f,name);
break;
case "createlink":
_b51=new dojo.widget.Editor2DialogCommand(_b4f,name,{contentFile:"dojo.widget.Editor2Plugin.CreateLinkDialog",contentClass:"Editor2CreateLinkDialog",title:"Insert/Edit Link",width:"300px",height:"200px"});
break;
case "insertimage":
_b51=new dojo.widget.Editor2DialogCommand(_b4f,name,{contentFile:"dojo.widget.Editor2Plugin.InsertImageDialog",contentClass:"Editor2InsertImageDialog",title:"Insert/Edit Image",width:"400px",height:"270px"});
break;
default:
var _b53=this.getCurrentInstance();
if((_b53&&_b53.queryCommandAvailable(name))||(!_b53&&dojo.widget.Editor2.prototype.queryCommandAvailable(name))){
_b51=new dojo.widget.Editor2BrowserCommand(_b4f,name);
}else{
dojo.debug("dojo.widget.Editor2Manager.getCommand: Unknown command "+name);
return;
}
}
return _b51;
},destroy:function(){
this._currentInstance=null;
dojo.widget.HandlerManager.prototype.destroy.call(this);
}});
dojo.addOnUnload(dojo.widget.Editor2Manager,"destroy");
dojo.lang.declare("dojo.widget.Editor2Command",null,function(_b54,name){
this._editor=_b54;
this._updateTime=0;
this._name=name;
},{_text:"Unknown",execute:function(para){
dojo.unimplemented("dojo.widget.Editor2Command.execute");
},getText:function(){
return this._text;
},getState:function(){
return dojo.widget.Editor2Manager.commandState.Enabled;
},destroy:function(){
}});
dojo.widget.Editor2BrowserCommandNames={"bold":"Bold","copy":"Copy","cut":"Cut","Delete":"Delete","indent":"Indent","inserthorizontalrule":"Horizental Rule","insertorderedlist":"Numbered List","insertunorderedlist":"Bullet List","italic":"Italic","justifycenter":"Align Center","justifyfull":"Justify","justifyleft":"Align Left","justifyright":"Align Right","outdent":"Outdent","paste":"Paste","redo":"Redo","removeformat":"Remove Format","selectall":"Select All","strikethrough":"Strikethrough","subscript":"Subscript","superscript":"Superscript","underline":"Underline","undo":"Undo","unlink":"Remove Link","createlink":"Create Link","insertimage":"Insert Image","htmltoggle":"HTML Source","forecolor":"Foreground Color","hilitecolor":"Background Color","plainformatblock":"Paragraph Style","formatblock":"Paragraph Style","fontsize":"Font Size","fontname":"Font Name"};
dojo.lang.declare("dojo.widget.Editor2BrowserCommand",dojo.widget.Editor2Command,function(_b57,name){
var text=dojo.widget.Editor2BrowserCommandNames[name.toLowerCase()];
if(text){
this._text=text;
}
},{execute:function(para){
this._editor.execCommand(this._name,para);
},getState:function(){
if(this._editor._lastStateTimestamp>this._updateTime||this._state==undefined){
this._updateTime=this._editor._lastStateTimestamp;
try{
if(this._editor.queryCommandEnabled(this._name)){
if(this._editor.queryCommandState(this._name)){
this._state=dojo.widget.Editor2Manager.commandState.Latched;
}else{
this._state=dojo.widget.Editor2Manager.commandState.Enabled;
}
}else{
this._state=dojo.widget.Editor2Manager.commandState.Disabled;
}
}
catch(e){
this._state=dojo.widget.Editor2Manager.commandState.Enabled;
}
}
return this._state;
},getValue:function(){
try{
return this._editor.queryCommandValue(this._name);
}
catch(e){
}
}});
dojo.lang.declare("dojo.widget.Editor2FormatBlockCommand",dojo.widget.Editor2BrowserCommand,{});
dojo.widget.defineWidget("dojo.widget.Editor2Dialog",[dojo.widget.HtmlWidget,dojo.widget.FloatingPaneBase,dojo.widget.ModalDialogBase],{templateString:"<div id=\"${this.widgetId}\" class=\"dojoFloatingPane\">\n\t<span dojoattachpoint=\"tabStartOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\"\ttabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabStart\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<div dojoAttachPoint=\"titleBar\" class=\"dojoFloatingPaneTitleBar\"  style=\"display:none\">\n\t  \t<img dojoAttachPoint=\"titleBarIcon\"  class=\"dojoFloatingPaneTitleBarIcon\">\n\t\t<div dojoAttachPoint=\"closeAction\" dojoAttachEvent=\"onClick:hide\"\n   \t  \t\tclass=\"dojoFloatingPaneCloseIcon\"></div>\n\t\t<div dojoAttachPoint=\"restoreAction\" dojoAttachEvent=\"onClick:restoreWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneRestoreIcon\"></div>\n\t\t<div dojoAttachPoint=\"maximizeAction\" dojoAttachEvent=\"onClick:maximizeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneMaximizeIcon\"></div>\n\t\t<div dojoAttachPoint=\"minimizeAction\" dojoAttachEvent=\"onClick:minimizeWindow\"\n   \t  \t\tclass=\"dojoFloatingPaneMinimizeIcon\"></div>\n\t  \t<div dojoAttachPoint=\"titleBarText\" class=\"dojoFloatingPaneTitleText\">${this.title}</div>\n\t</div>\n\n\t<div id=\"${this.widgetId}_container\" dojoAttachPoint=\"containerNode\" class=\"dojoFloatingPaneClient\"></div>\n\t<span dojoattachpoint=\"tabEnd\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<span dojoattachpoint=\"tabEndOuter\" dojoonfocus=\"trapTabs\" dojoonblur=\"clearTrap\" tabindex=\"0\"></span>\n\t<div dojoAttachPoint=\"resizeBar\" class=\"dojoFloatingPaneResizebar\" style=\"display:none\"></div>\n</div>\n",modal:true,width:"",height:"",windowState:"minimized",displayCloseAction:true,contentFile:"",contentClass:"",fillInTemplate:function(args,frag){
this.fillInFloatingPaneTemplate(args,frag);
dojo.widget.Editor2Dialog.superclass.fillInTemplate.call(this,args,frag);
},postCreate:function(){
if(this.contentFile){
dojo.require(this.contentFile);
}
if(this.modal){
dojo.widget.ModalDialogBase.prototype.postCreate.call(this);
}else{
with(this.domNode.style){
zIndex=999;
display="none";
}
}
dojo.widget.FloatingPaneBase.prototype.postCreate.apply(this,arguments);
dojo.widget.Editor2Dialog.superclass.postCreate.call(this);
if(this.width&&this.height){
with(this.domNode.style){
width=this.width;
height=this.height;
}
}
},createContent:function(){
if(!this.contentWidget&&this.contentClass){
this.contentWidget=dojo.widget.createWidget(this.contentClass);
this.addChild(this.contentWidget);
}
},show:function(){
if(!this.contentWidget){
dojo.widget.Editor2Dialog.superclass.show.apply(this,arguments);
this.createContent();
dojo.widget.Editor2Dialog.superclass.hide.call(this);
}
if(!this.contentWidget||!this.contentWidget.loadContent()){
return;
}
this.showFloatingPane();
dojo.widget.Editor2Dialog.superclass.show.apply(this,arguments);
if(this.modal){
this.showModalDialog();
}
if(this.modal){
this.bg.style.zIndex=this.domNode.style.zIndex-1;
}
},onShow:function(){
dojo.widget.Editor2Dialog.superclass.onShow.call(this);
this.onFloatingPaneShow();
},closeWindow:function(){
this.hide();
dojo.widget.Editor2Dialog.superclass.closeWindow.apply(this,arguments);
},hide:function(){
if(this.modal){
this.hideModalDialog();
}
dojo.widget.Editor2Dialog.superclass.hide.call(this);
},checkSize:function(){
if(this.isShowing()){
if(this.modal){
this._sizeBackground();
}
this.placeModalDialog();
this.onResized();
}
}});
dojo.widget.defineWidget("dojo.widget.Editor2DialogContent",dojo.widget.HtmlWidget,{widgetsInTemplate:true,loadContent:function(){
return true;
},cancel:function(){
this.parent.hide();
}});
dojo.lang.declare("dojo.widget.Editor2DialogCommand",dojo.widget.Editor2BrowserCommand,function(_b5d,name,_b5f){
this.dialogParas=_b5f;
},{execute:function(){
if(!this.dialog){
if(!this.dialogParas.contentFile||!this.dialogParas.contentClass){
alert("contentFile and contentClass should be set for dojo.widget.Editor2DialogCommand.dialogParas!");
return;
}
this.dialog=dojo.widget.createWidget("Editor2Dialog",this.dialogParas);
dojo.body().appendChild(this.dialog.domNode);
dojo.event.connect(this,"destroy",this.dialog,"destroy");
}
this.dialog.show();
},getText:function(){
return this.dialogParas.title||dojo.widget.Editor2DialogCommand.superclass.getText.call(this);
}});
dojo.widget.Editor2ToolbarGroups={};
dojo.widget.defineWidget("dojo.widget.Editor2",dojo.widget.RichText,function(){
this._loadedCommands={};
},{toolbarAlwaysVisible:false,toolbarWidget:null,scrollInterval:null,toolbarTemplatePath:dojo.uri.cache.set(dojo.uri.moduleUri("dojo.widget","templates/EditorToolbarOneline.html"), "<div class=\"EditorToolbarDomNode EditorToolbarSmallBg\">\n\t<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\">\n\t\t<tbody>\n\t\t\t<tr valign=\"top\" align=\"left\">\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"htmltoggle\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon\" \n\t\t\t\t\t\tstyle=\"background-image: none; width: 30px;\" >&lt;h&gt;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"copy\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Copy\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"paste\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Paste\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"undo\">\n\t\t\t\t\t\t<!-- FIXME: should we have the text \"undo\" here? -->\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Undo\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"redo\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Redo\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td isSpacer=\"true\">\n\t\t\t\t\t<span class=\"iconContainer\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Sep\"\tstyle=\"width: 5px; min-width: 5px;\"></span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"createlink\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Link\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"insertimage\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Image\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"inserthorizontalrule\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_HorizontalLine \">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"bold\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Bold\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"italic\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Italic\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"underline\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Underline\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"strikethrough\">\n\t\t\t\t\t\t<span \n\t\t\t\t\t\t\tclass=\"dojoE2TBIcon dojoE2TBIcon_StrikeThrough\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td isSpacer=\"true\">\n\t\t\t\t\t<span class=\"iconContainer\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Sep\" \n\t\t\t\t\t\t\tstyle=\"width: 5px; min-width: 5px;\"></span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"insertunorderedlist\">\n\t\t\t\t\t\t<span \n\t\t\t\t\t\t\tclass=\"dojoE2TBIcon dojoE2TBIcon_BulletedList\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"insertorderedlist\">\n\t\t\t\t\t\t<span \n\t\t\t\t\t\t\tclass=\"dojoE2TBIcon dojoE2TBIcon_NumberedList\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td isSpacer=\"true\">\n\t\t\t\t\t<span class=\"iconContainer\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Sep\" style=\"width: 5px; min-width: 5px;\"></span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"indent\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Indent\" \n\t\t\t\t\t\t\tunselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"outdent\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Outdent\" \n\t\t\t\t\t\t\tunselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td isSpacer=\"true\">\n\t\t\t\t\t<span class=\"iconContainer\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Sep\" style=\"width: 5px; min-width: 5px;\"></span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"forecolor\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_TextColor\" \n\t\t\t\t\t\t\tunselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"hilitecolor\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_BackgroundColor\" \n\t\t\t\t\t\t\tunselectable=\"on\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td isSpacer=\"true\">\n\t\t\t\t\t<span class=\"iconContainer\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Sep\" style=\"width: 5px; min-width: 5px;\"></span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"justifyleft\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_LeftJustify\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"justifycenter\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_CenterJustify\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"justifyright\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_RightJustify\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\n\t\t\t\t<td>\n\t\t\t\t\t<span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"justifyfull\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_BlockJustify\">&nbsp;</span>\n\t\t\t\t\t</span>\n\t\t\t\t</td>\t\n\t\t\t\t<td>\n\t\t\t\t\t<select class=\"dojoEditorToolbarItem\" dojoETItemName=\"plainformatblock\">\n\t\t\t\t\t\t<!-- FIXME: using \"p\" here inserts a paragraph in most cases! -->\n\t\t\t\t\t\t<option value=\"\">-- format --</option>\n\t\t\t\t\t\t<option value=\"p\">Normal</option>\n\t\t\t\t\t\t<option value=\"pre\">Fixed Font</option>\n\t\t\t\t\t\t<option value=\"h1\">Main Heading</option>\n\t\t\t\t\t\t<option value=\"h2\">Section Heading</option>\n\t\t\t\t\t\t<option value=\"h3\">Sub-Heading</option>\n\t\t\t\t\t\t<!-- <option value=\"blockquote\">Block Quote</option> -->\n\t\t\t\t\t</select>\n\t\t\t\t</td>\n\t\t\t\t<td><!-- uncomment to enable save button -->\n\t\t\t\t\t<!-- save -->\n\t\t\t\t\t<!--span class=\"iconContainer dojoEditorToolbarItem\" dojoETItemName=\"save\">\n\t\t\t\t\t\t<span class=\"dojoE2TBIcon dojoE2TBIcon_Save\">&nbsp;</span>\n\t\t\t\t\t</span-->\n\t\t\t\t</td>\n\t\t\t\t<td width=\"*\">&nbsp;</td>\n\t\t\t</tr>\n\t\t</tbody>\n\t</table>\n</div>\n"),toolbarTemplateCssPath:null,toolbarPlaceHolder:"",_inSourceMode:false,_htmlEditNode:null,toolbarGroup:"",shareToolbar:false,contextMenuGroupSet:"",editorOnLoad:function(){
dojo.event.topic.publish("dojo.widget.Editor2::preLoadingToolbar",this);
if(this.toolbarAlwaysVisible){
}
if(this.toolbarWidget){
this.toolbarWidget.show();
dojo.html.insertBefore(this.toolbarWidget.domNode,this.domNode.firstChild);
}else{
if(this.shareToolbar){
dojo.deprecated("Editor2:shareToolbar is deprecated in favor of toolbarGroup","0.5");
this.toolbarGroup="defaultDojoToolbarGroup";
}
if(this.toolbarGroup){
if(dojo.widget.Editor2ToolbarGroups[this.toolbarGroup]){
this.toolbarWidget=dojo.widget.Editor2ToolbarGroups[this.toolbarGroup];
}
}
if(!this.toolbarWidget){
var _b60={shareGroup:this.toolbarGroup,parent:this};
_b60.templateString=dojo.uri.cache.get(this.toolbarTemplatePath);
if(this.toolbarTemplateCssPath){
_b60.templateCssPath=this.toolbarTemplateCssPath;
_b60.templateCssString=dojo.uri.cache.get(this.toolbarTemplateCssPath);
}
if(this.toolbarPlaceHolder){
this.toolbarWidget=dojo.widget.createWidget("Editor2Toolbar",_b60,dojo.byId(this.toolbarPlaceHolder),"after");
}else{
this.toolbarWidget=dojo.widget.createWidget("Editor2Toolbar",_b60,this.domNode.firstChild,"before");
}
if(this.toolbarGroup){
dojo.widget.Editor2ToolbarGroups[this.toolbarGroup]=this.toolbarWidget;
}
dojo.event.connect(this,"close",this.toolbarWidget,"hide");
this.toolbarLoaded();
}
}
dojo.event.topic.registerPublisher("Editor2.clobberFocus",this,"clobberFocus");
dojo.event.topic.subscribe("Editor2.clobberFocus",this,"setBlur");
dojo.event.topic.publish("dojo.widget.Editor2::onLoad",this);
},toolbarLoaded:function(){
},registerLoadedPlugin:function(obj){
if(!this.loadedPlugins){
this.loadedPlugins=[];
}
this.loadedPlugins.push(obj);
},unregisterLoadedPlugin:function(obj){
for(var i in this.loadedPlugins){
if(this.loadedPlugins[i]===obj){
delete this.loadedPlugins[i];
return;
}
}
dojo.debug("dojo.widget.Editor2.unregisterLoadedPlugin: unknow plugin object: "+obj);
},execCommand:function(_b64,_b65){
switch(_b64.toLowerCase()){
case "htmltoggle":
this.toggleHtmlEditing();
break;
default:
dojo.widget.Editor2.superclass.execCommand.apply(this,arguments);
}
},queryCommandEnabled:function(_b66,_b67){
switch(_b66.toLowerCase()){
case "htmltoggle":
return true;
default:
if(this._inSourceMode){
return false;
}
return dojo.widget.Editor2.superclass.queryCommandEnabled.apply(this,arguments);
}
},queryCommandState:function(_b68,_b69){
switch(_b68.toLowerCase()){
case "htmltoggle":
return this._inSourceMode;
default:
return dojo.widget.Editor2.superclass.queryCommandState.apply(this,arguments);
}
},onClick:function(e){
dojo.widget.Editor2.superclass.onClick.call(this,e);
if(dojo.widget.PopupManager){
if(!e){
e=this.window.event;
}
dojo.widget.PopupManager.onClick(e);
}
},clobberFocus:function(){
},toggleHtmlEditing:function(){
if(this===dojo.widget.Editor2Manager.getCurrentInstance()){
if(!this._inSourceMode){
var html=this.getEditorContent();
this._inSourceMode=true;
if(!this._htmlEditNode){
this._htmlEditNode=dojo.doc().createElement("textarea");
dojo.html.insertAfter(this._htmlEditNode,this.editorObject);
}
this._htmlEditNode.style.display="";
this._htmlEditNode.style.width="100%";
this._htmlEditNode.style.height=dojo.html.getBorderBox(this.editNode).height+"px";
this._htmlEditNode.value=html;
with(this.editorObject.style){
position="absolute";
left="-2000px";
top="-2000px";
}
}else{
this._inSourceMode=false;
this._htmlEditNode.blur();
with(this.editorObject.style){
position="";
left="";
top="";
}
var html=this._htmlEditNode.value;
dojo.lang.setTimeout(this,"replaceEditorContent",1,html);
this._htmlEditNode.style.display="none";
this.focus();
}
this.onDisplayChanged(null,true);
}
},setFocus:function(){
if(dojo.widget.Editor2Manager.getCurrentInstance()===this){
return;
}
this.clobberFocus();
dojo.widget.Editor2Manager.setCurrentInstance(this);
},setBlur:function(){
},saveSelection:function(){
this._bookmark=null;
this._bookmark=dojo.withGlobal(this.window,dojo.html.selection.getBookmark);
},restoreSelection:function(){
if(this._bookmark){
this.focus();
dojo.withGlobal(this.window,"moveToBookmark",dojo.html.selection,[this._bookmark]);
this._bookmark=null;
}else{
dojo.debug("restoreSelection: no saved selection is found!");
}
},_updateToolbarLastRan:null,_updateToolbarTimer:null,_updateToolbarFrequency:500,updateToolbar:function(_b6c){
if((!this.isLoaded)||(!this.toolbarWidget)){
return;
}
var diff=new Date()-this._updateToolbarLastRan;
if((!_b6c)&&(this._updateToolbarLastRan)&&((diff<this._updateToolbarFrequency))){
clearTimeout(this._updateToolbarTimer);
var _b6e=this;
this._updateToolbarTimer=setTimeout(function(){
_b6e.updateToolbar();
},this._updateToolbarFrequency/2);
return;
}else{
this._updateToolbarLastRan=new Date();
}
if(dojo.widget.Editor2Manager.getCurrentInstance()!==this){
return;
}
this.toolbarWidget.update();
},destroy:function(_b6f){
this._htmlEditNode=null;
dojo.event.disconnect(this,"close",this.toolbarWidget,"hide");
if(!_b6f){
this.toolbarWidget.destroy();
}
dojo.widget.Editor2.superclass.destroy.call(this);
},_lastStateTimestamp:0,onDisplayChanged:function(e,_b71){
this._lastStateTimestamp=(new Date()).getTime();
dojo.widget.Editor2.superclass.onDisplayChanged.call(this,e);
this.updateToolbar(_b71);
},onLoad:function(){
try{
dojo.widget.Editor2.superclass.onLoad.call(this);
}
catch(e){
dojo.debug(e);
}
this.editorOnLoad();
},onFocus:function(){
dojo.widget.Editor2.superclass.onFocus.call(this);
this.setFocus();
},getEditorContent:function(){
if(this._inSourceMode){
return this._htmlEditNode.value;
}
return dojo.widget.Editor2.superclass.getEditorContent.call(this);
},replaceEditorContent:function(html){
if(this._inSourceMode){
this._htmlEditNode.value=html;
return;
}
dojo.widget.Editor2.superclass.replaceEditorContent.apply(this,arguments);
},getCommand:function(name){
if(this._loadedCommands[name]){
return this._loadedCommands[name];
}
var cmd=dojo.widget.Editor2Manager.getCommand(this,name);
this._loadedCommands[name]=cmd;
return cmd;
},shortcuts:[["bold"],["italic"],["underline"],["selectall","a"],["insertunorderedlist","\\"]],setupDefaultShortcuts:function(){
var exec=function(cmd){
return function(){
cmd.execute();
};
};
var self=this;
dojo.lang.forEach(this.shortcuts,function(item){
var cmd=self.getCommand(item[0]);
if(cmd){
self.addKeyHandler(item[1]?item[1]:item[0].charAt(0),item[2]==undefined?self.KEY_CTRL:item[2],exec(cmd));
}
});
}});


__CPAN_EDITION__ editor build.txt
Files baked into this build:

dojo.js:
dojoGuardStart.js
../src/bootstrap1.js
../src/loader.js
dojoGuardEnd.js
../src/hostenv_browser.js
../src/dom.js
../src/xml/Parse.js
../src/lang/common.js
../src/lang/func.js
../src/lang/array.js
../src/lang/extras.js
../src/lang/declare.js
../src/ns.js
../src/event/common.js
../src/event/topic.js
../src/event/browser.js
../src/event/__package__.js
../src/widget/Manager.js
../src/uri/Uri.js
../src/uri/__package__.js
../src/html/common.js
../src/a11y.js
../src/widget/Widget.js
../src/widget/Parse.js
../src/html/style.js
../src/widget/DomWidget.js
../src/html/display.js
../src/html/layout.js
../src/html/util.js
../src/gfx/color.js
../src/lfx/Animation.js
../src/html/color.js
../src/lfx/html.js
../src/lfx/__package__.js
../src/lfx/toggle.js
../src/widget/HtmlWidget.js
../src/widget/__package__.js
../src/string/common.js
../src/string.js
../src/io/common.js
../src/string/extras.js
../src/undo/browser.js
../src/io/BrowserIO.js
../src/io/cookie.js
../src/io/__package__.js
../src/html/__package__.js
../src/html/selection.js
../src/Deferred.js
../src/widget/RichText.js
../src/lang/type.js
../src/lang/assert.js
../src/AdapterRegistry.js
../src/lang/repr.js
../src/lang/__package__.js
../src/html/iframe.js
../src/widget/PopupContainer.js
../src/widget/ColorPalette.js
../src/widget/ContentPane.js
../src/widget/Editor2Toolbar.js
../src/uri/cache.js
../src/lfx/shadow.js
../src/widget/html/layout.js
../src/dnd/DragAndDrop.js
../src/dnd/HtmlDragManager.js
../src/dnd/HtmlDragAndDrop.js
../src/dnd/__package__.js
../src/dnd/HtmlDragMove.js
../src/widget/Dialog.js
../src/widget/ResizeHandle.js
../src/widget/FloatingPane.js
../src/widget/Editor2Plugin/AlwaysShowToolbar.js
../src/widget/Editor2.js

__CPAN_EDITION__ event_and_io dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:3,flag:"",revision:Number("$Rev: 8617 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
dojo.hostenv._djInitFired=false;
function dj_load_init(e){
dojo.hostenv._djInitFired=true;
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_f4,_f5){
var out="";
for(var i=0;i<_f4;i++){
out+=str;
if(_f5&&i<_f4-1){
out+=_f5;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_103,_104){
if(!dojo.lang.isFunction(_104)){
dojo.raise("dojo.inherits: superclass argument ["+_104+"] must be a function (subclass: ["+_103+"']");
}
_103.prototype=new _104();
_103.prototype.constructor=_103;
_103.superclass=_104.prototype;
_103["super"]=_104.prototype;
};
dojo.lang._mixin=function(obj,_106){
var tobj={};
for(var x in _106){
if((typeof tobj[x]=="undefined")||(tobj[x]!=_106[x])){
obj[x]=_106[x];
}
}
if(dojo.render.html.ie&&(typeof (_106["toString"])=="function")&&(_106["toString"]!=obj["toString"])&&(_106["toString"]!=tobj["toString"])){
obj.toString=_106.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_10a){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_10d,_10e){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_10d.prototype,arguments[i]);
}
return _10d;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_111,_112,_113,_114){
if(!dojo.lang.isArrayLike(_111)&&dojo.lang.isArrayLike(_112)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_111;
_111=_112;
_112=temp;
}
var _116=dojo.lang.isString(_111);
if(_116){
_111=_111.split("");
}
if(_114){
var step=-1;
var i=_111.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_111.length;
}
if(_113){
while(i!=end){
if(_111[i]===_112){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_111[i]==_112){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_11a,_11b,_11c){
return dojo.lang.find(_11a,_11b,_11c,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_11d,_11e){
return dojo.lang.find(_11d,_11e)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_12a){
var _12b=window,_12c=2;
if(!dojo.lang.isFunction(func)){
_12b=func;
func=_12a;
_12a=arguments[2];
_12c++;
}
if(dojo.lang.isString(func)){
func=_12b[func];
}
var args=[];
for(var i=_12c;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_12b,args);
},_12a);
};
dojo.lang.clearTimeout=function(_12f){
dojo.global().clearTimeout(_12f);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_138,_139,_13a){
with(dojo.parseObjPath(_138,_139,_13a)){
return dojo.evalProp(prop,obj,_13a);
}
};
dojo.lang.setObjPathValue=function(_13b,_13c,_13d,_13e){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_13e=true;
}
with(dojo.parseObjPath(_13b,_13d,_13e)){
if(obj&&(_13e||(prop in obj))){
obj[prop]=_13c;
}
}
};
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_140,_141,_142){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_140){
this.mimetype=_140;
}
if(_141){
this.transport=_141;
}
if(arguments.length>=4){
this.changeUrl=_142;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,jsonFilter:function(_143){
if((this.mimetype=="text/json-comment-filtered")||(this.mimetype=="application/json-comment-filtered")){
var _144=_143.indexOf("/*");
var _145=_143.lastIndexOf("*/");
if((_144==-1)||(_145==-1)){
dojo.debug("your JSON wasn't comment filtered!");
return "";
}
return _143.substring(_144+2,_145);
}
dojo.debug("please consider using a mimetype of text/json-comment-filtered to avoid potential security issues with JSON endpoints");
return _143;
},load:function(type,data,_148,_149){
},error:function(type,_14b,_14c,_14d){
},timeout:function(type,_14f,_150,_151){
},handle:function(type,data,_154,_155){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_156){
if(_156["url"]){
_156.url=_156.url.toString();
}
if(_156["formNode"]){
_156.formNode=dojo.byId(_156.formNode);
}
if(!_156["method"]&&_156["formNode"]&&_156["formNode"].method){
_156.method=_156["formNode"].method;
}
if(!_156["handle"]&&_156["handler"]){
_156.handle=_156.handler;
}
if(!_156["load"]&&_156["loaded"]){
_156.load=_156.loaded;
}
if(!_156["changeUrl"]&&_156["changeURL"]){
_156.changeUrl=_156.changeURL;
}
_156.encoding=dojo.lang.firstValued(_156["encoding"],djConfig["bindEncoding"],"");
_156.sendTransport=dojo.lang.firstValued(_156["sendTransport"],djConfig["ioSendTransport"],false);
var _157=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_156[fn]&&_157(_156[fn])){
continue;
}
if(_156["handle"]&&_157(_156["handle"])){
_156[fn]=_156.handle;
}
}
dojo.lang.mixin(this,_156);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_15e){
if(!(_15e instanceof dojo.io.Request)){
try{
_15e=new dojo.io.Request(_15e);
}
catch(e){
dojo.debug(e);
}
}
var _15f="";
if(_15e["transport"]){
_15f=_15e["transport"];
if(!this[_15f]){
dojo.io.sendBindError(_15e,"No dojo.io.bind() transport with name '"+_15e["transport"]+"'.");
return _15e;
}
if(!this[_15f].canHandle(_15e)){
dojo.io.sendBindError(_15e,"dojo.io.bind() transport with name '"+_15e["transport"]+"' cannot handle this type of request.");
return _15e;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_15e))){
_15f=tmp;
break;
}
}
if(_15f==""){
dojo.io.sendBindError(_15e,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _15e;
}
}
this[_15f].bind(_15e);
_15e.bindSuccess=true;
return _15e;
};
dojo.io.sendBindError=function(_162,_163){
if((typeof _162.error=="function"||typeof _162.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _164=new dojo.io.Error(_163);
setTimeout(function(){
_162[(typeof _162.error=="function")?"error":"handle"]("error",_164,null,_162);
},50);
}else{
dojo.raise(_163);
}
};
dojo.io.queueBind=function(_165){
if(!(_165 instanceof dojo.io.Request)){
try{
_165=new dojo.io.Request(_165);
}
catch(e){
dojo.debug(e);
}
}
var _166=_165.load;
_165.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_166.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _168=_165.error;
_165.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_168.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_165);
dojo.io._dispatchNextQueueBind();
return _165;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_16b,last){
var enc=/utf/i.test(_16b||"")?encodeURIComponent:dojo.string.encodeAscii;
var _16e=[];
var _16f=new Object();
for(var name in map){
var _171=function(elt){
var val=enc(name)+"="+enc(elt);
_16e[(last==name)?"push":"unshift"](val);
};
if(!_16f[name]){
var _174=map[name];
if(dojo.lang.isArray(_174)){
dojo.lang.forEach(_174,_171);
}else{
_171(_174);
}
}
}
return _16e.join("&");
};
dojo.io.setIFrameSrc=function(_175,src,_177){
try{
var r=dojo.render.html;
if(!_177){
if(r.safari){
_175.location=src;
}else{
frames[_175.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_175.contentWindow.document;
}else{
if(r.safari){
idoc=_175.document;
}else{
idoc=_175.contentWindow;
}
}
if(!idoc){
_175.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _17e=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_17e++;
break;
}
}
return _17e==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_182){
var _183=dojo.lang.isString(arr);
if(_183){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_182)){
_182=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_182){
var _184=obj;
obj=_182;
_182=_184;
}
}
if(Array.map){
var _185=Array.map(arr,_182,obj);
}else{
var _185=[];
for(var i=0;i<arr.length;++i){
_185.push(_182.call(obj,arr[i]));
}
}
if(_183){
return _185.join("");
}else{
return _185;
}
},reduce:function(arr,_188,obj,_18a){
var _18b=_188;
if(arguments.length==2){
_18a=_188;
_18b=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_18a=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_18a;
_18a=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_18b=_18a.call(ob,_18b,val);
});
return _18b;
},forEach:function(_18f,_190,_191){
if(dojo.lang.isString(_18f)){
_18f=_18f.split("");
}
if(Array.forEach){
Array.forEach(_18f,_190,_191);
}else{
if(!_191){
_191=dj_global;
}
for(var i=0,l=_18f.length;i<l;i++){
_190.call(_191,_18f[i],i,_18f);
}
}
},_everyOrSome:function(_194,arr,_196,_197){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_194?"every":"some"](arr,_196,_197);
}else{
if(!_197){
_197=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _19a=_196.call(_197,arr[i],i,arr);
if(_194&&!_19a){
return false;
}else{
if((!_194)&&(_19a)){
return true;
}
}
}
return Boolean(_194);
}
},every:function(arr,_19c,_19d){
return this._everyOrSome(true,arr,_19c,_19d);
},some:function(arr,_19f,_1a0){
return this._everyOrSome(false,arr,_19f,_1a0);
},filter:function(arr,_1a2,_1a3){
var _1a4=dojo.lang.isString(arr);
if(_1a4){
arr=arr.split("");
}
var _1a5;
if(Array.filter){
_1a5=Array.filter(arr,_1a2,_1a3);
}else{
if(!_1a3){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_1a3=dj_global;
}
_1a5=[];
for(var i=0;i<arr.length;i++){
if(_1a2.call(_1a3,arr[i],i,arr)){
_1a5.push(arr[i]);
}
}
}
if(_1a4){
return _1a5.join("");
}else{
return _1a5;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_1aa,_1ab){
var _1ac=[];
for(var i=_1ab||0;i<_1aa.length;i++){
_1ac.push(_1aa[i]);
}
return _1ac;
}});
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_1ae,_1af){
var args=[];
for(var x=2;x<arguments.length;x++){
args.push(arguments[x]);
}
var fcn=(dojo.lang.isString(_1af)?_1ae[_1af]:_1af)||function(){
};
return function(){
var ta=args.concat([]);
for(var x=0;x<arguments.length;x++){
ta.push(arguments[x]);
}
return fcn.apply(_1ae,ta);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_1b5,_1b6,_1b7){
var nso=(_1b6||dojo.lang.anon);
if((_1b7)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_1b5){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_1b5;
return ret;
};
dojo.lang.forward=function(_1bb){
return function(){
return this[_1bb].apply(this,arguments);
};
};
dojo.lang.curry=function(_1bc,func){
var _1be=[];
_1bc=_1bc||dj_global;
if(dojo.lang.isString(func)){
func=_1bc[func];
}
for(var x=2;x<arguments.length;x++){
_1be.push(arguments[x]);
}
var _1c0=(func["__preJoinArity"]||func.length)-_1be.length;
function gather(_1c1,_1c2,_1c3){
var _1c4=_1c3;
var _1c5=_1c2.slice(0);
for(var x=0;x<_1c1.length;x++){
_1c5.push(_1c1[x]);
}
_1c3=_1c3-_1c1.length;
if(_1c3<=0){
var res=func.apply(_1bc,_1c5);
_1c3=_1c4;
return res;
}else{
return function(){
return gather(arguments,_1c5,_1c3);
};
}
}
return gather([],_1be,_1c0);
};
dojo.lang.curryArguments=function(_1c8,func,args,_1cb){
var _1cc=[];
var x=_1cb||0;
for(x=_1cb;x<args.length;x++){
_1cc.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_1c8,func].concat(_1cc));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_1d2,_1d3){
if(!farr.length){
if(typeof _1d3=="function"){
_1d3();
}
return;
}
if((typeof _1d2=="undefined")&&(typeof cb=="number")){
_1d2=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_1d2){
_1d2=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_1d2,_1d3);
},_1d2);
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_1d4,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _1d4.replace(/\%\{(\w+)\}/g,function(_1d7,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _1da=str.split(" ");
for(var i=0;i<_1da.length;i++){
_1da[i]=_1da[i].charAt(0).toUpperCase()+_1da[i].substring(1);
}
return _1da.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _1df=escape(str);
var _1e0,re=/%u([0-9A-F]{4})/i;
while((_1e0=_1df.match(re))){
var num=Number("0x"+_1e0[1]);
var _1e3=escape("&#"+num+";");
ret+=_1df.substring(0,_1e0.index)+_1e3;
_1df=_1df.substring(_1e0.index+_1e0[0].length);
}
ret+=_1df.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_1e8){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_1e8){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_1f1){
if(_1f1){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_1f5,_1f6){
if(_1f6){
str=str.toLowerCase();
_1f5=_1f5.toLowerCase();
}
return str.indexOf(_1f5)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_1fc){
if(_1fc=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_1fc=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_1fe){
var _1ff=[];
for(var i=0,_201=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_1fe){
_1ff.push(str.substring(_201,i));
_201=i+1;
}
}
_1ff.push(str.substr(_201));
return _1ff;
};
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _203=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_203.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_205,_206){
var node=_205.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_206&&node&&node.tagName&&node.tagName.toLowerCase()!=_206.toLowerCase()){
node=dojo.dom.nextElement(node,_206);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_208,_209){
var node=_208.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_209&&node&&node.tagName&&node.tagName.toLowerCase()!=_209.toLowerCase()){
node=dojo.dom.prevElement(node,_209);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_20c){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_20c&&_20c.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_20c);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_20e){
if(!node){
return null;
}
if(_20e){
_20e=_20e.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_20e&&_20e.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_20e);
}
return node;
};
dojo.dom.moveChildren=function(_20f,_210,trim){
var _212=0;
if(trim){
while(_20f.hasChildNodes()&&_20f.firstChild.nodeType==dojo.dom.TEXT_NODE){
_20f.removeChild(_20f.firstChild);
}
while(_20f.hasChildNodes()&&_20f.lastChild.nodeType==dojo.dom.TEXT_NODE){
_20f.removeChild(_20f.lastChild);
}
}
while(_20f.hasChildNodes()){
_210.appendChild(_20f.firstChild);
_212++;
}
return _212;
};
dojo.dom.copyChildren=function(_213,_214,trim){
var _216=_213.cloneNode(true);
return this.moveChildren(_216,_214,trim);
};
dojo.dom.replaceChildren=function(node,_218){
var _219=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_219.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_218);
for(var i=0;i<_219.length;i++){
dojo.dom.destroyNode(_219[i]);
}
};
dojo.dom.removeChildren=function(node){
var _21c=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _21c;
};
dojo.dom.replaceNode=function(node,_21e){
return node.parentNode.replaceChild(_21e,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_222,_223){
var _224=[];
var _225=(_222&&(_222 instanceof Function||typeof _222=="function"));
while(node){
if(!_225||_222(node)){
_224.push(node);
}
if(_223&&_224.length>0){
return _224[0];
}
node=node.parentNode;
}
if(_223){
return null;
}
return _224;
};
dojo.dom.getAncestorsByTag=function(node,tag,_228){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_228);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_22d,_22e){
if(_22e&&node){
node=node.parentNode;
}
while(node){
if(node==_22d){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _231=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _232=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_232.length;i++){
try{
doc=new ActiveXObject(_232[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_231.implementation)&&(_231.implementation.createDocument)){
doc=_231.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_235){
if(!_235){
_235="text/xml";
}
if(!dj_undef("DOMParser")){
var _236=new DOMParser();
return _236.parseFromString(str,_235);
}else{
if(!dj_undef("ActiveXObject")){
var _237=dojo.dom.createDocument();
if(_237){
_237.async=false;
_237.loadXML(str);
return _237;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _238=dojo.doc();
if(_238.createElement){
var tmp=_238.createElement("xml");
tmp.innerHTML=str;
if(_238.implementation&&_238.implementation.createDocument){
var _23a=_238.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_23a.importNode(tmp.childNodes.item(i),true);
}
return _23a;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_23d){
if(_23d.firstChild){
_23d.insertBefore(node,_23d.firstChild);
}else{
_23d.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_240){
if((_240!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _241=ref.parentNode;
_241.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_244){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_244!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_244);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_248){
if((!node)||(!ref)||(!_248)){
return false;
}
switch(_248.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_24a,_24b){
var _24c=_24a.childNodes;
if(!_24c.length||_24c.length==_24b){
_24a.appendChild(node);
return true;
}
if(_24b==0){
return dojo.dom.prependChild(node,_24a);
}
return dojo.dom.insertAfter(node,_24c[_24b-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _24f=dojo.doc();
dojo.dom.replaceChildren(node,_24f.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _250="";
if(node==null){
return _250;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_250+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_250+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _250;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_256,_257,_258){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_256,_257,_258);
}else{
var _259=elem.ownerDocument;
var _25a=_259.createNode(2,_257,_256);
_25a.nodeValue=_258;
elem.setAttributeNode(_25a);
}
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:(!dj_undef("window"))?window.location.href:"",initialHash:(!dj_undef("window"))?window.location.hash:"",moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.undo.browser: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _25f=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_261){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_25f.apply(this,[_261]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _262=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_264){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_262){
_262.apply(this,[_264]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_267){
if(!dojo.render.html.opera){
var _268=this._getUrlQuery(_267.href);
if(_268==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_268==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_268==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _269=this.historyStack.pop();
if(!_269){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_269);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _270=url.split("?");
if(_270.length<2){
return null;
}else{
return _270[1];
}
},_loadIframeHistory:function(){
var url=(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
if(!dj_undef("window")){
dojo.io.checkChildrenForFile=function(node){
var _273=false;
var _274=node.getElementsByTagName("input");
dojo.lang.forEach(_274,function(_275){
if(_273){
return;
}
if(_275.getAttribute("type")=="file"){
_273=true;
}
});
return _273;
};
dojo.io.formHasFile=function(_276){
return dojo.io.checkChildrenForFile(_276);
};
dojo.io.updateNode=function(node,_278){
node=dojo.byId(node);
var args=_278;
if(dojo.lang.isString(_278)){
args={url:_278};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
dojo.dom.destroyNode(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_27f,_280,_281){
if((!_27f)||(!_27f.tagName)||(!_27f.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_281){
_281=dojo.io.formFilter;
}
var enc=/utf/i.test(_280||"")?encodeURIComponent:dojo.string.encodeAscii;
var _283=[];
for(var i=0;i<_27f.elements.length;i++){
var elm=_27f.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_281(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_283.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_283.push(name+"="+enc(elm.value));
}
}else{
_283.push(name+"="+enc(elm.value));
}
}
}
var _289=_27f.getElementsByTagName("input");
for(var i=0;i<_289.length;i++){
var _28a=_289[i];
if(_28a.type.toLowerCase()=="image"&&_28a.form==_27f&&_281(_28a)){
var name=enc(_28a.name);
_283.push(name+"="+enc(_28a.value));
_283.push(name+".x=0");
_283.push(name+".y=0");
}
}
return _283.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _290=form.getElementsByTagName("input");
for(var i=0;i<_290.length;i++){
var _291=_290[i];
if(_291.type.toLowerCase()=="image"&&_291.form==form){
this.connect(_291,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _298=false;
if(node.disabled||!node.name){
_298=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_298=node==this.clickedButton;
}else{
_298=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _298;
},connect:function(_299,_29a,_29b){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_299,_29a,this,_29b);
}else{
var fcn=dojo.lang.hitch(this,_29b);
_299[_29a]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _29e=this;
var _29f={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_2a1,_2a2){
return url+"|"+_2a1+"|"+_2a2.toLowerCase();
}
function addToCache(url,_2a4,_2a5,http){
_29f[getCacheKey(url,_2a4,_2a5)]=http;
}
function getFromCache(url,_2a8,_2a9){
return _29f[getCacheKey(url,_2a8,_2a9)];
}
this.clearCache=function(){
_29f={};
};
function doLoad(_2aa,http,url,_2ad,_2ae){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(http.status==1223)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_2aa.method.toLowerCase()=="head"){
var _2b0=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _2b0;
};
var _2b1=_2b0.split(/[\r\n]+/g);
for(var i=0;i<_2b1.length;i++){
var pair=_2b1[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_2aa.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_2aa.mimetype.substr(0,9)=="text/json"||_2aa.mimetype.substr(0,16)=="application/json"){
try{
ret=dj_eval("("+_2aa.jsonFilter(http.responseText)+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_2aa.mimetype=="application/xml")||(_2aa.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_2ae){
addToCache(url,_2ad,_2aa.method,http);
}
_2aa[(typeof _2aa.load=="function")?"load":"handle"]("load",ret,http,_2aa);
}else{
var _2b4=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_2aa[(typeof _2aa.error=="function")?"error":"handle"]("error",_2b4,http,_2aa);
}
}
function setHeaders(http,_2b6){
if(_2b6["headers"]){
for(var _2b7 in _2b6["headers"]){
if(_2b7.toLowerCase()=="content-type"&&!_2b6["contentType"]){
_2b6["contentType"]=_2b6["headers"][_2b7];
}else{
http.setRequestHeader(_2b7,_2b6["headers"][_2b7]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_29e._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _2bb=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_2bb,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _2bc=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_2bd){
var mlc=_2bd["mimetype"].toLowerCase()||"";
return _2bc&&((dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript"],mlc))||(mlc.substr(0,9)=="text/json"||mlc.substr(0,16)=="application/json"))&&!(_2bd["formNode"]&&dojo.io.formHasFile(_2bd["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_2bf){
if(!_2bf["url"]){
if(!_2bf["formNode"]&&(_2bf["backButton"]||_2bf["back"]||_2bf["changeUrl"]||_2bf["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_2bf);
return true;
}
}
var url=_2bf.url;
var _2c1="";
if(_2bf["formNode"]){
var ta=_2bf.formNode.getAttribute("action");
if((ta)&&(!_2bf["url"])){
url=ta;
}
var tp=_2bf.formNode.getAttribute("method");
if((tp)&&(!_2bf["method"])){
_2bf.method=tp;
}
_2c1+=dojo.io.encodeForm(_2bf.formNode,_2bf.encoding,_2bf["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_2bf["file"]){
_2bf.method="post";
}
if(!_2bf["method"]){
_2bf.method="get";
}
if(_2bf.method.toLowerCase()=="get"){
_2bf.multipart=false;
}else{
if(_2bf["file"]){
_2bf.multipart=true;
}else{
if(!_2bf["multipart"]){
_2bf.multipart=false;
}
}
}
if(_2bf["backButton"]||_2bf["back"]||_2bf["changeUrl"]){
dojo.undo.browser.addToHistory(_2bf);
}
var _2c4=_2bf["content"]||{};
if(_2bf.sendTransport){
_2c4["dojo.transport"]="xmlhttp";
}
do{
if(_2bf.postContent){
_2c1=_2bf.postContent;
break;
}
if(_2c4){
_2c1+=dojo.io.argsFromMap(_2c4,_2bf.encoding);
}
if(_2bf.method.toLowerCase()=="get"||!_2bf.multipart){
break;
}
var t=[];
if(_2c1.length){
var q=_2c1.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_2bf.file){
if(dojo.lang.isArray(_2bf.file)){
for(var i=0;i<_2bf.file.length;++i){
var o=_2bf.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_2bf.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_2c1=t.join("\r\n");
}
}while(false);
var _2ca=_2bf["sync"]?false:true;
var _2cb=_2bf["preventCache"]||(this.preventCache==true&&_2bf["preventCache"]!=false);
var _2cc=_2bf["useCache"]==true||(this.useCache==true&&_2bf["useCache"]!=false);
if(!_2cb&&_2cc){
var _2cd=getFromCache(url,_2c1,_2bf.method);
if(_2cd){
doLoad(_2bf,_2cd,url,_2c1,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_2bf);
var _2cf=false;
if(_2ca){
var _2d0=this.inFlight.push({"req":_2bf,"http":http,"url":url,"query":_2c1,"useCache":_2cc,"startTime":_2bf.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_29e._blockAsync=true;
}
if(_2bf.method.toLowerCase()=="post"){
if(!_2bf.user){
http.open("POST",url,_2ca);
}else{
http.open("POST",url,_2ca,_2bf.user,_2bf.password);
}
setHeaders(http,_2bf);
http.setRequestHeader("Content-Type",_2bf.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_2bf.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_2c1);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2bf,{status:404},url,_2c1,_2cc);
}
}else{
var _2d1=url;
if(_2c1!=""){
_2d1+=(_2d1.indexOf("?")>-1?"&":"?")+_2c1;
}
if(_2cb){
_2d1+=(dojo.string.endsWithAny(_2d1,"?","&")?"":(_2d1.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_2bf.user){
http.open(_2bf.method.toUpperCase(),_2d1,_2ca);
}else{
http.open(_2bf.method.toUpperCase(),_2d1,_2ca,_2bf.user,_2bf.password);
}
setHeaders(http,_2bf);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_2bf,{status:404},url,_2c1,_2cc);
}
}
if(!_2ca){
doLoad(_2bf,http,url,_2c1,_2cc);
_29e._blockAsync=false;
}
_2bf.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
}
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_2d3,days,path,_2d6,_2d7){
var _2d8=-1;
if((typeof days=="number")&&(days>=0)){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_2d8=d.toGMTString();
}
_2d3=escape(_2d3);
document.cookie=name+"="+_2d3+";"+(_2d8!=-1?" expires="+_2d8+";":"")+(path?"path="+path:"")+(_2d6?"; domain="+_2d6:"")+(_2d7?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _2dc=document.cookie.substring(idx+name.length+1);
var end=_2dc.indexOf(";");
if(end==-1){
end=_2dc.length;
}
_2dc=_2dc.substring(0,end);
_2dc=unescape(_2dc);
return _2dc;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_2e3,_2e4,_2e5){
if(arguments.length==5){
_2e5=_2e3;
_2e3=null;
_2e4=null;
}
var _2e6=[],_2e7,_2e8="";
if(!_2e5){
_2e7=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_2e7){
_2e7={};
}
for(var prop in obj){
if(obj[prop]==null){
delete _2e7[prop];
}else{
if((typeof obj[prop]=="string")||(typeof obj[prop]=="number")){
_2e7[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _2e7){
_2e6.push(escape(prop)+"="+escape(_2e7[prop]));
}
_2e8=_2e6.join("&");
}
dojo.io.cookie.setCookie(name,_2e8,days,path,_2e3,_2e4);
};
dojo.io.cookie.getObjectCookie=function(name){
var _2eb=null,_2ec=dojo.io.cookie.getCookie(name);
if(_2ec){
_2eb={};
var _2ed=_2ec.split("&");
for(var i=0;i<_2ed.length;i++){
var pair=_2ed[i].split("=");
var _2f0=pair[1];
if(isNaN(_2f0)){
_2f0=unescape(pair[1]);
}
_2eb[unescape(pair[0])]=_2f0;
}
}
return _2eb;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _2f1=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_2f1=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.kwCompoundRequire({common:["dojo.io.common"],rhino:["dojo.io.RhinoIO"],browser:["dojo.io.BrowserIO","dojo.io.cookie"],dashboard:["dojo.io.BrowserIO","dojo.io.cookie"]});
dojo.provide("dojo.io.*");
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_2f3){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false,maxCalls:-1};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _2f6=dl.nameAnonFunc(args[2],ao.adviceObj,_2f3);
ao.adviceFunc=_2f6;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _2f6=dl.nameAnonFunc(args[0],ao.srcObj,_2f3);
ao.srcFunc=_2f6;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _2f6=dl.nameAnonFunc(args[1],dj_global,_2f3);
ao.srcFunc=_2f6;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _2f6=dl.nameAnonFunc(args[3],dj_global,_2f3);
ao.adviceObj=dj_global;
ao.adviceFunc=_2f6;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
ao.maxCalls=(!isNaN(parseInt(args[11])))?args[11]:-1;
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _2f6=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_2f3);
ao.aroundFunc=_2f6;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _2f8={};
for(var x in ao){
_2f8[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_2f8.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_2f8));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _300;
if((arguments.length==1)&&(typeof a1=="object")){
_300=a1;
}else{
_300={srcObj:a1,srcFunc:a2};
}
_300.adviceFunc=function(){
var _301=[];
for(var x=0;x<arguments.length;x++){
_301.push(arguments[x]);
}
dojo.debug("("+_300.srcObj+")."+_300.srcFunc,":",_301.join(", "));
};
this.kwConnect(_300);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this.connectRunOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.maxCalls=1;
return this.connect(ao);
};
this._kwConnectImpl=function(_309,_30a){
var fn=(_30a)?"disconnect":"connect";
if(typeof _309["srcFunc"]=="function"){
_309.srcObj=_309["srcObj"]||dj_global;
var _30c=dojo.lang.nameAnonFunc(_309.srcFunc,_309.srcObj,true);
_309.srcFunc=_30c;
}
if(typeof _309["adviceFunc"]=="function"){
_309.adviceObj=_309["adviceObj"]||dj_global;
var _30c=dojo.lang.nameAnonFunc(_309.adviceFunc,_309.adviceObj,true);
_309.adviceFunc=_30c;
}
_309.srcObj=_309["srcObj"]||dj_global;
_309.adviceObj=_309["adviceObj"]||_309["targetObj"]||dj_global;
_309.adviceFunc=_309["adviceFunc"]||_309["targetFunc"];
return dojo.event[fn](_309);
};
this.kwConnect=function(_30d){
return this._kwConnectImpl(_30d,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_310){
return this._kwConnectImpl(_310,true);
};
};
dojo.event.MethodInvocation=function(_311,obj,args){
this.jp_=_311;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_319){
this.object=obj||dj_global;
this.methodname=_319;
this.methodfunc=this.object[_319];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_31b){
if(!obj){
obj=dj_global;
}
var ofn=obj[_31b];
if(!ofn){
ofn=obj[_31b]=function(){
};
if(!obj[_31b]){
dojo.raise("Cannot set do-nothing method on that object "+_31b);
}
}else{
if((typeof ofn!="function")&&(!dojo.lang.isFunction(ofn))&&(!dojo.lang.isAlien(ofn))){
return null;
}
}
var _31d=_31b+"$joinpoint";
var _31e=_31b+"$joinpoint$method";
var _31f=obj[_31d];
if(!_31f){
var _320=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_320=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_31d,_31e,_31b]);
}
}
var _321=ofn.length;
obj[_31e]=ofn;
_31f=obj[_31d]=new dojo.event.MethodJoinPoint(obj,_31e);
if(!_320){
obj[_31b]=function(){
return _31f.run.apply(_31f,arguments);
};
}else{
obj[_31b]=function(){
var args=[];
if(!arguments.length){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _31f.run.apply(_31f,args);
};
}
obj[_31b].__preJoinArity=_321;
}
return _31f;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{squelch:false,unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _327=[];
for(var x=0;x<args.length;x++){
_327[x]=args[x];
}
var _329=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _32b=marr[0]||dj_global;
var _32c=marr[1];
if(!_32b[_32c]){
dojo.raise("function \""+_32c+"\" does not exist on \""+_32b+"\"");
}
var _32d=marr[2]||dj_global;
var _32e=marr[3];
var msg=marr[6];
var _330=marr[7];
if(_330>-1){
if(_330==0){
return;
}
marr[7]--;
}
var _331;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _32b[_32c].apply(_32b,to.args);
}};
to.args=_327;
var _333=parseInt(marr[4]);
var _334=((!isNaN(_333))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _337=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_329(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_32e){
_32d[_32e].call(_32d,to);
}else{
if((_334)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_32b[_32c].call(_32b,to);
}else{
_32b[_32c].apply(_32b,args);
}
},_333);
}else{
if(msg){
_32b[_32c].call(_32b,to);
}else{
_32b[_32c].apply(_32b,args);
}
}
}
};
var _33a=function(){
if(this.squelch){
try{
return _329.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _329.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_33a);
}
var _33b;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_33b=mi.proceed();
}else{
if(this.methodfunc){
_33b=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_33a);
}
return (this.methodfunc)?_33b:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"],args["maxCalls"]);
},addAdvice:function(_340,_341,_342,_343,_344,_345,once,_347,rate,_349,_34a){
var arr=this.getArr(_344);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_340,_341,_342,_343,_347,rate,_349,_34a];
if(once){
if(this.hasAdvice(_340,_341,_344,arr)>=0){
return;
}
}
if(_345=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_34d,_34e,_34f,arr){
if(!arr){
arr=this.getArr(_34f);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _34e=="object")?(new String(_34e)).toString():_34e;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_34d)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_355,_356,_357,once){
var arr=this.getArr(_357);
var ind=this.hasAdvice(_355,_356,_357,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_355,_356,_357,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_35b){
if(!this.topics[_35b]){
this.topics[_35b]=new this.TopicImpl(_35b);
}
return this.topics[_35b];
};
this.registerPublisher=function(_35c,obj,_35e){
var _35c=this.getTopic(_35c);
_35c.registerPublisher(obj,_35e);
};
this.subscribe=function(_35f,obj,_361){
var _35f=this.getTopic(_35f);
_35f.subscribe(obj,_361);
};
this.unsubscribe=function(_362,obj,_364){
var _362=this.getTopic(_362);
_362.unsubscribe(obj,_364);
};
this.destroy=function(_365){
this.getTopic(_365).destroy();
delete this.topics[_365];
};
this.publishApply=function(_366,args){
var _366=this.getTopic(_366);
_366.sendMessage.apply(_366,args);
};
this.publish=function(_368,_369){
var _368=this.getTopic(_368);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_368.sendMessage.apply(_368,args);
};
};
dojo.event.topic.TopicImpl=function(_36c){
this.topicName=_36c;
this.subscribe=function(_36d,_36e){
var tf=_36e||_36d;
var to=(!_36e)?dj_global:_36d;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_371,_372){
var tf=(!_372)?_371:_372;
var to=(!_372)?null:_371;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_375){
this._getJoinPoint().squelch=_375;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_376,_377){
dojo.event.connect(_376,_377,this,"sendMessage");
};
this.sendMessage=function(_378){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_37b){
var na;
var tna;
if(_37b){
tna=_37b.all||_37b.getElementsByTagName("*");
na=[_37b];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _37f={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _384=0;
this.normalizedEventName=function(_385){
switch(_385){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _385;
break;
default:
var lcn=_385.toLowerCase();
return (lcn.indexOf("on")==0)?lcn.substr(2):lcn;
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_38a){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_38a.length;x++){
node.__clobberAttrs__.push(_38a[x]);
}
};
this.removeListener=function(node,_38d,fp,_38f){
if(!_38f){
var _38f=false;
}
_38d=dojo.event.browser.normalizedEventName(_38d);
if(_38d=="key"){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_38f);
}
_38d="keypress";
}
if(node.removeEventListener){
node.removeEventListener(_38d,fp,_38f);
}
};
this.addListener=function(node,_391,fp,_393,_394){
if(!node){
return;
}
if(!_393){
var _393=false;
}
_391=dojo.event.browser.normalizedEventName(_391);
if(_391=="key"){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_393,_394);
}
_391="keypress";
}
if(!_394){
var _395=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_393){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_395=fp;
}
if(node.addEventListener){
node.addEventListener(_391,_395,_393);
return _395;
}else{
_391="on"+_391;
if(typeof node[_391]=="function"){
var _398=node[_391];
node[_391]=function(e){
_398(e);
return _395(e);
};
}else{
node[_391]=_395;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_391]);
}
return _395;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_39b,_39c){
if(typeof _39b!="function"){
dojo.raise("listener not a function: "+_39b);
}
dojo.event.browser.currentEvent.currentTarget=_39c;
return _39b.call(_39c,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_39f){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _3a1=evt.keyCode;
if(_3a1>=65&&_3a1<=90&&evt.shiftKey==false){
_3a1+=32;
}
if(_3a1>=1&&_3a1<=26&&evt.ctrlKey){
_3a1+=96;
}
evt.key=String.fromCharCode(_3a1);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _3a1=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_3a1+=32;
}
evt.key=String.fromCharCode(_3a1);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_39f?_39f:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _3a3=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_3a3.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_3a3.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.kwCompoundRequire({common:["dojo.event.common","dojo.event.topic"],browser:["dojo.event.browser"],dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");


__CPAN_EDITION__ event_and_io build.txt
Files baked into this build:

dojo.js:
dojoGuardStart.js
../src/bootstrap1.js
../src/loader.js
dojoGuardEnd.js
../src/hostenv_browser.js
../src/string/common.js
../src/string.js
../src/lang/common.js
../src/lang/extras.js
../src/io/common.js
../src/lang/array.js
../src/lang/func.js
../src/string/extras.js
../src/dom.js
../src/undo/browser.js
../src/io/BrowserIO.js
../src/io/cookie.js
../src/io/__package__.js
../src/event/common.js
../src/event/topic.js
../src/event/browser.js
../src/event/__package__.js

__CPAN_EDITION__ kitchen_sink dojo.js
/*
	Copyright (c) 2004-2006, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/community/licensing.shtml
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(typeof dojo=="undefined"){
var dj_global=this;
var dj_currentContext=this;
function dj_undef(_1,_2){
return (typeof (_2||dj_currentContext)[_1]=="undefined");
}
if(dj_undef("djConfig",this)){
var djConfig={};
}
if(dj_undef("dojo",this)){
var dojo={};
}
dojo.global=function(){
return dj_currentContext;
};
dojo.locale=djConfig.locale;
dojo.version={major:0,minor:4,patch:3,flag:"",revision:Number("$Rev: 8617 $".match(/[0-9]+/)[0]),toString:function(){
with(dojo.version){
return major+"."+minor+"."+patch+flag+" ("+revision+")";
}
}};
dojo.evalProp=function(_3,_4,_5){
if((!_4)||(!_3)){
return undefined;
}
if(!dj_undef(_3,_4)){
return _4[_3];
}
return (_5?(_4[_3]={}):undefined);
};
dojo.parseObjPath=function(_6,_7,_8){
var _9=(_7||dojo.global());
var _a=_6.split(".");
var _b=_a.pop();
for(var i=0,l=_a.length;i<l&&_9;i++){
_9=dojo.evalProp(_a[i],_9,_8);
}
return {obj:_9,prop:_b};
};
dojo.evalObjPath=function(_e,_f){
if(typeof _e!="string"){
return dojo.global();
}
if(_e.indexOf(".")==-1){
return dojo.evalProp(_e,dojo.global(),_f);
}
var ref=dojo.parseObjPath(_e,dojo.global(),_f);
if(ref){
return dojo.evalProp(ref.prop,ref.obj,_f);
}
return null;
};
dojo.errorToString=function(_11){
if(!dj_undef("message",_11)){
return _11.message;
}else{
if(!dj_undef("description",_11)){
return _11.description;
}else{
return _11;
}
}
};
dojo.raise=function(_12,_13){
if(_13){
_12=_12+": "+dojo.errorToString(_13);
}else{
_12=dojo.errorToString(_12);
}
try{
if(djConfig.isDebug){
dojo.hostenv.println("FATAL exception raised: "+_12);
}
}
catch(e){
}
throw _13||Error(_12);
};
dojo.debug=function(){
};
dojo.debugShallow=function(obj){
};
dojo.profile={start:function(){
},end:function(){
},stop:function(){
},dump:function(){
}};
function dj_eval(_15){
return dj_global.eval?dj_global.eval(_15):eval(_15);
}
dojo.unimplemented=function(_16,_17){
var _18="'"+_16+"' not implemented";
if(_17!=null){
_18+=" "+_17;
}
dojo.raise(_18);
};
dojo.deprecated=function(_19,_1a,_1b){
var _1c="DEPRECATED: "+_19;
if(_1a){
_1c+=" "+_1a;
}
if(_1b){
_1c+=" -- will be removed in version: "+_1b;
}
dojo.debug(_1c);
};
dojo.render=(function(){
function vscaffold(_1d,_1e){
var tmp={capable:false,support:{builtin:false,plugin:false},prefixes:_1d};
for(var i=0;i<_1e.length;i++){
tmp[_1e[i]]=false;
}
return tmp;
}
return {name:"",ver:dojo.version,os:{win:false,linux:false,osx:false},html:vscaffold(["html"],["ie","opera","khtml","safari","moz"]),svg:vscaffold(["svg"],["corel","adobe","batik"]),vml:vscaffold(["vml"],["ie"]),swf:vscaffold(["Swf","Flash","Mm"],["mm"]),swt:vscaffold(["Swt"],["ibm"])};
})();
dojo.hostenv=(function(){
var _21={isDebug:false,allowQueryConfig:false,baseScriptUri:"",baseRelativePath:"",libraryScriptUri:"",iePreventClobber:false,ieClobberMinimal:true,preventBackButtonFix:true,delayMozLoadingFix:false,searchIds:[],parseWidgets:true};
if(typeof djConfig=="undefined"){
djConfig=_21;
}else{
for(var _22 in _21){
if(typeof djConfig[_22]=="undefined"){
djConfig[_22]=_21[_22];
}
}
}
return {name_:"(unset)",version_:"(unset)",getName:function(){
return this.name_;
},getVersion:function(){
return this.version_;
},getText:function(uri){
dojo.unimplemented("getText","uri="+uri);
}};
})();
dojo.hostenv.getBaseScriptUri=function(){
if(djConfig.baseScriptUri.length){
return djConfig.baseScriptUri;
}
var uri=new String(djConfig.libraryScriptUri||djConfig.baseRelativePath);
if(!uri){
dojo.raise("Nothing returned by getLibraryScriptUri(): "+uri);
}
var _25=uri.lastIndexOf("/");
djConfig.baseScriptUri=djConfig.baseRelativePath;
return djConfig.baseScriptUri;
};
(function(){
var _26={pkgFileName:"__package__",loading_modules_:{},loaded_modules_:{},addedToLoadingCount:[],removedFromLoadingCount:[],inFlightCount:0,modulePrefixes_:{dojo:{name:"dojo",value:"src"}},setModulePrefix:function(_27,_28){
this.modulePrefixes_[_27]={name:_27,value:_28};
},moduleHasPrefix:function(_29){
var mp=this.modulePrefixes_;
return Boolean(mp[_29]&&mp[_29].value);
},getModulePrefix:function(_2b){
if(this.moduleHasPrefix(_2b)){
return this.modulePrefixes_[_2b].value;
}
return _2b;
},getTextStack:[],loadUriStack:[],loadedUris:[],post_load_:false,modulesLoadedListeners:[],unloadListeners:[],loadNotifying:false};
for(var _2c in _26){
dojo.hostenv[_2c]=_26[_2c];
}
})();
dojo.hostenv.loadPath=function(_2d,_2e,cb){
var uri;
if(_2d.charAt(0)=="/"||_2d.match(/^\w+:/)){
uri=_2d;
}else{
uri=this.getBaseScriptUri()+_2d;
}
if(djConfig.cacheBust&&dojo.render.html.capable){
uri+="?"+String(djConfig.cacheBust).replace(/\W+/g,"");
}
try{
return !_2e?this.loadUri(uri,cb):this.loadUriAndCheck(uri,_2e,cb);
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.hostenv.loadUri=function(uri,cb){
if(this.loadedUris[uri]){
return true;
}
var _33=this.getText(uri,null,true);
if(!_33){
return false;
}
this.loadedUris[uri]=true;
if(cb){
_33="("+_33+")";
}
var _34=dj_eval(_33);
if(cb){
cb(_34);
}
return true;
};
dojo.hostenv.loadUriAndCheck=function(uri,_36,cb){
var ok=true;
try{
ok=this.loadUri(uri,cb);
}
catch(e){
dojo.debug("failed loading ",uri," with error: ",e);
}
return Boolean(ok&&this.findModule(_36,false));
};
dojo.loaded=function(){
};
dojo.unloaded=function(){
};
dojo.hostenv.loaded=function(){
this.loadNotifying=true;
this.post_load_=true;
var mll=this.modulesLoadedListeners;
for(var x=0;x<mll.length;x++){
mll[x]();
}
this.modulesLoadedListeners=[];
this.loadNotifying=false;
dojo.loaded();
};
dojo.hostenv.unloaded=function(){
var mll=this.unloadListeners;
while(mll.length){
(mll.pop())();
}
dojo.unloaded();
};
dojo.addOnLoad=function(obj,_3d){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.modulesLoadedListeners.push(obj);
}else{
if(arguments.length>1){
dh.modulesLoadedListeners.push(function(){
obj[_3d]();
});
}
}
if(dh.post_load_&&dh.inFlightCount==0&&!dh.loadNotifying){
dh.callLoaded();
}
};
dojo.addOnUnload=function(obj,_40){
var dh=dojo.hostenv;
if(arguments.length==1){
dh.unloadListeners.push(obj);
}else{
if(arguments.length>1){
dh.unloadListeners.push(function(){
obj[_40]();
});
}
}
};
dojo.hostenv.modulesLoaded=function(){
if(this.post_load_){
return;
}
if(this.loadUriStack.length==0&&this.getTextStack.length==0){
if(this.inFlightCount>0){
dojo.debug("files still in flight!");
return;
}
dojo.hostenv.callLoaded();
}
};
dojo.hostenv.callLoaded=function(){
if(typeof setTimeout=="object"||(djConfig["useXDomain"]&&dojo.render.html.opera)){
setTimeout("dojo.hostenv.loaded();",0);
}else{
dojo.hostenv.loaded();
}
};
dojo.hostenv.getModuleSymbols=function(_42){
var _43=_42.split(".");
for(var i=_43.length;i>0;i--){
var _45=_43.slice(0,i).join(".");
if((i==1)&&!this.moduleHasPrefix(_45)){
_43[0]="../"+_43[0];
}else{
var _46=this.getModulePrefix(_45);
if(_46!=_45){
_43.splice(0,i,_46);
break;
}
}
}
return _43;
};
dojo.hostenv._global_omit_module_check=false;
dojo.hostenv.loadModule=function(_47,_48,_49){
if(!_47){
return;
}
_49=this._global_omit_module_check||_49;
var _4a=this.findModule(_47,false);
if(_4a){
return _4a;
}
if(dj_undef(_47,this.loading_modules_)){
this.addedToLoadingCount.push(_47);
}
this.loading_modules_[_47]=1;
var _4b=_47.replace(/\./g,"/")+".js";
var _4c=_47.split(".");
var _4d=this.getModuleSymbols(_47);
var _4e=((_4d[0].charAt(0)!="/")&&!_4d[0].match(/^\w+:/));
var _4f=_4d[_4d.length-1];
var ok;
if(_4f=="*"){
_47=_4c.slice(0,-1).join(".");
while(_4d.length){
_4d.pop();
_4d.push(this.pkgFileName);
_4b=_4d.join("/")+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,!_49?_47:null);
if(ok){
break;
}
_4d.pop();
}
}else{
_4b=_4d.join("/")+".js";
_47=_4c.join(".");
var _51=!_49?_47:null;
ok=this.loadPath(_4b,_51);
if(!ok&&!_48){
_4d.pop();
while(_4d.length){
_4b=_4d.join("/")+".js";
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
_4d.pop();
_4b=_4d.join("/")+"/"+this.pkgFileName+".js";
if(_4e&&_4b.charAt(0)=="/"){
_4b=_4b.slice(1);
}
ok=this.loadPath(_4b,_51);
if(ok){
break;
}
}
}
if(!ok&&!_49){
dojo.raise("Could not load '"+_47+"'; last tried '"+_4b+"'");
}
}
if(!_49&&!this["isXDomain"]){
_4a=this.findModule(_47,false);
if(!_4a){
dojo.raise("symbol '"+_47+"' is not defined after loading '"+_4b+"'");
}
}
return _4a;
};
dojo.hostenv.startPackage=function(_52){
var _53=String(_52);
var _54=_53;
var _55=_52.split(/\./);
if(_55[_55.length-1]=="*"){
_55.pop();
_54=_55.join(".");
}
var _56=dojo.evalObjPath(_54,true);
this.loaded_modules_[_53]=_56;
this.loaded_modules_[_54]=_56;
return _56;
};
dojo.hostenv.findModule=function(_57,_58){
var lmn=String(_57);
if(this.loaded_modules_[lmn]){
return this.loaded_modules_[lmn];
}
if(_58){
dojo.raise("no loaded module named '"+_57+"'");
}
return null;
};
dojo.kwCompoundRequire=function(_5a){
var _5b=_5a["common"]||[];
var _5c=_5a[dojo.hostenv.name_]?_5b.concat(_5a[dojo.hostenv.name_]||[]):_5b.concat(_5a["default"]||[]);
for(var x=0;x<_5c.length;x++){
var _5e=_5c[x];
if(_5e.constructor==Array){
dojo.hostenv.loadModule.apply(dojo.hostenv,_5e);
}else{
dojo.hostenv.loadModule(_5e);
}
}
};
dojo.require=function(_5f){
dojo.hostenv.loadModule.apply(dojo.hostenv,arguments);
};
dojo.requireIf=function(_60,_61){
var _62=arguments[0];
if((_62===true)||(_62=="common")||(_62&&dojo.render[_62].capable)){
var _63=[];
for(var i=1;i<arguments.length;i++){
_63.push(arguments[i]);
}
dojo.require.apply(dojo,_63);
}
};
dojo.requireAfterIf=dojo.requireIf;
dojo.provide=function(_65){
return dojo.hostenv.startPackage.apply(dojo.hostenv,arguments);
};
dojo.registerModulePath=function(_66,_67){
return dojo.hostenv.setModulePrefix(_66,_67);
};
if(djConfig["modulePaths"]){
for(var param in djConfig["modulePaths"]){
dojo.registerModulePath(param,djConfig["modulePaths"][param]);
}
}
dojo.setModulePrefix=function(_68,_69){
dojo.deprecated("dojo.setModulePrefix(\""+_68+"\", \""+_69+"\")","replaced by dojo.registerModulePath","0.5");
return dojo.registerModulePath(_68,_69);
};
dojo.exists=function(obj,_6b){
var p=_6b.split(".");
for(var i=0;i<p.length;i++){
if(!obj[p[i]]){
return false;
}
obj=obj[p[i]];
}
return true;
};
dojo.hostenv.normalizeLocale=function(_6e){
var _6f=_6e?_6e.toLowerCase():dojo.locale;
if(_6f=="root"){
_6f="ROOT";
}
return _6f;
};
dojo.hostenv.searchLocalePath=function(_70,_71,_72){
_70=dojo.hostenv.normalizeLocale(_70);
var _73=_70.split("-");
var _74=[];
for(var i=_73.length;i>0;i--){
_74.push(_73.slice(0,i).join("-"));
}
_74.push(false);
if(_71){
_74.reverse();
}
for(var j=_74.length-1;j>=0;j--){
var loc=_74[j]||"ROOT";
var _78=_72(loc);
if(_78){
break;
}
}
};
dojo.hostenv.localesGenerated;
dojo.hostenv.registerNlsPrefix=function(){
dojo.registerModulePath("nls","nls");
};
dojo.hostenv.preloadLocalizations=function(){
if(dojo.hostenv.localesGenerated){
dojo.hostenv.registerNlsPrefix();
function preload(_79){
_79=dojo.hostenv.normalizeLocale(_79);
dojo.hostenv.searchLocalePath(_79,true,function(loc){
for(var i=0;i<dojo.hostenv.localesGenerated.length;i++){
if(dojo.hostenv.localesGenerated[i]==loc){
dojo["require"]("nls.dojo_"+loc);
return true;
}
}
return false;
});
}
preload();
var _7c=djConfig.extraLocale||[];
for(var i=0;i<_7c.length;i++){
preload(_7c[i]);
}
}
dojo.hostenv.preloadLocalizations=function(){
};
};
dojo.requireLocalization=function(_7e,_7f,_80,_81){
dojo.hostenv.preloadLocalizations();
var _82=dojo.hostenv.normalizeLocale(_80);
var _83=[_7e,"nls",_7f].join(".");
var _84="";
if(_81){
var _85=_81.split(",");
for(var i=0;i<_85.length;i++){
if(_82.indexOf(_85[i])==0){
if(_85[i].length>_84.length){
_84=_85[i];
}
}
}
if(!_84){
_84="ROOT";
}
}
var _87=_81?_84:_82;
var _88=dojo.hostenv.findModule(_83);
var _89=null;
if(_88){
if(djConfig.localizationComplete&&_88._built){
return;
}
var _8a=_87.replace("-","_");
var _8b=_83+"."+_8a;
_89=dojo.hostenv.findModule(_8b);
}
if(!_89){
_88=dojo.hostenv.startPackage(_83);
var _8c=dojo.hostenv.getModuleSymbols(_7e);
var _8d=_8c.concat("nls").join("/");
var _8e;
dojo.hostenv.searchLocalePath(_87,_81,function(loc){
var _90=loc.replace("-","_");
var _91=_83+"."+_90;
var _92=false;
if(!dojo.hostenv.findModule(_91)){
dojo.hostenv.startPackage(_91);
var _93=[_8d];
if(loc!="ROOT"){
_93.push(loc);
}
_93.push(_7f);
var _94=_93.join("/")+".js";
_92=dojo.hostenv.loadPath(_94,null,function(_95){
var _96=function(){
};
_96.prototype=_8e;
_88[_90]=new _96();
for(var j in _95){
_88[_90][j]=_95[j];
}
});
}else{
_92=true;
}
if(_92&&_88[_90]){
_8e=_88[_90];
}else{
_88[_90]=_8e;
}
if(_81){
return true;
}
});
}
if(_81&&_82!=_84){
_88[_82.replace("-","_")]=_88[_84.replace("-","_")];
}
};
(function(){
var _98=djConfig.extraLocale;
if(_98){
if(!_98 instanceof Array){
_98=[_98];
}
var req=dojo.requireLocalization;
dojo.requireLocalization=function(m,b,_9c,_9d){
req(m,b,_9c,_9d);
if(_9c){
return;
}
for(var i=0;i<_98.length;i++){
req(m,b,_98[i],_9d);
}
};
}
})();
}
if(typeof window!="undefined"){
(function(){
if(djConfig.allowQueryConfig){
var _9f=document.location.toString();
var _a0=_9f.split("?",2);
if(_a0.length>1){
var _a1=_a0[1];
var _a2=_a1.split("&");
for(var x in _a2){
var sp=_a2[x].split("=");
if((sp[0].length>9)&&(sp[0].substr(0,9)=="djConfig.")){
var opt=sp[0].substr(9);
try{
djConfig[opt]=eval(sp[1]);
}
catch(e){
djConfig[opt]=sp[1];
}
}
}
}
}
if(((djConfig["baseScriptUri"]=="")||(djConfig["baseRelativePath"]==""))&&(document&&document.getElementsByTagName)){
var _a6=document.getElementsByTagName("script");
var _a7=/(__package__|dojo|bootstrap1)\.js([\?\.]|$)/i;
for(var i=0;i<_a6.length;i++){
var src=_a6[i].getAttribute("src");
if(!src){
continue;
}
var m=src.match(_a7);
if(m){
var _ab=src.substring(0,m.index);
if(src.indexOf("bootstrap1")>-1){
_ab+="../";
}
if(!this["djConfig"]){
djConfig={};
}
if(djConfig["baseScriptUri"]==""){
djConfig["baseScriptUri"]=_ab;
}
if(djConfig["baseRelativePath"]==""){
djConfig["baseRelativePath"]=_ab;
}
break;
}
}
}
var dr=dojo.render;
var drh=dojo.render.html;
var drs=dojo.render.svg;
var dua=(drh.UA=navigator.userAgent);
var dav=(drh.AV=navigator.appVersion);
var t=true;
var f=false;
drh.capable=t;
drh.support.builtin=t;
dr.ver=parseFloat(drh.AV);
dr.os.mac=dav.indexOf("Macintosh")>=0;
dr.os.win=dav.indexOf("Windows")>=0;
dr.os.linux=dav.indexOf("X11")>=0;
drh.opera=dua.indexOf("Opera")>=0;
drh.khtml=(dav.indexOf("Konqueror")>=0)||(dav.indexOf("Safari")>=0);
drh.safari=dav.indexOf("Safari")>=0;
var _b3=dua.indexOf("Gecko");
drh.mozilla=drh.moz=(_b3>=0)&&(!drh.khtml);
if(drh.mozilla){
drh.geckoVersion=dua.substring(_b3+6,_b3+14);
}
drh.ie=(document.all)&&(!drh.opera);
drh.ie50=drh.ie&&dav.indexOf("MSIE 5.0")>=0;
drh.ie55=drh.ie&&dav.indexOf("MSIE 5.5")>=0;
drh.ie60=drh.ie&&dav.indexOf("MSIE 6.0")>=0;
drh.ie70=drh.ie&&dav.indexOf("MSIE 7.0")>=0;
var cm=document["compatMode"];
drh.quirks=(cm=="BackCompat")||(cm=="QuirksMode")||drh.ie55||drh.ie50;
dojo.locale=dojo.locale||(drh.ie?navigator.userLanguage:navigator.language).toLowerCase();
dr.vml.capable=drh.ie;
drs.capable=f;
drs.support.plugin=f;
drs.support.builtin=f;
var _b5=window["document"];
var tdi=_b5["implementation"];
if((tdi)&&(tdi["hasFeature"])&&(tdi.hasFeature("org.w3c.dom.svg","1.0"))){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
if(drh.safari){
var tmp=dua.split("AppleWebKit/")[1];
var ver=parseFloat(tmp.split(" ")[0]);
if(ver>=420){
drs.capable=t;
drs.support.builtin=t;
drs.support.plugin=f;
}
}else{
}
})();
dojo.hostenv.startPackage("dojo.hostenv");
dojo.render.name=dojo.hostenv.name_="browser";
dojo.hostenv.searchIds=[];
dojo.hostenv._XMLHTTP_PROGIDS=["Msxml2.XMLHTTP","Microsoft.XMLHTTP","Msxml2.XMLHTTP.4.0"];
dojo.hostenv.getXmlhttpObject=function(){
var _b9=null;
var _ba=null;
try{
_b9=new XMLHttpRequest();
}
catch(e){
}
if(!_b9){
for(var i=0;i<3;++i){
var _bc=dojo.hostenv._XMLHTTP_PROGIDS[i];
try{
_b9=new ActiveXObject(_bc);
}
catch(e){
_ba=e;
}
if(_b9){
dojo.hostenv._XMLHTTP_PROGIDS=[_bc];
break;
}
}
}
if(!_b9){
return dojo.raise("XMLHTTP not available",_ba);
}
return _b9;
};
dojo.hostenv._blockAsync=false;
dojo.hostenv.getText=function(uri,_be,_bf){
if(!_be){
this._blockAsync=true;
}
var _c0=this.getXmlhttpObject();
function isDocumentOk(_c1){
var _c2=_c1["status"];
return Boolean((!_c2)||((200<=_c2)&&(300>_c2))||(_c2==304));
}
if(_be){
var _c3=this,_c4=null,gbl=dojo.global();
var xhr=dojo.evalObjPath("dojo.io.XMLHTTPTransport");
_c0.onreadystatechange=function(){
if(_c4){
gbl.clearTimeout(_c4);
_c4=null;
}
if(_c3._blockAsync||(xhr&&xhr._blockAsync)){
_c4=gbl.setTimeout(function(){
_c0.onreadystatechange.apply(this);
},10);
}else{
if(4==_c0.readyState){
if(isDocumentOk(_c0)){
_be(_c0.responseText);
}
}
}
};
}
_c0.open("GET",uri,_be?true:false);
try{
_c0.send(null);
if(_be){
return null;
}
if(!isDocumentOk(_c0)){
var err=Error("Unable to load "+uri+" status:"+_c0.status);
err.status=_c0.status;
err.responseText=_c0.responseText;
throw err;
}
}
catch(e){
this._blockAsync=false;
if((_bf)&&(!_be)){
return null;
}else{
throw e;
}
}
this._blockAsync=false;
return _c0.responseText;
};
dojo.hostenv.defaultDebugContainerId="dojoDebug";
dojo.hostenv._println_buffer=[];
dojo.hostenv._println_safe=false;
dojo.hostenv.println=function(_c8){
if(!dojo.hostenv._println_safe){
dojo.hostenv._println_buffer.push(_c8);
}else{
try{
var _c9=document.getElementById(djConfig.debugContainerId?djConfig.debugContainerId:dojo.hostenv.defaultDebugContainerId);
if(!_c9){
_c9=dojo.body();
}
var div=document.createElement("div");
div.appendChild(document.createTextNode(_c8));
_c9.appendChild(div);
}
catch(e){
try{
document.write("<div>"+_c8+"</div>");
}
catch(e2){
window.status=_c8;
}
}
}
};
dojo.addOnLoad(function(){
dojo.hostenv._println_safe=true;
while(dojo.hostenv._println_buffer.length>0){
dojo.hostenv.println(dojo.hostenv._println_buffer.shift());
}
});
function dj_addNodeEvtHdlr(_cb,_cc,fp){
var _ce=_cb["on"+_cc]||function(){
};
_cb["on"+_cc]=function(){
fp.apply(_cb,arguments);
_ce.apply(_cb,arguments);
};
return true;
}
dojo.hostenv._djInitFired=false;
function dj_load_init(e){
dojo.hostenv._djInitFired=true;
var _d0=(e&&e.type)?e.type.toLowerCase():"load";
if(arguments.callee.initialized||(_d0!="domcontentloaded"&&_d0!="load")){
return;
}
arguments.callee.initialized=true;
if(typeof (_timer)!="undefined"){
clearInterval(_timer);
delete _timer;
}
var _d1=function(){
if(dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
};
if(dojo.hostenv.inFlightCount==0){
_d1();
dojo.hostenv.modulesLoaded();
}else{
dojo.hostenv.modulesLoadedListeners.unshift(_d1);
}
}
if(document.addEventListener){
if(dojo.render.html.opera||(dojo.render.html.moz&&(djConfig["enableMozDomContentLoaded"]===true))){
document.addEventListener("DOMContentLoaded",dj_load_init,null);
}
window.addEventListener("load",dj_load_init,null);
}
if(dojo.render.html.ie&&dojo.render.os.win){
document.attachEvent("onreadystatechange",function(e){
if(document.readyState=="complete"){
dj_load_init();
}
});
}
if(/(WebKit|khtml)/i.test(navigator.userAgent)){
var _timer=setInterval(function(){
if(/loaded|complete/.test(document.readyState)){
dj_load_init();
}
},10);
}
if(dojo.render.html.ie){
dj_addNodeEvtHdlr(window,"beforeunload",function(){
dojo.hostenv._unloading=true;
window.setTimeout(function(){
dojo.hostenv._unloading=false;
},0);
});
}
dj_addNodeEvtHdlr(window,"unload",function(){
dojo.hostenv.unloaded();
if((!dojo.render.html.ie)||(dojo.render.html.ie&&dojo.hostenv._unloading)){
dojo.hostenv.unloaded();
}
});
dojo.hostenv.makeWidgets=function(){
var _d3=[];
if(djConfig.searchIds&&djConfig.searchIds.length>0){
_d3=_d3.concat(djConfig.searchIds);
}
if(dojo.hostenv.searchIds&&dojo.hostenv.searchIds.length>0){
_d3=_d3.concat(dojo.hostenv.searchIds);
}
if((djConfig.parseWidgets)||(_d3.length>0)){
if(dojo.evalObjPath("dojo.widget.Parse")){
var _d4=new dojo.xml.Parse();
if(_d3.length>0){
for(var x=0;x<_d3.length;x++){
var _d6=document.getElementById(_d3[x]);
if(!_d6){
continue;
}
var _d7=_d4.parseElement(_d6,null,true);
dojo.widget.getParser().createComponents(_d7);
}
}else{
if(djConfig.parseWidgets){
var _d7=_d4.parseElement(dojo.body(),null,true);
dojo.widget.getParser().createComponents(_d7);
}
}
}
}
};
dojo.addOnLoad(function(){
if(!dojo.render.html.ie){
dojo.hostenv.makeWidgets();
}
});
try{
if(dojo.render.html.ie){
document.namespaces.add("v","urn:schemas-microsoft-com:vml");
document.createStyleSheet().addRule("v\\:*","behavior:url(#default#VML)");
}
}
catch(e){
}
dojo.hostenv.writeIncludes=function(){
};
if(!dj_undef("document",this)){
dj_currentDocument=this.document;
}
dojo.doc=function(){
return dj_currentDocument;
};
dojo.body=function(){
return dojo.doc().body||dojo.doc().getElementsByTagName("body")[0];
};
dojo.byId=function(id,doc){
if((id)&&((typeof id=="string")||(id instanceof String))){
if(!doc){
doc=dj_currentDocument;
}
var ele=doc.getElementById(id);
if(ele&&(ele.id!=id)&&doc.all){
ele=null;
eles=doc.all[id];
if(eles){
if(eles.length){
for(var i=0;i<eles.length;i++){
if(eles[i].id==id){
ele=eles[i];
break;
}
}
}else{
ele=eles;
}
}
}
return ele;
}
return id;
};
dojo.setContext=function(_dc,_dd){
dj_currentContext=_dc;
dj_currentDocument=_dd;
};
dojo._fireCallback=function(_de,_df,_e0){
if((_df)&&((typeof _de=="string")||(_de instanceof String))){
_de=_df[_de];
}
return (_df?_de.apply(_df,_e0||[]):_de());
};
dojo.withGlobal=function(_e1,_e2,_e3,_e4){
var _e5;
var _e6=dj_currentContext;
var _e7=dj_currentDocument;
try{
dojo.setContext(_e1,_e1.document);
_e5=dojo._fireCallback(_e2,_e3,_e4);
}
finally{
dojo.setContext(_e6,_e7);
}
return _e5;
};
dojo.withDoc=function(_e8,_e9,_ea,_eb){
var _ec;
var _ed=dj_currentDocument;
try{
dj_currentDocument=_e8;
_ec=dojo._fireCallback(_e9,_ea,_eb);
}
finally{
dj_currentDocument=_ed;
}
return _ec;
};
}
dojo.requireIf((djConfig["isDebug"]||djConfig["debugAtAllCosts"]),"dojo.debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&!djConfig["useXDomain"],"dojo.browser_debug");
dojo.requireIf(djConfig["debugAtAllCosts"]&&!window.widget&&djConfig["useXDomain"],"dojo.browser_debug_xd");
dojo.provide("dojo.lang.common");
dojo.lang.inherits=function(_ee,_ef){
if(!dojo.lang.isFunction(_ef)){
dojo.raise("dojo.inherits: superclass argument ["+_ef+"] must be a function (subclass: ["+_ee+"']");
}
_ee.prototype=new _ef();
_ee.prototype.constructor=_ee;
_ee.superclass=_ef.prototype;
_ee["super"]=_ef.prototype;
};
dojo.lang._mixin=function(obj,_f1){
var _f2={};
for(var x in _f1){
if((typeof _f2[x]=="undefined")||(_f2[x]!=_f1[x])){
obj[x]=_f1[x];
}
}
if(dojo.render.html.ie&&(typeof (_f1["toString"])=="function")&&(_f1["toString"]!=obj["toString"])&&(_f1["toString"]!=_f2["toString"])){
obj.toString=_f1.toString;
}
return obj;
};
dojo.lang.mixin=function(obj,_f5){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(obj,arguments[i]);
}
return obj;
};
dojo.lang.extend=function(_f8,_f9){
for(var i=1,l=arguments.length;i<l;i++){
dojo.lang._mixin(_f8.prototype,arguments[i]);
}
return _f8;
};
dojo.inherits=dojo.lang.inherits;
dojo.mixin=dojo.lang.mixin;
dojo.extend=dojo.lang.extend;
dojo.lang.find=function(_fc,_fd,_fe,_ff){
if(!dojo.lang.isArrayLike(_fc)&&dojo.lang.isArrayLike(_fd)){
dojo.deprecated("dojo.lang.find(value, array)","use dojo.lang.find(array, value) instead","0.5");
var temp=_fc;
_fc=_fd;
_fd=temp;
}
var _101=dojo.lang.isString(_fc);
if(_101){
_fc=_fc.split("");
}
if(_ff){
var step=-1;
var i=_fc.length-1;
var end=-1;
}else{
var step=1;
var i=0;
var end=_fc.length;
}
if(_fe){
while(i!=end){
if(_fc[i]===_fd){
return i;
}
i+=step;
}
}else{
while(i!=end){
if(_fc[i]==_fd){
return i;
}
i+=step;
}
}
return -1;
};
dojo.lang.indexOf=dojo.lang.find;
dojo.lang.findLast=function(_105,_106,_107){
return dojo.lang.find(_105,_106,_107,true);
};
dojo.lang.lastIndexOf=dojo.lang.findLast;
dojo.lang.inArray=function(_108,_109){
return dojo.lang.find(_108,_109)>-1;
};
dojo.lang.isObject=function(it){
if(typeof it=="undefined"){
return false;
}
return (typeof it=="object"||it===null||dojo.lang.isArray(it)||dojo.lang.isFunction(it));
};
dojo.lang.isArray=function(it){
return (it&&it instanceof Array||typeof it=="array");
};
dojo.lang.isArrayLike=function(it){
if((!it)||(dojo.lang.isUndefined(it))){
return false;
}
if(dojo.lang.isString(it)){
return false;
}
if(dojo.lang.isFunction(it)){
return false;
}
if(dojo.lang.isArray(it)){
return true;
}
if((it.tagName)&&(it.tagName.toLowerCase()=="form")){
return false;
}
if(dojo.lang.isNumber(it.length)&&isFinite(it.length)){
return true;
}
return false;
};
dojo.lang.isFunction=function(it){
return (it instanceof Function||typeof it=="function");
};
(function(){
if((dojo.render.html.capable)&&(dojo.render.html["safari"])){
dojo.lang.isFunction=function(it){
if((typeof (it)=="function")&&(it=="[object NodeList]")){
return false;
}
return (it instanceof Function||typeof it=="function");
};
}
})();
dojo.lang.isString=function(it){
return (typeof it=="string"||it instanceof String);
};
dojo.lang.isAlien=function(it){
if(!it){
return false;
}
return !dojo.lang.isFunction(it)&&/\{\s*\[native code\]\s*\}/.test(String(it));
};
dojo.lang.isBoolean=function(it){
return (it instanceof Boolean||typeof it=="boolean");
};
dojo.lang.isNumber=function(it){
return (it instanceof Number||typeof it=="number");
};
dojo.lang.isUndefined=function(it){
return ((typeof (it)=="undefined")&&(it==undefined));
};
dojo.provide("dojo.lang");
dojo.deprecated("dojo.lang","replaced by dojo.lang.common","0.5");
dojo.provide("dojo.dom");
dojo.dom.ELEMENT_NODE=1;
dojo.dom.ATTRIBUTE_NODE=2;
dojo.dom.TEXT_NODE=3;
dojo.dom.CDATA_SECTION_NODE=4;
dojo.dom.ENTITY_REFERENCE_NODE=5;
dojo.dom.ENTITY_NODE=6;
dojo.dom.PROCESSING_INSTRUCTION_NODE=7;
dojo.dom.COMMENT_NODE=8;
dojo.dom.DOCUMENT_NODE=9;
dojo.dom.DOCUMENT_TYPE_NODE=10;
dojo.dom.DOCUMENT_FRAGMENT_NODE=11;
dojo.dom.NOTATION_NODE=12;
dojo.dom.dojoml="http://www.dojotoolkit.org/2004/dojoml";
dojo.dom.xmlns={svg:"http://www.w3.org/2000/svg",smil:"http://www.w3.org/2001/SMIL20/",mml:"http://www.w3.org/1998/Math/MathML",cml:"http://www.xml-cml.org",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml",xul:"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",xbl:"http://www.mozilla.org/xbl",fo:"http://www.w3.org/1999/XSL/Format",xsl:"http://www.w3.org/1999/XSL/Transform",xslt:"http://www.w3.org/1999/XSL/Transform",xi:"http://www.w3.org/2001/XInclude",xforms:"http://www.w3.org/2002/01/xforms",saxon:"http://icl.com/saxon",xalan:"http://xml.apache.org/xslt",xsd:"http://www.w3.org/2001/XMLSchema",dt:"http://www.w3.org/2001/XMLSchema-datatypes",xsi:"http://www.w3.org/2001/XMLSchema-instance",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dc:"http://purl.org/dc/elements/1.1/",dcq:"http://purl.org/dc/qualifiers/1.0","soap-env":"http://schemas.xmlsoap.org/soap/envelope/",wsdl:"http://schemas.xmlsoap.org/wsdl/",AdobeExtensions:"http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/"};
dojo.dom.isNode=function(wh){
if(typeof Element=="function"){
try{
return wh instanceof Element;
}
catch(e){
}
}else{
return wh&&!isNaN(wh.nodeType);
}
};
dojo.dom.getUniqueId=function(){
var _115=dojo.doc();
do{
var id="dj_unique_"+(++arguments.callee._idIncrement);
}while(_115.getElementById(id));
return id;
};
dojo.dom.getUniqueId._idIncrement=0;
dojo.dom.firstElement=dojo.dom.getFirstChildElement=function(_117,_118){
var node=_117.firstChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.nextSibling;
}
if(_118&&node&&node.tagName&&node.tagName.toLowerCase()!=_118.toLowerCase()){
node=dojo.dom.nextElement(node,_118);
}
return node;
};
dojo.dom.lastElement=dojo.dom.getLastChildElement=function(_11a,_11b){
var node=_11a.lastChild;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.previousSibling;
}
if(_11b&&node&&node.tagName&&node.tagName.toLowerCase()!=_11b.toLowerCase()){
node=dojo.dom.prevElement(node,_11b);
}
return node;
};
dojo.dom.nextElement=dojo.dom.getNextSiblingElement=function(node,_11e){
if(!node){
return null;
}
do{
node=node.nextSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_11e&&_11e.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.nextElement(node,_11e);
}
return node;
};
dojo.dom.prevElement=dojo.dom.getPreviousSiblingElement=function(node,_120){
if(!node){
return null;
}
if(_120){
_120=_120.toLowerCase();
}
do{
node=node.previousSibling;
}while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE);
if(node&&_120&&_120.toLowerCase()!=node.tagName.toLowerCase()){
return dojo.dom.prevElement(node,_120);
}
return node;
};
dojo.dom.moveChildren=function(_121,_122,trim){
var _124=0;
if(trim){
while(_121.hasChildNodes()&&_121.firstChild.nodeType==dojo.dom.TEXT_NODE){
_121.removeChild(_121.firstChild);
}
while(_121.hasChildNodes()&&_121.lastChild.nodeType==dojo.dom.TEXT_NODE){
_121.removeChild(_121.lastChild);
}
}
while(_121.hasChildNodes()){
_122.appendChild(_121.firstChild);
_124++;
}
return _124;
};
dojo.dom.copyChildren=function(_125,_126,trim){
var _128=_125.cloneNode(true);
return this.moveChildren(_128,_126,trim);
};
dojo.dom.replaceChildren=function(node,_12a){
var _12b=[];
if(dojo.render.html.ie){
for(var i=0;i<node.childNodes.length;i++){
_12b.push(node.childNodes[i]);
}
}
dojo.dom.removeChildren(node);
node.appendChild(_12a);
for(var i=0;i<_12b.length;i++){
dojo.dom.destroyNode(_12b[i]);
}
};
dojo.dom.removeChildren=function(node){
var _12e=node.childNodes.length;
while(node.hasChildNodes()){
dojo.dom.removeNode(node.firstChild);
}
return _12e;
};
dojo.dom.replaceNode=function(node,_130){
return node.parentNode.replaceChild(_130,node);
};
dojo.dom.destroyNode=function(node){
if(node.parentNode){
node=dojo.dom.removeNode(node);
}
if(node.nodeType!=3){
if(dojo.evalObjPath("dojo.event.browser.clean",false)){
dojo.event.browser.clean(node);
}
if(dojo.render.html.ie){
node.outerHTML="";
}
}
};
dojo.dom.removeNode=function(node){
if(node&&node.parentNode){
return node.parentNode.removeChild(node);
}
};
dojo.dom.getAncestors=function(node,_134,_135){
var _136=[];
var _137=(_134&&(_134 instanceof Function||typeof _134=="function"));
while(node){
if(!_137||_134(node)){
_136.push(node);
}
if(_135&&_136.length>0){
return _136[0];
}
node=node.parentNode;
}
if(_135){
return null;
}
return _136;
};
dojo.dom.getAncestorsByTag=function(node,tag,_13a){
tag=tag.toLowerCase();
return dojo.dom.getAncestors(node,function(el){
return ((el.tagName)&&(el.tagName.toLowerCase()==tag));
},_13a);
};
dojo.dom.getFirstAncestorByTag=function(node,tag){
return dojo.dom.getAncestorsByTag(node,tag,true);
};
dojo.dom.isDescendantOf=function(node,_13f,_140){
if(_140&&node){
node=node.parentNode;
}
while(node){
if(node==_13f){
return true;
}
node=node.parentNode;
}
return false;
};
dojo.dom.innerXML=function(node){
if(node.innerXML){
return node.innerXML;
}else{
if(node.xml){
return node.xml;
}else{
if(typeof XMLSerializer!="undefined"){
return (new XMLSerializer()).serializeToString(node);
}
}
}
};
dojo.dom.createDocument=function(){
var doc=null;
var _143=dojo.doc();
if(!dj_undef("ActiveXObject")){
var _144=["MSXML2","Microsoft","MSXML","MSXML3"];
for(var i=0;i<_144.length;i++){
try{
doc=new ActiveXObject(_144[i]+".XMLDOM");
}
catch(e){
}
if(doc){
break;
}
}
}else{
if((_143.implementation)&&(_143.implementation.createDocument)){
doc=_143.implementation.createDocument("","",null);
}
}
return doc;
};
dojo.dom.createDocumentFromText=function(str,_147){
if(!_147){
_147="text/xml";
}
if(!dj_undef("DOMParser")){
var _148=new DOMParser();
return _148.parseFromString(str,_147);
}else{
if(!dj_undef("ActiveXObject")){
var _149=dojo.dom.createDocument();
if(_149){
_149.async=false;
_149.loadXML(str);
return _149;
}else{
dojo.debug("toXml didn't work?");
}
}else{
var _14a=dojo.doc();
if(_14a.createElement){
var tmp=_14a.createElement("xml");
tmp.innerHTML=str;
if(_14a.implementation&&_14a.implementation.createDocument){
var _14c=_14a.implementation.createDocument("foo","",null);
for(var i=0;i<tmp.childNodes.length;i++){
_14c.importNode(tmp.childNodes.item(i),true);
}
return _14c;
}
return ((tmp.document)&&(tmp.document.firstChild?tmp.document.firstChild:tmp));
}
}
}
return null;
};
dojo.dom.prependChild=function(node,_14f){
if(_14f.firstChild){
_14f.insertBefore(node,_14f.firstChild);
}else{
_14f.appendChild(node);
}
return true;
};
dojo.dom.insertBefore=function(node,ref,_152){
if((_152!=true)&&(node===ref||node.nextSibling===ref)){
return false;
}
var _153=ref.parentNode;
_153.insertBefore(node,ref);
return true;
};
dojo.dom.insertAfter=function(node,ref,_156){
var pn=ref.parentNode;
if(ref==pn.lastChild){
if((_156!=true)&&(node===ref)){
return false;
}
pn.appendChild(node);
}else{
return this.insertBefore(node,ref.nextSibling,_156);
}
return true;
};
dojo.dom.insertAtPosition=function(node,ref,_15a){
if((!node)||(!ref)||(!_15a)){
return false;
}
switch(_15a.toLowerCase()){
case "before":
return dojo.dom.insertBefore(node,ref);
case "after":
return dojo.dom.insertAfter(node,ref);
case "first":
if(ref.firstChild){
return dojo.dom.insertBefore(node,ref.firstChild);
}else{
ref.appendChild(node);
return true;
}
break;
default:
ref.appendChild(node);
return true;
}
};
dojo.dom.insertAtIndex=function(node,_15c,_15d){
var _15e=_15c.childNodes;
if(!_15e.length||_15e.length==_15d){
_15c.appendChild(node);
return true;
}
if(_15d==0){
return dojo.dom.prependChild(node,_15c);
}
return dojo.dom.insertAfter(node,_15e[_15d-1]);
};
dojo.dom.textContent=function(node,text){
if(arguments.length>1){
var _161=dojo.doc();
dojo.dom.replaceChildren(node,_161.createTextNode(text));
return text;
}else{
if(node.textContent!=undefined){
return node.textContent;
}
var _162="";
if(node==null){
return _162;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
_162+=dojo.dom.textContent(node.childNodes[i]);
break;
case 3:
case 2:
case 4:
_162+=node.childNodes[i].nodeValue;
break;
default:
break;
}
}
return _162;
}
};
dojo.dom.hasParent=function(node){
return Boolean(node&&node.parentNode&&dojo.dom.isNode(node.parentNode));
};
dojo.dom.isTag=function(node){
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName==String(arguments[i])){
return String(arguments[i]);
}
}
}
return "";
};
dojo.dom.setAttributeNS=function(elem,_168,_169,_16a){
if(elem==null||((elem==undefined)&&(typeof elem=="undefined"))){
dojo.raise("No element given to dojo.dom.setAttributeNS");
}
if(!((elem.setAttributeNS==undefined)&&(typeof elem.setAttributeNS=="undefined"))){
elem.setAttributeNS(_168,_169,_16a);
}else{
var _16b=elem.ownerDocument;
var _16c=_16b.createNode(2,_169,_168);
_16c.nodeValue=_16a;
elem.setAttributeNode(_16c);
}
};
dojo.provide("dojo.html.common");
dojo.lang.mixin(dojo.html,dojo.dom);
dojo.html.body=function(){
dojo.deprecated("dojo.html.body() moved to dojo.body()","0.5");
return dojo.body();
};
dojo.html.getEventTarget=function(evt){
if(!evt){
evt=dojo.global().event||{};
}
var t=(evt.srcElement?evt.srcElement:(evt.target?evt.target:null));
while((t)&&(t.nodeType!=1)){
t=t.parentNode;
}
return t;
};
dojo.html.getViewport=function(){
var _16f=dojo.global();
var _170=dojo.doc();
var w=0;
var h=0;
if(dojo.render.html.mozilla){
w=_170.documentElement.clientWidth;
h=_16f.innerHeight;
}else{
if(!dojo.render.html.opera&&_16f.innerWidth){
w=_16f.innerWidth;
h=_16f.innerHeight;
}else{
if(!dojo.render.html.opera&&dojo.exists(_170,"documentElement.clientWidth")){
var w2=_170.documentElement.clientWidth;
if(!w||w2&&w2<w){
w=w2;
}
h=_170.documentElement.clientHeight;
}else{
if(dojo.body().clientWidth){
w=dojo.body().clientWidth;
h=dojo.body().clientHeight;
}
}
}
}
return {width:w,height:h};
};
dojo.html.getScroll=function(){
var _174=dojo.global();
var _175=dojo.doc();
var top=_174.pageYOffset||_175.documentElement.scrollTop||dojo.body().scrollTop||0;
var left=_174.pageXOffset||_175.documentElement.scrollLeft||dojo.body().scrollLeft||0;
return {top:top,left:left,offset:{x:left,y:top}};
};
dojo.html.getParentByType=function(node,type){
var _17a=dojo.doc();
var _17b=dojo.byId(node);
type=type.toLowerCase();
while((_17b)&&(_17b.nodeName.toLowerCase()!=type)){
if(_17b==(_17a["body"]||_17a["documentElement"])){
return null;
}
_17b=_17b.parentNode;
}
return _17b;
};
dojo.html.getAttribute=function(node,attr){
node=dojo.byId(node);
if((!node)||(!node.getAttribute)){
return null;
}
var ta=typeof attr=="string"?attr:new String(attr);
var v=node.getAttribute(ta.toUpperCase());
if((v)&&(typeof v=="string")&&(v!="")){
return v;
}
if(v&&v.value){
return v.value;
}
if((node.getAttributeNode)&&(node.getAttributeNode(ta))){
return (node.getAttributeNode(ta)).value;
}else{
if(node.getAttribute(ta)){
return node.getAttribute(ta);
}else{
if(node.getAttribute(ta.toLowerCase())){
return node.getAttribute(ta.toLowerCase());
}
}
}
return null;
};
dojo.html.hasAttribute=function(node,attr){
return dojo.html.getAttribute(dojo.byId(node),attr)?true:false;
};
dojo.html.getCursorPosition=function(e){
e=e||dojo.global().event;
var _183={x:0,y:0};
if(e.pageX||e.pageY){
_183.x=e.pageX;
_183.y=e.pageY;
}else{
var de=dojo.doc().documentElement;
var db=dojo.body();
_183.x=e.clientX+((de||db)["scrollLeft"])-((de||db)["clientLeft"]);
_183.y=e.clientY+((de||db)["scrollTop"])-((de||db)["clientTop"]);
}
return _183;
};
dojo.html.isTag=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
for(var i=1;i<arguments.length;i++){
if(node.tagName.toLowerCase()==String(arguments[i]).toLowerCase()){
return String(arguments[i]).toLowerCase();
}
}
}
return "";
};
if(dojo.render.html.ie&&!dojo.render.html.ie70){
if(window.location.href.substr(0,6).toLowerCase()!="https:"){
(function(){
var _188=dojo.doc().createElement("script");
_188.src="javascript:'dojo.html.createExternalElement=function(doc, tag){ return doc.createElement(tag); }'";
dojo.doc().getElementsByTagName("head")[0].appendChild(_188);
})();
}
}else{
dojo.html.createExternalElement=function(doc,tag){
return doc.createElement(tag);
};
}
dojo.html._callDeprecated=function(_18b,_18c,args,_18e,_18f){
dojo.deprecated("dojo.html."+_18b,"replaced by dojo.html."+_18c+"("+(_18e?"node, {"+_18e+": "+_18e+"}":"")+")"+(_18f?"."+_18f:""),"0.5");
var _190=[];
if(_18e){
var _191={};
_191[_18e]=args[1];
_190.push(args[0]);
_190.push(_191);
}else{
_190=args;
}
var ret=dojo.html[_18c].apply(dojo.html,args);
if(_18f){
return ret[_18f];
}else{
return ret;
}
};
dojo.html.getViewportWidth=function(){
return dojo.html._callDeprecated("getViewportWidth","getViewport",arguments,null,"width");
};
dojo.html.getViewportHeight=function(){
return dojo.html._callDeprecated("getViewportHeight","getViewport",arguments,null,"height");
};
dojo.html.getViewportSize=function(){
return dojo.html._callDeprecated("getViewportSize","getViewport",arguments);
};
dojo.html.getScrollTop=function(){
return dojo.html._callDeprecated("getScrollTop","getScroll",arguments,null,"top");
};
dojo.html.getScrollLeft=function(){
return dojo.html._callDeprecated("getScrollLeft","getScroll",arguments,null,"left");
};
dojo.html.getScrollOffset=function(){
return dojo.html._callDeprecated("getScrollOffset","getScroll",arguments,null,"offset");
};
dojo.provide("dojo.uri.Uri");
dojo.uri=new function(){
this.dojoUri=function(uri){
return new dojo.uri.Uri(dojo.hostenv.getBaseScriptUri(),uri);
};
this.moduleUri=function(_194,uri){
var loc=dojo.hostenv.getModuleSymbols(_194).join("/");
if(!loc){
return null;
}
if(loc.lastIndexOf("/")!=loc.length-1){
loc+="/";
}
var _197=loc.indexOf(":");
var _198=loc.indexOf("/");
if(loc.charAt(0)!="/"&&(_197==-1||_197>_198)){
loc=dojo.hostenv.getBaseScriptUri()+loc;
}
return new dojo.uri.Uri(loc,uri);
};
this.Uri=function(){
var uri=arguments[0];
for(var i=1;i<arguments.length;i++){
if(!arguments[i]){
continue;
}
var _19b=new dojo.uri.Uri(arguments[i].toString());
var _19c=new dojo.uri.Uri(uri.toString());
if((_19b.path=="")&&(_19b.scheme==null)&&(_19b.authority==null)&&(_19b.query==null)){
if(_19b.fragment!=null){
_19c.fragment=_19b.fragment;
}
_19b=_19c;
}else{
if(_19b.scheme==null){
_19b.scheme=_19c.scheme;
if(_19b.authority==null){
_19b.authority=_19c.authority;
if(_19b.path.charAt(0)!="/"){
var path=_19c.path.substring(0,_19c.path.lastIndexOf("/")+1)+_19b.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==segs.length-1){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_19b.path=segs.join("/");
}
}
}
}
uri="";
if(_19b.scheme!=null){
uri+=_19b.scheme+":";
}
if(_19b.authority!=null){
uri+="//"+_19b.authority;
}
uri+=_19b.path;
if(_19b.query!=null){
uri+="?"+_19b.query;
}
if(_19b.fragment!=null){
uri+="#"+_19b.fragment;
}
}
this.uri=uri.toString();
var _1a0="^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$";
var r=this.uri.match(new RegExp(_1a0));
this.scheme=r[2]||(r[1]?"":null);
this.authority=r[4]||(r[3]?"":null);
this.path=r[5];
this.query=r[7]||(r[6]?"":null);
this.fragment=r[9]||(r[8]?"":null);
if(this.authority!=null){
_1a0="^((([^:]+:)?([^@]+))@)?([^:]*)(:([0-9]+))?$";
r=this.authority.match(new RegExp(_1a0));
this.user=r[3]||null;
this.password=r[4]||null;
this.host=r[5];
this.port=r[7]||null;
}
this.toString=function(){
return this.uri;
};
};
};
dojo.provide("dojo.html.style");
dojo.html.getClass=function(node){
node=dojo.byId(node);
if(!node){
return "";
}
var cs="";
if(node.className){
cs=node.className;
}else{
if(dojo.html.hasAttribute(node,"class")){
cs=dojo.html.getAttribute(node,"class");
}
}
return cs.replace(/^\s+|\s+$/g,"");
};
dojo.html.getClasses=function(node){
var c=dojo.html.getClass(node);
return (c=="")?[]:c.split(/\s+/g);
};
dojo.html.hasClass=function(node,_1a7){
return (new RegExp("(^|\\s+)"+_1a7+"(\\s+|$)")).test(dojo.html.getClass(node));
};
dojo.html.prependClass=function(node,_1a9){
_1a9+=" "+dojo.html.getClass(node);
return dojo.html.setClass(node,_1a9);
};
dojo.html.addClass=function(node,_1ab){
if(dojo.html.hasClass(node,_1ab)){
return false;
}
_1ab=(dojo.html.getClass(node)+" "+_1ab).replace(/^\s+|\s+$/g,"");
return dojo.html.setClass(node,_1ab);
};
dojo.html.setClass=function(node,_1ad){
node=dojo.byId(node);
var cs=new String(_1ad);
try{
if(typeof node.className=="string"){
node.className=cs;
}else{
if(node.setAttribute){
node.setAttribute("class",_1ad);
node.className=cs;
}else{
return false;
}
}
}
catch(e){
dojo.debug("dojo.html.setClass() failed",e);
}
return true;
};
dojo.html.removeClass=function(node,_1b0,_1b1){
try{
if(!_1b1){
var _1b2=dojo.html.getClass(node).replace(new RegExp("(^|\\s+)"+_1b0+"(\\s+|$)"),"$1$2");
}else{
var _1b2=dojo.html.getClass(node).replace(_1b0,"");
}
dojo.html.setClass(node,_1b2);
}
catch(e){
dojo.debug("dojo.html.removeClass() failed",e);
}
return true;
};
dojo.html.replaceClass=function(node,_1b4,_1b5){
dojo.html.removeClass(node,_1b5);
dojo.html.addClass(node,_1b4);
};
dojo.html.classMatchType={ContainsAll:0,ContainsAny:1,IsOnly:2};
dojo.html.getElementsByClass=function(_1b6,_1b7,_1b8,_1b9,_1ba){
_1ba=false;
var _1bb=dojo.doc();
_1b7=dojo.byId(_1b7)||_1bb;
var _1bc=_1b6.split(/\s+/g);
var _1bd=[];
if(_1b9!=1&&_1b9!=2){
_1b9=0;
}
var _1be=new RegExp("(\\s|^)(("+_1bc.join(")|(")+"))(\\s|$)");
var _1bf=_1bc.join(" ").length;
var _1c0=[];
if(!_1ba&&_1bb.evaluate){
var _1c1=".//"+(_1b8||"*")+"[contains(";
if(_1b9!=dojo.html.classMatchType.ContainsAny){
_1c1+="concat(' ',@class,' '), ' "+_1bc.join(" ') and contains(concat(' ',@class,' '), ' ")+" ')";
if(_1b9==2){
_1c1+=" and string-length(@class)="+_1bf+"]";
}else{
_1c1+="]";
}
}else{
_1c1+="concat(' ',@class,' '), ' "+_1bc.join(" ') or contains(concat(' ',@class,' '), ' ")+" ')]";
}
var _1c2=_1bb.evaluate(_1c1,_1b7,null,XPathResult.ANY_TYPE,null);
var _1c3=_1c2.iterateNext();
while(_1c3){
try{
_1c0.push(_1c3);
_1c3=_1c2.iterateNext();
}
catch(e){
break;
}
}
return _1c0;
}else{
if(!_1b8){
_1b8="*";
}
_1c0=_1b7.getElementsByTagName(_1b8);
var node,i=0;
outer:
while(node=_1c0[i++]){
var _1c6=dojo.html.getClasses(node);
if(_1c6.length==0){
continue outer;
}
var _1c7=0;
for(var j=0;j<_1c6.length;j++){
if(_1be.test(_1c6[j])){
if(_1b9==dojo.html.classMatchType.ContainsAny){
_1bd.push(node);
continue outer;
}else{
_1c7++;
}
}else{
if(_1b9==dojo.html.classMatchType.IsOnly){
continue outer;
}
}
}
if(_1c7==_1bc.length){
if((_1b9==dojo.html.classMatchType.IsOnly)&&(_1c7==_1c6.length)){
_1bd.push(node);
}else{
if(_1b9==dojo.html.classMatchType.ContainsAll){
_1bd.push(node);
}
}
}
}
return _1bd;
}
};
dojo.html.getElementsByClassName=dojo.html.getElementsByClass;
dojo.html.toCamelCase=function(_1c9){
var arr=_1c9.split("-"),cc=arr[0];
for(var i=1;i<arr.length;i++){
cc+=arr[i].charAt(0).toUpperCase()+arr[i].substring(1);
}
return cc;
};
dojo.html.toSelectorCase=function(_1cd){
return _1cd.replace(/([A-Z])/g,"-$1").toLowerCase();
};
if(dojo.render.html.ie){
dojo.html.getComputedStyle=function(node,_1cf,_1d0){
node=dojo.byId(node);
if(!node||!node.currentStyle){
return _1d0;
}
return node.currentStyle[dojo.html.toCamelCase(_1cf)];
};
dojo.html.getComputedStyles=function(node){
return node.currentStyle;
};
}else{
dojo.html.getComputedStyle=function(node,_1d3,_1d4){
node=dojo.byId(node);
if(!node||!node.style){
return _1d4;
}
var s=document.defaultView.getComputedStyle(node,null);
return (s&&s[dojo.html.toCamelCase(_1d3)])||"";
};
dojo.html.getComputedStyles=function(node){
return document.defaultView.getComputedStyle(node,null);
};
}
dojo.html.getStyleProperty=function(node,_1d8){
node=dojo.byId(node);
return (node&&node.style?node.style[dojo.html.toCamelCase(_1d8)]:undefined);
};
dojo.html.getStyle=function(node,_1da){
var _1db=dojo.html.getStyleProperty(node,_1da);
return (_1db?_1db:dojo.html.getComputedStyle(node,_1da));
};
dojo.html.setStyle=function(node,_1dd,_1de){
node=dojo.byId(node);
if(node&&node.style){
var _1df=dojo.html.toCamelCase(_1dd);
node.style[_1df]=_1de;
}
};
dojo.html.setStyleText=function(_1e0,text){
try{
_1e0.style.cssText=text;
}
catch(e){
_1e0.setAttribute("style",text);
}
};
dojo.html.copyStyle=function(_1e2,_1e3){
if(!_1e3.style.cssText){
_1e2.setAttribute("style",_1e3.getAttribute("style"));
}else{
_1e2.style.cssText=_1e3.style.cssText;
}
dojo.html.addClass(_1e2,dojo.html.getClass(_1e3));
};
dojo.html.getUnitValue=function(node,_1e5,_1e6){
var s=dojo.html.getComputedStyle(node,_1e5);
if((!s)||((s=="auto")&&(_1e6))){
return {value:0,units:"px"};
}
var _1e8=s.match(/(\-?[\d.]+)([a-z%]*)/i);
if(!_1e8){
return dojo.html.getUnitValue.bad;
}
return {value:Number(_1e8[1]),units:_1e8[2].toLowerCase()};
};
dojo.html.getUnitValue.bad={value:NaN,units:""};
if(dojo.render.html.ie){
dojo.html.toPixelValue=function(_1e9,_1ea){
if(!_1ea){
return 0;
}
if(_1ea.slice(-2)=="px"){
return parseFloat(_1ea);
}
var _1eb=0;
with(_1e9){
var _1ec=style.left;
var _1ed=runtimeStyle.left;
runtimeStyle.left=currentStyle.left;
try{
style.left=_1ea||0;
_1eb=style.pixelLeft;
style.left=_1ec;
runtimeStyle.left=_1ed;
}
catch(e){
}
}
return _1eb;
};
}else{
dojo.html.toPixelValue=function(_1ee,_1ef){
return (_1ef&&(_1ef.slice(-2)=="px")?parseFloat(_1ef):0);
};
}
dojo.html.getPixelValue=function(node,_1f1,_1f2){
return dojo.html.toPixelValue(node,dojo.html.getComputedStyle(node,_1f1));
};
dojo.html.setPositivePixelValue=function(node,_1f4,_1f5){
if(isNaN(_1f5)){
return false;
}
node.style[_1f4]=Math.max(0,_1f5)+"px";
return true;
};
dojo.html.styleSheet=null;
dojo.html.insertCssRule=function(_1f6,_1f7,_1f8){
if(!dojo.html.styleSheet){
if(document.createStyleSheet){
dojo.html.styleSheet=document.createStyleSheet();
}else{
if(document.styleSheets[0]){
dojo.html.styleSheet=document.styleSheets[0];
}else{
return null;
}
}
}
if(arguments.length<3){
if(dojo.html.styleSheet.cssRules){
_1f8=dojo.html.styleSheet.cssRules.length;
}else{
if(dojo.html.styleSheet.rules){
_1f8=dojo.html.styleSheet.rules.length;
}else{
return null;
}
}
}
if(dojo.html.styleSheet.insertRule){
var rule=_1f6+" { "+_1f7+" }";
return dojo.html.styleSheet.insertRule(rule,_1f8);
}else{
if(dojo.html.styleSheet.addRule){
return dojo.html.styleSheet.addRule(_1f6,_1f7,_1f8);
}else{
return null;
}
}
};
dojo.html.removeCssRule=function(_1fa){
if(!dojo.html.styleSheet){
dojo.debug("no stylesheet defined for removing rules");
return false;
}
if(dojo.render.html.ie){
if(!_1fa){
_1fa=dojo.html.styleSheet.rules.length;
dojo.html.styleSheet.removeRule(_1fa);
}
}else{
if(document.styleSheets[0]){
if(!_1fa){
_1fa=dojo.html.styleSheet.cssRules.length;
}
dojo.html.styleSheet.deleteRule(_1fa);
}
}
return true;
};
dojo.html._insertedCssFiles=[];
dojo.html.insertCssFile=function(URI,doc,_1fd,_1fe){
if(!URI){
return;
}
if(!doc){
doc=document;
}
var _1ff=dojo.hostenv.getText(URI,false,_1fe);
if(_1ff===null){
return;
}
_1ff=dojo.html.fixPathsInCssText(_1ff,URI);
if(_1fd){
var idx=-1,node,ent=dojo.html._insertedCssFiles;
for(var i=0;i<ent.length;i++){
if((ent[i].doc==doc)&&(ent[i].cssText==_1ff)){
idx=i;
node=ent[i].nodeRef;
break;
}
}
if(node){
var _204=doc.getElementsByTagName("style");
for(var i=0;i<_204.length;i++){
if(_204[i]==node){
return;
}
}
dojo.html._insertedCssFiles.shift(idx,1);
}
}
var _205=dojo.html.insertCssText(_1ff,doc);
dojo.html._insertedCssFiles.push({"doc":doc,"cssText":_1ff,"nodeRef":_205});
if(_205&&djConfig.isDebug){
_205.setAttribute("dbgHref",URI);
}
return _205;
};
dojo.html.insertCssText=function(_206,doc,URI){
if(!_206){
return;
}
if(!doc){
doc=document;
}
if(URI){
_206=dojo.html.fixPathsInCssText(_206,URI);
}
var _209=doc.createElement("style");
_209.setAttribute("type","text/css");
var head=doc.getElementsByTagName("head")[0];
if(!head){
dojo.debug("No head tag in document, aborting styles");
return;
}else{
head.appendChild(_209);
}
if(_209.styleSheet){
var _20b=function(){
try{
_209.styleSheet.cssText=_206;
}
catch(e){
dojo.debug(e);
}
};
if(_209.styleSheet.disabled){
setTimeout(_20b,10);
}else{
_20b();
}
}else{
var _20c=doc.createTextNode(_206);
_209.appendChild(_20c);
}
return _209;
};
dojo.html.fixPathsInCssText=function(_20d,URI){
if(!_20d||!URI){
return;
}
var _20f,str="",url="",_212="[\\t\\s\\w\\(\\)\\/\\.\\\\'\"-:#=&?~]+";
var _213=new RegExp("url\\(\\s*("+_212+")\\s*\\)");
var _214=/(file|https?|ftps?):\/\//;
regexTrim=new RegExp("^[\\s]*(['\"]?)("+_212+")\\1[\\s]*?$");
if(dojo.render.html.ie55||dojo.render.html.ie60){
var _215=new RegExp("AlphaImageLoader\\((.*)src=['\"]("+_212+")['\"]");
while(_20f=_215.exec(_20d)){
url=_20f[2].replace(regexTrim,"$2");
if(!_214.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_20d.substring(0,_20f.index)+"AlphaImageLoader("+_20f[1]+"src='"+url+"'";
_20d=_20d.substr(_20f.index+_20f[0].length);
}
_20d=str+_20d;
str="";
}
while(_20f=_213.exec(_20d)){
url=_20f[1].replace(regexTrim,"$2");
if(!_214.exec(url)){
url=(new dojo.uri.Uri(URI,url).toString());
}
str+=_20d.substring(0,_20f.index)+"url("+url+")";
_20d=_20d.substr(_20f.index+_20f[0].length);
}
return str+_20d;
};
dojo.html.setActiveStyleSheet=function(_216){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")){
a.disabled=true;
if(a.getAttribute("title")==_216){
a.disabled=false;
}
}
}
};
dojo.html.getActiveStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("title")&&!a.disabled){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.getPreferredStyleSheet=function(){
var i=0,a,els=dojo.doc().getElementsByTagName("link");
while(a=els[i++]){
if(a.getAttribute("rel").indexOf("style")!=-1&&a.getAttribute("rel").indexOf("alt")==-1&&a.getAttribute("title")){
return a.getAttribute("title");
}
}
return null;
};
dojo.html.applyBrowserClass=function(node){
var drh=dojo.render.html;
var _222={dj_ie:drh.ie,dj_ie55:drh.ie55,dj_ie6:drh.ie60,dj_ie7:drh.ie70,dj_iequirks:drh.ie&&drh.quirks,dj_opera:drh.opera,dj_opera8:drh.opera&&(Math.floor(dojo.render.version)==8),dj_opera9:drh.opera&&(Math.floor(dojo.render.version)==9),dj_khtml:drh.khtml,dj_safari:drh.safari,dj_gecko:drh.mozilla};
for(var p in _222){
if(_222[p]){
dojo.html.addClass(node,p);
}
}
};
dojo.kwCompoundRequire({common:["dojo.html.common","dojo.html.style"]});
dojo.provide("dojo.html.*");
dojo.provide("dojo.html.display");
dojo.html._toggle=function(node,_225,_226){
node=dojo.byId(node);
_226(node,!_225(node));
return _225(node);
};
dojo.html.show=function(node){
node=dojo.byId(node);
if(dojo.html.getStyleProperty(node,"display")=="none"){
dojo.html.setStyle(node,"display",(node.dojoDisplayCache||""));
node.dojoDisplayCache=undefined;
}
};
dojo.html.hide=function(node){
node=dojo.byId(node);
if(typeof node["dojoDisplayCache"]=="undefined"){
var d=dojo.html.getStyleProperty(node,"display");
if(d!="none"){
node.dojoDisplayCache=d;
}
}
dojo.html.setStyle(node,"display","none");
};
dojo.html.setShowing=function(node,_22b){
dojo.html[(_22b?"show":"hide")](node);
};
dojo.html.isShowing=function(node){
return (dojo.html.getStyleProperty(node,"display")!="none");
};
dojo.html.toggleShowing=function(node){
return dojo.html._toggle(node,dojo.html.isShowing,dojo.html.setShowing);
};
dojo.html.displayMap={tr:"",td:"",th:"",img:"inline",span:"inline",input:"inline",button:"inline"};
dojo.html.suggestDisplayByTagName=function(node){
node=dojo.byId(node);
if(node&&node.tagName){
var tag=node.tagName.toLowerCase();
return (tag in dojo.html.displayMap?dojo.html.displayMap[tag]:"block");
}
};
dojo.html.setDisplay=function(node,_231){
dojo.html.setStyle(node,"display",((_231 instanceof String||typeof _231=="string")?_231:(_231?dojo.html.suggestDisplayByTagName(node):"none")));
};
dojo.html.isDisplayed=function(node){
return (dojo.html.getComputedStyle(node,"display")!="none");
};
dojo.html.toggleDisplay=function(node){
return dojo.html._toggle(node,dojo.html.isDisplayed,dojo.html.setDisplay);
};
dojo.html.setVisibility=function(node,_235){
dojo.html.setStyle(node,"visibility",((_235 instanceof String||typeof _235=="string")?_235:(_235?"visible":"hidden")));
};
dojo.html.isVisible=function(node){
return (dojo.html.getComputedStyle(node,"visibility")!="hidden");
};
dojo.html.toggleVisibility=function(node){
return dojo.html._toggle(node,dojo.html.isVisible,dojo.html.setVisibility);
};
dojo.html.setOpacity=function(node,_239,_23a){
node=dojo.byId(node);
var h=dojo.render.html;
if(!_23a){
if(_239>=1){
if(h.ie){
dojo.html.clearOpacity(node);
return;
}else{
_239=0.999999;
}
}else{
if(_239<0){
_239=0;
}
}
}
if(h.ie){
if(node.nodeName.toLowerCase()=="tr"){
var tds=node.getElementsByTagName("td");
for(var x=0;x<tds.length;x++){
tds[x].style.filter="Alpha(Opacity="+_239*100+")";
}
}
node.style.filter="Alpha(Opacity="+_239*100+")";
}else{
if(h.moz){
node.style.opacity=_239;
node.style.MozOpacity=_239;
}else{
if(h.safari){
node.style.opacity=_239;
node.style.KhtmlOpacity=_239;
}else{
node.style.opacity=_239;
}
}
}
};
dojo.html.clearOpacity=function(node){
node=dojo.byId(node);
var ns=node.style;
var h=dojo.render.html;
if(h.ie){
try{
if(node.filters&&node.filters.alpha){
ns.filter="";
}
}
catch(e){
}
}else{
if(h.moz){
ns.opacity=1;
ns.MozOpacity=1;
}else{
if(h.safari){
ns.opacity=1;
ns.KhtmlOpacity=1;
}else{
ns.opacity=1;
}
}
}
};
dojo.html.getOpacity=function(node){
node=dojo.byId(node);
var h=dojo.render.html;
if(h.ie){
var opac=(node.filters&&node.filters.alpha&&typeof node.filters.alpha.opacity=="number"?node.filters.alpha.opacity:100)/100;
}else{
var opac=node.style.opacity||node.style.MozOpacity||node.style.KhtmlOpacity||1;
}
return opac>=0.999999?1:Number(opac);
};
dojo.provide("dojo.html.layout");
dojo.html.sumAncestorProperties=function(node,prop){
node=dojo.byId(node);
if(!node){
return 0;
}
var _246=0;
while(node){
if(dojo.html.getComputedStyle(node,"position")=="fixed"){
return 0;
}
var val=node[prop];
if(val){
_246+=val-0;
if(node==dojo.body()){
break;
}
}
node=node.parentNode;
}
return _246;
};
dojo.html.setStyleAttributes=function(node,_249){
node=dojo.byId(node);
var _24a=_249.replace(/(;)?\s*$/,"").split(";");
for(var i=0;i<_24a.length;i++){
var _24c=_24a[i].split(":");
var name=_24c[0].replace(/\s*$/,"").replace(/^\s*/,"").toLowerCase();
var _24e=_24c[1].replace(/\s*$/,"").replace(/^\s*/,"");
switch(name){
case "opacity":
dojo.html.setOpacity(node,_24e);
break;
case "content-height":
dojo.html.setContentBox(node,{height:_24e});
break;
case "content-width":
dojo.html.setContentBox(node,{width:_24e});
break;
case "outer-height":
dojo.html.setMarginBox(node,{height:_24e});
break;
case "outer-width":
dojo.html.setMarginBox(node,{width:_24e});
break;
default:
node.style[dojo.html.toCamelCase(name)]=_24e;
}
}
};
dojo.html.boxSizing={MARGIN_BOX:"margin-box",BORDER_BOX:"border-box",PADDING_BOX:"padding-box",CONTENT_BOX:"content-box"};
dojo.html.getAbsolutePosition=dojo.html.abs=function(node,_250,_251){
node=dojo.byId(node,node.ownerDocument);
var ret={x:0,y:0};
var bs=dojo.html.boxSizing;
if(!_251){
_251=bs.CONTENT_BOX;
}
var _254=2;
var _255;
switch(_251){
case bs.MARGIN_BOX:
_255=3;
break;
case bs.BORDER_BOX:
_255=2;
break;
case bs.PADDING_BOX:
default:
_255=1;
break;
case bs.CONTENT_BOX:
_255=0;
break;
}
var h=dojo.render.html;
var db=document["body"]||document["documentElement"];
if(h.ie){
with(node.getBoundingClientRect()){
ret.x=left-2;
ret.y=top-2;
}
}else{
if(document.getBoxObjectFor){
_254=1;
try{
var bo=document.getBoxObjectFor(node);
ret.x=bo.x-dojo.html.sumAncestorProperties(node,"scrollLeft");
ret.y=bo.y-dojo.html.sumAncestorProperties(node,"scrollTop");
}
catch(e){
}
}else{
if(node["offsetParent"]){
var _259;
if((h.safari)&&(node.style.getPropertyValue("position")=="absolute")&&(node.parentNode==db)){
_259=db;
}else{
_259=db.parentNode;
}
if(node.parentNode!=db){
var nd=node;
if(dojo.render.html.opera){
nd=db;
}
ret.x-=dojo.html.sumAncestorProperties(nd,"scrollLeft");
ret.y-=dojo.html.sumAncestorProperties(nd,"scrollTop");
}
var _25b=node;
do{
var n=_25b["offsetLeft"];
if(!h.opera||n>0){
ret.x+=isNaN(n)?0:n;
}
var m=_25b["offsetTop"];
ret.y+=isNaN(m)?0:m;
_25b=_25b.offsetParent;
}while((_25b!=_259)&&(_25b!=null));
}else{
if(node["x"]&&node["y"]){
ret.x+=isNaN(node.x)?0:node.x;
ret.y+=isNaN(node.y)?0:node.y;
}
}
}
}
if(_250){
var _25e=dojo.html.getScroll();
ret.y+=_25e.top;
ret.x+=_25e.left;
}
var _25f=[dojo.html.getPaddingExtent,dojo.html.getBorderExtent,dojo.html.getMarginExtent];
if(_254>_255){
for(var i=_255;i<_254;++i){
ret.y+=_25f[i](node,"top");
ret.x+=_25f[i](node,"left");
}
}else{
if(_254<_255){
for(var i=_255;i>_254;--i){
ret.y-=_25f[i-1](node,"top");
ret.x-=_25f[i-1](node,"left");
}
}
}
ret.top=ret.y;
ret.left=ret.x;
return ret;
};
dojo.html.isPositionAbsolute=function(node){
return (dojo.html.getComputedStyle(node,"position")=="absolute");
};
dojo.html._sumPixelValues=function(node,_263,_264){
var _265=0;
for(var x=0;x<_263.length;x++){
_265+=dojo.html.getPixelValue(node,_263[x],_264);
}
return _265;
};
dojo.html.getMargin=function(node){
return {width:dojo.html._sumPixelValues(node,["margin-left","margin-right"],(dojo.html.getComputedStyle(node,"position")=="absolute")),height:dojo.html._sumPixelValues(node,["margin-top","margin-bottom"],(dojo.html.getComputedStyle(node,"position")=="absolute"))};
};
dojo.html.getBorder=function(node){
return {width:dojo.html.getBorderExtent(node,"left")+dojo.html.getBorderExtent(node,"right"),height:dojo.html.getBorderExtent(node,"top")+dojo.html.getBorderExtent(node,"bottom")};
};
dojo.html.getBorderExtent=function(node,side){
return (dojo.html.getStyle(node,"border-"+side+"-style")=="none"?0:dojo.html.getPixelValue(node,"border-"+side+"-width"));
};
dojo.html.getMarginExtent=function(node,side){
return dojo.html._sumPixelValues(node,["margin-"+side],dojo.html.isPositionAbsolute(node));
};
dojo.html.getPaddingExtent=function(node,side){
return dojo.html._sumPixelValues(node,["padding-"+side],true);
};
dojo.html.getPadding=function(node){
return {width:dojo.html._sumPixelValues(node,["padding-left","padding-right"],true),height:dojo.html._sumPixelValues(node,["padding-top","padding-bottom"],true)};
};
dojo.html.getPadBorder=function(node){
var pad=dojo.html.getPadding(node);
var _272=dojo.html.getBorder(node);
return {width:pad.width+_272.width,height:pad.height+_272.height};
};
dojo.html.getBoxSizing=function(node){
var h=dojo.render.html;
var bs=dojo.html.boxSizing;
if(((h.ie)||(h.opera))&&node.nodeName.toLowerCase()!="img"){
var cm=document["compatMode"];
if((cm=="BackCompat")||(cm=="QuirksMode")){
return bs.BORDER_BOX;
}else{
return bs.CONTENT_BOX;
}
}else{
if(arguments.length==0){
node=document.documentElement;
}
var _277;
if(!h.ie){
_277=dojo.html.getStyle(node,"-moz-box-sizing");
if(!_277){
_277=dojo.html.getStyle(node,"box-sizing");
}
}
return (_277?_277:bs.CONTENT_BOX);
}
};
dojo.html.isBorderBox=function(node){
return (dojo.html.getBoxSizing(node)==dojo.html.boxSizing.BORDER_BOX);
};
dojo.html.getBorderBox=function(node){
node=dojo.byId(node);
return {width:node.offsetWidth,height:node.offsetHeight};
};
dojo.html.getPaddingBox=function(node){
var box=dojo.html.getBorderBox(node);
var _27c=dojo.html.getBorder(node);
return {width:box.width-_27c.width,height:box.height-_27c.height};
};
dojo.html.getContentBox=function(node){
node=dojo.byId(node);
var _27e=dojo.html.getPadBorder(node);
return {width:node.offsetWidth-_27e.width,height:node.offsetHeight-_27e.height};
};
dojo.html.setContentBox=function(node,args){
node=dojo.byId(node);
var _281=0;
var _282=0;
var isbb=dojo.html.isBorderBox(node);
var _284=(isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var ret={};
if(typeof args.width!="undefined"){
_281=args.width+_284.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_281);
}
if(typeof args.height!="undefined"){
_282=args.height+_284.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_282);
}
return ret;
};
dojo.html.getMarginBox=function(node){
var _287=dojo.html.getBorderBox(node);
var _288=dojo.html.getMargin(node);
return {width:_287.width+_288.width,height:_287.height+_288.height};
};
dojo.html.setMarginBox=function(node,args){
node=dojo.byId(node);
var _28b=0;
var _28c=0;
var isbb=dojo.html.isBorderBox(node);
var _28e=(!isbb?dojo.html.getPadBorder(node):{width:0,height:0});
var _28f=dojo.html.getMargin(node);
var ret={};
if(typeof args.width!="undefined"){
_28b=args.width-_28e.width;
_28b-=_28f.width;
ret.width=dojo.html.setPositivePixelValue(node,"width",_28b);
}
if(typeof args.height!="undefined"){
_28c=args.height-_28e.height;
_28c-=_28f.height;
ret.height=dojo.html.setPositivePixelValue(node,"height",_28c);
}
return ret;
};
dojo.html.getElementBox=function(node,type){
var bs=dojo.html.boxSizing;
switch(type){
case bs.MARGIN_BOX:
return dojo.html.getMarginBox(node);
case bs.BORDER_BOX:
return dojo.html.getBorderBox(node);
case bs.PADDING_BOX:
return dojo.html.getPaddingBox(node);
case bs.CONTENT_BOX:
default:
return dojo.html.getContentBox(node);
}
};
dojo.html.toCoordinateObject=dojo.html.toCoordinateArray=function(_294,_295,_296){
if(_294 instanceof Array||typeof _294=="array"){
dojo.deprecated("dojo.html.toCoordinateArray","use dojo.html.toCoordinateObject({left: , top: , width: , height: }) instead","0.5");
while(_294.length<4){
_294.push(0);
}
while(_294.length>4){
_294.pop();
}
var ret={left:_294[0],top:_294[1],width:_294[2],height:_294[3]};
}else{
if(!_294.nodeType&&!(_294 instanceof String||typeof _294=="string")&&("width" in _294||"height" in _294||"left" in _294||"x" in _294||"top" in _294||"y" in _294)){
var ret={left:_294.left||_294.x||0,top:_294.top||_294.y||0,width:_294.width||0,height:_294.height||0};
}else{
var node=dojo.byId(_294);
var pos=dojo.html.abs(node,_295,_296);
var _29a=dojo.html.getMarginBox(node);
var ret={left:pos.left,top:pos.top,width:_29a.width,height:_29a.height};
}
}
ret.x=ret.left;
ret.y=ret.top;
return ret;
};
dojo.html.setMarginBoxWidth=dojo.html.setOuterWidth=function(node,_29c){
return dojo.html._callDeprecated("setMarginBoxWidth","setMarginBox",arguments,"width");
};
dojo.html.setMarginBoxHeight=dojo.html.setOuterHeight=function(){
return dojo.html._callDeprecated("setMarginBoxHeight","setMarginBox",arguments,"height");
};
dojo.html.getMarginBoxWidth=dojo.html.getOuterWidth=function(){
return dojo.html._callDeprecated("getMarginBoxWidth","getMarginBox",arguments,null,"width");
};
dojo.html.getMarginBoxHeight=dojo.html.getOuterHeight=function(){
return dojo.html._callDeprecated("getMarginBoxHeight","getMarginBox",arguments,null,"height");
};
dojo.html.getTotalOffset=function(node,type,_29f){
return dojo.html._callDeprecated("getTotalOffset","getAbsolutePosition",arguments,null,type);
};
dojo.html.getAbsoluteX=function(node,_2a1){
return dojo.html._callDeprecated("getAbsoluteX","getAbsolutePosition",arguments,null,"x");
};
dojo.html.getAbsoluteY=function(node,_2a3){
return dojo.html._callDeprecated("getAbsoluteY","getAbsolutePosition",arguments,null,"y");
};
dojo.html.totalOffsetLeft=function(node,_2a5){
return dojo.html._callDeprecated("totalOffsetLeft","getAbsolutePosition",arguments,null,"left");
};
dojo.html.totalOffsetTop=function(node,_2a7){
return dojo.html._callDeprecated("totalOffsetTop","getAbsolutePosition",arguments,null,"top");
};
dojo.html.getMarginWidth=function(node){
return dojo.html._callDeprecated("getMarginWidth","getMargin",arguments,null,"width");
};
dojo.html.getMarginHeight=function(node){
return dojo.html._callDeprecated("getMarginHeight","getMargin",arguments,null,"height");
};
dojo.html.getBorderWidth=function(node){
return dojo.html._callDeprecated("getBorderWidth","getBorder",arguments,null,"width");
};
dojo.html.getBorderHeight=function(node){
return dojo.html._callDeprecated("getBorderHeight","getBorder",arguments,null,"height");
};
dojo.html.getPaddingWidth=function(node){
return dojo.html._callDeprecated("getPaddingWidth","getPadding",arguments,null,"width");
};
dojo.html.getPaddingHeight=function(node){
return dojo.html._callDeprecated("getPaddingHeight","getPadding",arguments,null,"height");
};
dojo.html.getPadBorderWidth=function(node){
return dojo.html._callDeprecated("getPadBorderWidth","getPadBorder",arguments,null,"width");
};
dojo.html.getPadBorderHeight=function(node){
return dojo.html._callDeprecated("getPadBorderHeight","getPadBorder",arguments,null,"height");
};
dojo.html.getBorderBoxWidth=dojo.html.getInnerWidth=function(){
return dojo.html._callDeprecated("getBorderBoxWidth","getBorderBox",arguments,null,"width");
};
dojo.html.getBorderBoxHeight=dojo.html.getInnerHeight=function(){
return dojo.html._callDeprecated("getBorderBoxHeight","getBorderBox",arguments,null,"height");
};
dojo.html.getContentBoxWidth=dojo.html.getContentWidth=function(){
return dojo.html._callDeprecated("getContentBoxWidth","getContentBox",arguments,null,"width");
};
dojo.html.getContentBoxHeight=dojo.html.getContentHeight=function(){
return dojo.html._callDeprecated("getContentBoxHeight","getContentBox",arguments,null,"height");
};
dojo.html.setContentBoxWidth=dojo.html.setContentWidth=function(node,_2b1){
return dojo.html._callDeprecated("setContentBoxWidth","setContentBox",arguments,"width");
};
dojo.html.setContentBoxHeight=dojo.html.setContentHeight=function(node,_2b3){
return dojo.html._callDeprecated("setContentBoxHeight","setContentBox",arguments,"height");
};
dojo.provide("dojo.html.util");
dojo.html.getElementWindow=function(_2b4){
return dojo.html.getDocumentWindow(_2b4.ownerDocument);
};
dojo.html.getDocumentWindow=function(doc){
if(dojo.render.html.safari&&!doc._parentWindow){
var fix=function(win){
win.document._parentWindow=win;
for(var i=0;i<win.frames.length;i++){
fix(win.frames[i]);
}
};
fix(window.top);
}
if(dojo.render.html.ie&&window!==document.parentWindow&&!doc._parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc._parentWindow||doc.parentWindow||doc.defaultView;
};
dojo.html.gravity=function(node,e){
node=dojo.byId(node);
var _2bc=dojo.html.getCursorPosition(e);
with(dojo.html){
var _2bd=getAbsolutePosition(node,true);
var bb=getBorderBox(node);
var _2bf=_2bd.x+(bb.width/2);
var _2c0=_2bd.y+(bb.height/2);
}
with(dojo.html.gravity){
return ((_2bc.x<_2bf?WEST:EAST)|(_2bc.y<_2c0?NORTH:SOUTH));
}
};
dojo.html.gravity.NORTH=1;
dojo.html.gravity.SOUTH=1<<1;
dojo.html.gravity.EAST=1<<2;
dojo.html.gravity.WEST=1<<3;
dojo.html.overElement=function(_2c1,e){
_2c1=dojo.byId(_2c1);
var _2c3=dojo.html.getCursorPosition(e);
var bb=dojo.html.getBorderBox(_2c1);
var _2c5=dojo.html.getAbsolutePosition(_2c1,true,dojo.html.boxSizing.BORDER_BOX);
var top=_2c5.y;
var _2c7=top+bb.height;
var left=_2c5.x;
var _2c9=left+bb.width;
return (_2c3.x>=left&&_2c3.x<=_2c9&&_2c3.y>=top&&_2c3.y<=_2c7);
};
dojo.html.renderedTextContent=function(node){
node=dojo.byId(node);
var _2cb="";
if(node==null){
return _2cb;
}
for(var i=0;i<node.childNodes.length;i++){
switch(node.childNodes[i].nodeType){
case 1:
case 5:
var _2cd="unknown";
try{
_2cd=dojo.html.getStyle(node.childNodes[i],"display");
}
catch(E){
}
switch(_2cd){
case "block":
case "list-item":
case "run-in":
case "table":
case "table-row-group":
case "table-header-group":
case "table-footer-group":
case "table-row":
case "table-column-group":
case "table-column":
case "table-cell":
case "table-caption":
_2cb+="\n";
_2cb+=dojo.html.renderedTextContent(node.childNodes[i]);
_2cb+="\n";
break;
case "none":
break;
default:
if(node.childNodes[i].tagName&&node.childNodes[i].tagName.toLowerCase()=="br"){
_2cb+="\n";
}else{
_2cb+=dojo.html.renderedTextContent(node.childNodes[i]);
}
break;
}
break;
case 3:
case 2:
case 4:
var text=node.childNodes[i].nodeValue;
var _2cf="unknown";
try{
_2cf=dojo.html.getStyle(node,"text-transform");
}
catch(E){
}
switch(_2cf){
case "capitalize":
var _2d0=text.split(" ");
for(var i=0;i<_2d0.length;i++){
_2d0[i]=_2d0[i].charAt(0).toUpperCase()+_2d0[i].substring(1);
}
text=_2d0.join(" ");
break;
case "uppercase":
text=text.toUpperCase();
break;
case "lowercase":
text=text.toLowerCase();
break;
default:
break;
}
switch(_2cf){
case "nowrap":
break;
case "pre-wrap":
break;
case "pre-line":
break;
case "pre":
break;
default:
text=text.replace(/\s+/," ");
if(/\s$/.test(_2cb)){
text.replace(/^\s/,"");
}
break;
}
_2cb+=text;
break;
default:
break;
}
}
return _2cb;
};
dojo.html.createNodesFromText=function(txt,trim){
if(trim){
txt=txt.replace(/^\s+|\s+$/g,"");
}
var tn=dojo.doc().createElement("div");
tn.style.visibility="hidden";
dojo.body().appendChild(tn);
var _2d4="none";
if((/^<t[dh][\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody><tr>"+txt+"</tr></tbody></table>";
_2d4="cell";
}else{
if((/^<tr[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table><tbody>"+txt+"</tbody></table>";
_2d4="row";
}else{
if((/^<(thead|tbody|tfoot)[\s\r\n>]/i).test(txt.replace(/^\s+/))){
txt="<table>"+txt+"</table>";
_2d4="section";
}
}
}
tn.innerHTML=txt;
if(tn["normalize"]){
tn.normalize();
}
var _2d5=null;
switch(_2d4){
case "cell":
_2d5=tn.getElementsByTagName("tr")[0];
break;
case "row":
_2d5=tn.getElementsByTagName("tbody")[0];
break;
case "section":
_2d5=tn.getElementsByTagName("table")[0];
break;
default:
_2d5=tn;
break;
}
var _2d6=[];
for(var x=0;x<_2d5.childNodes.length;x++){
_2d6.push(_2d5.childNodes[x].cloneNode(true));
}
tn.style.display="none";
dojo.html.destroyNode(tn);
return _2d6;
};
dojo.html.placeOnScreen=function(node,_2d9,_2da,_2db,_2dc,_2dd,_2de){
if(_2d9 instanceof Array||typeof _2d9=="array"){
_2de=_2dd;
_2dd=_2dc;
_2dc=_2db;
_2db=_2da;
_2da=_2d9[1];
_2d9=_2d9[0];
}
if(_2dd instanceof String||typeof _2dd=="string"){
_2dd=_2dd.split(",");
}
if(!isNaN(_2db)){
_2db=[Number(_2db),Number(_2db)];
}else{
if(!(_2db instanceof Array||typeof _2db=="array")){
_2db=[0,0];
}
}
var _2df=dojo.html.getScroll().offset;
var view=dojo.html.getViewport();
node=dojo.byId(node);
var _2e1=node.style.display;
node.style.display="";
var bb=dojo.html.getBorderBox(node);
var w=bb.width;
var h=bb.height;
node.style.display=_2e1;
if(!(_2dd instanceof Array||typeof _2dd=="array")){
_2dd=["TL"];
}
var _2e5,_2e6,_2e7=Infinity,_2e8;
for(var _2e9=0;_2e9<_2dd.length;++_2e9){
var _2ea=_2dd[_2e9];
var _2eb=true;
var tryX=_2d9-(_2ea.charAt(1)=="L"?0:w)+_2db[0]*(_2ea.charAt(1)=="L"?1:-1);
var tryY=_2da-(_2ea.charAt(0)=="T"?0:h)+_2db[1]*(_2ea.charAt(0)=="T"?1:-1);
if(_2dc){
tryX-=_2df.x;
tryY-=_2df.y;
}
if(tryX<0){
tryX=0;
_2eb=false;
}
if(tryY<0){
tryY=0;
_2eb=false;
}
var x=tryX+w;
if(x>view.width){
x=view.width-w;
_2eb=false;
}else{
x=tryX;
}
x=Math.max(_2db[0],x)+_2df.x;
var y=tryY+h;
if(y>view.height){
y=view.height-h;
_2eb=false;
}else{
y=tryY;
}
y=Math.max(_2db[1],y)+_2df.y;
if(_2eb){
_2e5=x;
_2e6=y;
_2e7=0;
_2e8=_2ea;
break;
}else{
var dist=Math.pow(x-tryX-_2df.x,2)+Math.pow(y-tryY-_2df.y,2);
if(_2e7>dist){
_2e7=dist;
_2e5=x;
_2e6=y;
_2e8=_2ea;
}
}
}
if(!_2de){
node.style.left=_2e5+"px";
node.style.top=_2e6+"px";
}
return {left:_2e5,top:_2e6,x:_2e5,y:_2e6,dist:_2e7,corner:_2e8};
};
dojo.html.placeOnScreenPoint=function(node,_2f2,_2f3,_2f4,_2f5){
dojo.deprecated("dojo.html.placeOnScreenPoint","use dojo.html.placeOnScreen() instead","0.5");
return dojo.html.placeOnScreen(node,_2f2,_2f3,_2f4,_2f5,["TL","TR","BL","BR"]);
};
dojo.html.placeOnScreenAroundElement=function(node,_2f7,_2f8,_2f9,_2fa,_2fb){
var best,_2fd=Infinity;
_2f7=dojo.byId(_2f7);
var _2fe=_2f7.style.display;
_2f7.style.display="";
var mb=dojo.html.getElementBox(_2f7,_2f9);
var _300=mb.width;
var _301=mb.height;
var _302=dojo.html.getAbsolutePosition(_2f7,true,_2f9);
_2f7.style.display=_2fe;
for(var _303 in _2fa){
var pos,_305,_306;
var _307=_2fa[_303];
_305=_302.x+(_303.charAt(1)=="L"?0:_300);
_306=_302.y+(_303.charAt(0)=="T"?0:_301);
pos=dojo.html.placeOnScreen(node,_305,_306,_2f8,true,_307,true);
if(pos.dist==0){
best=pos;
break;
}else{
if(_2fd>pos.dist){
_2fd=pos.dist;
best=pos;
}
}
}
if(!_2fb){
node.style.left=best.left+"px";
node.style.top=best.top+"px";
}
return best;
};
dojo.html.scrollIntoView=function(node){
if(!node){
return;
}
if(dojo.render.html.ie){
if(dojo.html.getBorderBox(node.parentNode).height<=node.parentNode.scrollHeight){
node.scrollIntoView(false);
}
}else{
if(dojo.render.html.mozilla){
node.scrollIntoView(false);
}else{
var _309=node.parentNode;
var _30a=_309.scrollTop+dojo.html.getBorderBox(_309).height;
var _30b=node.offsetTop+dojo.html.getMarginBox(node).height;
if(_30a<_30b){
_309.scrollTop+=(_30b-_30a);
}else{
if(_309.scrollTop>node.offsetTop){
_309.scrollTop-=(_309.scrollTop-node.offsetTop);
}
}
}
}
};
dojo.provide("dojo.lang.array");
dojo.lang.mixin(dojo.lang,{has:function(obj,name){
try{
return typeof obj[name]!="undefined";
}
catch(e){
return false;
}
},isEmpty:function(obj){
if(dojo.lang.isObject(obj)){
var tmp={};
var _310=0;
for(var x in obj){
if(obj[x]&&(!tmp[x])){
_310++;
break;
}
}
return _310==0;
}else{
if(dojo.lang.isArrayLike(obj)||dojo.lang.isString(obj)){
return obj.length==0;
}
}
},map:function(arr,obj,_314){
var _315=dojo.lang.isString(arr);
if(_315){
arr=arr.split("");
}
if(dojo.lang.isFunction(obj)&&(!_314)){
_314=obj;
obj=dj_global;
}else{
if(dojo.lang.isFunction(obj)&&_314){
var _316=obj;
obj=_314;
_314=_316;
}
}
if(Array.map){
var _317=Array.map(arr,_314,obj);
}else{
var _317=[];
for(var i=0;i<arr.length;++i){
_317.push(_314.call(obj,arr[i]));
}
}
if(_315){
return _317.join("");
}else{
return _317;
}
},reduce:function(arr,_31a,obj,_31c){
var _31d=_31a;
if(arguments.length==2){
_31c=_31a;
_31d=arr[0];
arr=arr.slice(1);
}else{
if(arguments.length==3){
if(dojo.lang.isFunction(obj)){
_31c=obj;
obj=null;
}
}else{
if(dojo.lang.isFunction(obj)){
var tmp=_31c;
_31c=obj;
obj=tmp;
}
}
}
var ob=obj||dj_global;
dojo.lang.map(arr,function(val){
_31d=_31c.call(ob,_31d,val);
});
return _31d;
},forEach:function(_321,_322,_323){
if(dojo.lang.isString(_321)){
_321=_321.split("");
}
if(Array.forEach){
Array.forEach(_321,_322,_323);
}else{
if(!_323){
_323=dj_global;
}
for(var i=0,l=_321.length;i<l;i++){
_322.call(_323,_321[i],i,_321);
}
}
},_everyOrSome:function(_326,arr,_328,_329){
if(dojo.lang.isString(arr)){
arr=arr.split("");
}
if(Array.every){
return Array[_326?"every":"some"](arr,_328,_329);
}else{
if(!_329){
_329=dj_global;
}
for(var i=0,l=arr.length;i<l;i++){
var _32c=_328.call(_329,arr[i],i,arr);
if(_326&&!_32c){
return false;
}else{
if((!_326)&&(_32c)){
return true;
}
}
}
return Boolean(_326);
}
},every:function(arr,_32e,_32f){
return this._everyOrSome(true,arr,_32e,_32f);
},some:function(arr,_331,_332){
return this._everyOrSome(false,arr,_331,_332);
},filter:function(arr,_334,_335){
var _336=dojo.lang.isString(arr);
if(_336){
arr=arr.split("");
}
var _337;
if(Array.filter){
_337=Array.filter(arr,_334,_335);
}else{
if(!_335){
if(arguments.length>=3){
dojo.raise("thisObject doesn't exist!");
}
_335=dj_global;
}
_337=[];
for(var i=0;i<arr.length;i++){
if(_334.call(_335,arr[i],i,arr)){
_337.push(arr[i]);
}
}
}
if(_336){
return _337.join("");
}else{
return _337;
}
},unnest:function(){
var out=[];
for(var i=0;i<arguments.length;i++){
if(dojo.lang.isArrayLike(arguments[i])){
var add=dojo.lang.unnest.apply(this,arguments[i]);
out=out.concat(add);
}else{
out.push(arguments[i]);
}
}
return out;
},toArray:function(_33c,_33d){
var _33e=[];
for(var i=_33d||0;i<_33c.length;i++){
_33e.push(_33c[i]);
}
return _33e;
}});
dojo.provide("dojo.gfx.color");
dojo.gfx.color.Color=function(r,g,b,a){
if(dojo.lang.isArray(r)){
this.r=r[0];
this.g=r[1];
this.b=r[2];
this.a=r[3]||1;
}else{
if(dojo.lang.isString(r)){
var rgb=dojo.gfx.color.extractRGB(r);
this.r=rgb[0];
this.g=rgb[1];
this.b=rgb[2];
this.a=g||1;
}else{
if(r instanceof dojo.gfx.color.Color){
this.r=r.r;
this.b=r.b;
this.g=r.g;
this.a=r.a;
}else{
this.r=r;
this.g=g;
this.b=b;
this.a=a;
}
}
}
};
dojo.gfx.color.Color.fromArray=function(arr){
return new dojo.gfx.color.Color(arr[0],arr[1],arr[2],arr[3]);
};
dojo.extend(dojo.gfx.color.Color,{toRgb:function(_346){
if(_346){
return this.toRgba();
}else{
return [this.r,this.g,this.b];
}
},toRgba:function(){
return [this.r,this.g,this.b,this.a];
},toHex:function(){
return dojo.gfx.color.rgb2hex(this.toRgb());
},toCss:function(){
return "rgb("+this.toRgb().join()+")";
},toString:function(){
return this.toHex();
},blend:function(_347,_348){
var rgb=null;
if(dojo.lang.isArray(_347)){
rgb=_347;
}else{
if(_347 instanceof dojo.gfx.color.Color){
rgb=_347.toRgb();
}else{
rgb=new dojo.gfx.color.Color(_347).toRgb();
}
}
return dojo.gfx.color.blend(this.toRgb(),rgb,_348);
}});
dojo.gfx.color.named={white:[255,255,255],black:[0,0,0],red:[255,0,0],green:[0,255,0],lime:[0,255,0],blue:[0,0,255],navy:[0,0,128],gray:[128,128,128],silver:[192,192,192]};
dojo.gfx.color.blend=function(a,b,_34c){
if(typeof a=="string"){
return dojo.gfx.color.blendHex(a,b,_34c);
}
if(!_34c){
_34c=0;
}
_34c=Math.min(Math.max(-1,_34c),1);
_34c=((_34c+1)/2);
var c=[];
for(var x=0;x<3;x++){
c[x]=parseInt(b[x]+((a[x]-b[x])*_34c));
}
return c;
};
dojo.gfx.color.blendHex=function(a,b,_351){
return dojo.gfx.color.rgb2hex(dojo.gfx.color.blend(dojo.gfx.color.hex2rgb(a),dojo.gfx.color.hex2rgb(b),_351));
};
dojo.gfx.color.extractRGB=function(_352){
var hex="0123456789abcdef";
_352=_352.toLowerCase();
if(_352.indexOf("rgb")==0){
var _354=_352.match(/rgba*\((\d+), *(\d+), *(\d+)/i);
var ret=_354.splice(1,3);
return ret;
}else{
var _356=dojo.gfx.color.hex2rgb(_352);
if(_356){
return _356;
}else{
return dojo.gfx.color.named[_352]||[255,255,255];
}
}
};
dojo.gfx.color.hex2rgb=function(hex){
var _358="0123456789ABCDEF";
var rgb=new Array(3);
if(hex.indexOf("#")==0){
hex=hex.substring(1);
}
hex=hex.toUpperCase();
if(hex.replace(new RegExp("["+_358+"]","g"),"")!=""){
return null;
}
if(hex.length==3){
rgb[0]=hex.charAt(0)+hex.charAt(0);
rgb[1]=hex.charAt(1)+hex.charAt(1);
rgb[2]=hex.charAt(2)+hex.charAt(2);
}else{
rgb[0]=hex.substring(0,2);
rgb[1]=hex.substring(2,4);
rgb[2]=hex.substring(4);
}
for(var i=0;i<rgb.length;i++){
rgb[i]=_358.indexOf(rgb[i].charAt(0))*16+_358.indexOf(rgb[i].charAt(1));
}
return rgb;
};
dojo.gfx.color.rgb2hex=function(r,g,b){
if(dojo.lang.isArray(r)){
g=r[1]||0;
b=r[2]||0;
r=r[0]||0;
}
var ret=dojo.lang.map([r,g,b],function(x){
x=new Number(x);
var s=x.toString(16);
while(s.length<2){
s="0"+s;
}
return s;
});
ret.unshift("#");
return ret.join("");
};
dojo.provide("dojo.lang.func");
dojo.lang.hitch=function(_361,_362){
var args=[];
for(var x=2;x<arguments.length;x++){
args.push(arguments[x]);
}
var fcn=(dojo.lang.isString(_362)?_361[_362]:_362)||function(){
};
return function(){
var ta=args.concat([]);
for(var x=0;x<arguments.length;x++){
ta.push(arguments[x]);
}
return fcn.apply(_361,ta);
};
};
dojo.lang.anonCtr=0;
dojo.lang.anon={};
dojo.lang.nameAnonFunc=function(_368,_369,_36a){
var nso=(_369||dojo.lang.anon);
if((_36a)||((dj_global["djConfig"])&&(djConfig["slowAnonFuncLookups"]==true))){
for(var x in nso){
try{
if(nso[x]===_368){
return x;
}
}
catch(e){
}
}
}
var ret="__"+dojo.lang.anonCtr++;
while(typeof nso[ret]!="undefined"){
ret="__"+dojo.lang.anonCtr++;
}
nso[ret]=_368;
return ret;
};
dojo.lang.forward=function(_36e){
return function(){
return this[_36e].apply(this,arguments);
};
};
dojo.lang.curry=function(_36f,func){
var _371=[];
_36f=_36f||dj_global;
if(dojo.lang.isString(func)){
func=_36f[func];
}
for(var x=2;x<arguments.length;x++){
_371.push(arguments[x]);
}
var _373=(func["__preJoinArity"]||func.length)-_371.length;
function gather(_374,_375,_376){
var _377=_376;
var _378=_375.slice(0);
for(var x=0;x<_374.length;x++){
_378.push(_374[x]);
}
_376=_376-_374.length;
if(_376<=0){
var res=func.apply(_36f,_378);
_376=_377;
return res;
}else{
return function(){
return gather(arguments,_378,_376);
};
}
}
return gather([],_371,_373);
};
dojo.lang.curryArguments=function(_37b,func,args,_37e){
var _37f=[];
var x=_37e||0;
for(x=_37e;x<args.length;x++){
_37f.push(args[x]);
}
return dojo.lang.curry.apply(dojo.lang,[_37b,func].concat(_37f));
};
dojo.lang.tryThese=function(){
for(var x=0;x<arguments.length;x++){
try{
if(typeof arguments[x]=="function"){
var ret=(arguments[x]());
if(ret){
return ret;
}
}
}
catch(e){
dojo.debug(e);
}
}
};
dojo.lang.delayThese=function(farr,cb,_385,_386){
if(!farr.length){
if(typeof _386=="function"){
_386();
}
return;
}
if((typeof _385=="undefined")&&(typeof cb=="number")){
_385=cb;
cb=function(){
};
}else{
if(!cb){
cb=function(){
};
if(!_385){
_385=0;
}
}
}
setTimeout(function(){
(farr.shift())();
cb();
dojo.lang.delayThese(farr,cb,_385,_386);
},_385);
};
dojo.provide("dojo.lfx.Animation");
dojo.lfx.Line=function(_387,end){
this.start=_387;
this.end=end;
if(dojo.lang.isArray(_387)){
var diff=[];
dojo.lang.forEach(this.start,function(s,i){
diff[i]=this.end[i]-s;
},this);
this.getValue=function(n){
var res=[];
dojo.lang.forEach(this.start,function(s,i){
res[i]=(diff[i]*n)+s;
},this);
return res;
};
}else{
var diff=end-_387;
this.getValue=function(n){
return (diff*n)+this.start;
};
}
};
if((dojo.render.html.khtml)&&(!dojo.render.html.safari)){
dojo.lfx.easeDefault=function(n){
return (parseFloat("0.5")+((Math.sin((n+parseFloat("1.5"))*Math.PI))/2));
};
}else{
dojo.lfx.easeDefault=function(n){
return (0.5+((Math.sin((n+1.5)*Math.PI))/2));
};
}
dojo.lfx.easeIn=function(n){
return Math.pow(n,3);
};
dojo.lfx.easeOut=function(n){
return (1-Math.pow(1-n,3));
};
dojo.lfx.easeInOut=function(n){
return ((3*Math.pow(n,2))-(2*Math.pow(n,3)));
};
dojo.lfx.IAnimation=function(){
};
dojo.lang.extend(dojo.lfx.IAnimation,{curve:null,duration:1000,easing:null,repeatCount:0,rate:10,handler:null,beforeBegin:null,onBegin:null,onAnimate:null,onEnd:null,onPlay:null,onPause:null,onStop:null,play:null,pause:null,stop:null,connect:function(evt,_397,_398){
if(!_398){
_398=_397;
_397=this;
}
_398=dojo.lang.hitch(_397,_398);
var _399=this[evt]||function(){
};
this[evt]=function(){
var ret=_399.apply(this,arguments);
_398.apply(this,arguments);
return ret;
};
return this;
},fire:function(evt,args){
if(this[evt]){
this[evt].apply(this,(args||[]));
}
return this;
},repeat:function(_39d){
this.repeatCount=_39d;
return this;
},_active:false,_paused:false});
dojo.lfx.Animation=function(_39e,_39f,_3a0,_3a1,_3a2,rate){
dojo.lfx.IAnimation.call(this);
if(dojo.lang.isNumber(_39e)||(!_39e&&_39f.getValue)){
rate=_3a2;
_3a2=_3a1;
_3a1=_3a0;
_3a0=_39f;
_39f=_39e;
_39e=null;
}else{
if(_39e.getValue||dojo.lang.isArray(_39e)){
rate=_3a1;
_3a2=_3a0;
_3a1=_39f;
_3a0=_39e;
_39f=null;
_39e=null;
}
}
if(dojo.lang.isArray(_3a0)){
this.curve=new dojo.lfx.Line(_3a0[0],_3a0[1]);
}else{
this.curve=_3a0;
}
if(_39f!=null&&_39f>0){
this.duration=_39f;
}
if(_3a2){
this.repeatCount=_3a2;
}
if(rate){
this.rate=rate;
}
if(_39e){
dojo.lang.forEach(["handler","beforeBegin","onBegin","onEnd","onPlay","onStop","onAnimate"],function(item){
if(_39e[item]){
this.connect(item,_39e[item]);
}
},this);
}
if(_3a1&&dojo.lang.isFunction(_3a1)){
this.easing=_3a1;
}
};
dojo.inherits(dojo.lfx.Animation,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Animation,{_startTime:null,_endTime:null,_timer:null,_percent:0,_startRepeatCount:0,play:function(_3a5,_3a6){
if(_3a6){
clearTimeout(this._timer);
this._active=false;
this._paused=false;
this._percent=0;
}else{
if(this._active&&!this._paused){
return this;
}
}
this.fire("handler",["beforeBegin"]);
this.fire("beforeBegin");
if(_3a5>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3a6);
}),_3a5);
return this;
}
this._startTime=new Date().valueOf();
if(this._paused){
this._startTime-=(this.duration*this._percent/100);
}
this._endTime=this._startTime+this.duration;
this._active=true;
this._paused=false;
var step=this._percent/100;
var _3a8=this.curve.getValue(step);
if(this._percent==0){
if(!this._startRepeatCount){
this._startRepeatCount=this.repeatCount;
}
this.fire("handler",["begin",_3a8]);
this.fire("onBegin",[_3a8]);
}
this.fire("handler",["play",_3a8]);
this.fire("onPlay",[_3a8]);
this._cycle();
return this;
},pause:function(){
clearTimeout(this._timer);
if(!this._active){
return this;
}
this._paused=true;
var _3a9=this.curve.getValue(this._percent/100);
this.fire("handler",["pause",_3a9]);
this.fire("onPause",[_3a9]);
return this;
},gotoPercent:function(pct,_3ab){
clearTimeout(this._timer);
this._active=true;
this._paused=true;
this._percent=pct;
if(_3ab){
this.play();
}
return this;
},stop:function(_3ac){
clearTimeout(this._timer);
var step=this._percent/100;
if(_3ac){
step=1;
}
var _3ae=this.curve.getValue(step);
this.fire("handler",["stop",_3ae]);
this.fire("onStop",[_3ae]);
this._active=false;
this._paused=false;
return this;
},status:function(){
if(this._active){
return this._paused?"paused":"playing";
}else{
return "stopped";
}
return this;
},_cycle:function(){
clearTimeout(this._timer);
if(this._active){
var curr=new Date().valueOf();
var step=(curr-this._startTime)/(this._endTime-this._startTime);
if(step>=1){
step=1;
this._percent=100;
}else{
this._percent=step*100;
}
if((this.easing)&&(dojo.lang.isFunction(this.easing))){
step=this.easing(step);
}
var _3b1=this.curve.getValue(step);
this.fire("handler",["animate",_3b1]);
this.fire("onAnimate",[_3b1]);
if(step<1){
this._timer=setTimeout(dojo.lang.hitch(this,"_cycle"),this.rate);
}else{
this._active=false;
this.fire("handler",["end"]);
this.fire("onEnd");
if(this.repeatCount>0){
this.repeatCount--;
this.play(null,true);
}else{
if(this.repeatCount==-1){
this.play(null,true);
}else{
if(this._startRepeatCount){
this.repeatCount=this._startRepeatCount;
this._startRepeatCount=0;
}
}
}
}
}
return this;
}});
dojo.lfx.Combine=function(_3b2){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._animsEnded=0;
var _3b3=arguments;
if(_3b3.length==1&&(dojo.lang.isArray(_3b3[0])||dojo.lang.isArrayLike(_3b3[0]))){
_3b3=_3b3[0];
}
dojo.lang.forEach(_3b3,function(anim){
this._anims.push(anim);
anim.connect("onEnd",dojo.lang.hitch(this,"_onAnimsEnded"));
},this);
};
dojo.inherits(dojo.lfx.Combine,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Combine,{_animsEnded:0,play:function(_3b5,_3b6){
if(!this._anims.length){
return this;
}
this.fire("beforeBegin");
if(_3b5>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3b6);
}),_3b5);
return this;
}
if(_3b6||this._anims[0].percent==0){
this.fire("onBegin");
}
this.fire("onPlay");
this._animsCall("play",null,_3b6);
return this;
},pause:function(){
this.fire("onPause");
this._animsCall("pause");
return this;
},stop:function(_3b7){
this.fire("onStop");
this._animsCall("stop",_3b7);
return this;
},_onAnimsEnded:function(){
this._animsEnded++;
if(this._animsEnded>=this._anims.length){
this.fire("onEnd");
}
return this;
},_animsCall:function(_3b8){
var args=[];
if(arguments.length>1){
for(var i=1;i<arguments.length;i++){
args.push(arguments[i]);
}
}
var _3bb=this;
dojo.lang.forEach(this._anims,function(anim){
anim[_3b8](args);
},_3bb);
return this;
}});
dojo.lfx.Chain=function(_3bd){
dojo.lfx.IAnimation.call(this);
this._anims=[];
this._currAnim=-1;
var _3be=arguments;
if(_3be.length==1&&(dojo.lang.isArray(_3be[0])||dojo.lang.isArrayLike(_3be[0]))){
_3be=_3be[0];
}
var _3bf=this;
dojo.lang.forEach(_3be,function(anim,i,_3c2){
this._anims.push(anim);
if(i<_3c2.length-1){
anim.connect("onEnd",dojo.lang.hitch(this,"_playNext"));
}else{
anim.connect("onEnd",dojo.lang.hitch(this,function(){
this.fire("onEnd");
}));
}
},this);
};
dojo.inherits(dojo.lfx.Chain,dojo.lfx.IAnimation);
dojo.lang.extend(dojo.lfx.Chain,{_currAnim:-1,play:function(_3c3,_3c4){
if(!this._anims.length){
return this;
}
if(_3c4||!this._anims[this._currAnim]){
this._currAnim=0;
}
var _3c5=this._anims[this._currAnim];
this.fire("beforeBegin");
if(_3c3>0){
setTimeout(dojo.lang.hitch(this,function(){
this.play(null,_3c4);
}),_3c3);
return this;
}
if(_3c5){
if(this._currAnim==0){
this.fire("handler",["begin",this._currAnim]);
this.fire("onBegin",[this._currAnim]);
}
this.fire("onPlay",[this._currAnim]);
_3c5.play(null,_3c4);
}
return this;
},pause:function(){
if(this._anims[this._currAnim]){
this._anims[this._currAnim].pause();
this.fire("onPause",[this._currAnim]);
}
return this;
},playPause:function(){
if(this._anims.length==0){
return this;
}
if(this._currAnim==-1){
this._currAnim=0;
}
var _3c6=this._anims[this._currAnim];
if(_3c6){
if(!_3c6._active||_3c6._paused){
this.play();
}else{
this.pause();
}
}
return this;
},stop:function(){
var _3c7=this._anims[this._currAnim];
if(_3c7){
_3c7.stop();
this.fire("onStop",[this._currAnim]);
}
return _3c7;
},_playNext:function(){
if(this._currAnim==-1||this._anims.length==0){
return this;
}
this._currAnim++;
if(this._anims[this._currAnim]){
this._anims[this._currAnim].play(null,true);
}
return this;
}});
dojo.lfx.combine=function(_3c8){
var _3c9=arguments;
if(dojo.lang.isArray(arguments[0])){
_3c9=arguments[0];
}
if(_3c9.length==1){
return _3c9[0];
}
return new dojo.lfx.Combine(_3c9);
};
dojo.lfx.chain=function(_3ca){
var _3cb=arguments;
if(dojo.lang.isArray(arguments[0])){
_3cb=arguments[0];
}
if(_3cb.length==1){
return _3cb[0];
}
return new dojo.lfx.Chain(_3cb);
};
dojo.provide("dojo.html.color");
dojo.html.getBackgroundColor=function(node){
node=dojo.byId(node);
var _3cd;
do{
_3cd=dojo.html.getStyle(node,"background-color");
if(_3cd.toLowerCase()=="rgba(0, 0, 0, 0)"){
_3cd="transparent";
}
if(node==document.getElementsByTagName("body")[0]){
node=null;
break;
}
node=node.parentNode;
}while(node&&dojo.lang.inArray(["transparent",""],_3cd));
if(_3cd=="transparent"){
_3cd=[255,255,255,0];
}else{
_3cd=dojo.gfx.color.extractRGB(_3cd);
}
return _3cd;
};
dojo.provide("dojo.lfx.html");
dojo.lfx.html._byId=function(_3ce){
if(!_3ce){
return [];
}
if(dojo.lang.isArrayLike(_3ce)){
if(!_3ce.alreadyChecked){
var n=[];
dojo.lang.forEach(_3ce,function(node){
n.push(dojo.byId(node));
});
n.alreadyChecked=true;
return n;
}else{
return _3ce;
}
}else{
var n=[];
n.push(dojo.byId(_3ce));
n.alreadyChecked=true;
return n;
}
};
dojo.lfx.html.propertyAnimation=function(_3d1,_3d2,_3d3,_3d4,_3d5){
_3d1=dojo.lfx.html._byId(_3d1);
var _3d6={"propertyMap":_3d2,"nodes":_3d1,"duration":_3d3,"easing":_3d4||dojo.lfx.easeDefault};
var _3d7=function(args){
if(args.nodes.length==1){
var pm=args.propertyMap;
if(!dojo.lang.isArray(args.propertyMap)){
var parr=[];
for(var _3db in pm){
pm[_3db].property=_3db;
parr.push(pm[_3db]);
}
pm=args.propertyMap=parr;
}
dojo.lang.forEach(pm,function(prop){
if(dj_undef("start",prop)){
if(prop.property!="opacity"){
prop.start=parseInt(dojo.html.getComputedStyle(args.nodes[0],prop.property));
}else{
prop.start=dojo.html.getOpacity(args.nodes[0]);
}
}
});
}
};
var _3dd=function(_3de){
var _3df=[];
dojo.lang.forEach(_3de,function(c){
_3df.push(Math.round(c));
});
return _3df;
};
var _3e1=function(n,_3e3){
n=dojo.byId(n);
if(!n||!n.style){
return;
}
for(var s in _3e3){
try{
if(s=="opacity"){
dojo.html.setOpacity(n,_3e3[s]);
}else{
n.style[s]=_3e3[s];
}
}
catch(e){
dojo.debug(e);
}
}
};
var _3e5=function(_3e6){
this._properties=_3e6;
this.diffs=new Array(_3e6.length);
dojo.lang.forEach(_3e6,function(prop,i){
if(dojo.lang.isFunction(prop.start)){
prop.start=prop.start(prop,i);
}
if(dojo.lang.isFunction(prop.end)){
prop.end=prop.end(prop,i);
}
if(dojo.lang.isArray(prop.start)){
this.diffs[i]=null;
}else{
if(prop.start instanceof dojo.gfx.color.Color){
prop.startRgb=prop.start.toRgb();
prop.endRgb=prop.end.toRgb();
}else{
this.diffs[i]=prop.end-prop.start;
}
}
},this);
this.getValue=function(n){
var ret={};
dojo.lang.forEach(this._properties,function(prop,i){
var _3ed=null;
if(dojo.lang.isArray(prop.start)){
}else{
if(prop.start instanceof dojo.gfx.color.Color){
_3ed=(prop.units||"rgb")+"(";
for(var j=0;j<prop.startRgb.length;j++){
_3ed+=Math.round(((prop.endRgb[j]-prop.startRgb[j])*n)+prop.startRgb[j])+(j<prop.startRgb.length-1?",":"");
}
_3ed+=")";
}else{
_3ed=((this.diffs[i])*n)+prop.start+(prop.property!="opacity"?prop.units||"px":"");
}
}
ret[dojo.html.toCamelCase(prop.property)]=_3ed;
},this);
return ret;
};
};
var anim=new dojo.lfx.Animation({beforeBegin:function(){
_3d7(_3d6);
anim.curve=new _3e5(_3d6.propertyMap);
},onAnimate:function(_3f0){
dojo.lang.forEach(_3d6.nodes,function(node){
_3e1(node,_3f0);
});
}},_3d6.duration,null,_3d6.easing);
if(_3d5){
for(var x in _3d5){
if(dojo.lang.isFunction(_3d5[x])){
anim.connect(x,anim,_3d5[x]);
}
}
}
return anim;
};
dojo.lfx.html._makeFadeable=function(_3f3){
var _3f4=function(node){
if(dojo.render.html.ie){
if((node.style.zoom.length==0)&&(dojo.html.getStyle(node,"zoom")=="normal")){
node.style.zoom="1";
}
if((node.style.width.length==0)&&(dojo.html.getStyle(node,"width")=="auto")){
node.style.width="auto";
}
}
};
if(dojo.lang.isArrayLike(_3f3)){
dojo.lang.forEach(_3f3,_3f4);
}else{
_3f4(_3f3);
}
};
dojo.lfx.html.fade=function(_3f6,_3f7,_3f8,_3f9,_3fa){
_3f6=dojo.lfx.html._byId(_3f6);
var _3fb={property:"opacity"};
if(!dj_undef("start",_3f7)){
_3fb.start=_3f7.start;
}else{
_3fb.start=function(){
return dojo.html.getOpacity(_3f6[0]);
};
}
if(!dj_undef("end",_3f7)){
_3fb.end=_3f7.end;
}else{
dojo.raise("dojo.lfx.html.fade needs an end value");
}
var anim=dojo.lfx.propertyAnimation(_3f6,[_3fb],_3f8,_3f9);
anim.connect("beforeBegin",function(){
dojo.lfx.html._makeFadeable(_3f6);
});
if(_3fa){
anim.connect("onEnd",function(){
_3fa(_3f6,anim);
});
}
return anim;
};
dojo.lfx.html.fadeIn=function(_3fd,_3fe,_3ff,_400){
return dojo.lfx.html.fade(_3fd,{end:1},_3fe,_3ff,_400);
};
dojo.lfx.html.fadeOut=function(_401,_402,_403,_404){
return dojo.lfx.html.fade(_401,{end:0},_402,_403,_404);
};
dojo.lfx.html.fadeShow=function(_405,_406,_407,_408){
_405=dojo.lfx.html._byId(_405);
dojo.lang.forEach(_405,function(node){
dojo.html.setOpacity(node,0);
});
var anim=dojo.lfx.html.fadeIn(_405,_406,_407,_408);
anim.connect("beforeBegin",function(){
if(dojo.lang.isArrayLike(_405)){
dojo.lang.forEach(_405,dojo.html.show);
}else{
dojo.html.show(_405);
}
});
return anim;
};
dojo.lfx.html.fadeHide=function(_40b,_40c,_40d,_40e){
var anim=dojo.lfx.html.fadeOut(_40b,_40c,_40d,function(){
if(dojo.lang.isArrayLike(_40b)){
dojo.lang.forEach(_40b,dojo.html.hide);
}else{
dojo.html.hide(_40b);
}
if(_40e){
_40e(_40b,anim);
}
});
return anim;
};
dojo.lfx.html.wipeIn=function(_410,_411,_412,_413){
_410=dojo.lfx.html._byId(_410);
var _414=[];
dojo.lang.forEach(_410,function(node){
var _416={};
var _417,_418,_419;
with(node.style){
_417=top;
_418=left;
_419=position;
top="-9999px";
left="-9999px";
position="absolute";
display="";
}
var _41a=dojo.html.getBorderBox(node).height;
with(node.style){
top=_417;
left=_418;
position=_419;
display="none";
}
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:1,end:function(){
return _41a;
}}},_411,_412);
anim.connect("beforeBegin",function(){
_416.overflow=node.style.overflow;
_416.height=node.style.height;
with(node.style){
overflow="hidden";
height="1px";
}
dojo.html.show(node);
});
anim.connect("onEnd",function(){
with(node.style){
overflow=_416.overflow;
height=_416.height;
}
if(_413){
_413(node,anim);
}
});
_414.push(anim);
});
return dojo.lfx.combine(_414);
};
dojo.lfx.html.wipeOut=function(_41c,_41d,_41e,_41f){
_41c=dojo.lfx.html._byId(_41c);
var _420=[];
dojo.lang.forEach(_41c,function(node){
var _422={};
var anim=dojo.lfx.propertyAnimation(node,{"height":{start:function(){
return dojo.html.getContentBox(node).height;
},end:1}},_41d,_41e,{"beforeBegin":function(){
_422.overflow=node.style.overflow;
_422.height=node.style.height;
with(node.style){
overflow="hidden";
}
dojo.html.show(node);
},"onEnd":function(){
dojo.html.hide(node);
with(node.style){
overflow=_422.overflow;
height=_422.height;
}
if(_41f){
_41f(node,anim);
}
}});
_420.push(anim);
});
return dojo.lfx.combine(_420);
};
dojo.lfx.html.slideTo=function(_424,_425,_426,_427,_428){
_424=dojo.lfx.html._byId(_424);
var _429=[];
var _42a=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_425)){
dojo.deprecated("dojo.lfx.html.slideTo(node, array)","use dojo.lfx.html.slideTo(node, {top: value, left: value});","0.5");
_425={top:_425[0],left:_425[1]};
}
dojo.lang.forEach(_424,function(node){
var top=null;
var left=null;
var init=(function(){
var _42f=node;
return function(){
var pos=_42a(_42f,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_42a(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_42a(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_42f,true);
dojo.html.setStyleAttributes(_42f,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:(_425.top||0)},"left":{start:left,end:(_425.left||0)}},_426,_427,{"beforeBegin":init});
if(_428){
anim.connect("onEnd",function(){
_428(_424,anim);
});
}
_429.push(anim);
});
return dojo.lfx.combine(_429);
};
dojo.lfx.html.slideBy=function(_433,_434,_435,_436,_437){
_433=dojo.lfx.html._byId(_433);
var _438=[];
var _439=dojo.html.getComputedStyle;
if(dojo.lang.isArray(_434)){
dojo.deprecated("dojo.lfx.html.slideBy(node, array)","use dojo.lfx.html.slideBy(node, {top: value, left: value});","0.5");
_434={top:_434[0],left:_434[1]};
}
dojo.lang.forEach(_433,function(node){
var top=null;
var left=null;
var init=(function(){
var _43e=node;
return function(){
var pos=_439(_43e,"position");
top=(pos=="absolute"?node.offsetTop:parseInt(_439(node,"top"))||0);
left=(pos=="absolute"?node.offsetLeft:parseInt(_439(node,"left"))||0);
if(!dojo.lang.inArray(["absolute","relative"],pos)){
var ret=dojo.html.abs(_43e,true);
dojo.html.setStyleAttributes(_43e,"position:absolute;top:"+ret.y+"px;left:"+ret.x+"px;");
top=ret.y;
left=ret.x;
}
};
})();
init();
var anim=dojo.lfx.propertyAnimation(node,{"top":{start:top,end:top+(_434.top||0)},"left":{start:left,end:left+(_434.left||0)}},_435,_436).connect("beforeBegin",init);
if(_437){
anim.connect("onEnd",function(){
_437(_433,anim);
});
}
_438.push(anim);
});
return dojo.lfx.combine(_438);
};
dojo.lfx.html.explode=function(_442,_443,_444,_445,_446){
var h=dojo.html;
_442=dojo.byId(_442);
_443=dojo.byId(_443);
var _448=h.toCoordinateObject(_442,true);
var _449=document.createElement("div");
h.copyStyle(_449,_443);
if(_443.explodeClassName){
_449.className=_443.explodeClassName;
}
with(_449.style){
position="absolute";
display="none";
var _44a=h.getStyle(_442,"background-color");
backgroundColor=_44a?_44a.toLowerCase():"transparent";
backgroundColor=(backgroundColor=="transparent")?"rgb(221, 221, 221)":backgroundColor;
}
dojo.body().appendChild(_449);
with(_443.style){
visibility="hidden";
display="block";
}
var _44b=h.toCoordinateObject(_443,true);
with(_443.style){
display="none";
visibility="visible";
}
var _44c={opacity:{start:0.5,end:1}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_44c[type]={start:_448[type],end:_44b[type]};
});
var anim=new dojo.lfx.propertyAnimation(_449,_44c,_444,_445,{"beforeBegin":function(){
h.setDisplay(_449,"block");
},"onEnd":function(){
h.setDisplay(_443,"block");
_449.parentNode.removeChild(_449);
}});
if(_446){
anim.connect("onEnd",function(){
_446(_443,anim);
});
}
return anim;
};
dojo.lfx.html.implode=function(_44f,end,_451,_452,_453){
var h=dojo.html;
_44f=dojo.byId(_44f);
end=dojo.byId(end);
var _455=dojo.html.toCoordinateObject(_44f,true);
var _456=dojo.html.toCoordinateObject(end,true);
var _457=document.createElement("div");
dojo.html.copyStyle(_457,_44f);
if(_44f.explodeClassName){
_457.className=_44f.explodeClassName;
}
dojo.html.setOpacity(_457,0.3);
with(_457.style){
position="absolute";
display="none";
backgroundColor=h.getStyle(_44f,"background-color").toLowerCase();
}
dojo.body().appendChild(_457);
var _458={opacity:{start:1,end:0.5}};
dojo.lang.forEach(["height","width","top","left"],function(type){
_458[type]={start:_455[type],end:_456[type]};
});
var anim=new dojo.lfx.propertyAnimation(_457,_458,_451,_452,{"beforeBegin":function(){
dojo.html.hide(_44f);
dojo.html.show(_457);
},"onEnd":function(){
_457.parentNode.removeChild(_457);
}});
if(_453){
anim.connect("onEnd",function(){
_453(_44f,anim);
});
}
return anim;
};
dojo.lfx.html.highlight=function(_45b,_45c,_45d,_45e,_45f){
_45b=dojo.lfx.html._byId(_45b);
var _460=[];
dojo.lang.forEach(_45b,function(node){
var _462=dojo.html.getBackgroundColor(node);
var bg=dojo.html.getStyle(node,"background-color").toLowerCase();
var _464=dojo.html.getStyle(node,"background-image");
var _465=(bg=="transparent"||bg=="rgba(0, 0, 0, 0)");
while(_462.length>3){
_462.pop();
}
var rgb=new dojo.gfx.color.Color(_45c);
var _467=new dojo.gfx.color.Color(_462);
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:rgb,end:_467}},_45d,_45e,{"beforeBegin":function(){
if(_464){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+rgb.toRgb().join(",")+")";
},"onEnd":function(){
if(_464){
node.style.backgroundImage=_464;
}
if(_465){
node.style.backgroundColor="transparent";
}
if(_45f){
_45f(node,anim);
}
}});
_460.push(anim);
});
return dojo.lfx.combine(_460);
};
dojo.lfx.html.unhighlight=function(_469,_46a,_46b,_46c,_46d){
_469=dojo.lfx.html._byId(_469);
var _46e=[];
dojo.lang.forEach(_469,function(node){
var _470=new dojo.gfx.color.Color(dojo.html.getBackgroundColor(node));
var rgb=new dojo.gfx.color.Color(_46a);
var _472=dojo.html.getStyle(node,"background-image");
var anim=dojo.lfx.propertyAnimation(node,{"background-color":{start:_470,end:rgb}},_46b,_46c,{"beforeBegin":function(){
if(_472){
node.style.backgroundImage="none";
}
node.style.backgroundColor="rgb("+_470.toRgb().join(",")+")";
},"onEnd":function(){
if(_46d){
_46d(node,anim);
}
}});
_46e.push(anim);
});
return dojo.lfx.combine(_46e);
};
dojo.lang.mixin(dojo.lfx,dojo.lfx.html);
dojo.kwCompoundRequire({browser:["dojo.lfx.html"],dashboard:["dojo.lfx.html"]});
dojo.provide("dojo.lfx.*");
dojo.provide("dojo.lang.extras");
dojo.lang.setTimeout=function(func,_475){
var _476=window,_477=2;
if(!dojo.lang.isFunction(func)){
_476=func;
func=_475;
_475=arguments[2];
_477++;
}
if(dojo.lang.isString(func)){
func=_476[func];
}
var args=[];
for(var i=_477;i<arguments.length;i++){
args.push(arguments[i]);
}
return dojo.global().setTimeout(function(){
func.apply(_476,args);
},_475);
};
dojo.lang.clearTimeout=function(_47a){
dojo.global().clearTimeout(_47a);
};
dojo.lang.getNameInObj=function(ns,item){
if(!ns){
ns=dj_global;
}
for(var x in ns){
if(ns[x]===item){
return new String(x);
}
}
return null;
};
dojo.lang.shallowCopy=function(obj,deep){
var i,ret;
if(obj===null){
return null;
}
if(dojo.lang.isObject(obj)){
ret=new obj.constructor();
for(i in obj){
if(dojo.lang.isUndefined(ret[i])){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}
}else{
if(dojo.lang.isArray(obj)){
ret=[];
for(i=0;i<obj.length;i++){
ret[i]=deep?dojo.lang.shallowCopy(obj[i],deep):obj[i];
}
}else{
ret=obj;
}
}
return ret;
};
dojo.lang.firstValued=function(){
for(var i=0;i<arguments.length;i++){
if(typeof arguments[i]!="undefined"){
return arguments[i];
}
}
return undefined;
};
dojo.lang.getObjPathValue=function(_483,_484,_485){
with(dojo.parseObjPath(_483,_484,_485)){
return dojo.evalProp(prop,obj,_485);
}
};
dojo.lang.setObjPathValue=function(_486,_487,_488,_489){
dojo.deprecated("dojo.lang.setObjPathValue","use dojo.parseObjPath and the '=' operator","0.6");
if(arguments.length<4){
_489=true;
}
with(dojo.parseObjPath(_486,_488,_489)){
if(obj&&(_489||(prop in obj))){
obj[prop]=_487;
}
}
};
dojo.provide("dojo.event.common");
dojo.event=new function(){
this._canTimeout=dojo.lang.isFunction(dj_global["setTimeout"])||dojo.lang.isAlien(dj_global["setTimeout"]);
function interpolateArgs(args,_48b){
var dl=dojo.lang;
var ao={srcObj:dj_global,srcFunc:null,adviceObj:dj_global,adviceFunc:null,aroundObj:null,aroundFunc:null,adviceType:(args.length>2)?args[0]:"after",precedence:"last",once:false,delay:null,rate:0,adviceMsg:false,maxCalls:-1};
switch(args.length){
case 0:
return;
case 1:
return;
case 2:
ao.srcFunc=args[0];
ao.adviceFunc=args[1];
break;
case 3:
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isString(args[1]))&&(dl.isString(args[2]))){
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
}else{
if((dl.isObject(args[0]))&&(dl.isString(args[1]))&&(dl.isFunction(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
var _48e=dl.nameAnonFunc(args[2],ao.adviceObj,_48b);
ao.adviceFunc=_48e;
}else{
if((dl.isFunction(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))){
ao.adviceType="after";
ao.srcObj=dj_global;
var _48e=dl.nameAnonFunc(args[0],ao.srcObj,_48b);
ao.srcFunc=_48e;
ao.adviceObj=args[1];
ao.adviceFunc=args[2];
}
}
}
}
break;
case 4:
if((dl.isObject(args[0]))&&(dl.isObject(args[2]))){
ao.adviceType="after";
ao.srcObj=args[0];
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isString(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isFunction(args[1]))&&(dl.isObject(args[2]))){
ao.adviceType=args[0];
ao.srcObj=dj_global;
var _48e=dl.nameAnonFunc(args[1],dj_global,_48b);
ao.srcFunc=_48e;
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
if((dl.isString(args[0]))&&(dl.isObject(args[1]))&&(dl.isString(args[2]))&&(dl.isFunction(args[3]))){
ao.srcObj=args[1];
ao.srcFunc=args[2];
var _48e=dl.nameAnonFunc(args[3],dj_global,_48b);
ao.adviceObj=dj_global;
ao.adviceFunc=_48e;
}else{
if(dl.isObject(args[1])){
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=dj_global;
ao.adviceFunc=args[3];
}else{
if(dl.isObject(args[2])){
ao.srcObj=dj_global;
ao.srcFunc=args[1];
ao.adviceObj=args[2];
ao.adviceFunc=args[3];
}else{
ao.srcObj=ao.adviceObj=ao.aroundObj=dj_global;
ao.srcFunc=args[1];
ao.adviceFunc=args[2];
ao.aroundFunc=args[3];
}
}
}
}
}
}
break;
case 6:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundFunc=args[5];
ao.aroundObj=dj_global;
break;
default:
ao.srcObj=args[1];
ao.srcFunc=args[2];
ao.adviceObj=args[3];
ao.adviceFunc=args[4];
ao.aroundObj=args[5];
ao.aroundFunc=args[6];
ao.once=args[7];
ao.delay=args[8];
ao.rate=args[9];
ao.adviceMsg=args[10];
ao.maxCalls=(!isNaN(parseInt(args[11])))?args[11]:-1;
break;
}
if(dl.isFunction(ao.aroundFunc)){
var _48e=dl.nameAnonFunc(ao.aroundFunc,ao.aroundObj,_48b);
ao.aroundFunc=_48e;
}
if(dl.isFunction(ao.srcFunc)){
ao.srcFunc=dl.getNameInObj(ao.srcObj,ao.srcFunc);
}
if(dl.isFunction(ao.adviceFunc)){
ao.adviceFunc=dl.getNameInObj(ao.adviceObj,ao.adviceFunc);
}
if((ao.aroundObj)&&(dl.isFunction(ao.aroundFunc))){
ao.aroundFunc=dl.getNameInObj(ao.aroundObj,ao.aroundFunc);
}
if(!ao.srcObj){
dojo.raise("bad srcObj for srcFunc: "+ao.srcFunc);
}
if(!ao.adviceObj){
dojo.raise("bad adviceObj for adviceFunc: "+ao.adviceFunc);
}
if(!ao.adviceFunc){
dojo.debug("bad adviceFunc for srcFunc: "+ao.srcFunc);
dojo.debugShallow(ao);
}
return ao;
}
this.connect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.connect(ao);
}
ao.srcFunc="onkeypress";
}
if(dojo.lang.isArray(ao.srcObj)&&ao.srcObj!=""){
var _490={};
for(var x in ao){
_490[x]=ao[x];
}
var mjps=[];
dojo.lang.forEach(ao.srcObj,function(src){
if((dojo.render.html.capable)&&(dojo.lang.isString(src))){
src=dojo.byId(src);
}
_490.srcObj=src;
mjps.push(dojo.event.connect.call(dojo.event,_490));
});
return mjps;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc);
if(ao.adviceFunc){
var mjp2=dojo.event.MethodJoinPoint.getForMethod(ao.adviceObj,ao.adviceFunc);
}
mjp.kwAddAdvice(ao);
return mjp;
};
this.log=function(a1,a2){
var _498;
if((arguments.length==1)&&(typeof a1=="object")){
_498=a1;
}else{
_498={srcObj:a1,srcFunc:a2};
}
_498.adviceFunc=function(){
var _499=[];
for(var x=0;x<arguments.length;x++){
_499.push(arguments[x]);
}
dojo.debug("("+_498.srcObj+")."+_498.srcFunc,":",_499.join(", "));
};
this.kwConnect(_498);
};
this.connectBefore=function(){
var args=["before"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectAround=function(){
var args=["around"];
for(var i=0;i<arguments.length;i++){
args.push(arguments[i]);
}
return this.connect.apply(this,args);
};
this.connectOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.once=true;
return this.connect(ao);
};
this.connectRunOnce=function(){
var ao=interpolateArgs(arguments,true);
ao.maxCalls=1;
return this.connect(ao);
};
this._kwConnectImpl=function(_4a1,_4a2){
var fn=(_4a2)?"disconnect":"connect";
if(typeof _4a1["srcFunc"]=="function"){
_4a1.srcObj=_4a1["srcObj"]||dj_global;
var _4a4=dojo.lang.nameAnonFunc(_4a1.srcFunc,_4a1.srcObj,true);
_4a1.srcFunc=_4a4;
}
if(typeof _4a1["adviceFunc"]=="function"){
_4a1.adviceObj=_4a1["adviceObj"]||dj_global;
var _4a4=dojo.lang.nameAnonFunc(_4a1.adviceFunc,_4a1.adviceObj,true);
_4a1.adviceFunc=_4a4;
}
_4a1.srcObj=_4a1["srcObj"]||dj_global;
_4a1.adviceObj=_4a1["adviceObj"]||_4a1["targetObj"]||dj_global;
_4a1.adviceFunc=_4a1["adviceFunc"]||_4a1["targetFunc"];
return dojo.event[fn](_4a1);
};
this.kwConnect=function(_4a5){
return this._kwConnectImpl(_4a5,false);
};
this.disconnect=function(){
if(arguments.length==1){
var ao=arguments[0];
}else{
var ao=interpolateArgs(arguments,true);
}
if(!ao.adviceFunc){
return;
}
if(dojo.lang.isString(ao.srcFunc)&&(ao.srcFunc.toLowerCase()=="onkey")){
if(dojo.render.html.ie){
ao.srcFunc="onkeydown";
this.disconnect(ao);
}
ao.srcFunc="onkeypress";
}
if(!ao.srcObj[ao.srcFunc]){
return null;
}
var mjp=dojo.event.MethodJoinPoint.getForMethod(ao.srcObj,ao.srcFunc,true);
mjp.removeAdvice(ao.adviceObj,ao.adviceFunc,ao.adviceType,ao.once);
return mjp;
};
this.kwDisconnect=function(_4a8){
return this._kwConnectImpl(_4a8,true);
};
};
dojo.event.MethodInvocation=function(_4a9,obj,args){
this.jp_=_4a9;
this.object=obj;
this.args=[];
for(var x=0;x<args.length;x++){
this.args[x]=args[x];
}
this.around_index=-1;
};
dojo.event.MethodInvocation.prototype.proceed=function(){
this.around_index++;
if(this.around_index>=this.jp_.around.length){
return this.jp_.object[this.jp_.methodname].apply(this.jp_.object,this.args);
}else{
var ti=this.jp_.around[this.around_index];
var mobj=ti[0]||dj_global;
var meth=ti[1];
return mobj[meth].call(mobj,this);
}
};
dojo.event.MethodJoinPoint=function(obj,_4b1){
this.object=obj||dj_global;
this.methodname=_4b1;
this.methodfunc=this.object[_4b1];
this.squelch=false;
};
dojo.event.MethodJoinPoint.getForMethod=function(obj,_4b3){
if(!obj){
obj=dj_global;
}
var ofn=obj[_4b3];
if(!ofn){
ofn=obj[_4b3]=function(){
};
if(!obj[_4b3]){
dojo.raise("Cannot set do-nothing method on that object "+_4b3);
}
}else{
if((typeof ofn!="function")&&(!dojo.lang.isFunction(ofn))&&(!dojo.lang.isAlien(ofn))){
return null;
}
}
var _4b5=_4b3+"$joinpoint";
var _4b6=_4b3+"$joinpoint$method";
var _4b7=obj[_4b5];
if(!_4b7){
var _4b8=false;
if(dojo.event["browser"]){
if((obj["attachEvent"])||(obj["nodeType"])||(obj["addEventListener"])){
_4b8=true;
dojo.event.browser.addClobberNodeAttrs(obj,[_4b5,_4b6,_4b3]);
}
}
var _4b9=ofn.length;
obj[_4b6]=ofn;
_4b7=obj[_4b5]=new dojo.event.MethodJoinPoint(obj,_4b6);
if(!_4b8){
obj[_4b3]=function(){
return _4b7.run.apply(_4b7,arguments);
};
}else{
obj[_4b3]=function(){
var args=[];
if(!arguments.length){
var evt=null;
try{
if(obj.ownerDocument){
evt=obj.ownerDocument.parentWindow.event;
}else{
if(obj.documentElement){
evt=obj.documentElement.ownerDocument.parentWindow.event;
}else{
if(obj.event){
evt=obj.event;
}else{
evt=window.event;
}
}
}
}
catch(e){
evt=window.event;
}
if(evt){
args.push(dojo.event.browser.fixEvent(evt,this));
}
}else{
for(var x=0;x<arguments.length;x++){
if((x==0)&&(dojo.event.browser.isEvent(arguments[x]))){
args.push(dojo.event.browser.fixEvent(arguments[x],this));
}else{
args.push(arguments[x]);
}
}
}
return _4b7.run.apply(_4b7,args);
};
}
obj[_4b3].__preJoinArity=_4b9;
}
return _4b7;
};
dojo.lang.extend(dojo.event.MethodJoinPoint,{squelch:false,unintercept:function(){
this.object[this.methodname]=this.methodfunc;
this.before=[];
this.after=[];
this.around=[];
},disconnect:dojo.lang.forward("unintercept"),run:function(){
var obj=this.object||dj_global;
var args=arguments;
var _4bf=[];
for(var x=0;x<args.length;x++){
_4bf[x]=args[x];
}
var _4c1=function(marr){
if(!marr){
dojo.debug("Null argument to unrollAdvice()");
return;
}
var _4c3=marr[0]||dj_global;
var _4c4=marr[1];
if(!_4c3[_4c4]){
dojo.raise("function \""+_4c4+"\" does not exist on \""+_4c3+"\"");
}
var _4c5=marr[2]||dj_global;
var _4c6=marr[3];
var msg=marr[6];
var _4c8=marr[7];
if(_4c8>-1){
if(_4c8==0){
return;
}
marr[7]--;
}
var _4c9;
var to={args:[],jp_:this,object:obj,proceed:function(){
return _4c3[_4c4].apply(_4c3,to.args);
}};
to.args=_4bf;
var _4cb=parseInt(marr[4]);
var _4cc=((!isNaN(_4cb))&&(marr[4]!==null)&&(typeof marr[4]!="undefined"));
if(marr[5]){
var rate=parseInt(marr[5]);
var cur=new Date();
var _4cf=false;
if((marr["last"])&&((cur-marr.last)<=rate)){
if(dojo.event._canTimeout){
if(marr["delayTimer"]){
clearTimeout(marr.delayTimer);
}
var tod=parseInt(rate*2);
var mcpy=dojo.lang.shallowCopy(marr);
marr.delayTimer=setTimeout(function(){
mcpy[5]=0;
_4c1(mcpy);
},tod);
}
return;
}else{
marr.last=cur;
}
}
if(_4c6){
_4c5[_4c6].call(_4c5,to);
}else{
if((_4cc)&&((dojo.render.html)||(dojo.render.svg))){
dj_global["setTimeout"](function(){
if(msg){
_4c3[_4c4].call(_4c3,to);
}else{
_4c3[_4c4].apply(_4c3,args);
}
},_4cb);
}else{
if(msg){
_4c3[_4c4].call(_4c3,to);
}else{
_4c3[_4c4].apply(_4c3,args);
}
}
}
};
var _4d2=function(){
if(this.squelch){
try{
return _4c1.apply(this,arguments);
}
catch(e){
dojo.debug(e);
}
}else{
return _4c1.apply(this,arguments);
}
};
if((this["before"])&&(this.before.length>0)){
dojo.lang.forEach(this.before.concat(new Array()),_4d2);
}
var _4d3;
try{
if((this["around"])&&(this.around.length>0)){
var mi=new dojo.event.MethodInvocation(this,obj,args);
_4d3=mi.proceed();
}else{
if(this.methodfunc){
_4d3=this.object[this.methodname].apply(this.object,args);
}
}
}
catch(e){
if(!this.squelch){
dojo.debug(e,"when calling",this.methodname,"on",this.object,"with arguments",args);
dojo.raise(e);
}
}
if((this["after"])&&(this.after.length>0)){
dojo.lang.forEach(this.after.concat(new Array()),_4d2);
}
return (this.methodfunc)?_4d3:null;
},getArr:function(kind){
var type="after";
if((typeof kind=="string")&&(kind.indexOf("before")!=-1)){
type="before";
}else{
if(kind=="around"){
type="around";
}
}
if(!this[type]){
this[type]=[];
}
return this[type];
},kwAddAdvice:function(args){
this.addAdvice(args["adviceObj"],args["adviceFunc"],args["aroundObj"],args["aroundFunc"],args["adviceType"],args["precedence"],args["once"],args["delay"],args["rate"],args["adviceMsg"],args["maxCalls"]);
},addAdvice:function(_4d8,_4d9,_4da,_4db,_4dc,_4dd,once,_4df,rate,_4e1,_4e2){
var arr=this.getArr(_4dc);
if(!arr){
dojo.raise("bad this: "+this);
}
var ao=[_4d8,_4d9,_4da,_4db,_4df,rate,_4e1,_4e2];
if(once){
if(this.hasAdvice(_4d8,_4d9,_4dc,arr)>=0){
return;
}
}
if(_4dd=="first"){
arr.unshift(ao);
}else{
arr.push(ao);
}
},hasAdvice:function(_4e5,_4e6,_4e7,arr){
if(!arr){
arr=this.getArr(_4e7);
}
var ind=-1;
for(var x=0;x<arr.length;x++){
var aao=(typeof _4e6=="object")?(new String(_4e6)).toString():_4e6;
var a1o=(typeof arr[x][1]=="object")?(new String(arr[x][1])).toString():arr[x][1];
if((arr[x][0]==_4e5)&&(a1o==aao)){
ind=x;
}
}
return ind;
},removeAdvice:function(_4ed,_4ee,_4ef,once){
var arr=this.getArr(_4ef);
var ind=this.hasAdvice(_4ed,_4ee,_4ef,arr);
if(ind==-1){
return false;
}
while(ind!=-1){
arr.splice(ind,1);
if(once){
break;
}
ind=this.hasAdvice(_4ed,_4ee,_4ef,arr);
}
return true;
}});
dojo.provide("dojo.event.topic");
dojo.event.topic=new function(){
this.topics={};
this.getTopic=function(_4f3){
if(!this.topics[_4f3]){
this.topics[_4f3]=new this.TopicImpl(_4f3);
}
return this.topics[_4f3];
};
this.registerPublisher=function(_4f4,obj,_4f6){
var _4f4=this.getTopic(_4f4);
_4f4.registerPublisher(obj,_4f6);
};
this.subscribe=function(_4f7,obj,_4f9){
var _4f7=this.getTopic(_4f7);
_4f7.subscribe(obj,_4f9);
};
this.unsubscribe=function(_4fa,obj,_4fc){
var _4fa=this.getTopic(_4fa);
_4fa.unsubscribe(obj,_4fc);
};
this.destroy=function(_4fd){
this.getTopic(_4fd).destroy();
delete this.topics[_4fd];
};
this.publishApply=function(_4fe,args){
var _4fe=this.getTopic(_4fe);
_4fe.sendMessage.apply(_4fe,args);
};
this.publish=function(_500,_501){
var _500=this.getTopic(_500);
var args=[];
for(var x=1;x<arguments.length;x++){
args.push(arguments[x]);
}
_500.sendMessage.apply(_500,args);
};
};
dojo.event.topic.TopicImpl=function(_504){
this.topicName=_504;
this.subscribe=function(_505,_506){
var tf=_506||_505;
var to=(!_506)?dj_global:_505;
return dojo.event.kwConnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this.unsubscribe=function(_509,_50a){
var tf=(!_50a)?_509:_50a;
var to=(!_50a)?null:_509;
return dojo.event.kwDisconnect({srcObj:this,srcFunc:"sendMessage",adviceObj:to,adviceFunc:tf});
};
this._getJoinPoint=function(){
return dojo.event.MethodJoinPoint.getForMethod(this,"sendMessage");
};
this.setSquelch=function(_50d){
this._getJoinPoint().squelch=_50d;
};
this.destroy=function(){
this._getJoinPoint().disconnect();
};
this.registerPublisher=function(_50e,_50f){
dojo.event.connect(_50e,_50f,this,"sendMessage");
};
this.sendMessage=function(_510){
};
};
dojo.provide("dojo.event.browser");
dojo._ie_clobber=new function(){
this.clobberNodes=[];
function nukeProp(node,prop){
try{
node[prop]=null;
}
catch(e){
}
try{
delete node[prop];
}
catch(e){
}
try{
node.removeAttribute(prop);
}
catch(e){
}
}
this.clobber=function(_513){
var na;
var tna;
if(_513){
tna=_513.all||_513.getElementsByTagName("*");
na=[_513];
for(var x=0;x<tna.length;x++){
if(tna[x]["__doClobber__"]){
na.push(tna[x]);
}
}
}else{
try{
window.onload=null;
}
catch(e){
}
na=(this.clobberNodes.length)?this.clobberNodes:document.all;
}
tna=null;
var _517={};
for(var i=na.length-1;i>=0;i=i-1){
var el=na[i];
try{
if(el&&el["__clobberAttrs__"]){
for(var j=0;j<el.__clobberAttrs__.length;j++){
nukeProp(el,el.__clobberAttrs__[j]);
}
nukeProp(el,"__clobberAttrs__");
nukeProp(el,"__doClobber__");
}
}
catch(e){
}
}
na=null;
};
};
if(dojo.render.html.ie){
dojo.addOnUnload(function(){
dojo._ie_clobber.clobber();
try{
if((dojo["widget"])&&(dojo.widget["manager"])){
dojo.widget.manager.destroyAll();
}
}
catch(e){
}
if(dojo.widget){
for(var name in dojo.widget._templateCache){
if(dojo.widget._templateCache[name].node){
dojo.dom.destroyNode(dojo.widget._templateCache[name].node);
dojo.widget._templateCache[name].node=null;
delete dojo.widget._templateCache[name].node;
}
}
}
try{
window.onload=null;
}
catch(e){
}
try{
window.onunload=null;
}
catch(e){
}
dojo._ie_clobber.clobberNodes=[];
});
}
dojo.event.browser=new function(){
var _51c=0;
this.normalizedEventName=function(_51d){
switch(_51d){
case "CheckboxStateChange":
case "DOMAttrModified":
case "DOMMenuItemActive":
case "DOMMenuItemInactive":
case "DOMMouseScroll":
case "DOMNodeInserted":
case "DOMNodeRemoved":
case "RadioStateChange":
return _51d;
break;
default:
var lcn=_51d.toLowerCase();
return (lcn.indexOf("on")==0)?lcn.substr(2):lcn;
break;
}
};
this.clean=function(node){
if(dojo.render.html.ie){
dojo._ie_clobber.clobber(node);
}
};
this.addClobberNode=function(node){
if(!dojo.render.html.ie){
return;
}
if(!node["__doClobber__"]){
node.__doClobber__=true;
dojo._ie_clobber.clobberNodes.push(node);
node.__clobberAttrs__=[];
}
};
this.addClobberNodeAttrs=function(node,_522){
if(!dojo.render.html.ie){
return;
}
this.addClobberNode(node);
for(var x=0;x<_522.length;x++){
node.__clobberAttrs__.push(_522[x]);
}
};
this.removeListener=function(node,_525,fp,_527){
if(!_527){
var _527=false;
}
_525=dojo.event.browser.normalizedEventName(_525);
if(_525=="key"){
if(dojo.render.html.ie){
this.removeListener(node,"onkeydown",fp,_527);
}
_525="keypress";
}
if(node.removeEventListener){
node.removeEventListener(_525,fp,_527);
}
};
this.addListener=function(node,_529,fp,_52b,_52c){
if(!node){
return;
}
if(!_52b){
var _52b=false;
}
_529=dojo.event.browser.normalizedEventName(_529);
if(_529=="key"){
if(dojo.render.html.ie){
this.addListener(node,"onkeydown",fp,_52b,_52c);
}
_529="keypress";
}
if(!_52c){
var _52d=function(evt){
if(!evt){
evt=window.event;
}
var ret=fp(dojo.event.browser.fixEvent(evt,this));
if(_52b){
dojo.event.browser.stopEvent(evt);
}
return ret;
};
}else{
_52d=fp;
}
if(node.addEventListener){
node.addEventListener(_529,_52d,_52b);
return _52d;
}else{
_529="on"+_529;
if(typeof node[_529]=="function"){
var _530=node[_529];
node[_529]=function(e){
_530(e);
return _52d(e);
};
}else{
node[_529]=_52d;
}
if(dojo.render.html.ie){
this.addClobberNodeAttrs(node,[_529]);
}
return _52d;
}
};
this.isEvent=function(obj){
return (typeof obj!="undefined")&&(obj)&&(typeof Event!="undefined")&&(obj.eventPhase);
};
this.currentEvent=null;
this.callListener=function(_533,_534){
if(typeof _533!="function"){
dojo.raise("listener not a function: "+_533);
}
dojo.event.browser.currentEvent.currentTarget=_534;
return _533.call(_534,dojo.event.browser.currentEvent);
};
this._stopPropagation=function(){
dojo.event.browser.currentEvent.cancelBubble=true;
};
this._preventDefault=function(){
dojo.event.browser.currentEvent.returnValue=false;
};
this.keys={KEY_BACKSPACE:8,KEY_TAB:9,KEY_CLEAR:12,KEY_ENTER:13,KEY_SHIFT:16,KEY_CTRL:17,KEY_ALT:18,KEY_PAUSE:19,KEY_CAPS_LOCK:20,KEY_ESCAPE:27,KEY_SPACE:32,KEY_PAGE_UP:33,KEY_PAGE_DOWN:34,KEY_END:35,KEY_HOME:36,KEY_LEFT_ARROW:37,KEY_UP_ARROW:38,KEY_RIGHT_ARROW:39,KEY_DOWN_ARROW:40,KEY_INSERT:45,KEY_DELETE:46,KEY_HELP:47,KEY_LEFT_WINDOW:91,KEY_RIGHT_WINDOW:92,KEY_SELECT:93,KEY_NUMPAD_0:96,KEY_NUMPAD_1:97,KEY_NUMPAD_2:98,KEY_NUMPAD_3:99,KEY_NUMPAD_4:100,KEY_NUMPAD_5:101,KEY_NUMPAD_6:102,KEY_NUMPAD_7:103,KEY_NUMPAD_8:104,KEY_NUMPAD_9:105,KEY_NUMPAD_MULTIPLY:106,KEY_NUMPAD_PLUS:107,KEY_NUMPAD_ENTER:108,KEY_NUMPAD_MINUS:109,KEY_NUMPAD_PERIOD:110,KEY_NUMPAD_DIVIDE:111,KEY_F1:112,KEY_F2:113,KEY_F3:114,KEY_F4:115,KEY_F5:116,KEY_F6:117,KEY_F7:118,KEY_F8:119,KEY_F9:120,KEY_F10:121,KEY_F11:122,KEY_F12:123,KEY_F13:124,KEY_F14:125,KEY_F15:126,KEY_NUM_LOCK:144,KEY_SCROLL_LOCK:145};
this.revKeys=[];
for(var key in this.keys){
this.revKeys[this.keys[key]]=key;
}
this.fixEvent=function(evt,_537){
if(!evt){
if(window["event"]){
evt=window.event;
}
}
if((evt["type"])&&(evt["type"].indexOf("key")==0)){
evt.keys=this.revKeys;
for(var key in this.keys){
evt[key]=this.keys[key];
}
if(evt["type"]=="keydown"&&dojo.render.html.ie){
switch(evt.keyCode){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_LEFT_WINDOW:
case evt.KEY_RIGHT_WINDOW:
case evt.KEY_SELECT:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
case evt.KEY_NUMPAD_0:
case evt.KEY_NUMPAD_1:
case evt.KEY_NUMPAD_2:
case evt.KEY_NUMPAD_3:
case evt.KEY_NUMPAD_4:
case evt.KEY_NUMPAD_5:
case evt.KEY_NUMPAD_6:
case evt.KEY_NUMPAD_7:
case evt.KEY_NUMPAD_8:
case evt.KEY_NUMPAD_9:
case evt.KEY_NUMPAD_PERIOD:
break;
case evt.KEY_NUMPAD_MULTIPLY:
case evt.KEY_NUMPAD_PLUS:
case evt.KEY_NUMPAD_ENTER:
case evt.KEY_NUMPAD_MINUS:
case evt.KEY_NUMPAD_DIVIDE:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
case evt.KEY_PAGE_UP:
case evt.KEY_PAGE_DOWN:
case evt.KEY_END:
case evt.KEY_HOME:
case evt.KEY_LEFT_ARROW:
case evt.KEY_UP_ARROW:
case evt.KEY_RIGHT_ARROW:
case evt.KEY_DOWN_ARROW:
case evt.KEY_INSERT:
case evt.KEY_DELETE:
case evt.KEY_F1:
case evt.KEY_F2:
case evt.KEY_F3:
case evt.KEY_F4:
case evt.KEY_F5:
case evt.KEY_F6:
case evt.KEY_F7:
case evt.KEY_F8:
case evt.KEY_F9:
case evt.KEY_F10:
case evt.KEY_F11:
case evt.KEY_F12:
case evt.KEY_F12:
case evt.KEY_F13:
case evt.KEY_F14:
case evt.KEY_F15:
case evt.KEY_CLEAR:
case evt.KEY_HELP:
evt.key=evt.keyCode;
break;
default:
if(evt.ctrlKey||evt.altKey){
var _539=evt.keyCode;
if(_539>=65&&_539<=90&&evt.shiftKey==false){
_539+=32;
}
if(_539>=1&&_539<=26&&evt.ctrlKey){
_539+=96;
}
evt.key=String.fromCharCode(_539);
}
}
}else{
if(evt["type"]=="keypress"){
if(dojo.render.html.opera){
if(evt.which==0){
evt.key=evt.keyCode;
}else{
if(evt.which>0){
switch(evt.which){
case evt.KEY_SHIFT:
case evt.KEY_CTRL:
case evt.KEY_ALT:
case evt.KEY_CAPS_LOCK:
case evt.KEY_NUM_LOCK:
case evt.KEY_SCROLL_LOCK:
break;
case evt.KEY_PAUSE:
case evt.KEY_TAB:
case evt.KEY_BACKSPACE:
case evt.KEY_ENTER:
case evt.KEY_ESCAPE:
evt.key=evt.which;
break;
default:
var _539=evt.which;
if((evt.ctrlKey||evt.altKey||evt.metaKey)&&(evt.which>=65&&evt.which<=90&&evt.shiftKey==false)){
_539+=32;
}
evt.key=String.fromCharCode(_539);
}
}
}
}else{
if(dojo.render.html.ie){
if(!evt.ctrlKey&&!evt.altKey&&evt.keyCode>=evt.KEY_SPACE){
evt.key=String.fromCharCode(evt.keyCode);
}
}else{
if(dojo.render.html.safari){
switch(evt.keyCode){
case 25:
evt.key=evt.KEY_TAB;
evt.shift=true;
break;
case 63232:
evt.key=evt.KEY_UP_ARROW;
break;
case 63233:
evt.key=evt.KEY_DOWN_ARROW;
break;
case 63234:
evt.key=evt.KEY_LEFT_ARROW;
break;
case 63235:
evt.key=evt.KEY_RIGHT_ARROW;
break;
case 63236:
evt.key=evt.KEY_F1;
break;
case 63237:
evt.key=evt.KEY_F2;
break;
case 63238:
evt.key=evt.KEY_F3;
break;
case 63239:
evt.key=evt.KEY_F4;
break;
case 63240:
evt.key=evt.KEY_F5;
break;
case 63241:
evt.key=evt.KEY_F6;
break;
case 63242:
evt.key=evt.KEY_F7;
break;
case 63243:
evt.key=evt.KEY_F8;
break;
case 63244:
evt.key=evt.KEY_F9;
break;
case 63245:
evt.key=evt.KEY_F10;
break;
case 63246:
evt.key=evt.KEY_F11;
break;
case 63247:
evt.key=evt.KEY_F12;
break;
case 63250:
evt.key=evt.KEY_PAUSE;
break;
case 63272:
evt.key=evt.KEY_DELETE;
break;
case 63273:
evt.key=evt.KEY_HOME;
break;
case 63275:
evt.key=evt.KEY_END;
break;
case 63276:
evt.key=evt.KEY_PAGE_UP;
break;
case 63277:
evt.key=evt.KEY_PAGE_DOWN;
break;
case 63302:
evt.key=evt.KEY_INSERT;
break;
case 63248:
case 63249:
case 63289:
break;
default:
evt.key=evt.charCode>=evt.KEY_SPACE?String.fromCharCode(evt.charCode):evt.keyCode;
}
}else{
evt.key=evt.charCode>0?String.fromCharCode(evt.charCode):evt.keyCode;
}
}
}
}
}
}
if(dojo.render.html.ie){
if(!evt.target){
evt.target=evt.srcElement;
}
if(!evt.currentTarget){
evt.currentTarget=(_537?_537:evt.srcElement);
}
if(!evt.layerX){
evt.layerX=evt.offsetX;
}
if(!evt.layerY){
evt.layerY=evt.offsetY;
}
var doc=(evt.srcElement&&evt.srcElement.ownerDocument)?evt.srcElement.ownerDocument:document;
var _53b=((dojo.render.html.ie55)||(doc["compatMode"]=="BackCompat"))?doc.body:doc.documentElement;
if(!evt.pageX){
evt.pageX=evt.clientX+(_53b.scrollLeft||0);
}
if(!evt.pageY){
evt.pageY=evt.clientY+(_53b.scrollTop||0);
}
if(evt.type=="mouseover"){
evt.relatedTarget=evt.fromElement;
}
if(evt.type=="mouseout"){
evt.relatedTarget=evt.toElement;
}
this.currentEvent=evt;
evt.callListener=this.callListener;
evt.stopPropagation=this._stopPropagation;
evt.preventDefault=this._preventDefault;
}
return evt;
};
this.stopEvent=function(evt){
if(window.event){
evt.cancelBubble=true;
evt.returnValue=false;
}else{
evt.preventDefault();
evt.stopPropagation();
}
};
};
dojo.kwCompoundRequire({common:["dojo.event.common","dojo.event.topic"],browser:["dojo.event.browser"],dashboard:["dojo.event.browser"]});
dojo.provide("dojo.event.*");
dojo.provide("dojo.lang.declare");
dojo.lang.declare=function(_53d,_53e,init,_540){
if((dojo.lang.isFunction(_540))||((!_540)&&(!dojo.lang.isFunction(init)))){
var temp=_540;
_540=init;
init=temp;
}
var _542=[];
if(dojo.lang.isArray(_53e)){
_542=_53e;
_53e=_542.shift();
}
if(!init){
init=dojo.evalObjPath(_53d,false);
if((init)&&(!dojo.lang.isFunction(init))){
init=null;
}
}
var ctor=dojo.lang.declare._makeConstructor();
var scp=(_53e?_53e.prototype:null);
if(scp){
scp.prototyping=true;
ctor.prototype=new _53e();
scp.prototyping=false;
}
ctor.superclass=scp;
ctor.mixins=_542;
for(var i=0,l=_542.length;i<l;i++){
dojo.lang.extend(ctor,_542[i].prototype);
}
ctor.prototype.initializer=null;
ctor.prototype.declaredClass=_53d;
if(dojo.lang.isArray(_540)){
dojo.lang.extend.apply(dojo.lang,[ctor].concat(_540));
}else{
dojo.lang.extend(ctor,(_540)||{});
}
dojo.lang.extend(ctor,dojo.lang.declare._common);
ctor.prototype.constructor=ctor;
ctor.prototype.initializer=(ctor.prototype.initializer)||(init)||(function(){
});
var _547=dojo.parseObjPath(_53d,null,true);
_547.obj[_547.prop]=ctor;
return ctor;
};
dojo.lang.declare._makeConstructor=function(){
return function(){
var self=this._getPropContext();
var s=self.constructor.superclass;
if((s)&&(s.constructor)){
if(s.constructor==arguments.callee){
this._inherited("constructor",arguments);
}else{
this._contextMethod(s,"constructor",arguments);
}
}
var ms=(self.constructor.mixins)||([]);
for(var i=0,m;(m=ms[i]);i++){
(((m.prototype)&&(m.prototype.initializer))||(m)).apply(this,arguments);
}
if((!this.prototyping)&&(self.initializer)){
self.initializer.apply(this,arguments);
}
};
};
dojo.lang.declare._common={_getPropContext:function(){
return (this.___proto||this);
},_contextMethod:function(_54d,_54e,args){
var _550,_551=this.___proto;
this.___proto=_54d;
try{
_550=_54d[_54e].apply(this,(args||[]));
}
catch(e){
throw e;
}
finally{
this.___proto=_551;
}
return _550;
},_inherited:function(prop,args){
var p=this._getPropContext();
do{
if((!p.constructor)||(!p.constructor.superclass)){
return;
}
p=p.constructor.superclass;
}while(!(prop in p));
return (dojo.lang.isFunction(p[prop])?this._contextMethod(p,prop,args):p[prop]);
},inherited:function(prop,args){
dojo.deprecated("'inherited' method is dangerous, do not up-call! 'inherited' is slated for removal in 0.5; name your super class (or use superclass property) instead.","0.5");
this._inherited(prop,args);
}};
dojo.declare=dojo.lang.declare;
dojo.provide("dojo.logging.Logger");
dojo.provide("dojo.logging.LogFilter");
dojo.provide("dojo.logging.Record");
dojo.provide("dojo.log");
dojo.logging.Record=function(_557,_558){
this.level=_557;
this.message="";
this.msgArgs=[];
this.time=new Date();
if(dojo.lang.isArray(_558)){
if(_558.length>0&&dojo.lang.isString(_558[0])){
this.message=_558.shift();
}
this.msgArgs=_558;
}else{
this.message=_558;
}
};
dojo.logging.LogFilter=function(_559){
this.passChain=_559||"";
this.filter=function(_55a){
return true;
};
};
dojo.logging.Logger=function(){
this.cutOffLevel=0;
this.propagate=true;
this.parent=null;
this.data=[];
this.filters=[];
this.handlers=[];
};
dojo.extend(dojo.logging.Logger,{_argsToArr:function(args){
var ret=[];
for(var x=0;x<args.length;x++){
ret.push(args[x]);
}
return ret;
},setLevel:function(lvl){
this.cutOffLevel=parseInt(lvl);
},isEnabledFor:function(lvl){
return parseInt(lvl)>=this.cutOffLevel;
},getEffectiveLevel:function(){
if((this.cutOffLevel==0)&&(this.parent)){
return this.parent.getEffectiveLevel();
}
return this.cutOffLevel;
},addFilter:function(flt){
this.filters.push(flt);
return this.filters.length-1;
},removeFilterByIndex:function(_561){
if(this.filters[_561]){
delete this.filters[_561];
return true;
}
return false;
},removeFilter:function(_562){
for(var x=0;x<this.filters.length;x++){
if(this.filters[x]===_562){
delete this.filters[x];
return true;
}
}
return false;
},removeAllFilters:function(){
this.filters=[];
},filter:function(rec){
for(var x=0;x<this.filters.length;x++){
if((this.filters[x]["filter"])&&(!this.filters[x].filter(rec))||(rec.level<this.cutOffLevel)){
return false;
}
}
return true;
},addHandler:function(hdlr){
this.handlers.push(hdlr);
return this.handlers.length-1;
},handle:function(rec){
if((!this.filter(rec))||(rec.level<this.cutOffLevel)){
return false;
}
for(var x=0;x<this.handlers.length;x++){
if(this.handlers[x]["handle"]){
this.handlers[x].handle(rec);
}
}
return true;
},log:function(lvl,msg){
if((this.propagate)&&(this.parent)&&(this.parent.rec.level>=this.cutOffLevel)){
this.parent.log(lvl,msg);
return false;
}
this.handle(new dojo.logging.Record(lvl,msg));
return true;
},debug:function(msg){
return this.logType("DEBUG",this._argsToArr(arguments));
},info:function(msg){
return this.logType("INFO",this._argsToArr(arguments));
},warning:function(msg){
return this.logType("WARNING",this._argsToArr(arguments));
},error:function(msg){
return this.logType("ERROR",this._argsToArr(arguments));
},critical:function(msg){
return this.logType("CRITICAL",this._argsToArr(arguments));
},exception:function(msg,e,_572){
if(e){
var _573=[e.name,(e.description||e.message)];
if(e.fileName){
_573.push(e.fileName);
_573.push("line "+e.lineNumber);
}
msg+=" "+_573.join(" : ");
}
this.logType("ERROR",msg);
if(!_572){
throw e;
}
},logType:function(type,args){
return this.log.apply(this,[dojo.logging.log.getLevel(type),args]);
},warn:function(){
this.warning.apply(this,arguments);
},err:function(){
this.error.apply(this,arguments);
},crit:function(){
this.critical.apply(this,arguments);
}});
dojo.logging.LogHandler=function(_576){
this.cutOffLevel=(_576)?_576:0;
this.formatter=null;
this.data=[];
this.filters=[];
};
dojo.lang.extend(dojo.logging.LogHandler,{setFormatter:function(_577){
dojo.unimplemented("setFormatter");
},flush:function(){
},close:function(){
},handleError:function(){
dojo.deprecated("dojo.logging.LogHandler.handleError","use handle()","0.6");
},handle:function(_578){
if((this.filter(_578))&&(_578.level>=this.cutOffLevel)){
this.emit(_578);
}
},emit:function(_579){
dojo.unimplemented("emit");
}});
void (function(){
var _57a=["setLevel","addFilter","removeFilterByIndex","removeFilter","removeAllFilters","filter"];
var tgt=dojo.logging.LogHandler.prototype;
var src=dojo.logging.Logger.prototype;
for(var x=0;x<_57a.length;x++){
tgt[_57a[x]]=src[_57a[x]];
}
})();
dojo.logging.log=new dojo.logging.Logger();
dojo.logging.log.levels=[{"name":"DEBUG","level":1},{"name":"INFO","level":2},{"name":"WARNING","level":3},{"name":"ERROR","level":4},{"name":"CRITICAL","level":5}];
dojo.logging.log.loggers={};
dojo.logging.log.getLogger=function(name){
if(!this.loggers[name]){
this.loggers[name]=new dojo.logging.Logger();
this.loggers[name].parent=this;
}
return this.loggers[name];
};
dojo.logging.log.getLevelName=function(lvl){
for(var x=0;x<this.levels.length;x++){
if(this.levels[x].level==lvl){
return this.levels[x].name;
}
}
return null;
};
dojo.logging.log.getLevel=function(name){
for(var x=0;x<this.levels.length;x++){
if(this.levels[x].name.toUpperCase()==name.toUpperCase()){
return this.levels[x].level;
}
}
return null;
};
dojo.declare("dojo.logging.MemoryLogHandler",dojo.logging.LogHandler,{initializer:function(_583,_584,_585,_586){
dojo.logging.LogHandler.call(this,_583);
this.numRecords=(typeof djConfig["loggingNumRecords"]!="undefined")?djConfig["loggingNumRecords"]:((_584)?_584:-1);
this.postType=(typeof djConfig["loggingPostType"]!="undefined")?djConfig["loggingPostType"]:(_585||-1);
this.postInterval=(typeof djConfig["loggingPostInterval"]!="undefined")?djConfig["loggingPostInterval"]:(_585||-1);
},emit:function(_587){
if(!djConfig.isDebug){
return;
}
var _588=String(dojo.log.getLevelName(_587.level)+": "+_587.time.toLocaleTimeString())+": "+_587.message;
if(!dj_undef("println",dojo.hostenv)){
dojo.hostenv.println(_588,_587.msgArgs);
}
this.data.push(_587);
if(this.numRecords!=-1){
while(this.data.length>this.numRecords){
this.data.shift();
}
}
}});
dojo.logging.logQueueHandler=new dojo.logging.MemoryLogHandler(0,50,0,10000);
dojo.logging.log.addHandler(dojo.logging.logQueueHandler);
dojo.log=dojo.logging.log;
dojo.kwCompoundRequire({common:[["dojo.logging.Logger",false,false]],rhino:["dojo.logging.RhinoLogger"]});
dojo.provide("dojo.logging.*");
dojo.provide("dojo.string.common");
dojo.string.trim=function(str,wh){
if(!str.replace){
return str;
}
if(!str.length){
return str;
}
var re=(wh>0)?(/^\s+/):(wh<0)?(/\s+$/):(/^\s+|\s+$/g);
return str.replace(re,"");
};
dojo.string.trimStart=function(str){
return dojo.string.trim(str,1);
};
dojo.string.trimEnd=function(str){
return dojo.string.trim(str,-1);
};
dojo.string.repeat=function(str,_58f,_590){
var out="";
for(var i=0;i<_58f;i++){
out+=str;
if(_590&&i<_58f-1){
out+=_590;
}
}
return out;
};
dojo.string.pad=function(str,len,c,dir){
var out=String(str);
if(!c){
c="0";
}
if(!dir){
dir=1;
}
while(out.length<len){
if(dir>0){
out=c+out;
}else{
out+=c;
}
}
return out;
};
dojo.string.padLeft=function(str,len,c){
return dojo.string.pad(str,len,c,1);
};
dojo.string.padRight=function(str,len,c){
return dojo.string.pad(str,len,c,-1);
};
dojo.provide("dojo.string");
dojo.provide("dojo.io.common");
dojo.io.transports=[];
dojo.io.hdlrFuncNames=["load","error","timeout"];
dojo.io.Request=function(url,_59f,_5a0,_5a1){
if((arguments.length==1)&&(arguments[0].constructor==Object)){
this.fromKwArgs(arguments[0]);
}else{
this.url=url;
if(_59f){
this.mimetype=_59f;
}
if(_5a0){
this.transport=_5a0;
}
if(arguments.length>=4){
this.changeUrl=_5a1;
}
}
};
dojo.lang.extend(dojo.io.Request,{url:"",mimetype:"text/plain",method:"GET",content:undefined,transport:undefined,changeUrl:undefined,formNode:undefined,sync:false,bindSuccess:false,useCache:false,preventCache:false,jsonFilter:function(_5a2){
if((this.mimetype=="text/json-comment-filtered")||(this.mimetype=="application/json-comment-filtered")){
var _5a3=_5a2.indexOf("/*");
var _5a4=_5a2.lastIndexOf("*/");
if((_5a3==-1)||(_5a4==-1)){
dojo.debug("your JSON wasn't comment filtered!");
return "";
}
return _5a2.substring(_5a3+2,_5a4);
}
dojo.debug("please consider using a mimetype of text/json-comment-filtered to avoid potential security issues with JSON endpoints");
return _5a2;
},load:function(type,data,_5a7,_5a8){
},error:function(type,_5aa,_5ab,_5ac){
},timeout:function(type,_5ae,_5af,_5b0){
},handle:function(type,data,_5b3,_5b4){
},timeoutSeconds:0,abort:function(){
},fromKwArgs:function(_5b5){
if(_5b5["url"]){
_5b5.url=_5b5.url.toString();
}
if(_5b5["formNode"]){
_5b5.formNode=dojo.byId(_5b5.formNode);
}
if(!_5b5["method"]&&_5b5["formNode"]&&_5b5["formNode"].method){
_5b5.method=_5b5["formNode"].method;
}
if(!_5b5["handle"]&&_5b5["handler"]){
_5b5.handle=_5b5.handler;
}
if(!_5b5["load"]&&_5b5["loaded"]){
_5b5.load=_5b5.loaded;
}
if(!_5b5["changeUrl"]&&_5b5["changeURL"]){
_5b5.changeUrl=_5b5.changeURL;
}
_5b5.encoding=dojo.lang.firstValued(_5b5["encoding"],djConfig["bindEncoding"],"");
_5b5.sendTransport=dojo.lang.firstValued(_5b5["sendTransport"],djConfig["ioSendTransport"],false);
var _5b6=dojo.lang.isFunction;
for(var x=0;x<dojo.io.hdlrFuncNames.length;x++){
var fn=dojo.io.hdlrFuncNames[x];
if(_5b5[fn]&&_5b6(_5b5[fn])){
continue;
}
if(_5b5["handle"]&&_5b6(_5b5["handle"])){
_5b5[fn]=_5b5.handle;
}
}
dojo.lang.mixin(this,_5b5);
}});
dojo.io.Error=function(msg,type,num){
this.message=msg;
this.type=type||"unknown";
this.number=num||0;
};
dojo.io.transports.addTransport=function(name){
this.push(name);
this[name]=dojo.io[name];
};
dojo.io.bind=function(_5bd){
if(!(_5bd instanceof dojo.io.Request)){
try{
_5bd=new dojo.io.Request(_5bd);
}
catch(e){
dojo.debug(e);
}
}
var _5be="";
if(_5bd["transport"]){
_5be=_5bd["transport"];
if(!this[_5be]){
dojo.io.sendBindError(_5bd,"No dojo.io.bind() transport with name '"+_5bd["transport"]+"'.");
return _5bd;
}
if(!this[_5be].canHandle(_5bd)){
dojo.io.sendBindError(_5bd,"dojo.io.bind() transport with name '"+_5bd["transport"]+"' cannot handle this type of request.");
return _5bd;
}
}else{
for(var x=0;x<dojo.io.transports.length;x++){
var tmp=dojo.io.transports[x];
if((this[tmp])&&(this[tmp].canHandle(_5bd))){
_5be=tmp;
break;
}
}
if(_5be==""){
dojo.io.sendBindError(_5bd,"None of the loaded transports for dojo.io.bind()"+" can handle the request.");
return _5bd;
}
}
this[_5be].bind(_5bd);
_5bd.bindSuccess=true;
return _5bd;
};
dojo.io.sendBindError=function(_5c1,_5c2){
if((typeof _5c1.error=="function"||typeof _5c1.handle=="function")&&(typeof setTimeout=="function"||typeof setTimeout=="object")){
var _5c3=new dojo.io.Error(_5c2);
setTimeout(function(){
_5c1[(typeof _5c1.error=="function")?"error":"handle"]("error",_5c3,null,_5c1);
},50);
}else{
dojo.raise(_5c2);
}
};
dojo.io.queueBind=function(_5c4){
if(!(_5c4 instanceof dojo.io.Request)){
try{
_5c4=new dojo.io.Request(_5c4);
}
catch(e){
dojo.debug(e);
}
}
var _5c5=_5c4.load;
_5c4.load=function(){
dojo.io._queueBindInFlight=false;
var ret=_5c5.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
var _5c7=_5c4.error;
_5c4.error=function(){
dojo.io._queueBindInFlight=false;
var ret=_5c7.apply(this,arguments);
dojo.io._dispatchNextQueueBind();
return ret;
};
dojo.io._bindQueue.push(_5c4);
dojo.io._dispatchNextQueueBind();
return _5c4;
};
dojo.io._dispatchNextQueueBind=function(){
if(!dojo.io._queueBindInFlight){
dojo.io._queueBindInFlight=true;
if(dojo.io._bindQueue.length>0){
dojo.io.bind(dojo.io._bindQueue.shift());
}else{
dojo.io._queueBindInFlight=false;
}
}
};
dojo.io._bindQueue=[];
dojo.io._queueBindInFlight=false;
dojo.io.argsFromMap=function(map,_5ca,last){
var enc=/utf/i.test(_5ca||"")?encodeURIComponent:dojo.string.encodeAscii;
var _5cd=[];
var _5ce=new Object();
for(var name in map){
var _5d0=function(elt){
var val=enc(name)+"="+enc(elt);
_5cd[(last==name)?"push":"unshift"](val);
};
if(!_5ce[name]){
var _5d3=map[name];
if(dojo.lang.isArray(_5d3)){
dojo.lang.forEach(_5d3,_5d0);
}else{
_5d0(_5d3);
}
}
}
return _5cd.join("&");
};
dojo.io.setIFrameSrc=function(_5d4,src,_5d6){
try{
var r=dojo.render.html;
if(!_5d6){
if(r.safari){
_5d4.location=src;
}else{
frames[_5d4.name].location=src;
}
}else{
var idoc;
if(r.ie){
idoc=_5d4.contentWindow.document;
}else{
if(r.safari){
idoc=_5d4.document;
}else{
idoc=_5d4.contentWindow;
}
}
if(!idoc){
_5d4.location=src;
return;
}else{
idoc.location.replace(src);
}
}
}
catch(e){
dojo.debug(e);
dojo.debug("setIFrameSrc: "+e);
}
};
dojo.provide("dojo.string.extras");
dojo.string.substituteParams=function(_5d9,hash){
var map=(typeof hash=="object")?hash:dojo.lang.toArray(arguments,1);
return _5d9.replace(/\%\{(\w+)\}/g,function(_5dc,key){
if(typeof (map[key])!="undefined"&&map[key]!=null){
return map[key];
}
dojo.raise("Substitution not found: "+key);
});
};
dojo.string.capitalize=function(str){
if(!dojo.lang.isString(str)){
return "";
}
if(arguments.length==0){
str=this;
}
var _5df=str.split(" ");
for(var i=0;i<_5df.length;i++){
_5df[i]=_5df[i].charAt(0).toUpperCase()+_5df[i].substring(1);
}
return _5df.join(" ");
};
dojo.string.isBlank=function(str){
if(!dojo.lang.isString(str)){
return true;
}
return (dojo.string.trim(str).length==0);
};
dojo.string.encodeAscii=function(str){
if(!dojo.lang.isString(str)){
return str;
}
var ret="";
var _5e4=escape(str);
var _5e5,re=/%u([0-9A-F]{4})/i;
while((_5e5=_5e4.match(re))){
var num=Number("0x"+_5e5[1]);
var _5e8=escape("&#"+num+";");
ret+=_5e4.substring(0,_5e5.index)+_5e8;
_5e4=_5e4.substring(_5e5.index+_5e5[0].length);
}
ret+=_5e4.replace(/\+/g,"%2B");
return ret;
};
dojo.string.escape=function(type,str){
var args=dojo.lang.toArray(arguments,1);
switch(type.toLowerCase()){
case "xml":
case "html":
case "xhtml":
return dojo.string.escapeXml.apply(this,args);
case "sql":
return dojo.string.escapeSql.apply(this,args);
case "regexp":
case "regex":
return dojo.string.escapeRegExp.apply(this,args);
case "javascript":
case "jscript":
case "js":
return dojo.string.escapeJavaScript.apply(this,args);
case "ascii":
return dojo.string.encodeAscii.apply(this,args);
default:
return str;
}
};
dojo.string.escapeXml=function(str,_5ed){
str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");
if(!_5ed){
str=str.replace(/'/gm,"&#39;");
}
return str;
};
dojo.string.escapeSql=function(str){
return str.replace(/'/gm,"''");
};
dojo.string.escapeRegExp=function(str){
return str.replace(/\\/gm,"\\\\").replace(/([\f\b\n\t\r[\^$|?*+(){}])/gm,"\\$1");
};
dojo.string.escapeJavaScript=function(str){
return str.replace(/(["'\f\b\n\t\r])/gm,"\\$1");
};
dojo.string.escapeString=function(str){
return ("\""+str.replace(/(["\\])/g,"\\$1")+"\"").replace(/[\f]/g,"\\f").replace(/[\b]/g,"\\b").replace(/[\n]/g,"\\n").replace(/[\t]/g,"\\t").replace(/[\r]/g,"\\r");
};
dojo.string.summary=function(str,len){
if(!len||str.length<=len){
return str;
}
return str.substring(0,len).replace(/\.+$/,"")+"...";
};
dojo.string.endsWith=function(str,end,_5f6){
if(_5f6){
str=str.toLowerCase();
end=end.toLowerCase();
}
if((str.length-end.length)<0){
return false;
}
return str.lastIndexOf(end)==str.length-end.length;
};
dojo.string.endsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.endsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.startsWith=function(str,_5fa,_5fb){
if(_5fb){
str=str.toLowerCase();
_5fa=_5fa.toLowerCase();
}
return str.indexOf(_5fa)==0;
};
dojo.string.startsWithAny=function(str){
for(var i=1;i<arguments.length;i++){
if(dojo.string.startsWith(str,arguments[i])){
return true;
}
}
return false;
};
dojo.string.has=function(str){
for(var i=1;i<arguments.length;i++){
if(str.indexOf(arguments[i])>-1){
return true;
}
}
return false;
};
dojo.string.normalizeNewlines=function(text,_601){
if(_601=="\n"){
text=text.replace(/\r\n/g,"\n");
text=text.replace(/\r/g,"\n");
}else{
if(_601=="\r"){
text=text.replace(/\r\n/g,"\r");
text=text.replace(/\n/g,"\r");
}else{
text=text.replace(/([^\r])\n/g,"$1\r\n").replace(/\r([^\n])/g,"\r\n$1");
}
}
return text;
};
dojo.string.splitEscaped=function(str,_603){
var _604=[];
for(var i=0,_606=0;i<str.length;i++){
if(str.charAt(i)=="\\"){
i++;
continue;
}
if(str.charAt(i)==_603){
_604.push(str.substring(_606,i));
_606=i+1;
}
}
_604.push(str.substr(_606));
return _604;
};
dojo.provide("dojo.undo.browser");
try{
if((!djConfig["preventBackButtonFix"])&&(!dojo.hostenv.post_load_)){
document.write("<iframe style='border: 0px; width: 1px; height: 1px; position: absolute; bottom: 0px; right: 0px; visibility: visible;' name='djhistory' id='djhistory' src='"+(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"'></iframe>");
}
}
catch(e){
}
if(dojo.render.html.opera){
dojo.debug("Opera is not supported with dojo.undo.browser, so back/forward detection will not work.");
}
dojo.undo.browser={initialHref:(!dj_undef("window"))?window.location.href:"",initialHash:(!dj_undef("window"))?window.location.hash:"",moveForward:false,historyStack:[],forwardStack:[],historyIframe:null,bookmarkAnchor:null,locationTimer:null,setInitialState:function(args){
this.initialState=this._createState(this.initialHref,args,this.initialHash);
},addToHistory:function(args){
this.forwardStack=[];
var hash=null;
var url=null;
if(!this.historyIframe){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.undo.browser: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
this.historyIframe=window.frames["djhistory"];
}
if(!this.bookmarkAnchor){
this.bookmarkAnchor=document.createElement("a");
dojo.body().appendChild(this.bookmarkAnchor);
this.bookmarkAnchor.style.display="none";
}
if(args["changeUrl"]){
hash="#"+((args["changeUrl"]!==true)?args["changeUrl"]:(new Date()).getTime());
if(this.historyStack.length==0&&this.initialState.urlHash==hash){
this.initialState=this._createState(url,args,hash);
return;
}else{
if(this.historyStack.length>0&&this.historyStack[this.historyStack.length-1].urlHash==hash){
this.historyStack[this.historyStack.length-1]=this._createState(url,args,hash);
return;
}
}
this.changingUrl=true;
setTimeout("window.location.href = '"+hash+"'; dojo.undo.browser.changingUrl = false;",1);
this.bookmarkAnchor.href=hash;
if(dojo.render.html.ie){
url=this._loadIframeHistory();
var _60b=args["back"]||args["backButton"]||args["handle"];
var tcb=function(_60d){
if(window.location.hash!=""){
setTimeout("window.location.href = '"+hash+"';",1);
}
_60b.apply(this,[_60d]);
};
if(args["back"]){
args.back=tcb;
}else{
if(args["backButton"]){
args.backButton=tcb;
}else{
if(args["handle"]){
args.handle=tcb;
}
}
}
var _60e=args["forward"]||args["forwardButton"]||args["handle"];
var tfw=function(_610){
if(window.location.hash!=""){
window.location.href=hash;
}
if(_60e){
_60e.apply(this,[_610]);
}
};
if(args["forward"]){
args.forward=tfw;
}else{
if(args["forwardButton"]){
args.forwardButton=tfw;
}else{
if(args["handle"]){
args.handle=tfw;
}
}
}
}else{
if(dojo.render.html.moz){
if(!this.locationTimer){
this.locationTimer=setInterval("dojo.undo.browser.checkLocation();",200);
}
}
}
}else{
url=this._loadIframeHistory();
}
this.historyStack.push(this._createState(url,args,hash));
},checkLocation:function(){
if(!this.changingUrl){
var hsl=this.historyStack.length;
if((window.location.hash==this.initialHash||window.location.href==this.initialHref)&&(hsl==1)){
this.handleBackButton();
return;
}
if(this.forwardStack.length>0){
if(this.forwardStack[this.forwardStack.length-1].urlHash==window.location.hash){
this.handleForwardButton();
return;
}
}
if((hsl>=2)&&(this.historyStack[hsl-2])){
if(this.historyStack[hsl-2].urlHash==window.location.hash){
this.handleBackButton();
return;
}
}
}
},iframeLoaded:function(evt,_613){
if(!dojo.render.html.opera){
var _614=this._getUrlQuery(_613.href);
if(_614==null){
if(this.historyStack.length==1){
this.handleBackButton();
}
return;
}
if(this.moveForward){
this.moveForward=false;
return;
}
if(this.historyStack.length>=2&&_614==this._getUrlQuery(this.historyStack[this.historyStack.length-2].url)){
this.handleBackButton();
}else{
if(this.forwardStack.length>0&&_614==this._getUrlQuery(this.forwardStack[this.forwardStack.length-1].url)){
this.handleForwardButton();
}
}
}
},handleBackButton:function(){
var _615=this.historyStack.pop();
if(!_615){
return;
}
var last=this.historyStack[this.historyStack.length-1];
if(!last&&this.historyStack.length==0){
last=this.initialState;
}
if(last){
if(last.kwArgs["back"]){
last.kwArgs["back"]();
}else{
if(last.kwArgs["backButton"]){
last.kwArgs["backButton"]();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("back");
}
}
}
}
this.forwardStack.push(_615);
},handleForwardButton:function(){
var last=this.forwardStack.pop();
if(!last){
return;
}
if(last.kwArgs["forward"]){
last.kwArgs.forward();
}else{
if(last.kwArgs["forwardButton"]){
last.kwArgs.forwardButton();
}else{
if(last.kwArgs["handle"]){
last.kwArgs.handle("forward");
}
}
}
this.historyStack.push(last);
},_createState:function(url,args,hash){
return {"url":url,"kwArgs":args,"urlHash":hash};
},_getUrlQuery:function(url){
var _61c=url.split("?");
if(_61c.length<2){
return null;
}else{
return _61c[1];
}
},_loadIframeHistory:function(){
var url=(djConfig["dojoIframeHistoryUrl"]||dojo.hostenv.getBaseScriptUri()+"iframe_history.html")+"?"+(new Date()).getTime();
this.moveForward=true;
dojo.io.setIFrameSrc(this.historyIframe,url,false);
return url;
}};
dojo.provide("dojo.io.BrowserIO");
if(!dj_undef("window")){
dojo.io.checkChildrenForFile=function(node){
var _61f=false;
var _620=node.getElementsByTagName("input");
dojo.lang.forEach(_620,function(_621){
if(_61f){
return;
}
if(_621.getAttribute("type")=="file"){
_61f=true;
}
});
return _61f;
};
dojo.io.formHasFile=function(_622){
return dojo.io.checkChildrenForFile(_622);
};
dojo.io.updateNode=function(node,_624){
node=dojo.byId(node);
var args=_624;
if(dojo.lang.isString(_624)){
args={url:_624};
}
args.mimetype="text/html";
args.load=function(t,d,e){
while(node.firstChild){
dojo.dom.destroyNode(node.firstChild);
}
node.innerHTML=d;
};
dojo.io.bind(args);
};
dojo.io.formFilter=function(node){
var type=(node.type||"").toLowerCase();
return !node.disabled&&node.name&&!dojo.lang.inArray(["file","submit","image","reset","button"],type);
};
dojo.io.encodeForm=function(_62b,_62c,_62d){
if((!_62b)||(!_62b.tagName)||(!_62b.tagName.toLowerCase()=="form")){
dojo.raise("Attempted to encode a non-form element.");
}
if(!_62d){
_62d=dojo.io.formFilter;
}
var enc=/utf/i.test(_62c||"")?encodeURIComponent:dojo.string.encodeAscii;
var _62f=[];
for(var i=0;i<_62b.elements.length;i++){
var elm=_62b.elements[i];
if(!elm||elm.tagName.toLowerCase()=="fieldset"||!_62d(elm)){
continue;
}
var name=enc(elm.name);
var type=elm.type.toLowerCase();
if(type=="select-multiple"){
for(var j=0;j<elm.options.length;j++){
if(elm.options[j].selected){
_62f.push(name+"="+enc(elm.options[j].value));
}
}
}else{
if(dojo.lang.inArray(["radio","checkbox"],type)){
if(elm.checked){
_62f.push(name+"="+enc(elm.value));
}
}else{
_62f.push(name+"="+enc(elm.value));
}
}
}
var _635=_62b.getElementsByTagName("input");
for(var i=0;i<_635.length;i++){
var _636=_635[i];
if(_636.type.toLowerCase()=="image"&&_636.form==_62b&&_62d(_636)){
var name=enc(_636.name);
_62f.push(name+"="+enc(_636.value));
_62f.push(name+".x=0");
_62f.push(name+".y=0");
}
}
return _62f.join("&")+"&";
};
dojo.io.FormBind=function(args){
this.bindArgs={};
if(args&&args.formNode){
this.init(args);
}else{
if(args){
this.init({formNode:args});
}
}
};
dojo.lang.extend(dojo.io.FormBind,{form:null,bindArgs:null,clickedButton:null,init:function(args){
var form=dojo.byId(args.formNode);
if(!form||!form.tagName||form.tagName.toLowerCase()!="form"){
throw new Error("FormBind: Couldn't apply, invalid form");
}else{
if(this.form==form){
return;
}else{
if(this.form){
throw new Error("FormBind: Already applied to a form");
}
}
}
dojo.lang.mixin(this.bindArgs,args);
this.form=form;
this.connect(form,"onsubmit","submit");
for(var i=0;i<form.elements.length;i++){
var node=form.elements[i];
if(node&&node.type&&dojo.lang.inArray(["submit","button"],node.type.toLowerCase())){
this.connect(node,"onclick","click");
}
}
var _63c=form.getElementsByTagName("input");
for(var i=0;i<_63c.length;i++){
var _63d=_63c[i];
if(_63d.type.toLowerCase()=="image"&&_63d.form==form){
this.connect(_63d,"onclick","click");
}
}
},onSubmit:function(form){
return true;
},submit:function(e){
e.preventDefault();
if(this.onSubmit(this.form)){
dojo.io.bind(dojo.lang.mixin(this.bindArgs,{formFilter:dojo.lang.hitch(this,"formFilter")}));
}
},click:function(e){
var node=e.currentTarget;
if(node.disabled){
return;
}
this.clickedButton=node;
},formFilter:function(node){
var type=(node.type||"").toLowerCase();
var _644=false;
if(node.disabled||!node.name){
_644=false;
}else{
if(dojo.lang.inArray(["submit","button","image"],type)){
if(!this.clickedButton){
this.clickedButton=node;
}
_644=node==this.clickedButton;
}else{
_644=!dojo.lang.inArray(["file","submit","reset","button"],type);
}
}
return _644;
},connect:function(_645,_646,_647){
if(dojo.evalObjPath("dojo.event.connect")){
dojo.event.connect(_645,_646,this,_647);
}else{
var fcn=dojo.lang.hitch(this,_647);
_645[_646]=function(e){
if(!e){
e=window.event;
}
if(!e.currentTarget){
e.currentTarget=e.srcElement;
}
if(!e.preventDefault){
e.preventDefault=function(){
window.event.returnValue=false;
};
}
fcn(e);
};
}
}});
dojo.io.XMLHTTPTransport=new function(){
var _64a=this;
var _64b={};
this.useCache=false;
this.preventCache=false;
function getCacheKey(url,_64d,_64e){
return url+"|"+_64d+"|"+_64e.toLowerCase();
}
function addToCache(url,_650,_651,http){
_64b[getCacheKey(url,_650,_651)]=http;
}
function getFromCache(url,_654,_655){
return _64b[getCacheKey(url,_654,_655)];
}
this.clearCache=function(){
_64b={};
};
function doLoad(_656,http,url,_659,_65a){
if(((http.status>=200)&&(http.status<300))||(http.status==304)||(http.status==1223)||(location.protocol=="file:"&&(http.status==0||http.status==undefined))||(location.protocol=="chrome:"&&(http.status==0||http.status==undefined))){
var ret;
if(_656.method.toLowerCase()=="head"){
var _65c=http.getAllResponseHeaders();
ret={};
ret.toString=function(){
return _65c;
};
var _65d=_65c.split(/[\r\n]+/g);
for(var i=0;i<_65d.length;i++){
var pair=_65d[i].match(/^([^:]+)\s*:\s*(.+)$/i);
if(pair){
ret[pair[1]]=pair[2];
}
}
}else{
if(_656.mimetype=="text/javascript"){
try{
ret=dj_eval(http.responseText);
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=null;
}
}else{
if(_656.mimetype.substr(0,9)=="text/json"||_656.mimetype.substr(0,16)=="application/json"){
try{
ret=dj_eval("("+_656.jsonFilter(http.responseText)+")");
}
catch(e){
dojo.debug(e);
dojo.debug(http.responseText);
ret=false;
}
}else{
if((_656.mimetype=="application/xml")||(_656.mimetype=="text/xml")){
ret=http.responseXML;
if(!ret||typeof ret=="string"||!http.getResponseHeader("Content-Type")){
ret=dojo.dom.createDocumentFromText(http.responseText);
}
}else{
ret=http.responseText;
}
}
}
}
if(_65a){
addToCache(url,_659,_656.method,http);
}
_656[(typeof _656.load=="function")?"load":"handle"]("load",ret,http,_656);
}else{
var _660=new dojo.io.Error("XMLHttpTransport Error: "+http.status+" "+http.statusText);
_656[(typeof _656.error=="function")?"error":"handle"]("error",_660,http,_656);
}
}
function setHeaders(http,_662){
if(_662["headers"]){
for(var _663 in _662["headers"]){
if(_663.toLowerCase()=="content-type"&&!_662["contentType"]){
_662["contentType"]=_662["headers"][_663];
}else{
http.setRequestHeader(_663,_662["headers"][_663]);
}
}
}
}
this.inFlight=[];
this.inFlightTimer=null;
this.startWatchingInFlight=function(){
if(!this.inFlightTimer){
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
}
};
this.watchInFlight=function(){
var now=null;
if(!dojo.hostenv._blockAsync&&!_64a._blockAsync){
for(var x=this.inFlight.length-1;x>=0;x--){
try{
var tif=this.inFlight[x];
if(!tif||tif.http._aborted||!tif.http.readyState){
this.inFlight.splice(x,1);
continue;
}
if(4==tif.http.readyState){
this.inFlight.splice(x,1);
doLoad(tif.req,tif.http,tif.url,tif.query,tif.useCache);
}else{
if(tif.startTime){
if(!now){
now=(new Date()).getTime();
}
if(tif.startTime+(tif.req.timeoutSeconds*1000)<now){
if(typeof tif.http.abort=="function"){
tif.http.abort();
}
this.inFlight.splice(x,1);
tif.req[(typeof tif.req.timeout=="function")?"timeout":"handle"]("timeout",null,tif.http,tif.req);
}
}
}
}
catch(e){
try{
var _667=new dojo.io.Error("XMLHttpTransport.watchInFlight Error: "+e);
tif.req[(typeof tif.req.error=="function")?"error":"handle"]("error",_667,tif.http,tif.req);
}
catch(e2){
dojo.debug("XMLHttpTransport error callback failed: "+e2);
}
}
}
}
clearTimeout(this.inFlightTimer);
if(this.inFlight.length==0){
this.inFlightTimer=null;
return;
}
this.inFlightTimer=setTimeout("dojo.io.XMLHTTPTransport.watchInFlight();",10);
};
var _668=dojo.hostenv.getXmlhttpObject()?true:false;
this.canHandle=function(_669){
var mlc=_669["mimetype"].toLowerCase()||"";
return _668&&((dojo.lang.inArray(["text/plain","text/html","application/xml","text/xml","text/javascript"],mlc))||(mlc.substr(0,9)=="text/json"||mlc.substr(0,16)=="application/json"))&&!(_669["formNode"]&&dojo.io.formHasFile(_669["formNode"]));
};
this.multipartBoundary="45309FFF-BD65-4d50-99C9-36986896A96F";
this.bind=function(_66b){
if(!_66b["url"]){
if(!_66b["formNode"]&&(_66b["backButton"]||_66b["back"]||_66b["changeUrl"]||_66b["watchForURL"])&&(!djConfig.preventBackButtonFix)){
dojo.deprecated("Using dojo.io.XMLHTTPTransport.bind() to add to browser history without doing an IO request","Use dojo.undo.browser.addToHistory() instead.","0.4");
dojo.undo.browser.addToHistory(_66b);
return true;
}
}
var url=_66b.url;
var _66d="";
if(_66b["formNode"]){
var ta=_66b.formNode.getAttribute("action");
if((ta)&&(!_66b["url"])){
url=ta;
}
var tp=_66b.formNode.getAttribute("method");
if((tp)&&(!_66b["method"])){
_66b.method=tp;
}
_66d+=dojo.io.encodeForm(_66b.formNode,_66b.encoding,_66b["formFilter"]);
}
if(url.indexOf("#")>-1){
dojo.debug("Warning: dojo.io.bind: stripping hash values from url:",url);
url=url.split("#")[0];
}
if(_66b["file"]){
_66b.method="post";
}
if(!_66b["method"]){
_66b.method="get";
}
if(_66b.method.toLowerCase()=="get"){
_66b.multipart=false;
}else{
if(_66b["file"]){
_66b.multipart=true;
}else{
if(!_66b["multipart"]){
_66b.multipart=false;
}
}
}
if(_66b["backButton"]||_66b["back"]||_66b["changeUrl"]){
dojo.undo.browser.addToHistory(_66b);
}
var _670=_66b["content"]||{};
if(_66b.sendTransport){
_670["dojo.transport"]="xmlhttp";
}
do{
if(_66b.postContent){
_66d=_66b.postContent;
break;
}
if(_670){
_66d+=dojo.io.argsFromMap(_670,_66b.encoding);
}
if(_66b.method.toLowerCase()=="get"||!_66b.multipart){
break;
}
var t=[];
if(_66d.length){
var q=_66d.split("&");
for(var i=0;i<q.length;++i){
if(q[i].length){
var p=q[i].split("=");
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+p[0]+"\"","",p[1]);
}
}
}
if(_66b.file){
if(dojo.lang.isArray(_66b.file)){
for(var i=0;i<_66b.file.length;++i){
var o=_66b.file[i];
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}else{
var o=_66b.file;
t.push("--"+this.multipartBoundary,"Content-Disposition: form-data; name=\""+o.name+"\"; filename=\""+("fileName" in o?o.fileName:o.name)+"\"","Content-Type: "+("contentType" in o?o.contentType:"application/octet-stream"),"",o.content);
}
}
if(t.length){
t.push("--"+this.multipartBoundary+"--","");
_66d=t.join("\r\n");
}
}while(false);
var _676=_66b["sync"]?false:true;
var _677=_66b["preventCache"]||(this.preventCache==true&&_66b["preventCache"]!=false);
var _678=_66b["useCache"]==true||(this.useCache==true&&_66b["useCache"]!=false);
if(!_677&&_678){
var _679=getFromCache(url,_66d,_66b.method);
if(_679){
doLoad(_66b,_679,url,_66d,false);
return;
}
}
var http=dojo.hostenv.getXmlhttpObject(_66b);
var _67b=false;
if(_676){
var _67c=this.inFlight.push({"req":_66b,"http":http,"url":url,"query":_66d,"useCache":_678,"startTime":_66b.timeoutSeconds?(new Date()).getTime():0});
this.startWatchingInFlight();
}else{
_64a._blockAsync=true;
}
if(_66b.method.toLowerCase()=="post"){
if(!_66b.user){
http.open("POST",url,_676);
}else{
http.open("POST",url,_676,_66b.user,_66b.password);
}
setHeaders(http,_66b);
http.setRequestHeader("Content-Type",_66b.multipart?("multipart/form-data; boundary="+this.multipartBoundary):(_66b.contentType||"application/x-www-form-urlencoded"));
try{
http.send(_66d);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_66b,{status:404},url,_66d,_678);
}
}else{
var _67d=url;
if(_66d!=""){
_67d+=(_67d.indexOf("?")>-1?"&":"?")+_66d;
}
if(_677){
_67d+=(dojo.string.endsWithAny(_67d,"?","&")?"":(_67d.indexOf("?")>-1?"&":"?"))+"dojo.preventCache="+new Date().valueOf();
}
if(!_66b.user){
http.open(_66b.method.toUpperCase(),_67d,_676);
}else{
http.open(_66b.method.toUpperCase(),_67d,_676,_66b.user,_66b.password);
}
setHeaders(http,_66b);
try{
http.send(null);
}
catch(e){
if(typeof http.abort=="function"){
http.abort();
}
doLoad(_66b,{status:404},url,_66d,_678);
}
}
if(!_676){
doLoad(_66b,http,url,_66d,_678);
_64a._blockAsync=false;
}
_66b.abort=function(){
try{
http._aborted=true;
}
catch(e){
}
return http.abort();
};
return;
};
dojo.io.transports.addTransport("XMLHTTPTransport");
};
}
dojo.provide("dojo.io.cookie");
dojo.io.cookie.setCookie=function(name,_67f,days,path,_682,_683){
var _684=-1;
if((typeof days=="number")&&(days>=0)){
var d=new Date();
d.setTime(d.getTime()+(days*24*60*60*1000));
_684=d.toGMTString();
}
_67f=escape(_67f);
document.cookie=name+"="+_67f+";"+(_684!=-1?" expires="+_684+";":"")+(path?"path="+path:"")+(_682?"; domain="+_682:"")+(_683?"; secure":"");
};
dojo.io.cookie.set=dojo.io.cookie.setCookie;
dojo.io.cookie.getCookie=function(name){
var idx=document.cookie.lastIndexOf(name+"=");
if(idx==-1){
return null;
}
var _688=document.cookie.substring(idx+name.length+1);
var end=_688.indexOf(";");
if(end==-1){
end=_688.length;
}
_688=_688.substring(0,end);
_688=unescape(_688);
return _688;
};
dojo.io.cookie.get=dojo.io.cookie.getCookie;
dojo.io.cookie.deleteCookie=function(name){
dojo.io.cookie.setCookie(name,"-",0);
};
dojo.io.cookie.setObjectCookie=function(name,obj,days,path,_68f,_690,_691){
if(arguments.length==5){
_691=_68f;
_68f=null;
_690=null;
}
var _692=[],_693,_694="";
if(!_691){
_693=dojo.io.cookie.getObjectCookie(name);
}
if(days>=0){
if(!_693){
_693={};
}
for(var prop in obj){
if(obj[prop]==null){
delete _693[prop];
}else{
if((typeof obj[prop]=="string")||(typeof obj[prop]=="number")){
_693[prop]=obj[prop];
}
}
}
prop=null;
for(var prop in _693){
_692.push(escape(prop)+"="+escape(_693[prop]));
}
_694=_692.join("&");
}
dojo.io.cookie.setCookie(name,_694,days,path,_68f,_690);
};
dojo.io.cookie.getObjectCookie=function(name){
var _697=null,_698=dojo.io.cookie.getCookie(name);
if(_698){
_697={};
var _699=_698.split("&");
for(var i=0;i<_699.length;i++){
var pair=_699[i].split("=");
var _69c=pair[1];
if(isNaN(_69c)){
_69c=unescape(pair[1]);
}
_697[unescape(pair[0])]=_69c;
}
}
return _697;
};
dojo.io.cookie.isSupported=function(){
if(typeof navigator.cookieEnabled!="boolean"){
dojo.io.cookie.setCookie("__TestingYourBrowserForCookieSupport__","CookiesAllowed",90,null);
var _69d=dojo.io.cookie.getCookie("__TestingYourBrowserForCookieSupport__");
navigator.cookieEnabled=(_69d=="CookiesAllowed");
if(navigator.cookieEnabled){
this.deleteCookie("__TestingYourBrowserForCookieSupport__");
}
}
return navigator.cookieEnabled;
};
if(!dojo.io.cookies){
dojo.io.cookies=dojo.io.cookie;
}
dojo.kwCompoundRequire({common:["dojo.io.common"],rhino:["dojo.io.RhinoIO"],browser:["dojo.io.BrowserIO","dojo.io.cookie"],dashboard:["dojo.io.BrowserIO","dojo.io.cookie"]});
dojo.provide("dojo.io.*");
dojo.kwCompoundRequire({common:[["dojo.uri.Uri",false,false]]});
dojo.provide("dojo.uri.*");
dojo.provide("dojo.io.IframeIO");
dojo.io.createIFrame=function(_69e,_69f,uri){
if(window[_69e]){
return window[_69e];
}
if(window.frames[_69e]){
return window.frames[_69e];
}
var r=dojo.render.html;
var _6a2=null;
var turi=uri;
if(!turi){
if(djConfig["useXDomain"]&&!djConfig["dojoIframeHistoryUrl"]){
dojo.debug("dojo.io.createIFrame: When using cross-domain Dojo builds,"+" please save iframe_history.html to your domain and set djConfig.dojoIframeHistoryUrl"+" to the path on your domain to iframe_history.html");
}
turi=(djConfig["dojoIframeHistoryUrl"]||dojo.uri.moduleUri("dojo","../iframe_history.html"))+"#noInit=true";
}
var _6a4=((r.ie)&&(dojo.render.os.win))?"<iframe name=\""+_69e+"\" src=\""+turi+"\" onload=\""+_69f+"\">":"iframe";
_6a2=document.createElement(_6a4);
with(_6a2){
name=_69e;
setAttribute("name",_69e);
id=_69e;
}
dojo.body().appendChild(_6a2);
window[_69e]=_6a2;
with(_6a2.style){
if(!r.safari){
position="absolute";
}
left=top="0px";
height=width="1px";
visibility="hidden";
}
if(!r.ie){
dojo.io.setIFrameSrc(_6a2,turi,true);
_6a2.onload=new Function(_69f);
}
return _6a2;
};
dojo.io.IframeTransport=new function(){
var _6a5=this;
this.currentRequest=null;
this.requestQueue=[];
this.iframeName="dojoIoIframe";
this.fireNextRequest=function(){
try{
if((this.currentRequest)||(this.requestQueue.length==0)){
return;
}
var cr=this.currentRequest=this.requestQueue.shift();
cr._contentToClean=[];
var fn=cr["formNode"];
var _6a8=cr["content"]||{};
if(cr.sendTransport){
_6a8["dojo.transport"]="iframe";
}
if(fn){
if(_6a8){
for(var x in _6a8){
if(!fn[x]){
var tn;
if(dojo.render.html.ie){
tn=document.createElement("<input type='hidden' name='"+x+"' value='"+_6a8[x]+"'>");
fn.appendChild(tn);
}else{
tn=document.createElement("input");
fn.appendChild(tn);
tn.type="hidden";
tn.name=x;
tn.value=_6a8[x];
}
cr._contentToClean.push(x);
}else{
fn[x].value=_6a8[x];
}
}
}
if(cr["url"]){
cr._originalAction=fn.getAttribute("action");
fn.setAttribute("action",cr.url);
}
if(!fn.getAttribute("method")){
fn.setAttribute("method",(cr["method"])?cr["method"]:"post");
}
cr._originalTarget=fn.getAttribute("target");
fn.setAttribute("target",this.iframeName);
fn.target=this.iframeName;
fn.submit();
}else{
var _6ab=dojo.io.argsFromMap(this.currentRequest.content);
var _6ac=cr.url+(cr.url.indexOf("?")>-1?"&":"?")+_6ab;
dojo.io.setIFrameSrc(this.iframe,_6ac,true);
}
}
catch(e){
this.iframeOnload(e);
}
};
this.canHandle=function(_6ad){
return ((dojo.lang.inArray(["text/plain","text/html","text/javascript","text/json","application/json"],_6ad["mimetype"]))&&(dojo.lang.inArray(["post","get"],_6ad["method"].toLowerCase()))&&(!((_6ad["sync"])&&(_6ad["sync"]==true))));
};
this.bind=function(_6ae){
if(!this["iframe"]){
this.setUpIframe();
}
this.requestQueue.push(_6ae);
this.fireNextRequest();
return;
};
this.setUpIframe=function(){
this.iframe=dojo.io.createIFrame(this.iframeName,"dojo.io.IframeTransport.iframeOnload();");
};
this.iframeOnload=function(_6af){
if(!_6a5.currentRequest){
_6a5.fireNextRequest();
return;
}
var req=_6a5.currentRequest;
if(req.formNode){
var _6b1=req._contentToClean;
for(var i=0;i<_6b1.length;i++){
var key=_6b1[i];
if(dojo.render.html.safari){
var _6b4=req.formNode;
for(var j=0;j<_6b4.childNodes.length;j++){
var _6b6=_6b4.childNodes[j];
if(_6b6.name==key){
var _6b7=_6b6.parentNode;
_6b7.removeChild(_6b6);
break;
}
}
}else{
var _6b8=req.formNode[key];
req.formNode.removeChild(_6b8);
req.formNode[key]=null;
}
}
if(req["_originalAction"]){
req.formNode.setAttribute("action",req._originalAction);
}
if(req["_originalTarget"]){
req.formNode.setAttribute("target",req._originalTarget);
req.formNode.target=req._originalTarget;
}
}
var _6b9=function(_6ba){
var doc=_6ba.contentDocument||((_6ba.contentWindow)&&(_6ba.contentWindow.document))||((_6ba.name)&&(document.frames[_6ba.name])&&(document.frames[_6ba.name].document))||null;
return doc;
};
var _6bc;
var _6bd=false;
if(_6af){
this._callError(req,"IframeTransport Request Error: "+_6af);
}else{
var ifd=_6b9(_6a5.iframe);
try{
var cmt=req.mimetype;
if((cmt=="text/javascript")||(cmt=="text/json")||(cmt=="application/json")){
var js=ifd.getElementsByTagName("textarea")[0].value;
if(cmt=="text/json"||cmt=="application/json"){
js="("+js+")";
}
_6bc=dj_eval(js);
}else{
if(cmt=="text/html"){
_6bc=ifd;
}else{
_6bc=ifd.getElementsByTagName("textarea")[0].value;
}
}
_6bd=true;
}
catch(e){
this._callError(req,"IframeTransport Error: "+e);
}
}
try{
if(_6bd&&dojo.lang.isFunction(req["load"])){
req.load("load",_6bc,req);
}
}
catch(e){
throw e;
}
finally{
_6a5.currentRequest=null;
_6a5.fireNextRequest();
}
};
this._callError=function(req,_6c2){
var _6c3=new dojo.io.Error(_6c2);
if(dojo.lang.isFunction(req["error"])){
req.error("error",_6c3,req);
}
};
dojo.io.transports.addTransport("IframeTransport");
};
dojo.provide("dojo.date");
dojo.deprecated("dojo.date","use one of the modules in dojo.date.* instead","0.5");
dojo.provide("dojo.string.Builder");
dojo.string.Builder=function(str){
this.arrConcat=(dojo.render.html.capable&&dojo.render.html["ie"]);
var a=[];
var b="";
var _6c7=this.length=b.length;
if(this.arrConcat){
if(b.length>0){
a.push(b);
}
b="";
}
this.toString=this.valueOf=function(){
return (this.arrConcat)?a.join(""):b;
};
this.append=function(){
for(var x=0;x<arguments.length;x++){
var s=arguments[x];
if(dojo.lang.isArrayLike(s)){
this.append.apply(this,s);
}else{
if(this.arrConcat){
a.push(s);
}else{
b+=s;
}
_6c7+=s.length;
this.length=_6c7;
}
}
return this;
};
this.clear=function(){
a=[];
b="";
_6c7=this.length=0;
return this;
};
this.remove=function(f,l){
var s="";
if(this.arrConcat){
b=a.join("");
}
a=[];
if(f>0){
s=b.substring(0,(f-1));
}
b=s+b.substring(f+l);
_6c7=this.length=b.length;
if(this.arrConcat){
a.push(b);
b="";
}
return this;
};
this.replace=function(o,n){
if(this.arrConcat){
b=a.join("");
}
a=[];
b=b.replace(o,n);
_6c7=this.length=b.length;
if(this.arrConcat){
a.push(b);
b="";
}
return this;
};
this.insert=function(idx,s){
if(this.arrConcat){
b=a.join("");
}
a=[];
if(idx==0){
b=s+b;
}else{
var t=b.split("");
t.splice(idx,0,s);
b=t.join("");
}
_6c7=this.length=b.length;
if(this.arrConcat){
a.push(b);
b="";
}
return this;
};
this.append.apply(this,arguments);
};
dojo.kwCompoundRequire({common:["dojo.string","dojo.string.common","dojo.string.extras","dojo.string.Builder"]});
dojo.provide("dojo.string.*");
if(!this["dojo"]){
alert("\"dojo/__package__.js\" is now located at \"dojo/dojo.js\". Please update your includes accordingly");
}
dojo.provide("dojo.AdapterRegistry");
dojo.AdapterRegistry=function(_6d2){
this.pairs=[];
this.returnWrappers=_6d2||false;
};
dojo.lang.extend(dojo.AdapterRegistry,{register:function(name,_6d4,wrap,_6d6,_6d7){
var type=(_6d7)?"unshift":"push";
this.pairs[type]([name,_6d4,wrap,_6d6]);
},match:function(){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[1].apply(this,arguments)){
if((pair[3])||(this.returnWrappers)){
return pair[2];
}else{
return pair[2].apply(this,arguments);
}
}
}
throw new Error("No match found");
},unregister:function(name){
for(var i=0;i<this.pairs.length;i++){
var pair=this.pairs[i];
if(pair[0]==name){
this.pairs.splice(i,1);
return true;
}
}
return false;
}});
dojo.provide("dojo.json");
dojo.json={jsonRegistry:new dojo.AdapterRegistry(),register:function(name,_6df,wrap,_6e1){
dojo.json.jsonRegistry.register(name,_6df,wrap,_6e1);
},evalJson:function(json){
try{
return eval("("+json+")");
}
catch(e){
dojo.debug(e);
return json;
}
},serialize:function(o){
var _6e4=typeof (o);
if(_6e4=="undefined"){
return "undefined";
}else{
if((_6e4=="number")||(_6e4=="boolean")){
return o+"";
}else{
if(o===null){
return "null";
}
}
}
if(_6e4=="string"){
return dojo.string.escapeString(o);
}
var me=arguments.callee;
var _6e6;
if(typeof (o.__json__)=="function"){
_6e6=o.__json__();
if(o!==_6e6){
return me(_6e6);
}
}
if(typeof (o.json)=="function"){
_6e6=o.json();
if(o!==_6e6){
return me(_6e6);
}
}
if(_6e4!="function"&&typeof (o.length)=="number"){
var res=[];
for(var i=0;i<o.length;i++){
var val=me(o[i]);
if(typeof (val)!="string"){
val="undefined";
}
res.push(val);
}
return "["+res.join(",")+"]";
}
try{
window.o=o;
_6e6=dojo.json.jsonRegistry.match(o);
return me(_6e6);
}
catch(e){
}
if(_6e4=="function"){
return null;
}
res=[];
for(var k in o){
var _6eb;
if(typeof (k)=="number"){
_6eb="\""+k+"\"";
}else{
if(typeof (k)=="string"){
_6eb=dojo.string.escapeString(k);
}else{
continue;
}
}
val=me(o[k]);
if(typeof (val)!="string"){
continue;
}
res.push(_6eb+":"+val);
}
return "{"+res.join(",")+"}";
}};
dojo.provide("dojo.Deferred");
dojo.Deferred=function(_6ec){
this.chain=[];
this.id=this._nextId();
this.fired=-1;
this.paused=0;
this.results=[null,null];
this.canceller=_6ec;
this.silentlyCancelled=false;
};
dojo.lang.extend(dojo.Deferred,{getFunctionFromArgs:function(){
var a=arguments;
if((a[0])&&(!a[1])){
if(dojo.lang.isFunction(a[0])){
return a[0];
}else{
if(dojo.lang.isString(a[0])){
return dj_global[a[0]];
}
}
}else{
if((a[0])&&(a[1])){
return dojo.lang.hitch(a[0],a[1]);
}
}
return null;
},makeCalled:function(){
var _6ee=new dojo.Deferred();
_6ee.callback();
return _6ee;
},repr:function(){
var _6ef;
if(this.fired==-1){
_6ef="unfired";
}else{
if(this.fired==0){
_6ef="success";
}else{
_6ef="error";
}
}
return "Deferred("+this.id+", "+_6ef+")";
},toString:dojo.lang.forward("repr"),_nextId:(function(){
var n=1;
return function(){
return n++;
};
})(),cancel:function(){
if(this.fired==-1){
if(this.canceller){
this.canceller(this);
}else{
this.silentlyCancelled=true;
}
if(this.fired==-1){
this.errback(new Error(this.repr()));
}
}else{
if((this.fired==0)&&(this.results[0] instanceof dojo.Deferred)){
this.results[0].cancel();
}
}
},_pause:function(){
this.paused++;
},_unpause:function(){
this.paused--;
if((this.paused==0)&&(this.fired>=0)){
this._fire();
}
},_continue:function(res){
this._resback(res);
this._unpause();
},_resback:function(res){
this.fired=((res instanceof Error)?1:0);
this.results[this.fired]=res;
this._fire();
},_check:function(){
if(this.fired!=-1){
if(!this.silentlyCancelled){
dojo.raise("already called!");
}
this.silentlyCancelled=false;
return;
}
},callback:function(res){
this._check();
this._resback(res);
},errback:function(res){
this._check();
if(!(res instanceof Error)){
res=new Error(res);
}
this._resback(res);
},addBoth:function(cb,cbfn){
var _6f7=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_6f7=dojo.lang.curryArguments(null,_6f7,arguments,2);
}
return this.addCallbacks(_6f7,_6f7);
},addCallback:function(cb,cbfn){
var _6fa=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_6fa=dojo.lang.curryArguments(null,_6fa,arguments,2);
}
return this.addCallbacks(_6fa,null);
},addErrback:function(cb,cbfn){
var _6fd=this.getFunctionFromArgs(cb,cbfn);
if(arguments.length>2){
_6fd=dojo.lang.curryArguments(null,_6fd,arguments,2);
}
return this.addCallbacks(null,_6fd);
return this.addCallbacks(null,cbfn);
},addCallbacks:function(cb,eb){
this.chain.push([cb,eb]);
if(this.fired>=0){
this._fire();
}
return this;
},_fire:function(){
var _700=this.chain;
var _701=this.fired;
var res=this.results[_701];
var self=this;
var cb=null;
while(_700.length>0&&this.paused==0){
var pair=_700.shift();
var f=pair[_701];
if(f==null){
continue;
}
try{
res=f(res);
_701=((res instanceof Error)?1:0);
if(res instanceof dojo.Deferred){
cb=function(res){
self._continue(res);
};
this._pause();
}
}
catch(err){
_701=1;
res=err;
}
}
this.fired=_701;
this.results[_701]=res;
if((cb)&&(this.paused)){
res.addBoth(cb);
}
}});
dojo.provide("dojo.rpc.RpcService");
dojo.rpc.RpcService=function(url){
if(url){
this.connect(url);
}
};
dojo.lang.extend(dojo.rpc.RpcService,{strictArgChecks:true,serviceUrl:"",parseResults:function(obj){
return obj;
},errorCallback:function(_70a){
return function(type,e){
_70a.errback(new Error(e.message));
};
},resultCallback:function(_70d){
var tf=dojo.lang.hitch(this,function(type,obj,e){
if(obj["error"]!=null){
var err=new Error(obj.error);
err.id=obj.id;
_70d.errback(err);
}else{
var _713=this.parseResults(obj);
_70d.callback(_713);
}
});
return tf;
},generateMethod:function(_714,_715,url){
return dojo.lang.hitch(this,function(){
var _717=new dojo.Deferred();
if((this.strictArgChecks)&&(_715!=null)&&(arguments.length!=_715.length)){
dojo.raise("Invalid number of parameters for remote method.");
}else{
this.bind(_714,arguments,_717,url);
}
return _717;
});
},processSmd:function(_718){
dojo.debug("RpcService: Processing returned SMD.");
if(_718.methods){
dojo.lang.forEach(_718.methods,function(m){
if(m&&m["name"]){
dojo.debug("RpcService: Creating Method: this.",m.name,"()");
this[m.name]=this.generateMethod(m.name,m.parameters,m["url"]||m["serviceUrl"]||m["serviceURL"]);
if(dojo.lang.isFunction(this[m.name])){
dojo.debug("RpcService: Successfully created",m.name,"()");
}else{
dojo.debug("RpcService: Failed to create",m.name,"()");
}
}
},this);
}
this.serviceUrl=_718.serviceUrl||_718.serviceURL;
dojo.debug("RpcService: Dojo RpcService is ready for use.");
},connect:function(_71a){
dojo.debug("RpcService: Attempting to load SMD document from:",_71a);
dojo.io.bind({url:_71a,mimetype:"text/json",load:dojo.lang.hitch(this,function(type,_71c,e){
return this.processSmd(_71c);
}),sync:true});
}});
dojo.provide("dojo.rpc.JsonService");
dojo.rpc.JsonService=function(args){
if(args){
if(dojo.lang.isString(args)){
this.connect(args);
}else{
if(args["smdUrl"]){
this.connect(args.smdUrl);
}
if(args["smdStr"]){
this.processSmd(dj_eval("("+args.smdStr+")"));
}
if(args["smdObj"]){
this.processSmd(args.smdObj);
}
if(args["serviceUrl"]){
this.serviceUrl=args.serviceUrl;
}
if(typeof args["strictArgChecks"]!="undefined"){
this.strictArgChecks=args.strictArgChecks;
}
}
}
};
dojo.inherits(dojo.rpc.JsonService,dojo.rpc.RpcService);
dojo.extend(dojo.rpc.JsonService,{bustCache:false,contentType:"application/json-rpc",lastSubmissionId:0,callRemote:function(_71f,_720){
var _721=new dojo.Deferred();
this.bind(_71f,_720,_721);
return _721;
},bind:function(_722,_723,_724,url){
dojo.io.bind({url:url||this.serviceUrl,postContent:this.createRequest(_722,_723),method:"POST",contentType:this.contentType,mimetype:"text/json",load:this.resultCallback(_724),error:this.errorCallback(_724),preventCache:this.bustCache});
},createRequest:function(_726,_727){
var req={"params":_727,"method":_726,"id":++this.lastSubmissionId};
var data=dojo.json.serialize(req);
dojo.debug("JsonService: JSON-RPC Request: "+data);
return data;
},parseResults:function(obj){
if(!obj){
return;
}
if(obj["Result"]!=null){
return obj["Result"];
}else{
if(obj["result"]!=null){
return obj["result"];
}else{
if(obj["ResultSet"]){
return obj["ResultSet"];
}else{
return obj;
}
}
}
}});
dojo.kwCompoundRequire({common:[["dojo.rpc.JsonService",false,false]]});
dojo.provide("dojo.rpc.*");
dojo.provide("dojo.xml.Parse");
dojo.xml.Parse=function(){
var isIE=((dojo.render.html.capable)&&(dojo.render.html.ie));
function getTagName(node){
try{
return node.tagName.toLowerCase();
}
catch(e){
return "";
}
}
function getDojoTagName(node){
var _72e=getTagName(node);
if(!_72e){
return "";
}
if((dojo.widget)&&(dojo.widget.tags[_72e])){
return _72e;
}
var p=_72e.indexOf(":");
if(p>=0){
return _72e;
}
if(_72e.substr(0,5)=="dojo:"){
return _72e;
}
if(dojo.render.html.capable&&dojo.render.html.ie&&node.scopeName!="HTML"){
return node.scopeName.toLowerCase()+":"+_72e;
}
if(_72e.substr(0,4)=="dojo"){
return "dojo:"+_72e.substring(4);
}
var djt=node.getAttribute("dojoType")||node.getAttribute("dojotype");
if(djt){
if(djt.indexOf(":")<0){
djt="dojo:"+djt;
}
return djt.toLowerCase();
}
djt=node.getAttributeNS&&node.getAttributeNS(dojo.dom.dojoml,"type");
if(djt){
return "dojo:"+djt.toLowerCase();
}
try{
djt=node.getAttribute("dojo:type");
}
catch(e){
}
if(djt){
return "dojo:"+djt.toLowerCase();
}
if((dj_global["djConfig"])&&(!djConfig["ignoreClassNames"])){
var _731=node.className||node.getAttribute("class");
if((_731)&&(_731.indexOf)&&(_731.indexOf("dojo-")!=-1)){
var _732=_731.split(" ");
for(var x=0,c=_732.length;x<c;x++){
if(_732[x].slice(0,5)=="dojo-"){
return "dojo:"+_732[x].substr(5).toLowerCase();
}
}
}
}
return "";
}
this.parseElement=function(node,_736,_737,_738){
var _739=getTagName(node);
if(isIE&&_739.indexOf("/")==0){
return null;
}
try{
var attr=node.getAttribute("parseWidgets");
if(attr&&attr.toLowerCase()=="false"){
return {};
}
}
catch(e){
}
var _73b=true;
if(_737){
var _73c=getDojoTagName(node);
_739=_73c||_739;
_73b=Boolean(_73c);
}
var _73d={};
_73d[_739]=[];
var pos=_739.indexOf(":");
if(pos>0){
var ns=_739.substring(0,pos);
_73d["ns"]=ns;
if((dojo.ns)&&(!dojo.ns.allow(ns))){
_73b=false;
}
}
if(_73b){
var _740=this.parseAttributes(node);
for(var attr in _740){
if((!_73d[_739][attr])||(typeof _73d[_739][attr]!="array")){
_73d[_739][attr]=[];
}
_73d[_739][attr].push(_740[attr]);
}
_73d[_739].nodeRef=node;
_73d.tagName=_739;
_73d.index=_738||0;
}
var _741=0;
for(var i=0;i<node.childNodes.length;i++){
var tcn=node.childNodes.item(i);
switch(tcn.nodeType){
case dojo.dom.ELEMENT_NODE:
var ctn=getDojoTagName(tcn)||getTagName(tcn);
if(!_73d[ctn]){
_73d[ctn]=[];
}
_73d[ctn].push(this.parseElement(tcn,true,_737,_741));
if((tcn.childNodes.length==1)&&(tcn.childNodes.item(0).nodeType==dojo.dom.TEXT_NODE)){
_73d[ctn][_73d[ctn].length-1].value=tcn.childNodes.item(0).nodeValue;
}
_741++;
break;
case dojo.dom.TEXT_NODE:
if(node.childNodes.length==1){
_73d[_739].push({value:node.childNodes.item(0).nodeValue});
}
break;
default:
break;
}
}
return _73d;
};
this.parseAttributes=function(node){
var _746={};
var atts=node.attributes;
var _748,i=0;
while((_748=atts[i++])){
if(isIE){
if(!_748){
continue;
}
if((typeof _748=="object")&&(typeof _748.nodeValue=="undefined")||(_748.nodeValue==null)||(_748.nodeValue=="")){
continue;
}
}
var nn=_748.nodeName.split(":");
nn=(nn.length==2)?nn[1]:_748.nodeName;
_746[nn]={value:_748.nodeValue};
}
return _746;
};
};
dojo.kwCompoundRequire({common:["dojo.dom"],browser:["dojo.html.*"],dashboard:["dojo.html.*"]});
dojo.provide("dojo.xml.*");
dojo.provide("dojo.undo.Manager");
dojo.undo.Manager=function(_74b){
this.clear();
this._parent=_74b;
};
dojo.extend(dojo.undo.Manager,{_parent:null,_undoStack:null,_redoStack:null,_currentManager:null,canUndo:false,canRedo:false,isUndoing:false,isRedoing:false,onUndo:function(_74c,item){
},onRedo:function(_74e,item){
},onUndoAny:function(_750,item){
},onRedoAny:function(_752,item){
},_updateStatus:function(){
this.canUndo=this._undoStack.length>0;
this.canRedo=this._redoStack.length>0;
},clear:function(){
this._undoStack=[];
this._redoStack=[];
this._currentManager=this;
this.isUndoing=false;
this.isRedoing=false;
this._updateStatus();
},undo:function(){
if(!this.canUndo){
return false;
}
this.endAllTransactions();
this.isUndoing=true;
var top=this._undoStack.pop();
if(top instanceof dojo.undo.Manager){
top.undoAll();
}else{
top.undo();
}
if(top.redo){
this._redoStack.push(top);
}
this.isUndoing=false;
this._updateStatus();
this.onUndo(this,top);
if(!(top instanceof dojo.undo.Manager)){
this.getTop().onUndoAny(this,top);
}
return true;
},redo:function(){
if(!this.canRedo){
return false;
}
this.isRedoing=true;
var top=this._redoStack.pop();
if(top instanceof dojo.undo.Manager){
top.redoAll();
}else{
top.redo();
}
this._undoStack.push(top);
this.isRedoing=false;
this._updateStatus();
this.onRedo(this,top);
if(!(top instanceof dojo.undo.Manager)){
this.getTop().onRedoAny(this,top);
}
return true;
},undoAll:function(){
while(this._undoStack.length>0){
this.undo();
}
},redoAll:function(){
while(this._redoStack.length>0){
this.redo();
}
},push:function(undo,redo,_758){
if(!undo){
return;
}
if(this._currentManager==this){
this._undoStack.push({undo:undo,redo:redo,description:_758});
}else{
this._currentManager.push.apply(this._currentManager,arguments);
}
this._redoStack=[];
this._updateStatus();
},concat:function(_759){
if(!_759){
return;
}
if(this._currentManager==this){
for(var x=0;x<_759._undoStack.length;x++){
this._undoStack.push(_759._undoStack[x]);
}
if(_759._undoStack.length>0){
this._redoStack=[];
}
this._updateStatus();
}else{
this._currentManager.concat.apply(this._currentManager,arguments);
}
},beginTransaction:function(_75b){
if(this._currentManager==this){
var mgr=new dojo.undo.Manager(this);
mgr.description=_75b?_75b:"";
this._undoStack.push(mgr);
this._currentManager=mgr;
return mgr;
}else{
this._currentManager=this._currentManager.beginTransaction.apply(this._currentManager,arguments);
}
},endTransaction:function(_75d){
if(this._currentManager==this){
if(this._parent){
this._parent._currentManager=this._parent;
if(this._undoStack.length==0||_75d){
var idx=dojo.lang.find(this._parent._undoStack,this);
if(idx>=0){
this._parent._undoStack.splice(idx,1);
if(_75d){
for(var x=0;x<this._undoStack.length;x++){
this._parent._undoStack.splice(idx++,0,this._undoStack[x]);
}
this._updateStatus();
}
}
}
return this._parent;
}
}else{
this._currentManager=this._currentManager.endTransaction.apply(this._currentManager,arguments);
}
},endAllTransactions:function(){
while(this._currentManager!=this){
this.endTransaction();
}
},getTop:function(){
if(this._parent){
return this._parent.getTop();
}else{
return this;
}
}});
dojo.provide("dojo.undo.*");
dojo.provide("dojo.crypto");
dojo.crypto.cipherModes={ECB:0,CBC:1,PCBC:2,CFB:3,OFB:4,CTR:5};
dojo.crypto.outputTypes={Base64:0,Hex:1,String:2,Raw:3};
dojo.provide("dojo.crypto.MD5");
dojo.crypto.MD5=new function(){
var _760=8;
var mask=(1<<_760)-1;
function toWord(s){
var wa=[];
for(var i=0;i<s.length*_760;i+=_760){
wa[i>>5]|=(s.charCodeAt(i/_760)&mask)<<(i%32);
}
return wa;
}
function toString(wa){
var s=[];
for(var i=0;i<wa.length*32;i+=_760){
s.push(String.fromCharCode((wa[i>>5]>>>(i%32))&mask));
}
return s.join("");
}
function toHex(wa){
var h="0123456789abcdef";
var s=[];
for(var i=0;i<wa.length*4;i++){
s.push(h.charAt((wa[i>>2]>>((i%4)*8+4))&15)+h.charAt((wa[i>>2]>>((i%4)*8))&15));
}
return s.join("");
}
function toBase64(wa){
var p="=";
var tab="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
var s=[];
for(var i=0;i<wa.length*4;i+=3){
var t=(((wa[i>>2]>>8*(i%4))&255)<<16)|(((wa[i+1>>2]>>8*((i+1)%4))&255)<<8)|((wa[i+2>>2]>>8*((i+2)%4))&255);
for(var j=0;j<4;j++){
if(i*8+j*6>wa.length*32){
s.push(p);
}else{
s.push(tab.charAt((t>>6*(3-j))&63));
}
}
}
return s.join("");
}
function add(x,y){
var l=(x&65535)+(y&65535);
var m=(x>>16)+(y>>16)+(l>>16);
return (m<<16)|(l&65535);
}
function R(n,c){
return (n<<c)|(n>>>(32-c));
}
function C(q,a,b,x,s,t){
return add(R(add(add(a,q),add(x,t)),s),b);
}
function FF(a,b,c,d,x,s,t){
return C((b&c)|((~b)&d),a,b,x,s,t);
}
function GG(a,b,c,d,x,s,t){
return C((b&d)|(c&(~d)),a,b,x,s,t);
}
function HH(a,b,c,d,x,s,t){
return C(b^c^d,a,b,x,s,t);
}
function II(a,b,c,d,x,s,t){
return C(c^(b|(~d)),a,b,x,s,t);
}
function core(x,len){
x[len>>5]|=128<<((len)%32);
x[(((len+64)>>>9)<<4)+14]=len;
var a=1732584193;
var b=-271733879;
var c=-1732584194;
var d=271733878;
for(var i=0;i<x.length;i+=16){
var olda=a;
var oldb=b;
var oldc=c;
var oldd=d;
a=FF(a,b,c,d,x[i+0],7,-680876936);
d=FF(d,a,b,c,x[i+1],12,-389564586);
c=FF(c,d,a,b,x[i+2],17,606105819);
b=FF(b,c,d,a,x[i+3],22,-1044525330);
a=FF(a,b,c,d,x[i+4],7,-176418897);
d=FF(d,a,b,c,x[i+5],12,1200080426);
c=FF(c,d,a,b,x[i+6],17,-1473231341);
b=FF(b,c,d,a,x[i+7],22,-45705983);
a=FF(a,b,c,d,x[i+8],7,1770035416);
d=FF(d,a,b,c,x[i+9],12,-1958414417);
c=FF(c,d,a,b,x[i+10],17,-42063);
b=FF(b,c,d,a,x[i+11],22,-1990404162);
a=FF(a,b,c,d,x[i+12],7,1804603682);
d=FF(d,a,b,c,x[i+13],12,-40341101);
c=FF(c,d,a,b,x[i+14],17,-1502002290);
b=FF(b,c,d,a,x[i+15],22,1236535329);
a=GG(a,b,c,d,x[i+1],5,-165796510);
d=GG(d,a,b,c,x[i+6],9,-1069501632);
c=GG(c,d,a,b,x[i+11],14,643717713);
b=GG(b,c,d,a,x[i+0],20,-373897302);
a=GG(a,b,c,d,x[i+5],5,-701558691);
d=GG(d,a,b,c,x[i+10],9,38016083);
c=GG(c,d,a,b,x[i+15],14,-660478335);
b=GG(b,c,d,a,x[i+4],20,-405537848);
a=GG(a,b,c,d,x[i+9],5,568446438);
d=GG(d,a,b,c,x[i+14],9,-1019803690);
c=GG(c,d,a,b,x[i+3],14,-187363961);
b=GG(b,c,d,a,x[i+8],20,1163531501);
a=GG(a,b,c,d,x[i+13],5,-1444681467);
d=GG(d,a,b,c,x[i+2],9,-51403784);
c=GG(c,d,a,b,x[i+7],14,1735328473);
b=GG(b,c,d,a,x[i+12],20,-1926607734);
a=HH(a,b,c,d,x[i+5],4,-378558);
d=HH(d,a,b,c,x[i+8],11,-2022574463);
c=HH(c,d,a,b,x[i+11],16,1839030562);
b=HH(b,c,d,a,x[i+14],23,-35309556);
a=HH(a,b,c,d,x[i+1],4,-1530992060);
d=HH(d,a,b,c,x[i+4],11,1272893353);
c=HH(c,d,a,b,x[i+7],16,-155497632);
b=HH(b,c,d,a,x[i+10],23,-1094730640);
a=HH(a,b,c,d,x[i+13],4,681279174);
d=HH(d,a,b,c,x[i+0],11,-358537222);
c=HH(c,d,a,b,x[i+3],16,-722521979);
b=HH(b,c,d,a,x[i+6],23,76029189);
a=HH(a,b,c,d,x[i+9],4,-640364487);
d=HH(d,a,b,c,x[i+12],11,-421815835);
c=HH(c,d,a,b,x[i+15],16,530742520);
b=HH(b,c,d,a,x[i+2],23,-995338651);
a=II(a,b,c,d,x[i+0],6,-198630844);
d=II(d,a,b,c,x[i+7],10,1126891415);
c=II(c,d,a,b,x[i+14],15,-1416354905);
b=II(b,c,d,a,x[i+5],21,-57434055);
a=II(a,b,c,d,x[i+12],6,1700485571);
d=II(d,a,b,c,x[i+3],10,-1894986606);
c=II(c,d,a,b,x[i+10],15,-1051523);
b=II(b,c,d,a,x[i+1],21,-2054922799);
a=II(a,b,c,d,x[i+8],6,1873313359);
d=II(d,a,b,c,x[i+15],10,-30611744);
c=II(c,d,a,b,x[i+6],15,-1560198380);
b=II(b,c,d,a,x[i+13],21,1309151649);
a=II(a,b,c,d,x[i+4],6,-145523070);
d=II(d,a,b,c,x[i+11],10,-1120210379);
c=II(c,d,a,b,x[i+2],15,718787259);
b=II(b,c,d,a,x[i+9],21,-343485551);
a=add(a,olda);
b=add(b,oldb);
c=add(c,oldc);
d=add(d,oldd);
}
return [a,b,c,d];
}
function hmac(data,key){
var wa=toWord(key);
if(wa.length>16){
wa=core(wa,key.length*_760);
}
var l=[],r=[];
for(var i=0;i<16;i++){
l[i]=wa[i]^909522486;
r[i]=wa[i]^1549556828;
}
var h=core(l.concat(toWord(data)),512+data.length*_760);
return core(r.concat(h),640);
}
this.compute=function(data,_7ae){
var out=_7ae||dojo.crypto.outputTypes.Base64;
switch(out){
case dojo.crypto.outputTypes.Hex:
return toHex(core(toWord(data),data.length*_760));
case dojo.crypto.outputTypes.String:
return toString(core(toWord(data),data.length*_760));
default:
return toBase64(core(toWord(data),data.length*_760));
}
};
this.getHMAC=function(data,key,_7b2){
var out=_7b2||dojo.crypto.outputTypes.Base64;
switch(out){
case dojo.crypto.outputTypes.Hex:
return toHex(hmac(data,key));
case dojo.crypto.outputTypes.String:
return toString(hmac(data,key));
default:
return toBase64(hmac(data,key));
}
};
}();
dojo.kwCompoundRequire({common:["dojo.crypto","dojo.crypto.MD5"]});
dojo.provide("dojo.crypto.*");
dojo.provide("dojo.collections.Collections");
dojo.collections.DictionaryEntry=function(k,v){
this.key=k;
this.value=v;
this.valueOf=function(){
return this.value;
};
this.toString=function(){
return String(this.value);
};
};
dojo.collections.Iterator=function(arr){
var a=arr;
var _7b8=0;
this.element=a[_7b8]||null;
this.atEnd=function(){
return (_7b8>=a.length);
};
this.get=function(){
if(this.atEnd()){
return null;
}
this.element=a[_7b8++];
return this.element;
};
this.map=function(fn,_7ba){
var s=_7ba||dj_global;
if(Array.map){
return Array.map(a,fn,s);
}else{
var arr=[];
for(var i=0;i<a.length;i++){
arr.push(fn.call(s,a[i]));
}
return arr;
}
};
this.reset=function(){
_7b8=0;
this.element=a[_7b8];
};
};
dojo.collections.DictionaryIterator=function(obj){
var a=[];
var _7c0={};
for(var p in obj){
if(!_7c0[p]){
a.push(obj[p]);
}
}
var _7c2=0;
this.element=a[_7c2]||null;
this.atEnd=function(){
return (_7c2>=a.length);
};
this.get=function(){
if(this.atEnd()){
return null;
}
this.element=a[_7c2++];
return this.element;
};
this.map=function(fn,_7c4){
var s=_7c4||dj_global;
if(Array.map){
return Array.map(a,fn,s);
}else{
var arr=[];
for(var i=0;i<a.length;i++){
arr.push(fn.call(s,a[i]));
}
return arr;
}
};
this.reset=function(){
_7c2=0;
this.element=a[_7c2];
};
};
dojo.provide("dojo.collections.ArrayList");
dojo.collections.ArrayList=function(arr){
var _7c9=[];
if(arr){
_7c9=_7c9.concat(arr);
}
this.count=_7c9.length;
this.add=function(obj){
_7c9.push(obj);
this.count=_7c9.length;
};
this.addRange=function(a){
if(a.getIterator){
var e=a.getIterator();
while(!e.atEnd()){
this.add(e.get());
}
this.count=_7c9.length;
}else{
for(var i=0;i<a.length;i++){
_7c9.push(a[i]);
}
this.count=_7c9.length;
}
};
this.clear=function(){
_7c9.splice(0,_7c9.length);
this.count=0;
};
this.clone=function(){
return new dojo.collections.ArrayList(_7c9);
};
this.contains=function(obj){
for(var i=0;i<_7c9.length;i++){
if(_7c9[i]==obj){
return true;
}
}
return false;
};
this.forEach=function(fn,_7d1){
var s=_7d1||dj_global;
if(Array.forEach){
Array.forEach(_7c9,fn,s);
}else{
for(var i=0;i<_7c9.length;i++){
fn.call(s,_7c9[i],i,_7c9);
}
}
};
this.getIterator=function(){
return new dojo.collections.Iterator(_7c9);
};
this.indexOf=function(obj){
for(var i=0;i<_7c9.length;i++){
if(_7c9[i]==obj){
return i;
}
}
return -1;
};
this.insert=function(i,obj){
_7c9.splice(i,0,obj);
this.count=_7c9.length;
};
this.item=function(i){
return _7c9[i];
};
this.remove=function(obj){
var i=this.indexOf(obj);
if(i>=0){
_7c9.splice(i,1);
}
this.count=_7c9.length;
};
this.removeAt=function(i){
_7c9.splice(i,1);
this.count=_7c9.length;
};
this.reverse=function(){
_7c9.reverse();
};
this.sort=function(fn){
if(fn){
_7c9.sort(fn);
}else{
_7c9.sort();
}
};
this.setByIndex=function(i,obj){
_7c9[i]=obj;
this.count=_7c9.length;
};
this.toArray=function(){
return [].concat(_7c9);
};
this.toString=function(_7df){
return _7c9.join((_7df||","));
};
};
dojo.provide("dojo.collections.Queue");
dojo.collections.Queue=function(arr){
var q=[];
if(arr){
q=q.concat(arr);
}
this.count=q.length;
this.clear=function(){
q=[];
this.count=q.length;
};
this.clone=function(){
return new dojo.collections.Queue(q);
};
this.contains=function(o){
for(var i=0;i<q.length;i++){
if(q[i]==o){
return true;
}
}
return false;
};
this.copyTo=function(arr,i){
arr.splice(i,0,q);
};
this.dequeue=function(){
var r=q.shift();
this.count=q.length;
return r;
};
this.enqueue=function(o){
this.count=q.push(o);
};
this.forEach=function(fn,_7e9){
var s=_7e9||dj_global;
if(Array.forEach){
Array.forEach(q,fn,s);
}else{
for(var i=0;i<q.length;i++){
fn.call(s,q[i],i,q);
}
}
};
this.getIterator=function(){
return new dojo.collections.Iterator(q);
};
this.peek=function(){
return q[0];
};
this.toArray=function(){
return [].concat(q);
};
};
dojo.provide("dojo.collections.Stack");
dojo.collections.Stack=function(arr){
var q=[];
if(arr){
q=q.concat(arr);
}
this.count=q.length;
this.clear=function(){
q=[];
this.count=q.length;
};
this.clone=function(){
return new dojo.collections.Stack(q);
};
this.contains=function(o){
for(var i=0;i<q.length;i++){
if(q[i]==o){
return true;
}
}
return false;
};
this.copyTo=function(arr,i){
arr.splice(i,0,q);
};
this.forEach=function(fn,_7f3){
var s=_7f3||dj_global;
if(Array.forEach){
Array.forEach(q,fn,s);
}else{
for(var i=0;i<q.length;i++){
fn.call(s,q[i],i,q);
}
}
};
this.getIterator=function(){
return new dojo.collections.Iterator(q);
};
this.peek=function(){
return q[(q.length-1)];
};
this.pop=function(){
var r=q.pop();
this.count=q.length;
return r;
};
this.push=function(o){
this.count=q.push(o);
};
this.toArray=function(){
return [].concat(q);
};
};
dojo.provide("dojo.dnd.DragAndDrop");
dojo.declare("dojo.dnd.DragSource",null,{type:"",onDragEnd:function(evt){
},onDragStart:function(evt){
},onSelected:function(evt){
},unregister:function(){
dojo.dnd.dragManager.unregisterDragSource(this);
},reregister:function(){
dojo.dnd.dragManager.registerDragSource(this);
}});
dojo.declare("dojo.dnd.DragObject",null,{type:"",register:function(){
var dm=dojo.dnd.dragManager;
if(dm["registerDragObject"]){
dm.registerDragObject(this);
}
},onDragStart:function(evt){
},onDragMove:function(evt){
},onDragOver:function(evt){
},onDragOut:function(evt){
},onDragEnd:function(evt){
},onDragLeave:dojo.lang.forward("onDragOut"),onDragEnter:dojo.lang.forward("onDragOver"),ondragout:dojo.lang.forward("onDragOut"),ondragover:dojo.lang.forward("onDragOver")});
dojo.declare("dojo.dnd.DropTarget",null,{acceptsType:function(type){
if(!dojo.lang.inArray(this.acceptedTypes,"*")){
if(!dojo.lang.inArray(this.acceptedTypes,type)){
return false;
}
}
return true;
},accepts:function(_802){
if(!dojo.lang.inArray(this.acceptedTypes,"*")){
for(var i=0;i<_802.length;i++){
if(!dojo.lang.inArray(this.acceptedTypes,_802[i].type)){
return false;
}
}
}
return true;
},unregister:function(){
dojo.dnd.dragManager.unregisterDropTarget(this);
},onDragOver:function(evt){
},onDragOut:function(evt){
},onDragMove:function(evt){
},onDropStart:function(evt){
},onDrop:function(evt){
},onDropEnd:function(){
}},function(){
this.acceptedTypes=[];
});
dojo.dnd.DragEvent=function(){
this.dragSource=null;
this.dragObject=null;
this.target=null;
this.eventStatus="success";
};
dojo.declare("dojo.dnd.DragManager",null,{selectedSources:[],dragObjects:[],dragSources:[],registerDragSource:function(_809){
},dropTargets:[],registerDropTarget:function(_80a){
},lastDragTarget:null,currentDragTarget:null,onKeyDown:function(){
},onMouseOut:function(){
},onMouseMove:function(){
},onMouseUp:function(){
}});
dojo.provide("dojo.dnd.HtmlDragManager");
dojo.declare("dojo.dnd.HtmlDragManager",dojo.dnd.DragManager,{disabled:false,nestedTargets:false,mouseDownTimer:null,dsCounter:0,dsPrefix:"dojoDragSource",dropTargetDimensions:[],currentDropTarget:null,previousDropTarget:null,_dragTriggered:false,selectedSources:[],dragObjects:[],dragSources:[],dropTargets:[],currentX:null,currentY:null,lastX:null,lastY:null,mouseDownX:null,mouseDownY:null,threshold:7,dropAcceptable:false,cancelEvent:function(e){
e.stopPropagation();
e.preventDefault();
},registerDragSource:function(ds){
if(ds["domNode"]){
var dp=this.dsPrefix;
var _80e=dp+"Idx_"+(this.dsCounter++);
ds.dragSourceId=_80e;
this.dragSources[_80e]=ds;
ds.domNode.setAttribute(dp,_80e);
if(dojo.render.html.ie){
dojo.event.browser.addListener(ds.domNode,"ondragstart",this.cancelEvent);
}
}
},unregisterDragSource:function(ds){
if(ds["domNode"]){
var dp=this.dsPrefix;
var _811=ds.dragSourceId;
delete ds.dragSourceId;
delete this.dragSources[_811];
ds.domNode.setAttribute(dp,null);
if(dojo.render.html.ie){
dojo.event.browser.removeListener(ds.domNode,"ondragstart",this.cancelEvent);
}
}
},registerDropTarget:function(dt){
this.dropTargets.push(dt);
},unregisterDropTarget:function(dt){
var _814=dojo.lang.find(this.dropTargets,dt,true);
if(_814>=0){
this.dropTargets.splice(_814,1);
}
},getDragSource:function(e){
var tn=e.target;
if(tn===dojo.body()){
return;
}
var ta=dojo.html.getAttribute(tn,this.dsPrefix);
while((!ta)&&(tn)){
tn=tn.parentNode;
if((!tn)||(tn===dojo.body())){
return;
}
ta=dojo.html.getAttribute(tn,this.dsPrefix);
}
return this.dragSources[ta];
},onKeyDown:function(e){
},onMouseDown:function(e){
if(this.disabled){
return;
}
if(dojo.render.html.ie){
if(e.button!=1){
return;
}
}else{
if(e.which!=1){
return;
}
}
var _81a=e.target.nodeType==dojo.html.TEXT_NODE?e.target.parentNode:e.target;
if(dojo.html.isTag(_81a,"button","textarea","input","select","option")){
return;
}
var ds=this.getDragSource(e);
if(!ds){
return;
}
if(!dojo.lang.inArray(this.selectedSources,ds)){
this.selectedSources.push(ds);
ds.onSelected();
}
this.mouseDownX=e.pageX;
this.mouseDownY=e.pageY;
e.preventDefault();
dojo.event.connect(document,"onmousemove",this,"onMouseMove");
},onMouseUp:function(e,_81d){
if(this.selectedSources.length==0){
return;
}
this.mouseDownX=null;
this.mouseDownY=null;
this._dragTriggered=false;
e.dragSource=this.dragSource;
if((!e.shiftKey)&&(!e.ctrlKey)){
if(this.currentDropTarget){
this.currentDropTarget.onDropStart();
}
dojo.lang.forEach(this.dragObjects,function(_81e){
var ret=null;
if(!_81e){
return;
}
if(this.currentDropTarget){
e.dragObject=_81e;
var ce=this.currentDropTarget.domNode.childNodes;
if(ce.length>0){
e.dropTarget=ce[0];
while(e.dropTarget==_81e.domNode){
e.dropTarget=e.dropTarget.nextSibling;
}
}else{
e.dropTarget=this.currentDropTarget.domNode;
}
if(this.dropAcceptable){
ret=this.currentDropTarget.onDrop(e);
}else{
this.currentDropTarget.onDragOut(e);
}
}
e.dragStatus=this.dropAcceptable&&ret?"dropSuccess":"dropFailure";
dojo.lang.delayThese([function(){
try{
_81e.dragSource.onDragEnd(e);
}
catch(err){
var _821={};
for(var i in e){
if(i=="type"){
_821.type="mouseup";
continue;
}
_821[i]=e[i];
}
_81e.dragSource.onDragEnd(_821);
}
},function(){
_81e.onDragEnd(e);
}]);
},this);
this.selectedSources=[];
this.dragObjects=[];
this.dragSource=null;
if(this.currentDropTarget){
this.currentDropTarget.onDropEnd();
}
}else{
}
dojo.event.disconnect(document,"onmousemove",this,"onMouseMove");
this.currentDropTarget=null;
},onScroll:function(){
for(var i=0;i<this.dragObjects.length;i++){
if(this.dragObjects[i].updateDragOffset){
this.dragObjects[i].updateDragOffset();
}
}
if(this.dragObjects.length){
this.cacheTargetLocations();
}
},_dragStartDistance:function(x,y){
if((!this.mouseDownX)||(!this.mouseDownX)){
return;
}
var dx=Math.abs(x-this.mouseDownX);
var dx2=dx*dx;
var dy=Math.abs(y-this.mouseDownY);
var dy2=dy*dy;
return parseInt(Math.sqrt(dx2+dy2),10);
},cacheTargetLocations:function(){
dojo.profile.start("cacheTargetLocations");
this.dropTargetDimensions=[];
dojo.lang.forEach(this.dropTargets,function(_82a){
var tn=_82a.domNode;
if(!tn||!_82a.accepts([this.dragSource])){
return;
}
var abs=dojo.html.getAbsolutePosition(tn,true);
var bb=dojo.html.getBorderBox(tn);
this.dropTargetDimensions.push([[abs.x,abs.y],[abs.x+bb.width,abs.y+bb.height],_82a]);
},this);
dojo.profile.end("cacheTargetLocations");
},onMouseMove:function(e){
if((dojo.render.html.ie)&&(e.button!=1)){
this.currentDropTarget=null;
this.onMouseUp(e,true);
return;
}
if((this.selectedSources.length)&&(!this.dragObjects.length)){
var dx;
var dy;
if(!this._dragTriggered){
this._dragTriggered=(this._dragStartDistance(e.pageX,e.pageY)>this.threshold);
if(!this._dragTriggered){
return;
}
dx=e.pageX-this.mouseDownX;
dy=e.pageY-this.mouseDownY;
}
this.dragSource=this.selectedSources[0];
dojo.lang.forEach(this.selectedSources,function(_831){
if(!_831){
return;
}
var tdo=_831.onDragStart(e);
if(tdo){
tdo.onDragStart(e);
tdo.dragOffset.y+=dy;
tdo.dragOffset.x+=dx;
tdo.dragSource=_831;
this.dragObjects.push(tdo);
}
},this);
this.previousDropTarget=null;
this.cacheTargetLocations();
}
dojo.lang.forEach(this.dragObjects,function(_833){
if(_833){
_833.onDragMove(e);
}
});
if(this.currentDropTarget){
var c=dojo.html.toCoordinateObject(this.currentDropTarget.domNode,true);
var dtp=[[c.x,c.y],[c.x+c.width,c.y+c.height]];
}
if((!this.nestedTargets)&&(dtp)&&(this.isInsideBox(e,dtp))){
if(this.dropAcceptable){
this.currentDropTarget.onDragMove(e,this.dragObjects);
}
}else{
var _836=this.findBestTarget(e);
if(_836.target===null){
if(this.currentDropTarget){
this.currentDropTarget.onDragOut(e);
this.previousDropTarget=this.currentDropTarget;
this.currentDropTarget=null;
}
this.dropAcceptable=false;
return;
}
if(this.currentDropTarget!==_836.target){
if(this.currentDropTarget){
this.previousDropTarget=this.currentDropTarget;
this.currentDropTarget.onDragOut(e);
}
this.currentDropTarget=_836.target;
e.dragObjects=this.dragObjects;
this.dropAcceptable=this.currentDropTarget.onDragOver(e);
}else{
if(this.dropAcceptable){
this.currentDropTarget.onDragMove(e,this.dragObjects);
}
}
}
},findBestTarget:function(e){
var _838=this;
var _839=new Object();
_839.target=null;
_839.points=null;
dojo.lang.every(this.dropTargetDimensions,function(_83a){
if(!_838.isInsideBox(e,_83a)){
return true;
}
_839.target=_83a[2];
_839.points=_83a;
return Boolean(_838.nestedTargets);
});
return _839;
},isInsideBox:function(e,_83c){
if((e.pageX>_83c[0][0])&&(e.pageX<_83c[1][0])&&(e.pageY>_83c[0][1])&&(e.pageY<_83c[1][1])){
return true;
}
return false;
},onMouseOver:function(e){
},onMouseOut:function(e){
}});
dojo.dnd.dragManager=new dojo.dnd.HtmlDragManager();
(function(){
var d=document;
var dm=dojo.dnd.dragManager;
dojo.event.connect(d,"onkeydown",dm,"onKeyDown");
dojo.event.connect(d,"onmouseover",dm,"onMouseOver");
dojo.event.connect(d,"onmouseout",dm,"onMouseOut");
dojo.event.connect(d,"onmousedown",dm,"onMouseDown");
dojo.event.connect(d,"onmouseup",dm,"onMouseUp");
dojo.event.connect(window,"onscroll",dm,"onScroll");
})();
dojo.provide("dojo.html.selection");
dojo.html.selectionType={NONE:0,TEXT:1,CONTROL:2};
dojo.html.clearSelection=function(){
var _841=dojo.global();
var _842=dojo.doc();
try{
if(_841["getSelection"]){
if(dojo.render.html.safari){
_841.getSelection().collapse();
}else{
_841.getSelection().removeAllRanges();
}
}else{
if(_842.selection){
if(_842.selection.empty){
_842.selection.empty();
}else{
if(_842.selection.clear){
_842.selection.clear();
}
}
}
}
return true;
}
catch(e){
dojo.debug(e);
return false;
}
};
dojo.html.disableSelection=function(_843){
_843=dojo.byId(_843)||dojo.body();
var h=dojo.render.html;
if(h.mozilla){
_843.style.MozUserSelect="none";
}else{
if(h.safari){
_843.style.KhtmlUserSelect="none";
}else{
if(h.ie){
_843.unselectable="on";
}else{
return false;
}
}
}
return true;
};
dojo.html.enableSelection=function(_845){
_845=dojo.byId(_845)||dojo.body();
var h=dojo.render.html;
if(h.mozilla){
_845.style.MozUserSelect="";
}else{
if(h.safari){
_845.style.KhtmlUserSelect="";
}else{
if(h.ie){
_845.unselectable="off";
}else{
return false;
}
}
}
return true;
};
dojo.html.selectElement=function(_847){
dojo.deprecated("dojo.html.selectElement","replaced by dojo.html.selection.selectElementChildren",0.5);
};
dojo.html.selectInputText=function(_848){
var _849=dojo.global();
var _84a=dojo.doc();
_848=dojo.byId(_848);
if(_84a["selection"]&&dojo.body()["createTextRange"]){
var _84b=_848.createTextRange();
_84b.moveStart("character",0);
_84b.moveEnd("character",_848.value.length);
_84b.select();
}else{
if(_849["getSelection"]){
var _84c=_849.getSelection();
_848.setSelectionRange(0,_848.value.length);
}
}
_848.focus();
};
dojo.html.isSelectionCollapsed=function(){
dojo.deprecated("dojo.html.isSelectionCollapsed","replaced by dojo.html.selection.isCollapsed",0.5);
return dojo.html.selection.isCollapsed();
};
dojo.lang.mixin(dojo.html.selection,{getType:function(){
if(dojo.doc()["selection"]){
return dojo.html.selectionType[dojo.doc().selection.type.toUpperCase()];
}else{
var _84d=dojo.html.selectionType.TEXT;
var oSel;
try{
oSel=dojo.global().getSelection();
}
catch(e){
}
if(oSel&&oSel.rangeCount==1){
var _84f=oSel.getRangeAt(0);
if(_84f.startContainer==_84f.endContainer&&(_84f.endOffset-_84f.startOffset)==1&&_84f.startContainer.nodeType!=dojo.dom.TEXT_NODE){
_84d=dojo.html.selectionType.CONTROL;
}
}
return _84d;
}
},isCollapsed:function(){
var _850=dojo.global();
var _851=dojo.doc();
if(_851["selection"]){
return _851.selection.createRange().text=="";
}else{
if(_850["getSelection"]){
var _852=_850.getSelection();
if(dojo.lang.isString(_852)){
return _852=="";
}else{
return _852.isCollapsed||_852.toString()=="";
}
}
}
},getSelectedElement:function(){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
if(dojo.doc()["selection"]){
var _853=dojo.doc().selection.createRange();
if(_853&&_853.item){
return dojo.doc().selection.createRange().item(0);
}
}else{
var _854=dojo.global().getSelection();
return _854.anchorNode.childNodes[_854.anchorOffset];
}
}
},getParentElement:function(){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
var p=dojo.html.selection.getSelectedElement();
if(p){
return p.parentNode;
}
}else{
if(dojo.doc()["selection"]){
return dojo.doc().selection.createRange().parentElement();
}else{
var _856=dojo.global().getSelection();
if(_856){
var node=_856.anchorNode;
while(node&&node.nodeType!=dojo.dom.ELEMENT_NODE){
node=node.parentNode;
}
return node;
}
}
}
},getSelectedText:function(){
if(dojo.doc()["selection"]){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
return null;
}
return dojo.doc().selection.createRange().text;
}else{
var _858=dojo.global().getSelection();
if(_858){
return _858.toString();
}
}
},getSelectedHtml:function(){
if(dojo.doc()["selection"]){
if(dojo.html.selection.getType()==dojo.html.selectionType.CONTROL){
return null;
}
return dojo.doc().selection.createRange().htmlText;
}else{
var _859=dojo.global().getSelection();
if(_859&&_859.rangeCount){
var frag=_859.getRangeAt(0).cloneContents();
var div=document.createElement("div");
div.appendChild(frag);
return div.innerHTML;
}
return null;
}
},hasAncestorElement:function(_85c){
return (dojo.html.selection.getAncestorElement.apply(this,arguments)!=null);
},getAncestorElement:function(_85d){
var node=dojo.html.selection.getSelectedElement()||dojo.html.selection.getParentElement();
while(node){
if(dojo.html.selection.isTag(node,arguments).length>0){
return node;
}
node=node.parentNode;
}
return null;
},isTag:function(node,tags){
if(node&&node.tagName){
for(var i=0;i<tags.length;i++){
if(node.tagName.toLowerCase()==String(tags[i]).toLowerCase()){
return String(tags[i]).toLowerCase();
}
}
}
return "";
},selectElement:function(_862){
var _863=dojo.global();
var _864=dojo.doc();
_862=dojo.byId(_862);
if(_864.selection&&dojo.body().createTextRange){
try{
var _865=dojo.body().createControlRange();
_865.addElement(_862);
_865.select();
}
catch(e){
dojo.html.selection.selectElementChildren(_862);
}
}else{
if(_863["getSelection"]){
var _866=_863.getSelection();
if(_866["removeAllRanges"]){
var _865=_864.createRange();
_865.selectNode(_862);
_866.removeAllRanges();
_866.addRange(_865);
}
}
}
},selectElementChildren:function(_867){
var _868=dojo.global();
var _869=dojo.doc();
_867=dojo.byId(_867);
if(_869.selection&&dojo.body().createTextRange){
var _86a=dojo.body().createTextRange();
_86a.moveToElementText(_867);
_86a.select();
}else{
if(_868["getSelection"]){
var _86b=_868.getSelection();
if(_86b["setBaseAndExtent"]){
_86b.setBaseAndExtent(_867,0,_867,_867.innerText.length-1);
}else{
if(_86b["selectAllChildren"]){
_86b.selectAllChildren(_867);
}
}
}
}
},getBookmark:function(){
var _86c;
var _86d=dojo.doc();
if(_86d["selection"]){
var _86e=_86d.selection.createRange();
_86c=_86e.getBookmark();
}else{
var _86f;
try{
_86f=dojo.global().getSelection();
}
catch(e){
}
if(_86f){
var _86e=_86f.getRangeAt(0);
_86c=_86e.cloneRange();
}else{
dojo.debug("No idea how to store the current selection for this browser!");
}
}
return _86c;
},moveToBookmark:function(_870){
var _871=dojo.doc();
if(_871["selection"]){
var _872=_871.selection.createRange();
_872.moveToBookmark(_870);
_872.select();
}else{
var _873;
try{
_873=dojo.global().getSelection();
}
catch(e){
}
if(_873&&_873["removeAllRanges"]){
_873.removeAllRanges();
_873.addRange(_870);
}else{
dojo.debug("No idea how to restore selection for this browser!");
}
}
},collapse:function(_874){
if(dojo.global()["getSelection"]){
var _875=dojo.global().getSelection();
if(_875.removeAllRanges){
if(_874){
_875.collapseToStart();
}else{
_875.collapseToEnd();
}
}else{
dojo.global().getSelection().collapse(_874);
}
}else{
if(dojo.doc().selection){
var _876=dojo.doc().selection.createRange();
_876.collapse(_874);
_876.select();
}
}
},remove:function(){
if(dojo.doc().selection){
var _877=dojo.doc().selection;
if(_877.type.toUpperCase()!="NONE"){
_877.clear();
}
return _877;
}else{
var _877=dojo.global().getSelection();
for(var i=0;i<_877.rangeCount;i++){
_877.getRangeAt(i).deleteContents();
}
return _877;
}
}});
dojo.provide("dojo.html.iframe");
dojo.html.iframeContentWindow=function(_879){
var win=dojo.html.getDocumentWindow(dojo.html.iframeContentDocument(_879))||dojo.html.iframeContentDocument(_879).__parent__||(_879.name&&document.frames[_879.name])||null;
return win;
};
dojo.html.iframeContentDocument=function(_87b){
var doc=_87b.contentDocument||((_87b.contentWindow)&&(_87b.contentWindow.document))||((_87b.name)&&(document.frames[_87b.name])&&(document.frames[_87b.name].document))||null;
return doc;
};
dojo.html.BackgroundIframe=function(node){
if(dojo.render.html.ie55||dojo.render.html.ie60){
var html="<iframe src='javascript:false'"+" style='position: absolute; left: 0px; top: 0px; width: 100%; height: 100%;"+"z-index: -1; filter:Alpha(Opacity=\"0\");' "+">";
this.iframe=dojo.doc().createElement(html);
this.iframe.tabIndex=-1;
if(node){
node.appendChild(this.iframe);
this.domNode=node;
}else{
dojo.body().appendChild(this.iframe);
this.iframe.style.display="none";
}
}
};
dojo.lang.extend(dojo.html.BackgroundIframe,{iframe:null,onResized:function(){
if(this.iframe&&this.domNode&&this.domNode.parentNode){
var _87f=dojo.html.getMarginBox(this.domNode);
if(_87f.width==0||_87f.height==0){
dojo.lang.setTimeout(this,this.onResized,100);
return;
}
this.iframe.style.width=_87f.width+"px";
this.iframe.style.height=_87f.height+"px";
}
},size:function(node){
if(!this.iframe){
return;
}
var _881=dojo.html.toCoordinateObject(node,true,dojo.html.boxSizing.BORDER_BOX);
with(this.iframe.style){
width=_881.width+"px";
height=_881.height+"px";
left=_881.left+"px";
top=_881.top+"px";
}
},setZIndex:function(node){
if(!this.iframe){
return;
}
if(dojo.dom.isNode(node)){
this.iframe.style.zIndex=dojo.html.getStyle(node,"z-index")-1;
}else{
if(!isNaN(node)){
this.iframe.style.zIndex=node;
}
}
},show:function(){
if(this.iframe){
this.iframe.style.display="block";
}
},hide:function(){
if(this.iframe){
this.iframe.style.display="none";
}
},remove:function(){
if(this.iframe){
dojo.html.removeNode(this.iframe,true);
delete this.iframe;
this.iframe=null;
}
}});
dojo.provide("dojo.dnd.HtmlDragAndDrop");
dojo.declare("dojo.dnd.HtmlDragSource",dojo.dnd.DragSource,{dragClass:"",onDragStart:function(){
var _883=new dojo.dnd.HtmlDragObject(this.dragObject,this.type);
if(this.dragClass){
_883.dragClass=this.dragClass;
}
if(this.constrainToContainer){
_883.constrainTo(this.constrainingContainer||this.domNode.parentNode);
}
return _883;
},setDragHandle:function(node){
node=dojo.byId(node);
dojo.dnd.dragManager.unregisterDragSource(this);
this.domNode=node;
dojo.dnd.dragManager.registerDragSource(this);
},setDragTarget:function(node){
this.dragObject=node;
},constrainTo:function(_886){
this.constrainToContainer=true;
if(_886){
this.constrainingContainer=_886;
}
},onSelected:function(){
for(var i=0;i<this.dragObjects.length;i++){
dojo.dnd.dragManager.selectedSources.push(new dojo.dnd.HtmlDragSource(this.dragObjects[i]));
}
},addDragObjects:function(el){
for(var i=0;i<arguments.length;i++){
this.dragObjects.push(dojo.byId(arguments[i]));
}
}},function(node,type){
node=dojo.byId(node);
this.dragObjects=[];
this.constrainToContainer=false;
if(node){
this.domNode=node;
this.dragObject=node;
this.type=(type)||(this.domNode.nodeName.toLowerCase());
dojo.dnd.DragSource.prototype.reregister.call(this);
}
});
dojo.declare("dojo.dnd.HtmlDragObject",dojo.dnd.DragObject,{dragClass:"",opacity:0.5,createIframe:true,disableX:false,disableY:false,createDragNode:function(){
var node=this.domNode.cloneNode(true);
if(this.dragClass){
dojo.html.addClass(node,this.dragClass);
}
if(this.opacity<1){
dojo.html.setOpacity(node,this.opacity);
}
var ltn=node.tagName.toLowerCase();
var isTr=(ltn=="tr");
if((isTr)||(ltn=="tbody")){
var doc=this.domNode.ownerDocument;
var _890=doc.createElement("table");
if(isTr){
var _891=doc.createElement("tbody");
_890.appendChild(_891);
_891.appendChild(node);
}else{
_890.appendChild(node);
}
var _892=((isTr)?this.domNode:this.domNode.firstChild);
var _893=((isTr)?node:node.firstChild);
var _894=_892.childNodes;
var _895=_893.childNodes;
for(var i=0;i<_894.length;i++){
if((_895[i])&&(_895[i].style)){
_895[i].style.width=dojo.html.getContentBox(_894[i]).width+"px";
}
}
node=_890;
}
if((dojo.render.html.ie55||dojo.render.html.ie60)&&this.createIframe){
with(node.style){
top="0px";
left="0px";
}
var _897=document.createElement("div");
_897.appendChild(node);
this.bgIframe=new dojo.html.BackgroundIframe(_897);
_897.appendChild(this.bgIframe.iframe);
node=_897;
}
node.style.zIndex=999;
return node;
},onDragStart:function(e){
dojo.html.clearSelection();
this.scrollOffset=dojo.html.getScroll().offset;
this.dragStartPosition=dojo.html.getAbsolutePosition(this.domNode,true);
this.dragOffset={y:this.dragStartPosition.y-e.pageY,x:this.dragStartPosition.x-e.pageX};
this.dragClone=this.createDragNode();
this.containingBlockPosition=this.domNode.offsetParent?dojo.html.getAbsolutePosition(this.domNode.offsetParent,true):{x:0,y:0};
if(this.constrainToContainer){
this.constraints=this.getConstraints();
}
with(this.dragClone.style){
position="absolute";
top=this.dragOffset.y+e.pageY+"px";
left=this.dragOffset.x+e.pageX+"px";
}
dojo.body().appendChild(this.dragClone);
dojo.event.topic.publish("dragStart",{source:this});
},getConstraints:function(){
if(this.constrainingContainer.nodeName.toLowerCase()=="body"){
var _899=dojo.html.getViewport();
var _89a=_899.width;
var _89b=_899.height;
var _89c=dojo.html.getScroll().offset;
var x=_89c.x;
var y=_89c.y;
}else{
var _89f=dojo.html.getContentBox(this.constrainingContainer);
_89a=_89f.width;
_89b=_89f.height;
x=this.containingBlockPosition.x+dojo.html.getPixelValue(this.constrainingContainer,"padding-left",true)+dojo.html.getBorderExtent(this.constrainingContainer,"left");
y=this.containingBlockPosition.y+dojo.html.getPixelValue(this.constrainingContainer,"padding-top",true)+dojo.html.getBorderExtent(this.constrainingContainer,"top");
}
var mb=dojo.html.getMarginBox(this.domNode);
return {minX:x,minY:y,maxX:x+_89a-mb.width,maxY:y+_89b-mb.height};
},updateDragOffset:function(){
var _8a1=dojo.html.getScroll().offset;
if(_8a1.y!=this.scrollOffset.y){
var diff=_8a1.y-this.scrollOffset.y;
this.dragOffset.y+=diff;
this.scrollOffset.y=_8a1.y;
}
if(_8a1.x!=this.scrollOffset.x){
var diff=_8a1.x-this.scrollOffset.x;
this.dragOffset.x+=diff;
this.scrollOffset.x=_8a1.x;
}
},onDragMove:function(e){
this.updateDragOffset();
var x=this.dragOffset.x+e.pageX;
var y=this.dragOffset.y+e.pageY;
if(this.constrainToContainer){
if(x<this.constraints.minX){
x=this.constraints.minX;
}
if(y<this.constraints.minY){
y=this.constraints.minY;
}
if(x>this.constraints.maxX){
x=this.constraints.maxX;
}
if(y>this.constraints.maxY){
y=this.constraints.maxY;
}
}
this.setAbsolutePosition(x,y);
dojo.event.topic.publish("dragMove",{source:this});
},setAbsolutePosition:function(x,y){
if(!this.disableY){
this.dragClone.style.top=y+"px";
}
if(!this.disableX){
this.dragClone.style.left=x+"px";
}
},onDragEnd:function(e){
switch(e.dragStatus){
case "dropSuccess":
dojo.html.removeNode(this.dragClone);
this.dragClone=null;
break;
case "dropFailure":
var _8a9=dojo.html.getAbsolutePosition(this.dragClone,true);
var _8aa={left:this.dragStartPosition.x+1,top:this.dragStartPosition.y+1};
var anim=dojo.lfx.slideTo(this.dragClone,_8aa,300);
var _8ac=this;
dojo.event.connect(anim,"onEnd",function(e){
dojo.html.removeNode(_8ac.dragClone);
_8ac.dragClone=null;
});
anim.play();
break;
}
dojo.event.topic.publish("dragEnd",{source:this});
},constrainTo:function(_8ae){
this.constrainToContainer=true;
if(_8ae){
this.constrainingContainer=_8ae;
}else{
this.constrainingContainer=this.domNode.parentNode;
}
}},function(node,type){
this.domNode=dojo.byId(node);
this.type=type;
this.constrainToContainer=false;
this.dragSource=null;
dojo.dnd.DragObject.prototype.register.call(this);
});
dojo.declare("dojo.dnd.HtmlDropTarget",dojo.dnd.DropTarget,{vertical:false,onDragOver:function(e){
if(!this.accepts(e.dragObjects)){
return false;
}
this.childBoxes=[];
for(var i=0,_8b3;i<this.domNode.childNodes.length;i++){
_8b3=this.domNode.childNodes[i];
if(_8b3.nodeType!=dojo.html.ELEMENT_NODE){
continue;
}
var pos=dojo.html.getAbsolutePosition(_8b3,true);
var _8b5=dojo.html.getBorderBox(_8b3);
this.childBoxes.push({top:pos.y,bottom:pos.y+_8b5.height,left:pos.x,right:pos.x+_8b5.width,height:_8b5.height,width:_8b5.width,node:_8b3});
}
return true;
},_getNodeUnderMouse:function(e){
for(var i=0,_8b8;i<this.childBoxes.length;i++){
with(this.childBoxes[i]){
if(e.pageX>=left&&e.pageX<=right&&e.pageY>=top&&e.pageY<=bottom){
return i;
}
}
}
return -1;
},createDropIndicator:function(){
this.dropIndicator=document.createElement("div");
with(this.dropIndicator.style){
position="absolute";
zIndex=999;
if(this.vertical){
borderLeftWidth="1px";
borderLeftColor="black";
borderLeftStyle="solid";
height=dojo.html.getBorderBox(this.domNode).height+"px";
top=dojo.html.getAbsolutePosition(this.domNode,true).y+"px";
}else{
borderTopWidth="1px";
borderTopColor="black";
borderTopStyle="solid";
width=dojo.html.getBorderBox(this.domNode).width+"px";
left=dojo.html.getAbsolutePosition(this.domNode,true).x+"px";
}
}
},onDragMove:function(e,_8ba){
var i=this._getNodeUnderMouse(e);
if(!this.dropIndicator){
this.createDropIndicator();
}
var _8bc=this.vertical?dojo.html.gravity.WEST:dojo.html.gravity.NORTH;
var hide=false;
if(i<0){
if(this.childBoxes.length){
var _8be=(dojo.html.gravity(this.childBoxes[0].node,e)&_8bc);
if(_8be){
hide=true;
}
}else{
var _8be=true;
}
}else{
var _8bf=this.childBoxes[i];
var _8be=(dojo.html.gravity(_8bf.node,e)&_8bc);
if(_8bf.node===_8ba[0].dragSource.domNode){
hide=true;
}else{
var _8c0=_8be?(i>0?this.childBoxes[i-1]:_8bf):(i<this.childBoxes.length-1?this.childBoxes[i+1]:_8bf);
if(_8c0.node===_8ba[0].dragSource.domNode){
hide=true;
}
}
}
if(hide){
this.dropIndicator.style.display="none";
return;
}else{
this.dropIndicator.style.display="";
}
this.placeIndicator(e,_8ba,i,_8be);
if(!dojo.html.hasParent(this.dropIndicator)){
dojo.body().appendChild(this.dropIndicator);
}
},placeIndicator:function(e,_8c2,_8c3,_8c4){
var _8c5=this.vertical?"left":"top";
var _8c6;
if(_8c3<0){
if(this.childBoxes.length){
_8c6=_8c4?this.childBoxes[0]:this.childBoxes[this.childBoxes.length-1];
}else{
this.dropIndicator.style[_8c5]=dojo.html.getAbsolutePosition(this.domNode,true)[this.vertical?"x":"y"]+"px";
}
}else{
_8c6=this.childBoxes[_8c3];
}
if(_8c6){
this.dropIndicator.style[_8c5]=(_8c4?_8c6[_8c5]:_8c6[this.vertical?"right":"bottom"])+"px";
if(this.vertical){
this.dropIndicator.style.height=_8c6.height+"px";
this.dropIndicator.style.top=_8c6.top+"px";
}else{
this.dropIndicator.style.width=_8c6.width+"px";
this.dropIndicator.style.left=_8c6.left+"px";
}
}
},onDragOut:function(e){
if(this.dropIndicator){
dojo.html.removeNode(this.dropIndicator);
delete this.dropIndicator;
}
},onDrop:function(e){
this.onDragOut(e);
var i=this._getNodeUnderMouse(e);
var _8ca=this.vertical?dojo.html.gravity.WEST:dojo.html.gravity.NORTH;
if(i<0){
if(this.childBoxes.length){
if(dojo.html.gravity(this.childBoxes[0].node,e)&_8ca){
return this.insert(e,this.childBoxes[0].node,"before");
}else{
return this.insert(e,this.childBoxes[this.childBoxes.length-1].node,"after");
}
}
return this.insert(e,this.domNode,"append");
}
var _8cb=this.childBoxes[i];
if(dojo.html.gravity(_8cb.node,e)&_8ca){
return this.insert(e,_8cb.node,"before");
}else{
return this.insert(e,_8cb.node,"after");
}
},insert:function(e,_8cd,_8ce){
var node=e.dragObject.domNode;
if(_8ce=="before"){
return dojo.html.insertBefore(node,_8cd);
}else{
if(_8ce=="after"){
return dojo.html.insertAfter(node,_8cd);
}else{
if(_8ce=="append"){
_8cd.appendChild(node);
return true;
}
}
}
return false;
}},function(node,_8d1){
if(arguments.length==0){
return;
}
this.domNode=dojo.byId(node);
dojo.dnd.DropTarget.call(this);
if(_8d1&&dojo.lang.isString(_8d1)){
_8d1=[_8d1];
}
this.acceptedTypes=_8d1||[];
dojo.dnd.dragManager.registerDropTarget(this);
});
dojo.kwCompoundRequire({common:["dojo.dnd.DragAndDrop"],browser:["dojo.dnd.HtmlDragAndDrop"],dashboard:["dojo.dnd.HtmlDragAndDrop"]});
dojo.provide("dojo.dnd.*");
dojo.provide("dojo.ns");
dojo.ns={namespaces:{},failed:{},loading:{},loaded:{},register:function(name,_8d3,_8d4,_8d5){
if(!_8d5||!this.namespaces[name]){
this.namespaces[name]=new dojo.ns.Ns(name,_8d3,_8d4);
}
},allow:function(name){
if(this.failed[name]){
return false;
}
if((djConfig.excludeNamespace)&&(dojo.lang.inArray(djConfig.excludeNamespace,name))){
return false;
}
return ((name==this.dojo)||(!djConfig.includeNamespace)||(dojo.lang.inArray(djConfig.includeNamespace,name)));
},get:function(name){
return this.namespaces[name];
},require:function(name){
var ns=this.namespaces[name];
if((ns)&&(this.loaded[name])){
return ns;
}
if(!this.allow(name)){
return false;
}
if(this.loading[name]){
dojo.debug("dojo.namespace.require: re-entrant request to load namespace \""+name+"\" must fail.");
return false;
}
var req=dojo.require;
this.loading[name]=true;
try{
if(name=="dojo"){
req("dojo.namespaces.dojo");
}else{
if(!dojo.hostenv.moduleHasPrefix(name)){
dojo.registerModulePath(name,"../"+name);
}
req([name,"manifest"].join("."),false,true);
}
if(!this.namespaces[name]){
this.failed[name]=true;
}
}
finally{
this.loading[name]=false;
}
return this.namespaces[name];
}};
dojo.ns.Ns=function(name,_8dc,_8dd){
this.name=name;
this.module=_8dc;
this.resolver=_8dd;
this._loaded=[];
this._failed=[];
};
dojo.ns.Ns.prototype.resolve=function(name,_8df,_8e0){
if(!this.resolver||djConfig["skipAutoRequire"]){
return false;
}
var _8e1=this.resolver(name,_8df);
if((_8e1)&&(!this._loaded[_8e1])&&(!this._failed[_8e1])){
var req=dojo.require;
req(_8e1,false,true);
if(dojo.hostenv.findModule(_8e1,false)){
this._loaded[_8e1]=true;
}else{
if(!_8e0){
dojo.raise("dojo.ns.Ns.resolve: module '"+_8e1+"' not found after loading via namespace '"+this.name+"'");
}
this._failed[_8e1]=true;
}
}
return Boolean(this._loaded[_8e1]);
};
dojo.registerNamespace=function(name,_8e4,_8e5){
dojo.ns.register.apply(dojo.ns,arguments);
};
dojo.registerNamespaceResolver=function(name,_8e7){
var n=dojo.ns.namespaces[name];
if(n){
n.resolver=_8e7;
}
};
dojo.registerNamespaceManifest=function(_8e9,path,name,_8ec,_8ed){
dojo.registerModulePath(name,path);
dojo.registerNamespace(name,_8ec,_8ed);
};
dojo.registerNamespace("dojo","dojo.widget");
dojo.provide("dojo.widget.Manager");
dojo.widget.manager=new function(){
this.widgets=[];
this.widgetIds=[];
this.topWidgets={};
var _8ee={};
var _8ef=[];
this.getUniqueId=function(_8f0){
var _8f1;
do{
_8f1=_8f0+"_"+(_8ee[_8f0]!=undefined?++_8ee[_8f0]:_8ee[_8f0]=0);
}while(this.getWidgetById(_8f1));
return _8f1;
};
this.add=function(_8f2){
this.widgets.push(_8f2);
if(!_8f2.extraArgs["id"]){
_8f2.extraArgs["id"]=_8f2.extraArgs["ID"];
}
if(_8f2.widgetId==""){
if(_8f2["id"]){
_8f2.widgetId=_8f2["id"];
}else{
if(_8f2.extraArgs["id"]){
_8f2.widgetId=_8f2.extraArgs["id"];
}else{
_8f2.widgetId=this.getUniqueId(_8f2.ns+"_"+_8f2.widgetType);
}
}
}
if(this.widgetIds[_8f2.widgetId]){
dojo.debug("widget ID collision on ID: "+_8f2.widgetId);
}
this.widgetIds[_8f2.widgetId]=_8f2;
};
this.destroyAll=function(){
for(var x=this.widgets.length-1;x>=0;x--){
try{
this.widgets[x].destroy(true);
delete this.widgets[x];
}
catch(e){
}
}
};
this.remove=function(_8f4){
if(dojo.lang.isNumber(_8f4)){
var tw=this.widgets[_8f4].widgetId;
delete this.topWidgets[tw];
delete this.widgetIds[tw];
this.widgets.splice(_8f4,1);
}else{
this.removeById(_8f4);
}
};
this.removeById=function(id){
if(!dojo.lang.isString(id)){
id=id["widgetId"];
if(!id){
dojo.debug("invalid widget or id passed to removeById");
return;
}
}
for(var i=0;i<this.widgets.length;i++){
if(this.widgets[i].widgetId==id){
this.remove(i);
break;
}
}
};
this.getWidgetById=function(id){
if(dojo.lang.isString(id)){
return this.widgetIds[id];
}
return id;
};
this.getWidgetsByType=function(type){
var lt=type.toLowerCase();
var _8fb=(type.indexOf(":")<0?function(x){
return x.widgetType.toLowerCase();
}:function(x){
return x.getNamespacedType();
});
var ret=[];
dojo.lang.forEach(this.widgets,function(x){
if(_8fb(x)==lt){
ret.push(x);
}
});
return ret;
};
this.getWidgetsByFilter=function(_900,_901){
var ret=[];
dojo.lang.every(this.widgets,function(x){
if(_900(x)){
ret.push(x);
if(_901){
return false;
}
}
return true;
});
return (_901?ret[0]:ret);
};
this.getAllWidgets=function(){
return this.widgets.concat();
};
this.getWidgetByNode=function(node){
var w=this.getAllWidgets();
node=dojo.byId(node);
for(var i=0;i<w.length;i++){
if(w[i].domNode==node){
return w[i];
}
}
return null;
};
this.byId=this.getWidgetById;
this.byType=this.getWidgetsByType;
this.byFilter=this.getWidgetsByFilter;
this.byNode=this.getWidgetByNode;
var _907={};
var _908=["dojo.widget"];
for(var i=0;i<_908.length;i++){
_908[_908[i]]=true;
}
this.registerWidgetPackage=function(_90a){
if(!_908[_90a]){
_908[_90a]=true;
_908.push(_90a);
}
};
this.getWidgetPackageList=function(){
return dojo.lang.map(_908,function(elt){
return (elt!==true?elt:undefined);
});
};
this.getImplementation=function(_90c,_90d,_90e,ns){
var impl=this.getImplementationName(_90c,ns);
if(impl){
var ret=_90d?new impl(_90d):new impl();
return ret;
}
};
function buildPrefixCache(){
for(var _912 in dojo.render){
if(dojo.render[_912]["capable"]===true){
var _913=dojo.render[_912].prefixes;
for(var i=0;i<_913.length;i++){
_8ef.push(_913[i].toLowerCase());
}
}
}
}
var _915=function(_916,_917){
if(!_917){
return null;
}
for(var i=0,l=_8ef.length,_91a;i<=l;i++){
_91a=(i<l?_917[_8ef[i]]:_917);
if(!_91a){
continue;
}
for(var name in _91a){
if(name.toLowerCase()==_916){
return _91a[name];
}
}
}
return null;
};
var _91c=function(_91d,_91e){
var _91f=dojo.evalObjPath(_91e,false);
return (_91f?_915(_91d,_91f):null);
};
this.getImplementationName=function(_920,ns){
var _922=_920.toLowerCase();
ns=ns||"dojo";
var imps=_907[ns]||(_907[ns]={});
var impl=imps[_922];
if(impl){
return impl;
}
if(!_8ef.length){
buildPrefixCache();
}
var _925=dojo.ns.get(ns);
if(!_925){
dojo.ns.register(ns,ns+".widget");
_925=dojo.ns.get(ns);
}
if(_925){
_925.resolve(_920);
}
impl=_91c(_922,_925.module);
if(impl){
return (imps[_922]=impl);
}
_925=dojo.ns.require(ns);
if((_925)&&(_925.resolver)){
_925.resolve(_920);
impl=_91c(_922,_925.module);
if(impl){
return (imps[_922]=impl);
}
}
dojo.deprecated("dojo.widget.Manager.getImplementationName","Could not locate widget implementation for \""+_920+"\" in \""+_925.module+"\" registered to namespace \""+_925.name+"\". "+"Developers must specify correct namespaces for all non-Dojo widgets","0.5");
for(var i=0;i<_908.length;i++){
impl=_91c(_922,_908[i]);
if(impl){
return (imps[_922]=impl);
}
}
throw new Error("Could not locate widget implementation for \""+_920+"\" in \""+_925.module+"\" registered to namespace \""+_925.name+"\"");
};
this.resizing=false;
this.onWindowResized=function(){
if(this.resizing){
return;
}
try{
this.resizing=true;
for(var id in this.topWidgets){
var _928=this.topWidgets[id];
if(_928.checkSize){
_928.checkSize();
}
}
}
catch(e){
}
finally{
this.resizing=false;
}
};
if(typeof window!="undefined"){
dojo.addOnLoad(this,"onWindowResized");
dojo.event.connect(window,"onresize",this,"onWindowResized");
}
};
(function(){
var dw=dojo.widget;
var dwm=dw.manager;
var h=dojo.lang.curry(dojo.lang,"hitch",dwm);
var g=function(_92d,_92e){
dw[(_92e||_92d)]=h(_92d);
};
g("add","addWidget");
g("destroyAll","destroyAllWidgets");
g("remove","removeWidget");
g("removeById","removeWidgetById");
g("getWidgetById");
g("getWidgetById","byId");
g("getWidgetsByType");
g("getWidgetsByFilter");
g("getWidgetsByType","byType");
g("getWidgetsByFilter","byFilter");
g("getWidgetByNode","byNode");
dw.all=function(n){
var _930=dwm.getAllWidgets.apply(dwm,arguments);
if(arguments.length>0){
return _930[n];
}
return _930;
};
g("registerWidgetPackage");
g("getImplementation","getWidgetImplementation");
g("getImplementationName","getWidgetImplementationName");
dw.widgets=dwm.widgets;
dw.widgetIds=dwm.widgetIds;
dw.root=dwm.root;
})();
dojo.provide("dojo.a11y");
dojo.a11y={imgPath:dojo.uri.moduleUri("dojo.widget","templates/images"),doAccessibleCheck:true,accessible:null,checkAccessible:function(){
if(this.accessible===null){
this.accessible=false;
if(this.doAccessibleCheck==true){
this.accessible=this.testAccessible();
}
}
return this.accessible;
},testAccessible:function(){
this.accessible=false;
if(dojo.render.html.ie||dojo.render.html.mozilla){
var div=document.createElement("div");
div.style.backgroundImage="url(\""+this.imgPath+"/tab_close.gif\")";
dojo.body().appendChild(div);
var _932=null;
if(window.getComputedStyle){
var _933=getComputedStyle(div,"");
_932=_933.getPropertyValue("background-image");
}else{
_932=div.currentStyle.backgroundImage;
}
var _934=false;
if(_932!=null&&(_932=="none"||_932=="url(invalid-url:)")){
this.accessible=true;
}
dojo.body().removeChild(div);
}
return this.accessible;
},setCheckAccessible:function(_935){
this.doAccessibleCheck=_935;
},setAccessibleMode:function(){
if(this.accessible===null){
if(this.checkAccessible()){
dojo.render.html.prefixes.unshift("a11y");
}
}
return this.accessible;
}};
dojo.provide("dojo.widget.Widget");
dojo.declare("dojo.widget.Widget",null,function(){
this.children=[];
this.extraArgs={};
},{parent:null,isTopLevel:false,disabled:false,isContainer:false,widgetId:"",widgetType:"Widget",ns:"dojo",getNamespacedType:function(){
return (this.ns?this.ns+":"+this.widgetType:this.widgetType).toLowerCase();
},toString:function(){
return "[Widget "+this.getNamespacedType()+", "+(this.widgetId||"NO ID")+"]";
},repr:function(){
return this.toString();
},enable:function(){
this.disabled=false;
},disable:function(){
this.disabled=true;
},onResized:function(){
this.notifyChildrenOfResize();
},notifyChildrenOfResize:function(){
for(var i=0;i<this.children.length;i++){
var _937=this.children[i];
if(_937.onResized){
_937.onResized();
}
}
},create:function(args,_939,_93a,ns){
if(ns){
this.ns=ns;
}
this.satisfyPropertySets(args,_939,_93a);
this.mixInProperties(args,_939,_93a);
this.postMixInProperties(args,_939,_93a);
dojo.widget.manager.add(this);
this.buildRendering(args,_939,_93a);
this.initialize(args,_939,_93a);
this.postInitialize(args,_939,_93a);
this.postCreate(args,_939,_93a);
return this;
},destroy:function(_93c){
if(this.parent){
this.parent.removeChild(this);
}
this.destroyChildren();
this.uninitialize();
this.destroyRendering(_93c);
dojo.widget.manager.removeById(this.widgetId);
},destroyChildren:function(){
var _93d;
var i=0;
while(this.children.length>i){
_93d=this.children[i];
if(_93d instanceof dojo.widget.Widget){
this.removeChild(_93d);
_93d.destroy();
continue;
}
i++;
}
},getChildrenOfType:function(type,_940){
var ret=[];
var _942=dojo.lang.isFunction(type);
if(!_942){
type=type.toLowerCase();
}
for(var x=0;x<this.children.length;x++){
if(_942){
if(this.children[x] instanceof type){
ret.push(this.children[x]);
}
}else{
if(this.children[x].widgetType.toLowerCase()==type){
ret.push(this.children[x]);
}
}
if(_940){
ret=ret.concat(this.children[x].getChildrenOfType(type,_940));
}
}
return ret;
},getDescendants:function(){
var _944=[];
var _945=[this];
var elem;
while((elem=_945.pop())){
_944.push(elem);
if(elem.children){
dojo.lang.forEach(elem.children,function(elem){
_945.push(elem);
});
}
}
return _944;
},isFirstChild:function(){
return this===this.parent.children[0];
},isLastChild:function(){
return this===this.parent.children[this.parent.children.length-1];
},satisfyPropertySets:function(args){
return args;
},mixInProperties:function(args,frag){
if((args["fastMixIn"])||(frag["fastMixIn"])){
for(var x in args){
this[x]=args[x];
}
return;
}
var _94c;
var _94d=dojo.widget.lcArgsCache[this.widgetType];
if(_94d==null){
_94d={};
for(var y in this){
_94d[((new String(y)).toLowerCase())]=y;
}
dojo.widget.lcArgsCache[this.widgetType]=_94d;
}
var _94f={};
for(var x in args){
if(!this[x]){
var y=_94d[(new String(x)).toLowerCase()];
if(y){
args[y]=args[x];
x=y;
}
}
if(_94f[x]){
continue;
}
_94f[x]=true;
if((typeof this[x])!=(typeof _94c)){
if(typeof args[x]!="string"){
this[x]=args[x];
}else{
if(dojo.lang.isString(this[x])){
this[x]=args[x];
}else{
if(dojo.lang.isNumber(this[x])){
this[x]=new Number(args[x]);
}else{
if(dojo.lang.isBoolean(this[x])){
this[x]=(args[x].toLowerCase()=="false")?false:true;
}else{
if(dojo.lang.isFunction(this[x])){
if(args[x].search(/[^\w\.]+/i)==-1){
this[x]=dojo.evalObjPath(args[x],false);
}else{
var tn=dojo.lang.nameAnonFunc(new Function(args[x]),this);
dojo.event.kwConnect({srcObj:this,srcFunc:x,adviceObj:this,adviceFunc:tn});
}
}else{
if(dojo.lang.isArray(this[x])){
this[x]=args[x].split(";");
}else{
if(this[x] instanceof Date){
this[x]=new Date(Number(args[x]));
}else{
if(typeof this[x]=="object"){
if(this[x] instanceof dojo.uri.Uri){
this[x]=dojo.uri.dojoUri(args[x]);
}else{
var _951=args[x].split(";");
for(var y=0;y<_951.length;y++){
var si=_951[y].indexOf(":");
if((si!=-1)&&(_951[y].length>si)){
this[x][_951[y].substr(0,si).replace(/^\s+|\s+$/g,"")]=_951[y].substr(si+1);
}
}
}
}else{
this[x]=args[x];
}
}
}
}
}
}
}
}
}else{
this.extraArgs[x.toLowerCase()]=args[x];
}
}
},postMixInProperties:function(args,frag,_955){
},initialize:function(args,frag,_958){
return false;
},postInitialize:function(args,frag,_95b){
return false;
},postCreate:function(args,frag,_95e){
return false;
},uninitialize:function(){
return false;
},buildRendering:function(args,frag,_961){
dojo.unimplemented("dojo.widget.Widget.buildRendering, on "+this.toString()+", ");
return false;
},destroyRendering:function(){
dojo.unimplemented("dojo.widget.Widget.destroyRendering");
return false;
},addedTo:function(_962){
},addChild:function(_963){
dojo.unimplemented("dojo.widget.Widget.addChild");
return false;
},removeChild:function(_964){
for(var x=0;x<this.children.length;x++){
if(this.children[x]===_964){
this.children.splice(x,1);
_964.parent=null;
break;
}
}
return _964;
},getPreviousSibling:function(){
var idx=this.getParentIndex();
if(idx<=0){
return null;
}
return this.parent.children[idx-1];
},getSiblings:function(){
return this.parent.children;
},getParentIndex:function(){
return dojo.lang.indexOf(this.parent.children,this,true);
},getNextSibling:function(){
var idx=this.getParentIndex();
if(idx==this.parent.children.length-1){
return null;
}
if(idx<0){
return null;
}
return this.parent.children[idx+1];
}});
dojo.widget.lcArgsCache={};
dojo.widget.tags={};
dojo.widget.tags.addParseTreeHandler=function(type){
dojo.deprecated("addParseTreeHandler",". ParseTreeHandlers are now reserved for components. Any unfiltered DojoML tag without a ParseTreeHandler is assumed to be a widget","0.5");
};
dojo.widget.tags["dojo:propertyset"]=function(_969,_96a,_96b){
var _96c=_96a.parseProperties(_969["dojo:propertyset"]);
};
dojo.widget.tags["dojo:connect"]=function(_96d,_96e,_96f){
var _970=_96e.parseProperties(_96d["dojo:connect"]);
};
dojo.widget.buildWidgetFromParseTree=function(type,frag,_973,_974,_975,_976){
dojo.a11y.setAccessibleMode();
var _977=type.split(":");
_977=(_977.length==2)?_977[1]:type;
var _978=_976||_973.parseProperties(frag[frag["ns"]+":"+_977]);
var _979=dojo.widget.manager.getImplementation(_977,null,null,frag["ns"]);
if(!_979){
throw new Error("cannot find \""+type+"\" widget");
}else{
if(!_979.create){
throw new Error("\""+type+"\" widget object has no \"create\" method and does not appear to implement *Widget");
}
}
_978["dojoinsertionindex"]=_975;
var ret=_979.create(_978,frag,_974,frag["ns"]);
return ret;
};
dojo.widget.defineWidget=function(_97b,_97c,_97d,init,_97f){
if(dojo.lang.isString(arguments[3])){
dojo.widget._defineWidget(arguments[0],arguments[3],arguments[1],arguments[4],arguments[2]);
}else{
var args=[arguments[0]],p=3;
if(dojo.lang.isString(arguments[1])){
args.push(arguments[1],arguments[2]);
}else{
args.push("",arguments[1]);
p=2;
}
if(dojo.lang.isFunction(arguments[p])){
args.push(arguments[p],arguments[p+1]);
}else{
args.push(null,arguments[p]);
}
dojo.widget._defineWidget.apply(this,args);
}
};
dojo.widget.defineWidget.renderers="html|svg|vml";
dojo.widget._defineWidget=function(_982,_983,_984,init,_986){
var _987=_982.split(".");
var type=_987.pop();
var regx="\\.("+(_983?_983+"|":"")+dojo.widget.defineWidget.renderers+")\\.";
var r=_982.search(new RegExp(regx));
_987=(r<0?_987.join("."):_982.substr(0,r));
dojo.widget.manager.registerWidgetPackage(_987);
var pos=_987.indexOf(".");
var _98c=(pos>-1)?_987.substring(0,pos):_987;
_986=(_986)||{};
_986.widgetType=type;
if((!init)&&(_986["classConstructor"])){
init=_986.classConstructor;
delete _986.classConstructor;
}
dojo.declare(_982,_984,init,_986);
};
dojo.provide("dojo.widget.Parse");
dojo.widget.Parse=function(_98d){
this.propertySetsList=[];
this.fragment=_98d;
this.createComponents=function(frag,_98f){
var _990=[];
var _991=false;
try{
if(frag&&frag.tagName&&(frag!=frag.nodeRef)){
var _992=dojo.widget.tags;
var tna=String(frag.tagName).split(";");
for(var x=0;x<tna.length;x++){
var ltn=tna[x].replace(/^\s+|\s+$/g,"").toLowerCase();
frag.tagName=ltn;
var ret;
if(_992[ltn]){
_991=true;
ret=_992[ltn](frag,this,_98f,frag.index);
_990.push(ret);
}else{
if(ltn.indexOf(":")==-1){
ltn="dojo:"+ltn;
}
ret=dojo.widget.buildWidgetFromParseTree(ltn,frag,this,_98f,frag.index);
if(ret){
_991=true;
_990.push(ret);
}
}
}
}
}
catch(e){
dojo.debug("dojo.widget.Parse: error:",e);
}
if(!_991){
_990=_990.concat(this.createSubComponents(frag,_98f));
}
return _990;
};
this.createSubComponents=function(_997,_998){
var frag,_99a=[];
for(var item in _997){
frag=_997[item];
if(frag&&typeof frag=="object"&&(frag!=_997.nodeRef)&&(frag!=_997.tagName)&&(!dojo.dom.isNode(frag))){
_99a=_99a.concat(this.createComponents(frag,_998));
}
}
return _99a;
};
this.parsePropertySets=function(_99c){
return [];
};
this.parseProperties=function(_99d){
var _99