# Generated by default/object.tt
package Paws::LexModelsV2::ImportSummary;
  use Moose;
  has CreationDateTime => (is => 'ro', isa => 'Str', request_name => 'creationDateTime', traits => ['NameInRequest']);
  has ImportedResourceId => (is => 'ro', isa => 'Str', request_name => 'importedResourceId', traits => ['NameInRequest']);
  has ImportedResourceName => (is => 'ro', isa => 'Str', request_name => 'importedResourceName', traits => ['NameInRequest']);
  has ImportId => (is => 'ro', isa => 'Str', request_name => 'importId', traits => ['NameInRequest']);
  has ImportStatus => (is => 'ro', isa => 'Str', request_name => 'importStatus', traits => ['NameInRequest']);
  has LastUpdatedDateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedDateTime', traits => ['NameInRequest']);
  has MergeStrategy => (is => 'ro', isa => 'Str', request_name => 'mergeStrategy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::ImportSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::ImportSummary object:

  $service_obj->Method(Att1 => { CreationDateTime => $value, ..., MergeStrategy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::ImportSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationDateTime

=head1 DESCRIPTION

Provides summary information about an import in an import list.

=head1 ATTRIBUTES


=head2 CreationDateTime => Str

The date and time that the import was created.


=head2 ImportedResourceId => Str

The unique identifier that Amazon Lex assigned to the imported
resource.


=head2 ImportedResourceName => Str

The name that you gave the imported resource.


=head2 ImportId => Str

The unique identifier that Amazon Lex assigned to the import.


=head2 ImportStatus => Str

The status of the resource. When the status is C<Completed> the
resource is ready to build.


=head2 LastUpdatedDateTime => Str

The date and time that the import was last updated.


=head2 MergeStrategy => Str

The strategy used to merge existing bot or bot locale definitions with
the imported definition.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

