# Generated by default/object.tt
package Paws::LookoutEquipment::InferenceExecutionSummary;
  use Moose;
  has CustomerResultObject => (is => 'ro', isa => 'Paws::LookoutEquipment::S3Object');
  has DataEndTime => (is => 'ro', isa => 'Str');
  has DataInputConfiguration => (is => 'ro', isa => 'Paws::LookoutEquipment::InferenceInputConfiguration');
  has DataOutputConfiguration => (is => 'ro', isa => 'Paws::LookoutEquipment::InferenceOutputConfiguration');
  has DataStartTime => (is => 'ro', isa => 'Str');
  has FailedReason => (is => 'ro', isa => 'Str');
  has InferenceSchedulerArn => (is => 'ro', isa => 'Str');
  has InferenceSchedulerName => (is => 'ro', isa => 'Str');
  has ModelArn => (is => 'ro', isa => 'Str');
  has ModelName => (is => 'ro', isa => 'Str');
  has ScheduledStartTime => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutEquipment::InferenceExecutionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutEquipment::InferenceExecutionSummary object:

  $service_obj->Method(Att1 => { CustomerResultObject => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutEquipment::InferenceExecutionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CustomerResultObject

=head1 DESCRIPTION

Contains information about the specific inference execution, including
input and output data configuration, inference scheduling information,
status, and so on.

=head1 ATTRIBUTES


=head2 CustomerResultObject => L<Paws::LookoutEquipment::S3Object>




=head2 DataEndTime => Str

Indicates the time reference in the dataset at which the inference
execution stopped.


=head2 DataInputConfiguration => L<Paws::LookoutEquipment::InferenceInputConfiguration>

Specifies configuration information for the input data for the
inference scheduler, including delimiter, format, and dataset location.


=head2 DataOutputConfiguration => L<Paws::LookoutEquipment::InferenceOutputConfiguration>

Specifies configuration information for the output results from for the
inference execution, including the output S3 location.


=head2 DataStartTime => Str

Indicates the time reference in the dataset at which the inference
execution began.


=head2 FailedReason => Str

Specifies the reason for failure when an inference execution has
failed.


=head2 InferenceSchedulerArn => Str

The Amazon Resource Name (ARN) of the inference scheduler being used
for the inference execution.


=head2 InferenceSchedulerName => Str

The name of the inference scheduler being used for the inference
execution.


=head2 ModelArn => Str

The Amazon Resource Name (ARN) of the ML model used for the inference
execution.


=head2 ModelName => Str

The name of the ML model being used for the inference execution.


=head2 ScheduledStartTime => Str

Indicates the start time at which the inference scheduler began the
specific inference execution.


=head2 Status => Str

Indicates the status of the inference execution.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutEquipment>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

