#!/usr/bin/perl
use strict;
use warnings;
use Data::Dumper;
use Test::More 'no_plan';
use Bio::Phylo::IO 'parse';
use Bio::Phylo::Util::Logger ':levels';
use Bio::Phylo::Util::CONSTANT ':objecttypes';

eval { require Statistics::R };

SKIP: {
	skip 'Statistics::R not installed', 7, if $@;
	
	# get the data
	my $project = parse(
		'-format'     => 'nexus',
		'-handle'     => \*DATA,
		'-as_project' => 1,
	);
	my ($tree) = @{ $project->get_items(_TREE_) };
	my ($matrix) = @{ $project->get_items(_MATRIX_) };
	my ($taxa) = @{ $project->get_items(_TAXA_) };
	
	# do the replication
	my $rep = $matrix->replicate('-tree'=>$tree, '-seed'=>123);
	ok($rep);
	ok($rep->get_nchar == 4);
	ok($rep->get_ntax == 200);
	
	# going to compare states
	my $raw_rep = $rep->get_raw;
	my $raw_exp = $matrix->get_raw;
	
	# characters 1 and 2 should be invariant
	for my $i ( 1 .. 2 ) {
		my @obs = map { $_->[$i] } @{ $raw_rep };
		my @exp = map { $_->[$i] } @{ $raw_exp };
		is_deeply( \@obs, \@exp );
	}
	
	# if you look at the ratios of states 1:0 between observed and 
	# expected they are in the same ballpark
	for my $i ( 3 .. 4 ) {
		my ( %seen_obs, %seen_exp );
		my %obs = map { $_->[$i] => ++$seen_obs{$_->[$i]} } @{ $raw_rep };
		my %exp = map { $_->[$i] => ++$seen_exp{$_->[$i]} } @{ $raw_exp };

		# so the test here is that for both characters it CANNOT be the case
		# that the ratio 1:0 is < 1 for observed but > 1 for expected, or vice versa
		ok( ! ( ( $obs{"1"} / $obs{"0"} ) < 1 ) ^ ( ( $exp{"1"} / $exp{"0"} ) < 1 ) );
		
	}
		
	# write output
	# $rep->set_taxa($taxa);
	# $project->insert($rep);		
	# print $project->to_nexus;
};

__DATA__
#NEXUS

BEGIN TAXA;
	TITLE Taxa;
	DIMENSIONS NTAX=200;
	TAXLABELS
		taxon_1 taxon_2 taxon_3 taxon_4 taxon_5 taxon_6 taxon_7 taxon_8 taxon_9 taxon_10 taxon_11 taxon_12 taxon_13 taxon_14 taxon_15 taxon_16 taxon_17 taxon_18 taxon_19 taxon_20 taxon_21 taxon_22 taxon_23 taxon_24 taxon_25 taxon_26 taxon_27 taxon_28 taxon_29 taxon_30 taxon_31 taxon_32 taxon_33 taxon_34 taxon_35 taxon_36 taxon_37 taxon_38 taxon_39 taxon_40 taxon_41 taxon_42 taxon_43 taxon_44 taxon_45 taxon_46 taxon_47 taxon_48 taxon_49 taxon_50 taxon_51 taxon_52 taxon_53 taxon_54 taxon_55 taxon_56 taxon_57 taxon_58 taxon_59 taxon_60 taxon_61 taxon_62 taxon_63 taxon_64 taxon_65 taxon_66 taxon_67 taxon_68 taxon_69 taxon_70 taxon_71 taxon_72 taxon_73 taxon_74 taxon_75 taxon_76 taxon_77 taxon_78 taxon_79 taxon_80 taxon_81 taxon_82 taxon_83 taxon_84 taxon_85 taxon_86 taxon_87 taxon_88 taxon_89 taxon_90 taxon_91 taxon_92 taxon_93 taxon_94 taxon_95 taxon_96 taxon_97 taxon_98 taxon_99 taxon_100 taxon_101 taxon_102 taxon_103 taxon_104 taxon_105 taxon_106 taxon_107 taxon_108 taxon_109 taxon_110 taxon_111 taxon_112 taxon_113 taxon_114 taxon_115 taxon_116 taxon_117 taxon_118 taxon_119 taxon_120 taxon_121 taxon_122 taxon_123 taxon_124 taxon_125 taxon_126 taxon_127 taxon_128 taxon_129 taxon_130 taxon_131 taxon_132 taxon_133 taxon_134 taxon_135 taxon_136 taxon_137 taxon_138 taxon_139 taxon_140 taxon_141 taxon_142 taxon_143 taxon_144 taxon_145 taxon_146 taxon_147 taxon_148 taxon_149 taxon_150 taxon_151 taxon_152 taxon_153 taxon_154 taxon_155 taxon_156 taxon_157 taxon_158 taxon_159 taxon_160 taxon_161 taxon_162 taxon_163 taxon_164 taxon_165 taxon_166 taxon_167 taxon_168 taxon_169 taxon_170 taxon_171 taxon_172 taxon_173 taxon_174 taxon_175 taxon_176 taxon_177 taxon_178 taxon_179 taxon_180 taxon_181 taxon_182 taxon_183 taxon_184 taxon_185 taxon_186 taxon_187 taxon_188 taxon_189 taxon_190 taxon_191 taxon_192 taxon_193 taxon_194 taxon_195 taxon_196 taxon_197 taxon_198 taxon_199 taxon_200 
	;
END;

BEGIN CHARACTERS;
	DIMENSIONS  NCHAR=4;
	FORMAT DATATYPE = STANDARD GAP = - MISSING = ? SYMBOLS = "  0 1";
	MATRIX
	taxon_1    1011
	taxon_2    1010
	taxon_3    1000
	taxon_4    1011
	taxon_5    1000
	taxon_6    1000
	taxon_7    1011
	taxon_8    1010
	taxon_9    1000
	taxon_10   1010
	taxon_11   1000
	taxon_12   1000
	taxon_13   1010
	taxon_14   1010
	taxon_15   1001
	taxon_16   1010
	taxon_17   1010
	taxon_18   1010
	taxon_19   1010
	taxon_20   1001
	taxon_21   1001
	taxon_22   1010
	taxon_23   1001
	taxon_24   1010
	taxon_25   1000
	taxon_26   1010
	taxon_27   1011
	taxon_28   1010
	taxon_29   1010
	taxon_30   1010
	taxon_31   1011
	taxon_32   1010
	taxon_33   1000
	taxon_34   1001
	taxon_35   1001
	taxon_36   1011
	taxon_37   1010
	taxon_38   1011
	taxon_39   1001
	taxon_40   1010
	taxon_41   1011
	taxon_42   1010
	taxon_43   1010
	taxon_44   1011
	taxon_45   1001
	taxon_46   1010
	taxon_47   1011
	taxon_48   1010
	taxon_49   1011
	taxon_50   1001
	taxon_51   1010
	taxon_52   1010
	taxon_53   1000
	taxon_54   1011
	taxon_55   1011
	taxon_56   1011
	taxon_57   1010
	taxon_58   1000
	taxon_59   1001
	taxon_60   1000
	taxon_61   1001
	taxon_62   1011
	taxon_63   1011
	taxon_64   1010
	taxon_65   1001
	taxon_66   1011
	taxon_67   1001
	taxon_68   1000
	taxon_69   1010
	taxon_70   1000
	taxon_71   1000
	taxon_72   1010
	taxon_73   1001
	taxon_74   1010
	taxon_75   1001
	taxon_76   1010
	taxon_77   1010
	taxon_78   1000
	taxon_79   1010
	taxon_80   1001
	taxon_81   1011
	taxon_82   1011
	taxon_83   1010
	taxon_84   1001
	taxon_85   1010
	taxon_86   1011
	taxon_87   1010
	taxon_88   1010
	taxon_89   1010
	taxon_90   1010
	taxon_91   1010
	taxon_92   1000
	taxon_93   1011
	taxon_94   1001
	taxon_95   1011
	taxon_96   1000
	taxon_97   1010
	taxon_98   1011
	taxon_99   1011
	taxon_100  1001
	taxon_101  1000
	taxon_102  1010
	taxon_103  1001
	taxon_104  1001
	taxon_105  1001
	taxon_106  1000
	taxon_107  1000
	taxon_108  1011
	taxon_109  1010
	taxon_110  1011
	taxon_111  1010
	taxon_112  1010
	taxon_113  1010
	taxon_114  1011
	taxon_115  1001
	taxon_116  1011
	taxon_117  1001
	taxon_118  1001
	taxon_119  1011
	taxon_120  1010
	taxon_121  1001
	taxon_122  1010
	taxon_123  1010
	taxon_124  1010
	taxon_125  1010
	taxon_126  1001
	taxon_127  1010
	taxon_128  1010
	taxon_129  1001
	taxon_130  1010
	taxon_131  1010
	taxon_132  1010
	taxon_133  1001
	taxon_134  1000
	taxon_135  1010
	taxon_136  1011
	taxon_137  1011
	taxon_138  1001
	taxon_139  1010
	taxon_140  1010
	taxon_141  1010
	taxon_142  1000
	taxon_143  1001
	taxon_144  1011
	taxon_145  1001
	taxon_146  1001
	taxon_147  1010
	taxon_148  1011
	taxon_149  1010
	taxon_150  1010
	taxon_151  1001
	taxon_152  1011
	taxon_153  1001
	taxon_154  1001
	taxon_155  1011
	taxon_156  1000
	taxon_157  1010
	taxon_158  1011
	taxon_159  1000
	taxon_160  1010
	taxon_161  1010
	taxon_162  1010
	taxon_163  1011
	taxon_164  1000
	taxon_165  1011
	taxon_166  1010
	taxon_167  1011
	taxon_168  1010
	taxon_169  1000
	taxon_170  1011
	taxon_171  1011
	taxon_172  1011
	taxon_173  1001
	taxon_174  1001
	taxon_175  1000
	taxon_176  1001
	taxon_177  1000
	taxon_178  1010
	taxon_179  1010
	taxon_180  1000
	taxon_181  1010
	taxon_182  1010
	taxon_183  1010
	taxon_184  1010
	taxon_185  1001
	taxon_186  1010
	taxon_187  1010
	taxon_188  1011
	taxon_189  1011
	taxon_190  1000
	taxon_191  1010
	taxon_192  1011
	taxon_193  1000
	taxon_194  1010
	taxon_195  1000
	taxon_196  1010
	taxon_197  1000
	taxon_198  1000
	taxon_199  1010
	taxon_200  1000
;
END;

BEGIN TREES;
	TRANSLATE
		1 taxon_1,
		2 taxon_2,
		3 taxon_3,
		4 taxon_4,
		5 taxon_5,
		6 taxon_6,
		7 taxon_7,
		8 taxon_8,
		9 taxon_9,
		10 taxon_10,
		11 taxon_11,
		12 taxon_12,
		13 taxon_13,
		14 taxon_14,
		15 taxon_15,
		16 taxon_16,
		17 taxon_17,
		18 taxon_18,
		19 taxon_19,
		20 taxon_20,
		21 taxon_21,
		22 taxon_22,
		23 taxon_23,
		24 taxon_24,
		25 taxon_25,
		26 taxon_26,
		27 taxon_27,
		28 taxon_28,
		29 taxon_29,
		30 taxon_30,
		31 taxon_31,
		32 taxon_32,
		33 taxon_33,
		34 taxon_34,
		35 taxon_35,
		36 taxon_36,
		37 taxon_37,
		38 taxon_38,
		39 taxon_39,
		40 taxon_40,
		41 taxon_41,
		42 taxon_42,
		43 taxon_43,
		44 taxon_44,
		45 taxon_45,
		46 taxon_46,
		47 taxon_47,
		48 taxon_48,
		49 taxon_49,
		50 taxon_50,
		51 taxon_51,
		52 taxon_52,
		53 taxon_53,
		54 taxon_54,
		55 taxon_55,
		56 taxon_56,
		57 taxon_57,
		58 taxon_58,
		59 taxon_59,
		60 taxon_60,
		61 taxon_61,
		62 taxon_62,
		63 taxon_63,
		64 taxon_64,
		65 taxon_65,
		66 taxon_66,
		67 taxon_67,
		68 taxon_68,
		69 taxon_69,
		70 taxon_70,
		71 taxon_71,
		72 taxon_72,
		73 taxon_73,
		74 taxon_74,
		75 taxon_75,
		76 taxon_76,
		77 taxon_77,
		78 taxon_78,
		79 taxon_79,
		80 taxon_80,
		81 taxon_81,
		82 taxon_82,
		83 taxon_83,
		84 taxon_84,
		85 taxon_85,
		86 taxon_86,
		87 taxon_87,
		88 taxon_88,
		89 taxon_89,
		90 taxon_90,
		91 taxon_91,
		92 taxon_92,
		93 taxon_93,
		94 taxon_94,
		95 taxon_95,
		96 taxon_96,
		97 taxon_97,
		98 taxon_98,
		99 taxon_99,
		100 taxon_100,
		101 taxon_101,
		102 taxon_102,
		103 taxon_103,
		104 taxon_104,
		105 taxon_105,
		106 taxon_106,
		107 taxon_107,
		108 taxon_108,
		109 taxon_109,
		110 taxon_110,
		111 taxon_111,
		112 taxon_112,
		113 taxon_113,
		114 taxon_114,
		115 taxon_115,
		116 taxon_116,
		117 taxon_117,
		118 taxon_118,
		119 taxon_119,
		120 taxon_120,
		121 taxon_121,
		122 taxon_122,
		123 taxon_123,
		124 taxon_124,
		125 taxon_125,
		126 taxon_126,
		127 taxon_127,
		128 taxon_128,
		129 taxon_129,
		130 taxon_130,
		131 taxon_131,
		132 taxon_132,
		133 taxon_133,
		134 taxon_134,
		135 taxon_135,
		136 taxon_136,
		137 taxon_137,
		138 taxon_138,
		139 taxon_139,
		140 taxon_140,
		141 taxon_141,
		142 taxon_142,
		143 taxon_143,
		144 taxon_144,
		145 taxon_145,
		146 taxon_146,
		147 taxon_147,
		148 taxon_148,
		149 taxon_149,
		150 taxon_150,
		151 taxon_151,
		152 taxon_152,
		153 taxon_153,
		154 taxon_154,
		155 taxon_155,
		156 taxon_156,
		157 taxon_157,
		158 taxon_158,
		159 taxon_159,
		160 taxon_160,
		161 taxon_161,
		162 taxon_162,
		163 taxon_163,
		164 taxon_164,
		165 taxon_165,
		166 taxon_166,
		167 taxon_167,
		168 taxon_168,
		169 taxon_169,
		170 taxon_170,
		171 taxon_171,
		172 taxon_172,
		173 taxon_173,
		174 taxon_174,
		175 taxon_175,
		176 taxon_176,
		177 taxon_177,
		178 taxon_178,
		179 taxon_179,
		180 taxon_180,
		181 taxon_181,
		182 taxon_182,
		183 taxon_183,
		184 taxon_184,
		185 taxon_185,
		186 taxon_186,
		187 taxon_187,
		188 taxon_188,
		189 taxon_189,
		190 taxon_190,
		191 taxon_191,
		192 taxon_192,
		193 taxon_193,
		194 taxon_194,
		195 taxon_195,
		196 taxon_196,
		197 taxon_197,
		198 taxon_198,
		199 taxon_199,
		200 taxon_200;
	TREE tree1 = (((((((((154:1.9645341469111588,(105:1.7825166216887833,((((186:0.11793326922845607,26:0.11793326922845607):0.11833830984985658,197:0.23627157907830676):0.13952709481491624,12:0.3757986738932172):0.77947040307379,166:1.1552690769669895):0.6272475447218576):0.1820175252224267):1.4167356252871892,(92:2.1668343428597225,14:2.1668343428597083):1.2144354293384705):1.8199157409475233,(139:1.8977485258813975,69:1.8977485258815139):3.303436987264487):6.5883501682648244,((195:9.18711368323075,(127:0.43784865164014336,64:0.43784865164014336):8.749265031588743):1.9928943887814592,((17:2.961122593015628,((110:0.8478455305149859,114:0.8478455305149859):1.696828517343898,(82:0.3043490931602493,189:0.3043490931602493):2.2403249546982957):0.416448545156827):7.788900249740833,(((((((28:0.22118192077997584,150:0.22118192077997584):1.065798057204082,(52:0.6428361380486255,199:0.6428361380486255):0.644143839935366):2.6647601251992863,((184:0.21246956895816738,147:0.21246956895816738):1.0646934284944434,140:1.2771629974525829):2.674577105730743):0.9070527489752008,(137:2.4277544055649454,47:2.4277544055649454):2.431038446593087):0.17860399469969782,(62:2.7520364171712317,(170:1.6691746808597088,188:1.6691746808598094):1.082861736311524):2.2853604296862966):0.4173735767450357,(128:2.966440098642566,(2:1.89574630126043,178:1.8957463012602218):1.0706937973824044):2.488330324959897):3.23594053107369,(((((88:0.22985765283655044,85:0.22985765283655044):1.3131059505279472,((163:1.3638360362868127,(108:0.6541681705657849,86:0.6541681705657849):0.7096678657209374):0.007376826625930712,(152:1.155899811192862,66:1.155899811192862):0.21531305171976522):0.1717507404517737):0.04901290870391778,(109:1.0169949055073937,(193:0.4217750537059745,43:0.4217750537059745):0.5952198518014086):0.5749816065609558):3.233849931836774,(11:3.1296185634819977,(190:0.995479245516155,90:0.995479245516155):2.1341393179659054):1.6962078804232632):0.8193111330966636,(133:3.5253717574346926,(((153:0.5111272327099486,171:0.5111272327099486):0.04077036962993775,148:0.5518976023399099):2.381992854375179,(100:0.07203726181271317,116:0.07203726181271317):2.8618531949022388):0.5914813007193415):2.1197658195674243):3.045573377674739):2.059311888080876):0.4299852292557059):0.6095276093973201):0.9339908900834976,(198:10.060046954290108,(58:2.6498768228712875,(76:0.8174596712153781,157:0.8174596712153781):1.8324171516563377):7.410170131422013):2.663479617201018):0.689375682922527,(((((((122:0.3152599990647281,79:0.3152599990647281):2.064811402682365,(87:0.21751554499974296,135:0.21751554499974296):2.162555856747254):0.14314137587000622,160:2.5232127776168194):0.5282038959673396,131:3.0514166735845447):1.7388325315219673,187:4.790249205107044):2.662614565763091,((115:1.834955909004572,(80:0.3962125638742345,118:0.3962125638742345):1.4387433451302636):3.6508749466540955,(67:2.002865778379344,(65:0.7602314251248226,185:0.7602314251248226):1.2426343532544937):3.482965077279135):1.9670329152113029):5.1418418582101335,(((((((168:0.05604517190325908,22:0.05604517190325908):2.9354464957268127,(95:1.642785195749667,(44:7.088812050083358E-5,55:7.088812050083358E-5):1.6427143076291661):1.3487064718805222):1.8424534115761606,117:4.8339450792063205):2.3830762053329777,49:7.217021284540247):0.1008720863833236,138:7.31789337092344):1.1197211641649552,((40:6.61044522155018,63:6.610445221550276):0.4824369561976485,((((151:1.1989563092234519,38:1.1989563092234519):0.23299898534538874,145:1.431955294568928):3.291752069193739,136:4.723707363763226):0.34278053091947364,(111:2.0750630959549703,((134:1.3204218939030605,181:1.3204218939030605):0.3176776515921742,50:1.6380995454952296):0.43696355046005436):2.9914247987267837):2.026394283064775):1.3447323573407624):2.315012431815084,(45:2.579915005750993,(120:0.5020001227646262,(182:0.46792462332023826,72:0.46792462332023826):0.03407549944438602):2.0779148829867085):8.172711961150458):1.8420786621770613):0.8181966253367361):1.5838854225777723,((((20:4.865349100001558,104:4.865349100001701):0.4169932987104196,(25:3.119797079370673,(35:1.6574243899921317,((126:0.7480456270293846,59:0.7480456270293846):0.14290978860773362,121:0.8909554156371757):0.7664689743548619):1.4623726893785156):2.1625453193416027):0.7157668073276346,68:5.998109206039297):5.985026745165796,((((112:0.07290347589337817,51:0.07290347589337817):6.432640498854958,((144:2.1467797343172803,(93:0.485019091293908,123:0.485019091293908):1.661760643023313):3.8250301941823253,((5:3.1265635608932247,71:3.1265635608931963):2.387583547064542,((6:0.9679256468674469,180:0.9679256468674469):0.9310464000895832,9:1.8989720469569857):3.6151750610002136):0.4576628205424307):0.5337340462475177):0.6399536755266454,(77:1.143719663962236,46:1.143719663962236):6.001777986312412):3.6199935280472797,((96:0.48402762796062226,(175:0.07304838097891841,159:0.07304838097891841):0.41097924698171534):1.9705067345366243,(73:0.8238630346168687,34:0.8238630346168687):1.6306713278805063):8.310956815824184):1.2176447728841466):3.013651725788953):6.676488257333351,((((194:1.272745030780066,13:1.2727450307800976):2.6935645092922473,42:3.9663095400723414):9.79233049080787,(((8:1.8110870336167402,(24:0.636335790166028,(10:0.06599935298086543,124:0.06599935298086543):0.5703364371851415):1.1747512434505887):1.5639509926540682,130:3.3750380262711532):0.7167207639331066,(132:1.5276641095273653,37:1.5276641095273653):2.5640946806764804):9.66688124067752):0.3140418625956975,(((141:4.705978092171089,((27:0.36015810882870986,172:0.36015810882870986):2.61259580934044,(((31:0.0694457379014439,158:0.0694457379014439):1.0744308195258905,196:1.1438765574273668):1.3139174652723338,(16:0.47178680393513905,78:0.47178680393513905):1.9860072187645315):0.5149598954693705):1.733224174001237):2.1795064491333314,(39:2.2895298622528246,146:2.2895298622528033):4.595954679051988):5.9379364629699385,(((81:0.9097530169509125,36:0.9097530169509125):1.0909197770915133,30:2.0006727940423796):8.087090639216733,((75:3.73619063062427,((119:0.025891149912737634,1:0.025891149912737634):0.35325255382321885,61:0.37914370373595535):3.3570469268883922):3.282565246613338,(((101:0.7623272663860753,113:0.7623272663860753):3.519997261228012,((((106:0.3426853110217119,107:0.3426853110217119):0.44364003648680767,(33:0.07812690640142309,177:0.07812690640142309):0.7081984411070756):0.9160077284887255,70:1.7023330759973208):2.351365580508581,53:4.053698656506318):0.22862587110774388):1.4927775063341273,((94:1.4593620857002465,103:1.4593620857002465):0.795206342538562,(167:1.7891243050105154,(155:0.14601247483846183,99:0.14601247483846183):1.6431118301720848):0.465444123228179):3.5205336057094594):1.2436538432887625):3.069007556023043):2.735657571014102):1.2492608892034038):7.600594040849868):0.9912423868800057,(((((162:1.7115128321703006,161:1.7115128321703006):3.485874134974147,89:5.197386967144836):2.0244495879555866,((191:2.3703101287136623,125:2.3703101287136623):1.1070464456475322,(57:0.42604759576715323,(97:0.1894956380505827,83:0.1894956380505827):0.23655195771655896):3.0513089785947707):3.744479980739622):4.195122355597924,((((18:3.497774639813275,(179:3.4184439052003155,74:3.418443905200502):0.07933073461283496):3.141257898696118,((48:4.294370978983364,19:4.294370978983371):0.37553896513149754,(102:4.256247979195993,149:4.256247979194976):0.41366196491922513):1.9691225943940047):2.0631717299685963,((3:0.01928174756117772,200:0.01928174756117772):0.27047585964823434,(60:0.0496878461301411,164:0.0496878461301411):0.24006976107927366):8.41244666126756):1.9732905590625096,183:10.675494827537177):0.7414640831574792):3.48625141602731,((((56:2.6592202408741024,((174:0.6111069617989798,143:0.6111069617989798):0.2321028473077748,21:0.8432098091067121):1.8160104317678072):6.143565965620891,(((((15:0.26745102708918256,176:0.26745102708918256):3.2424067595453967,165:3.5098577866345093):1.5802031846842368,(((192:1.5562727711675617,41:1.5562727711675617):0.7801068244593741,(169:0.4997019228492188,156:0.4997019228492188):1.8366776727775571):2.275679914124065,((29:4.036611032896095,142:4.0366110328961495):0.03511319680585529,173:4.071724229701867):0.5403352800492953):0.4780014615673249):0.7744936665445558,98:5.864554637863146):1.9918916431608087,((32:0.10169463174591431,91:0.10169463174591431):4.425481347806992,(7:4.007626958065582,54:4.00762695806564):0.5195490214871693):3.329270301471796):0.9463399254728428):0.7968199738734586,4:9.599606180365301):2.337013747967151,((129:0.17763893948208886,23:0.17763893948208886):0.9534919951643376,84:1.1311309346463971):10.80548899368963):2.966590398388003):7.761307994482627):0.0;
END;
