/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
 *    2008 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/opcode.pl from its data.
 * Any changes made here will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADSV_STORE	 = 10,
	OP_PADAV	 = 11,
	OP_PADHV	 = 12,
	OP_PADANY	 = 13,
	OP_RV2GV	 = 14,
	OP_RV2SV	 = 15,
	OP_AV2ARYLEN	 = 16,
	OP_RV2CV	 = 17,
	OP_ANONCODE	 = 18,
	OP_PROTOTYPE	 = 19,
	OP_REFGEN	 = 20,
	OP_SREFGEN	 = 21,
	OP_REF		 = 22,
	OP_BLESS	 = 23,
	OP_BACKTICK	 = 24,
	OP_GLOB		 = 25,
	OP_READLINE	 = 26,
	OP_RCATLINE	 = 27,
	OP_REGCMAYBE	 = 28,
	OP_REGCRESET	 = 29,
	OP_REGCOMP	 = 30,
	OP_MATCH	 = 31,
	OP_QR		 = 32,
	OP_SUBST	 = 33,
	OP_SUBSTCONT	 = 34,
	OP_TRANS	 = 35,
	OP_TRANSR	 = 36,
	OP_SASSIGN	 = 37,
	OP_AASSIGN	 = 38,
	OP_CHOP		 = 39,
	OP_SCHOP	 = 40,
	OP_CHOMP	 = 41,
	OP_SCHOMP	 = 42,
	OP_DEFINED	 = 43,
	OP_UNDEF	 = 44,
	OP_STUDY	 = 45,
	OP_POS		 = 46,
	OP_PREINC	 = 47,
	OP_I_PREINC	 = 48,
	OP_PREDEC	 = 49,
	OP_I_PREDEC	 = 50,
	OP_POSTINC	 = 51,
	OP_I_POSTINC	 = 52,
	OP_POSTDEC	 = 53,
	OP_I_POSTDEC	 = 54,
	OP_POW		 = 55,
	OP_MULTIPLY	 = 56,
	OP_I_MULTIPLY	 = 57,
	OP_DIVIDE	 = 58,
	OP_I_DIVIDE	 = 59,
	OP_MODULO	 = 60,
	OP_I_MODULO	 = 61,
	OP_REPEAT	 = 62,
	OP_ADD		 = 63,
	OP_I_ADD	 = 64,
	OP_SUBTRACT	 = 65,
	OP_I_SUBTRACT	 = 66,
	OP_CONCAT	 = 67,
	OP_MULTICONCAT	 = 68,
	OP_STRINGIFY	 = 69,
	OP_LEFT_SHIFT	 = 70,
	OP_RIGHT_SHIFT	 = 71,
	OP_LT		 = 72,
	OP_I_LT		 = 73,
	OP_GT		 = 74,
	OP_I_GT		 = 75,
	OP_LE		 = 76,
	OP_I_LE		 = 77,
	OP_GE		 = 78,
	OP_I_GE		 = 79,
	OP_EQ		 = 80,
	OP_I_EQ		 = 81,
	OP_NE		 = 82,
	OP_I_NE		 = 83,
	OP_NCMP		 = 84,
	OP_I_NCMP	 = 85,
	OP_SLT		 = 86,
	OP_SGT		 = 87,
	OP_SLE		 = 88,
	OP_SGE		 = 89,
	OP_SEQ		 = 90,
	OP_SNE		 = 91,
	OP_SCMP		 = 92,
	OP_BIT_AND	 = 93,
	OP_BIT_XOR	 = 94,
	OP_BIT_OR	 = 95,
	OP_NBIT_AND	 = 96,
	OP_NBIT_XOR	 = 97,
	OP_NBIT_OR	 = 98,
	OP_SBIT_AND	 = 99,
	OP_SBIT_XOR	 = 100,
	OP_SBIT_OR	 = 101,
	OP_NEGATE	 = 102,
	OP_I_NEGATE	 = 103,
	OP_NOT		 = 104,
	OP_COMPLEMENT	 = 105,
	OP_NCOMPLEMENT	 = 106,
	OP_SCOMPLEMENT	 = 107,
	OP_SMARTMATCH	 = 108,
	OP_ATAN2	 = 109,
	OP_SIN		 = 110,
	OP_COS		 = 111,
	OP_RAND		 = 112,
	OP_SRAND	 = 113,
	OP_EXP		 = 114,
	OP_LOG		 = 115,
	OP_SQRT		 = 116,
	OP_INT		 = 117,
	OP_HEX		 = 118,
	OP_OCT		 = 119,
	OP_ABS		 = 120,
	OP_LENGTH	 = 121,
	OP_SUBSTR	 = 122,
	OP_VEC		 = 123,
	OP_INDEX	 = 124,
	OP_RINDEX	 = 125,
	OP_SPRINTF	 = 126,
	OP_FORMLINE	 = 127,
	OP_ORD		 = 128,
	OP_CHR		 = 129,
	OP_CRYPT	 = 130,
	OP_UCFIRST	 = 131,
	OP_LCFIRST	 = 132,
	OP_UC		 = 133,
	OP_LC		 = 134,
	OP_QUOTEMETA	 = 135,
	OP_RV2AV	 = 136,
	OP_AELEMFAST	 = 137,
	OP_AELEMFAST_LEX = 138,
	OP_AELEMFASTLEX_STORE = 139,
	OP_AELEM	 = 140,
	OP_ASLICE	 = 141,
	OP_KVASLICE	 = 142,
	OP_AEACH	 = 143,
	OP_AVALUES	 = 144,
	OP_AKEYS	 = 145,
	OP_EACH		 = 146,
	OP_VALUES	 = 147,
	OP_KEYS		 = 148,
	OP_DELETE	 = 149,
	OP_EXISTS	 = 150,
	OP_RV2HV	 = 151,
	OP_HELEM	 = 152,
	OP_HSLICE	 = 153,
	OP_KVHSLICE	 = 154,
	OP_MULTIDEREF	 = 155,
	OP_UNPACK	 = 156,
	OP_PACK		 = 157,
	OP_SPLIT	 = 158,
	OP_JOIN		 = 159,
	OP_LIST		 = 160,
	OP_LSLICE	 = 161,
	OP_ANONLIST	 = 162,
	OP_ANONHASH	 = 163,
	OP_SPLICE	 = 164,
	OP_PUSH		 = 165,
	OP_POP		 = 166,
	OP_SHIFT	 = 167,
	OP_UNSHIFT	 = 168,
	OP_SORT		 = 169,
	OP_REVERSE	 = 170,
	OP_GREPSTART	 = 171,
	OP_GREPWHILE	 = 172,
	OP_MAPSTART	 = 173,
	OP_MAPWHILE	 = 174,
	OP_RANGE	 = 175,
	OP_FLIP		 = 176,
	OP_FLOP		 = 177,
	OP_AND		 = 178,
	OP_OR		 = 179,
	OP_XOR		 = 180,
	OP_DOR		 = 181,
	OP_COND_EXPR	 = 182,
	OP_ANDASSIGN	 = 183,
	OP_ORASSIGN	 = 184,
	OP_DORASSIGN	 = 185,
	OP_ENTERSUB	 = 186,
	OP_LEAVESUB	 = 187,
	OP_LEAVESUBLV	 = 188,
	OP_ARGCHECK	 = 189,
	OP_ARGELEM	 = 190,
	OP_ARGDEFELEM	 = 191,
	OP_CALLER	 = 192,
	OP_WARN		 = 193,
	OP_DIE		 = 194,
	OP_RESET	 = 195,
	OP_LINESEQ	 = 196,
	OP_NEXTSTATE	 = 197,
	OP_DBSTATE	 = 198,
	OP_UNSTACK	 = 199,
	OP_ENTER	 = 200,
	OP_LEAVE	 = 201,
	OP_SCOPE	 = 202,
	OP_ENTERITER	 = 203,
	OP_ITER		 = 204,
	OP_ENTERLOOP	 = 205,
	OP_LEAVELOOP	 = 206,
	OP_RETURN	 = 207,
	OP_LAST		 = 208,
	OP_NEXT		 = 209,
	OP_REDO		 = 210,
	OP_DUMP		 = 211,
	OP_GOTO		 = 212,
	OP_EXIT		 = 213,
	OP_METHOD	 = 214,
	OP_METHOD_NAMED	 = 215,
	OP_METHOD_SUPER	 = 216,
	OP_METHOD_REDIR	 = 217,
	OP_METHOD_REDIR_SUPER = 218,
	OP_ENTERGIVEN	 = 219,
	OP_LEAVEGIVEN	 = 220,
	OP_ENTERWHEN	 = 221,
	OP_LEAVEWHEN	 = 222,
	OP_BREAK	 = 223,
	OP_CONTINUE	 = 224,
	OP_OPEN		 = 225,
	OP_CLOSE	 = 226,
	OP_PIPE_OP	 = 227,
	OP_FILENO	 = 228,
	OP_UMASK	 = 229,
	OP_BINMODE	 = 230,
	OP_TIE		 = 231,
	OP_UNTIE	 = 232,
	OP_TIED		 = 233,
	OP_DBMOPEN	 = 234,
	OP_DBMCLOSE	 = 235,
	OP_SSELECT	 = 236,
	OP_SELECT	 = 237,
	OP_GETC		 = 238,
	OP_READ		 = 239,
	OP_ENTERWRITE	 = 240,
	OP_LEAVEWRITE	 = 241,
	OP_PRTF		 = 242,
	OP_PRINT	 = 243,
	OP_SAY		 = 244,
	OP_SYSOPEN	 = 245,
	OP_SYSSEEK	 = 246,
	OP_SYSREAD	 = 247,
	OP_SYSWRITE	 = 248,
	OP_EOF		 = 249,
	OP_TELL		 = 250,
	OP_SEEK		 = 251,
	OP_TRUNCATE	 = 252,
	OP_FCNTL	 = 253,
	OP_IOCTL	 = 254,
	OP_FLOCK	 = 255,
	OP_SEND		 = 256,
	OP_RECV		 = 257,
	OP_SOCKET	 = 258,
	OP_SOCKPAIR	 = 259,
	OP_BIND		 = 260,
	OP_CONNECT	 = 261,
	OP_LISTEN	 = 262,
	OP_ACCEPT	 = 263,
	OP_SHUTDOWN	 = 264,
	OP_GSOCKOPT	 = 265,
	OP_SSOCKOPT	 = 266,
	OP_GETSOCKNAME	 = 267,
	OP_GETPEERNAME	 = 268,
	OP_LSTAT	 = 269,
	OP_STAT		 = 270,
	OP_FTRREAD	 = 271,
	OP_FTRWRITE	 = 272,
	OP_FTREXEC	 = 273,
	OP_FTEREAD	 = 274,
	OP_FTEWRITE	 = 275,
	OP_FTEEXEC	 = 276,
	OP_FTIS		 = 277,
	OP_FTSIZE	 = 278,
	OP_FTMTIME	 = 279,
	OP_FTATIME	 = 280,
	OP_FTCTIME	 = 281,
	OP_FTROWNED	 = 282,
	OP_FTEOWNED	 = 283,
	OP_FTZERO	 = 284,
	OP_FTSOCK	 = 285,
	OP_FTCHR	 = 286,
	OP_FTBLK	 = 287,
	OP_FTFILE	 = 288,
	OP_FTDIR	 = 289,
	OP_FTPIPE	 = 290,
	OP_FTSUID	 = 291,
	OP_FTSGID	 = 292,
	OP_FTSVTX	 = 293,
	OP_FTLINK	 = 294,
	OP_FTTTY	 = 295,
	OP_FTTEXT	 = 296,
	OP_FTBINARY	 = 297,
	OP_CHDIR	 = 298,
	OP_CHOWN	 = 299,
	OP_CHROOT	 = 300,
	OP_UNLINK	 = 301,
	OP_CHMOD	 = 302,
	OP_UTIME	 = 303,
	OP_RENAME	 = 304,
	OP_LINK		 = 305,
	OP_SYMLINK	 = 306,
	OP_READLINK	 = 307,
	OP_MKDIR	 = 308,
	OP_RMDIR	 = 309,
	OP_OPEN_DIR	 = 310,
	OP_READDIR	 = 311,
	OP_TELLDIR	 = 312,
	OP_SEEKDIR	 = 313,
	OP_REWINDDIR	 = 314,
	OP_CLOSEDIR	 = 315,
	OP_FORK		 = 316,
	OP_WAIT		 = 317,
	OP_WAITPID	 = 318,
	OP_SYSTEM	 = 319,
	OP_EXEC		 = 320,
	OP_KILL		 = 321,
	OP_GETPPID	 = 322,
	OP_GETPGRP	 = 323,
	OP_SETPGRP	 = 324,
	OP_GETPRIORITY	 = 325,
	OP_SETPRIORITY	 = 326,
	OP_TIME		 = 327,
	OP_TMS		 = 328,
	OP_LOCALTIME	 = 329,
	OP_GMTIME	 = 330,
	OP_ALARM	 = 331,
	OP_SLEEP	 = 332,
	OP_SHMGET	 = 333,
	OP_SHMCTL	 = 334,
	OP_SHMREAD	 = 335,
	OP_SHMWRITE	 = 336,
	OP_MSGGET	 = 337,
	OP_MSGCTL	 = 338,
	OP_MSGSND	 = 339,
	OP_MSGRCV	 = 340,
	OP_SEMOP	 = 341,
	OP_SEMGET	 = 342,
	OP_SEMCTL	 = 343,
	OP_REQUIRE	 = 344,
	OP_DOFILE	 = 345,
	OP_HINTSEVAL	 = 346,
	OP_ENTEREVAL	 = 347,
	OP_LEAVEEVAL	 = 348,
	OP_ENTERTRY	 = 349,
	OP_LEAVETRY	 = 350,
	OP_GHBYNAME	 = 351,
	OP_GHBYADDR	 = 352,
	OP_GHOSTENT	 = 353,
	OP_GNBYNAME	 = 354,
	OP_GNBYADDR	 = 355,
	OP_GNETENT	 = 356,
	OP_GPBYNAME	 = 357,
	OP_GPBYNUMBER	 = 358,
	OP_GPROTOENT	 = 359,
	OP_GSBYNAME	 = 360,
	OP_GSBYPORT	 = 361,
	OP_GSERVENT	 = 362,
	OP_SHOSTENT	 = 363,
	OP_SNETENT	 = 364,
	OP_SPROTOENT	 = 365,
	OP_SSERVENT	 = 366,
	OP_EHOSTENT	 = 367,
	OP_ENETENT	 = 368,
	OP_EPROTOENT	 = 369,
	OP_ESERVENT	 = 370,
	OP_GPWNAM	 = 371,
	OP_GPWUID	 = 372,
	OP_GPWENT	 = 373,
	OP_SPWENT	 = 374,
	OP_EPWENT	 = 375,
	OP_GGRNAM	 = 376,
	OP_GGRGID	 = 377,
	OP_GGRENT	 = 378,
	OP_SGRENT	 = 379,
	OP_EGRENT	 = 380,
	OP_GETLOGIN	 = 381,
	OP_SYSCALL	 = 382,
	OP_LOCK		 = 383,
	OP_ONCE		 = 384,
	OP_CUSTOM	 = 385,
	OP_COREARGS	 = 386,
	OP_AVHVSWITCH	 = 387,
	OP_RUNCV	 = 388,
	OP_FC		 = 389,
	OP_PADCV	 = 390,
	OP_INTROCV	 = 391,
	OP_CLONECV	 = 392,
	OP_PADRANGE	 = 393,
	OP_REFASSIGN	 = 394,
	OP_LVREF	 = 395,
	OP_LVREFSLICE	 = 396,
	OP_LVAVREF	 = 397,
	OP_ANONCONST	 = 398,
	OP_ISA		 = 399,
	OP_CMPCHAIN_AND	 = 400,
	OP_CMPCHAIN_DUP	 = 401,
	OP_ENTERTRYCATCH = 402,
	OP_LEAVETRYCATCH = 403,
	OP_POPTRY	 = 404,
	OP_CATCH	 = 405,
	OP_PUSHDEFER	 = 406,
	OP_IS_BOOL	 = 407,
	OP_IS_WEAK	 = 408,
	OP_WEAKEN	 = 409,
	OP_UNWEAKEN	 = 410,
	OP_BLESSED	 = 411,
	OP_REFADDR	 = 412,
	OP_REFTYPE	 = 413,
	OP_CEIL		 = 414,
	OP_FLOOR	 = 415,
	OP_IS_TAINTED	 = 416,
	OP_max		
} opcode;

#define MAXO 417
#define OP_FREED MAXO

/* the OP_IS_* macros are optimized to a simple range check because
    all the member OPs are contiguous in regen/opcodes table.
    opcode.pl verifies the range contiguity, or generates an OR-equals
    expression */

#define OP_IS_SOCKET(op)	\
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

#define OP_IS_NUMCOMPARE(op)	\
	((op) >= OP_LT && (op) <= OP_I_NCMP)

#define OP_IS_DIRHOP(op)	\
	((op) >= OP_READDIR && (op) <= OP_CLOSEDIR)

#define OP_IS_INFIX_BIT(op)	\
	((op) >= OP_BIT_AND && (op) <= OP_SBIT_OR)

/* ex: set ro: */
