# Generated by default/object.tt
package Paws::Shield::AttackVolume;
  use Moose;
  has BitsPerSecond => (is => 'ro', isa => 'Paws::Shield::AttackVolumeStatistics');
  has PacketsPerSecond => (is => 'ro', isa => 'Paws::Shield::AttackVolumeStatistics');
  has RequestsPerSecond => (is => 'ro', isa => 'Paws::Shield::AttackVolumeStatistics');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Shield::AttackVolume

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Shield::AttackVolume object:

  $service_obj->Method(Att1 => { BitsPerSecond => $value, ..., RequestsPerSecond => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Shield::AttackVolume object:

  $result = $service_obj->Method(...);
  $result->Att1->BitsPerSecond

=head1 DESCRIPTION

Information about the volume of attacks during the time period,
included in an AttackStatisticsDataItem. If the accompanying
C<AttackCount> in the statistics object is zero, this setting might be
empty.

=head1 ATTRIBUTES


=head2 BitsPerSecond => L<Paws::Shield::AttackVolumeStatistics>

A statistics object that uses bits per second as the unit. This is
included for network level attacks.


=head2 PacketsPerSecond => L<Paws::Shield::AttackVolumeStatistics>

A statistics object that uses packets per second as the unit. This is
included for network level attacks.


=head2 RequestsPerSecond => L<Paws::Shield::AttackVolumeStatistics>

A statistics object that uses requests per second as the unit. This is
included for application level attacks, and is only available for
accounts that are subscribed to Shield Advanced.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Shield>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

