#!/usr/bin/env python3

"""usage: ./gen-arabic-pua.py
"""

import packTab


print ("/* == Start of generated table == */")
print ("/*")
print (" * The following table is generated by running:")
print (" *")
print (" *   ./gen-arabic-pua.py")
print (" *")
print (" */")
print ()
print ("#ifndef HB_OT_SHAPER_ARABIC_PUA_HH")
print ("#define HB_OT_SHAPER_ARABIC_PUA_HH")
print ()

code = packTab.Code('_hb_arabic')

for p in ("ArabicPUASimplified.txt", "ArabicPUATraditional.txt"):
    with open (p, encoding='utf-8') as f:
        fields = [l.split('\t') for l in f if l[:1] != '#']
    data = {int(fs[1], 16):int(fs[0], 16) for fs in fields}
    sol = packTab.pack_table(data, compression=9)
    sol.genCode(code, f'pua_{p[9:13].lower()}_map')

code.print_c(linkage='static inline')

print ()
print ("#endif /* HB_OT_SHAPER_ARABIC_PUA_HH */")
print ()
print ("/* == End of generated table == */")
