#!/usr/bin/perl

package eBay::API::XML::DataType::DisputeFilterCountType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DisputeFilterCountType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::DisputeFilterCountType

=head1 DESCRIPTION

The number of disputes that match a given filter.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::DisputeFilterCountType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::DisputeFilterTypeCodeType;


my @gaProperties = ( [ 'DisputeFilterType', 'ns:DisputeFilterTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DisputeFilterTypeCodeType', '' ]
	, [ 'TotalAvailable', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDisputeFilterType()

A filter used to reduce the number of disputes returned. The filter uses criteria
such as whether the dispute is awaiting a response, is closed, or is eligible for
credit. Both Unpaid Item and Item Not Received disputes can be returned for the
same filter value.

#    Argument: 'ns:DisputeFilterTypeCodeType'

=cut

sub setDisputeFilterType {
  my $self = shift;
  $self->{'DisputeFilterType'} = shift
}

=head2 getDisputeFilterType()

  Calls: GetUserDisputes
  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none

#    Returns: 'ns:DisputeFilterTypeCodeType'

=cut

sub getDisputeFilterType {
  my $self = shift;
  return $self->{'DisputeFilterType'};
}


=head2 setTotalAvailable()

The number of disputes that match the filter.
In the GetUserDisputes response, not returned for the filter type
that was used in the request.

#    Argument: 'xs:int'

=cut

sub setTotalAvailable {
  my $self = shift;
  $self->{'TotalAvailable'} = shift
}

=head2 getTotalAvailable()

  Calls: GetUserDisputes
  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none

#    Returns: 'xs:int'

=cut

sub getTotalAvailable {
  my $self = shift;
  return $self->{'TotalAvailable'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
